/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.timingdiagram.command;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.timingdiagram.Player;
import net.sourceforge.plantuml.timingdiagram.TimingDiagram;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandAtPlayer
extends SingleLineCommand2<TimingDiagram> {
    public CommandAtPlayer() {
        super(CommandAtPlayer.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandAtPlayer.class.getName(), RegexLeaf.start(), new RegexLeaf("@"), new RegexLeaf("PLAYER", "([\\p{L}_][%pLN_.]*)"), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }

    @Override
    protected final CommandExecutionResult executeArg(TimingDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) {
        String code = arg.get("PLAYER", 0);
        Player player = diagram.getPlayer(code);
        if (player == null) {
            return CommandExecutionResult.error("No such participant " + code);
        }
        diagram.setLastPlayer(player);
        return CommandExecutionResult.ok();
    }
}

