/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.RectangleArea;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.svek.PackageStyle;

public class ClusterDecoration {
    private final UStroke defaultStroke;
    private final USymbol symbol;
    private final TextBlock title;
    private final TextBlock stereo;
    private final RectangleArea rectangleArea;

    public ClusterDecoration(PackageStyle style, USymbol symbol, TextBlock title, TextBlock stereo, RectangleArea rectangleArea, UStroke stroke) {
        this.symbol = ClusterDecoration.guess(symbol, style);
        this.stereo = stereo;
        this.title = title;
        this.rectangleArea = rectangleArea;
        this.defaultStroke = stroke;
    }

    private static USymbol guess(USymbol symbol, PackageStyle style) {
        if (symbol != null) {
            return symbol;
        }
        return style.toUSymbol();
    }

    public void drawU(UGraphic ug, HColor backColor, HColor borderColor, double shadowing, double roundCorner, HorizontalAlignment titleAlignment, HorizontalAlignment stereoAlignment, double diagonalCorner) {
        TextBlock asBig = this.getTextBlock(backColor, borderColor, shadowing, roundCorner, titleAlignment, stereoAlignment, diagonalCorner);
        asBig.drawU(ug.apply(this.rectangleArea.getPosition()));
    }

    public TextBlock getTextBlock(HColor backColor, HColor borderColor, double shadowing, double roundCorner, HorizontalAlignment titleAlignment, HorizontalAlignment stereoAlignment, double diagonalCorner) {
        Fashion biColor = new Fashion(backColor, borderColor);
        if (this.symbol == null) {
            throw new UnsupportedOperationException();
        }
        Fashion symbolContext = biColor.withShadow(shadowing).withStroke(this.defaultStroke).withCorner(roundCorner, diagonalCorner);
        TextBlock asBig = this.symbol.asBig(this.title, titleAlignment, this.stereo, this.rectangleArea.getWidth(), this.rectangleArea.getHeight(), symbolContext, stereoAlignment);
        return asBig;
    }
}

