/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;

public class CommandExecutionResult {
    private final String error;
    private final AbstractPSystem newDiagram;
    private final List<String> debugLines;
    private final int score;

    private CommandExecutionResult(AbstractPSystem newDiagram, String error, int score, List<String> debugLines) {
        this.error = error;
        this.newDiagram = newDiagram;
        this.debugLines = debugLines;
        this.score = score;
    }

    public CommandExecutionResult withDiagram(AbstractPSystem newDiagram) {
        return new CommandExecutionResult(newDiagram, this.error, 0, null);
    }

    public String toString() {
        return super.toString() + " " + this.error;
    }

    public static CommandExecutionResult newDiagram(AbstractPSystem result) {
        return new CommandExecutionResult(result, null, 0, null);
    }

    public static CommandExecutionResult ok() {
        return new CommandExecutionResult(null, null, 0, null);
    }

    public static CommandExecutionResult badColor() {
        return new CommandExecutionResult(null, "No such color", 10, null);
    }

    public static CommandExecutionResult error(String error) {
        return new CommandExecutionResult(null, error, 0, null);
    }

    public static CommandExecutionResult error(String error, int score) {
        return new CommandExecutionResult(null, error, score, null);
    }

    public static CommandExecutionResult error(String error, Throwable t) {
        return new CommandExecutionResult(null, error, 0, CommandExecutionResult.getStackTrace(t));
    }

    public static List<String> getStackTrace(Throwable exception) {
        ArrayList<String> result = new ArrayList<String>();
        result.add(exception.toString());
        for (StackTraceElement ste : exception.getStackTrace()) {
            result.add("  " + ste.toString());
        }
        if (exception.getCause() != null) {
            Throwable cause = exception.getCause();
            result.add("  ");
            result.add("Caused by " + cause.toString());
            for (StackTraceElement ste : cause.getStackTrace()) {
                result.add("  " + ste.toString());
            }
        }
        return result;
    }

    public boolean isOk() {
        return this.error == null;
    }

    public String getError() {
        if (this.isOk()) {
            throw new IllegalStateException();
        }
        return this.error;
    }

    public int getScore() {
        return this.score;
    }

    public AbstractPSystem getNewDiagram() {
        return this.newDiagram;
    }

    public List<String> getDebugLines() {
        return this.debugLines;
    }
}

