/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.diagram;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.regex.Pattern;
import org.asciidoctor.diagram.HTTPHeader;
import org.asciidoctor.diagram.HTTPHeaders;
import org.asciidoctor.diagram.Request;
import org.asciidoctor.diagram.RequestInput;
import org.asciidoctor.diagram.Response;
import org.asciidoctor.diagram.ResponseInput;

class HTTPInputStream
extends FilterInputStream
implements RequestInput,
ResponseInput {
    public static final Pattern START_LINE_SPLIT_RE = Pattern.compile(" +");

    public HTTPInputStream(InputStream in) {
        super(new BufferedInputStream(in));
    }

    public String readLine() throws IOException {
        StringBuilder b = new StringBuilder();
        boolean cr = false;
        while (true) {
            int value;
            if ((value = this.in.read()) == -1) {
                throw new EOFException();
            }
            if (value == 13) {
                if (cr) {
                    b.append('\r');
                }
                cr = true;
                continue;
            }
            if (value == 10 && cr) break;
            if (cr) {
                b.append('\r');
                cr = false;
            }
            b.append((char)value);
        }
        return b.toString();
    }

    public void readAll(byte[] data) throws IOException {
        int toRead = data.length;
        int offset = 0;
        while (toRead > 0) {
            int bytesRead = this.in.read(data, offset, toRead);
            toRead -= bytesRead;
            offset += bytesRead;
        }
    }

    @Override
    public Request readRequest() throws IOException {
        String line;
        try {
            line = this.readLine();
            if (line == null) {
                return null;
            }
        }
        catch (IOException e) {
            return null;
        }
        if (line.isEmpty()) {
            line = this.readLine();
        }
        String requestLine = line;
        String[] parts = START_LINE_SPLIT_RE.split(requestLine, 0);
        URI requestUri = URI.create(parts[1]);
        HTTPHeaders headers = this.readHeaders();
        byte[] data = this.readData(headers);
        return new Request(requestUri, headers, data);
    }

    @Override
    public Response readResponse() throws IOException {
        String line = this.readLine();
        if (line.isEmpty()) {
            line = this.readLine();
        }
        String statusLine = line;
        String[] parts = START_LINE_SPLIT_RE.split(statusLine, 0);
        int code = Integer.parseInt(parts[1]);
        String reason = parts[2];
        HTTPHeaders headers = this.readHeaders();
        byte[] data = this.readData(headers);
        return new Response(code, headers, data);
    }

    private byte[] readData(HTTPHeaders headers) throws IOException {
        byte[] data;
        Integer length = headers.getValue(HTTPHeader.CONTENT_LENGTH);
        if (length != null) {
            data = new byte[length.intValue()];
            this.readAll(data);
        } else {
            data = null;
        }
        return data;
    }

    private HTTPHeaders readHeaders() throws IOException {
        String line;
        HTTPHeaders headers = new HTTPHeaders();
        while (!(line = this.readLine()).isEmpty()) {
            int i = line.indexOf(58);
            String key = line.substring(0, i);
            String value = line.substring(i + 1).trim();
            headers.putValue(key, value);
        }
        return headers;
    }
}

