/* 
    TowBowlTactics: Strategy game for X11

    Copyright (C) 2002 Pascal Bourut (toweld@rocketmail.com)

    Network part from grrrreg (greg@doodoo.darktech.org)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef NETWORK_H
#define NETWORK_H

#include <SDL_net.h>
#include <iostream>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>

#include "global.h"

#define WAIT_TIMEOUT 10 // 10 milisecondes
#define MAX_MSG_LEN 256 // 256 octets max dans les msgs
#define NET_DEFAULT_PORT 8110
#define NET_DEFAULT_SERVER_IP "127.0.0.1"
#define NET_NB_SOCKETS 3

#define CLIENT 1
#define SERVER 2

typedef struct _TCPsocket* TCPsocket;

class Network {

 public:

  //   Network(void); // Constructeur qui cr un serveur 
  //~Network(void);
  int send_msg(char*, ...); // Renvoie 0 si rat, 1 si russi
  char* rcv_msg(void); // renvoie NULL si rat
  char* rcv_msg(int); // renvoie NULL si rat
  int get_type(void); // retourne CLIENT ou SERVER
  void set_nickname(char*); // pseudo du joueur, histoire de savoir avec qui on parle...
  char* get_nickname(void); 
  void set_adversary_nickname(char*); // pseudo du joueur, histoire de savoir avec qui on parle...
  char* get_adversary_nickname(void); 
  
  void set_ready(bool);
  bool is_ready(void);
 protected:

  // Les fonctions

 
  Uint16 getPort(void);
  // Les variables

  char data_received[MAX_MSG_LEN];
  TCPsocket serverSocket;
  TCPsocket parloteSocket;
  IPaddress serverIP;
  IPaddress clientIP;
  Uint16 port;
  SDLNet_SocketSet socketSet;
  char* ip_server;
  int type;
  char* nickname;
  char* adversary_nickname;
  bool ready;
};


#endif
