/* 
    TowBowlTactics: Strategy game for X11

    Copyright (C) 2001 Pascal Bourut (toweld@rocketmail.com)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "Formation.h"

Formation::Formation(){
	id = 1;
	placement = new map<int,Square*>;
}

Formation::Formation(int i){
	id = i;
	placement = new map<int,Square*>;
  } 

Formation::~Formation(){
	std::map<int,Square*> ::iterator it;
	for(it=placement->begin();it!=placement->end();it++){
		if( (*it).second ) {
			delete ((*it).second);
		}
	}
	delete placement;
}

void Formation::set_id(int i){
	id=i;
}

int Formation::get_id(){
	return id;
}

map<int, Square*> * Formation::get_placement(void){
	return placement;
}

void Formation::add_element(int i,Square* s){
	placement->insert(make_pair(i,s));
}

void Formation::add_element(int i, int x, int y){
	placement->insert(make_pair(i,new Square(x,y)));		
}




