/* 
 * Copyright (C) 2003 Tim Martin
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#ifndef UTILS_H
#define UTILS_H

#ifndef MAXFLOAT
#define MAXFLOAT ((float)3.40282346638528860e+38)
#endif /* MAXFLOAT */

typedef struct squareparts_s {
    short topx; short topy;
    short rightx; short righty;
    short botx; short boty;
    short leftx; short lefty;
} squareparts_t;

typedef struct point_s {
    short x;
    short y;
} point_t;

typedef union square_u {
    squareparts_t parts;
    point_t points[4];
} square_t;

typedef enum tax_types_indexes_e {
    TAX_TYPE_INCOME,
    TAX_TYPE_PROPERTY,
    TAX_TYPE_BUS_INCOME,
    TAX_TYPE_SALES,

    NUM_TAX_TYPES
} tax_types_indexes_t;

/* xxx link with types above */
extern char *tax_types[];

#define SECS_IN_DAY (60 * 60 * 24)

#define DAYS_MONTH 30

#define IMG_DIRECTORY "/usr/local/share/senken/img/"
#define GAMES_DIRECTORY "/usr/local/share/senken/games/"

#include "game.h"
#include "map.h"

extern char *prettyprint_money(int num, char *str, int lenstr);

extern int labor_count(labor_t *labor);

extern int set_map_byname(map_t *map, int x, int y, char *name, int force);

/*
 * Standard gettext macros.
 */
#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
#endif

#endif /* UTILS_H */
