/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.gunit;

import java.io.File;
import java.io.IOException;
import org.antlr.gunit.GrammarInfo;
import org.antlr.gunit.JUnitCodeGen;
import org.antlr.gunit.gUnitExecutor;
import org.antlr.gunit.gUnitLexer;
import org.antlr.gunit.gUnitParser;
import org.antlr.runtime.ANTLRFileStream;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;

public class Interp {
    static String testPackage;
    static boolean genJUnit;
    static String gunitFile;

    public static void main(String[] args) throws IOException, ClassNotFoundException, RecognitionException {
        ANTLRFileStream input = null;
        String testsuiteDir = System.getProperty("user.dir");
        Interp.processArgs(args);
        if (genJUnit) {
            if (gunitFile != null) {
                input = new ANTLRFileStream(gunitFile);
                File f = new File(gunitFile);
                testsuiteDir = Interp.getTestsuiteDir(f.getCanonicalPath(), f.getName());
            } else {
                input = new ANTLRInputStream(System.in);
            }
            GrammarInfo grammarInfo = Interp.parse((CharStream)input);
            grammarInfo.setTestPackage(testPackage);
            JUnitCodeGen generater = new JUnitCodeGen(grammarInfo, testsuiteDir);
            generater.compile();
            return;
        }
        if (gunitFile != null) {
            input = new ANTLRFileStream(gunitFile);
            File f = new File(gunitFile);
            testsuiteDir = Interp.getTestsuiteDir(f.getCanonicalPath(), f.getName());
        } else {
            input = new ANTLRInputStream(System.in);
        }
        gUnitExecutor executer = new gUnitExecutor(Interp.parse((CharStream)input), testsuiteDir);
        System.out.print(executer.execTest());
        System.exit(executer.failures.size() + executer.invalids.size());
    }

    public static void processArgs(String[] args) {
        if (args == null || args.length == 0) {
            return;
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-p")) {
                if (i + 1 >= args.length) {
                    System.err.println("missing library directory with -lib option; ignoring");
                    continue;
                }
                testPackage = args[++i];
                continue;
            }
            if (args[i].equals("-o")) {
                genJUnit = true;
                continue;
            }
            gunitFile = args[i];
        }
    }

    public static GrammarInfo parse(CharStream input) throws RecognitionException {
        gUnitLexer lexer = new gUnitLexer(input);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        GrammarInfo grammarInfo = new GrammarInfo();
        gUnitParser parser = new gUnitParser((TokenStream)tokens, grammarInfo);
        parser.gUnitDef();
        return grammarInfo;
    }

    public static String getTestsuiteDir(String fullPath, String fileName) {
        return fullPath.substring(0, fullPath.length() - fileName.length());
    }
}

