#ifndef ATL_sGetNB_geqrf

/*
 * NB selection for GEQRF: Side='RIGHT', Uplo='UPPER'
 * M : 25,410,796,844,892,940,989,1037,1085,1133,1182,1375,1568,1616,1664,1712,1761,1857,1954,2147,2340,2726,3112,3884,4656,5428,6200
 * N : 25,410,796,844,892,940,989,1037,1085,1133,1182,1375,1568,1616,1664,1712,1761,1857,1954,2147,2340,2726,3112,3884,4656,5428,6200
 * NB : 1,1,6,22,26,28,30,32,33,33,34,34,35,83,99,96,115,119,147,144,163,164,176,272,288,288,512
 */
#define ATL_sGetNB_geqrf(n_, nb_) \
{ \
   if ((n_) < 603) (nb_) = 1; \
   else if ((n_) < 820) (nb_) = 6; \
   else if ((n_) < 868) (nb_) = 22; \
   else if ((n_) < 916) (nb_) = 26; \
   else if ((n_) < 964) (nb_) = 28; \
   else if ((n_) < 1013) (nb_) = 30; \
   else if ((n_) < 1061) (nb_) = 32; \
   else if ((n_) < 1157) (nb_) = 33; \
   else if ((n_) < 1471) (nb_) = 34; \
   else if ((n_) < 1592) (nb_) = 35; \
   else if ((n_) < 1640) (nb_) = 83; \
   else if ((n_) < 1688) (nb_) = 99; \
   else if ((n_) < 1736) (nb_) = 96; \
   else if ((n_) < 1809) (nb_) = 115; \
   else if ((n_) < 1905) (nb_) = 119; \
   else if ((n_) < 2050) (nb_) = 147; \
   else if ((n_) < 2243) (nb_) = 144; \
   else if ((n_) < 2533) (nb_) = 163; \
   else if ((n_) < 2919) (nb_) = 164; \
   else if ((n_) < 3498) (nb_) = 176; \
   else if ((n_) < 4270) (nb_) = 272; \
   else if ((n_) < 5814) (nb_) = 288; \
   else (nb_) = 512; \
}


#endif    /* end ifndef ATL_sGetNB_geqrf */
