/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import java.io.File;
import java.io.FileReader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.functions.supportVector.Kernel;
import weka.core.Capabilities;
import weka.core.Copyable;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.matrix.Matrix;

public class PrecomputedKernelMatrixKernel
extends Kernel
implements Copyable {
    static final long serialVersionUID = -321831645846363333L;
    protected File m_KernelMatrixFile = new File("kernelMatrix.matrix");
    protected Matrix m_KernelMatrix;
    protected int m_Counter;

    @Override
    public Object copy() {
        PrecomputedKernelMatrixKernel newK = new PrecomputedKernelMatrixKernel();
        newK.setKernelMatrix(this.m_KernelMatrix);
        newK.setKernelMatrixFile(this.m_KernelMatrixFile);
        newK.m_Counter = this.m_Counter;
        return newK;
    }

    @Override
    public String globalInfo() {
        return "This kernel is based on a static kernel matrix that is read from a file. Instances must have a single nominal attribute (excluding the class). This attribute must be the first attribute in the file and its values are used to reference rows/columns in the kernel matrix. The second attribute must be the class attribute.";
    }

    @Override
    public Enumeration<Option> listOptions() {
        Vector<Option> result = new Vector<Option>();
        result.addElement(new Option("\tThe file name of the file that holds the kernel matrix.\n\t(default: kernelMatrix.matrix)", "M", 1, "-M <file name>"));
        result.addAll(Collections.list(super.listOptions()));
        return result.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String tmpStr = Utils.getOption('M', options);
        if (tmpStr.length() != 0) {
            this.setKernelMatrixFile(new File(tmpStr));
        } else {
            this.setKernelMatrixFile(new File("kernelMatrix.matrix"));
        }
        super.setOptions(options);
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-M");
        result.add("" + this.getKernelMatrixFile());
        Collections.addAll(result, super.getOptions());
        return result.toArray(new String[result.size()]);
    }

    @Override
    public double eval(int id1, int id2, Instance inst1) throws Exception {
        if (this.m_KernelMatrix == null) {
            throw new IllegalArgumentException("Kernel matrix has not been loaded successfully.");
        }
        int index1 = -1;
        index1 = id1 > -1 ? (int)this.m_data.instance(id1).value(0) : (int)inst1.value(0);
        int index2 = (int)this.m_data.instance(id2).value(0);
        return this.m_KernelMatrix.get(index1, index2);
    }

    @Override
    protected void initVars(Instances data) {
        super.initVars(data);
        try {
            if (this.m_KernelMatrix == null) {
                this.m_KernelMatrix = new Matrix(new FileReader(this.m_KernelMatrixFile));
            }
        }
        catch (Exception e) {
            System.err.println("Problem reading matrix from " + this.m_KernelMatrixFile);
        }
        ++this.m_Counter;
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public void setKernelMatrixFile(File f) {
        this.m_KernelMatrixFile = f;
    }

    public File getKernelMatrixFile() {
        return this.m_KernelMatrixFile;
    }

    public String kernelMatrixFileTipText() {
        return "The file holding the kernel matrix.";
    }

    protected void setKernelMatrix(Matrix km) {
        this.m_KernelMatrix = km;
    }

    public String toString() {
        return "Using kernel matrix from file with name: " + this.getKernelMatrixFile();
    }

    @Override
    public void clean() {
    }

    @Override
    public int numEvals() {
        return 0;
    }

    @Override
    public int numCacheHits() {
        return 0;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 14534 $");
    }
}

