<?php
/* DEFAULT USER CONFIGURATION STARTS HERE */

/* rrdtool_path :   path to rrdtool executable
 * cache_dir :      where generated graphs (and their definitions) are
 *                  stored. garbage collection, ie file removal will happen
 *                  automatically; this directory cannot be shared with other
 *                  files.
 * cache_duration : number of seconds until files are refreshed
 * combine :        combine all 'type' rrdfiles for a host in one graph
 * host_tree :      where is the host tree located symon expects
 *                  a <host>/<rrds> directory structure.
 * host_layouts :   generate host layouts
 * isolate_hosts :  show a single host only when the default layout is selected
 * layout_dir :     location of layout files - remove this value to
 *                  disable user layouts
 * layout_first :   display layout files before host layouts
 *
 */

/* running OpenBSD, apache chrooted: */
$symon['rrdtool_path']='/bin/rrdtool';
$symon['cache_dir']='/symon/cache';
$symon['host_tree']='/symon/rrds';
$symon['layout_dir']='/symon';


/* running OpenBSD, apache not chrooted:
$symon['rrdtool_path']='/usr/local/bin/rrdtool';
$symon['cache_dir']='/var/www/symon/cache';
$symon['host_tree']='/var/www/symon/rrds';
$symon['layout_dir']='/var/www/symon';
*/

/* running FreeBSD, apache not chrooted:
$symon['rrdtool_path']='/usr/local/bin/rrdtool';
$symon['cache_dir']='/usr/local/www/symon/cache';
$symon['host_tree']='/usr/local/www/symon/rrds';
$symon['layout_dir']='/usr/local/www/symon';
*/

/* running Linux, apache not chrooted:
$symon['rrdtool_path']='/usr/bin/rrdtool';
$symon['cache_dir']='/var/www/symon/cache';
$symon['host_tree']='/var/www/symon/rrds';
$symon['layout_dir']='/var/www/symon';
*/
    
$symon['cache_duration']=20;
$symon['host_layouts']=1;
$symon['layout_first']=0;
$symon['isolate_hosts']=0;

$symon['combine']['cpu']=1;
$symon['combine']['cpuiow']=1;
$symon['combine']['df']=1;
$symon['combine']['io']=1;
$symon['combine']['iops']=1;
$symon['combine']['pfq']=1;

/* df can be displayed as bytes or blocks */
$symon['options']['df']='bytes';
/* $symon['options']['df']='blocks'; */

/* smart counters are vendor and model dependant; raw simply lists the values
 * as measured, cooked shows an interpretation that folds all errors into one
 * and all temperatures into another value. */
$symon['options']['smart']='raw';
/* $symon['options']['smart']='cooked'; */

/* io, iops, df and smart can use /dev/disk/by-id/ under linux yielding
 * 'ata-Hitachi_HDS722020ALA330_JK12345678900A' like identifiers. driveserial
 * will isolate the last part of the underscore separated id under the
 * assumption it is the driveserial. */
$symon['options']['driveserial']=1;

/* DEFAULT USER CONFIGURATION ENDS HERE */

/* Troubleshooting section */
/* $symon['rrdtool_debug']=1; // make rrdtool dump state apache error log */
/* $symon['layout_debug']=1;  // make layout dump state on screen */
/* $symon['graph_debug']=1;   // make graph dump state on screen */
/* $symon['lexer_debug']=1;   // make lexer dump state on screen */
/* $symon['metric_debug']=1; // make metric frontend dump state on screen */

/* make php verbose */
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_reporting' , E_ALL);

/* maximum time for graph to wait for file to appear */
$symon['graph_max_wait']=30;

/* constraints for rrdtool command line arguments */
$symon['constraints'] = ['--width'  => ['max' => 2048, 'min' => 32, 'default' => 300],
                         '-w'       => ['max' => 2048, 'min' => 32, 'default' => 300],
                         '--heigth' => ['max' => 2048, 'min' => 32, 'default' => 225],
                         '-h'       => ['max' => 2048, 'min' => 32, 'default' => 225],
                         '--start'  => ['max' => 4_294_967_296, 'min' => -4_294_967_296, 'default' => -86400],
                         '-s'       => ['max' => 4_294_967_296, 'min' => -4_294_967_296, 'default' => -86400],
                         '--end'    => ['max' => 4_294_967_296, 'min' => -4_294_967_296, 'default' => -1],
                         '-e'       => ['max' => 4_294_967_296, 'min' => -4_294_967_296, 'default' => -1]];

/* setup defaults for form variables */
$symon['defaults'] = [
    'size' => ['type'        => 'named',
               'default'     => 'normal',
               'namedvalues' => ['small'     => ['width' =>  200, 'heigth' => 125],
                                 'normal'    => ['width' =>  400, 'heigth' => 225],
                                 'big'       => ['width' =>  800, 'heigth' => 450],
                                 'huge'      => ['width' => 1000, 'heigth' => 575],
                                 'custom'    => '']],
    'timespan' => ['type'        => 'named',
                   'default'     => 'last 24 hours',
                   'namedvalues' => ['last 5 minutes'  => ['start' => -360, 'end' => -1],
                                     'last hour'       => ['start' => -3600, 'end' => -1],
                                     'last 4 hours'    => ['start' => -14400, 'end' => -1],
                                     'last 24 hours'   => ['start' => -86400, 'end' => -1],
                                     'last week'       => ['start' => -604800, 'end' => -1],
                                     'last month'      => ['start' => -2_419_200, 'end' => -1],
                                     //          'six months' => array( 'start' => -14515200, 'end' => -1 ),
                                     'custom'     => '']],
    'layout' => ['type'        => 'named',
                 'default'     => 'default',
                 'namedvalues' => ['default'    => '']],
    'start' => ['type'        => 'integer', 'default'     => $symon['constraints']['--start']['default'],
                'bounds'      => $symon['constraints']['--start']],
    'end' => ['type'        => 'integer',
              'default'     => $symon['constraints']['--end']['default'],
              'bounds'      => $symon['constraints']['--end']],
    'width' => ['type'        => 'integer', 'default'     => $symon['constraints']['--width']['default'],
                'bounds'      => $symon['constraints']['--width']],
    'heigth' => ['type'        => 'integer', 'default'     => $symon['constraints']['--heigth']['default'],
                 'bounds'      => $symon['constraints']['--heigth']],
    'grep' => ['type'        => 'enum', 'default'     => '',
               'enum'        => [1 => 'cpu', 'cpuiow', 'io1', 'io', 'iops', 'if', 'mem', 'pf', 'pfq', 'proc', 'mbuf', 'sensor', 'df', 'smart']],
    'split' => ['type'        => 'enum', 'default'     => '', 'namedvalues' => []]];

if ((is_countable($symon['combine']) ? count($symon['combine']) : 0) > 0) {
    $all = [];
    foreach ($symon['combine'] as $item => $value) {
        if ($value == 1) {
            $symon['defaults']['split']['namedvalues'][$item] = $item;
            $all[] = $item;
        }
    }
    $symon['defaults']['split']['namedvalues']['all'] = $all;
}
/* maximum buffer for file loads */
$symon['loadbuffer'] = 81920;

/* color codes for combine graphs */
$symon['colors'] = ['s1' => ['#570043','#6B1A52','#481D85','#6B2F98','#76325E','#78449D','#87486D','#8F5975','#8F5DAE','#9F73B6','#A17386','#A57C72','#B18AC2','#C2AACD'],
                    's2' => ['#005743','#1A6B52','#1D4885','#2F6B98','#32765E','#44789D','#48876D','#598F75','#5D8FAE','#739FB6','#73A186','#7CA572','#8AB1C2','#AAC2CD'],
                    's3' => ['#FF9275','#FFA484','#FFFFCC','#B5C393','#78AD87'],
                    's4' => ['#EB4C17','#4B93AF','#C5DAE7','#332C64','#C9E89B']];

$symon['color']['io'] = $symon['colors']['s1'];
$symon['color']['pfq'] = $symon['colors']['s2'];
$symon['color']['iops'] = $symon['colors']['s3'];
$symon['color']['df'] = $symon['colors']['s4'];
$symon['color']['smart'] = $symon['colors']['s1'];
$symon['color']['cpu'] = [
    'user' => '#00FF00',
    'nice' => '#00FFFF',
    'system' => '#DDA0DD',
    'interrupt' => '#9932CC',
    'idle' => '#F5FFFA',
    /* not shown for combined graphs */
    'iowait' => '#CC3232',
];
$symon['color']['cpuiow'] = $symon['color']['cpu'];
?>
