// Code generated by go-swagger; DO NOT EDIT.

// Copyright 2019 HAProxy Technologies
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//

package tcp_request_rule

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/haproxytech/client-native/v6/models"
)

// ReplaceTCPRequestRuleBackendOKCode is the HTTP code returned for type ReplaceTCPRequestRuleBackendOK
const ReplaceTCPRequestRuleBackendOKCode int = 200

/*
ReplaceTCPRequestRuleBackendOK TCP Request Rule replaced

swagger:response replaceTcpRequestRuleBackendOK
*/
type ReplaceTCPRequestRuleBackendOK struct {

	/*
	  In: Body
	*/
	Payload *models.TCPRequestRule `json:"body,omitempty"`
}

// NewReplaceTCPRequestRuleBackendOK creates ReplaceTCPRequestRuleBackendOK with default headers values
func NewReplaceTCPRequestRuleBackendOK() *ReplaceTCPRequestRuleBackendOK {

	return &ReplaceTCPRequestRuleBackendOK{}
}

// WithPayload adds the payload to the replace Tcp request rule backend o k response
func (o *ReplaceTCPRequestRuleBackendOK) WithPayload(payload *models.TCPRequestRule) *ReplaceTCPRequestRuleBackendOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Tcp request rule backend o k response
func (o *ReplaceTCPRequestRuleBackendOK) SetPayload(payload *models.TCPRequestRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceTCPRequestRuleBackendOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceTCPRequestRuleBackendAcceptedCode is the HTTP code returned for type ReplaceTCPRequestRuleBackendAccepted
const ReplaceTCPRequestRuleBackendAcceptedCode int = 202

/*
ReplaceTCPRequestRuleBackendAccepted Configuration change accepted and reload requested

swagger:response replaceTcpRequestRuleBackendAccepted
*/
type ReplaceTCPRequestRuleBackendAccepted struct {
	/*ID of the requested reload

	 */
	ReloadID string `json:"Reload-ID"`

	/*
	  In: Body
	*/
	Payload *models.TCPRequestRule `json:"body,omitempty"`
}

// NewReplaceTCPRequestRuleBackendAccepted creates ReplaceTCPRequestRuleBackendAccepted with default headers values
func NewReplaceTCPRequestRuleBackendAccepted() *ReplaceTCPRequestRuleBackendAccepted {

	return &ReplaceTCPRequestRuleBackendAccepted{}
}

// WithReloadID adds the reloadId to the replace Tcp request rule backend accepted response
func (o *ReplaceTCPRequestRuleBackendAccepted) WithReloadID(reloadID string) *ReplaceTCPRequestRuleBackendAccepted {
	o.ReloadID = reloadID
	return o
}

// SetReloadID sets the reloadId to the replace Tcp request rule backend accepted response
func (o *ReplaceTCPRequestRuleBackendAccepted) SetReloadID(reloadID string) {
	o.ReloadID = reloadID
}

// WithPayload adds the payload to the replace Tcp request rule backend accepted response
func (o *ReplaceTCPRequestRuleBackendAccepted) WithPayload(payload *models.TCPRequestRule) *ReplaceTCPRequestRuleBackendAccepted {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Tcp request rule backend accepted response
func (o *ReplaceTCPRequestRuleBackendAccepted) SetPayload(payload *models.TCPRequestRule) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceTCPRequestRuleBackendAccepted) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Reload-ID

	reloadID := o.ReloadID
	if reloadID != "" {
		rw.Header().Set("Reload-ID", reloadID)
	}

	rw.WriteHeader(202)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceTCPRequestRuleBackendBadRequestCode is the HTTP code returned for type ReplaceTCPRequestRuleBackendBadRequest
const ReplaceTCPRequestRuleBackendBadRequestCode int = 400

/*
ReplaceTCPRequestRuleBackendBadRequest Bad request

swagger:response replaceTcpRequestRuleBackendBadRequest
*/
type ReplaceTCPRequestRuleBackendBadRequest struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceTCPRequestRuleBackendBadRequest creates ReplaceTCPRequestRuleBackendBadRequest with default headers values
func NewReplaceTCPRequestRuleBackendBadRequest() *ReplaceTCPRequestRuleBackendBadRequest {

	return &ReplaceTCPRequestRuleBackendBadRequest{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Tcp request rule backend bad request response
func (o *ReplaceTCPRequestRuleBackendBadRequest) WithConfigurationVersion(configurationVersion string) *ReplaceTCPRequestRuleBackendBadRequest {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Tcp request rule backend bad request response
func (o *ReplaceTCPRequestRuleBackendBadRequest) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Tcp request rule backend bad request response
func (o *ReplaceTCPRequestRuleBackendBadRequest) WithPayload(payload *models.Error) *ReplaceTCPRequestRuleBackendBadRequest {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Tcp request rule backend bad request response
func (o *ReplaceTCPRequestRuleBackendBadRequest) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceTCPRequestRuleBackendBadRequest) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(400)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

// ReplaceTCPRequestRuleBackendNotFoundCode is the HTTP code returned for type ReplaceTCPRequestRuleBackendNotFound
const ReplaceTCPRequestRuleBackendNotFoundCode int = 404

/*
ReplaceTCPRequestRuleBackendNotFound The specified resource was not found

swagger:response replaceTcpRequestRuleBackendNotFound
*/
type ReplaceTCPRequestRuleBackendNotFound struct {
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceTCPRequestRuleBackendNotFound creates ReplaceTCPRequestRuleBackendNotFound with default headers values
func NewReplaceTCPRequestRuleBackendNotFound() *ReplaceTCPRequestRuleBackendNotFound {

	return &ReplaceTCPRequestRuleBackendNotFound{}
}

// WithConfigurationVersion adds the configurationVersion to the replace Tcp request rule backend not found response
func (o *ReplaceTCPRequestRuleBackendNotFound) WithConfigurationVersion(configurationVersion string) *ReplaceTCPRequestRuleBackendNotFound {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace Tcp request rule backend not found response
func (o *ReplaceTCPRequestRuleBackendNotFound) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace Tcp request rule backend not found response
func (o *ReplaceTCPRequestRuleBackendNotFound) WithPayload(payload *models.Error) *ReplaceTCPRequestRuleBackendNotFound {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace Tcp request rule backend not found response
func (o *ReplaceTCPRequestRuleBackendNotFound) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceTCPRequestRuleBackendNotFound) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(404)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ReplaceTCPRequestRuleBackendDefault General Error

swagger:response replaceTcpRequestRuleBackendDefault
*/
type ReplaceTCPRequestRuleBackendDefault struct {
	_statusCode int
	/*Configuration file version

	 */
	ConfigurationVersion string `json:"Configuration-Version"`

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewReplaceTCPRequestRuleBackendDefault creates ReplaceTCPRequestRuleBackendDefault with default headers values
func NewReplaceTCPRequestRuleBackendDefault(code int) *ReplaceTCPRequestRuleBackendDefault {
	if code <= 0 {
		code = 500
	}

	return &ReplaceTCPRequestRuleBackendDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the replace TCP request rule backend default response
func (o *ReplaceTCPRequestRuleBackendDefault) WithStatusCode(code int) *ReplaceTCPRequestRuleBackendDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the replace TCP request rule backend default response
func (o *ReplaceTCPRequestRuleBackendDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithConfigurationVersion adds the configurationVersion to the replace TCP request rule backend default response
func (o *ReplaceTCPRequestRuleBackendDefault) WithConfigurationVersion(configurationVersion string) *ReplaceTCPRequestRuleBackendDefault {
	o.ConfigurationVersion = configurationVersion
	return o
}

// SetConfigurationVersion sets the configurationVersion to the replace TCP request rule backend default response
func (o *ReplaceTCPRequestRuleBackendDefault) SetConfigurationVersion(configurationVersion string) {
	o.ConfigurationVersion = configurationVersion
}

// WithPayload adds the payload to the replace TCP request rule backend default response
func (o *ReplaceTCPRequestRuleBackendDefault) WithPayload(payload *models.Error) *ReplaceTCPRequestRuleBackendDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the replace TCP request rule backend default response
func (o *ReplaceTCPRequestRuleBackendDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ReplaceTCPRequestRuleBackendDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	// response header Configuration-Version

	configurationVersion := o.ConfigurationVersion
	if configurationVersion != "" {
		rw.Header().Set("Configuration-Version", configurationVersion)
	}

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
