/* theme-2d-file.c generated by valac 0.46.3, the Vala compiler
 * generated from theme-2d-file.vala, do not modify */

/*  Pasang Emas. Enjoy a unique traditional game of Brunei.
    Copyright (C) 2010  Nor Jaidi Tuah

    This file is part of Pasang Emas.
      
    Pasang Emas is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <../config.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <gdk/gdk.h>

#define PASANG_TYPE_THEME (pasang_theme_get_type ())
#define PASANG_THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_THEME, PasangTheme))
#define PASANG_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_THEME, PasangThemeClass))
#define PASANG_IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_THEME))
#define PASANG_IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_THEME))
#define PASANG_THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_THEME, PasangThemeClass))

typedef struct _PasangTheme PasangTheme;
typedef struct _PasangThemeClass PasangThemeClass;
typedef struct _PasangThemePrivate PasangThemePrivate;

#define PASANG_TYPE_GAME_VIEW (pasang_game_view_get_type ())
#define PASANG_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_GAME_VIEW, PasangGameView))
#define PASANG_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_GAME_VIEW, PasangGameViewClass))
#define PASANG_IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_GAME_VIEW))
#define PASANG_IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_GAME_VIEW))
#define PASANG_GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_GAME_VIEW, PasangGameViewClass))

typedef struct _PasangGameView PasangGameView;
typedef struct _PasangGameViewClass PasangGameViewClass;
typedef enum  {
	PASANG_PIECE_NULL = -999,
	PASANG_PIECE_KAS_0 = 0,
	PASANG_PIECE_KAS_1 = 1,
	PASANG_PIECE_BLACK = 2,
	PASANG_PIECE_WHITE = 3,
	PASANG_PIECE_COUNT = 4,
	PASANG_PIECE_BOARD = 4,
	PASANG_PIECE_GUARD = 5,
	PASANG_PIECE_GUIDE = 6,
	PASANG_PIECE_EMPTY = 100
} PasangPiece;

#define PASANG_TYPE_PIECE (pasang_piece_get_type ())

#define PASANG_TYPE_POINT (pasang_point_get_type ())
typedef struct _PasangPoint PasangPoint;

#define PASANG_TYPE_GAME (pasang_game_get_type ())
#define PASANG_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_GAME, PasangGame))
#define PASANG_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_GAME, PasangGameClass))
#define PASANG_IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_GAME))
#define PASANG_IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_GAME))
#define PASANG_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_GAME, PasangGameClass))

typedef struct _PasangGame PasangGame;
typedef struct _PasangGameClass PasangGameClass;

#define PASANG_TYPE_THEME_ITEM (pasang_theme_item_get_type ())
typedef struct _PasangThemeItem PasangThemeItem;

#define PASANG_TYPE_FILM (pasang_film_get_type ())
typedef struct _PasangFilm PasangFilm;

#define PASANG_TYPE_THEME2_D (pasang_theme2_d_get_type ())
#define PASANG_THEME2_D(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_THEME2_D, PasangTheme2D))
#define PASANG_THEME2_D_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_THEME2_D, PasangTheme2DClass))
#define PASANG_IS_THEME2_D(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_THEME2_D))
#define PASANG_IS_THEME2_D_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_THEME2_D))
#define PASANG_THEME2_D_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_THEME2_D, PasangTheme2DClass))

typedef struct _PasangTheme2D PasangTheme2D;
typedef struct _PasangTheme2DClass PasangTheme2DClass;
typedef struct _PasangTheme2DPrivate PasangTheme2DPrivate;

#define PASANG_TYPE_LAYOUT2_D (pasang_layout2_d_get_type ())
typedef struct _PasangLayout2D PasangLayout2D;

#define PASANG_TYPE_RGB (pasang_rgb_get_type ())
typedef struct _PasangRgb PasangRgb;

#define PASANG_TYPE_THEME2_DFILE (pasang_theme2_dfile_get_type ())
#define PASANG_THEME2_DFILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_THEME2_DFILE, PasangTheme2DFile))
#define PASANG_THEME2_DFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_THEME2_DFILE, PasangTheme2DFileClass))
#define PASANG_IS_THEME2_DFILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_THEME2_DFILE))
#define PASANG_IS_THEME2_DFILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_THEME2_DFILE))
#define PASANG_THEME2_DFILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_THEME2_DFILE, PasangTheme2DFileClass))

typedef struct _PasangTheme2DFile PasangTheme2DFile;
typedef struct _PasangTheme2DFileClass PasangTheme2DFileClass;
typedef struct _PasangTheme2DFilePrivate PasangTheme2DFilePrivate;
enum  {
	PASANG_THEME2_DFILE_0_PROPERTY,
	PASANG_THEME2_DFILE_NUM_PROPERTIES
};
static GParamSpec* pasang_theme2_dfile_properties[PASANG_THEME2_DFILE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _PasangPoint {
	gint x;
	gint y;
};

struct _PasangThemeItem {
	gchar* name;
	gchar* path;
	GdkPixbuf* pixbuf;
	gchar* license;
	gchar* artist;
	gchar* comment;
	PasangTheme* engine;
};

struct _PasangFilm {
	gint stop;
	gint length;
	gint viewed;
	gint n;
};

struct _PasangTheme {
	GObject parent_instance;
	PasangThemePrivate * priv;
	PasangThemeItem* items;
	gint items_length1;
	gint _items_size_;
	PasangFilm* films;
	gint films_length1;
	gint _films_size_;
	gint* cycles;
	gint cycles_length1;
	gint _cycles_size_;
};

struct _PasangThemeClass {
	GObjectClass parent_class;
	PasangTheme* (*select) (PasangTheme* self, const gchar* path, gint width, gint height);
	void (*resize) (PasangTheme* self, gint width, gint height);
	void (*free) (PasangTheme* self);
	void (*draw) (PasangTheme* self, PasangGameView* game_view, cairo_t* cr);
	void (*queue_draw_piece) (PasangTheme* self, GtkDrawingArea* view, PasangPiece piece, PasangPoint* p);
	gint (*count_frames) (PasangTheme* self, PasangPiece piece);
	void (*to_point) (PasangTheme* self, gint pos, gboolean rotated, PasangPoint* result);
	gint (*to_position) (PasangTheme* self, PasangGame* game, PasangPoint* p, gboolean rotated, gboolean precise);
	gint (*to_side) (PasangTheme* self, PasangPoint* p);
};

struct _PasangRgb {
	gdouble red;
	gdouble green;
	gdouble blue;
	gdouble alpha;
};

struct _PasangLayout2D {
	gint x;
	gint y;
	gint width;
	gint height;
	gint board_x;
	gint board_y;
	gint board_size;
	gint score_x[2];
	gint score_y[2];
	gint score_font_size;
	PasangRgb score_color[2];
	gint kas_x[2];
	gint kas_y[2];
	gint kas_frame[2];
	gint num_wins_x[2];
	gint num_wins_y[2];
	gint num_wins_font_size;
	PasangRgb num_wins_color;
	gint num_rounds_x;
	gint num_rounds_y;
	gint num_rounds_format;
	gint num_rounds_font_size;
	PasangRgb num_rounds_color;
	gint filler_left;
	gint filler_top;
	gint filler_right;
	gint filler_bottom;
	gint image_x;
	gint image_y;
	gint image_width;
	gint image_height;
};

struct _PasangTheme2D {
	PasangTheme parent_instance;
	PasangTheme2DPrivate * priv;
	PasangLayout2D default_layout;
	PasangLayout2D layout;
	PasangLayout2D table;
	gboolean layout_changed;
	cairo_surface_t** images;
	gint images_length1;
	gint _images_size_;
	gint* num_rows_in_image;
	gint num_rows_in_image_length1;
	gint _num_rows_in_image_size_;
};

struct _PasangTheme2DClass {
	PasangThemeClass parent_class;
	void (*resize_images) (PasangTheme2D* self);
};

struct _PasangTheme2DFile {
	PasangTheme2D parent_instance;
	PasangTheme2DFilePrivate * priv;
	GdkPixbuf** pixbufs;
	gint pixbufs_length1;
	gint _pixbufs_size_;
};

struct _PasangTheme2DFileClass {
	PasangTheme2DClass parent_class;
};

struct _PasangTheme2DFilePrivate {
	gchar** filename_alts;
	gint filename_alts_length1;
	gint _filename_alts_size_;
	gchar** filetypes;
	gint filetypes_length1;
	gint _filetypes_size_;
	gboolean old_theme;
};

static gint PasangTheme2DFile_private_offset;
static gpointer pasang_theme2_dfile_parent_class = NULL;
extern gchar* pasang_reloc_theme_root_dir;

GType pasang_theme_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangTheme, g_object_unref)
GType pasang_game_view_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangGameView, g_object_unref)
GType pasang_piece_get_type (void) G_GNUC_CONST;
GType pasang_point_get_type (void) G_GNUC_CONST;
PasangPoint* pasang_point_dup (const PasangPoint* self);
void pasang_point_free (PasangPoint* self);
GType pasang_game_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangGame, g_object_unref)
GType pasang_theme_item_get_type (void) G_GNUC_CONST;
PasangThemeItem* pasang_theme_item_dup (const PasangThemeItem* self);
void pasang_theme_item_free (PasangThemeItem* self);
void pasang_theme_item_copy (const PasangThemeItem* self,
                             PasangThemeItem* dest);
void pasang_theme_item_destroy (PasangThemeItem* self);
GType pasang_film_get_type (void) G_GNUC_CONST;
PasangFilm* pasang_film_dup (const PasangFilm* self);
void pasang_film_free (PasangFilm* self);
GType pasang_theme2_d_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangTheme2D, g_object_unref)
GType pasang_layout2_d_get_type (void) G_GNUC_CONST;
GType pasang_rgb_get_type (void) G_GNUC_CONST;
PasangRgb* pasang_rgb_dup (const PasangRgb* self);
void pasang_rgb_free (PasangRgb* self);
PasangLayout2D* pasang_layout2_d_dup (const PasangLayout2D* self);
void pasang_layout2_d_free (PasangLayout2D* self);
GType pasang_theme2_dfile_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangTheme2DFile, g_object_unref)
PasangTheme2DFile* pasang_theme2_dfile_new (void);
PasangTheme2DFile* pasang_theme2_dfile_construct (GType object_type);
PasangTheme2D* pasang_theme2_d_construct (GType object_type);
static void pasang_theme2_dfile_add_themes_in_dir (PasangTheme2DFile* self,
                                            const gchar* parent_directory);
static gboolean pasang_theme2_dfile_image_files_found (PasangTheme2DFile* self,
                                                const gchar* path);
void pasang_theme_item_init (PasangThemeItem *self);
static gboolean pasang_theme2_dfile_add_theme_info (PasangTheme2DFile* self,
                                             const gchar* path,
                                             PasangThemeItem* item);
static void _vala_array_add32 (PasangThemeItem* * array,
                        int* length,
                        int* size,
                        const PasangThemeItem* value);
static void pasang_theme2_dfile_get_kf_string (PasangTheme2DFile* self,
                                        GKeyFile* kf,
                                        const gchar* group,
                                        const gchar* key,
                                        gchar* * output,
                                        GError** error);
PasangTheme* pasang_theme_select (PasangTheme* self,
                                  const gchar* path,
                                  gint width,
                                  gint height);
static void pasang_theme2_dfile_real_free (PasangTheme* base);
void pasang_theme_free (PasangTheme* self);
static PasangTheme* pasang_theme2_dfile_real_select (PasangTheme* base,
                                              const gchar* path,
                                              gint width,
                                              gint height);
void pasang_theme_set_time_span (PasangTheme* self,
                                 gdouble value);
static GdkPixbuf* pasang_theme2_dfile_load_as_pixbuf (PasangTheme2DFile* self,
                                               const gchar* path,
                                               const gchar* filename_alt);
static void pasang_theme2_dfile_get_kf_layout (PasangTheme2DFile* self,
                                        GKeyFile* kf);
static void pasang_theme2_dfile_get_kf_integer_list (PasangTheme2DFile* self,
                                              GKeyFile* kf,
                                              const gchar* group,
                                              const gchar* key,
                                              gint** output,
                                              gint* output_length1,
                                              GError** error);
void pasang_theme_resize (PasangTheme* self,
                          gint width,
                          gint height);
#define PASANG_BOARD_WIDTH 13
void pasang_rgb_init (PasangRgb *self,
                      gdouble r,
                      gdouble g,
                      gdouble b,
                      gdouble a);
static void pasang_theme2_dfile_real_resize_images (PasangTheme2D* base);
static void pasang_theme2_dfile_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
pasang_theme2_dfile_get_instance_private (PasangTheme2DFile* self)
{
	return G_STRUCT_MEMBER_P (self, PasangTheme2DFile_private_offset);
}

PasangTheme2DFile*
pasang_theme2_dfile_construct (GType object_type)
{
	PasangTheme2DFile * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 28 "theme-2d-file.vala"
	self = (PasangTheme2DFile*) pasang_theme2_d_construct (object_type);
#line 30 "theme-2d-file.vala"
	_tmp0_ = pasang_reloc_theme_root_dir;
#line 30 "theme-2d-file.vala"
	pasang_theme2_dfile_add_themes_in_dir (self, _tmp0_);
#line 32 "theme-2d-file.vala"
	_tmp1_ = g_get_home_dir ();
#line 32 "theme-2d-file.vala"
	_tmp2_ = g_build_filename (_tmp1_, USER_THEME_ROOT_DIR, NULL, NULL);
#line 32 "theme-2d-file.vala"
	_tmp3_ = _tmp2_;
#line 32 "theme-2d-file.vala"
	pasang_theme2_dfile_add_themes_in_dir (self, _tmp3_);
#line 32 "theme-2d-file.vala"
	_g_free0 (_tmp3_);
#line 28 "theme-2d-file.vala"
	return self;
#line 393 "theme-2d-file.c"
}

PasangTheme2DFile*
pasang_theme2_dfile_new (void)
{
#line 28 "theme-2d-file.vala"
	return pasang_theme2_dfile_construct (PASANG_TYPE_THEME2_DFILE);
#line 401 "theme-2d-file.c"
}

/**
     * Get all directories inside the given one. Assume these to be themes.
     * Side effect: items
     */
static gpointer
_g_object_ref0 (gpointer self)
{
#line 47 "theme-2d-file.vala"
	return self ? g_object_ref (self) : NULL;
#line 413 "theme-2d-file.c"
}

static void
_vala_array_add32 (PasangThemeItem* * array,
                   int* length,
                   int* size,
                   const PasangThemeItem* value)
{
#line 49 "theme-2d-file.vala"
	if ((*length) == (*size)) {
#line 49 "theme-2d-file.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 49 "theme-2d-file.vala"
		*array = g_renew (PasangThemeItem, *array, *size);
#line 428 "theme-2d-file.c"
	}
#line 49 "theme-2d-file.vala"
	(*array)[(*length)++] = *value;
#line 432 "theme-2d-file.c"
}

static void
pasang_theme2_dfile_add_themes_in_dir (PasangTheme2DFile* self,
                                       const gchar* parent_directory)
{
	GError* _inner_error0_ = NULL;
#line 39 "theme-2d-file.vala"
	g_return_if_fail (self != NULL);
#line 39 "theme-2d-file.vala"
	g_return_if_fail (parent_directory != NULL);
#line 444 "theme-2d-file.c"
	{
		GDir* theme_dir = NULL;
		GDir* _tmp0_;
#line 41 "theme-2d-file.vala"
		_tmp0_ = g_dir_open (parent_directory, (guint) 0, &_inner_error0_);
#line 41 "theme-2d-file.vala"
		theme_dir = _tmp0_;
#line 41 "theme-2d-file.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 454 "theme-2d-file.c"
			goto __catch18_g_error;
		}
#line 42 "theme-2d-file.vala"
		while (TRUE) {
#line 459 "theme-2d-file.c"
			gchar* dir = NULL;
			GDir* _tmp1_;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			const gchar* _tmp4_;
			gchar* path = NULL;
			const gchar* _tmp5_;
			gchar* _tmp6_;
			gboolean _tmp7_ = FALSE;
			const gchar* _tmp8_;
#line 43 "theme-2d-file.vala"
			_tmp1_ = theme_dir;
#line 43 "theme-2d-file.vala"
			_tmp2_ = g_dir_read_name (_tmp1_);
#line 43 "theme-2d-file.vala"
			_tmp3_ = g_strdup (_tmp2_);
#line 43 "theme-2d-file.vala"
			dir = _tmp3_;
#line 44 "theme-2d-file.vala"
			_tmp4_ = dir;
#line 44 "theme-2d-file.vala"
			if (_tmp4_ == NULL) {
#line 44 "theme-2d-file.vala"
				_g_free0 (dir);
#line 44 "theme-2d-file.vala"
				break;
#line 486 "theme-2d-file.c"
			}
#line 45 "theme-2d-file.vala"
			_tmp5_ = dir;
#line 45 "theme-2d-file.vala"
			_tmp6_ = g_build_filename (parent_directory, _tmp5_, NULL, NULL);
#line 45 "theme-2d-file.vala"
			path = _tmp6_;
#line 46 "theme-2d-file.vala"
			_tmp8_ = path;
#line 46 "theme-2d-file.vala"
			if (g_file_test (_tmp8_, G_FILE_TEST_IS_DIR)) {
#line 498 "theme-2d-file.c"
				const gchar* _tmp9_;
#line 46 "theme-2d-file.vala"
				_tmp9_ = path;
#line 46 "theme-2d-file.vala"
				_tmp7_ = pasang_theme2_dfile_image_files_found (self, _tmp9_);
#line 504 "theme-2d-file.c"
			} else {
#line 46 "theme-2d-file.vala"
				_tmp7_ = FALSE;
#line 508 "theme-2d-file.c"
			}
#line 46 "theme-2d-file.vala"
			if (_tmp7_) {
#line 512 "theme-2d-file.c"
				PasangThemeItem item = {0};
				const gchar* _tmp10_;
				gchar* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				PasangTheme* _tmp14_;
				PasangThemeItem _tmp15_ = {0};
				const gchar* _tmp16_;
				gboolean _tmp17_;
#line 47 "theme-2d-file.vala"
				_tmp10_ = dir;
#line 47 "theme-2d-file.vala"
				_tmp11_ = g_strdup (_tmp10_);
#line 47 "theme-2d-file.vala"
				_tmp12_ = path;
#line 47 "theme-2d-file.vala"
				_tmp13_ = g_strdup (_tmp12_);
#line 47 "theme-2d-file.vala"
				_tmp14_ = _g_object_ref0 ((PasangTheme*) self);
#line 47 "theme-2d-file.vala"
				pasang_theme_item_init (&_tmp15_);
#line 47 "theme-2d-file.vala"
				_g_free0 (_tmp15_.name);
#line 47 "theme-2d-file.vala"
				_tmp15_.name = _tmp11_;
#line 47 "theme-2d-file.vala"
				_g_free0 (_tmp15_.path);
#line 47 "theme-2d-file.vala"
				_tmp15_.path = _tmp13_;
#line 47 "theme-2d-file.vala"
				_g_object_unref0 (_tmp15_.engine);
#line 47 "theme-2d-file.vala"
				_tmp15_.engine = _tmp14_;
#line 47 "theme-2d-file.vala"
				item = _tmp15_;
#line 48 "theme-2d-file.vala"
				_tmp16_ = path;
#line 48 "theme-2d-file.vala"
				_tmp17_ = pasang_theme2_dfile_add_theme_info (self, _tmp16_, &item);
#line 48 "theme-2d-file.vala"
				if (_tmp17_) {
#line 554 "theme-2d-file.c"
					PasangThemeItem* _tmp18_;
					gint _tmp18__length1;
					PasangThemeItem _tmp19_;
					PasangThemeItem _tmp20_;
					PasangThemeItem _tmp21_ = {0};
#line 49 "theme-2d-file.vala"
					_tmp18_ = ((PasangTheme*) self)->items;
#line 49 "theme-2d-file.vala"
					_tmp18__length1 = ((PasangTheme*) self)->items_length1;
#line 49 "theme-2d-file.vala"
					_tmp19_ = item;
#line 49 "theme-2d-file.vala"
					_tmp20_ = _tmp19_;
#line 49 "theme-2d-file.vala"
					pasang_theme_item_copy (&_tmp20_, &_tmp21_);
#line 49 "theme-2d-file.vala"
					_vala_array_add32 (&((PasangTheme*) self)->items, &((PasangTheme*) self)->items_length1, &((PasangTheme*) self)->_items_size_, &_tmp21_);
#line 572 "theme-2d-file.c"
				}
#line 46 "theme-2d-file.vala"
				pasang_theme_item_destroy (&item);
#line 576 "theme-2d-file.c"
			}
#line 42 "theme-2d-file.vala"
			_g_free0 (path);
#line 42 "theme-2d-file.vala"
			_g_free0 (dir);
#line 582 "theme-2d-file.c"
		}
#line 40 "theme-2d-file.vala"
		_g_dir_close0 (theme_dir);
#line 586 "theme-2d-file.c"
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError* e = NULL;
		FILE* _tmp22_;
		GError* _tmp23_;
		const gchar* _tmp24_;
#line 40 "theme-2d-file.vala"
		e = _inner_error0_;
#line 40 "theme-2d-file.vala"
		_inner_error0_ = NULL;
#line 55 "theme-2d-file.vala"
		_tmp22_ = stderr;
#line 55 "theme-2d-file.vala"
		_tmp23_ = e;
#line 55 "theme-2d-file.vala"
		_tmp24_ = _tmp23_->message;
#line 55 "theme-2d-file.vala"
		fprintf (_tmp22_, "File error: %s\n", _tmp24_);
#line 40 "theme-2d-file.vala"
		_g_error_free0 (e);
#line 609 "theme-2d-file.c"
	}
	__finally18:
#line 40 "theme-2d-file.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 40 "theme-2d-file.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 40 "theme-2d-file.vala"
		g_clear_error (&_inner_error0_);
#line 40 "theme-2d-file.vala"
		return;
#line 620 "theme-2d-file.c"
	}
}

/**
     * Check if the directory contains all the required image files.
     */
static gboolean
pasang_theme2_dfile_image_files_found (PasangTheme2DFile* self,
                                       const gchar* path)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gboolean result = FALSE;
#line 62 "theme-2d-file.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 62 "theme-2d-file.vala"
	g_return_val_if_fail (path != NULL, FALSE);
#line 63 "theme-2d-file.vala"
	_tmp0_ = self->priv->filename_alts;
#line 63 "theme-2d-file.vala"
	_tmp0__length1 = self->priv->filename_alts_length1;
#line 642 "theme-2d-file.c"
	{
		gchar** filename_alt_collection = NULL;
		gint filename_alt_collection_length1 = 0;
		gint _filename_alt_collection_size_ = 0;
		gint filename_alt_it = 0;
#line 63 "theme-2d-file.vala"
		filename_alt_collection = _tmp0_;
#line 63 "theme-2d-file.vala"
		filename_alt_collection_length1 = _tmp0__length1;
#line 63 "theme-2d-file.vala"
		for (filename_alt_it = 0; filename_alt_it < filename_alt_collection_length1; filename_alt_it = filename_alt_it + 1) {
#line 654 "theme-2d-file.c"
			gchar* _tmp1_;
			gchar* filename_alt = NULL;
#line 63 "theme-2d-file.vala"
			_tmp1_ = g_strdup (filename_alt_collection[filename_alt_it]);
#line 63 "theme-2d-file.vala"
			filename_alt = _tmp1_;
#line 661 "theme-2d-file.c"
			{
				gchar** filenames = NULL;
				const gchar* _tmp2_;
				gchar** _tmp3_;
				gchar** _tmp4_;
				gint filenames_length1;
				gint _filenames_size_;
				gboolean found = FALSE;
				gchar** _tmp5_;
				gint _tmp5__length1;
#line 64 "theme-2d-file.vala"
				_tmp2_ = filename_alt;
#line 64 "theme-2d-file.vala"
				_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, "|", 0);
#line 64 "theme-2d-file.vala"
				filenames = _tmp4_;
#line 64 "theme-2d-file.vala"
				filenames_length1 = _vala_array_length (_tmp3_);
#line 64 "theme-2d-file.vala"
				_filenames_size_ = filenames_length1;
#line 66 "theme-2d-file.vala"
				found = FALSE;
#line 67 "theme-2d-file.vala"
				_tmp5_ = filenames;
#line 67 "theme-2d-file.vala"
				_tmp5__length1 = filenames_length1;
#line 688 "theme-2d-file.c"
				{
					gchar** filename_collection = NULL;
					gint filename_collection_length1 = 0;
					gint _filename_collection_size_ = 0;
					gint filename_it = 0;
#line 67 "theme-2d-file.vala"
					filename_collection = _tmp5_;
#line 67 "theme-2d-file.vala"
					filename_collection_length1 = _tmp5__length1;
#line 67 "theme-2d-file.vala"
					for (filename_it = 0; filename_it < filename_collection_length1; filename_it = filename_it + 1) {
#line 700 "theme-2d-file.c"
						gchar* _tmp6_;
						gchar* filename = NULL;
#line 67 "theme-2d-file.vala"
						_tmp6_ = g_strdup (filename_collection[filename_it]);
#line 67 "theme-2d-file.vala"
						filename = _tmp6_;
#line 707 "theme-2d-file.c"
						{
							gchar** _tmp7_;
							gint _tmp7__length1;
#line 68 "theme-2d-file.vala"
							_tmp7_ = self->priv->filetypes;
#line 68 "theme-2d-file.vala"
							_tmp7__length1 = self->priv->filetypes_length1;
#line 715 "theme-2d-file.c"
							{
								gchar** filetype_collection = NULL;
								gint filetype_collection_length1 = 0;
								gint _filetype_collection_size_ = 0;
								gint filetype_it = 0;
#line 68 "theme-2d-file.vala"
								filetype_collection = _tmp7_;
#line 68 "theme-2d-file.vala"
								filetype_collection_length1 = _tmp7__length1;
#line 68 "theme-2d-file.vala"
								for (filetype_it = 0; filetype_it < filetype_collection_length1; filetype_it = filetype_it + 1) {
#line 727 "theme-2d-file.c"
									gchar* _tmp8_;
									gchar* filetype = NULL;
#line 68 "theme-2d-file.vala"
									_tmp8_ = g_strdup (filetype_collection[filetype_it]);
#line 68 "theme-2d-file.vala"
									filetype = _tmp8_;
#line 734 "theme-2d-file.c"
									{
										gchar* filepath = NULL;
										const gchar* _tmp9_;
										const gchar* _tmp10_;
										gchar* _tmp11_;
										gchar* _tmp12_;
										gchar* _tmp13_;
										gchar* _tmp14_;
										const gchar* _tmp15_;
#line 69 "theme-2d-file.vala"
										_tmp9_ = filename;
#line 69 "theme-2d-file.vala"
										_tmp10_ = filetype;
#line 69 "theme-2d-file.vala"
										_tmp11_ = g_strconcat (_tmp9_, _tmp10_, NULL);
#line 69 "theme-2d-file.vala"
										_tmp12_ = _tmp11_;
#line 69 "theme-2d-file.vala"
										_tmp13_ = g_build_filename (path, _tmp12_, NULL, NULL);
#line 69 "theme-2d-file.vala"
										_tmp14_ = _tmp13_;
#line 69 "theme-2d-file.vala"
										_g_free0 (_tmp12_);
#line 69 "theme-2d-file.vala"
										filepath = _tmp14_;
#line 70 "theme-2d-file.vala"
										_tmp15_ = filepath;
#line 70 "theme-2d-file.vala"
										if (g_file_test (_tmp15_, G_FILE_TEST_EXISTS)) {
#line 71 "theme-2d-file.vala"
											found = TRUE;
#line 72 "theme-2d-file.vala"
											_g_free0 (filepath);
#line 72 "theme-2d-file.vala"
											_g_free0 (filetype);
#line 72 "theme-2d-file.vala"
											break;
#line 772 "theme-2d-file.c"
										}
#line 68 "theme-2d-file.vala"
										_g_free0 (filepath);
#line 68 "theme-2d-file.vala"
										_g_free0 (filetype);
#line 778 "theme-2d-file.c"
									}
								}
							}
#line 75 "theme-2d-file.vala"
							if (found) {
#line 75 "theme-2d-file.vala"
								_g_free0 (filename);
#line 75 "theme-2d-file.vala"
								break;
#line 788 "theme-2d-file.c"
							}
#line 67 "theme-2d-file.vala"
							_g_free0 (filename);
#line 792 "theme-2d-file.c"
						}
					}
				}
#line 77 "theme-2d-file.vala"
				if (!found) {
#line 77 "theme-2d-file.vala"
					result = FALSE;
#line 77 "theme-2d-file.vala"
					filenames = (_vala_array_free (filenames, filenames_length1, (GDestroyNotify) g_free), NULL);
#line 77 "theme-2d-file.vala"
					_g_free0 (filename_alt);
#line 77 "theme-2d-file.vala"
					return result;
#line 806 "theme-2d-file.c"
				}
#line 63 "theme-2d-file.vala"
				filenames = (_vala_array_free (filenames, filenames_length1, (GDestroyNotify) g_free), NULL);
#line 63 "theme-2d-file.vala"
				_g_free0 (filename_alt);
#line 812 "theme-2d-file.c"
			}
		}
	}
#line 79 "theme-2d-file.vala"
	result = TRUE;
#line 79 "theme-2d-file.vala"
	return result;
#line 820 "theme-2d-file.c"
}

/**
     * Read theme.prop info into ThemeItem.
     * Return false if the theme is malformed.
     */
static gboolean
pasang_theme2_dfile_add_theme_info (PasangTheme2DFile* self,
                                    const gchar* path,
                                    PasangThemeItem* item)
{
	gchar* filepath = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	PasangTheme* _tmp14_;
	PasangTheme* _tmp15_;
	gboolean _tmp16_;
	gint size = 0;
	PasangPiece p = 0;
	gint frame_size = 0;
	GdkPixbuf** _tmp17_;
	gint _tmp17__length1;
	PasangPiece _tmp18_;
	GdkPixbuf* _tmp19_;
	gint* _tmp20_;
	gint _tmp20__length1;
	PasangPiece _tmp21_;
	gint _tmp22_;
	gint num_cols = 0;
	GdkPixbuf** _tmp23_;
	gint _tmp23__length1;
	PasangPiece _tmp24_;
	GdkPixbuf* _tmp25_;
	gint y = 0;
	PasangLayout2D _tmp26_;
	PasangPiece _tmp27_;
	gint _tmp28_;
	gint x = 0;
	PasangLayout2D _tmp29_;
	PasangPiece _tmp30_;
	gint _tmp31_;
	GdkPixbuf* pixbuf = NULL;
	GdkPixbuf** _tmp32_;
	gint _tmp32__length1;
	PasangPiece _tmp33_;
	GdkPixbuf* _tmp34_;
	GdkPixbuf* _tmp35_;
	GdkPixbuf* _tmp36_;
	GdkPixbuf* _tmp37_;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
#line 86 "theme-2d-file.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 86 "theme-2d-file.vala"
	g_return_val_if_fail (path != NULL, FALSE);
#line 86 "theme-2d-file.vala"
	g_return_val_if_fail (item != NULL, FALSE);
#line 87 "theme-2d-file.vala"
	_tmp0_ = g_build_filename (path, "theme.prop", NULL, NULL);
#line 87 "theme-2d-file.vala"
	filepath = _tmp0_;
#line 88 "theme-2d-file.vala"
	_tmp1_ = filepath;
#line 88 "theme-2d-file.vala"
	if (g_file_test (_tmp1_, G_FILE_TEST_EXISTS)) {
#line 886 "theme-2d-file.c"
		{
			GKeyFile* kf = NULL;
			GKeyFile* _tmp2_;
			GKeyFile* _tmp3_;
			const gchar* _tmp4_;
			GKeyFile* _tmp5_;
			GKeyFile* _tmp6_;
			GKeyFile* _tmp7_;
			GKeyFile* _tmp8_;
#line 90 "theme-2d-file.vala"
			_tmp2_ = g_key_file_new ();
#line 90 "theme-2d-file.vala"
			kf = _tmp2_;
#line 91 "theme-2d-file.vala"
			_tmp3_ = kf;
#line 91 "theme-2d-file.vala"
			_tmp4_ = filepath;
#line 91 "theme-2d-file.vala"
			g_key_file_load_from_file (_tmp3_, _tmp4_, G_KEY_FILE_NONE, &_inner_error0_);
#line 91 "theme-2d-file.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 91 "theme-2d-file.vala"
				_g_key_file_unref0 (kf);
#line 910 "theme-2d-file.c"
				goto __catch19_g_error;
			}
#line 92 "theme-2d-file.vala"
			_tmp5_ = kf;
#line 92 "theme-2d-file.vala"
			pasang_theme2_dfile_get_kf_string (self, _tmp5_, "Info", "Name", &(*item).name, &_inner_error0_);
#line 92 "theme-2d-file.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 92 "theme-2d-file.vala"
				_g_key_file_unref0 (kf);
#line 921 "theme-2d-file.c"
				goto __catch19_g_error;
			}
#line 93 "theme-2d-file.vala"
			_tmp6_ = kf;
#line 93 "theme-2d-file.vala"
			pasang_theme2_dfile_get_kf_string (self, _tmp6_, "Info", "Artist", &(*item).artist, &_inner_error0_);
#line 93 "theme-2d-file.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 93 "theme-2d-file.vala"
				_g_key_file_unref0 (kf);
#line 932 "theme-2d-file.c"
				goto __catch19_g_error;
			}
#line 94 "theme-2d-file.vala"
			_tmp7_ = kf;
#line 94 "theme-2d-file.vala"
			pasang_theme2_dfile_get_kf_string (self, _tmp7_, "Info", "License", &(*item).license, &_inner_error0_);
#line 94 "theme-2d-file.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 94 "theme-2d-file.vala"
				_g_key_file_unref0 (kf);
#line 943 "theme-2d-file.c"
				goto __catch19_g_error;
			}
#line 95 "theme-2d-file.vala"
			_tmp8_ = kf;
#line 95 "theme-2d-file.vala"
			pasang_theme2_dfile_get_kf_string (self, _tmp8_, "Info", "Comment", &(*item).comment, &_inner_error0_);
#line 95 "theme-2d-file.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 95 "theme-2d-file.vala"
				_g_key_file_unref0 (kf);
#line 954 "theme-2d-file.c"
				goto __catch19_g_error;
			}
#line 89 "theme-2d-file.vala"
			_g_key_file_unref0 (kf);
#line 959 "theme-2d-file.c"
		}
		goto __finally19;
		__catch19_g_error:
		{
			GError* e = NULL;
			FILE* _tmp9_;
			const gchar* _tmp10_;
			GError* _tmp11_;
			const gchar* _tmp12_;
#line 89 "theme-2d-file.vala"
			e = _inner_error0_;
#line 89 "theme-2d-file.vala"
			_inner_error0_ = NULL;
#line 98 "theme-2d-file.vala"
			_tmp9_ = stderr;
#line 98 "theme-2d-file.vala"
			_tmp10_ = filepath;
#line 98 "theme-2d-file.vala"
			_tmp11_ = e;
#line 98 "theme-2d-file.vala"
			_tmp12_ = _tmp11_->message;
#line 98 "theme-2d-file.vala"
			fprintf (_tmp9_, "Info error while reading %s: %s\n", _tmp10_, _tmp12_);
#line 99 "theme-2d-file.vala"
			result = FALSE;
#line 99 "theme-2d-file.vala"
			_g_error_free0 (e);
#line 99 "theme-2d-file.vala"
			_g_free0 (filepath);
#line 99 "theme-2d-file.vala"
			return result;
#line 991 "theme-2d-file.c"
		}
		__finally19:
#line 89 "theme-2d-file.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 996 "theme-2d-file.c"
			gboolean _tmp13_ = FALSE;
#line 89 "theme-2d-file.vala"
			_g_free0 (filepath);
#line 89 "theme-2d-file.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 89 "theme-2d-file.vala"
			g_clear_error (&_inner_error0_);
#line 89 "theme-2d-file.vala"
			return _tmp13_;
#line 1006 "theme-2d-file.c"
		}
	}
#line 104 "theme-2d-file.vala"
	_tmp14_ = pasang_theme_select ((PasangTheme*) self, path, 0, 0);
#line 104 "theme-2d-file.vala"
	_tmp15_ = _tmp14_;
#line 104 "theme-2d-file.vala"
	_tmp16_ = _tmp15_ == NULL;
#line 104 "theme-2d-file.vala"
	_g_object_unref0 (_tmp15_);
#line 104 "theme-2d-file.vala"
	if (_tmp16_) {
#line 104 "theme-2d-file.vala"
		result = FALSE;
#line 104 "theme-2d-file.vala"
		_g_free0 (filepath);
#line 104 "theme-2d-file.vala"
		return result;
#line 1025 "theme-2d-file.c"
	}
#line 107 "theme-2d-file.vala"
	size = 48;
#line 108 "theme-2d-file.vala"
	p = PASANG_PIECE_KAS_1;
#line 109 "theme-2d-file.vala"
	_tmp17_ = self->pixbufs;
#line 109 "theme-2d-file.vala"
	_tmp17__length1 = self->pixbufs_length1;
#line 109 "theme-2d-file.vala"
	_tmp18_ = p;
#line 109 "theme-2d-file.vala"
	_tmp19_ = _tmp17_[_tmp18_];
#line 109 "theme-2d-file.vala"
	_tmp20_ = ((PasangTheme2D*) self)->num_rows_in_image;
#line 109 "theme-2d-file.vala"
	_tmp20__length1 = ((PasangTheme2D*) self)->num_rows_in_image_length1;
#line 109 "theme-2d-file.vala"
	_tmp21_ = p;
#line 109 "theme-2d-file.vala"
	_tmp22_ = _tmp20_[_tmp21_];
#line 109 "theme-2d-file.vala"
	frame_size = gdk_pixbuf_get_height (_tmp19_) / _tmp22_;
#line 110 "theme-2d-file.vala"
	_tmp23_ = self->pixbufs;
#line 110 "theme-2d-file.vala"
	_tmp23__length1 = self->pixbufs_length1;
#line 110 "theme-2d-file.vala"
	_tmp24_ = p;
#line 110 "theme-2d-file.vala"
	_tmp25_ = _tmp23_[_tmp24_];
#line 110 "theme-2d-file.vala"
	num_cols = gdk_pixbuf_get_width (_tmp25_) / frame_size;
#line 111 "theme-2d-file.vala"
	_tmp26_ = ((PasangTheme2D*) self)->layout;
#line 111 "theme-2d-file.vala"
	_tmp27_ = p;
#line 111 "theme-2d-file.vala"
	_tmp28_ = _tmp26_.kas_frame[_tmp27_];
#line 111 "theme-2d-file.vala"
	y = (_tmp28_ / num_cols) * frame_size;
#line 112 "theme-2d-file.vala"
	_tmp29_ = ((PasangTheme2D*) self)->layout;
#line 112 "theme-2d-file.vala"
	_tmp30_ = p;
#line 112 "theme-2d-file.vala"
	_tmp31_ = _tmp29_.kas_frame[_tmp30_];
#line 112 "theme-2d-file.vala"
	x = (_tmp31_ % num_cols) * frame_size;
#line 114 "theme-2d-file.vala"
	_tmp32_ = self->pixbufs;
#line 114 "theme-2d-file.vala"
	_tmp32__length1 = self->pixbufs_length1;
#line 114 "theme-2d-file.vala"
	_tmp33_ = p;
#line 114 "theme-2d-file.vala"
	_tmp34_ = _tmp32_[_tmp33_];
#line 114 "theme-2d-file.vala"
	_tmp35_ = gdk_pixbuf_new_subpixbuf (_tmp34_, x, y, frame_size, frame_size);
#line 114 "theme-2d-file.vala"
	pixbuf = _tmp35_;
#line 116 "theme-2d-file.vala"
	_tmp36_ = pixbuf;
#line 116 "theme-2d-file.vala"
	_tmp37_ = gdk_pixbuf_scale_simple (_tmp36_, size, size, GDK_INTERP_BILINEAR);
#line 116 "theme-2d-file.vala"
	_g_object_unref0 ((*item).pixbuf);
#line 116 "theme-2d-file.vala"
	(*item).pixbuf = _tmp37_;
#line 117 "theme-2d-file.vala"
	result = TRUE;
#line 117 "theme-2d-file.vala"
	_g_object_unref0 (pixbuf);
#line 117 "theme-2d-file.vala"
	_g_free0 (filepath);
#line 117 "theme-2d-file.vala"
	return result;
#line 1103 "theme-2d-file.c"
}

static void
pasang_theme2_dfile_real_free (PasangTheme* base)
{
	PasangTheme2DFile * self;
#line 122 "theme-2d-file.vala"
	self = (PasangTheme2DFile*) base;
#line 123 "theme-2d-file.vala"
	PASANG_THEME_CLASS (pasang_theme2_dfile_parent_class)->free ((PasangTheme*) G_TYPE_CHECK_INSTANCE_CAST (self, PASANG_TYPE_THEME2_D, PasangTheme2D));
#line 1114 "theme-2d-file.c"
	{
		gint i = 0;
#line 124 "theme-2d-file.vala"
		i = 0;
#line 1119 "theme-2d-file.c"
		{
			gboolean _tmp0_ = FALSE;
#line 124 "theme-2d-file.vala"
			_tmp0_ = TRUE;
#line 124 "theme-2d-file.vala"
			while (TRUE) {
#line 1126 "theme-2d-file.c"
				GdkPixbuf** _tmp2_;
				gint _tmp2__length1;
				GdkPixbuf** _tmp3_;
				gint _tmp3__length1;
#line 124 "theme-2d-file.vala"
				if (!_tmp0_) {
#line 1133 "theme-2d-file.c"
					gint _tmp1_;
#line 124 "theme-2d-file.vala"
					_tmp1_ = i;
#line 124 "theme-2d-file.vala"
					i = _tmp1_ + 1;
#line 1139 "theme-2d-file.c"
				}
#line 124 "theme-2d-file.vala"
				_tmp0_ = FALSE;
#line 124 "theme-2d-file.vala"
				_tmp2_ = self->pixbufs;
#line 124 "theme-2d-file.vala"
				_tmp2__length1 = self->pixbufs_length1;
#line 124 "theme-2d-file.vala"
				if (!(i < _tmp2__length1)) {
#line 124 "theme-2d-file.vala"
					break;
#line 1151 "theme-2d-file.c"
				}
#line 124 "theme-2d-file.vala"
				_tmp3_ = self->pixbufs;
#line 124 "theme-2d-file.vala"
				_tmp3__length1 = self->pixbufs_length1;
#line 124 "theme-2d-file.vala"
				_g_object_unref0 (_tmp3_[i]);
#line 124 "theme-2d-file.vala"
				_tmp3_[i] = NULL;
#line 1161 "theme-2d-file.c"
			}
		}
	}
}

/**
     * Load theme files.
     * If width == 0, then we are actually only peeking for the purpose
     * of populating the theme menu.
     * Side-effect: pixbufs[], also imges[] through resize
     */
static PasangTheme*
pasang_theme2_dfile_real_select (PasangTheme* base,
                                 const gchar* path,
                                 gint width,
                                 gint height)
{
	PasangTheme2DFile * self;
	PasangLayout2D _tmp3_;
	gchar* filepath = NULL;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	PasangTheme* _tmp31_;
	GError* _inner_error0_ = NULL;
	PasangTheme* result = NULL;
#line 133 "theme-2d-file.vala"
	self = (PasangTheme2DFile*) base;
#line 133 "theme-2d-file.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 135 "theme-2d-file.vala"
	pasang_theme_set_time_span ((PasangTheme*) self, 1.3);
#line 1193 "theme-2d-file.c"
	{
		gint i = 0;
#line 136 "theme-2d-file.vala"
		i = 0;
#line 1198 "theme-2d-file.c"
		{
			gboolean _tmp0_ = FALSE;
#line 136 "theme-2d-file.vala"
			_tmp0_ = TRUE;
#line 136 "theme-2d-file.vala"
			while (TRUE) {
#line 1205 "theme-2d-file.c"
				gint* _tmp2_;
				gint _tmp2__length1;
#line 136 "theme-2d-file.vala"
				if (!_tmp0_) {
#line 1210 "theme-2d-file.c"
					gint _tmp1_;
#line 136 "theme-2d-file.vala"
					_tmp1_ = i;
#line 136 "theme-2d-file.vala"
					i = _tmp1_ + 1;
#line 1216 "theme-2d-file.c"
				}
#line 136 "theme-2d-file.vala"
				_tmp0_ = FALSE;
#line 136 "theme-2d-file.vala"
				if (!(i < ((gint) PASANG_PIECE_COUNT))) {
#line 136 "theme-2d-file.vala"
					break;
#line 1224 "theme-2d-file.c"
				}
#line 136 "theme-2d-file.vala"
				_tmp2_ = ((PasangTheme2D*) self)->num_rows_in_image;
#line 136 "theme-2d-file.vala"
				_tmp2__length1 = ((PasangTheme2D*) self)->num_rows_in_image_length1;
#line 136 "theme-2d-file.vala"
				_tmp2_[i] = 1;
#line 1232 "theme-2d-file.c"
			}
		}
	}
#line 137 "theme-2d-file.vala"
	_tmp3_ = ((PasangTheme2D*) self)->default_layout;
#line 137 "theme-2d-file.vala"
	((PasangTheme2D*) self)->layout = _tmp3_;
#line 139 "theme-2d-file.vala"
	((PasangTheme2D*) self)->layout_changed = TRUE;
#line 1242 "theme-2d-file.c"
	{
		gint i = 0;
#line 140 "theme-2d-file.vala"
		i = 0;
#line 1247 "theme-2d-file.c"
		{
			gboolean _tmp4_ = FALSE;
#line 140 "theme-2d-file.vala"
			_tmp4_ = TRUE;
#line 140 "theme-2d-file.vala"
			while (TRUE) {
#line 1254 "theme-2d-file.c"
				gchar** _tmp6_;
				gint _tmp6__length1;
				gint* _tmp7_;
				gint _tmp7__length1;
				GdkPixbuf** _tmp8_;
				gint _tmp8__length1;
				gchar** _tmp9_;
				gint _tmp9__length1;
				const gchar* _tmp10_;
				GdkPixbuf* _tmp11_;
				GdkPixbuf** _tmp12_;
				gint _tmp12__length1;
				GdkPixbuf* _tmp13_;
#line 140 "theme-2d-file.vala"
				if (!_tmp4_) {
#line 1270 "theme-2d-file.c"
					gint _tmp5_;
#line 140 "theme-2d-file.vala"
					_tmp5_ = i;
#line 140 "theme-2d-file.vala"
					i = _tmp5_ + 1;
#line 1276 "theme-2d-file.c"
				}
#line 140 "theme-2d-file.vala"
				_tmp4_ = FALSE;
#line 140 "theme-2d-file.vala"
				_tmp6_ = self->priv->filename_alts;
#line 140 "theme-2d-file.vala"
				_tmp6__length1 = self->priv->filename_alts_length1;
#line 140 "theme-2d-file.vala"
				if (!(i < _tmp6__length1)) {
#line 140 "theme-2d-file.vala"
					break;
#line 1288 "theme-2d-file.c"
				}
#line 141 "theme-2d-file.vala"
				_tmp7_ = ((PasangTheme*) self)->cycles;
#line 141 "theme-2d-file.vala"
				_tmp7__length1 = ((PasangTheme*) self)->cycles_length1;
#line 141 "theme-2d-file.vala"
				_tmp7_[i] = 0;
#line 142 "theme-2d-file.vala"
				_tmp8_ = self->pixbufs;
#line 142 "theme-2d-file.vala"
				_tmp8__length1 = self->pixbufs_length1;
#line 142 "theme-2d-file.vala"
				_tmp9_ = self->priv->filename_alts;
#line 142 "theme-2d-file.vala"
				_tmp9__length1 = self->priv->filename_alts_length1;
#line 142 "theme-2d-file.vala"
				_tmp10_ = _tmp9_[i];
#line 142 "theme-2d-file.vala"
				_tmp11_ = pasang_theme2_dfile_load_as_pixbuf (self, path, _tmp10_);
#line 142 "theme-2d-file.vala"
				_g_object_unref0 (_tmp8_[i]);
#line 142 "theme-2d-file.vala"
				_tmp8_[i] = _tmp11_;
#line 143 "theme-2d-file.vala"
				_tmp12_ = self->pixbufs;
#line 143 "theme-2d-file.vala"
				_tmp12__length1 = self->pixbufs_length1;
#line 143 "theme-2d-file.vala"
				_tmp13_ = _tmp12_[i];
#line 143 "theme-2d-file.vala"
				if (_tmp13_ == NULL) {
#line 143 "theme-2d-file.vala"
					result = NULL;
#line 143 "theme-2d-file.vala"
					return result;
#line 1324 "theme-2d-file.c"
				}
			}
		}
	}
#line 147 "theme-2d-file.vala"
	self->priv->old_theme = TRUE;
#line 148 "theme-2d-file.vala"
	pasang_theme2_dfile_get_kf_layout (self, NULL);
#line 149 "theme-2d-file.vala"
	_tmp14_ = g_build_filename (path, "theme.prop", NULL, NULL);
#line 149 "theme-2d-file.vala"
	filepath = _tmp14_;
#line 150 "theme-2d-file.vala"
	_tmp15_ = filepath;
#line 150 "theme-2d-file.vala"
	if (g_file_test (_tmp15_, G_FILE_TEST_EXISTS)) {
#line 1341 "theme-2d-file.c"
		{
			GKeyFile* kf = NULL;
			GKeyFile* _tmp16_;
			GKeyFile* _tmp17_;
			const gchar* _tmp18_;
			GKeyFile* _tmp19_;
			gboolean _tmp20_ = FALSE;
			GKeyFile* _tmp21_;
			GKeyFile* _tmp24_;
			GKeyFile* _tmp25_;
			GKeyFile* _tmp26_;
#line 152 "theme-2d-file.vala"
			_tmp16_ = g_key_file_new ();
#line 152 "theme-2d-file.vala"
			kf = _tmp16_;
#line 153 "theme-2d-file.vala"
			_tmp17_ = kf;
#line 153 "theme-2d-file.vala"
			_tmp18_ = filepath;
#line 153 "theme-2d-file.vala"
			g_key_file_load_from_file (_tmp17_, _tmp18_, G_KEY_FILE_NONE, &_inner_error0_);
#line 153 "theme-2d-file.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 153 "theme-2d-file.vala"
				_g_key_file_unref0 (kf);
#line 1367 "theme-2d-file.c"
				goto __catch20_g_error;
			}
#line 154 "theme-2d-file.vala"
			_tmp19_ = kf;
#line 154 "theme-2d-file.vala"
			pasang_theme2_dfile_get_kf_integer_list (self, _tmp19_, "View", "Repeat", &((PasangTheme*) self)->cycles, (gint*) (&((PasangTheme*) self)->cycles_length1), &_inner_error0_);
#line 154 "theme-2d-file.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 154 "theme-2d-file.vala"
				_g_key_file_unref0 (kf);
#line 1378 "theme-2d-file.c"
				goto __catch20_g_error;
			}
#line 155 "theme-2d-file.vala"
			_tmp21_ = kf;
#line 155 "theme-2d-file.vala"
			_tmp20_ = g_key_file_has_key (_tmp21_, "View", "Span", &_inner_error0_);
#line 155 "theme-2d-file.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 155 "theme-2d-file.vala"
				_g_key_file_unref0 (kf);
#line 1389 "theme-2d-file.c"
				goto __catch20_g_error;
			}
#line 155 "theme-2d-file.vala"
			if (_tmp20_) {
#line 1394 "theme-2d-file.c"
				gdouble val = 0.0;
				GKeyFile* _tmp22_;
				gboolean _tmp23_ = FALSE;
#line 156 "theme-2d-file.vala"
				_tmp22_ = kf;
#line 156 "theme-2d-file.vala"
				val = g_key_file_get_double (_tmp22_, "View", "Span", &_inner_error0_);
#line 156 "theme-2d-file.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 156 "theme-2d-file.vala"
					_g_key_file_unref0 (kf);
#line 1406 "theme-2d-file.c"
					goto __catch20_g_error;
				}
#line 157 "theme-2d-file.vala"
				if (val > ((gdouble) 1)) {
#line 157 "theme-2d-file.vala"
					_tmp23_ = val <= ((gdouble) 5);
#line 1413 "theme-2d-file.c"
				} else {
#line 157 "theme-2d-file.vala"
					_tmp23_ = FALSE;
#line 1417 "theme-2d-file.c"
				}
#line 157 "theme-2d-file.vala"
				if (_tmp23_) {
#line 157 "theme-2d-file.vala"
					pasang_theme_set_time_span ((PasangTheme*) self, val);
#line 1423 "theme-2d-file.c"
				}
			}
#line 159 "theme-2d-file.vala"
			_tmp24_ = kf;
#line 159 "theme-2d-file.vala"
			pasang_theme2_dfile_get_kf_integer_list (self, _tmp24_, "View", "Rows", &((PasangTheme2D*) self)->num_rows_in_image, (gint*) (&((PasangTheme2D*) self)->num_rows_in_image_length1), &_inner_error0_);
#line 159 "theme-2d-file.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 159 "theme-2d-file.vala"
				_g_key_file_unref0 (kf);
#line 1434 "theme-2d-file.c"
				goto __catch20_g_error;
			}
#line 160 "theme-2d-file.vala"
			_tmp25_ = kf;
#line 160 "theme-2d-file.vala"
			if (g_key_file_has_group (_tmp25_, "Layout")) {
#line 160 "theme-2d-file.vala"
				self->priv->old_theme = FALSE;
#line 1443 "theme-2d-file.c"
			}
#line 161 "theme-2d-file.vala"
			_tmp26_ = kf;
#line 161 "theme-2d-file.vala"
			pasang_theme2_dfile_get_kf_layout (self, _tmp26_);
#line 151 "theme-2d-file.vala"
			_g_key_file_unref0 (kf);
#line 1451 "theme-2d-file.c"
		}
		goto __finally20;
		__catch20_g_error:
		{
			GError* e = NULL;
			FILE* _tmp27_;
			const gchar* _tmp28_;
			GError* _tmp29_;
			const gchar* _tmp30_;
#line 151 "theme-2d-file.vala"
			e = _inner_error0_;
#line 151 "theme-2d-file.vala"
			_inner_error0_ = NULL;
#line 164 "theme-2d-file.vala"
			_tmp27_ = stderr;
#line 164 "theme-2d-file.vala"
			_tmp28_ = filepath;
#line 164 "theme-2d-file.vala"
			_tmp29_ = e;
#line 164 "theme-2d-file.vala"
			_tmp30_ = _tmp29_->message;
#line 164 "theme-2d-file.vala"
			fprintf (_tmp27_, "File error while reading %s: %s\n", _tmp28_, _tmp30_);
#line 151 "theme-2d-file.vala"
			_g_error_free0 (e);
#line 1477 "theme-2d-file.c"
		}
		__finally20:
#line 151 "theme-2d-file.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 151 "theme-2d-file.vala"
			_g_free0 (filepath);
#line 151 "theme-2d-file.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 151 "theme-2d-file.vala"
			g_clear_error (&_inner_error0_);
#line 151 "theme-2d-file.vala"
			return NULL;
#line 1490 "theme-2d-file.c"
		}
	}
#line 168 "theme-2d-file.vala"
	if (width != 0) {
#line 169 "theme-2d-file.vala"
		pasang_theme_resize ((PasangTheme*) self, width, height);
#line 1497 "theme-2d-file.c"
	}
#line 171 "theme-2d-file.vala"
	_tmp31_ = _g_object_ref0 ((PasangTheme*) self);
#line 171 "theme-2d-file.vala"
	result = _tmp31_;
#line 171 "theme-2d-file.vala"
	_g_free0 (filepath);
#line 171 "theme-2d-file.vala"
	return result;
#line 1507 "theme-2d-file.c"
}

/**
     * Load <file name + any recognized extension> and return as a Pixbuf
     */
static GdkPixbuf*
pasang_theme2_dfile_load_as_pixbuf (PasangTheme2DFile* self,
                                    const gchar* path,
                                    const gchar* filename_alt)
{
	GError* _inner_error0_ = NULL;
	GdkPixbuf* result = NULL;
#line 177 "theme-2d-file.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 177 "theme-2d-file.vala"
	g_return_val_if_fail (path != NULL, NULL);
#line 177 "theme-2d-file.vala"
	g_return_val_if_fail (filename_alt != NULL, NULL);
#line 1526 "theme-2d-file.c"
	{
		gchar** filenames = NULL;
		gchar** _tmp0_;
		gchar** _tmp1_;
		gint filenames_length1;
		gint _filenames_size_;
		gchar** _tmp2_;
		gint _tmp2__length1;
#line 179 "theme-2d-file.vala"
		_tmp1_ = _tmp0_ = g_strsplit (filename_alt, "|", 0);
#line 179 "theme-2d-file.vala"
		filenames = _tmp1_;
#line 179 "theme-2d-file.vala"
		filenames_length1 = _vala_array_length (_tmp0_);
#line 179 "theme-2d-file.vala"
		_filenames_size_ = filenames_length1;
#line 180 "theme-2d-file.vala"
		_tmp2_ = filenames;
#line 180 "theme-2d-file.vala"
		_tmp2__length1 = filenames_length1;
#line 1547 "theme-2d-file.c"
		{
			gchar** filename_collection = NULL;
			gint filename_collection_length1 = 0;
			gint _filename_collection_size_ = 0;
			gint filename_it = 0;
#line 180 "theme-2d-file.vala"
			filename_collection = _tmp2_;
#line 180 "theme-2d-file.vala"
			filename_collection_length1 = _tmp2__length1;
#line 180 "theme-2d-file.vala"
			for (filename_it = 0; filename_it < filename_collection_length1; filename_it = filename_it + 1) {
#line 1559 "theme-2d-file.c"
				gchar* _tmp3_;
				gchar* filename = NULL;
#line 180 "theme-2d-file.vala"
				_tmp3_ = g_strdup (filename_collection[filename_it]);
#line 180 "theme-2d-file.vala"
				filename = _tmp3_;
#line 1566 "theme-2d-file.c"
				{
					gchar** _tmp4_;
					gint _tmp4__length1;
#line 181 "theme-2d-file.vala"
					_tmp4_ = self->priv->filetypes;
#line 181 "theme-2d-file.vala"
					_tmp4__length1 = self->priv->filetypes_length1;
#line 1574 "theme-2d-file.c"
					{
						gchar** filetype_collection = NULL;
						gint filetype_collection_length1 = 0;
						gint _filetype_collection_size_ = 0;
						gint filetype_it = 0;
#line 181 "theme-2d-file.vala"
						filetype_collection = _tmp4_;
#line 181 "theme-2d-file.vala"
						filetype_collection_length1 = _tmp4__length1;
#line 181 "theme-2d-file.vala"
						for (filetype_it = 0; filetype_it < filetype_collection_length1; filetype_it = filetype_it + 1) {
#line 1586 "theme-2d-file.c"
							gchar* _tmp5_;
							gchar* filetype = NULL;
#line 181 "theme-2d-file.vala"
							_tmp5_ = g_strdup (filetype_collection[filetype_it]);
#line 181 "theme-2d-file.vala"
							filetype = _tmp5_;
#line 1593 "theme-2d-file.c"
							{
								gchar* filepath = NULL;
								const gchar* _tmp6_;
								const gchar* _tmp7_;
								gchar* _tmp8_;
								gchar* _tmp9_;
								gchar* _tmp10_;
								gchar* _tmp11_;
								const gchar* _tmp12_;
#line 182 "theme-2d-file.vala"
								_tmp6_ = filename;
#line 182 "theme-2d-file.vala"
								_tmp7_ = filetype;
#line 182 "theme-2d-file.vala"
								_tmp8_ = g_strconcat (_tmp6_, _tmp7_, NULL);
#line 182 "theme-2d-file.vala"
								_tmp9_ = _tmp8_;
#line 182 "theme-2d-file.vala"
								_tmp10_ = g_build_filename (path, _tmp9_, NULL, NULL);
#line 182 "theme-2d-file.vala"
								_tmp11_ = _tmp10_;
#line 182 "theme-2d-file.vala"
								_g_free0 (_tmp9_);
#line 182 "theme-2d-file.vala"
								filepath = _tmp11_;
#line 183 "theme-2d-file.vala"
								_tmp12_ = filepath;
#line 183 "theme-2d-file.vala"
								if (g_file_test (_tmp12_, G_FILE_TEST_EXISTS)) {
#line 1623 "theme-2d-file.c"
									GdkPixbuf* _tmp13_ = NULL;
									const gchar* _tmp14_;
									GdkPixbuf* _tmp15_;
									GdkPixbuf* _tmp16_;
#line 184 "theme-2d-file.vala"
									_tmp14_ = filepath;
#line 184 "theme-2d-file.vala"
									_tmp15_ = gdk_pixbuf_new_from_file (_tmp14_, &_inner_error0_);
#line 184 "theme-2d-file.vala"
									_tmp13_ = _tmp15_;
#line 184 "theme-2d-file.vala"
									if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 184 "theme-2d-file.vala"
										_g_free0 (filepath);
#line 184 "theme-2d-file.vala"
										_g_free0 (filetype);
#line 184 "theme-2d-file.vala"
										_g_free0 (filename);
#line 184 "theme-2d-file.vala"
										filenames = (_vala_array_free (filenames, filenames_length1, (GDestroyNotify) g_free), NULL);
#line 1644 "theme-2d-file.c"
										goto __catch21_g_error;
									}
#line 184 "theme-2d-file.vala"
									_tmp16_ = _tmp13_;
#line 184 "theme-2d-file.vala"
									_tmp13_ = NULL;
#line 184 "theme-2d-file.vala"
									result = _tmp16_;
#line 184 "theme-2d-file.vala"
									_g_object_unref0 (_tmp13_);
#line 184 "theme-2d-file.vala"
									_g_free0 (filepath);
#line 184 "theme-2d-file.vala"
									_g_free0 (filetype);
#line 184 "theme-2d-file.vala"
									_g_free0 (filename);
#line 184 "theme-2d-file.vala"
									filenames = (_vala_array_free (filenames, filenames_length1, (GDestroyNotify) g_free), NULL);
#line 184 "theme-2d-file.vala"
									return result;
#line 1665 "theme-2d-file.c"
								}
#line 181 "theme-2d-file.vala"
								_g_free0 (filepath);
#line 181 "theme-2d-file.vala"
								_g_free0 (filetype);
#line 1671 "theme-2d-file.c"
							}
						}
					}
#line 180 "theme-2d-file.vala"
					_g_free0 (filename);
#line 1677 "theme-2d-file.c"
				}
			}
		}
#line 178 "theme-2d-file.vala"
		filenames = (_vala_array_free (filenames, filenames_length1, (GDestroyNotify) g_free), NULL);
#line 1683 "theme-2d-file.c"
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError* e = NULL;
		FILE* _tmp17_;
		GError* _tmp18_;
		const gchar* _tmp19_;
#line 178 "theme-2d-file.vala"
		e = _inner_error0_;
#line 178 "theme-2d-file.vala"
		_inner_error0_ = NULL;
#line 190 "theme-2d-file.vala"
		_tmp17_ = stderr;
#line 190 "theme-2d-file.vala"
		_tmp18_ = e;
#line 190 "theme-2d-file.vala"
		_tmp19_ = _tmp18_->message;
#line 190 "theme-2d-file.vala"
		fprintf (_tmp17_, "File error: %s\n", _tmp19_);
#line 191 "theme-2d-file.vala"
		pasang_theme_free ((PasangTheme*) self);
#line 178 "theme-2d-file.vala"
		_g_error_free0 (e);
#line 1708 "theme-2d-file.c"
	}
	__finally21:
#line 178 "theme-2d-file.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 178 "theme-2d-file.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 178 "theme-2d-file.vala"
		g_clear_error (&_inner_error0_);
#line 178 "theme-2d-file.vala"
		return NULL;
#line 1719 "theme-2d-file.c"
	}
#line 193 "theme-2d-file.vala"
	result = NULL;
#line 193 "theme-2d-file.vala"
	return result;
#line 1725 "theme-2d-file.c"
}

/**
     * Read the layout from the KeyFile. If kf is null or values are not available,
     * simply set them to some defaults.
     */
static void
pasang_theme2_dfile_get_kf_layout (PasangTheme2DFile* self,
                                   GKeyFile* kf)
{
	GError* _inner_error0_ = NULL;
#line 200 "theme-2d-file.vala"
	g_return_if_fail (self != NULL);
#line 1739 "theme-2d-file.c"
	{
		gint image_width = 0;
		GdkPixbuf** _tmp0_;
		gint _tmp0__length1;
		GdkPixbuf* _tmp1_;
		gint image_height = 0;
		GdkPixbuf** _tmp2_;
		gint _tmp2__length1;
		GdkPixbuf* _tmp3_;
		gint* table = NULL;
		gint* _tmp4_;
		gint table_length1;
		gint _table_size_;
		gint* _tmp5_;
		gint _tmp5__length1;
		gint _tmp6_;
		gint* _tmp7_;
		gint _tmp7__length1;
		gint _tmp8_;
		gint* _tmp9_;
		gint _tmp9__length1;
		gint _tmp10_;
		gint* _tmp11_;
		gint _tmp11__length1;
		gint _tmp12_;
		gint* _tmp13_;
		gint _tmp13__length1;
		gint _tmp14_;
		gint* _tmp15_;
		gint _tmp15__length1;
		gint _tmp16_;
		gint* _tmp17_;
		gint _tmp17__length1;
		gint _tmp18_;
		gint* _tmp19_;
		gint _tmp19__length1;
		gint _tmp20_;
		gdouble grid_size = 0.0;
		PasangLayout2D _tmp21_;
		gint corner1x = 0;
		PasangLayout2D _tmp22_;
		gint corner1y = 0;
		PasangLayout2D _tmp23_;
		gint corner2x = 0;
		PasangLayout2D _tmp24_;
		gint* grid = NULL;
		gint* _tmp25_;
		gint grid_length1;
		gint _grid_size_;
		gint* _tmp26_;
		gint _tmp26__length1;
		gint _tmp27_;
		gint* _tmp28_;
		gint _tmp28__length1;
		gint _tmp29_;
		PasangLayout2D _tmp30_;
		gint* _tmp31_;
		gint _tmp31__length1;
		gint _tmp32_;
		PasangLayout2D _tmp33_;
		gint* _tmp34_;
		gint _tmp34__length1;
		gint _tmp35_;
		PasangLayout2D _tmp36_;
		gint x = 0;
		PasangLayout2D _tmp37_;
		PasangLayout2D _tmp38_;
		PasangLayout2D _tmp39_;
		gint y0 = 0;
		PasangLayout2D _tmp40_;
		PasangLayout2D _tmp41_;
		gint y1 = 0;
		PasangLayout2D _tmp42_;
		PasangLayout2D _tmp43_;
		gint* pt = NULL;
		gint* _tmp44_;
		gint pt_length1;
		gint _pt_size_;
		gint* _tmp45_;
		gint _tmp45__length1;
		gint _tmp46_;
		PasangLayout2D _tmp47_;
		gint* _tmp48_;
		gint _tmp48__length1;
		gint _tmp49_;
		PasangLayout2D _tmp50_;
		gint _tmp51_[2] = {0};
		gint* _tmp52_;
		gint _tmp52__length1;
		gint _tmp53_;
		PasangLayout2D _tmp54_;
		gint* _tmp55_;
		gint _tmp55__length1;
		gint _tmp56_;
		PasangLayout2D _tmp57_;
		gint _tmp58_[2] = {0};
		gint* font = NULL;
		gint* _tmp59_;
		gint font_length1;
		gint _font_size_;
		gint* _tmp60_;
		gint _tmp60__length1;
		gint _tmp61_;
		gint* _tmp62_;
		gint _tmp62__length1;
		gint _tmp63_;
		gint* _tmp64_;
		gint _tmp64__length1;
		gint _tmp65_;
		gint* _tmp66_;
		gint _tmp66__length1;
		gint _tmp67_;
		gint* _tmp68_;
		gint _tmp68__length1;
		gint _tmp69_;
		gint* _tmp70_;
		gint _tmp70__length1;
		gint* _tmp71_;
		gint _tmp71__length1;
		gint* _tmp72_;
		gint _tmp72__length1;
		gint _tmp73_;
		PasangLayout2D _tmp74_;
		gint* _tmp75_;
		gint _tmp75__length1;
		gint _tmp76_;
		PasangLayout2D _tmp77_;
		gint _tmp78_[2] = {0};
		gint* _tmp79_;
		gint _tmp79__length1;
		gint _tmp80_;
		PasangLayout2D _tmp81_;
		gint* _tmp82_;
		gint _tmp82__length1;
		gint _tmp83_;
		PasangLayout2D _tmp84_;
		gint _tmp85_[2] = {0};
		gint* _tmp86_;
		gint* _tmp87_;
		gint _tmp87__length1;
		gint _tmp88_;
		gint* _tmp89_;
		gint _tmp89__length1;
		gint _tmp90_;
		gint* _tmp91_;
		gint _tmp91__length1;
		gint _tmp92_;
		gint* _tmp93_;
		gint _tmp93__length1;
		gint _tmp94_;
		gint* _tmp95_;
		gint _tmp95__length1;
		gint _tmp96_;
		PasangRgb _tmp97_ = {0};
		gint* _tmp98_;
		gint _tmp98__length1;
		gint _tmp99_;
		gint* _tmp100_;
		gint _tmp100__length1;
		gint _tmp101_;
		gint* _tmp102_;
		gint _tmp102__length1;
		gint _tmp103_;
		gint* _tmp104_;
		gint _tmp104__length1;
		gint _tmp105_;
		PasangRgb _tmp106_ = {0};
		PasangRgb _tmp107_[2] = {0};
		gint* _tmp108_;
		gint _tmp108__length1;
		gint* _tmp109_;
		gint _tmp109__length1;
		gint* _tmp110_;
		gint _tmp110__length1;
		gint _tmp111_;
		PasangLayout2D _tmp112_;
		gint* _tmp113_;
		gint _tmp113__length1;
		gint _tmp114_;
		PasangLayout2D _tmp115_;
		gint _tmp116_[2] = {0};
		gint* _tmp117_;
		gint _tmp117__length1;
		gint _tmp118_;
		PasangLayout2D _tmp119_;
		gint* _tmp120_;
		gint _tmp120__length1;
		gint _tmp121_;
		PasangLayout2D _tmp122_;
		gint _tmp123_[2] = {0};
		gint* kas_frame = NULL;
		gint* _tmp124_;
		gint kas_frame_length1;
		gint _kas_frame_size_;
		gint* _tmp125_;
		gint _tmp125__length1;
		gint* _tmp126_;
		gint _tmp126__length1;
		gint _tmp127_;
		gint* _tmp128_;
		gint _tmp128__length1;
		gint _tmp129_;
		gint* _tmp130_;
		gint _tmp130__length1;
		gint _tmp131_;
		gint* _tmp132_;
		gint _tmp132__length1;
		gint _tmp133_;
		gint* _tmp134_;
		gint* _tmp135_;
		gint _tmp135__length1;
		gint _tmp136_;
		PasangLayout2D _tmp137_;
		gint* _tmp138_;
		gint _tmp138__length1;
		gint _tmp139_;
		PasangLayout2D _tmp140_;
		gint* _tmp141_;
		gint _tmp141__length1;
		gint _tmp142_;
		gint* _tmp143_;
		gint* _tmp144_;
		gint _tmp144__length1;
		gint _tmp145_;
		gint* _tmp146_;
		gint _tmp146__length1;
		gint _tmp147_;
		gint* _tmp148_;
		gint _tmp148__length1;
		gint _tmp149_;
		gint* _tmp150_;
		gint _tmp150__length1;
		gint _tmp151_;
		gint* _tmp152_;
		gint _tmp152__length1;
		gint _tmp153_;
#line 202 "theme-2d-file.vala"
		_tmp0_ = self->pixbufs;
#line 202 "theme-2d-file.vala"
		_tmp0__length1 = self->pixbufs_length1;
#line 202 "theme-2d-file.vala"
		_tmp1_ = _tmp0_[PASANG_PIECE_BOARD];
#line 202 "theme-2d-file.vala"
		image_width = gdk_pixbuf_get_width (_tmp1_);
#line 203 "theme-2d-file.vala"
		_tmp2_ = self->pixbufs;
#line 203 "theme-2d-file.vala"
		_tmp2__length1 = self->pixbufs_length1;
#line 203 "theme-2d-file.vala"
		_tmp3_ = _tmp2_[PASANG_PIECE_BOARD];
#line 203 "theme-2d-file.vala"
		image_height = gdk_pixbuf_get_height (_tmp3_);
#line 207 "theme-2d-file.vala"
		_tmp4_ = g_new0 (gint, 4);
#line 207 "theme-2d-file.vala"
		_tmp4_[0] = 0;
#line 207 "theme-2d-file.vala"
		_tmp4_[1] = 0;
#line 207 "theme-2d-file.vala"
		_tmp4_[2] = image_width;
#line 207 "theme-2d-file.vala"
		_tmp4_[3] = image_height;
#line 207 "theme-2d-file.vala"
		table = _tmp4_;
#line 207 "theme-2d-file.vala"
		table_length1 = 4;
#line 207 "theme-2d-file.vala"
		_table_size_ = table_length1;
#line 208 "theme-2d-file.vala"
		pasang_theme2_dfile_get_kf_integer_list (self, kf, "Layout", "Table", &table, (gint*) (&table_length1), &_inner_error0_);
#line 208 "theme-2d-file.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 208 "theme-2d-file.vala"
			table = (g_free (table), NULL);
#line 2014 "theme-2d-file.c"
			goto __catch22_g_error;
		}
#line 209 "theme-2d-file.vala"
		_tmp5_ = table;
#line 209 "theme-2d-file.vala"
		_tmp5__length1 = table_length1;
#line 209 "theme-2d-file.vala"
		_tmp6_ = _tmp5_[0];
#line 209 "theme-2d-file.vala"
		((PasangTheme2D*) self)->layout.filler_left = _tmp6_;
#line 210 "theme-2d-file.vala"
		_tmp7_ = table;
#line 210 "theme-2d-file.vala"
		_tmp7__length1 = table_length1;
#line 210 "theme-2d-file.vala"
		_tmp8_ = _tmp7_[1];
#line 210 "theme-2d-file.vala"
		((PasangTheme2D*) self)->layout.filler_top = _tmp8_;
#line 211 "theme-2d-file.vala"
		_tmp9_ = table;
#line 211 "theme-2d-file.vala"
		_tmp9__length1 = table_length1;
#line 211 "theme-2d-file.vala"
		_tmp10_ = _tmp9_[2];
#line 211 "theme-2d-file.vala"
		((PasangTheme2D*) self)->layout.filler_right = image_width - _tmp10_;
#line 212 "theme-2d-file.vala"
		_tmp11_ = table;
#line 212 "theme-2d-file.vala"
		_tmp11__length1 = table_length1;
#line 212 "theme-2d-file.vala"
		_tmp12_ = _tmp11_[3];
#line 212 "theme-2d-file.vala"
		((PasangTheme2D*) self)->layout.filler_bottom = image_height - _tmp12_;
#line 213 "theme-2d-file.vala"
		_tmp13_ = table;
#line 213 "theme-2d-file.vala"
		_tmp13__length1 = table_length1;
#line 213 "theme-2d-file.vala"
		_tmp14_ = _tmp13_[2];
#line 213 "theme-2d-file.vala"
		_tmp15_ = table;
#line 213 "theme-2d-file.vala"
		_tmp15__length1 = table_length1;
#line 213 "theme-2d-file.vala"
		_tmp16_ = _tmp15_[0];
#line 213 "theme-2d-file.vala"
		((PasangTheme2D*) self)->layout.width = (_tmp14_ - _tmp16_) + 1;
#line 214 "theme-2d-file.vala"
		_tmp17_ = table;
#line 214 "theme-2d-file.vala"
		_tmp17__length1 = table_length1;
#line 214 "theme-2d-file.vala"
		_tmp18_ = _tmp17_[3];
#line 214 "theme-2d-file.vala"
		_tmp19_ = table;
#line 214 "theme-2d-file.vala"
		_tmp19__length1 = table_length1;
#line 214 "theme-2d-file.vala"
		_tmp20_ = _tmp19_[1];
#line 214 "theme-2d-file.vala"
		((PasangTheme2D*) self)->layout.height = (_tmp18_ - _tmp20_) + 1;
#line 218 "theme-2d-file.vala"
		_tmp21_ = ((PasangTheme2D*) self)->layout;
#line 218 "theme-2d-file.vala"
		grid_size = ((gdouble) _tmp21_.height) / PASANG_BOARD_WIDTH;
#line 222 "theme-2d-file.vala"
		_tmp22_ = ((PasangTheme2D*) self)->layout;
#line 222 "theme-2d-file.vala"
		corner1x = ((gint) (1.5 * grid_size)) + _tmp22_.filler_left;
#line 223 "theme-2d-file.vala"
		_tmp23_ = ((PasangTheme2D*) self)->layout;
#line 223 "theme-2d-file.vala"
		corner1y = ((gint) (1.5 * grid_size)) + _tmp23_.filler_top;
#line 224 "theme-2d-file.vala"
		_tmp24_ = ((PasangTheme2D*) self)->layout;
#line 224 "theme-2d-file.vala"
		corner2x = ((gint) (11.5 * grid_size)) + _tmp24_.filler_left;
#line 225 "theme-2d-file.vala"
		_tmp25_ = g_new0 (gint, 3);
#line 225 "theme-2d-file.vala"
		_tmp25_[0] = corner1x;
#line 225 "theme-2d-file.vala"
		_tmp25_[1] = corner1y;
#line 225 "theme-2d-file.vala"
		_tmp25_[2] = corner2x;
#line 225 "theme-2d-file.vala"
		grid = _tmp25_;
#line 225 "theme-2d-file.vala"
		grid_length1 = 3;
#line 225 "theme-2d-file.vala"
		_grid_size_ = grid_length1;
#line 226 "theme-2d-file.vala"
		pasang_theme2_dfile_get_kf_integer_list (self, kf, "Layout", "Grid", &grid, (gint*) (&grid_length1), &_inner_error0_);
#line 226 "theme-2d-file.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 226 "theme-2d-file.vala"
			grid = (g_free (grid), NULL);
#line 226 "theme-2d-file.vala"
			table = (g_free (table), NULL);
#line 2115 "theme-2d-file.c"
			goto __catch22_g_error;
		}
#line 227 "theme-2d-file.vala"
		_tmp26_ = grid;
#line 227 "theme-2d-file.vala"
		_tmp26__length1 = grid_length1;
#line 227 "theme-2d-file.vala"
		_tmp27_ = _tmp26_[2];
#line 227 "theme-2d-file.vala"
		_tmp28_ = grid;
#line 227 "theme-2d-file.vala"
		_tmp28__length1 = grid_length1;
#line 227 "theme-2d-file.vala"
		_tmp29_ = _tmp28_[0];
#line 227 "theme-2d-file.vala"
		((PasangTheme2D*) self)->layout.board_size = (((_tmp27_ - _tmp29_) + 1) * PASANG_BOARD_WIDTH) / (PASANG_BOARD_WIDTH - 3);
#line 228 "theme-2d-file.vala"
		_tmp30_ = ((PasangTheme2D*) self)->layout;
#line 228 "theme-2d-file.vala"
		grid_size = ((gdouble) _tmp30_.board_size) / PASANG_BOARD_WIDTH;
#line 229 "theme-2d-file.vala"
		_tmp31_ = grid;
#line 229 "theme-2d-file.vala"
		_tmp31__length1 = grid_length1;
#line 229 "theme-2d-file.vala"
		_tmp32_ = _tmp31_[0];
#line 229 "theme-2d-file.vala"
		_tmp33_ = ((PasangTheme2D*) self)->layout;
#line 229 "theme-2d-file.vala"
		((PasangTheme2D*) self)->layout.board_x = ((gint) (_tmp32_ - (1.5 * grid_size))) - _tmp33_.filler_left;
#line 230 "theme-2d-file.vala"
		_tmp34_ = grid;
#line 230 "theme-2d-file.vala"
		_tmp34__length1 = grid_length1;
#line 230 "theme-2d-file.vala"
		_tmp35_ = _tmp34_[1];
#line 230 "theme-2d-file.vala"
		_tmp36_ = ((PasangTheme2D*) self)->layout;
#line 230 "theme-2d-file.vala"
		((PasangTheme2D*) self)->layout.board_y = ((gint) (_tmp35_ - (1.5 * grid_size))) - _tmp36_.filler_top;
#line 234 "theme-2d-file.vala"
		_tmp37_ = ((PasangTheme2D*) self)->layout;
#line 234 "theme-2d-file.vala"
		_tmp38_ = ((PasangTheme2D*) self)->layout;
#line 234 "theme-2d-file.vala"
		_tmp39_ = ((PasangTheme2D*) self)->layout;
#line 234 "theme-2d-file.vala"
		x = (_tmp37_.board_x + ((gint) (1.1 * _tmp38_.board_size))) + _tmp39_.filler_left;
#line 235 "theme-2d-file.vala"
		_tmp40_ = ((PasangTheme2D*) self)->layout;
#line 235 "theme-2d-file.vala"
		_tmp41_ = ((PasangTheme2D*) self)->layout;
#line 235 "theme-2d-file.vala"
		y0 = (_tmp40_.board_y + ((gint) (0.5 * grid_size))) + _tmp41_.filler_top;
#line 236 "theme-2d-file.vala"
		_tmp42_ = ((PasangTheme2D*) self)->layout;
#line 236 "theme-2d-file.vala"
		_tmp43_ = ((PasangTheme2D*) self)->layout;
#line 236 "theme-2d-file.vala"
		y1 = (_tmp42_.board_y + ((gint) (12.5 * grid_size))) + _tmp43_.filler_top;
#line 237 "theme-2d-file.vala"
		_tmp44_ = g_new0 (gint, 4);
#line 237 "theme-2d-file.vala"
		_tmp44_[0] = x;
#line 237 "theme-2d-file.vala"
		_tmp44_[1] = y0;
#line 237 "theme-2d-file.vala"
		_tmp44_[2] = x;
#line 237 "theme-2d-file.vala"
		_tmp44_[3] = y1;
#line 237 "theme-2d-file.vala"
		pt = _tmp44_;
#line 237 "theme-2d-file.vala"
		pt_length1 = 4;
#line 237 "theme-2d-file.vala"
		_pt_size_ = pt_length1;
#line 238 "theme-2d-file.vala"
		pasang_theme2_dfile_get_kf_integer_list (self, kf, "Layout", "Wins", &pt, (gint*) (&pt_length1), &_inner_error0_);
#line 238 "theme-2d-file.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 238 "theme-2d-file.vala"
			pt = (g_free (pt), NULL);
#line 238 "theme-2d-file.vala"
			grid = (g_free (grid), NULL);
#line 238 "theme-2d-file.vala"
			table = (g_free (table), NULL);
#line 2202 "theme-2d-file.c"
			goto __catch22_g_error;
		}
#line 239 "theme-2d-file.vala"
		_tmp45_ = pt;
#line 239 "theme-2d-file.vala"
		_tmp45__length1 = pt_length1;
#line 239 "theme-2d-file.vala"
		_tmp46_ = _tmp45_[0];
#line 239 "theme-2d-file.vala"
		_tmp47_ = ((PasangTheme2D*) self)->layout;
#line 239 "theme-2d-file.vala"
		_tmp48_ = pt;
#line 239 "theme-2d-file.vala"
		_tmp48__length1 = pt_length1;
#line 239 "theme-2d-file.vala"
		_tmp49_ = _tmp48_[2];
#line 239 "theme-2d-file.vala"
		_tmp50_ = ((PasangTheme2D*) self)->layout;
#line 239 "theme-2d-file.vala"
		_tmp51_[0] = _tmp46_ - _tmp47_.filler_left;
#line 239 "theme-2d-file.vala"
		_tmp51_[1] = _tmp49_ - _tmp50_.filler_left;
#line 239 "theme-2d-file.vala"
		memcpy (((PasangTheme2D*) self)->layout.num_wins_x, _tmp51_, 2 * sizeof (gint));
#line 240 "theme-2d-file.vala"
		_tmp52_ = pt;
#line 240 "theme-2d-file.vala"
		_tmp52__length1 = pt_length1;
#line 240 "theme-2d-file.vala"
		_tmp53_ = _tmp52_[1];
#line 240 "theme-2d-file.vala"
		_tmp54_ = ((PasangTheme2D*) self)->layout;
#line 240 "theme-2d-file.vala"
		_tmp55_ = pt;
#line 240 "theme-2d-file.vala"
		_tmp55__length1 = pt_length1;
#line 240 "theme-2d-file.vala"
		_tmp56_ = _tmp55_[3];
#line 240 "theme-2d-file.vala"
		_tmp57_ = ((PasangTheme2D*) self)->layout;
#line 240 "theme-2d-file.vala"
		_tmp58_[0] = _tmp53_ - _tmp54_.filler_top;
#line 240 "theme-2d-file.vala"
		_tmp58_[1] = _tmp56_ - _tmp57_.filler_top;
#line 240 "theme-2d-file.vala"
		memcpy (((PasangTheme2D*) self)->layout.num_wins_y, _tmp58_, 2 * sizeof (gint));
#line 244 "theme-2d-file.vala"
		_tmp59_ = g_new0 (gint, 5);
#line 244 "theme-2d-file.vala"
		_tmp59_[0] = (gint) (0.7 * grid_size);
#line 244 "theme-2d-file.vala"
		_tmp59_[1] = 0;
#line 244 "theme-2d-file.vala"
		_tmp59_[2] = 0;
#line 244 "theme-2d-file.vala"
		_tmp59_[3] = 0;
#line 244 "theme-2d-file.vala"
		_tmp59_[4] = 255;
#line 244 "theme-2d-file.vala"
		font = _tmp59_;
#line 244 "theme-2d-file.vala"
		font_length1 = 5;
#line 244 "theme-2d-file.vala"
		_font_size_ = font_length1;
#line 245 "theme-2d-file.vala"
		pasang_theme2_dfile_get_kf_integer_list (self, kf, "Layout", "WinsFont", &font, (gint*) (&font_length1), &_inner_error0_);
#line 245 "theme-2d-file.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 245 "theme-2d-file.vala"
			font = (g_free (font), NULL);
#line 245 "theme-2d-file.vala"
			pt = (g_free (pt), NULL);
#line 245 "theme-2d-file.vala"
			grid = (g_free (grid), NULL);
#line 245 "theme-2d-file.vala"
			table = (g_free (table), NULL);
#line 2279 "theme-2d-file.c"
			goto __catch22_g_error;
		}
#line 246 "theme-2d-file.vala"
		_tmp60_ = font;
#line 246 "theme-2d-file.vala"
		_tmp60__length1 = font_length1;
#line 246 "theme-2d-file.vala"
		_tmp61_ = _tmp60_[0];
#line 246 "theme-2d-file.vala"
		((PasangTheme2D*) self)->layout.num_wins_font_size = _tmp61_;
#line 247 "theme-2d-file.vala"
		_tmp62_ = font;
#line 247 "theme-2d-file.vala"
		_tmp62__length1 = font_length1;
#line 247 "theme-2d-file.vala"
		_tmp63_ = _tmp62_[1];
#line 247 "theme-2d-file.vala"
		_tmp64_ = font;
#line 247 "theme-2d-file.vala"
		_tmp64__length1 = font_length1;
#line 247 "theme-2d-file.vala"
		_tmp65_ = _tmp64_[2];
#line 247 "theme-2d-file.vala"
		_tmp66_ = font;
#line 247 "theme-2d-file.vala"
		_tmp66__length1 = font_length1;
#line 247 "theme-2d-file.vala"
		_tmp67_ = _tmp66_[3];
#line 247 "theme-2d-file.vala"
		_tmp68_ = font;
#line 247 "theme-2d-file.vala"
		_tmp68__length1 = font_length1;
#line 247 "theme-2d-file.vala"
		_tmp69_ = _tmp68_[4];
#line 247 "theme-2d-file.vala"
		pasang_rgb_init (&((PasangTheme2D*) self)->layout.num_wins_color, _tmp63_ / 255.0, _tmp65_ / 255.0, _tmp67_ / 255.0, _tmp69_ / 255.0);
#line 251 "theme-2d-file.vala"
		_tmp70_ = pt;
#line 251 "theme-2d-file.vala"
		_tmp70__length1 = pt_length1;
#line 251 "theme-2d-file.vala"
		_tmp70_[1] += (gint) (3 * grid_size);
#line 252 "theme-2d-file.vala"
		_tmp71_ = pt;
#line 252 "theme-2d-file.vala"
		_tmp71__length1 = pt_length1;
#line 252 "theme-2d-file.vala"
		_tmp71_[3] -= (gint) (3 * grid_size);
#line 253 "theme-2d-file.vala"
		pasang_theme2_dfile_get_kf_integer_list (self, kf, "Layout", "Score", &pt, (gint*) (&pt_length1), &_inner_error0_);
#line 253 "theme-2d-file.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 253 "theme-2d-file.vala"
			font = (g_free (font), NULL);
#line 253 "theme-2d-file.vala"
			pt = (g_free (pt), NULL);
#line 253 "theme-2d-file.vala"
			grid = (g_free (grid), NULL);
#line 253 "theme-2d-file.vala"
			table = (g_free (table), NULL);
#line 2340 "theme-2d-file.c"
			goto __catch22_g_error;
		}
#line 254 "theme-2d-file.vala"
		_tmp72_ = pt;
#line 254 "theme-2d-file.vala"
		_tmp72__length1 = pt_length1;
#line 254 "theme-2d-file.vala"
		_tmp73_ = _tmp72_[0];
#line 254 "theme-2d-file.vala"
		_tmp74_ = ((PasangTheme2D*) self)->layout;
#line 254 "theme-2d-file.vala"
		_tmp75_ = pt;
#line 254 "theme-2d-file.vala"
		_tmp75__length1 = pt_length1;
#line 254 "theme-2d-file.vala"
		_tmp76_ = _tmp75_[2];
#line 254 "theme-2d-file.vala"
		_tmp77_ = ((PasangTheme2D*) self)->layout;
#line 254 "theme-2d-file.vala"
		_tmp78_[0] = _tmp73_ - _tmp74_.filler_left;
#line 254 "theme-2d-file.vala"
		_tmp78_[1] = _tmp76_ - _tmp77_.filler_left;
#line 254 "theme-2d-file.vala"
		memcpy (((PasangTheme2D*) self)->layout.score_x, _tmp78_, 2 * sizeof (gint));
#line 255 "theme-2d-file.vala"
		_tmp79_ = pt;
#line 255 "theme-2d-file.vala"
		_tmp79__length1 = pt_length1;
#line 255 "theme-2d-file.vala"
		_tmp80_ = _tmp79_[1];
#line 255 "theme-2d-file.vala"
		_tmp81_ = ((PasangTheme2D*) self)->layout;
#line 255 "theme-2d-file.vala"
		_tmp82_ = pt;
#line 255 "theme-2d-file.vala"
		_tmp82__length1 = pt_length1;
#line 255 "theme-2d-file.vala"
		_tmp83_ = _tmp82_[3];
#line 255 "theme-2d-file.vala"
		_tmp84_ = ((PasangTheme2D*) self)->layout;
#line 255 "theme-2d-file.vala"
		_tmp85_[0] = _tmp80_ - _tmp81_.filler_top;
#line 255 "theme-2d-file.vala"
		_tmp85_[1] = _tmp83_ - _tmp84_.filler_top;
#line 255 "theme-2d-file.vala"
		memcpy (((PasangTheme2D*) self)->layout.score_y, _tmp85_, 2 * sizeof (gint));
#line 259 "theme-2d-file.vala"
		_tmp86_ = g_new0 (gint, 9);
#line 259 "theme-2d-file.vala"
		_tmp86_[0] = (gint) (0.5 * grid_size);
#line 259 "theme-2d-file.vala"
		_tmp86_[1] = 0;
#line 259 "theme-2d-file.vala"
		_tmp86_[2] = 0;
#line 259 "theme-2d-file.vala"
		_tmp86_[3] = 0;
#line 259 "theme-2d-file.vala"
		_tmp86_[4] = 255;
#line 259 "theme-2d-file.vala"
		_tmp86_[5] = 0;
#line 259 "theme-2d-file.vala"
		_tmp86_[6] = 0;
#line 259 "theme-2d-file.vala"
		_tmp86_[7] = 0;
#line 259 "theme-2d-file.vala"
		_tmp86_[8] = 255;
#line 259 "theme-2d-file.vala"
		font = (g_free (font), NULL);
#line 259 "theme-2d-file.vala"
		font = _tmp86_;
#line 259 "theme-2d-file.vala"
		font_length1 = 9;
#line 259 "theme-2d-file.vala"
		_font_size_ = font_length1;
#line 260 "theme-2d-file.vala"
		pasang_theme2_dfile_get_kf_integer_list (self, kf, "Layout", "ScoreFont", &font, (gint*) (&font_length1), &_inner_error0_);
#line 260 "theme-2d-file.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 260 "theme-2d-file.vala"
			font = (g_free (font), NULL);
#line 260 "theme-2d-file.vala"
			pt = (g_free (pt), NULL);
#line 260 "theme-2d-file.vala"
			grid = (g_free (grid), NULL);
#line 260 "theme-2d-file.vala"
			table = (g_free (table), NULL);
#line 2427 "theme-2d-file.c"
			goto __catch22_g_error;
		}
#line 261 "theme-2d-file.vala"
		_tmp87_ = font;
#line 261 "theme-2d-file.vala"
		_tmp87__length1 = font_length1;
#line 261 "theme-2d-file.vala"
		_tmp88_ = _tmp87_[0];
#line 261 "theme-2d-file.vala"
		((PasangTheme2D*) self)->layout.score_font_size = _tmp88_;
#line 262 "theme-2d-file.vala"
		_tmp89_ = font;
#line 262 "theme-2d-file.vala"
		_tmp89__length1 = font_length1;
#line 262 "theme-2d-file.vala"
		_tmp90_ = _tmp89_[1];
#line 262 "theme-2d-file.vala"
		_tmp91_ = font;
#line 262 "theme-2d-file.vala"
		_tmp91__length1 = font_length1;
#line 262 "theme-2d-file.vala"
		_tmp92_ = _tmp91_[2];
#line 262 "theme-2d-file.vala"
		_tmp93_ = font;
#line 262 "theme-2d-file.vala"
		_tmp93__length1 = font_length1;
#line 262 "theme-2d-file.vala"
		_tmp94_ = _tmp93_[3];
#line 262 "theme-2d-file.vala"
		_tmp95_ = font;
#line 262 "theme-2d-file.vala"
		_tmp95__length1 = font_length1;
#line 262 "theme-2d-file.vala"
		_tmp96_ = _tmp95_[4];
#line 262 "theme-2d-file.vala"
		pasang_rgb_init (&_tmp97_, _tmp90_ / 255.0, _tmp92_ / 255.0, _tmp94_ / 255.0, _tmp96_ / 255.0);
#line 262 "theme-2d-file.vala"
		_tmp98_ = font;
#line 262 "theme-2d-file.vala"
		_tmp98__length1 = font_length1;
#line 262 "theme-2d-file.vala"
		_tmp99_ = _tmp98_[5];
#line 262 "theme-2d-file.vala"
		_tmp100_ = font;
#line 262 "theme-2d-file.vala"
		_tmp100__length1 = font_length1;
#line 262 "theme-2d-file.vala"
		_tmp101_ = _tmp100_[6];
#line 262 "theme-2d-file.vala"
		_tmp102_ = font;
#line 262 "theme-2d-file.vala"
		_tmp102__length1 = font_length1;
#line 262 "theme-2d-file.vala"
		_tmp103_ = _tmp102_[7];
#line 262 "theme-2d-file.vala"
		_tmp104_ = font;
#line 262 "theme-2d-file.vala"
		_tmp104__length1 = font_length1;
#line 262 "theme-2d-file.vala"
		_tmp105_ = _tmp104_[8];
#line 262 "theme-2d-file.vala"
		pasang_rgb_init (&_tmp106_, _tmp99_ / 255.0, _tmp101_ / 255.0, _tmp103_ / 255.0, _tmp105_ / 255.0);
#line 262 "theme-2d-file.vala"
		_tmp107_[0] = _tmp97_;
#line 262 "theme-2d-file.vala"
		_tmp107_[1] = _tmp106_;
#line 262 "theme-2d-file.vala"
		memcpy (((PasangTheme2D*) self)->layout.score_color, _tmp107_, 2 * sizeof (PasangRgb));
#line 267 "theme-2d-file.vala"
		_tmp108_ = pt;
#line 267 "theme-2d-file.vala"
		_tmp108__length1 = pt_length1;
#line 267 "theme-2d-file.vala"
		_tmp108_[1] += (gint) grid_size;
#line 268 "theme-2d-file.vala"
		_tmp109_ = pt;
#line 268 "theme-2d-file.vala"
		_tmp109__length1 = pt_length1;
#line 268 "theme-2d-file.vala"
		_tmp109_[3] -= (gint) grid_size;
#line 269 "theme-2d-file.vala"
		pasang_theme2_dfile_get_kf_integer_list (self, kf, "Layout", "Kas", &pt, (gint*) (&pt_length1), &_inner_error0_);
#line 269 "theme-2d-file.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 269 "theme-2d-file.vala"
			font = (g_free (font), NULL);
#line 269 "theme-2d-file.vala"
			pt = (g_free (pt), NULL);
#line 269 "theme-2d-file.vala"
			grid = (g_free (grid), NULL);
#line 269 "theme-2d-file.vala"
			table = (g_free (table), NULL);
#line 2520 "theme-2d-file.c"
			goto __catch22_g_error;
		}
#line 270 "theme-2d-file.vala"
		_tmp110_ = pt;
#line 270 "theme-2d-file.vala"
		_tmp110__length1 = pt_length1;
#line 270 "theme-2d-file.vala"
		_tmp111_ = _tmp110_[0];
#line 270 "theme-2d-file.vala"
		_tmp112_ = ((PasangTheme2D*) self)->layout;
#line 270 "theme-2d-file.vala"
		_tmp113_ = pt;
#line 270 "theme-2d-file.vala"
		_tmp113__length1 = pt_length1;
#line 270 "theme-2d-file.vala"
		_tmp114_ = _tmp113_[2];
#line 270 "theme-2d-file.vala"
		_tmp115_ = ((PasangTheme2D*) self)->layout;
#line 270 "theme-2d-file.vala"
		_tmp116_[0] = _tmp111_ - _tmp112_.filler_left;
#line 270 "theme-2d-file.vala"
		_tmp116_[1] = _tmp114_ - _tmp115_.filler_left;
#line 270 "theme-2d-file.vala"
		memcpy (((PasangTheme2D*) self)->layout.kas_x, _tmp116_, 2 * sizeof (gint));
#line 271 "theme-2d-file.vala"
		_tmp117_ = pt;
#line 271 "theme-2d-file.vala"
		_tmp117__length1 = pt_length1;
#line 271 "theme-2d-file.vala"
		_tmp118_ = _tmp117_[1];
#line 271 "theme-2d-file.vala"
		_tmp119_ = ((PasangTheme2D*) self)->layout;
#line 271 "theme-2d-file.vala"
		_tmp120_ = pt;
#line 271 "theme-2d-file.vala"
		_tmp120__length1 = pt_length1;
#line 271 "theme-2d-file.vala"
		_tmp121_ = _tmp120_[3];
#line 271 "theme-2d-file.vala"
		_tmp122_ = ((PasangTheme2D*) self)->layout;
#line 271 "theme-2d-file.vala"
		_tmp123_[0] = _tmp118_ - _tmp119_.filler_top;
#line 271 "theme-2d-file.vala"
		_tmp123_[1] = _tmp121_ - _tmp122_.filler_top;
#line 271 "theme-2d-file.vala"
		memcpy (((PasangTheme2D*) self)->layout.kas_y, _tmp123_, 2 * sizeof (gint));
#line 275 "theme-2d-file.vala"
		_tmp124_ = g_new0 (gint, 2);
#line 275 "theme-2d-file.vala"
		_tmp124_[0] = 0;
#line 275 "theme-2d-file.vala"
		_tmp124_[1] = 0;
#line 275 "theme-2d-file.vala"
		kas_frame = _tmp124_;
#line 275 "theme-2d-file.vala"
		kas_frame_length1 = 2;
#line 275 "theme-2d-file.vala"
		_kas_frame_size_ = kas_frame_length1;
#line 276 "theme-2d-file.vala"
		pasang_theme2_dfile_get_kf_integer_list (self, kf, "Layout", "KasFrame", &kas_frame, (gint*) (&kas_frame_length1), &_inner_error0_);
#line 276 "theme-2d-file.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 276 "theme-2d-file.vala"
			kas_frame = (g_free (kas_frame), NULL);
#line 276 "theme-2d-file.vala"
			font = (g_free (font), NULL);
#line 276 "theme-2d-file.vala"
			pt = (g_free (pt), NULL);
#line 276 "theme-2d-file.vala"
			grid = (g_free (grid), NULL);
#line 276 "theme-2d-file.vala"
			table = (g_free (table), NULL);
#line 2593 "theme-2d-file.c"
			goto __catch22_g_error;
		}
#line 277 "theme-2d-file.vala"
		_tmp125_ = kas_frame;
#line 277 "theme-2d-file.vala"
		_tmp125__length1 = kas_frame_length1;
#line 277 "theme-2d-file.vala"
		memcpy (((PasangTheme2D*) self)->layout.kas_frame, _tmp125_, 2 * sizeof (gint));
#line 281 "theme-2d-file.vala"
		_tmp126_ = pt;
#line 281 "theme-2d-file.vala"
		_tmp126__length1 = pt_length1;
#line 281 "theme-2d-file.vala"
		_tmp127_ = _tmp126_[0];
#line 281 "theme-2d-file.vala"
		_tmp128_ = pt;
#line 281 "theme-2d-file.vala"
		_tmp128__length1 = pt_length1;
#line 281 "theme-2d-file.vala"
		_tmp129_ = _tmp128_[2];
#line 281 "theme-2d-file.vala"
		_tmp130_ = pt;
#line 281 "theme-2d-file.vala"
		_tmp130__length1 = pt_length1;
#line 281 "theme-2d-file.vala"
		_tmp131_ = _tmp130_[1];
#line 281 "theme-2d-file.vala"
		_tmp132_ = pt;
#line 281 "theme-2d-file.vala"
		_tmp132__length1 = pt_length1;
#line 281 "theme-2d-file.vala"
		_tmp133_ = _tmp132_[3];
#line 281 "theme-2d-file.vala"
		_tmp134_ = g_new0 (gint, 3);
#line 281 "theme-2d-file.vala"
		_tmp134_[0] = (_tmp127_ + _tmp129_) / 2;
#line 281 "theme-2d-file.vala"
		_tmp134_[1] = (_tmp131_ + _tmp133_) / 2;
#line 281 "theme-2d-file.vala"
		_tmp134_[2] = 0;
#line 281 "theme-2d-file.vala"
		pt = (g_free (pt), NULL);
#line 281 "theme-2d-file.vala"
		pt = _tmp134_;
#line 281 "theme-2d-file.vala"
		pt_length1 = 3;
#line 281 "theme-2d-file.vala"
		_pt_size_ = pt_length1;
#line 282 "theme-2d-file.vala"
		pasang_theme2_dfile_get_kf_integer_list (self, kf, "Layout", "Round", &pt, (gint*) (&pt_length1), &_inner_error0_);
#line 282 "theme-2d-file.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 282 "theme-2d-file.vala"
			kas_frame = (g_free (kas_frame), NULL);
#line 282 "theme-2d-file.vala"
			font = (g_free (font), NULL);
#line 282 "theme-2d-file.vala"
			pt = (g_free (pt), NULL);
#line 282 "theme-2d-file.vala"
			grid = (g_free (grid), NULL);
#line 282 "theme-2d-file.vala"
			table = (g_free (table), NULL);
#line 2656 "theme-2d-file.c"
			goto __catch22_g_error;
		}
#line 283 "theme-2d-file.vala"
		_tmp135_ = pt;
#line 283 "theme-2d-file.vala"
		_tmp135__length1 = pt_length1;
#line 283 "theme-2d-file.vala"
		_tmp136_ = _tmp135_[0];
#line 283 "theme-2d-file.vala"
		_tmp137_ = ((PasangTheme2D*) self)->layout;
#line 283 "theme-2d-file.vala"
		((PasangTheme2D*) self)->layout.num_rounds_x = _tmp136_ - _tmp137_.filler_left;
#line 284 "theme-2d-file.vala"
		_tmp138_ = pt;
#line 284 "theme-2d-file.vala"
		_tmp138__length1 = pt_length1;
#line 284 "theme-2d-file.vala"
		_tmp139_ = _tmp138_[1];
#line 284 "theme-2d-file.vala"
		_tmp140_ = ((PasangTheme2D*) self)->layout;
#line 284 "theme-2d-file.vala"
		((PasangTheme2D*) self)->layout.num_rounds_y = _tmp139_ - _tmp140_.filler_top;
#line 285 "theme-2d-file.vala"
		_tmp141_ = pt;
#line 285 "theme-2d-file.vala"
		_tmp141__length1 = pt_length1;
#line 285 "theme-2d-file.vala"
		_tmp142_ = _tmp141_[2];
#line 285 "theme-2d-file.vala"
		((PasangTheme2D*) self)->layout.num_rounds_format = _tmp142_;
#line 289 "theme-2d-file.vala"
		_tmp143_ = g_new0 (gint, 9);
#line 289 "theme-2d-file.vala"
		_tmp143_[0] = (gint) (0.3 * grid_size);
#line 289 "theme-2d-file.vala"
		_tmp143_[1] = 0;
#line 289 "theme-2d-file.vala"
		_tmp143_[2] = 0;
#line 289 "theme-2d-file.vala"
		_tmp143_[3] = 0;
#line 289 "theme-2d-file.vala"
		_tmp143_[4] = 255;
#line 289 "theme-2d-file.vala"
		_tmp143_[5] = 0;
#line 289 "theme-2d-file.vala"
		_tmp143_[6] = 0;
#line 289 "theme-2d-file.vala"
		_tmp143_[7] = 0;
#line 289 "theme-2d-file.vala"
		_tmp143_[8] = 255;
#line 289 "theme-2d-file.vala"
		font = (g_free (font), NULL);
#line 289 "theme-2d-file.vala"
		font = _tmp143_;
#line 289 "theme-2d-file.vala"
		font_length1 = 9;
#line 289 "theme-2d-file.vala"
		_font_size_ = font_length1;
#line 290 "theme-2d-file.vala"
		pasang_theme2_dfile_get_kf_integer_list (self, kf, "Layout", "RoundFont", &font, (gint*) (&font_length1), &_inner_error0_);
#line 290 "theme-2d-file.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 290 "theme-2d-file.vala"
			kas_frame = (g_free (kas_frame), NULL);
#line 290 "theme-2d-file.vala"
			font = (g_free (font), NULL);
#line 290 "theme-2d-file.vala"
			pt = (g_free (pt), NULL);
#line 290 "theme-2d-file.vala"
			grid = (g_free (grid), NULL);
#line 290 "theme-2d-file.vala"
			table = (g_free (table), NULL);
#line 2729 "theme-2d-file.c"
			goto __catch22_g_error;
		}
#line 291 "theme-2d-file.vala"
		_tmp144_ = font;
#line 291 "theme-2d-file.vala"
		_tmp144__length1 = font_length1;
#line 291 "theme-2d-file.vala"
		_tmp145_ = _tmp144_[0];
#line 291 "theme-2d-file.vala"
		((PasangTheme2D*) self)->layout.num_rounds_font_size = _tmp145_;
#line 292 "theme-2d-file.vala"
		_tmp146_ = font;
#line 292 "theme-2d-file.vala"
		_tmp146__length1 = font_length1;
#line 292 "theme-2d-file.vala"
		_tmp147_ = _tmp146_[1];
#line 292 "theme-2d-file.vala"
		_tmp148_ = font;
#line 292 "theme-2d-file.vala"
		_tmp148__length1 = font_length1;
#line 292 "theme-2d-file.vala"
		_tmp149_ = _tmp148_[2];
#line 292 "theme-2d-file.vala"
		_tmp150_ = font;
#line 292 "theme-2d-file.vala"
		_tmp150__length1 = font_length1;
#line 292 "theme-2d-file.vala"
		_tmp151_ = _tmp150_[3];
#line 292 "theme-2d-file.vala"
		_tmp152_ = font;
#line 292 "theme-2d-file.vala"
		_tmp152__length1 = font_length1;
#line 292 "theme-2d-file.vala"
		_tmp153_ = _tmp152_[4];
#line 292 "theme-2d-file.vala"
		pasang_rgb_init (&((PasangTheme2D*) self)->layout.num_rounds_color, _tmp147_ / 255.0, _tmp149_ / 255.0, _tmp151_ / 255.0, _tmp153_ / 255.0);
#line 295 "theme-2d-file.vala"
		if (self->priv->old_theme) {
#line 2768 "theme-2d-file.c"
			PasangLayout2D _tmp154_;
#line 295 "theme-2d-file.vala"
			_tmp154_ = ((PasangTheme2D*) self)->layout;
#line 295 "theme-2d-file.vala"
			((PasangTheme2D*) self)->layout.width = (120 * _tmp154_.width) / 100;
#line 2774 "theme-2d-file.c"
		}
#line 201 "theme-2d-file.vala"
		kas_frame = (g_free (kas_frame), NULL);
#line 201 "theme-2d-file.vala"
		font = (g_free (font), NULL);
#line 201 "theme-2d-file.vala"
		pt = (g_free (pt), NULL);
#line 201 "theme-2d-file.vala"
		grid = (g_free (grid), NULL);
#line 201 "theme-2d-file.vala"
		table = (g_free (table), NULL);
#line 2786 "theme-2d-file.c"
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError* e = NULL;
		FILE* _tmp155_;
		GError* _tmp156_;
		const gchar* _tmp157_;
#line 201 "theme-2d-file.vala"
		e = _inner_error0_;
#line 201 "theme-2d-file.vala"
		_inner_error0_ = NULL;
#line 298 "theme-2d-file.vala"
		_tmp155_ = stderr;
#line 298 "theme-2d-file.vala"
		_tmp156_ = e;
#line 298 "theme-2d-file.vala"
		_tmp157_ = _tmp156_->message;
#line 298 "theme-2d-file.vala"
		fprintf (_tmp155_, "KeyFile error: %s\n", _tmp157_);
#line 201 "theme-2d-file.vala"
		_g_error_free0 (e);
#line 2809 "theme-2d-file.c"
	}
	__finally22:
#line 201 "theme-2d-file.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 201 "theme-2d-file.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 201 "theme-2d-file.vala"
		g_clear_error (&_inner_error0_);
#line 201 "theme-2d-file.vala"
		return;
#line 2820 "theme-2d-file.c"
	}
}

/**
     * Read the KeyFile if the given key is available. Otherwise leave the output untouched.
     */
static void
pasang_theme2_dfile_get_kf_string (PasangTheme2DFile* self,
                                   GKeyFile* kf,
                                   const gchar* group,
                                   const gchar* key,
                                   gchar* * output,
                                   GError** error)
{
	gboolean _tmp0_ = FALSE;
	GError* _inner_error0_ = NULL;
#line 305 "theme-2d-file.vala"
	g_return_if_fail (self != NULL);
#line 305 "theme-2d-file.vala"
	g_return_if_fail (kf != NULL);
#line 305 "theme-2d-file.vala"
	g_return_if_fail (group != NULL);
#line 305 "theme-2d-file.vala"
	g_return_if_fail (key != NULL);
#line 307 "theme-2d-file.vala"
	if (g_key_file_has_group (kf, group)) {
#line 2847 "theme-2d-file.c"
		gboolean _tmp1_ = FALSE;
#line 307 "theme-2d-file.vala"
		_tmp1_ = g_key_file_has_key (kf, group, key, &_inner_error0_);
#line 307 "theme-2d-file.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 307 "theme-2d-file.vala"
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
#line 307 "theme-2d-file.vala"
				g_propagate_error (error, _inner_error0_);
#line 307 "theme-2d-file.vala"
				return;
#line 2859 "theme-2d-file.c"
			} else {
#line 307 "theme-2d-file.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 307 "theme-2d-file.vala"
				g_clear_error (&_inner_error0_);
#line 307 "theme-2d-file.vala"
				return;
#line 2867 "theme-2d-file.c"
			}
		}
#line 307 "theme-2d-file.vala"
		_tmp0_ = _tmp1_;
#line 2872 "theme-2d-file.c"
	} else {
#line 307 "theme-2d-file.vala"
		_tmp0_ = FALSE;
#line 2876 "theme-2d-file.c"
	}
#line 307 "theme-2d-file.vala"
	if (_tmp0_) {
#line 2880 "theme-2d-file.c"
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
#line 308 "theme-2d-file.vala"
		_tmp3_ = g_key_file_get_locale_string (kf, group, key, NULL, &_inner_error0_);
#line 308 "theme-2d-file.vala"
		_tmp2_ = _tmp3_;
#line 308 "theme-2d-file.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 308 "theme-2d-file.vala"
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
#line 308 "theme-2d-file.vala"
				g_propagate_error (error, _inner_error0_);
#line 308 "theme-2d-file.vala"
				return;
#line 2896 "theme-2d-file.c"
			} else {
#line 308 "theme-2d-file.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 308 "theme-2d-file.vala"
				g_clear_error (&_inner_error0_);
#line 308 "theme-2d-file.vala"
				return;
#line 2904 "theme-2d-file.c"
			}
		}
#line 308 "theme-2d-file.vala"
		_tmp4_ = _tmp2_;
#line 308 "theme-2d-file.vala"
		_tmp2_ = NULL;
#line 308 "theme-2d-file.vala"
		_g_free0 (*output);
#line 308 "theme-2d-file.vala"
		*output = _tmp4_;
#line 307 "theme-2d-file.vala"
		_g_free0 (_tmp2_);
#line 2917 "theme-2d-file.c"
	}
}

static void
pasang_theme2_dfile_get_kf_integer_list (PasangTheme2DFile* self,
                                         GKeyFile* kf,
                                         const gchar* group,
                                         const gchar* key,
                                         gint** output,
                                         gint* output_length1,
                                         GError** error)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
#line 311 "theme-2d-file.vala"
	g_return_if_fail (self != NULL);
#line 311 "theme-2d-file.vala"
	g_return_if_fail (group != NULL);
#line 311 "theme-2d-file.vala"
	g_return_if_fail (key != NULL);
#line 313 "theme-2d-file.vala"
	if (kf != NULL) {
#line 313 "theme-2d-file.vala"
		_tmp1_ = g_key_file_has_group (kf, group);
#line 2943 "theme-2d-file.c"
	} else {
#line 313 "theme-2d-file.vala"
		_tmp1_ = FALSE;
#line 2947 "theme-2d-file.c"
	}
#line 313 "theme-2d-file.vala"
	if (_tmp1_) {
#line 2951 "theme-2d-file.c"
		gboolean _tmp2_ = FALSE;
#line 313 "theme-2d-file.vala"
		_tmp2_ = g_key_file_has_key (kf, group, key, &_inner_error0_);
#line 313 "theme-2d-file.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 313 "theme-2d-file.vala"
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
#line 313 "theme-2d-file.vala"
				g_propagate_error (error, _inner_error0_);
#line 313 "theme-2d-file.vala"
				return;
#line 2963 "theme-2d-file.c"
			} else {
#line 313 "theme-2d-file.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 313 "theme-2d-file.vala"
				g_clear_error (&_inner_error0_);
#line 313 "theme-2d-file.vala"
				return;
#line 2971 "theme-2d-file.c"
			}
		}
#line 313 "theme-2d-file.vala"
		_tmp0_ = _tmp2_;
#line 2976 "theme-2d-file.c"
	} else {
#line 313 "theme-2d-file.vala"
		_tmp0_ = FALSE;
#line 2980 "theme-2d-file.c"
	}
#line 313 "theme-2d-file.vala"
	if (_tmp0_) {
#line 2984 "theme-2d-file.c"
		gint* vals = NULL;
		gsize _tmp3_ = 0;
		gint* _tmp4_;
		gint vals_length1;
		gint _vals_size_;
		gint n = 0;
		gint* _tmp5_;
		gint _tmp5__length1;
#line 314 "theme-2d-file.vala"
		_tmp4_ = g_key_file_get_integer_list (kf, group, key, &_tmp3_, &_inner_error0_);
#line 314 "theme-2d-file.vala"
		vals = _tmp4_;
#line 314 "theme-2d-file.vala"
		vals_length1 = _tmp3_;
#line 314 "theme-2d-file.vala"
		_vals_size_ = vals_length1;
#line 314 "theme-2d-file.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 314 "theme-2d-file.vala"
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
#line 314 "theme-2d-file.vala"
				g_propagate_error (error, _inner_error0_);
#line 314 "theme-2d-file.vala"
				return;
#line 3009 "theme-2d-file.c"
			} else {
#line 314 "theme-2d-file.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 314 "theme-2d-file.vala"
				g_clear_error (&_inner_error0_);
#line 314 "theme-2d-file.vala"
				return;
#line 3017 "theme-2d-file.c"
			}
		}
#line 315 "theme-2d-file.vala"
		_tmp5_ = vals;
#line 315 "theme-2d-file.vala"
		_tmp5__length1 = vals_length1;
#line 315 "theme-2d-file.vala"
		n = MIN (_tmp5__length1, *output_length1);
#line 3026 "theme-2d-file.c"
		{
			gint i = 0;
#line 316 "theme-2d-file.vala"
			i = 0;
#line 3031 "theme-2d-file.c"
			{
				gboolean _tmp6_ = FALSE;
#line 316 "theme-2d-file.vala"
				_tmp6_ = TRUE;
#line 316 "theme-2d-file.vala"
				while (TRUE) {
#line 3038 "theme-2d-file.c"
					gint* _tmp8_;
					gint _tmp8__length1;
					gint _tmp9_;
#line 316 "theme-2d-file.vala"
					if (!_tmp6_) {
#line 3044 "theme-2d-file.c"
						gint _tmp7_;
#line 316 "theme-2d-file.vala"
						_tmp7_ = i;
#line 316 "theme-2d-file.vala"
						i = _tmp7_ + 1;
#line 3050 "theme-2d-file.c"
					}
#line 316 "theme-2d-file.vala"
					_tmp6_ = FALSE;
#line 316 "theme-2d-file.vala"
					if (!(i < n)) {
#line 316 "theme-2d-file.vala"
						break;
#line 3058 "theme-2d-file.c"
					}
#line 316 "theme-2d-file.vala"
					_tmp8_ = vals;
#line 316 "theme-2d-file.vala"
					_tmp8__length1 = vals_length1;
#line 316 "theme-2d-file.vala"
					_tmp9_ = _tmp8_[i];
#line 316 "theme-2d-file.vala"
					(*output)[i] = _tmp9_;
#line 3068 "theme-2d-file.c"
				}
			}
		}
#line 313 "theme-2d-file.vala"
		vals = (g_free (vals), NULL);
#line 3074 "theme-2d-file.c"
	}
}

/**
     * Scale pixbuf images previously loaded from files.
     * Use scale factor current_size / size of board image.
     * Side-effect: images[]
     */
static void
pasang_theme2_dfile_real_resize_images (PasangTheme2D* base)
{
	PasangTheme2DFile * self;
#line 325 "theme-2d-file.vala"
	self = (PasangTheme2DFile*) base;
#line 3089 "theme-2d-file.c"
	{
		gint i = 0;
#line 326 "theme-2d-file.vala"
		i = 0;
#line 3094 "theme-2d-file.c"
		{
			gboolean _tmp0_ = FALSE;
#line 326 "theme-2d-file.vala"
			_tmp0_ = TRUE;
#line 326 "theme-2d-file.vala"
			while (TRUE) {
#line 3101 "theme-2d-file.c"
				gint width = 0;
				gint height = 0;
				GdkPixbuf* pixbuf = NULL;
				GdkPixbuf** _tmp18_;
				gint _tmp18__length1;
				GdkPixbuf* _tmp19_;
				GdkPixbuf* _tmp20_;
				cairo_surface_t** _tmp21_;
				gint _tmp21__length1;
				cairo_surface_t* _tmp22_;
				cairo_t* cr = NULL;
				cairo_surface_t** _tmp23_;
				gint _tmp23__length1;
				cairo_surface_t* _tmp24_;
				cairo_t* _tmp25_;
				cairo_t* _tmp26_;
				GdkPixbuf* _tmp27_;
				cairo_t* _tmp28_;
#line 326 "theme-2d-file.vala"
				if (!_tmp0_) {
#line 3122 "theme-2d-file.c"
					gint _tmp1_;
#line 326 "theme-2d-file.vala"
					_tmp1_ = i;
#line 326 "theme-2d-file.vala"
					i = _tmp1_ + 1;
#line 3128 "theme-2d-file.c"
				}
#line 326 "theme-2d-file.vala"
				_tmp0_ = FALSE;
#line 326 "theme-2d-file.vala"
				if (!(i < ((gint) (PASANG_PIECE_COUNT + 1)))) {
#line 326 "theme-2d-file.vala"
					break;
#line 3136 "theme-2d-file.c"
				}
#line 328 "theme-2d-file.vala"
				if (i == ((gint) PASANG_PIECE_BOARD)) {
#line 3140 "theme-2d-file.c"
					gint _tmp2_ = 0;
					PasangLayout2D _tmp5_;
#line 329 "theme-2d-file.vala"
					if (self->priv->old_theme) {
#line 3145 "theme-2d-file.c"
						PasangLayout2D _tmp3_;
#line 329 "theme-2d-file.vala"
						_tmp3_ = ((PasangTheme2D*) self)->table;
#line 329 "theme-2d-file.vala"
						_tmp2_ = _tmp3_.image_height;
#line 3151 "theme-2d-file.c"
					} else {
						PasangLayout2D _tmp4_;
#line 329 "theme-2d-file.vala"
						_tmp4_ = ((PasangTheme2D*) self)->table;
#line 329 "theme-2d-file.vala"
						_tmp2_ = _tmp4_.image_width;
#line 3158 "theme-2d-file.c"
					}
#line 329 "theme-2d-file.vala"
					width = _tmp2_;
#line 330 "theme-2d-file.vala"
					_tmp5_ = ((PasangTheme2D*) self)->table;
#line 330 "theme-2d-file.vala"
					height = _tmp5_.image_height;
#line 3166 "theme-2d-file.c"
				} else {
					gint num_cols = 0;
					GdkPixbuf** _tmp6_;
					gint _tmp6__length1;
					GdkPixbuf* _tmp7_;
					GdkPixbuf** _tmp8_;
					gint _tmp8__length1;
					GdkPixbuf* _tmp9_;
					gint* _tmp10_;
					gint _tmp10__length1;
					gint _tmp11_;
					GdkPixbuf** _tmp12_;
					gint _tmp12__length1;
					GdkPixbuf* _tmp13_;
					PasangLayout2D _tmp14_;
					PasangLayout2D _tmp15_;
					gint* _tmp16_;
					gint _tmp16__length1;
					gint _tmp17_;
#line 334 "theme-2d-file.vala"
					_tmp6_ = self->pixbufs;
#line 334 "theme-2d-file.vala"
					_tmp6__length1 = self->pixbufs_length1;
#line 334 "theme-2d-file.vala"
					_tmp7_ = _tmp6_[i];
#line 334 "theme-2d-file.vala"
					_tmp8_ = self->pixbufs;
#line 334 "theme-2d-file.vala"
					_tmp8__length1 = self->pixbufs_length1;
#line 334 "theme-2d-file.vala"
					_tmp9_ = _tmp8_[i];
#line 334 "theme-2d-file.vala"
					_tmp10_ = ((PasangTheme2D*) self)->num_rows_in_image;
#line 334 "theme-2d-file.vala"
					_tmp10__length1 = ((PasangTheme2D*) self)->num_rows_in_image_length1;
#line 334 "theme-2d-file.vala"
					_tmp11_ = _tmp10_[i];
#line 334 "theme-2d-file.vala"
					num_cols = gdk_pixbuf_get_width (_tmp7_) / (gdk_pixbuf_get_height (_tmp9_) / _tmp11_);
#line 335 "theme-2d-file.vala"
					_tmp12_ = self->pixbufs;
#line 335 "theme-2d-file.vala"
					_tmp12__length1 = self->pixbufs_length1;
#line 335 "theme-2d-file.vala"
					_tmp13_ = _tmp12_[i];
#line 335 "theme-2d-file.vala"
					_tmp14_ = ((PasangTheme2D*) self)->table;
#line 335 "theme-2d-file.vala"
					_tmp15_ = ((PasangTheme2D*) self)->layout;
#line 335 "theme-2d-file.vala"
					height = (gint) ((gdk_pixbuf_get_height (_tmp13_) * _tmp14_.board_size) / _tmp15_.board_size);
#line 336 "theme-2d-file.vala"
					_tmp16_ = ((PasangTheme2D*) self)->num_rows_in_image;
#line 336 "theme-2d-file.vala"
					_tmp16__length1 = ((PasangTheme2D*) self)->num_rows_in_image_length1;
#line 336 "theme-2d-file.vala"
					_tmp17_ = _tmp16_[i];
#line 336 "theme-2d-file.vala"
					width = (height / _tmp17_) * num_cols;
#line 3226 "theme-2d-file.c"
				}
#line 339 "theme-2d-file.vala"
				_tmp18_ = self->pixbufs;
#line 339 "theme-2d-file.vala"
				_tmp18__length1 = self->pixbufs_length1;
#line 339 "theme-2d-file.vala"
				_tmp19_ = _tmp18_[i];
#line 339 "theme-2d-file.vala"
				_tmp20_ = gdk_pixbuf_scale_simple (_tmp19_, width, height, GDK_INTERP_BILINEAR);
#line 339 "theme-2d-file.vala"
				pixbuf = _tmp20_;
#line 342 "theme-2d-file.vala"
				_tmp21_ = ((PasangTheme2D*) self)->images;
#line 342 "theme-2d-file.vala"
				_tmp21__length1 = ((PasangTheme2D*) self)->images_length1;
#line 342 "theme-2d-file.vala"
				_tmp22_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, width, height);
#line 342 "theme-2d-file.vala"
				_cairo_surface_destroy0 (_tmp21_[i]);
#line 342 "theme-2d-file.vala"
				_tmp21_[i] = _tmp22_;
#line 343 "theme-2d-file.vala"
				_tmp23_ = ((PasangTheme2D*) self)->images;
#line 343 "theme-2d-file.vala"
				_tmp23__length1 = ((PasangTheme2D*) self)->images_length1;
#line 343 "theme-2d-file.vala"
				_tmp24_ = _tmp23_[i];
#line 343 "theme-2d-file.vala"
				_tmp25_ = cairo_create (_tmp24_);
#line 343 "theme-2d-file.vala"
				cr = _tmp25_;
#line 344 "theme-2d-file.vala"
				_tmp26_ = cr;
#line 344 "theme-2d-file.vala"
				_tmp27_ = pixbuf;
#line 344 "theme-2d-file.vala"
				gdk_cairo_set_source_pixbuf (_tmp26_, _tmp27_, 0.0, 0.0);
#line 345 "theme-2d-file.vala"
				_tmp28_ = cr;
#line 345 "theme-2d-file.vala"
				cairo_paint (_tmp28_);
#line 326 "theme-2d-file.vala"
				_cairo_destroy0 (cr);
#line 326 "theme-2d-file.vala"
				_g_object_unref0 (pixbuf);
#line 3272 "theme-2d-file.c"
			}
		}
	}
}

static void
pasang_theme2_dfile_class_init (PasangTheme2DFileClass * klass,
                                gpointer klass_data)
{
#line 21 "theme-2d-file.vala"
	pasang_theme2_dfile_parent_class = g_type_class_peek_parent (klass);
#line 21 "theme-2d-file.vala"
	g_type_class_adjust_private_offset (klass, &PasangTheme2DFile_private_offset);
#line 21 "theme-2d-file.vala"
	((PasangThemeClass *) klass)->free = (void (*) (PasangTheme*)) pasang_theme2_dfile_real_free;
#line 21 "theme-2d-file.vala"
	((PasangThemeClass *) klass)->select = (PasangTheme* (*) (PasangTheme*, const gchar*, gint, gint)) pasang_theme2_dfile_real_select;
#line 21 "theme-2d-file.vala"
	((PasangTheme2DClass *) klass)->resize_images = (void (*) (PasangTheme2D*)) pasang_theme2_dfile_real_resize_images;
#line 21 "theme-2d-file.vala"
	G_OBJECT_CLASS (klass)->finalize = pasang_theme2_dfile_finalize;
#line 3294 "theme-2d-file.c"
}

static void
pasang_theme2_dfile_instance_init (PasangTheme2DFile * self,
                                   gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar** _tmp8_;
	GdkPixbuf** _tmp9_;
#line 21 "theme-2d-file.vala"
	self->priv = pasang_theme2_dfile_get_instance_private (self);
#line 22 "theme-2d-file.vala"
	_tmp0_ = g_strdup ("red");
#line 22 "theme-2d-file.vala"
	_tmp1_ = g_strdup ("blue");
#line 22 "theme-2d-file.vala"
	_tmp2_ = g_strdup ("black");
#line 22 "theme-2d-file.vala"
	_tmp3_ = g_strdup ("white");
#line 22 "theme-2d-file.vala"
	_tmp4_ = g_strdup ("table|board");
#line 22 "theme-2d-file.vala"
	_tmp5_ = g_new0 (gchar*, 5 + 1);
#line 22 "theme-2d-file.vala"
	_tmp5_[0] = _tmp0_;
#line 22 "theme-2d-file.vala"
	_tmp5_[1] = _tmp1_;
#line 22 "theme-2d-file.vala"
	_tmp5_[2] = _tmp2_;
#line 22 "theme-2d-file.vala"
	_tmp5_[3] = _tmp3_;
#line 22 "theme-2d-file.vala"
	_tmp5_[4] = _tmp4_;
#line 22 "theme-2d-file.vala"
	self->priv->filename_alts = _tmp5_;
#line 22 "theme-2d-file.vala"
	self->priv->filename_alts_length1 = 5;
#line 22 "theme-2d-file.vala"
	self->priv->_filename_alts_size_ = self->priv->filename_alts_length1;
#line 23 "theme-2d-file.vala"
	_tmp6_ = g_strdup (".png");
#line 23 "theme-2d-file.vala"
	_tmp7_ = g_strdup (".svg");
#line 23 "theme-2d-file.vala"
	_tmp8_ = g_new0 (gchar*, 2 + 1);
#line 23 "theme-2d-file.vala"
	_tmp8_[0] = _tmp6_;
#line 23 "theme-2d-file.vala"
	_tmp8_[1] = _tmp7_;
#line 23 "theme-2d-file.vala"
	self->priv->filetypes = _tmp8_;
#line 23 "theme-2d-file.vala"
	self->priv->filetypes_length1 = 2;
#line 23 "theme-2d-file.vala"
	self->priv->_filetypes_size_ = self->priv->filetypes_length1;
#line 26 "theme-2d-file.vala"
	self->priv->old_theme = TRUE;
#line 120 "theme-2d-file.vala"
	_tmp9_ = g_new0 (GdkPixbuf*, (PASANG_PIECE_COUNT + 1) + 1);
#line 120 "theme-2d-file.vala"
	self->pixbufs = _tmp9_;
#line 120 "theme-2d-file.vala"
	self->pixbufs_length1 = PASANG_PIECE_COUNT + 1;
#line 120 "theme-2d-file.vala"
	self->_pixbufs_size_ = self->pixbufs_length1;
#line 3367 "theme-2d-file.c"
}

static void
pasang_theme2_dfile_finalize (GObject * obj)
{
	PasangTheme2DFile * self;
#line 21 "theme-2d-file.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PASANG_TYPE_THEME2_DFILE, PasangTheme2DFile);
#line 22 "theme-2d-file.vala"
	self->priv->filename_alts = (_vala_array_free (self->priv->filename_alts, self->priv->filename_alts_length1, (GDestroyNotify) g_free), NULL);
#line 23 "theme-2d-file.vala"
	self->priv->filetypes = (_vala_array_free (self->priv->filetypes, self->priv->filetypes_length1, (GDestroyNotify) g_free), NULL);
#line 120 "theme-2d-file.vala"
	self->pixbufs = (_vala_array_free (self->pixbufs, self->pixbufs_length1, (GDestroyNotify) g_object_unref), NULL);
#line 21 "theme-2d-file.vala"
	G_OBJECT_CLASS (pasang_theme2_dfile_parent_class)->finalize (obj);
#line 3384 "theme-2d-file.c"
}

GType
pasang_theme2_dfile_get_type (void)
{
	static volatile gsize pasang_theme2_dfile_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_theme2_dfile_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PasangTheme2DFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pasang_theme2_dfile_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PasangTheme2DFile), 0, (GInstanceInitFunc) pasang_theme2_dfile_instance_init, NULL };
		GType pasang_theme2_dfile_type_id;
		pasang_theme2_dfile_type_id = g_type_register_static (PASANG_TYPE_THEME2_D, "PasangTheme2DFile", &g_define_type_info, 0);
		PasangTheme2DFile_private_offset = g_type_add_instance_private (pasang_theme2_dfile_type_id, sizeof (PasangTheme2DFilePrivate));
		g_once_init_leave (&pasang_theme2_dfile_type_id__volatile, pasang_theme2_dfile_type_id);
	}
	return pasang_theme2_dfile_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

