/* brain.c generated by valac 0.46.3, the Vala compiler
 * generated from brain.vala, do not modify */

/*  Pasang Emas. Enjoy a unique traditional game of Brunei.
    Copyright (C) 2010  Nor Jaidi Tuah

    This file is part of Pasang Emas.
      
    Pasang Emas is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <string.h>
#include <float.h>
#include <math.h>

typedef enum  {
	PASANG_CUT_OFF_MAX = 10000,
	PASANG_CUT_OFF_MIN = -10000
} PasangCutOff;

#define PASANG_TYPE_CUT_OFF (pasang_cut_off_get_type ())

#define PASANG_TYPE_BRAIN_SPEC (pasang_brain_spec_get_type ())
typedef struct _PasangBrainSpec PasangBrainSpec;

#define PASANG_TYPE_BRAIN (pasang_brain_get_type ())
#define PASANG_BRAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_BRAIN, PasangBrain))
#define PASANG_BRAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_BRAIN, PasangBrainClass))
#define PASANG_IS_BRAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_BRAIN))
#define PASANG_IS_BRAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_BRAIN))
#define PASANG_BRAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_BRAIN, PasangBrainClass))

typedef struct _PasangBrain PasangBrain;
typedef struct _PasangBrainClass PasangBrainClass;
typedef struct _PasangBrainPrivate PasangBrainPrivate;

#define PASANG_TYPE_GAME (pasang_game_get_type ())
#define PASANG_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_GAME, PasangGame))
#define PASANG_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_GAME, PasangGameClass))
#define PASANG_IS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_GAME))
#define PASANG_IS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_GAME))
#define PASANG_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_GAME, PasangGameClass))

typedef struct _PasangGame PasangGame;
typedef struct _PasangGameClass PasangGameClass;
enum  {
	PASANG_BRAIN_0_PROPERTY,
	PASANG_BRAIN_NUM_PROPERTIES
};
static GParamSpec* pasang_brain_properties[PASANG_BRAIN_NUM_PROPERTIES];
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
typedef enum  {
	PASANG_STAGE_NULL = -999,
	PASANG_STAGE_OPENING = 0,
	PASANG_STAGE_SELECT = 1,
	PASANG_STAGE_SUB_SELECT = 2,
	PASANG_STAGE_MOVE = 3,
	PASANG_STAGE_SUB_MOVE = 4,
	PASANG_STAGE_GAME_OVER = 5
} PasangStage;

#define PASANG_TYPE_STAGE (pasang_stage_get_type ())

#define PASANG_TYPE_MOVE (pasang_move_get_type ())
#define PASANG_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_TYPE_MOVE, PasangMove))
#define PASANG_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_TYPE_MOVE, PasangMoveClass))
#define PASANG_IS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_TYPE_MOVE))
#define PASANG_IS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_TYPE_MOVE))
#define PASANG_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_TYPE_MOVE, PasangMoveClass))

typedef struct _PasangMove PasangMove;
typedef struct _PasangMoveClass PasangMoveClass;

#define PASANG_GAME_TYPE_ITERATOR (pasang_game_iterator_get_type ())
#define PASANG_GAME_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PASANG_GAME_TYPE_ITERATOR, PasangGameIterator))
#define PASANG_GAME_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PASANG_GAME_TYPE_ITERATOR, PasangGameIteratorClass))
#define PASANG_GAME_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PASANG_GAME_TYPE_ITERATOR))
#define PASANG_GAME_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PASANG_GAME_TYPE_ITERATOR))
#define PASANG_GAME_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PASANG_GAME_TYPE_ITERATOR, PasangGameIteratorClass))

typedef struct _PasangGameIterator PasangGameIterator;
typedef struct _PasangGameIteratorClass PasangGameIteratorClass;
#define _pasang_game_iterator_unref0(var) ((var == NULL) ? NULL : (var = (pasang_game_iterator_unref (var), NULL)))
typedef struct _PasangGamePrivate PasangGamePrivate;
typedef enum  {
	PASANG_PIECE_NULL = -999,
	PASANG_PIECE_KAS_0 = 0,
	PASANG_PIECE_KAS_1 = 1,
	PASANG_PIECE_BLACK = 2,
	PASANG_PIECE_WHITE = 3,
	PASANG_PIECE_COUNT = 4,
	PASANG_PIECE_BOARD = 4,
	PASANG_PIECE_GUARD = 5,
	PASANG_PIECE_GUIDE = 6,
	PASANG_PIECE_EMPTY = 100
} PasangPiece;

#define PASANG_TYPE_PIECE (pasang_piece_get_type ())
enum  {
	PASANG_BRAIN_GOT_MOVE_SIGNAL_SIGNAL,
	PASANG_BRAIN_NUM_SIGNALS
};
static guint pasang_brain_signals[PASANG_BRAIN_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _PasangBrainSpec {
	gint thinking_time;
	gint thinking_depth;
	gint discernment;
};

struct _PasangBrain {
	GObject parent_instance;
	PasangBrainPrivate * priv;
};

struct _PasangBrainClass {
	GObjectClass parent_class;
};

struct _PasangBrainPrivate {
	glong ticket;
	GTimer* timer;
	PasangBrainSpec brain_spec;
	PasangGame* root;
	GThread* thinking_thread;
	GMutex mutex;
	GCond cond;
	gboolean exiting;
	gboolean stopping;
	gboolean thinking;
};

struct _PasangGame {
	GObject parent_instance;
	PasangGamePrivate * priv;
	PasangPiece* board;
	gint board_length1;
	gint* score;
	gint score_length1;
	gint* kas_position;
	gint kas_position_length1;
	gint* first_move;
	gint first_move_length1;
};

struct _PasangGameClass {
	GObjectClass parent_class;
};

static gint PasangBrain_private_offset;
static gpointer pasang_brain_parent_class = NULL;

GType pasang_cut_off_get_type (void) G_GNUC_CONST;
GType pasang_brain_spec_get_type (void) G_GNUC_CONST;
PasangBrainSpec* pasang_brain_spec_dup (const PasangBrainSpec* self);
void pasang_brain_spec_free (PasangBrainSpec* self);
void pasang_brain_spec_init (PasangBrainSpec *self);
GType pasang_brain_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangBrain, g_object_unref)
GType pasang_game_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangGame, g_object_unref)
void pasang_brain_request_exit (PasangBrain* self);
PasangBrain* pasang_brain_new (void);
PasangBrain* pasang_brain_construct (GType object_type);
static void* pasang_brain_run (PasangBrain* self);
static gpointer _pasang_brain_run_gthread_func (gpointer self);
void pasang_brain_request_stop (PasangBrain* self);
void pasang_brain_request_think (PasangBrain* self,
                                 PasangGame* game,
                                 PasangBrainSpec* spec,
                                 glong* issued_ticked);
GType pasang_stage_get_type (void) G_GNUC_CONST;
PasangStage pasang_game_get_stage (PasangGame* self);
PasangGame* pasang_game_new_clone (PasangGame* source);
PasangGame* pasang_game_construct_clone (GType object_type,
                                         PasangGame* source);
GType pasang_move_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangMove, g_object_unref)
static PasangMove* pasang_brain_think (PasangBrain* self);
void pasang_game_generate_moves (PasangGame* self);
gint pasang_game_numMoves (PasangGame* self);
PasangMove* pasang_game_getMove (PasangGame* self,
                                 gint n);
gpointer pasang_game_iterator_ref (gpointer instance);
void pasang_game_iterator_unref (gpointer instance);
GParamSpec* pasang_game_param_spec_iterator (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags);
void pasang_game_value_set_iterator (GValue* value,
                                     gpointer v_object);
void pasang_game_value_take_iterator (GValue* value,
                                      gpointer v_object);
gpointer pasang_game_value_get_iterator (const GValue* value);
GType pasang_game_iterator_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PasangGameIterator, pasang_game_iterator_unref)
PasangGameIterator* pasang_game_iterator (PasangGame* self);
PasangMove* pasang_game_iterator_next_value (PasangGameIterator* self);
void pasang_move_set_value (PasangMove* self,
                            gint value);
void pasang_game_perform (PasangGame* self,
                          PasangMove* move,
                          gboolean full_move);
static gint pasang_brain_search (PasangBrain* self,
                          gint ply,
                          gint depth,
                          gint max_time,
                          gboolean* depth_reached,
                          PasangGame* game,
                          gint alpha,
                          gint beta);
void pasang_game_sort_moves (PasangGame* self);
static PasangMove* pasang_brain_select_move_randomly (PasangBrain* self);
GType pasang_piece_get_type (void) G_GNUC_CONST;
gint pasang_game_get_player (PasangGame* self);
gint pasang_move_get_value (PasangMove* self);
static void g_cclosure_user_marshal_VOID__LONG_OBJECT (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static void pasang_brain_finalize (GObject * obj);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);

GType
pasang_cut_off_get_type (void)
{
	static volatile gsize pasang_cut_off_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_cut_off_type_id__volatile)) {
		static const GEnumValue values[] = {{PASANG_CUT_OFF_MAX, "PASANG_CUT_OFF_MAX", "max"}, {PASANG_CUT_OFF_MIN, "PASANG_CUT_OFF_MIN", "min"}, {0, NULL, NULL}};
		GType pasang_cut_off_type_id;
		pasang_cut_off_type_id = g_enum_register_static ("PasangCutOff", values);
		g_once_init_leave (&pasang_cut_off_type_id__volatile, pasang_cut_off_type_id);
	}
	return pasang_cut_off_type_id__volatile;
}

void
pasang_brain_spec_init (PasangBrainSpec *self)
{
#line 30 "brain.vala"
	memset (self, 0, sizeof (PasangBrainSpec));
#line 31 "brain.vala"
	(*self).thinking_time = 1;
#line 32 "brain.vala"
	(*self).thinking_depth = 2;
#line 33 "brain.vala"
	(*self).discernment = 2;
#line 274 "brain.c"
}

PasangBrainSpec*
pasang_brain_spec_dup (const PasangBrainSpec* self)
{
	PasangBrainSpec* dup;
#line 26 "brain.vala"
	dup = g_new0 (PasangBrainSpec, 1);
#line 26 "brain.vala"
	memcpy (dup, self, sizeof (PasangBrainSpec));
#line 26 "brain.vala"
	return dup;
#line 287 "brain.c"
}

void
pasang_brain_spec_free (PasangBrainSpec* self)
{
#line 26 "brain.vala"
	g_free (self);
#line 295 "brain.c"
}

GType
pasang_brain_spec_get_type (void)
{
	static volatile gsize pasang_brain_spec_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_brain_spec_type_id__volatile)) {
		GType pasang_brain_spec_type_id;
		pasang_brain_spec_type_id = g_boxed_type_register_static ("PasangBrainSpec", (GBoxedCopyFunc) pasang_brain_spec_dup, (GBoxedFreeFunc) pasang_brain_spec_free);
		g_once_init_leave (&pasang_brain_spec_type_id__volatile, pasang_brain_spec_type_id);
	}
	return pasang_brain_spec_type_id__volatile;
}

static inline gpointer
pasang_brain_get_instance_private (PasangBrain* self)
{
	return G_STRUCT_MEMBER_P (self, PasangBrain_private_offset);
}

/**
     * The brain thinks using its own thread so that the GUI remains responsive.
     */
static gpointer
_pasang_brain_run_gthread_func (gpointer self)
{
	gpointer result;
	result = pasang_brain_run ((PasangBrain*) self);
#line 92 "brain.vala"
	g_object_unref (self);
#line 92 "brain.vala"
	return result;
#line 328 "brain.c"
}

PasangBrain*
pasang_brain_construct (GType object_type)
{
	PasangBrain * self = NULL;
	GThread* _tmp0_;
#line 88 "brain.vala"
	self = (PasangBrain*) g_object_new (object_type, NULL);
#line 89 "brain.vala"
	self->priv->exiting = FALSE;
#line 90 "brain.vala"
	self->priv->stopping = FALSE;
#line 91 "brain.vala"
	self->priv->thinking = FALSE;
#line 92 "brain.vala"
	_tmp0_ = g_thread_new ("thinking", _pasang_brain_run_gthread_func, g_object_ref (self));
#line 92 "brain.vala"
	_g_thread_unref0 (self->priv->thinking_thread);
#line 92 "brain.vala"
	self->priv->thinking_thread = _tmp0_;
#line 88 "brain.vala"
	return self;
#line 352 "brain.c"
}

PasangBrain*
pasang_brain_new (void)
{
#line 88 "brain.vala"
	return pasang_brain_construct (PASANG_TYPE_BRAIN);
#line 360 "brain.c"
}

/**
     * Request the thinking thread to exit. Wait for the request to be complied.
     */
void
pasang_brain_request_exit (PasangBrain* self)
{
	GThread* _tmp0_;
#line 102 "brain.vala"
	g_return_if_fail (self != NULL);
#line 103 "brain.vala"
	self->priv->exiting = TRUE;
#line 104 "brain.vala"
	self->priv->stopping = TRUE;
#line 105 "brain.vala"
	g_mutex_lock (&self->priv->mutex);
#line 378 "brain.c"
	{
#line 106 "brain.vala"
		self->priv->thinking = FALSE;
#line 107 "brain.vala"
		g_cond_signal (&self->priv->cond);
#line 384 "brain.c"
	}
#line 108 "brain.vala"
	g_mutex_unlock (&self->priv->mutex);
#line 109 "brain.vala"
	_tmp0_ = self->priv->thinking_thread;
#line 109 "brain.vala"
	self->priv->thinking_thread = NULL;
#line 109 "brain.vala"
	g_thread_join (_tmp0_);
#line 394 "brain.c"
}

/**
     * Request the thinking thread to abandon on-going thinking. 
     * Wait for the request to be complied.
     */
void
pasang_brain_request_stop (PasangBrain* self)
{
#line 116 "brain.vala"
	g_return_if_fail (self != NULL);
#line 117 "brain.vala"
	self->priv->stopping = TRUE;
#line 118 "brain.vala"
	g_mutex_lock (&self->priv->mutex);
#line 410 "brain.c"
	{
#line 119 "brain.vala"
		self->priv->stopping = FALSE;
#line 414 "brain.c"
	}
#line 120 "brain.vala"
	g_mutex_unlock (&self->priv->mutex);
#line 418 "brain.c"
}

/**
     * Request thinking on a new game configuration, killing any
     * on-going thinking prior to that.
     * This function returns its result via an out argument because the
     * result has to be set within the critical block. This alternative won't work:
     *    issued_ticket = request_think (game, vp)  <-- error
     * because the assignment is done outside the critical region.
     */
void
pasang_brain_request_think (PasangBrain* self,
                            PasangGame* game,
                            PasangBrainSpec* spec,
                            glong* issued_ticked)
{
	glong _vala_issued_ticked = 0L;
	PasangStage _tmp0_;
	PasangStage _tmp1_;
#line 131 "brain.vala"
	g_return_if_fail (self != NULL);
#line 131 "brain.vala"
	g_return_if_fail (game != NULL);
#line 131 "brain.vala"
	g_return_if_fail (spec != NULL);
#line 131 "brain.vala"
	_tmp0_ = pasang_game_get_stage (game);
#line 131 "brain.vala"
	_tmp1_ = _tmp0_;
#line 131 "brain.vala"
	_vala_return_if_fail (_tmp1_ != PASANG_STAGE_GAME_OVER, "game.stage != Stage.GAME_OVER");
#line 133 "brain.vala"
	self->priv->stopping = TRUE;
#line 134 "brain.vala"
	g_mutex_lock (&self->priv->mutex);
#line 454 "brain.c"
	{
		PasangGame* _tmp2_;
		PasangBrainSpec _tmp3_;
#line 135 "brain.vala"
		self->priv->stopping = FALSE;
#line 136 "brain.vala"
		self->priv->thinking = TRUE;
#line 137 "brain.vala"
		_tmp2_ = pasang_game_new_clone (game);
#line 137 "brain.vala"
		_g_object_unref0 (self->priv->root);
#line 137 "brain.vala"
		self->priv->root = _tmp2_;
#line 138 "brain.vala"
		self->priv->ticket = self->priv->ticket + 1;
#line 138 "brain.vala"
		_vala_issued_ticked = self->priv->ticket;
#line 139 "brain.vala"
		_tmp3_ = *spec;
#line 139 "brain.vala"
		self->priv->brain_spec = _tmp3_;
#line 140 "brain.vala"
		g_cond_signal (&self->priv->cond);
#line 478 "brain.c"
	}
#line 141 "brain.vala"
	g_mutex_unlock (&self->priv->mutex);
#line 131 "brain.vala"
	if (issued_ticked) {
#line 131 "brain.vala"
		*issued_ticked = _vala_issued_ticked;
#line 486 "brain.c"
	}
}

/**
     * The task for the thinking thread. To stop this thread, call request_exit.
     */
static void*
pasang_brain_run (PasangBrain* self)
{
	void* result = NULL;
#line 147 "brain.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 148 "brain.vala"
	while (TRUE) {
#line 148 "brain.vala"
		if (!(!self->priv->exiting)) {
#line 148 "brain.vala"
			break;
#line 505 "brain.c"
		}
#line 149 "brain.vala"
		g_mutex_lock (&self->priv->mutex);
#line 509 "brain.c"
		{
#line 150 "brain.vala"
			if (self->priv->thinking) {
#line 513 "brain.c"
				PasangMove* response = NULL;
				PasangMove* _tmp0_;
#line 151 "brain.vala"
				_tmp0_ = pasang_brain_think (self);
#line 151 "brain.vala"
				response = _tmp0_;
#line 152 "brain.vala"
				if (!self->priv->stopping) {
#line 522 "brain.c"
					PasangMove* _tmp1_;
#line 152 "brain.vala"
					_tmp1_ = response;
#line 152 "brain.vala"
					g_signal_emit (self, pasang_brain_signals[PASANG_BRAIN_GOT_MOVE_SIGNAL_SIGNAL], 0, self->priv->ticket, _tmp1_);
#line 528 "brain.c"
				}
#line 153 "brain.vala"
				self->priv->thinking = FALSE;
#line 150 "brain.vala"
				_g_object_unref0 (response);
#line 534 "brain.c"
			}
#line 155 "brain.vala"
			if (!self->priv->exiting) {
#line 155 "brain.vala"
				g_cond_wait (&self->priv->cond, &self->priv->mutex);
#line 540 "brain.c"
			}
		}
#line 156 "brain.vala"
		g_mutex_unlock (&self->priv->mutex);
#line 545 "brain.c"
	}
#line 158 "brain.vala"
	result = NULL;
#line 158 "brain.vala"
	return result;
#line 551 "brain.c"
}

/**
     * Perform iterative deepening, and then inject some randomness to 
     * the move selection.
     */
static PasangMove*
pasang_brain_think (PasangBrain* self)
{
	gint max_time = 0;
	PasangBrainSpec _tmp0_;
	gint max_ply = 0;
	PasangBrainSpec _tmp1_;
	PasangGame* _tmp2_;
	PasangGame* _tmp3_;
	GTimer* _tmp12_;
	PasangMove* _tmp32_;
	PasangMove* result = NULL;
#line 165 "brain.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 167 "brain.vala"
	_tmp0_ = self->priv->brain_spec;
#line 167 "brain.vala"
	max_time = _tmp0_.thinking_time;
#line 168 "brain.vala"
	_tmp1_ = self->priv->brain_spec;
#line 168 "brain.vala"
	max_ply = _tmp1_.thinking_depth * 2;
#line 171 "brain.vala"
	_tmp2_ = self->priv->root;
#line 171 "brain.vala"
	pasang_game_generate_moves (_tmp2_);
#line 172 "brain.vala"
	_tmp3_ = self->priv->root;
#line 172 "brain.vala"
	if (pasang_game_numMoves (_tmp3_) == 1) {
#line 588 "brain.c"
		PasangGame* _tmp4_;
		PasangMove* _tmp5_;
#line 172 "brain.vala"
		_tmp4_ = self->priv->root;
#line 172 "brain.vala"
		_tmp5_ = pasang_game_getMove (_tmp4_, 0);
#line 172 "brain.vala"
		result = _tmp5_;
#line 172 "brain.vala"
		return result;
#line 599 "brain.c"
	}
	{
		PasangGameIterator* _move_it = NULL;
		PasangGame* _tmp6_;
		PasangGameIterator* _tmp7_;
		PasangMove* move = NULL;
#line 173 "brain.vala"
		_tmp6_ = self->priv->root;
#line 173 "brain.vala"
		_tmp7_ = pasang_game_iterator (_tmp6_);
#line 173 "brain.vala"
		_move_it = _tmp7_;
#line 173 "brain.vala"
		while (TRUE) {
#line 614 "brain.c"
			PasangGameIterator* _tmp8_;
			PasangMove* _tmp9_;
			PasangMove* _tmp10_;
			PasangMove* _tmp11_;
#line 173 "brain.vala"
			_tmp8_ = _move_it;
#line 173 "brain.vala"
			_tmp9_ = pasang_game_iterator_next_value (_tmp8_);
#line 173 "brain.vala"
			_g_object_unref0 (move);
#line 173 "brain.vala"
			move = _tmp9_;
#line 173 "brain.vala"
			_tmp10_ = move;
#line 173 "brain.vala"
			if (!(_tmp10_ != NULL)) {
#line 173 "brain.vala"
				break;
#line 633 "brain.c"
			}
#line 174 "brain.vala"
			_tmp11_ = move;
#line 174 "brain.vala"
			pasang_move_set_value (_tmp11_, (gint) PASANG_CUT_OFF_MIN);
#line 639 "brain.c"
		}
#line 173 "brain.vala"
		_g_object_unref0 (move);
#line 173 "brain.vala"
		_pasang_game_iterator_unref0 (_move_it);
#line 645 "brain.c"
	}
#line 178 "brain.vala"
	_tmp12_ = self->priv->timer;
#line 178 "brain.vala"
	g_timer_reset (_tmp12_);
#line 651 "brain.c"
	{
		gint depth = 0;
#line 179 "brain.vala"
		depth = 1;
#line 656 "brain.c"
		{
			gboolean _tmp13_ = FALSE;
#line 179 "brain.vala"
			_tmp13_ = TRUE;
#line 179 "brain.vala"
			while (TRUE) {
#line 663 "brain.c"
				gboolean _tmp15_ = FALSE;
				gboolean depth_reached = FALSE;
				PasangGame* _tmp31_;
#line 179 "brain.vala"
				if (!_tmp13_) {
#line 669 "brain.c"
					gint _tmp14_;
#line 179 "brain.vala"
					_tmp14_ = depth;
#line 179 "brain.vala"
					depth = _tmp14_ + 1;
#line 675 "brain.c"
				}
#line 179 "brain.vala"
				_tmp13_ = FALSE;
#line 179 "brain.vala"
				if (!(depth < max_ply)) {
#line 179 "brain.vala"
					break;
#line 683 "brain.c"
				}
#line 181 "brain.vala"
				if (self->priv->stopping) {
#line 181 "brain.vala"
					_tmp15_ = TRUE;
#line 689 "brain.c"
				} else {
					GTimer* _tmp16_;
#line 181 "brain.vala"
					_tmp16_ = self->priv->timer;
#line 181 "brain.vala"
					_tmp15_ = g_timer_elapsed (_tmp16_, NULL) > ((gdouble) max_time);
#line 696 "brain.c"
				}
#line 181 "brain.vala"
				if (_tmp15_) {
#line 181 "brain.vala"
					break;
#line 702 "brain.c"
				}
#line 182 "brain.vala"
				depth_reached = FALSE;
#line 706 "brain.c"
				{
					PasangGameIterator* _move_it = NULL;
					PasangGame* _tmp17_;
					PasangGameIterator* _tmp18_;
					PasangMove* move = NULL;
#line 187 "brain.vala"
					_tmp17_ = self->priv->root;
#line 187 "brain.vala"
					_tmp18_ = pasang_game_iterator (_tmp17_);
#line 187 "brain.vala"
					_move_it = _tmp18_;
#line 187 "brain.vala"
					while (TRUE) {
#line 720 "brain.c"
						PasangGameIterator* _tmp19_;
						PasangMove* _tmp20_;
						PasangMove* _tmp21_;
						PasangGame* game = NULL;
						PasangGame* _tmp22_;
						PasangGame* _tmp23_;
						PasangGame* _tmp24_;
						PasangMove* _tmp25_;
						gint val = 0;
						PasangGame* _tmp26_;
						gint _tmp27_;
						gboolean _tmp28_ = FALSE;
#line 187 "brain.vala"
						_tmp19_ = _move_it;
#line 187 "brain.vala"
						_tmp20_ = pasang_game_iterator_next_value (_tmp19_);
#line 187 "brain.vala"
						_g_object_unref0 (move);
#line 187 "brain.vala"
						move = _tmp20_;
#line 187 "brain.vala"
						_tmp21_ = move;
#line 187 "brain.vala"
						if (!(_tmp21_ != NULL)) {
#line 187 "brain.vala"
							break;
#line 747 "brain.c"
						}
#line 188 "brain.vala"
						_tmp22_ = self->priv->root;
#line 188 "brain.vala"
						_tmp23_ = pasang_game_new_clone (_tmp22_);
#line 188 "brain.vala"
						game = _tmp23_;
#line 189 "brain.vala"
						_tmp24_ = game;
#line 189 "brain.vala"
						_tmp25_ = move;
#line 189 "brain.vala"
						pasang_game_perform (_tmp24_, _tmp25_, TRUE);
#line 190 "brain.vala"
						_tmp26_ = game;
#line 190 "brain.vala"
						_tmp27_ = pasang_brain_search (self, 1, depth, max_time, &depth_reached, _tmp26_, (gint) PASANG_CUT_OFF_MIN, (gint) PASANG_CUT_OFF_MAX);
#line 190 "brain.vala"
						val = -_tmp27_;
#line 193 "brain.vala"
						if (self->priv->stopping) {
#line 193 "brain.vala"
							_tmp28_ = TRUE;
#line 771 "brain.c"
						} else {
							GTimer* _tmp29_;
#line 193 "brain.vala"
							_tmp29_ = self->priv->timer;
#line 193 "brain.vala"
							_tmp28_ = g_timer_elapsed (_tmp29_, NULL) > ((gdouble) max_time);
#line 778 "brain.c"
						}
#line 193 "brain.vala"
						if (_tmp28_) {
#line 195 "brain.vala"
							_g_object_unref0 (game);
#line 195 "brain.vala"
							break;
#line 786 "brain.c"
						} else {
							PasangMove* _tmp30_;
#line 199 "brain.vala"
							_tmp30_ = move;
#line 199 "brain.vala"
							pasang_move_set_value (_tmp30_, (val * 10) + g_random_int_range ((gint32) 0, (gint32) 10));
#line 793 "brain.c"
						}
#line 187 "brain.vala"
						_g_object_unref0 (game);
#line 797 "brain.c"
					}
#line 187 "brain.vala"
					_g_object_unref0 (move);
#line 187 "brain.vala"
					_pasang_game_iterator_unref0 (_move_it);
#line 803 "brain.c"
				}
#line 202 "brain.vala"
				_tmp31_ = self->priv->root;
#line 202 "brain.vala"
				pasang_game_sort_moves (_tmp31_);
#line 205 "brain.vala"
				if (!depth_reached) {
#line 205 "brain.vala"
					break;
#line 813 "brain.c"
				}
			}
		}
	}
#line 207 "brain.vala"
	_tmp32_ = pasang_brain_select_move_randomly (self);
#line 207 "brain.vala"
	result = _tmp32_;
#line 207 "brain.vala"
	return result;
#line 824 "brain.c"
}

/**
     * Search to the given depth. Return evaluation.
     * Side effect: depth_reached set to true if ply == depth.
     */
static gint
pasang_brain_search (PasangBrain* self,
                     gint ply,
                     gint depth,
                     gint max_time,
                     gboolean* depth_reached,
                     PasangGame* game,
                     gint alpha,
                     gint beta)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp2_ = FALSE;
	PasangStage _tmp3_;
	PasangStage _tmp4_;
	gint result = 0;
#line 214 "brain.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 214 "brain.vala"
	g_return_val_if_fail (game != NULL, 0);
#line 217 "brain.vala"
	if (self->priv->stopping) {
#line 217 "brain.vala"
		_tmp0_ = TRUE;
#line 854 "brain.c"
	} else {
		GTimer* _tmp1_;
#line 217 "brain.vala"
		_tmp1_ = self->priv->timer;
#line 217 "brain.vala"
		_tmp0_ = g_timer_elapsed (_tmp1_, NULL) > ((gdouble) max_time);
#line 861 "brain.c"
	}
#line 217 "brain.vala"
	if (_tmp0_) {
#line 217 "brain.vala"
		result = 0;
#line 217 "brain.vala"
		return result;
#line 869 "brain.c"
	}
#line 219 "brain.vala"
	_tmp3_ = pasang_game_get_stage (game);
#line 219 "brain.vala"
	_tmp4_ = _tmp3_;
#line 219 "brain.vala"
	if (_tmp4_ == PASANG_STAGE_GAME_OVER) {
#line 219 "brain.vala"
		_tmp2_ = TRUE;
#line 879 "brain.c"
	} else {
#line 219 "brain.vala"
		_tmp2_ = ply == depth;
#line 883 "brain.c"
	}
#line 219 "brain.vala"
	if (_tmp2_) {
#line 887 "brain.c"
		gint* _tmp5_;
		gint _tmp5__length1;
		gint _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint* _tmp9_;
		gint _tmp9__length1;
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
#line 220 "brain.vala"
		if (ply == depth) {
#line 220 "brain.vala"
			*depth_reached = TRUE;
#line 902 "brain.c"
		}
#line 221 "brain.vala"
		_tmp5_ = game->score;
#line 221 "brain.vala"
		_tmp5__length1 = game->score_length1;
#line 221 "brain.vala"
		_tmp6_ = pasang_game_get_player (game);
#line 221 "brain.vala"
		_tmp7_ = _tmp6_;
#line 221 "brain.vala"
		_tmp8_ = _tmp5_[_tmp7_];
#line 221 "brain.vala"
		_tmp9_ = game->score;
#line 221 "brain.vala"
		_tmp9__length1 = game->score_length1;
#line 221 "brain.vala"
		_tmp10_ = pasang_game_get_player (game);
#line 221 "brain.vala"
		_tmp11_ = _tmp10_;
#line 221 "brain.vala"
		_tmp12_ = _tmp9_[1 - _tmp11_];
#line 221 "brain.vala"
		result = _tmp8_ - _tmp12_;
#line 221 "brain.vala"
		return result;
#line 928 "brain.c"
	}
	{
		PasangGameIterator* _move_it = NULL;
		PasangGameIterator* _tmp13_;
		PasangMove* move = NULL;
#line 224 "brain.vala"
		_tmp13_ = pasang_game_iterator (game);
#line 224 "brain.vala"
		_move_it = _tmp13_;
#line 224 "brain.vala"
		while (TRUE) {
#line 940 "brain.c"
			PasangGameIterator* _tmp14_;
			PasangMove* _tmp15_;
			PasangMove* _tmp16_;
			PasangGame* game2 = NULL;
			PasangGame* _tmp17_;
			PasangGame* _tmp18_;
			PasangMove* _tmp19_;
			gint val = 0;
			PasangGame* _tmp20_;
			gint _tmp21_;
#line 224 "brain.vala"
			_tmp14_ = _move_it;
#line 224 "brain.vala"
			_tmp15_ = pasang_game_iterator_next_value (_tmp14_);
#line 224 "brain.vala"
			_g_object_unref0 (move);
#line 224 "brain.vala"
			move = _tmp15_;
#line 224 "brain.vala"
			_tmp16_ = move;
#line 224 "brain.vala"
			if (!(_tmp16_ != NULL)) {
#line 224 "brain.vala"
				break;
#line 965 "brain.c"
			}
#line 225 "brain.vala"
			_tmp17_ = pasang_game_new_clone (game);
#line 225 "brain.vala"
			game2 = _tmp17_;
#line 226 "brain.vala"
			_tmp18_ = game2;
#line 226 "brain.vala"
			_tmp19_ = move;
#line 226 "brain.vala"
			pasang_game_perform (_tmp18_, _tmp19_, TRUE);
#line 227 "brain.vala"
			_tmp20_ = game2;
#line 227 "brain.vala"
			_tmp21_ = pasang_brain_search (self, ply + 1, depth, max_time, depth_reached, _tmp20_, -beta, -alpha);
#line 227 "brain.vala"
			val = -_tmp21_;
#line 230 "brain.vala"
			if (val > alpha) {
#line 230 "brain.vala"
				alpha = val;
#line 987 "brain.c"
			}
#line 231 "brain.vala"
			if (alpha > beta) {
#line 231 "brain.vala"
				_g_object_unref0 (game2);
#line 231 "brain.vala"
				break;
#line 995 "brain.c"
			}
#line 224 "brain.vala"
			_g_object_unref0 (game2);
#line 999 "brain.c"
		}
#line 224 "brain.vala"
		_g_object_unref0 (move);
#line 224 "brain.vala"
		_pasang_game_iterator_unref0 (_move_it);
#line 1005 "brain.c"
	}
#line 233 "brain.vala"
	result = alpha;
#line 233 "brain.vala"
	return result;
#line 1011 "brain.c"
}

/**
     * Provide some variability in the line of play.
     * Assume root's branches are sorted in descending values.
     */
static PasangMove*
pasang_brain_select_move_randomly (PasangBrain* self)
{
	PasangGame* _tmp0_;
	PasangStage _tmp1_;
	PasangStage _tmp2_;
	gint smallest_value = 0;
	PasangGame* _tmp25_;
	PasangGame* _tmp26_;
	PasangMove* _tmp27_;
	PasangMove* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gint _tmp31_;
	gint total = 0;
	gint num_rolls = 0;
	PasangBrainSpec _tmp40_;
	PasangGame* _tmp41_;
	PasangStage _tmp42_;
	PasangStage _tmp43_;
	gint roll = 0;
	PasangGame* _tmp57_;
	PasangMove* _tmp58_;
	PasangMove* result = NULL;
#line 241 "brain.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 242 "brain.vala"
	_tmp0_ = self->priv->root;
#line 242 "brain.vala"
	_tmp1_ = pasang_game_get_stage (_tmp0_);
#line 242 "brain.vala"
	_tmp2_ = _tmp1_;
#line 242 "brain.vala"
	if (_tmp2_ == PASANG_STAGE_OPENING) {
#line 1052 "brain.c"
		{
			PasangGameIterator* _move_it = NULL;
			PasangGame* _tmp3_;
			PasangGameIterator* _tmp4_;
			PasangMove* move = NULL;
#line 244 "brain.vala"
			_tmp3_ = self->priv->root;
#line 244 "brain.vala"
			_tmp4_ = pasang_game_iterator (_tmp3_);
#line 244 "brain.vala"
			_move_it = _tmp4_;
#line 244 "brain.vala"
			while (TRUE) {
#line 1066 "brain.c"
				PasangGameIterator* _tmp5_;
				PasangMove* _tmp6_;
				PasangMove* _tmp7_;
				PasangMove* _tmp8_;
				PasangMove* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
#line 244 "brain.vala"
				_tmp5_ = _move_it;
#line 244 "brain.vala"
				_tmp6_ = pasang_game_iterator_next_value (_tmp5_);
#line 244 "brain.vala"
				_g_object_unref0 (move);
#line 244 "brain.vala"
				move = _tmp6_;
#line 244 "brain.vala"
				_tmp7_ = move;
#line 244 "brain.vala"
				if (!(_tmp7_ != NULL)) {
#line 244 "brain.vala"
					break;
#line 1088 "brain.c"
				}
#line 245 "brain.vala"
				_tmp8_ = move;
#line 245 "brain.vala"
				_tmp9_ = move;
#line 245 "brain.vala"
				_tmp10_ = pasang_move_get_value (_tmp9_);
#line 245 "brain.vala"
				_tmp11_ = _tmp10_;
#line 245 "brain.vala"
				pasang_move_set_value (_tmp9_, _tmp11_ / 10);
#line 1100 "brain.c"
			}
#line 244 "brain.vala"
			_g_object_unref0 (move);
#line 244 "brain.vala"
			_pasang_game_iterator_unref0 (_move_it);
#line 1106 "brain.c"
		}
	} else {
		gint discernment = 0;
		PasangBrainSpec _tmp12_;
#line 250 "brain.vala"
		_tmp12_ = self->priv->brain_spec;
#line 250 "brain.vala"
		discernment = (_tmp12_.discernment - 1) * 5;
#line 1115 "brain.c"
		{
			PasangGameIterator* _move_it = NULL;
			PasangGame* _tmp13_;
			PasangGameIterator* _tmp14_;
			PasangMove* move = NULL;
#line 251 "brain.vala"
			_tmp13_ = self->priv->root;
#line 251 "brain.vala"
			_tmp14_ = pasang_game_iterator (_tmp13_);
#line 251 "brain.vala"
			_move_it = _tmp14_;
#line 251 "brain.vala"
			while (TRUE) {
#line 1129 "brain.c"
				PasangGameIterator* _tmp15_;
				PasangMove* _tmp16_;
				PasangMove* _tmp17_;
				PasangMove* _tmp18_;
				gint _tmp19_;
				gint _tmp20_;
#line 251 "brain.vala"
				_tmp15_ = _move_it;
#line 251 "brain.vala"
				_tmp16_ = pasang_game_iterator_next_value (_tmp15_);
#line 251 "brain.vala"
				_g_object_unref0 (move);
#line 251 "brain.vala"
				move = _tmp16_;
#line 251 "brain.vala"
				_tmp17_ = move;
#line 251 "brain.vala"
				if (!(_tmp17_ != NULL)) {
#line 251 "brain.vala"
					break;
#line 1150 "brain.c"
				}
#line 252 "brain.vala"
				_tmp18_ = move;
#line 252 "brain.vala"
				_tmp19_ = pasang_move_get_value (_tmp18_);
#line 252 "brain.vala"
				_tmp20_ = _tmp19_;
#line 252 "brain.vala"
				if (_tmp20_ > 0) {
#line 1160 "brain.c"
					PasangMove* _tmp21_;
					PasangMove* _tmp22_;
					gint _tmp23_;
					gint _tmp24_;
#line 252 "brain.vala"
					_tmp21_ = move;
#line 252 "brain.vala"
					_tmp22_ = move;
#line 252 "brain.vala"
					_tmp23_ = pasang_move_get_value (_tmp22_);
#line 252 "brain.vala"
					_tmp24_ = _tmp23_;
#line 252 "brain.vala"
					pasang_move_set_value (_tmp22_, _tmp24_ + discernment);
#line 1175 "brain.c"
				}
			}
#line 251 "brain.vala"
			_g_object_unref0 (move);
#line 251 "brain.vala"
			_pasang_game_iterator_unref0 (_move_it);
#line 1182 "brain.c"
		}
	}
#line 257 "brain.vala"
	_tmp25_ = self->priv->root;
#line 257 "brain.vala"
	_tmp26_ = self->priv->root;
#line 257 "brain.vala"
	_tmp27_ = pasang_game_getMove (_tmp25_, pasang_game_numMoves (_tmp26_) - 1);
#line 257 "brain.vala"
	_tmp28_ = _tmp27_;
#line 257 "brain.vala"
	_tmp29_ = pasang_move_get_value (_tmp28_);
#line 257 "brain.vala"
	_tmp30_ = _tmp29_;
#line 257 "brain.vala"
	_tmp31_ = _tmp30_;
#line 257 "brain.vala"
	_g_object_unref0 (_tmp28_);
#line 257 "brain.vala"
	smallest_value = _tmp31_;
#line 258 "brain.vala"
	total = 0;
#line 1205 "brain.c"
	{
		PasangGameIterator* _move_it = NULL;
		PasangGame* _tmp32_;
		PasangGameIterator* _tmp33_;
		PasangMove* move = NULL;
#line 259 "brain.vala"
		_tmp32_ = self->priv->root;
#line 259 "brain.vala"
		_tmp33_ = pasang_game_iterator (_tmp32_);
#line 259 "brain.vala"
		_move_it = _tmp33_;
#line 259 "brain.vala"
		while (TRUE) {
#line 1219 "brain.c"
			PasangGameIterator* _tmp34_;
			PasangMove* _tmp35_;
			PasangMove* _tmp36_;
			PasangMove* _tmp37_;
			gint _tmp38_;
			gint _tmp39_;
#line 259 "brain.vala"
			_tmp34_ = _move_it;
#line 259 "brain.vala"
			_tmp35_ = pasang_game_iterator_next_value (_tmp34_);
#line 259 "brain.vala"
			_g_object_unref0 (move);
#line 259 "brain.vala"
			move = _tmp35_;
#line 259 "brain.vala"
			_tmp36_ = move;
#line 259 "brain.vala"
			if (!(_tmp36_ != NULL)) {
#line 259 "brain.vala"
				break;
#line 1240 "brain.c"
			}
#line 260 "brain.vala"
			_tmp37_ = move;
#line 260 "brain.vala"
			_tmp38_ = pasang_move_get_value (_tmp37_);
#line 260 "brain.vala"
			_tmp39_ = _tmp38_;
#line 260 "brain.vala"
			total += (_tmp39_ - smallest_value) + 1;
#line 1250 "brain.c"
		}
#line 259 "brain.vala"
		_g_object_unref0 (move);
#line 259 "brain.vala"
		_pasang_game_iterator_unref0 (_move_it);
#line 1256 "brain.c"
	}
#line 263 "brain.vala"
	_tmp40_ = self->priv->brain_spec;
#line 263 "brain.vala"
	num_rolls = _tmp40_.discernment;
#line 265 "brain.vala"
	_tmp41_ = self->priv->root;
#line 265 "brain.vala"
	_tmp42_ = pasang_game_get_stage (_tmp41_);
#line 265 "brain.vala"
	_tmp43_ = _tmp42_;
#line 265 "brain.vala"
	if (_tmp43_ == PASANG_STAGE_OPENING) {
#line 265 "brain.vala"
		num_rolls = 1;
#line 1272 "brain.c"
	} else {
		PasangGame* _tmp44_;
		PasangStage _tmp45_;
		PasangStage _tmp46_;
#line 266 "brain.vala"
		_tmp44_ = self->priv->root;
#line 266 "brain.vala"
		_tmp45_ = pasang_game_get_stage (_tmp44_);
#line 266 "brain.vala"
		_tmp46_ = _tmp45_;
#line 266 "brain.vala"
		if (_tmp46_ == PASANG_STAGE_SELECT) {
#line 266 "brain.vala"
			num_rolls /= 2;
#line 1287 "brain.c"
		}
	}
#line 267 "brain.vala"
	roll = (gint) g_random_int_range ((gint32) 0, (gint32) total);
#line 1292 "brain.c"
	{
		gint i = 0;
#line 268 "brain.vala"
		i = 1;
#line 1297 "brain.c"
		{
			gboolean _tmp47_ = FALSE;
#line 268 "brain.vala"
			_tmp47_ = TRUE;
#line 268 "brain.vala"
			while (TRUE) {
#line 1304 "brain.c"
				gint roll2 = 0;
#line 268 "brain.vala"
				if (!_tmp47_) {
#line 1308 "brain.c"
					gint _tmp48_;
#line 268 "brain.vala"
					_tmp48_ = i;
#line 268 "brain.vala"
					i = _tmp48_ + 1;
#line 1314 "brain.c"
				}
#line 268 "brain.vala"
				_tmp47_ = FALSE;
#line 268 "brain.vala"
				if (!(i < num_rolls)) {
#line 268 "brain.vala"
					break;
#line 1322 "brain.c"
				}
#line 269 "brain.vala"
				roll2 = (gint) g_random_int_range ((gint32) 0, (gint32) total);
#line 270 "brain.vala"
				if (roll > roll2) {
#line 270 "brain.vala"
					roll = roll2;
#line 1330 "brain.c"
				}
			}
		}
	}
	{
		PasangGameIterator* _move_it = NULL;
		PasangGame* _tmp49_;
		PasangGameIterator* _tmp50_;
		PasangMove* move = NULL;
#line 273 "brain.vala"
		_tmp49_ = self->priv->root;
#line 273 "brain.vala"
		_tmp50_ = pasang_game_iterator (_tmp49_);
#line 273 "brain.vala"
		_move_it = _tmp50_;
#line 273 "brain.vala"
		while (TRUE) {
#line 1348 "brain.c"
			PasangGameIterator* _tmp51_;
			PasangMove* _tmp52_;
			PasangMove* _tmp53_;
			PasangMove* _tmp54_;
			gint _tmp55_;
			gint _tmp56_;
#line 273 "brain.vala"
			_tmp51_ = _move_it;
#line 273 "brain.vala"
			_tmp52_ = pasang_game_iterator_next_value (_tmp51_);
#line 273 "brain.vala"
			_g_object_unref0 (move);
#line 273 "brain.vala"
			move = _tmp52_;
#line 273 "brain.vala"
			_tmp53_ = move;
#line 273 "brain.vala"
			if (!(_tmp53_ != NULL)) {
#line 273 "brain.vala"
				break;
#line 1369 "brain.c"
			}
#line 274 "brain.vala"
			_tmp54_ = move;
#line 274 "brain.vala"
			_tmp55_ = pasang_move_get_value (_tmp54_);
#line 274 "brain.vala"
			_tmp56_ = _tmp55_;
#line 274 "brain.vala"
			roll -= (_tmp56_ - smallest_value) + 1;
#line 275 "brain.vala"
			if (roll < 0) {
#line 275 "brain.vala"
				result = move;
#line 275 "brain.vala"
				_pasang_game_iterator_unref0 (_move_it);
#line 275 "brain.vala"
				return result;
#line 1387 "brain.c"
			}
		}
#line 273 "brain.vala"
		_g_object_unref0 (move);
#line 273 "brain.vala"
		_pasang_game_iterator_unref0 (_move_it);
#line 1394 "brain.c"
	}
#line 277 "brain.vala"
	_tmp57_ = self->priv->root;
#line 277 "brain.vala"
	_tmp58_ = pasang_game_getMove (_tmp57_, 0);
#line 277 "brain.vala"
	result = _tmp58_;
#line 277 "brain.vala"
	return result;
#line 1404 "brain.c"
}

static void
g_cclosure_user_marshal_VOID__LONG_OBJECT (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__LONG_OBJECT) (gpointer data1, glong arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__LONG_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 37 "brain.vala"
	g_return_if_fail (n_param_values == 3);
#line 37 "brain.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 37 "brain.vala"
		data1 = closure->data;
#line 37 "brain.vala"
		data2 = param_values->data[0].v_pointer;
#line 1429 "brain.c"
	} else {
#line 37 "brain.vala"
		data1 = param_values->data[0].v_pointer;
#line 37 "brain.vala"
		data2 = closure->data;
#line 1435 "brain.c"
	}
#line 37 "brain.vala"
	callback = (GMarshalFunc_VOID__LONG_OBJECT) (marshal_data ? marshal_data : cc->callback);
#line 37 "brain.vala"
	callback (data1, g_value_get_long (param_values + 1), g_value_get_object (param_values + 2), data2);
#line 1441 "brain.c"
}

static void
pasang_brain_class_init (PasangBrainClass * klass,
                         gpointer klass_data)
{
#line 37 "brain.vala"
	pasang_brain_parent_class = g_type_class_peek_parent (klass);
#line 37 "brain.vala"
	g_type_class_adjust_private_offset (klass, &PasangBrain_private_offset);
#line 37 "brain.vala"
	G_OBJECT_CLASS (klass)->finalize = pasang_brain_finalize;
#line 1454 "brain.c"
	/**
	     * After the non-blocking request_think(game, vp, out ticket), the client will be 
	     * notified using this signal. The client should ensure that the ticket sent by the
	     * signal matches the ticket issued by request_think.
	     */
#line 37 "brain.vala"
	pasang_brain_signals[PASANG_BRAIN_GOT_MOVE_SIGNAL_SIGNAL] = g_signal_new ("got-move-signal", PASANG_TYPE_BRAIN, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__LONG_OBJECT, G_TYPE_NONE, 2, G_TYPE_LONG, PASANG_TYPE_MOVE);
#line 1462 "brain.c"
}

static void
pasang_brain_instance_init (PasangBrain * self,
                            gpointer klass)
{
	GTimer* _tmp0_;
#line 37 "brain.vala"
	self->priv = pasang_brain_get_instance_private (self);
#line 48 "brain.vala"
	self->priv->ticket = (glong) 0;
#line 53 "brain.vala"
	_tmp0_ = g_timer_new ();
#line 53 "brain.vala"
	self->priv->timer = _tmp0_;
#line 67 "brain.vala"
	g_mutex_init (&self->priv->mutex);
#line 68 "brain.vala"
	g_cond_init (&self->priv->cond);
#line 1482 "brain.c"
}

static void
pasang_brain_finalize (GObject * obj)
{
	PasangBrain * self;
#line 37 "brain.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PASANG_TYPE_BRAIN, PasangBrain);
#line 96 "brain.vala"
	pasang_brain_request_exit (self);
#line 53 "brain.vala"
	_g_timer_destroy0 (self->priv->timer);
#line 63 "brain.vala"
	_g_object_unref0 (self->priv->root);
#line 66 "brain.vala"
	_g_thread_unref0 (self->priv->thinking_thread);
#line 67 "brain.vala"
	_vala_clear_GMutex (&self->priv->mutex);
#line 68 "brain.vala"
	_vala_clear_GCond (&self->priv->cond);
#line 37 "brain.vala"
	G_OBJECT_CLASS (pasang_brain_parent_class)->finalize (obj);
#line 1505 "brain.c"
}

GType
pasang_brain_get_type (void)
{
	static volatile gsize pasang_brain_type_id__volatile = 0;
	if (g_once_init_enter (&pasang_brain_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PasangBrainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pasang_brain_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PasangBrain), 0, (GInstanceInitFunc) pasang_brain_instance_init, NULL };
		GType pasang_brain_type_id;
		pasang_brain_type_id = g_type_register_static (G_TYPE_OBJECT, "PasangBrain", &g_define_type_info, 0);
		PasangBrain_private_offset = g_type_add_instance_private (pasang_brain_type_id, sizeof (PasangBrainPrivate));
		g_once_init_leave (&pasang_brain_type_id__volatile, pasang_brain_type_id);
	}
	return pasang_brain_type_id__volatile;
}

static void
_vala_clear_GMutex (GMutex * mutex)
{
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}

static void
_vala_clear_GRecMutex (GRecMutex * mutex)
{
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}

static void
_vala_clear_GRWLock (GRWLock * mutex)
{
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}

static void
_vala_clear_GCond (GCond * mutex)
{
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}

