/*
 *   blobject.h
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */

//  This class encapsulates everything needed to track call restrictions
//  for several devices.  It is built up from an array of Device objects.
//  All calls to the Blacklist API are redirected through this object.
//  An overview of operations can be found in mwbl.txt.
//
//
//
//
//****************************************************************************

#if !defined(BLOBJECT_H)
#define BLOBJECT_H  1

#include <blwtt.h>
#include <idevice.h>
#include <unsucces.h>

// This defines the maximum number of devices that can be registered.
// Currently only one line with modem, fax is supported.
#define MAX_NUMBER_OF_DEVICES     3


typedef struct _BLobject
{
  // The semiphores are used in the WaitSemiphore and Endsemiphore functions.
  USHORT  usSemiphore1;
  USHORT  usSemiphore2;
  
  // The WTT settings are collected into their own class which does the loading
  WTTsettings WTT;
  
  // The main data structure of the BLobject object is an array of
  // Device classes.
  blDevice DeviceArray[MAX_NUMBER_OF_DEVICES];

} BLobject; 

ULONG objReset (BLobject *pBL);
ULONG objResetDevice(BLobject *pBL, ULONG ulDeviceHandle);
ULONG objRegisterDevice(BLobject *pBL, ULONG ulDeviceType, char FAR *lpszDeviceName, ULONG FAR *lpulDeviceHandle);
ULONG objUnRegisterDevice(BLobject *pBL, ULONG ulDeviceHandle);
ULONG objRequestDialPermission(BLobject *pBL, ULONG ulDeviceHandle,ULONG ulDialType, char FAR *lpszPhoneNumber, ULONG FAR *lpulDialStatus, ULONG FAR *lpulDialHandle, ULONG FAR *lpulDelayTime);
ULONG objDialResults(BLobject *pBL, ULONG ulDeviceHandle, ULONG ulDialHandle, ULONG ulDialStatus);
ULONG objGetInfo(BLobject *pBL, ULONG ulDeviceHandle, struct BL_Settings FAR *lpBLsettings);
ULONG objGetNumberList(BLobject *pBL, ULONG ulDeviceHandle, ULONG ulMaxListSize, struct BL_NumberListItem FAR *lpNumberList);
void objWaitSemiphore(BLobject *pBL);
void objEndSemiphore(BLobject *pBL);
ULONG objCleanDialString (BLobject *pBL,char FAR *lpszPhoneNumber);
#endif // !defined(BLOBJECT_H)
