// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: sql/distsqlrun/api.proto

/*
	Package distsqlrun is a generated protocol buffer package.

	It is generated from these files:
		sql/distsqlrun/api.proto
		sql/distsqlrun/data.proto
		sql/distsqlrun/processors.proto
		sql/distsqlrun/stats.proto

	It has these top-level messages:
		SetupFlowRequest
		EvalContext
		SequenceState
		SimpleResponse
		ConsumerSignal
		DrainRequest
		ConsumerHandshake
		Error
		Expression
		Ordering
		StreamEndpointSpec
		InputSyncSpec
		OutputRouterSpec
		DatumInfo
		ProducerHeader
		ProducerData
		ProducerMessage
		RemoteProducerMetadata
		DistSQLVersionGossipInfo
		DistSQLDrainingInfo
		ProcessorSpec
		PostProcessSpec
		ProcessorCoreUnion
		NoopCoreSpec
		MetadataTestSenderSpec
		MetadataTestReceiverSpec
		ValuesCoreSpec
		TableReaderSpan
		TableReaderSpec
		JoinReaderSpec
		SorterSpec
		DistinctSpec
		ZigzagJoinerSpec
		LocalPlanNodeSpec
		Columns
		MergeJoinerSpec
		HashJoinerSpec
		AggregatorSpec
		BackfillerSpec
		FlowSpec
		JobProgress
		ReadImportDataSpec
		SSTWriterSpec
		CSVWriterSpec
		SketchSpec
		SamplerSpec
		SampleAggregatorSpec
		InterleavedReaderJoinerSpec
		ProjectSetSpec
		WindowerSpec
		ChangeAggregatorSpec
		ChangeFrontierSpec
		InputStats
		TableReaderStats
		HashJoinerStats
		AggregatorStats
		DistinctStats
		MergeJoinerStats
		SorterStats
		JoinReaderStats
		OutboxStats
		RouterOutputStats
		WindowerStats
*/
package distsqlrun

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_roachpb1 "github.com/cockroachdb/cockroach/pkg/roachpb"

import time "time"

import context "context"
import grpc "google.golang.org/grpc"

import types "github.com/gogo/protobuf/types"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// BytesEncodeFormat is the configuration for bytes to string conversions.
type BytesEncodeFormat int32

const (
	BytesEncodeFormat_HEX    BytesEncodeFormat = 0
	BytesEncodeFormat_ESCAPE BytesEncodeFormat = 1
	BytesEncodeFormat_BASE64 BytesEncodeFormat = 2
)

var BytesEncodeFormat_name = map[int32]string{
	0: "HEX",
	1: "ESCAPE",
	2: "BASE64",
}
var BytesEncodeFormat_value = map[string]int32{
	"HEX":    0,
	"ESCAPE": 1,
	"BASE64": 2,
}

func (x BytesEncodeFormat) Enum() *BytesEncodeFormat {
	p := new(BytesEncodeFormat)
	*p = x
	return p
}
func (x BytesEncodeFormat) String() string {
	return proto.EnumName(BytesEncodeFormat_name, int32(x))
}
func (x *BytesEncodeFormat) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(BytesEncodeFormat_value, data, "BytesEncodeFormat")
	if err != nil {
		return err
	}
	*x = BytesEncodeFormat(value)
	return nil
}
func (BytesEncodeFormat) EnumDescriptor() ([]byte, []int) { return fileDescriptorApi, []int{0} }

type SetupFlowRequest struct {
	// TxnCoordMeta is the TxnCoordMeta for the transaction in which the flow
	// will run. If nil, the flow will not run in a transaction higher-level
	// transaction (i.e. it is responsible for managing its own transactions,
	// if any). Most flows expect to run in a txn, but some, like backfills,
	// don't.
	TxnCoordMeta *cockroach_roachpb1.TxnCoordMeta `protobuf:"bytes,7,opt,name=txn_coord_meta,json=txnCoordMeta" json:"txn_coord_meta,omitempty"`
	// deprecated_txn used to play the role that TxnCoordMeta now plays. It
	// can be removed in v2.2.
	DeprecatedTxn *cockroach_roachpb1.Transaction `protobuf:"bytes,1,opt,name=deprecated_txn,json=deprecatedTxn" json:"deprecated_txn,omitempty"`
	// Version of distsqlrun protocol; a server accepts a certain range of
	// versions, up to its own version. See server.go for more details.
	Version     DistSQLVersion `protobuf:"varint,5,opt,name=version,casttype=DistSQLVersion" json:"version"`
	Flow        FlowSpec       `protobuf:"bytes,3,opt,name=flow" json:"flow"`
	EvalContext EvalContext    `protobuf:"bytes,6,opt,name=evalContext" json:"evalContext"`
	TraceKV     bool           `protobuf:"varint,8,opt,name=TraceKV" json:"TraceKV"`
}

func (m *SetupFlowRequest) Reset()                    { *m = SetupFlowRequest{} }
func (m *SetupFlowRequest) String() string            { return proto.CompactTextString(m) }
func (*SetupFlowRequest) ProtoMessage()               {}
func (*SetupFlowRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{0} }

// EvalContext is used to marshall some planner.EvalContext members.
type EvalContext struct {
	StmtTimestampNanos int64 `protobuf:"varint,1,opt,name=stmtTimestampNanos" json:"stmtTimestampNanos"`
	TxnTimestampNanos  int64 `protobuf:"varint,2,opt,name=txnTimestampNanos" json:"txnTimestampNanos"`
	// The name of the location according to whose current timezone we're going to
	// parse timestamps. Used to init EvalContext.Location.
	Location          string            `protobuf:"bytes,4,opt,name=location" json:"location"`
	Database          string            `protobuf:"bytes,5,opt,name=database" json:"database"`
	SearchPath        []string          `protobuf:"bytes,6,rep,name=searchPath" json:"searchPath,omitempty"`
	User              string            `protobuf:"bytes,7,opt,name=user" json:"user"`
	SeqState          SequenceState     `protobuf:"bytes,8,opt,name=seq_state,json=seqState" json:"seq_state"`
	ApplicationName   string            `protobuf:"bytes,9,opt,name=application_name,json=applicationName" json:"application_name"`
	BytesEncodeFormat BytesEncodeFormat `protobuf:"varint,10,opt,name=bytes_encode_format,json=bytesEncodeFormat,enum=cockroach.sql.distsqlrun.BytesEncodeFormat" json:"bytes_encode_format"`
	ExtraFloatDigits  int32             `protobuf:"varint,11,opt,name=extra_float_digits,json=extraFloatDigits" json:"extra_float_digits"`
}

func (m *EvalContext) Reset()                    { *m = EvalContext{} }
func (m *EvalContext) String() string            { return proto.CompactTextString(m) }
func (*EvalContext) ProtoMessage()               {}
func (*EvalContext) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{1} }

// SequenceState is used to marshall the sessiondata.SequenceState struct.
type SequenceState struct {
	Seqs []*SequenceState_Seq `protobuf:"bytes,1,rep,name=seqs" json:"seqs,omitempty"`
	// last_seq_incremented is the id of the last sequence incremented by the
	// session. This field is filled in iff seqs is not empty.
	LastSeqIncremented *uint32 `protobuf:"varint,2,opt,name=last_seq_incremented,json=lastSeqIncremented" json:"last_seq_incremented,omitempty"`
}

func (m *SequenceState) Reset()                    { *m = SequenceState{} }
func (m *SequenceState) String() string            { return proto.CompactTextString(m) }
func (*SequenceState) ProtoMessage()               {}
func (*SequenceState) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{2} }

// Seq represents the last value of one sequence modified by the session.
type SequenceState_Seq struct {
	SeqID     uint32 `protobuf:"varint,1,opt,name=seq_id,json=seqId" json:"seq_id"`
	LatestVal int64  `protobuf:"varint,2,opt,name=latest_val,json=latestVal" json:"latest_val"`
}

func (m *SequenceState_Seq) Reset()                    { *m = SequenceState_Seq{} }
func (m *SequenceState_Seq) String() string            { return proto.CompactTextString(m) }
func (*SequenceState_Seq) ProtoMessage()               {}
func (*SequenceState_Seq) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{2, 0} }

type SimpleResponse struct {
	Error *Error `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
}

func (m *SimpleResponse) Reset()                    { *m = SimpleResponse{} }
func (m *SimpleResponse) String() string            { return proto.CompactTextString(m) }
func (*SimpleResponse) ProtoMessage()               {}
func (*SimpleResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{3} }

// ConsumerSignal are messages flowing from consumer to producer (so, from RPC
// server to client) for the FlowStream RPC.
type ConsumerSignal struct {
	// The consumer is done (doesn't need to consume any more rows) and is asking
	// the producer to push whatever trailing metadata it has and close its
	// stream.
	DrainRequest *DrainRequest `protobuf:"bytes,1,opt,name=drain_request,json=drainRequest" json:"drain_request,omitempty"`
	// Used in the RunSyncFlow case; the first message on the client stream must
	// contain this message.
	SetupFlowRequest *SetupFlowRequest `protobuf:"bytes,2,opt,name=setup_flow_request,json=setupFlowRequest" json:"setup_flow_request,omitempty"`
	// Consumer->Producer handshake messages. See message definition.
	Handshake *ConsumerHandshake `protobuf:"bytes,3,opt,name=handshake" json:"handshake,omitempty"`
}

func (m *ConsumerSignal) Reset()                    { *m = ConsumerSignal{} }
func (m *ConsumerSignal) String() string            { return proto.CompactTextString(m) }
func (*ConsumerSignal) ProtoMessage()               {}
func (*ConsumerSignal) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{4} }

type DrainRequest struct {
}

func (m *DrainRequest) Reset()                    { *m = DrainRequest{} }
func (m *DrainRequest) String() string            { return proto.CompactTextString(m) }
func (*DrainRequest) ProtoMessage()               {}
func (*DrainRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{5} }

// ConsumerHandshake is the first one or two message sent in the
// consumer->producer direction on a stream. It informs the producer about the
// status of the consumer flow.
// Introduced in version 1.1 for future use by producers.
type ConsumerHandshake struct {
	// consumer_scheduled is true if the flow that's consuming this stream has
	// already been scheduled and so it is ready to consume data. If this is
	// false, then the consumer has not yet been scheduled. In this case, the
	// server (i.e. the consumer node) will send another ConsumerHandshake with
	// consumer_scheduled = true when the consumer is finally scheduled (unless
	// the scheduling timeout fires first, in which case the stream will be
	// closed server-side).
	ConsumerScheduled bool `protobuf:"varint,1,opt,name=consumer_scheduled,json=consumerScheduled" json:"consumer_scheduled"`
	// If consumer_scheduled is false, then this indicates the deadline for the
	// scheduling of the consumer flow. If the flow is not scheduled within that
	// dealine, this stream will be disconnected by the server-side.
	ConsumerScheduleDeadline *time.Time `protobuf:"bytes,2,opt,name=consumer_schedule_deadline,json=consumerScheduleDeadline,stdtime" json:"consumer_schedule_deadline,omitempty"`
	// The server's DistSQL version range.
	Version            DistSQLVersion `protobuf:"varint,3,opt,name=version,casttype=DistSQLVersion" json:"version"`
	MinAcceptedVersion DistSQLVersion `protobuf:"varint,4,opt,name=min_accepted_version,json=minAcceptedVersion,casttype=DistSQLVersion" json:"min_accepted_version"`
}

func (m *ConsumerHandshake) Reset()                    { *m = ConsumerHandshake{} }
func (m *ConsumerHandshake) String() string            { return proto.CompactTextString(m) }
func (*ConsumerHandshake) ProtoMessage()               {}
func (*ConsumerHandshake) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{6} }

func init() {
	proto.RegisterType((*SetupFlowRequest)(nil), "cockroach.sql.distsqlrun.SetupFlowRequest")
	proto.RegisterType((*EvalContext)(nil), "cockroach.sql.distsqlrun.EvalContext")
	proto.RegisterType((*SequenceState)(nil), "cockroach.sql.distsqlrun.SequenceState")
	proto.RegisterType((*SequenceState_Seq)(nil), "cockroach.sql.distsqlrun.SequenceState.Seq")
	proto.RegisterType((*SimpleResponse)(nil), "cockroach.sql.distsqlrun.SimpleResponse")
	proto.RegisterType((*ConsumerSignal)(nil), "cockroach.sql.distsqlrun.ConsumerSignal")
	proto.RegisterType((*DrainRequest)(nil), "cockroach.sql.distsqlrun.DrainRequest")
	proto.RegisterType((*ConsumerHandshake)(nil), "cockroach.sql.distsqlrun.ConsumerHandshake")
	proto.RegisterEnum("cockroach.sql.distsqlrun.BytesEncodeFormat", BytesEncodeFormat_name, BytesEncodeFormat_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for DistSQL service

type DistSQLClient interface {
	// RunSyncFlow instantiates a flow and streams back results of that flow.
	// The request must contain one flow, and that flow must have a single mailbox
	// of the special sync response type.
	RunSyncFlow(ctx context.Context, opts ...grpc.CallOption) (DistSQL_RunSyncFlowClient, error)
	// SetupFlow instantiates a flow (subgraphs of a distributed SQL
	// computation) on the receiving node.
	SetupFlow(ctx context.Context, in *SetupFlowRequest, opts ...grpc.CallOption) (*SimpleResponse, error)
	// FlowStream is used to push a stream of messages that is part of a flow. The
	// first message will have a StreamHeader which identifies the flow and the
	// stream (mailbox).
	//
	// The response is a stream that the consumer uses to perform a handshake and
	// to signal the producer when it wants it to start draining. The client (i.e.
	// the producer) will read from this consumer->producer stream until it has
	// sent everything it needs to send and it performs CloseSend() on the
	// producer->consumer stream; after that point the producer isn't listening
	// for consumer signals any more.
	FlowStream(ctx context.Context, opts ...grpc.CallOption) (DistSQL_FlowStreamClient, error)
}

type distSQLClient struct {
	cc *grpc.ClientConn
}

func NewDistSQLClient(cc *grpc.ClientConn) DistSQLClient {
	return &distSQLClient{cc}
}

func (c *distSQLClient) RunSyncFlow(ctx context.Context, opts ...grpc.CallOption) (DistSQL_RunSyncFlowClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_DistSQL_serviceDesc.Streams[0], c.cc, "/cockroach.sql.distsqlrun.DistSQL/RunSyncFlow", opts...)
	if err != nil {
		return nil, err
	}
	x := &distSQLRunSyncFlowClient{stream}
	return x, nil
}

type DistSQL_RunSyncFlowClient interface {
	Send(*ConsumerSignal) error
	Recv() (*ProducerMessage, error)
	grpc.ClientStream
}

type distSQLRunSyncFlowClient struct {
	grpc.ClientStream
}

func (x *distSQLRunSyncFlowClient) Send(m *ConsumerSignal) error {
	return x.ClientStream.SendMsg(m)
}

func (x *distSQLRunSyncFlowClient) Recv() (*ProducerMessage, error) {
	m := new(ProducerMessage)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *distSQLClient) SetupFlow(ctx context.Context, in *SetupFlowRequest, opts ...grpc.CallOption) (*SimpleResponse, error) {
	out := new(SimpleResponse)
	err := grpc.Invoke(ctx, "/cockroach.sql.distsqlrun.DistSQL/SetupFlow", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *distSQLClient) FlowStream(ctx context.Context, opts ...grpc.CallOption) (DistSQL_FlowStreamClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_DistSQL_serviceDesc.Streams[1], c.cc, "/cockroach.sql.distsqlrun.DistSQL/FlowStream", opts...)
	if err != nil {
		return nil, err
	}
	x := &distSQLFlowStreamClient{stream}
	return x, nil
}

type DistSQL_FlowStreamClient interface {
	Send(*ProducerMessage) error
	Recv() (*ConsumerSignal, error)
	grpc.ClientStream
}

type distSQLFlowStreamClient struct {
	grpc.ClientStream
}

func (x *distSQLFlowStreamClient) Send(m *ProducerMessage) error {
	return x.ClientStream.SendMsg(m)
}

func (x *distSQLFlowStreamClient) Recv() (*ConsumerSignal, error) {
	m := new(ConsumerSignal)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for DistSQL service

type DistSQLServer interface {
	// RunSyncFlow instantiates a flow and streams back results of that flow.
	// The request must contain one flow, and that flow must have a single mailbox
	// of the special sync response type.
	RunSyncFlow(DistSQL_RunSyncFlowServer) error
	// SetupFlow instantiates a flow (subgraphs of a distributed SQL
	// computation) on the receiving node.
	SetupFlow(context.Context, *SetupFlowRequest) (*SimpleResponse, error)
	// FlowStream is used to push a stream of messages that is part of a flow. The
	// first message will have a StreamHeader which identifies the flow and the
	// stream (mailbox).
	//
	// The response is a stream that the consumer uses to perform a handshake and
	// to signal the producer when it wants it to start draining. The client (i.e.
	// the producer) will read from this consumer->producer stream until it has
	// sent everything it needs to send and it performs CloseSend() on the
	// producer->consumer stream; after that point the producer isn't listening
	// for consumer signals any more.
	FlowStream(DistSQL_FlowStreamServer) error
}

func RegisterDistSQLServer(s *grpc.Server, srv DistSQLServer) {
	s.RegisterService(&_DistSQL_serviceDesc, srv)
}

func _DistSQL_RunSyncFlow_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(DistSQLServer).RunSyncFlow(&distSQLRunSyncFlowServer{stream})
}

type DistSQL_RunSyncFlowServer interface {
	Send(*ProducerMessage) error
	Recv() (*ConsumerSignal, error)
	grpc.ServerStream
}

type distSQLRunSyncFlowServer struct {
	grpc.ServerStream
}

func (x *distSQLRunSyncFlowServer) Send(m *ProducerMessage) error {
	return x.ServerStream.SendMsg(m)
}

func (x *distSQLRunSyncFlowServer) Recv() (*ConsumerSignal, error) {
	m := new(ConsumerSignal)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func _DistSQL_SetupFlow_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetupFlowRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DistSQLServer).SetupFlow(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.sql.distsqlrun.DistSQL/SetupFlow",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DistSQLServer).SetupFlow(ctx, req.(*SetupFlowRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DistSQL_FlowStream_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(DistSQLServer).FlowStream(&distSQLFlowStreamServer{stream})
}

type DistSQL_FlowStreamServer interface {
	Send(*ConsumerSignal) error
	Recv() (*ProducerMessage, error)
	grpc.ServerStream
}

type distSQLFlowStreamServer struct {
	grpc.ServerStream
}

func (x *distSQLFlowStreamServer) Send(m *ConsumerSignal) error {
	return x.ServerStream.SendMsg(m)
}

func (x *distSQLFlowStreamServer) Recv() (*ProducerMessage, error) {
	m := new(ProducerMessage)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _DistSQL_serviceDesc = grpc.ServiceDesc{
	ServiceName: "cockroach.sql.distsqlrun.DistSQL",
	HandlerType: (*DistSQLServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SetupFlow",
			Handler:    _DistSQL_SetupFlow_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "RunSyncFlow",
			Handler:       _DistSQL_RunSyncFlow_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "FlowStream",
			Handler:       _DistSQL_FlowStream_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "sql/distsqlrun/api.proto",
}

func (m *SetupFlowRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SetupFlowRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.DeprecatedTxn != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.DeprecatedTxn.Size()))
		n1, err := m.DeprecatedTxn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Flow.Size()))
	n2, err := m.Flow.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	dAtA[i] = 0x28
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Version))
	dAtA[i] = 0x32
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.EvalContext.Size()))
	n3, err := m.EvalContext.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	if m.TxnCoordMeta != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.TxnCoordMeta.Size()))
		n4, err := m.TxnCoordMeta.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	dAtA[i] = 0x40
	i++
	if m.TraceKV {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func (m *EvalContext) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EvalContext) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.StmtTimestampNanos))
	dAtA[i] = 0x10
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.TxnTimestampNanos))
	dAtA[i] = 0x22
	i++
	i = encodeVarintApi(dAtA, i, uint64(len(m.Location)))
	i += copy(dAtA[i:], m.Location)
	dAtA[i] = 0x2a
	i++
	i = encodeVarintApi(dAtA, i, uint64(len(m.Database)))
	i += copy(dAtA[i:], m.Database)
	if len(m.SearchPath) > 0 {
		for _, s := range m.SearchPath {
			dAtA[i] = 0x32
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	dAtA[i] = 0x3a
	i++
	i = encodeVarintApi(dAtA, i, uint64(len(m.User)))
	i += copy(dAtA[i:], m.User)
	dAtA[i] = 0x42
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.SeqState.Size()))
	n5, err := m.SeqState.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	dAtA[i] = 0x4a
	i++
	i = encodeVarintApi(dAtA, i, uint64(len(m.ApplicationName)))
	i += copy(dAtA[i:], m.ApplicationName)
	dAtA[i] = 0x50
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.BytesEncodeFormat))
	dAtA[i] = 0x58
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ExtraFloatDigits))
	return i, nil
}

func (m *SequenceState) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SequenceState) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Seqs) > 0 {
		for _, msg := range m.Seqs {
			dAtA[i] = 0xa
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.LastSeqIncremented != nil {
		dAtA[i] = 0x10
		i++
		i = encodeVarintApi(dAtA, i, uint64(*m.LastSeqIncremented))
	}
	return i, nil
}

func (m *SequenceState_Seq) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SequenceState_Seq) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.SeqID))
	dAtA[i] = 0x10
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.LatestVal))
	return i, nil
}

func (m *SimpleResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SimpleResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Error != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Error.Size()))
		n6, err := m.Error.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	return i, nil
}

func (m *ConsumerSignal) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConsumerSignal) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.DrainRequest != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.DrainRequest.Size()))
		n7, err := m.DrainRequest.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.SetupFlowRequest != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.SetupFlowRequest.Size()))
		n8, err := m.SetupFlowRequest.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.Handshake != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Handshake.Size()))
		n9, err := m.Handshake.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	return i, nil
}

func (m *DrainRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DrainRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ConsumerHandshake) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConsumerHandshake) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	if m.ConsumerScheduled {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	if m.ConsumerScheduleDeadline != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(types.SizeOfStdTime(*m.ConsumerScheduleDeadline)))
		n10, err := types.StdTimeMarshalTo(*m.ConsumerScheduleDeadline, dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	dAtA[i] = 0x18
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Version))
	dAtA[i] = 0x20
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.MinAcceptedVersion))
	return i, nil
}

func encodeVarintApi(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *SetupFlowRequest) Size() (n int) {
	var l int
	_ = l
	if m.DeprecatedTxn != nil {
		l = m.DeprecatedTxn.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	l = m.Flow.Size()
	n += 1 + l + sovApi(uint64(l))
	n += 1 + sovApi(uint64(m.Version))
	l = m.EvalContext.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.TxnCoordMeta != nil {
		l = m.TxnCoordMeta.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	n += 2
	return n
}

func (m *EvalContext) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovApi(uint64(m.StmtTimestampNanos))
	n += 1 + sovApi(uint64(m.TxnTimestampNanos))
	l = len(m.Location)
	n += 1 + l + sovApi(uint64(l))
	l = len(m.Database)
	n += 1 + l + sovApi(uint64(l))
	if len(m.SearchPath) > 0 {
		for _, s := range m.SearchPath {
			l = len(s)
			n += 1 + l + sovApi(uint64(l))
		}
	}
	l = len(m.User)
	n += 1 + l + sovApi(uint64(l))
	l = m.SeqState.Size()
	n += 1 + l + sovApi(uint64(l))
	l = len(m.ApplicationName)
	n += 1 + l + sovApi(uint64(l))
	n += 1 + sovApi(uint64(m.BytesEncodeFormat))
	n += 1 + sovApi(uint64(m.ExtraFloatDigits))
	return n
}

func (m *SequenceState) Size() (n int) {
	var l int
	_ = l
	if len(m.Seqs) > 0 {
		for _, e := range m.Seqs {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if m.LastSeqIncremented != nil {
		n += 1 + sovApi(uint64(*m.LastSeqIncremented))
	}
	return n
}

func (m *SequenceState_Seq) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovApi(uint64(m.SeqID))
	n += 1 + sovApi(uint64(m.LatestVal))
	return n
}

func (m *SimpleResponse) Size() (n int) {
	var l int
	_ = l
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ConsumerSignal) Size() (n int) {
	var l int
	_ = l
	if m.DrainRequest != nil {
		l = m.DrainRequest.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.SetupFlowRequest != nil {
		l = m.SetupFlowRequest.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Handshake != nil {
		l = m.Handshake.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *DrainRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *ConsumerHandshake) Size() (n int) {
	var l int
	_ = l
	n += 2
	if m.ConsumerScheduleDeadline != nil {
		l = types.SizeOfStdTime(*m.ConsumerScheduleDeadline)
		n += 1 + l + sovApi(uint64(l))
	}
	n += 1 + sovApi(uint64(m.Version))
	n += 1 + sovApi(uint64(m.MinAcceptedVersion))
	return n
}

func sovApi(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozApi(x uint64) (n int) {
	return sovApi(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *ConsumerSignal) GetValue() interface{} {
	if this.DrainRequest != nil {
		return this.DrainRequest
	}
	if this.SetupFlowRequest != nil {
		return this.SetupFlowRequest
	}
	if this.Handshake != nil {
		return this.Handshake
	}
	return nil
}

func (this *ConsumerSignal) SetValue(value interface{}) bool {
	switch vt := value.(type) {
	case *DrainRequest:
		this.DrainRequest = vt
	case *SetupFlowRequest:
		this.SetupFlowRequest = vt
	case *ConsumerHandshake:
		this.Handshake = vt
	default:
		return false
	}
	return true
}
func (m *SetupFlowRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SetupFlowRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SetupFlowRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeprecatedTxn == nil {
				m.DeprecatedTxn = &cockroach_roachpb1.Transaction{}
			}
			if err := m.DeprecatedTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flow", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Flow.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= (DistSQLVersion(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EvalContext", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.EvalContext.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnCoordMeta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TxnCoordMeta == nil {
				m.TxnCoordMeta = &cockroach_roachpb1.TxnCoordMeta{}
			}
			if err := m.TxnCoordMeta.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceKV", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.TraceKV = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EvalContext) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EvalContext: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EvalContext: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StmtTimestampNanos", wireType)
			}
			m.StmtTimestampNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StmtTimestampNanos |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnTimestampNanos", wireType)
			}
			m.TxnTimestampNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TxnTimestampNanos |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Location", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Location = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Database", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Database = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SearchPath", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SearchPath = append(m.SearchPath, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.User = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SeqState", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.SeqState.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ApplicationName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ApplicationName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BytesEncodeFormat", wireType)
			}
			m.BytesEncodeFormat = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BytesEncodeFormat |= (BytesEncodeFormat(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExtraFloatDigits", wireType)
			}
			m.ExtraFloatDigits = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ExtraFloatDigits |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SequenceState) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SequenceState: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SequenceState: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Seqs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Seqs = append(m.Seqs, &SequenceState_Seq{})
			if err := m.Seqs[len(m.Seqs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastSeqIncremented", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.LastSeqIncremented = &v
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SequenceState_Seq) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Seq: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Seq: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SeqID", wireType)
			}
			m.SeqID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SeqID |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LatestVal", wireType)
			}
			m.LatestVal = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LatestVal |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SimpleResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SimpleResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SimpleResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &Error{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConsumerSignal) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConsumerSignal: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConsumerSignal: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DrainRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DrainRequest == nil {
				m.DrainRequest = &DrainRequest{}
			}
			if err := m.DrainRequest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SetupFlowRequest", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SetupFlowRequest == nil {
				m.SetupFlowRequest = &SetupFlowRequest{}
			}
			if err := m.SetupFlowRequest.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Handshake", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Handshake == nil {
				m.Handshake = &ConsumerHandshake{}
			}
			if err := m.Handshake.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DrainRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DrainRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DrainRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConsumerHandshake) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConsumerHandshake: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConsumerHandshake: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsumerScheduled", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ConsumerScheduled = bool(v != 0)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConsumerScheduleDeadline", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConsumerScheduleDeadline == nil {
				m.ConsumerScheduleDeadline = new(time.Time)
			}
			if err := types.StdTimeUnmarshal(m.ConsumerScheduleDeadline, dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= (DistSQLVersion(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MinAcceptedVersion", wireType)
			}
			m.MinAcceptedVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MinAcceptedVersion |= (DistSQLVersion(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipApi(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowApi
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowApi
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowApi
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthApi
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowApi
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipApi(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthApi = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowApi   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("sql/distsqlrun/api.proto", fileDescriptorApi) }

var fileDescriptorApi = []byte{
	// 1069 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x55, 0xcd, 0x6e, 0x23, 0x45,
	0x10, 0xf6, 0xd8, 0x93, 0x1f, 0x97, 0xd7, 0xc6, 0x69, 0x56, 0x68, 0xf0, 0xc1, 0xb6, 0xcc, 0x02,
	0x66, 0x91, 0xec, 0x95, 0x59, 0x38, 0x20, 0x24, 0xb4, 0x4e, 0xbc, 0xec, 0x0f, 0xbb, 0x0a, 0x33,
	0x51, 0xb4, 0xe2, 0xc0, 0xa8, 0x33, 0x53, 0xb1, 0x47, 0x3b, 0xd3, 0x3d, 0xee, 0x6e, 0x27, 0xde,
	0x07, 0x40, 0xe2, 0xc6, 0x3e, 0x02, 0x07, 0x5e, 0x84, 0x5b, 0x8e, 0x1c, 0x38, 0x70, 0x0a, 0x10,
	0xde, 0x82, 0x13, 0xea, 0xf1, 0x4c, 0xec, 0x38, 0x6b, 0x13, 0x6e, 0xd3, 0xf5, 0x7d, 0x5f, 0x55,
	0x75, 0x55, 0x4d, 0x35, 0x58, 0x72, 0x1c, 0x76, 0xfd, 0x40, 0x2a, 0x39, 0x0e, 0xc5, 0x84, 0x75,
	0x69, 0x1c, 0x74, 0x62, 0xc1, 0x15, 0x27, 0x96, 0xc7, 0xbd, 0x97, 0x82, 0x53, 0x6f, 0xd4, 0x91,
	0xe3, 0xb0, 0x33, 0xe7, 0xd4, 0x6e, 0x0f, 0xf9, 0x90, 0x27, 0xa4, 0xae, 0xfe, 0x9a, 0xf1, 0x6b,
	0x8d, 0x21, 0xe7, 0xc3, 0x10, 0xbb, 0xc9, 0xe9, 0x68, 0x72, 0xdc, 0x55, 0x41, 0x84, 0x52, 0xd1,
	0x28, 0x4e, 0x09, 0x24, 0x71, 0x16, 0x1f, 0x75, 0x7d, 0xaa, 0x68, 0x6a, 0x7b, 0x77, 0x29, 0xfc,
	0x02, 0xd4, 0x58, 0x82, 0x62, 0xc1, 0x3d, 0x94, 0x92, 0x0b, 0x39, 0x23, 0xb4, 0xbe, 0x2f, 0x40,
	0xd5, 0x41, 0x35, 0x89, 0x1f, 0x86, 0xfc, 0xd4, 0xc6, 0xf1, 0x04, 0xa5, 0x22, 0x03, 0xa8, 0xf8,
	0x18, 0x0b, 0xf4, 0xa8, 0x42, 0xdf, 0x55, 0x53, 0x66, 0x19, 0x4d, 0xa3, 0x5d, 0xea, 0xd5, 0x3b,
	0xf3, 0xeb, 0xa4, 0x79, 0x74, 0x0e, 0x04, 0x65, 0x92, 0x7a, 0x2a, 0xe0, 0xcc, 0x2e, 0xcf, 0x55,
	0x07, 0x53, 0x46, 0xbe, 0x00, 0xf3, 0x38, 0xe4, 0xa7, 0x56, 0x21, 0x11, 0xb7, 0x3a, 0xab, 0x6a,
	0xd1, 0xd1, 0xb1, 0x9d, 0x18, 0xbd, 0xbe, 0x79, 0x76, 0xde, 0xc8, 0xd9, 0x89, 0x8a, 0xdc, 0x83,
	0xad, 0x13, 0x14, 0x32, 0xe0, 0xcc, 0xda, 0x68, 0x1a, 0xed, 0x72, 0xff, 0x1d, 0x0d, 0xfe, 0x73,
	0xde, 0xa8, 0xec, 0x05, 0x52, 0x39, 0xdf, 0x7c, 0x7d, 0x38, 0x43, 0xed, 0x8c, 0x46, 0x9e, 0x41,
	0x09, 0x4f, 0x68, 0xb8, 0xcb, 0x99, 0xc2, 0xa9, 0xb2, 0x36, 0x93, 0xb0, 0xef, 0xaf, 0x0e, 0x3b,
	0x98, 0x93, 0xd3, 0xc8, 0x8b, 0x7a, 0x5d, 0x05, 0x35, 0x65, 0xae, 0xc7, 0xb9, 0xf0, 0xdd, 0x08,
	0x15, 0xb5, 0xb6, 0x12, 0x8f, 0x8d, 0x37, 0x55, 0x61, 0xca, 0x76, 0x35, 0xef, 0x19, 0x2a, 0x6a,
	0xdf, 0x52, 0x0b, 0x27, 0x52, 0x87, 0xad, 0x03, 0x41, 0x3d, 0x7c, 0x7a, 0x68, 0x6d, 0x37, 0x8d,
	0xf6, 0x76, 0x1a, 0x2a, 0x33, 0x3e, 0x31, 0xb7, 0xf3, 0xd5, 0x42, 0xeb, 0x47, 0x13, 0x4a, 0x0b,
	0xf9, 0x90, 0xfb, 0x40, 0xa4, 0x8a, 0xd4, 0x41, 0xd6, 0xfe, 0xe7, 0x94, 0x71, 0x99, 0xb4, 0xa1,
	0x90, 0x3a, 0x78, 0x03, 0x4e, 0x7a, 0xb0, 0xa3, 0xa6, 0x6c, 0x49, 0x94, 0x5f, 0x10, 0x5d, 0x87,
	0x49, 0x13, 0xb6, 0x43, 0xee, 0x51, 0xdd, 0x40, 0xcb, 0x6c, 0x1a, 0xed, 0x62, 0x4a, 0xbd, 0xb4,
	0x6a, 0x86, 0x1e, 0xa9, 0x23, 0x2a, 0x31, 0x69, 0xc5, 0x25, 0x23, 0xb3, 0x92, 0x3a, 0x80, 0x44,
	0x2a, 0xbc, 0xd1, 0x3e, 0x55, 0x23, 0x6b, 0xb3, 0x59, 0x68, 0x17, 0xed, 0x05, 0x0b, 0xb1, 0xc0,
	0x9c, 0x48, 0x14, 0x49, 0x01, 0x33, 0x75, 0x62, 0x21, 0x4f, 0xa0, 0x28, 0x71, 0xec, 0x4a, 0x45,
	0x15, 0x26, 0xf5, 0x29, 0xf5, 0x3e, 0x5c, 0xdd, 0x31, 0x47, 0x0f, 0x28, 0xf3, 0xd0, 0xd1, 0xf4,
	0x2c, 0x0b, 0x89, 0xe3, 0xe4, 0x4c, 0xba, 0x50, 0xa5, 0x71, 0x1c, 0x06, 0xb3, 0xb4, 0x5d, 0x46,
	0x23, 0xb4, 0x8a, 0x0b, 0x11, 0xdf, 0x5a, 0x40, 0x9f, 0xd3, 0x08, 0x09, 0x85, 0xb7, 0x8f, 0x5e,
	0x29, 0x94, 0x2e, 0x32, 0x8f, 0xfb, 0xe8, 0x1e, 0x73, 0x11, 0x51, 0x65, 0x41, 0xd3, 0x68, 0x57,
	0x7a, 0x1f, 0xaf, 0x4e, 0xa3, 0xaf, 0x45, 0x83, 0x44, 0xf3, 0x30, 0x91, 0x64, 0xd5, 0x3d, 0x5a,
	0x06, 0x48, 0x0f, 0x08, 0x4e, 0x95, 0xa0, 0xee, 0x71, 0xc8, 0xa9, 0x72, 0xfd, 0x60, 0x18, 0x28,
	0x69, 0x95, 0x9a, 0x46, 0x7b, 0x23, 0x15, 0x55, 0x13, 0xfc, 0xa1, 0x86, 0xf7, 0x12, 0xf4, 0x89,
	0xb9, 0x5d, 0xa8, 0x9a, 0xad, 0xdf, 0x0c, 0x28, 0x5f, 0xb9, 0x2f, 0xf9, 0x12, 0x4c, 0x89, 0x63,
	0x3d, 0x05, 0x85, 0x76, 0x69, 0x5d, 0x7e, 0x57, 0x64, 0xfa, 0x64, 0x27, 0x42, 0x72, 0x0f, 0x6e,
	0x87, 0x54, 0x2a, 0x57, 0x57, 0x3c, 0x60, 0x9e, 0xc0, 0x08, 0x99, 0x42, 0x3f, 0x99, 0x90, 0xb2,
	0x4d, 0x34, 0xe6, 0xe0, 0xf8, 0xf1, 0x1c, 0xa9, 0xed, 0x43, 0xc1, 0xc1, 0x31, 0xb9, 0x03, 0x9b,
	0x89, 0xc6, 0x4f, 0x26, 0xb0, 0xdc, 0x2f, 0xeb, 0xcc, 0x2f, 0xce, 0x1b, 0x1b, 0x9a, 0xbe, 0x67,
	0x6f, 0x48, 0x1c, 0x3f, 0xf6, 0xc9, 0x7b, 0x00, 0x21, 0x55, 0x28, 0x95, 0x7b, 0x42, 0xc3, 0x2b,
	0x63, 0x57, 0x9c, 0xd9, 0x0f, 0x69, 0xd8, 0xfa, 0x0a, 0x2a, 0x4e, 0x10, 0xc5, 0x21, 0xda, 0x28,
	0x63, 0xce, 0x24, 0x92, 0x4f, 0x61, 0x03, 0x85, 0xe0, 0x22, 0x5d, 0x32, 0x8d, 0x35, 0x3f, 0xac,
	0xa6, 0xd9, 0x33, 0x76, 0xeb, 0x87, 0x3c, 0x54, 0x76, 0x39, 0x93, 0x93, 0x08, 0x85, 0x13, 0x0c,
	0x19, 0x0d, 0xc9, 0x53, 0x28, 0xfb, 0x82, 0x06, 0xcc, 0x15, 0xb3, 0x45, 0x96, 0x7a, 0xfc, 0x60,
	0xb5, 0xc7, 0x3d, 0x4d, 0x4f, 0xd7, 0x9e, 0x7d, 0xcb, 0x5f, 0x38, 0x91, 0x17, 0x40, 0xa4, 0x5e,
	0x8c, 0xba, 0x73, 0xa7, 0x97, 0x1e, 0xf3, 0x89, 0xc7, 0xbb, 0xeb, 0x6a, 0x7f, 0x75, 0x99, 0xda,
	0x55, 0xb9, 0xbc, 0x5e, 0x1f, 0x43, 0x71, 0x44, 0x99, 0x2f, 0x47, 0xf4, 0x25, 0xa6, 0xcb, 0x71,
	0x4d, 0x33, 0xb3, 0x3b, 0x3e, 0xca, 0x24, 0xf6, 0x5c, 0xfd, 0xb9, 0x79, 0xf6, 0x53, 0xc3, 0x68,
	0x55, 0xe0, 0xd6, 0xe2, 0x45, 0x5a, 0x3f, 0xe7, 0x61, 0xe7, 0x9a, 0x8c, 0x7c, 0x02, 0xc4, 0x4b,
	0x8d, 0xae, 0xf4, 0x46, 0xe8, 0x4f, 0x42, 0x9c, 0x35, 0x34, 0xdb, 0x49, 0x3b, 0x19, 0xee, 0x64,
	0x30, 0xf9, 0x0e, 0x6a, 0xd7, 0x44, 0xae, 0x8f, 0xd4, 0x0f, 0x03, 0x86, 0x69, 0x35, 0x6a, 0x9d,
	0xd9, 0xab, 0xd5, 0xc9, 0x5e, 0xad, 0xce, 0xe5, 0x8a, 0xe9, 0x9b, 0xaf, 0xff, 0x68, 0x18, 0xb6,
	0xb5, 0xec, 0x78, 0x2f, 0xf5, 0xb0, 0xb8, 0xe5, 0x0b, 0x37, 0xdb, 0xf2, 0x8f, 0xe0, 0x76, 0x14,
	0x30, 0x97, 0x7a, 0x1e, 0xc6, 0xfa, 0x79, 0xca, 0xe4, 0xe6, 0x5a, 0x39, 0x89, 0x02, 0xf6, 0x20,
	0x95, 0xa4, 0xb6, 0xbb, 0xf7, 0x61, 0xe7, 0xda, 0x9f, 0x4c, 0xb6, 0xa0, 0xf0, 0x68, 0xf0, 0xa2,
	0x9a, 0x23, 0x00, 0x9b, 0x03, 0x67, 0xf7, 0xc1, 0xfe, 0xa0, 0x6a, 0xe8, 0xef, 0xfe, 0x03, 0x67,
	0xf0, 0xd9, 0xfd, 0x6a, 0xbe, 0xf7, 0x4b, 0x1e, 0xb6, 0x52, 0xe7, 0x64, 0x04, 0x25, 0x7b, 0xc2,
	0x9c, 0x57, 0xcc, 0xd3, 0xfd, 0x25, 0xed, 0xff, 0xee, 0xe2, 0x6c, 0x52, 0x6b, 0x1f, 0xad, 0x66,
	0xee, 0x0b, 0xee, 0x4f, 0x3c, 0x14, 0xcf, 0x50, 0x4a, 0x3a, 0xc4, 0x56, 0xae, 0x6d, 0xdc, 0x33,
	0x88, 0x07, 0xc5, 0xcb, 0xc9, 0x22, 0xff, 0x63, 0xfc, 0x6a, 0x6b, 0x72, 0xba, 0xfa, 0x1f, 0xb6,
	0x72, 0x64, 0x08, 0x90, 0x3c, 0xc5, 0x4a, 0x20, 0x8d, 0xc8, 0xcd, 0x73, 0xac, 0xdd, 0xf8, 0xe2,
	0xb3, 0xdb, 0xf4, 0xef, 0x9c, 0xfd, 0x55, 0xcf, 0x9d, 0x5d, 0xd4, 0x8d, 0x5f, 0x2f, 0xea, 0xc6,
	0xef, 0x17, 0x75, 0xe3, 0xcf, 0x8b, 0xba, 0xf1, 0xfa, 0xef, 0x7a, 0xee, 0x5b, 0x98, 0x4b, 0xff,
	0x0d, 0x00, 0x00, 0xff, 0xff, 0x45, 0x3d, 0x62, 0x8d, 0x57, 0x09, 0x00, 0x00,
}
