// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: gossip/gossip.proto

/*
	Package gossip is a generated protocol buffer package.

	It is generated from these files:
		gossip/gossip.proto

	It has these top-level messages:
		BootstrapInfo
		Request
		Response
		ConnStatus
		MetricSnap
		OutgoingConnStatus
		ClientStatus
		ServerStatus
		Connectivity
		InfoStatus
		Info
*/
package gossip

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_roachpb1 "github.com/cockroachdb/cockroach/pkg/roachpb"
import cockroach_util_hlc "github.com/cockroachdb/cockroach/pkg/util/hlc"
import cockroach_util "github.com/cockroachdb/cockroach/pkg/util"

import github_com_cockroachdb_cockroach_pkg_roachpb "github.com/cockroachdb/cockroach/pkg/roachpb"
import github_com_cockroachdb_cockroach_pkg_util_uuid "github.com/cockroachdb/cockroach/pkg/util/uuid"

import context "context"
import grpc "google.golang.org/grpc"

import sortkeys "github.com/gogo/protobuf/sortkeys"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// BootstrapInfo contains information necessary to bootstrap the
// gossip network from a cold start.
type BootstrapInfo struct {
	// Addresses of other nodes in the cluster.
	Addresses []cockroach_util.UnresolvedAddr `protobuf:"bytes,1,rep,name=addresses" json:"addresses"`
	// Timestamp at which the bootstrap info was written.
	Timestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,2,opt,name=timestamp" json:"timestamp"`
}

func (m *BootstrapInfo) Reset()                    { *m = BootstrapInfo{} }
func (m *BootstrapInfo) String() string            { return proto.CompactTextString(m) }
func (*BootstrapInfo) ProtoMessage()               {}
func (*BootstrapInfo) Descriptor() ([]byte, []int) { return fileDescriptorGossip, []int{0} }

// Request is the request struct passed with the Gossip RPC.
type Request struct {
	// Requesting node's ID.
	NodeID github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,1,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
	// Address of the requesting client.
	Addr cockroach_util.UnresolvedAddr `protobuf:"bytes,2,opt,name=addr" json:"addr"`
	// Map of high water timestamps from infos originating at other
	// nodes, as seen by the requester.
	HighWaterStamps map[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID]int64 `protobuf:"bytes,3,rep,name=high_water_stamps,json=highWaterStamps,castkey=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"high_water_stamps" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	// Delta of Infos originating at sender.
	Delta map[string]*Info `protobuf:"bytes,4,rep,name=delta" json:"delta,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	// Cluster ID to prevent illegal connections.
	ClusterID github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,5,opt,name=cluster_id,json=clusterId,proto3,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"cluster_id"`
}

func (m *Request) Reset()                    { *m = Request{} }
func (m *Request) String() string            { return proto.CompactTextString(m) }
func (*Request) ProtoMessage()               {}
func (*Request) Descriptor() ([]byte, []int) { return fileDescriptorGossip, []int{1} }

// Response is returned from the Gossip.Gossip RPC.
// Delta will be nil in the event that Alternate is set.
type Response struct {
	// Responding Node's ID.
	NodeID github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,1,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
	// Address of the responding client.
	Addr cockroach_util.UnresolvedAddr `protobuf:"bytes,2,opt,name=addr" json:"addr"`
	// Non-nil means client should retry with this address.
	AlternateAddr *cockroach_util.UnresolvedAddr `protobuf:"bytes,3,opt,name=alternate_addr,json=alternateAddr" json:"alternate_addr,omitempty"`
	// Node ID of the alternate address, if alternate_addr is not nil.
	AlternateNodeID github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,4,opt,name=alternate_node_id,json=alternateNodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"alternate_node_id,omitempty"`
	// Delta of Infos which are fresh according to the map of Node info messages
	// passed with the request.
	Delta map[string]*Info `protobuf:"bytes,5,rep,name=delta" json:"delta,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	// Map of high water timestamps from infos originating at other
	// nodes, as seen by the responder.
	HighWaterStamps map[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID]int64 `protobuf:"bytes,6,rep,name=high_water_stamps,json=highWaterStamps,castkey=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"high_water_stamps" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
}

func (m *Response) Reset()                    { *m = Response{} }
func (m *Response) String() string            { return proto.CompactTextString(m) }
func (*Response) ProtoMessage()               {}
func (*Response) Descriptor() ([]byte, []int) { return fileDescriptorGossip, []int{2} }

type ConnStatus struct {
	NodeID   github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,1,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
	Address  string                                              `protobuf:"bytes,2,opt,name=address,proto3" json:"address,omitempty"`
	AgeNanos int64                                               `protobuf:"varint,3,opt,name=age_nanos,json=ageNanos,proto3" json:"age_nanos,omitempty"`
}

func (m *ConnStatus) Reset()                    { *m = ConnStatus{} }
func (*ConnStatus) ProtoMessage()               {}
func (*ConnStatus) Descriptor() ([]byte, []int) { return fileDescriptorGossip, []int{3} }

type MetricSnap struct {
	BytesReceived int64 `protobuf:"varint,2,opt,name=bytes_received,json=bytesReceived,proto3" json:"bytes_received,omitempty"`
	BytesSent     int64 `protobuf:"varint,3,opt,name=bytes_sent,json=bytesSent,proto3" json:"bytes_sent,omitempty"`
	InfosReceived int64 `protobuf:"varint,4,opt,name=infos_received,json=infosReceived,proto3" json:"infos_received,omitempty"`
	InfosSent     int64 `protobuf:"varint,5,opt,name=infos_sent,json=infosSent,proto3" json:"infos_sent,omitempty"`
	ConnsRefused  int64 `protobuf:"varint,6,opt,name=conns_refused,json=connsRefused,proto3" json:"conns_refused,omitempty"`
}

func (m *MetricSnap) Reset()                    { *m = MetricSnap{} }
func (*MetricSnap) ProtoMessage()               {}
func (*MetricSnap) Descriptor() ([]byte, []int) { return fileDescriptorGossip, []int{4} }

type OutgoingConnStatus struct {
	ConnStatus `protobuf:"bytes,1,opt,name=conn_status,json=connStatus,embedded=conn_status" json:"conn_status"`
	MetricSnap `protobuf:"bytes,2,opt,name=metrics,embedded=metrics" json:"metrics"`
}

func (m *OutgoingConnStatus) Reset()                    { *m = OutgoingConnStatus{} }
func (*OutgoingConnStatus) ProtoMessage()               {}
func (*OutgoingConnStatus) Descriptor() ([]byte, []int) { return fileDescriptorGossip, []int{5} }

type ClientStatus struct {
	ConnStatus []OutgoingConnStatus `protobuf:"bytes,1,rep,name=conn_status,json=connStatus" json:"conn_status"`
	MaxConns   int32                `protobuf:"varint,2,opt,name=max_conns,json=maxConns,proto3" json:"max_conns,omitempty"`
}

func (m *ClientStatus) Reset()                    { *m = ClientStatus{} }
func (*ClientStatus) ProtoMessage()               {}
func (*ClientStatus) Descriptor() ([]byte, []int) { return fileDescriptorGossip, []int{6} }

type ServerStatus struct {
	ConnStatus []ConnStatus `protobuf:"bytes,1,rep,name=conn_status,json=connStatus" json:"conn_status"`
	MaxConns   int32        `protobuf:"varint,2,opt,name=max_conns,json=maxConns,proto3" json:"max_conns,omitempty"`
	MetricSnap `protobuf:"bytes,3,opt,name=metrics,embedded=metrics" json:"metrics"`
}

func (m *ServerStatus) Reset()                    { *m = ServerStatus{} }
func (*ServerStatus) ProtoMessage()               {}
func (*ServerStatus) Descriptor() ([]byte, []int) { return fileDescriptorGossip, []int{7} }

type Connectivity struct {
	SentinelNodeID github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,1,opt,name=sentinel_node_id,json=sentinelNodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"sentinel_node_id,omitempty"`
	ClientConns    []Connectivity_Conn                                 `protobuf:"bytes,2,rep,name=client_conns,json=clientConns" json:"client_conns"`
}

func (m *Connectivity) Reset()                    { *m = Connectivity{} }
func (*Connectivity) ProtoMessage()               {}
func (*Connectivity) Descriptor() ([]byte, []int) { return fileDescriptorGossip, []int{8} }

type Connectivity_Conn struct {
	SourceID github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,1,opt,name=source_id,json=sourceId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"source_id,omitempty"`
	TargetID github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,2,opt,name=target_id,json=targetId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"target_id,omitempty"`
}

func (m *Connectivity_Conn) Reset()                    { *m = Connectivity_Conn{} }
func (m *Connectivity_Conn) String() string            { return proto.CompactTextString(m) }
func (*Connectivity_Conn) ProtoMessage()               {}
func (*Connectivity_Conn) Descriptor() ([]byte, []int) { return fileDescriptorGossip, []int{8, 0} }

// InfoStatus contains information about the current status of the infoStore.
type InfoStatus struct {
	Infos        map[string]Info `protobuf:"bytes,1,rep,name=infos" json:"infos" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	Client       ClientStatus    `protobuf:"bytes,2,opt,name=client" json:"client"`
	Server       ServerStatus    `protobuf:"bytes,3,opt,name=server" json:"server"`
	Connectivity Connectivity    `protobuf:"bytes,4,opt,name=connectivity" json:"connectivity"`
}

func (m *InfoStatus) Reset()                    { *m = InfoStatus{} }
func (m *InfoStatus) String() string            { return proto.CompactTextString(m) }
func (*InfoStatus) ProtoMessage()               {}
func (*InfoStatus) Descriptor() ([]byte, []int) { return fileDescriptorGossip, []int{9} }

// Info is the basic unit of information traded over the
// gossip network.
type Info struct {
	Value cockroach_roachpb1.Value `protobuf:"bytes,1,opt,name=value" json:"value"`
	// Wall time of info when generated by originating node (Unix-nanos).
	OrigStamp int64 `protobuf:"varint,2,opt,name=orig_stamp,json=origStamp,proto3" json:"orig_stamp,omitempty"`
	// Wall time when info is to be discarded (Unix-nanos).
	TTLStamp int64 `protobuf:"varint,3,opt,name=ttl_stamp,json=ttlStamp,proto3" json:"ttl_stamp,omitempty"`
	// Number of hops from originator.
	Hops uint32 `protobuf:"varint,4,opt,name=hops,proto3" json:"hops,omitempty"`
	// Originating node's ID.
	NodeID github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,5,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
	// Peer node ID which passed this info.
	PeerID github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,6,opt,name=peer_id,json=peerId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"peer_id,omitempty"`
}

func (m *Info) Reset()                    { *m = Info{} }
func (m *Info) String() string            { return proto.CompactTextString(m) }
func (*Info) ProtoMessage()               {}
func (*Info) Descriptor() ([]byte, []int) { return fileDescriptorGossip, []int{10} }

func init() {
	proto.RegisterType((*BootstrapInfo)(nil), "cockroach.gossip.BootstrapInfo")
	proto.RegisterType((*Request)(nil), "cockroach.gossip.Request")
	proto.RegisterType((*Response)(nil), "cockroach.gossip.Response")
	proto.RegisterType((*ConnStatus)(nil), "cockroach.gossip.ConnStatus")
	proto.RegisterType((*MetricSnap)(nil), "cockroach.gossip.MetricSnap")
	proto.RegisterType((*OutgoingConnStatus)(nil), "cockroach.gossip.OutgoingConnStatus")
	proto.RegisterType((*ClientStatus)(nil), "cockroach.gossip.ClientStatus")
	proto.RegisterType((*ServerStatus)(nil), "cockroach.gossip.ServerStatus")
	proto.RegisterType((*Connectivity)(nil), "cockroach.gossip.Connectivity")
	proto.RegisterType((*Connectivity_Conn)(nil), "cockroach.gossip.Connectivity.Conn")
	proto.RegisterType((*InfoStatus)(nil), "cockroach.gossip.InfoStatus")
	proto.RegisterType((*Info)(nil), "cockroach.gossip.Info")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Gossip service

type GossipClient interface {
	Gossip(ctx context.Context, opts ...grpc.CallOption) (Gossip_GossipClient, error)
}

type gossipClient struct {
	cc *grpc.ClientConn
}

func NewGossipClient(cc *grpc.ClientConn) GossipClient {
	return &gossipClient{cc}
}

func (c *gossipClient) Gossip(ctx context.Context, opts ...grpc.CallOption) (Gossip_GossipClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_Gossip_serviceDesc.Streams[0], c.cc, "/cockroach.gossip.Gossip/Gossip", opts...)
	if err != nil {
		return nil, err
	}
	x := &gossipGossipClient{stream}
	return x, nil
}

type Gossip_GossipClient interface {
	Send(*Request) error
	Recv() (*Response, error)
	grpc.ClientStream
}

type gossipGossipClient struct {
	grpc.ClientStream
}

func (x *gossipGossipClient) Send(m *Request) error {
	return x.ClientStream.SendMsg(m)
}

func (x *gossipGossipClient) Recv() (*Response, error) {
	m := new(Response)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// Server API for Gossip service

type GossipServer interface {
	Gossip(Gossip_GossipServer) error
}

func RegisterGossipServer(s *grpc.Server, srv GossipServer) {
	s.RegisterService(&_Gossip_serviceDesc, srv)
}

func _Gossip_Gossip_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(GossipServer).Gossip(&gossipGossipServer{stream})
}

type Gossip_GossipServer interface {
	Send(*Response) error
	Recv() (*Request, error)
	grpc.ServerStream
}

type gossipGossipServer struct {
	grpc.ServerStream
}

func (x *gossipGossipServer) Send(m *Response) error {
	return x.ServerStream.SendMsg(m)
}

func (x *gossipGossipServer) Recv() (*Request, error) {
	m := new(Request)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _Gossip_serviceDesc = grpc.ServiceDesc{
	ServiceName: "cockroach.gossip.Gossip",
	HandlerType: (*GossipServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Gossip",
			Handler:       _Gossip_Gossip_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "gossip/gossip.proto",
}

func (m *BootstrapInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BootstrapInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Addresses) > 0 {
		for _, msg := range m.Addresses {
			dAtA[i] = 0xa
			i++
			i = encodeVarintGossip(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintGossip(dAtA, i, uint64(m.Timestamp.Size()))
	n1, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	return i, nil
}

func (m *Request) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Request) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.NodeID))
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintGossip(dAtA, i, uint64(m.Addr.Size()))
	n2, err := m.Addr.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	if len(m.HighWaterStamps) > 0 {
		keysForHighWaterStamps := make([]int32, 0, len(m.HighWaterStamps))
		for k := range m.HighWaterStamps {
			keysForHighWaterStamps = append(keysForHighWaterStamps, int32(k))
		}
		sortkeys.Int32s(keysForHighWaterStamps)
		for _, k := range keysForHighWaterStamps {
			dAtA[i] = 0x1a
			i++
			v := m.HighWaterStamps[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(k)]
			mapSize := 1 + sovGossip(uint64(k)) + 1 + sovGossip(uint64(v))
			i = encodeVarintGossip(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintGossip(dAtA, i, uint64(k))
			dAtA[i] = 0x10
			i++
			i = encodeVarintGossip(dAtA, i, uint64(v))
		}
	}
	if len(m.Delta) > 0 {
		keysForDelta := make([]string, 0, len(m.Delta))
		for k := range m.Delta {
			keysForDelta = append(keysForDelta, string(k))
		}
		sortkeys.Strings(keysForDelta)
		for _, k := range keysForDelta {
			dAtA[i] = 0x22
			i++
			v := m.Delta[string(k)]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovGossip(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovGossip(uint64(len(k))) + msgSize
			i = encodeVarintGossip(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGossip(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintGossip(dAtA, i, uint64(v.Size()))
				n3, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n3
			}
		}
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintGossip(dAtA, i, uint64(m.ClusterID.Size()))
	n4, err := m.ClusterID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n4
	return i, nil
}

func (m *Response) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Response) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.NodeID))
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintGossip(dAtA, i, uint64(m.Addr.Size()))
	n5, err := m.Addr.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	if m.AlternateAddr != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.AlternateAddr.Size()))
		n6, err := m.AlternateAddr.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.AlternateNodeID != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.AlternateNodeID))
	}
	if len(m.Delta) > 0 {
		keysForDelta := make([]string, 0, len(m.Delta))
		for k := range m.Delta {
			keysForDelta = append(keysForDelta, string(k))
		}
		sortkeys.Strings(keysForDelta)
		for _, k := range keysForDelta {
			dAtA[i] = 0x2a
			i++
			v := m.Delta[string(k)]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovGossip(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovGossip(uint64(len(k))) + msgSize
			i = encodeVarintGossip(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGossip(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintGossip(dAtA, i, uint64(v.Size()))
				n7, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n7
			}
		}
	}
	if len(m.HighWaterStamps) > 0 {
		keysForHighWaterStamps := make([]int32, 0, len(m.HighWaterStamps))
		for k := range m.HighWaterStamps {
			keysForHighWaterStamps = append(keysForHighWaterStamps, int32(k))
		}
		sortkeys.Int32s(keysForHighWaterStamps)
		for _, k := range keysForHighWaterStamps {
			dAtA[i] = 0x32
			i++
			v := m.HighWaterStamps[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(k)]
			mapSize := 1 + sovGossip(uint64(k)) + 1 + sovGossip(uint64(v))
			i = encodeVarintGossip(dAtA, i, uint64(mapSize))
			dAtA[i] = 0x8
			i++
			i = encodeVarintGossip(dAtA, i, uint64(k))
			dAtA[i] = 0x10
			i++
			i = encodeVarintGossip(dAtA, i, uint64(v))
		}
	}
	return i, nil
}

func (m *ConnStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConnStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NodeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.NodeID))
	}
	if len(m.Address) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintGossip(dAtA, i, uint64(len(m.Address)))
		i += copy(dAtA[i:], m.Address)
	}
	if m.AgeNanos != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.AgeNanos))
	}
	return i, nil
}

func (m *MetricSnap) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MetricSnap) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.BytesReceived != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.BytesReceived))
	}
	if m.BytesSent != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.BytesSent))
	}
	if m.InfosReceived != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.InfosReceived))
	}
	if m.InfosSent != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.InfosSent))
	}
	if m.ConnsRefused != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.ConnsRefused))
	}
	return i, nil
}

func (m *OutgoingConnStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OutgoingConnStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintGossip(dAtA, i, uint64(m.ConnStatus.Size()))
	n8, err := m.ConnStatus.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n8
	dAtA[i] = 0x12
	i++
	i = encodeVarintGossip(dAtA, i, uint64(m.MetricSnap.Size()))
	n9, err := m.MetricSnap.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n9
	return i, nil
}

func (m *ClientStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ClientStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ConnStatus) > 0 {
		for _, msg := range m.ConnStatus {
			dAtA[i] = 0xa
			i++
			i = encodeVarintGossip(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.MaxConns != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.MaxConns))
	}
	return i, nil
}

func (m *ServerStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ServerStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.ConnStatus) > 0 {
		for _, msg := range m.ConnStatus {
			dAtA[i] = 0xa
			i++
			i = encodeVarintGossip(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.MaxConns != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.MaxConns))
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintGossip(dAtA, i, uint64(m.MetricSnap.Size()))
	n10, err := m.MetricSnap.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n10
	return i, nil
}

func (m *Connectivity) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Connectivity) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.SentinelNodeID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.SentinelNodeID))
	}
	if len(m.ClientConns) > 0 {
		for _, msg := range m.ClientConns {
			dAtA[i] = 0x12
			i++
			i = encodeVarintGossip(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Connectivity_Conn) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Connectivity_Conn) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.SourceID != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.SourceID))
	}
	if m.TargetID != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.TargetID))
	}
	return i, nil
}

func (m *InfoStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InfoStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Infos) > 0 {
		keysForInfos := make([]string, 0, len(m.Infos))
		for k := range m.Infos {
			keysForInfos = append(keysForInfos, string(k))
		}
		sortkeys.Strings(keysForInfos)
		for _, k := range keysForInfos {
			dAtA[i] = 0xa
			i++
			v := m.Infos[string(k)]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovGossip(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovGossip(uint64(len(k))) + msgSize
			i = encodeVarintGossip(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintGossip(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintGossip(dAtA, i, uint64((&v).Size()))
			n11, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n11
		}
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintGossip(dAtA, i, uint64(m.Client.Size()))
	n12, err := m.Client.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n12
	dAtA[i] = 0x1a
	i++
	i = encodeVarintGossip(dAtA, i, uint64(m.Server.Size()))
	n13, err := m.Server.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n13
	dAtA[i] = 0x22
	i++
	i = encodeVarintGossip(dAtA, i, uint64(m.Connectivity.Size()))
	n14, err := m.Connectivity.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n14
	return i, nil
}

func (m *Info) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Info) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintGossip(dAtA, i, uint64(m.Value.Size()))
	n15, err := m.Value.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n15
	if m.OrigStamp != 0 {
		dAtA[i] = 0x10
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.OrigStamp))
	}
	if m.TTLStamp != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.TTLStamp))
	}
	if m.Hops != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.Hops))
	}
	if m.NodeID != 0 {
		dAtA[i] = 0x28
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.NodeID))
	}
	if m.PeerID != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintGossip(dAtA, i, uint64(m.PeerID))
	}
	return i, nil
}

func encodeVarintGossip(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *BootstrapInfo) Size() (n int) {
	var l int
	_ = l
	if len(m.Addresses) > 0 {
		for _, e := range m.Addresses {
			l = e.Size()
			n += 1 + l + sovGossip(uint64(l))
		}
	}
	l = m.Timestamp.Size()
	n += 1 + l + sovGossip(uint64(l))
	return n
}

func (m *Request) Size() (n int) {
	var l int
	_ = l
	if m.NodeID != 0 {
		n += 1 + sovGossip(uint64(m.NodeID))
	}
	l = m.Addr.Size()
	n += 1 + l + sovGossip(uint64(l))
	if len(m.HighWaterStamps) > 0 {
		for k, v := range m.HighWaterStamps {
			_ = k
			_ = v
			mapEntrySize := 1 + sovGossip(uint64(k)) + 1 + sovGossip(uint64(v))
			n += mapEntrySize + 1 + sovGossip(uint64(mapEntrySize))
		}
	}
	if len(m.Delta) > 0 {
		for k, v := range m.Delta {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovGossip(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovGossip(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovGossip(uint64(mapEntrySize))
		}
	}
	l = m.ClusterID.Size()
	n += 1 + l + sovGossip(uint64(l))
	return n
}

func (m *Response) Size() (n int) {
	var l int
	_ = l
	if m.NodeID != 0 {
		n += 1 + sovGossip(uint64(m.NodeID))
	}
	l = m.Addr.Size()
	n += 1 + l + sovGossip(uint64(l))
	if m.AlternateAddr != nil {
		l = m.AlternateAddr.Size()
		n += 1 + l + sovGossip(uint64(l))
	}
	if m.AlternateNodeID != 0 {
		n += 1 + sovGossip(uint64(m.AlternateNodeID))
	}
	if len(m.Delta) > 0 {
		for k, v := range m.Delta {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovGossip(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovGossip(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovGossip(uint64(mapEntrySize))
		}
	}
	if len(m.HighWaterStamps) > 0 {
		for k, v := range m.HighWaterStamps {
			_ = k
			_ = v
			mapEntrySize := 1 + sovGossip(uint64(k)) + 1 + sovGossip(uint64(v))
			n += mapEntrySize + 1 + sovGossip(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *ConnStatus) Size() (n int) {
	var l int
	_ = l
	if m.NodeID != 0 {
		n += 1 + sovGossip(uint64(m.NodeID))
	}
	l = len(m.Address)
	if l > 0 {
		n += 1 + l + sovGossip(uint64(l))
	}
	if m.AgeNanos != 0 {
		n += 1 + sovGossip(uint64(m.AgeNanos))
	}
	return n
}

func (m *MetricSnap) Size() (n int) {
	var l int
	_ = l
	if m.BytesReceived != 0 {
		n += 1 + sovGossip(uint64(m.BytesReceived))
	}
	if m.BytesSent != 0 {
		n += 1 + sovGossip(uint64(m.BytesSent))
	}
	if m.InfosReceived != 0 {
		n += 1 + sovGossip(uint64(m.InfosReceived))
	}
	if m.InfosSent != 0 {
		n += 1 + sovGossip(uint64(m.InfosSent))
	}
	if m.ConnsRefused != 0 {
		n += 1 + sovGossip(uint64(m.ConnsRefused))
	}
	return n
}

func (m *OutgoingConnStatus) Size() (n int) {
	var l int
	_ = l
	l = m.ConnStatus.Size()
	n += 1 + l + sovGossip(uint64(l))
	l = m.MetricSnap.Size()
	n += 1 + l + sovGossip(uint64(l))
	return n
}

func (m *ClientStatus) Size() (n int) {
	var l int
	_ = l
	if len(m.ConnStatus) > 0 {
		for _, e := range m.ConnStatus {
			l = e.Size()
			n += 1 + l + sovGossip(uint64(l))
		}
	}
	if m.MaxConns != 0 {
		n += 1 + sovGossip(uint64(m.MaxConns))
	}
	return n
}

func (m *ServerStatus) Size() (n int) {
	var l int
	_ = l
	if len(m.ConnStatus) > 0 {
		for _, e := range m.ConnStatus {
			l = e.Size()
			n += 1 + l + sovGossip(uint64(l))
		}
	}
	if m.MaxConns != 0 {
		n += 1 + sovGossip(uint64(m.MaxConns))
	}
	l = m.MetricSnap.Size()
	n += 1 + l + sovGossip(uint64(l))
	return n
}

func (m *Connectivity) Size() (n int) {
	var l int
	_ = l
	if m.SentinelNodeID != 0 {
		n += 1 + sovGossip(uint64(m.SentinelNodeID))
	}
	if len(m.ClientConns) > 0 {
		for _, e := range m.ClientConns {
			l = e.Size()
			n += 1 + l + sovGossip(uint64(l))
		}
	}
	return n
}

func (m *Connectivity_Conn) Size() (n int) {
	var l int
	_ = l
	if m.SourceID != 0 {
		n += 1 + sovGossip(uint64(m.SourceID))
	}
	if m.TargetID != 0 {
		n += 1 + sovGossip(uint64(m.TargetID))
	}
	return n
}

func (m *InfoStatus) Size() (n int) {
	var l int
	_ = l
	if len(m.Infos) > 0 {
		for k, v := range m.Infos {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + len(k) + sovGossip(uint64(len(k))) + 1 + l + sovGossip(uint64(l))
			n += mapEntrySize + 1 + sovGossip(uint64(mapEntrySize))
		}
	}
	l = m.Client.Size()
	n += 1 + l + sovGossip(uint64(l))
	l = m.Server.Size()
	n += 1 + l + sovGossip(uint64(l))
	l = m.Connectivity.Size()
	n += 1 + l + sovGossip(uint64(l))
	return n
}

func (m *Info) Size() (n int) {
	var l int
	_ = l
	l = m.Value.Size()
	n += 1 + l + sovGossip(uint64(l))
	if m.OrigStamp != 0 {
		n += 1 + sovGossip(uint64(m.OrigStamp))
	}
	if m.TTLStamp != 0 {
		n += 1 + sovGossip(uint64(m.TTLStamp))
	}
	if m.Hops != 0 {
		n += 1 + sovGossip(uint64(m.Hops))
	}
	if m.NodeID != 0 {
		n += 1 + sovGossip(uint64(m.NodeID))
	}
	if m.PeerID != 0 {
		n += 1 + sovGossip(uint64(m.PeerID))
	}
	return n
}

func sovGossip(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozGossip(x uint64) (n int) {
	return sovGossip(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *BootstrapInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGossip
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BootstrapInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BootstrapInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addresses", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Addresses = append(m.Addresses, cockroach_util.UnresolvedAddr{})
			if err := m.Addresses[len(m.Addresses)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGossip(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGossip
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Request) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGossip
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Request: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Request: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Addr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HighWaterStamps", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HighWaterStamps == nil {
				m.HighWaterStamps = make(map[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID]int64)
			}
			var mapkey int32
			var mapvalue int64
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGossip
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGossip
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGossip
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= (int64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipGossip(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthGossip
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.HighWaterStamps[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(mapkey)] = mapvalue
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Delta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Delta == nil {
				m.Delta = make(map[string]*Info)
			}
			var mapkey string
			var mapvalue *Info
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGossip
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGossip
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthGossip
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGossip
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthGossip
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthGossip
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &Info{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipGossip(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthGossip
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Delta[mapkey] = mapvalue
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ClusterID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGossip(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGossip
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Response) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGossip
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Response: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Response: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Addr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Addr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AlternateAddr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AlternateAddr == nil {
				m.AlternateAddr = &cockroach_util.UnresolvedAddr{}
			}
			if err := m.AlternateAddr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AlternateNodeID", wireType)
			}
			m.AlternateNodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AlternateNodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Delta", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Delta == nil {
				m.Delta = make(map[string]*Info)
			}
			var mapkey string
			var mapvalue *Info
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGossip
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGossip
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthGossip
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGossip
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthGossip
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthGossip
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &Info{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipGossip(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthGossip
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Delta[mapkey] = mapvalue
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HighWaterStamps", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HighWaterStamps == nil {
				m.HighWaterStamps = make(map[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID]int64)
			}
			var mapkey int32
			var mapvalue int64
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGossip
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGossip
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapkey |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else if fieldNum == 2 {
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGossip
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapvalue |= (int64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipGossip(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthGossip
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.HighWaterStamps[github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(mapkey)] = mapvalue
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGossip(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGossip
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConnStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGossip
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConnStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConnStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Address = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field AgeNanos", wireType)
			}
			m.AgeNanos = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.AgeNanos |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipGossip(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGossip
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MetricSnap) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGossip
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MetricSnap: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MetricSnap: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BytesReceived", wireType)
			}
			m.BytesReceived = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BytesReceived |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BytesSent", wireType)
			}
			m.BytesSent = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BytesSent |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InfosReceived", wireType)
			}
			m.InfosReceived = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InfosReceived |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field InfosSent", wireType)
			}
			m.InfosSent = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.InfosSent |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnsRefused", wireType)
			}
			m.ConnsRefused = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ConnsRefused |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipGossip(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGossip
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OutgoingConnStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGossip
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OutgoingConnStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OutgoingConnStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnStatus", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ConnStatus.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MetricSnap", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.MetricSnap.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGossip(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGossip
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ClientStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGossip
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ClientStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ClientStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnStatus", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ConnStatus = append(m.ConnStatus, OutgoingConnStatus{})
			if err := m.ConnStatus[len(m.ConnStatus)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxConns", wireType)
			}
			m.MaxConns = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxConns |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipGossip(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGossip
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ServerStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGossip
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ServerStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ServerStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConnStatus", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ConnStatus = append(m.ConnStatus, ConnStatus{})
			if err := m.ConnStatus[len(m.ConnStatus)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxConns", wireType)
			}
			m.MaxConns = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxConns |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MetricSnap", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.MetricSnap.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGossip(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGossip
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Connectivity) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGossip
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Connectivity: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Connectivity: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SentinelNodeID", wireType)
			}
			m.SentinelNodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SentinelNodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClientConns", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ClientConns = append(m.ClientConns, Connectivity_Conn{})
			if err := m.ClientConns[len(m.ClientConns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGossip(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGossip
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Connectivity_Conn) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGossip
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Conn: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Conn: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SourceID", wireType)
			}
			m.SourceID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SourceID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TargetID", wireType)
			}
			m.TargetID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TargetID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipGossip(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGossip
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InfoStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGossip
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InfoStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InfoStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Infos", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Infos == nil {
				m.Infos = make(map[string]Info)
			}
			var mapkey string
			mapvalue := &Info{}
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowGossip
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGossip
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthGossip
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowGossip
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthGossip
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthGossip
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &Info{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipGossip(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthGossip
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.Infos[mapkey] = *mapvalue
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Client", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Client.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Server", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Server.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Connectivity", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Connectivity.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGossip(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGossip
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Info) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGossip
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Info: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Info: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGossip
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrigStamp", wireType)
			}
			m.OrigStamp = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.OrigStamp |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TTLStamp", wireType)
			}
			m.TTLStamp = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TTLStamp |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hops", wireType)
			}
			m.Hops = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Hops |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PeerID", wireType)
			}
			m.PeerID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PeerID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipGossip(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthGossip
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipGossip(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowGossip
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGossip
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthGossip
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowGossip
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipGossip(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthGossip = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowGossip   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("gossip/gossip.proto", fileDescriptorGossip) }

var fileDescriptorGossip = []byte{
	// 1211 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x57, 0xcf, 0x6f, 0x1b, 0x45,
	0x14, 0xce, 0xc6, 0x3f, 0xe2, 0x7d, 0x76, 0xd2, 0x76, 0xa8, 0x90, 0x71, 0xa9, 0x1d, 0xb9, 0x54,
	0x04, 0x09, 0xad, 0x51, 0xca, 0xa1, 0x6a, 0x39, 0x10, 0x27, 0x55, 0x6b, 0x28, 0x6d, 0xb5, 0x6e,
	0x40, 0xca, 0xc5, 0x6c, 0x76, 0x27, 0xeb, 0x55, 0xd6, 0xbb, 0x66, 0x67, 0xd6, 0x34, 0x17, 0x0e,
	0xfc, 0x05, 0x9c, 0xa0, 0x47, 0x0e, 0xf4, 0x7f, 0xe0, 0xce, 0x25, 0x42, 0x42, 0xaa, 0x38, 0x21,
	0x0e, 0x06, 0xcc, 0x89, 0x3b, 0x27, 0x4e, 0x68, 0xde, 0xcc, 0x7a, 0x37, 0x89, 0x53, 0x85, 0x24,
	0x95, 0x38, 0x79, 0xe6, 0xcd, 0xfb, 0xbe, 0x79, 0xef, 0x9b, 0xf7, 0x66, 0xd6, 0xf0, 0x8a, 0x1b,
	0x32, 0xe6, 0x0d, 0x5b, 0xf2, 0xc7, 0x18, 0x46, 0x21, 0x0f, 0xc9, 0x45, 0x3b, 0xb4, 0x77, 0xa3,
	0xd0, 0xb2, 0xfb, 0x86, 0xb4, 0xd7, 0x08, 0xce, 0x86, 0xdb, 0x2d, 0xc7, 0xe2, 0x96, 0xf4, 0xaa,
	0x55, 0x63, 0xee, 0xf9, 0xad, 0xbe, 0x6f, 0xb7, 0xb8, 0x37, 0xa0, 0x8c, 0x5b, 0x03, 0x85, 0xaf,
	0xd5, 0x70, 0x25, 0x0e, 0x22, 0xca, 0x42, 0x7f, 0x44, 0x9d, 0x9e, 0xe5, 0x38, 0x91, 0x5a, 0xbb,
	0xec, 0x86, 0x6e, 0x88, 0xc3, 0x96, 0x18, 0x49, 0x6b, 0xf3, 0x6b, 0x0d, 0x16, 0xdb, 0x61, 0xc8,
	0x19, 0x8f, 0xac, 0x61, 0x27, 0xd8, 0x09, 0x49, 0x1b, 0x74, 0x81, 0xa2, 0x8c, 0x51, 0x56, 0xd5,
	0x96, 0x73, 0x2b, 0xe5, 0xd5, 0xba, 0x91, 0xc6, 0x25, 0x76, 0x30, 0x36, 0xa7, 0x3b, 0xac, 0x39,
	0x4e, 0xd4, 0xce, 0xef, 0x8f, 0x1b, 0x73, 0x66, 0x0a, 0x23, 0x6b, 0xa0, 0x4f, 0x43, 0xab, 0xce,
	0x2f, 0x6b, 0x2b, 0xe5, 0xd5, 0xab, 0x87, 0x39, 0xfa, 0xbe, 0x6d, 0x3c, 0x4e, 0x9c, 0x12, 0x8a,
	0x29, 0xaa, 0xf9, 0x77, 0x1e, 0x16, 0x4c, 0xfa, 0x59, 0x4c, 0x19, 0x27, 0x5b, 0xb0, 0x10, 0x84,
	0x0e, 0xed, 0x79, 0x4e, 0x55, 0x5b, 0xd6, 0x56, 0x0a, 0xed, 0xb5, 0xc9, 0xb8, 0x51, 0x7c, 0x10,
	0x3a, 0xb4, 0xb3, 0xf1, 0xcf, 0xb8, 0x71, 0xc3, 0xf5, 0x78, 0x3f, 0xde, 0x36, 0xec, 0x70, 0xd0,
	0x9a, 0x6e, 0xe2, 0x6c, 0xa7, 0xe3, 0xd6, 0x70, 0xd7, 0x6d, 0x29, 0x21, 0x0d, 0x09, 0x33, 0x8b,
	0x82, 0xb1, 0xe3, 0x90, 0x9b, 0x90, 0x17, 0x71, 0xab, 0x28, 0x4f, 0x96, 0x29, 0x22, 0xc8, 0x37,
	0x1a, 0x5c, 0xea, 0x7b, 0x6e, 0xbf, 0xf7, 0xb9, 0xc5, 0x69, 0xd4, 0xc3, 0xb0, 0x59, 0x35, 0x87,
	0x8a, 0x19, 0xc6, 0xe1, 0x93, 0x34, 0x54, 0x32, 0xc6, 0x3d, 0xcf, 0xed, 0x7f, 0x22, 0x10, 0x5d,
	0x04, 0xdc, 0x09, 0x78, 0xb4, 0xd7, 0xbe, 0x2d, 0x78, 0xbf, 0xfc, 0xed, 0x74, 0xa9, 0x5c, 0xe8,
	0x1f, 0xa4, 0x24, 0xb7, 0xa0, 0xe0, 0x50, 0x9f, 0x5b, 0xd5, 0x3c, 0x06, 0xf3, 0xc6, 0xf1, 0xc1,
	0x6c, 0x08, 0x37, 0x0c, 0xc1, 0x94, 0x10, 0xe2, 0x02, 0xd8, 0x7e, 0xcc, 0x44, 0x46, 0x9e, 0x53,
	0x2d, 0x2c, 0x6b, 0x2b, 0x95, 0xf6, 0x3d, 0x11, 0xdd, 0xaf, 0x27, 0x15, 0x5a, 0xd6, 0x60, 0xec,
	0x39, 0xc6, 0xe6, 0x66, 0x67, 0x63, 0x32, 0x6e, 0xe8, 0xeb, 0x92, 0xb0, 0xb3, 0x61, 0xea, 0x8a,
	0xbb, 0xe3, 0xd4, 0xda, 0x70, 0x79, 0x96, 0x14, 0xe4, 0x22, 0xe4, 0x76, 0xe9, 0x9e, 0x3c, 0x68,
	0x53, 0x0c, 0xc9, 0x65, 0x28, 0x8c, 0x2c, 0x3f, 0xa6, 0x78, 0x46, 0x39, 0x53, 0x4e, 0x6e, 0xcd,
	0xdf, 0xd4, 0x6a, 0x8f, 0x00, 0xd2, 0x0c, 0xb2, 0x48, 0x5d, 0x22, 0xdf, 0xce, 0x22, 0xcb, 0xab,
	0xaf, 0x1e, 0x15, 0x42, 0x94, 0x7c, 0x86, 0xb1, 0xf9, 0x53, 0x01, 0x4a, 0x26, 0x65, 0xc3, 0x30,
	0x60, 0xf4, 0x7f, 0x5a, 0x77, 0x77, 0x60, 0xc9, 0xf2, 0x39, 0x8d, 0x02, 0x8b, 0x53, 0x6c, 0xf0,
	0x6a, 0xee, 0x24, 0x1c, 0xe6, 0xe2, 0x14, 0x25, 0xa6, 0x64, 0x04, 0x97, 0x52, 0x9a, 0x24, 0xcd,
	0x3c, 0xa6, 0xf9, 0xc1, 0x64, 0xdc, 0xb8, 0xb0, 0x96, 0x2c, 0x9e, 0x2d, 0xdf, 0x0b, 0xd6, 0x01,
	0x1e, 0x87, 0xdc, 0x4e, 0x8a, 0xb3, 0x80, 0xc5, 0x79, 0x7d, 0x56, 0x71, 0x4a, 0xfd, 0x67, 0x54,
	0xe7, 0xd3, 0x99, 0x3d, 0x57, 0x44, 0xa6, 0xd6, 0x0b, 0x98, 0x5e, 0x7e, 0xd3, 0x9d, 0x7f, 0x2d,
	0x9e, 0x47, 0x87, 0x34, 0x9f, 0x69, 0x00, 0xeb, 0x61, 0x10, 0x74, 0xb9, 0xc5, 0x63, 0xf6, 0x52,
	0x2b, 0xba, 0x0a, 0x0b, 0xea, 0x05, 0xc0, 0x30, 0x74, 0x33, 0x99, 0x92, 0x2b, 0xa0, 0x5b, 0x2e,
	0xed, 0x05, 0x56, 0x10, 0x32, 0x2c, 0xd6, 0x9c, 0x59, 0xb2, 0x5c, 0xfa, 0x40, 0xcc, 0x6f, 0xe5,
	0x9f, 0x7e, 0xdb, 0x98, 0x6b, 0xfe, 0xa0, 0x01, 0x7c, 0x44, 0x79, 0xe4, 0xd9, 0xdd, 0xc0, 0x1a,
	0x92, 0xeb, 0xb0, 0xb4, 0xbd, 0xc7, 0x29, 0xeb, 0x45, 0xd4, 0xa6, 0xde, 0x88, 0x3a, 0x2a, 0xb3,
	0x45, 0xb4, 0x9a, 0xca, 0x48, 0xae, 0x02, 0x48, 0x37, 0x46, 0x03, 0xae, 0x98, 0x75, 0xb4, 0x74,
	0x69, 0xc0, 0x05, 0x8b, 0x17, 0xec, 0x84, 0x19, 0x96, 0xbc, 0x64, 0x41, 0x6b, 0x96, 0x45, 0xba,
	0x21, 0x4b, 0x41, 0xb2, 0xa0, 0x05, 0x59, 0xae, 0xc1, 0xa2, 0x1d, 0x06, 0x81, 0x60, 0xd9, 0x89,
	0x19, 0x75, 0xaa, 0x45, 0xf4, 0xa8, 0xa0, 0xd1, 0x94, 0x36, 0x95, 0xc5, 0x33, 0x0d, 0xc8, 0xc3,
	0x98, 0xbb, 0xa1, 0x17, 0xb8, 0x19, 0xd5, 0xef, 0x42, 0x59, 0x38, 0x8b, 0x72, 0xe5, 0x31, 0x43,
	0xe5, 0xcb, 0xab, 0xaf, 0x1f, 0x2d, 0x80, 0x14, 0xd2, 0x2e, 0x89, 0xda, 0x7c, 0x3e, 0x6e, 0x68,
	0x26, 0xd8, 0x29, 0xd1, 0xfb, 0xb0, 0x30, 0x40, 0x91, 0x98, 0xaa, 0xa2, 0x19, 0x24, 0xa9, 0x8a,
	0x19, 0x92, 0x04, 0xa6, 0xe2, 0xfc, 0x02, 0x2a, 0xeb, 0xbe, 0x47, 0x03, 0xae, 0x78, 0x3f, 0x3c,
	0x1c, 0xe0, 0x31, 0xcf, 0xc6, 0xd1, 0xdc, 0xd4, 0xcd, 0x94, 0x0d, 0xf2, 0x0a, 0xe8, 0x03, 0xeb,
	0x49, 0x0f, 0xe5, 0xc1, 0x30, 0x0b, 0x66, 0x69, 0x60, 0x3d, 0x11, 0x98, 0x64, 0xff, 0xef, 0x35,
	0xa8, 0x74, 0x69, 0x34, 0xc2, 0xba, 0x16, 0x98, 0xf5, 0x59, 0x01, 0xbc, 0x58, 0xa1, 0xff, 0xb6,
	0x71, 0x56, 0xba, 0xdc, 0x59, 0xa4, 0xfb, 0x2e, 0x07, 0x15, 0xc1, 0x48, 0x6d, 0xee, 0x8d, 0x3c,
	0xbe, 0x47, 0x18, 0x5c, 0x14, 0x75, 0xe3, 0x05, 0xd4, 0xef, 0x1d, 0xec, 0xad, 0xce, 0x64, 0xdc,
	0x58, 0xea, 0xaa, 0xb5, 0xb3, 0xf5, 0xd8, 0x12, 0xcb, 0xd2, 0x38, 0xe4, 0x3e, 0x54, 0x6c, 0x3c,
	0xc0, 0x69, 0xb6, 0x42, 0xb0, 0x6b, 0xb3, 0x05, 0x4b, 0x42, 0xc5, 0x89, 0xd2, 0xad, 0x2c, 0xe1,
	0xa8, 0x4d, 0xed, 0x47, 0x0d, 0xf2, 0x62, 0x44, 0x3e, 0x05, 0x9d, 0x85, 0x71, 0x64, 0x67, 0x92,
	0x58, 0x9f, 0x8c, 0x1b, 0xa5, 0x2e, 0x1a, 0x4f, 0x1f, 0x7e, 0x49, 0xb2, 0x76, 0x1c, 0xb1, 0x03,
	0xb7, 0x22, 0x97, 0x72, 0xb1, 0xc3, 0x7c, 0xba, 0xc3, 0x63, 0x34, 0x9e, 0x61, 0x07, 0xc9, 0xda,
	0x49, 0x3a, 0xf1, 0xaf, 0x79, 0x00, 0x71, 0x9f, 0x4e, 0xeb, 0xab, 0x80, 0x0d, 0xad, 0x2a, 0xeb,
	0xcd, 0xd9, 0x97, 0xaf, 0x74, 0xc6, 0xa1, 0x7a, 0x22, 0xa4, 0x58, 0x12, 0x4b, 0xde, 0x83, 0xa2,
	0x54, 0x6d, 0xc6, 0xa3, 0x9d, 0xc8, 0x9d, 0xe9, 0x2a, 0x05, 0x56, 0x18, 0x81, 0x66, 0x58, 0xf2,
	0x33, 0x9e, 0x6b, 0x85, 0xce, 0xb6, 0x44, 0x82, 0x96, 0x18, 0x72, 0x0f, 0xf0, 0xbe, 0x49, 0x8e,
	0x12, 0x2f, 0xb2, 0xd9, 0x11, 0x64, 0xbc, 0x14, 0xc7, 0x01, 0xa4, 0x78, 0xa7, 0xd2, 0x04, 0xcf,
	0xe5, 0x9b, 0xe9, 0xe7, 0x79, 0xc8, 0xe3, 0x5f, 0x87, 0x77, 0x13, 0xa8, 0xbc, 0xe1, 0xaa, 0x19,
	0x68, 0x72, 0x5c, 0x1f, 0x8b, 0xf5, 0x44, 0x56, 0x74, 0x16, 0xd7, 0x6f, 0x18, 0x79, 0x6e, 0x2f,
	0xfd, 0xb7, 0x90, 0x33, 0x75, 0x61, 0xc1, 0x37, 0x8f, 0xbc, 0x05, 0x3a, 0xe7, 0xbe, 0x5a, 0xc5,
	0x2b, 0xbe, 0x5d, 0xc1, 0x8a, 0x79, 0x7c, 0x1f, 0x1d, 0xcc, 0x12, 0xe7, 0xbe, 0x74, 0x25, 0x90,
	0xef, 0x87, 0x43, 0x86, 0xe2, 0x2c, 0x9a, 0x38, 0xce, 0xbe, 0x78, 0x85, 0xf3, 0x7e, 0xf1, 0xb6,
	0x60, 0x61, 0x48, 0xe5, 0x87, 0x72, 0x31, 0xe5, 0x7e, 0x44, 0xc5, 0xa7, 0xee, 0xa9, 0xb9, 0x05,
	0x63, 0xc7, 0x59, 0x7d, 0x08, 0xc5, 0xbb, 0x28, 0x37, 0xb9, 0x33, 0x1d, 0xbd, 0x76, 0xec, 0x87,
	0x7c, 0xad, 0x76, 0xfc, 0xc7, 0x4f, 0x73, 0x6e, 0x45, 0x7b, 0x47, 0x6b, 0x2f, 0xef, 0xff, 0x51,
	0x9f, 0xdb, 0x9f, 0xd4, 0xb5, 0xe7, 0x93, 0xba, 0xf6, 0xcb, 0xa4, 0xae, 0xfd, 0x3e, 0xa9, 0x6b,
	0x5f, 0xfd, 0x59, 0x9f, 0xdb, 0x2a, 0x4a, 0xc0, 0x76, 0x11, 0xff, 0x12, 0xde, 0xf8, 0x37, 0x00,
	0x00, 0xff, 0xff, 0x0a, 0x5b, 0x2c, 0xdd, 0x9b, 0x0e, 0x00, 0x00,
}
