// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: config/zone.proto

package config

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"

import github_com_cockroachdb_cockroach_pkg_roachpb "github.com/cockroachdb/cockroach/pkg/roachpb"

import bytes "bytes"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type Constraint_Type int32

const (
	// DEPRECATED_POSITIVE has no effect on a replica's placement.
	Constraint_DEPRECATED_POSITIVE Constraint_Type = 0
	// REQUIRED ensures all replicas are placed on stores that match the
	// constraint. Replication will fail if there aren't any such stores.
	Constraint_REQUIRED Constraint_Type = 1
	// PROHIBITED will prevent replicas from having this key, value.
	Constraint_PROHIBITED Constraint_Type = 2
)

var Constraint_Type_name = map[int32]string{
	0: "DEPRECATED_POSITIVE",
	1: "REQUIRED",
	2: "PROHIBITED",
}
var Constraint_Type_value = map[string]int32{
	"DEPRECATED_POSITIVE": 0,
	"REQUIRED":            1,
	"PROHIBITED":          2,
}

func (x Constraint_Type) Enum() *Constraint_Type {
	p := new(Constraint_Type)
	*p = x
	return p
}
func (x Constraint_Type) String() string {
	return proto.EnumName(Constraint_Type_name, int32(x))
}
func (x *Constraint_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(Constraint_Type_value, data, "Constraint_Type")
	if err != nil {
		return err
	}
	*x = Constraint_Type(value)
	return nil
}
func (Constraint_Type) EnumDescriptor() ([]byte, []int) { return fileDescriptorZone, []int{1, 0} }

// GCPolicy defines garbage collection policies which apply to MVCC
// values within a zone.
//
// TODO(spencer): flesh this out to include maximum number of values
//   as well as whether there's an intersection between max values
//   and TTL or a union.
type GCPolicy struct {
	// TTLSeconds specifies the maximum age of a value before it's
	// garbage collected. Only older versions of values are garbage
	// collected. Specifying <=0 mean older versions are never GC'd.
	TTLSeconds int32 `protobuf:"varint,1,opt,name=ttl_seconds,json=ttlSeconds" json:"ttl_seconds"`
}

func (m *GCPolicy) Reset()                    { *m = GCPolicy{} }
func (m *GCPolicy) String() string            { return proto.CompactTextString(m) }
func (*GCPolicy) ProtoMessage()               {}
func (*GCPolicy) Descriptor() ([]byte, []int) { return fileDescriptorZone, []int{0} }

// Constraint constrains the stores a replica can be stored on.
type Constraint struct {
	Type Constraint_Type `protobuf:"varint,1,opt,name=type,enum=cockroach.config.Constraint_Type" json:"type"`
	// Key is only set if this is a constraint on locality.
	Key string `protobuf:"bytes,2,opt,name=key" json:"key"`
	// Value to constrain to.
	Value string `protobuf:"bytes,3,opt,name=value" json:"value"`
}

func (m *Constraint) Reset()                    { *m = Constraint{} }
func (*Constraint) ProtoMessage()               {}
func (*Constraint) Descriptor() ([]byte, []int) { return fileDescriptorZone, []int{1} }

// Constraints is a collection of constraints.
type Constraints struct {
	// The number of replicas that should abide by the constraints. If left
	// unspecified (i.e. set to 0), the constraints will be assumed to apply
	// to all replicas of the range.
	// As of v2.0, only REQUIRED constraints are allowed when num_replicas is
	// set to a non-zero value.
	NumReplicas int32        `protobuf:"varint,7,opt,name=num_replicas,json=numReplicas" json:"num_replicas"`
	Constraints []Constraint `protobuf:"bytes,6,rep,name=constraints" json:"constraints"`
}

func (m *Constraints) Reset()                    { *m = Constraints{} }
func (m *Constraints) String() string            { return proto.CompactTextString(m) }
func (*Constraints) ProtoMessage()               {}
func (*Constraints) Descriptor() ([]byte, []int) { return fileDescriptorZone, []int{2} }

// LeasePreference specifies a preference about where range leases should be
// located.
type LeasePreference struct {
	Constraints []Constraint `protobuf:"bytes,1,rep,name=constraints" json:"constraints" yaml:"constraints,flow"`
}

func (m *LeasePreference) Reset()                    { *m = LeasePreference{} }
func (m *LeasePreference) String() string            { return proto.CompactTextString(m) }
func (*LeasePreference) ProtoMessage()               {}
func (*LeasePreference) Descriptor() ([]byte, []int) { return fileDescriptorZone, []int{3} }

// ZoneConfig holds configuration that applies to one or more ranges.
//
// Note: when adding.removing fields here, be sure to update
// supportedZoneConfigOptions in the sql package, to synchronize
// with the code for ALTER ... CONFIGURE ZONE.
type ZoneConfig struct {
	RangeMinBytes int64 `protobuf:"varint,2,opt,name=range_min_bytes,json=rangeMinBytes" json:"range_min_bytes" yaml:"range_min_bytes"`
	RangeMaxBytes int64 `protobuf:"varint,3,opt,name=range_max_bytes,json=rangeMaxBytes" json:"range_max_bytes" yaml:"range_max_bytes"`
	// If GC policy is not set, uses the next highest, non-null policy
	// in the zone config hierarchy, up to the default policy if necessary.
	GC GCPolicy `protobuf:"bytes,4,opt,name=gc" json:"gc"`
	// NumReplicas specifies the desired number of replicas
	NumReplicas int32 `protobuf:"varint,5,opt,name=num_replicas,json=numReplicas" json:"num_replicas" yaml:"num_replicas"`
	// Constraints constrains which stores the replicas can be stored on. The
	// order in which the constraints are stored is arbitrary and may change.
	// https://github.com/cockroachdb/cockroach/blob/master/docs/RFCS/20160706_expressive_zone_config.md#constraint-system
	//
	// NOTE: The sum of the num_replicas fields of the Constraints must add up to
	// ZoneConfig.num_replicas, or there must be no more than a single Constraints
	// field with num_replicas set to 0.
	Constraints []Constraints `protobuf:"bytes,6,rep,name=constraints" json:"constraints" yaml:"constraints,flow"`
	// LeasePreference stores information about where the user would prefer for
	// range leases to be placed. Leases are allowed to be placed elsewhere if
	// needed, but will follow the provided preference when possible.
	//
	// More than one lease preference is allowed, but they should be ordered from
	// most preferred to lease preferred. The first preference that an existing
	// replica of a range matches will take priority.
	LeasePreferences []LeasePreference `protobuf:"bytes,9,rep,name=lease_preferences,json=leasePreferences" json:"lease_preferences" yaml:"lease_preferences,flow"`
	// Subzones stores config overrides for "subzones", each of which represents
	// either a SQL table index or a partition of a SQL table index. Subzones are
	// not applicable when the zone does not represent a SQL table (i.e., when the
	// zone represents a database, a special system range, or is itself a
	// subzone.)
	Subzones []Subzone `protobuf:"bytes,8,rep,name=subzones" json:"subzones" yaml:"-"`
	// SubzoneSpans maps each key span in a subzone to the slice index of an entry
	// in SubzoneConfig. Spans are non-overlapping and sorted by start key to
	// allow binary searching. SubzoneSpans can be easily derived from a
	// TableDescriptor, but are denormalized here to make GetZoneConfigForKey
	// lookups efficient.
	SubzoneSpans []SubzoneSpan `protobuf:"bytes,7,rep,name=subzone_spans,json=subzoneSpans" json:"subzone_spans" yaml:"-"`
}

func (m *ZoneConfig) Reset()                    { *m = ZoneConfig{} }
func (m *ZoneConfig) String() string            { return proto.CompactTextString(m) }
func (*ZoneConfig) ProtoMessage()               {}
func (*ZoneConfig) Descriptor() ([]byte, []int) { return fileDescriptorZone, []int{4} }

type Subzone struct {
	// IndexID is the ID of the SQL table index that the subzone represents. It
	// must always be set even though partition names are unique across all of a
	// table's indices.
	IndexID uint32 `protobuf:"varint,1,opt,name=index_id,json=indexId" json:"index_id"`
	// PartitionName is the partition of the SQL table index that the subzone
	// represents. It is empty when the subzone represents the entire index.
	PartitionName string `protobuf:"bytes,2,opt,name=partition_name,json=partitionName" json:"partition_name"`
	// Config stores the ZoneConfig that applies to this Subzone. It never
	// contains nested subzones.
	Config ZoneConfig `protobuf:"bytes,3,opt,name=config" json:"config"`
}

func (m *Subzone) Reset()                    { *m = Subzone{} }
func (m *Subzone) String() string            { return proto.CompactTextString(m) }
func (*Subzone) ProtoMessage()               {}
func (*Subzone) Descriptor() ([]byte, []int) { return fileDescriptorZone, []int{5} }

type SubzoneSpan struct {
	// Key stores a key suffix that represents the inclusive lower bound for this
	// span. The SQL table prefix, like /Table/51/, is omitted.
	//
	// Both Key and EndKey, below, are cast to roachpb.Key for convenience, but
	// there's no technical restriction that prevents switching them to []byte or
	// another type that communicates their missing prefix.
	Key github_com_cockroachdb_cockroach_pkg_roachpb.Key `protobuf:"bytes,1,opt,name=key,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.Key" json:"key,omitempty"`
	// EndKey stores a key suffix that represents the exclusive upper bound for
	// this span. Like with Key, the SQL table prefix is omitted. If EndKey is
	// empty, it is assumed to be Key.PrefixEnd().
	EndKey github_com_cockroachdb_cockroach_pkg_roachpb.Key `protobuf:"bytes,2,opt,name=end_key,json=endKey,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.Key" json:"end_key,omitempty"`
	// SubzoneIndex is the slice index of the Subzone this span belongs to in the
	// parent ZoneConfig's Subzones field.
	SubzoneIndex int32 `protobuf:"varint,3,opt,name=subzone_index,json=subzoneIndex" json:"subzone_index"`
}

func (m *SubzoneSpan) Reset()                    { *m = SubzoneSpan{} }
func (m *SubzoneSpan) String() string            { return proto.CompactTextString(m) }
func (*SubzoneSpan) ProtoMessage()               {}
func (*SubzoneSpan) Descriptor() ([]byte, []int) { return fileDescriptorZone, []int{6} }

func init() {
	proto.RegisterType((*GCPolicy)(nil), "cockroach.config.GCPolicy")
	proto.RegisterType((*Constraint)(nil), "cockroach.config.Constraint")
	proto.RegisterType((*Constraints)(nil), "cockroach.config.Constraints")
	proto.RegisterType((*LeasePreference)(nil), "cockroach.config.LeasePreference")
	proto.RegisterType((*ZoneConfig)(nil), "cockroach.config.ZoneConfig")
	proto.RegisterType((*Subzone)(nil), "cockroach.config.Subzone")
	proto.RegisterType((*SubzoneSpan)(nil), "cockroach.config.SubzoneSpan")
	proto.RegisterEnum("cockroach.config.Constraint_Type", Constraint_Type_name, Constraint_Type_value)
}
func (this *GCPolicy) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GCPolicy)
	if !ok {
		that2, ok := that.(GCPolicy)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.TTLSeconds != that1.TTLSeconds {
		return false
	}
	return true
}
func (this *Constraint) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Constraint)
	if !ok {
		that2, ok := that.(Constraint)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.Key != that1.Key {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	return true
}
func (this *Constraints) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Constraints)
	if !ok {
		that2, ok := that.(Constraints)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.NumReplicas != that1.NumReplicas {
		return false
	}
	if len(this.Constraints) != len(that1.Constraints) {
		return false
	}
	for i := range this.Constraints {
		if !this.Constraints[i].Equal(&that1.Constraints[i]) {
			return false
		}
	}
	return true
}
func (this *LeasePreference) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*LeasePreference)
	if !ok {
		that2, ok := that.(LeasePreference)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Constraints) != len(that1.Constraints) {
		return false
	}
	for i := range this.Constraints {
		if !this.Constraints[i].Equal(&that1.Constraints[i]) {
			return false
		}
	}
	return true
}
func (this *ZoneConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ZoneConfig)
	if !ok {
		that2, ok := that.(ZoneConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.RangeMinBytes != that1.RangeMinBytes {
		return false
	}
	if this.RangeMaxBytes != that1.RangeMaxBytes {
		return false
	}
	if !this.GC.Equal(&that1.GC) {
		return false
	}
	if this.NumReplicas != that1.NumReplicas {
		return false
	}
	if len(this.Constraints) != len(that1.Constraints) {
		return false
	}
	for i := range this.Constraints {
		if !this.Constraints[i].Equal(&that1.Constraints[i]) {
			return false
		}
	}
	if len(this.LeasePreferences) != len(that1.LeasePreferences) {
		return false
	}
	for i := range this.LeasePreferences {
		if !this.LeasePreferences[i].Equal(&that1.LeasePreferences[i]) {
			return false
		}
	}
	if len(this.Subzones) != len(that1.Subzones) {
		return false
	}
	for i := range this.Subzones {
		if !this.Subzones[i].Equal(&that1.Subzones[i]) {
			return false
		}
	}
	if len(this.SubzoneSpans) != len(that1.SubzoneSpans) {
		return false
	}
	for i := range this.SubzoneSpans {
		if !this.SubzoneSpans[i].Equal(&that1.SubzoneSpans[i]) {
			return false
		}
	}
	return true
}
func (this *Subzone) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*Subzone)
	if !ok {
		that2, ok := that.(Subzone)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.IndexID != that1.IndexID {
		return false
	}
	if this.PartitionName != that1.PartitionName {
		return false
	}
	if !this.Config.Equal(&that1.Config) {
		return false
	}
	return true
}
func (this *SubzoneSpan) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*SubzoneSpan)
	if !ok {
		that2, ok := that.(SubzoneSpan)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !bytes.Equal(this.Key, that1.Key) {
		return false
	}
	if !bytes.Equal(this.EndKey, that1.EndKey) {
		return false
	}
	if this.SubzoneIndex != that1.SubzoneIndex {
		return false
	}
	return true
}
func (m *GCPolicy) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GCPolicy) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintZone(dAtA, i, uint64(m.TTLSeconds))
	return i, nil
}

func (m *Constraint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Constraint) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintZone(dAtA, i, uint64(m.Type))
	dAtA[i] = 0x12
	i++
	i = encodeVarintZone(dAtA, i, uint64(len(m.Key)))
	i += copy(dAtA[i:], m.Key)
	dAtA[i] = 0x1a
	i++
	i = encodeVarintZone(dAtA, i, uint64(len(m.Value)))
	i += copy(dAtA[i:], m.Value)
	return i, nil
}

func (m *Constraints) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Constraints) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Constraints) > 0 {
		for _, msg := range m.Constraints {
			dAtA[i] = 0x32
			i++
			i = encodeVarintZone(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x38
	i++
	i = encodeVarintZone(dAtA, i, uint64(m.NumReplicas))
	return i, nil
}

func (m *LeasePreference) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LeasePreference) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Constraints) > 0 {
		for _, msg := range m.Constraints {
			dAtA[i] = 0xa
			i++
			i = encodeVarintZone(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *ZoneConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ZoneConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x10
	i++
	i = encodeVarintZone(dAtA, i, uint64(m.RangeMinBytes))
	dAtA[i] = 0x18
	i++
	i = encodeVarintZone(dAtA, i, uint64(m.RangeMaxBytes))
	dAtA[i] = 0x22
	i++
	i = encodeVarintZone(dAtA, i, uint64(m.GC.Size()))
	n1, err := m.GC.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	dAtA[i] = 0x28
	i++
	i = encodeVarintZone(dAtA, i, uint64(m.NumReplicas))
	if len(m.Constraints) > 0 {
		for _, msg := range m.Constraints {
			dAtA[i] = 0x32
			i++
			i = encodeVarintZone(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.SubzoneSpans) > 0 {
		for _, msg := range m.SubzoneSpans {
			dAtA[i] = 0x3a
			i++
			i = encodeVarintZone(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Subzones) > 0 {
		for _, msg := range m.Subzones {
			dAtA[i] = 0x42
			i++
			i = encodeVarintZone(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.LeasePreferences) > 0 {
		for _, msg := range m.LeasePreferences {
			dAtA[i] = 0x4a
			i++
			i = encodeVarintZone(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Subzone) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Subzone) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintZone(dAtA, i, uint64(m.IndexID))
	dAtA[i] = 0x12
	i++
	i = encodeVarintZone(dAtA, i, uint64(len(m.PartitionName)))
	i += copy(dAtA[i:], m.PartitionName)
	dAtA[i] = 0x1a
	i++
	i = encodeVarintZone(dAtA, i, uint64(m.Config.Size()))
	n2, err := m.Config.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	return i, nil
}

func (m *SubzoneSpan) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SubzoneSpan) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Key != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintZone(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	if m.EndKey != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintZone(dAtA, i, uint64(len(m.EndKey)))
		i += copy(dAtA[i:], m.EndKey)
	}
	dAtA[i] = 0x18
	i++
	i = encodeVarintZone(dAtA, i, uint64(m.SubzoneIndex))
	return i, nil
}

func encodeVarintZone(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func NewPopulatedGCPolicy(r randyZone, easy bool) *GCPolicy {
	this := &GCPolicy{}
	this.TTLSeconds = int32(r.Int31())
	if r.Intn(2) == 0 {
		this.TTLSeconds *= -1
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedConstraint(r randyZone, easy bool) *Constraint {
	this := &Constraint{}
	this.Type = Constraint_Type([]int32{0, 1, 2}[r.Intn(3)])
	this.Key = string(randStringZone(r))
	this.Value = string(randStringZone(r))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedConstraints(r randyZone, easy bool) *Constraints {
	this := &Constraints{}
	if r.Intn(10) != 0 {
		v1 := r.Intn(5)
		this.Constraints = make([]Constraint, v1)
		for i := 0; i < v1; i++ {
			v2 := NewPopulatedConstraint(r, easy)
			this.Constraints[i] = *v2
		}
	}
	this.NumReplicas = int32(r.Int31())
	if r.Intn(2) == 0 {
		this.NumReplicas *= -1
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedLeasePreference(r randyZone, easy bool) *LeasePreference {
	this := &LeasePreference{}
	if r.Intn(10) != 0 {
		v3 := r.Intn(5)
		this.Constraints = make([]Constraint, v3)
		for i := 0; i < v3; i++ {
			v4 := NewPopulatedConstraint(r, easy)
			this.Constraints[i] = *v4
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedZoneConfig(r randyZone, easy bool) *ZoneConfig {
	this := &ZoneConfig{}
	this.RangeMinBytes = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.RangeMinBytes *= -1
	}
	this.RangeMaxBytes = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.RangeMaxBytes *= -1
	}
	v5 := NewPopulatedGCPolicy(r, easy)
	this.GC = *v5
	this.NumReplicas = int32(r.Int31())
	if r.Intn(2) == 0 {
		this.NumReplicas *= -1
	}
	if r.Intn(10) != 0 {
		v6 := r.Intn(5)
		this.Constraints = make([]Constraints, v6)
		for i := 0; i < v6; i++ {
			v7 := NewPopulatedConstraints(r, easy)
			this.Constraints[i] = *v7
		}
	}
	if r.Intn(10) != 0 {
		v8 := r.Intn(5)
		this.SubzoneSpans = make([]SubzoneSpan, v8)
		for i := 0; i < v8; i++ {
			v9 := NewPopulatedSubzoneSpan(r, easy)
			this.SubzoneSpans[i] = *v9
		}
	}
	if r.Intn(10) == 0 {
		v10 := r.Intn(5)
		this.Subzones = make([]Subzone, v10)
		for i := 0; i < v10; i++ {
			v11 := NewPopulatedSubzone(r, easy)
			this.Subzones[i] = *v11
		}
	}
	if r.Intn(10) != 0 {
		v12 := r.Intn(5)
		this.LeasePreferences = make([]LeasePreference, v12)
		for i := 0; i < v12; i++ {
			v13 := NewPopulatedLeasePreference(r, easy)
			this.LeasePreferences[i] = *v13
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedSubzone(r randyZone, easy bool) *Subzone {
	this := &Subzone{}
	this.IndexID = uint32(r.Uint32())
	this.PartitionName = string(randStringZone(r))
	v14 := NewPopulatedZoneConfig(r, easy)
	this.Config = *v14
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedSubzoneSpan(r randyZone, easy bool) *SubzoneSpan {
	this := &SubzoneSpan{}
	if r.Intn(10) != 0 {
		v15 := r.Intn(100)
		this.Key = make(github_com_cockroachdb_cockroach_pkg_roachpb.Key, v15)
		for i := 0; i < v15; i++ {
			this.Key[i] = byte(r.Intn(256))
		}
	}
	if r.Intn(10) != 0 {
		v16 := r.Intn(100)
		this.EndKey = make(github_com_cockroachdb_cockroach_pkg_roachpb.Key, v16)
		for i := 0; i < v16; i++ {
			this.EndKey[i] = byte(r.Intn(256))
		}
	}
	this.SubzoneIndex = int32(r.Int31())
	if r.Intn(2) == 0 {
		this.SubzoneIndex *= -1
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

type randyZone interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneZone(r randyZone) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringZone(r randyZone) string {
	v17 := r.Intn(100)
	tmps := make([]rune, v17)
	for i := 0; i < v17; i++ {
		tmps[i] = randUTF8RuneZone(r)
	}
	return string(tmps)
}
func randUnrecognizedZone(r randyZone, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldZone(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldZone(dAtA []byte, r randyZone, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateZone(dAtA, uint64(key))
		v18 := r.Int63()
		if r.Intn(2) == 0 {
			v18 *= -1
		}
		dAtA = encodeVarintPopulateZone(dAtA, uint64(v18))
	case 1:
		dAtA = encodeVarintPopulateZone(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateZone(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateZone(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateZone(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateZone(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *GCPolicy) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovZone(uint64(m.TTLSeconds))
	return n
}

func (m *Constraint) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovZone(uint64(m.Type))
	l = len(m.Key)
	n += 1 + l + sovZone(uint64(l))
	l = len(m.Value)
	n += 1 + l + sovZone(uint64(l))
	return n
}

func (m *Constraints) Size() (n int) {
	var l int
	_ = l
	if len(m.Constraints) > 0 {
		for _, e := range m.Constraints {
			l = e.Size()
			n += 1 + l + sovZone(uint64(l))
		}
	}
	n += 1 + sovZone(uint64(m.NumReplicas))
	return n
}

func (m *LeasePreference) Size() (n int) {
	var l int
	_ = l
	if len(m.Constraints) > 0 {
		for _, e := range m.Constraints {
			l = e.Size()
			n += 1 + l + sovZone(uint64(l))
		}
	}
	return n
}

func (m *ZoneConfig) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovZone(uint64(m.RangeMinBytes))
	n += 1 + sovZone(uint64(m.RangeMaxBytes))
	l = m.GC.Size()
	n += 1 + l + sovZone(uint64(l))
	n += 1 + sovZone(uint64(m.NumReplicas))
	if len(m.Constraints) > 0 {
		for _, e := range m.Constraints {
			l = e.Size()
			n += 1 + l + sovZone(uint64(l))
		}
	}
	if len(m.SubzoneSpans) > 0 {
		for _, e := range m.SubzoneSpans {
			l = e.Size()
			n += 1 + l + sovZone(uint64(l))
		}
	}
	if len(m.Subzones) > 0 {
		for _, e := range m.Subzones {
			l = e.Size()
			n += 1 + l + sovZone(uint64(l))
		}
	}
	if len(m.LeasePreferences) > 0 {
		for _, e := range m.LeasePreferences {
			l = e.Size()
			n += 1 + l + sovZone(uint64(l))
		}
	}
	return n
}

func (m *Subzone) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovZone(uint64(m.IndexID))
	l = len(m.PartitionName)
	n += 1 + l + sovZone(uint64(l))
	l = m.Config.Size()
	n += 1 + l + sovZone(uint64(l))
	return n
}

func (m *SubzoneSpan) Size() (n int) {
	var l int
	_ = l
	if m.Key != nil {
		l = len(m.Key)
		n += 1 + l + sovZone(uint64(l))
	}
	if m.EndKey != nil {
		l = len(m.EndKey)
		n += 1 + l + sovZone(uint64(l))
	}
	n += 1 + sovZone(uint64(m.SubzoneIndex))
	return n
}

func sovZone(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozZone(x uint64) (n int) {
	return sovZone(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *GCPolicy) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowZone
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GCPolicy: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GCPolicy: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TTLSeconds", wireType)
			}
			m.TTLSeconds = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TTLSeconds |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipZone(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthZone
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Constraint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowZone
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Constraint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Constraint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (Constraint_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthZone
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthZone
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipZone(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthZone
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Constraints) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowZone
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Constraints: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Constraints: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Constraints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthZone
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Constraints = append(m.Constraints, Constraint{})
			if err := m.Constraints[len(m.Constraints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumReplicas", wireType)
			}
			m.NumReplicas = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumReplicas |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipZone(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthZone
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LeasePreference) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowZone
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LeasePreference: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LeasePreference: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Constraints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthZone
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Constraints = append(m.Constraints, Constraint{})
			if err := m.Constraints[len(m.Constraints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipZone(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthZone
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ZoneConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowZone
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ZoneConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ZoneConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeMinBytes", wireType)
			}
			m.RangeMinBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeMinBytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeMaxBytes", wireType)
			}
			m.RangeMaxBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeMaxBytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GC", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthZone
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.GC.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumReplicas", wireType)
			}
			m.NumReplicas = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumReplicas |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Constraints", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthZone
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Constraints = append(m.Constraints, Constraints{})
			if err := m.Constraints[len(m.Constraints)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubzoneSpans", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthZone
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SubzoneSpans = append(m.SubzoneSpans, SubzoneSpan{})
			if err := m.SubzoneSpans[len(m.SubzoneSpans)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Subzones", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthZone
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Subzones = append(m.Subzones, Subzone{})
			if err := m.Subzones[len(m.Subzones)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeasePreferences", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthZone
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LeasePreferences = append(m.LeasePreferences, LeasePreference{})
			if err := m.LeasePreferences[len(m.LeasePreferences)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipZone(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthZone
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Subzone) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowZone
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Subzone: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Subzone: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IndexID", wireType)
			}
			m.IndexID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IndexID |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PartitionName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthZone
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PartitionName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthZone
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Config.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipZone(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthZone
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SubzoneSpan) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowZone
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SubzoneSpan: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SubzoneSpan: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthZone
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthZone
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SubzoneIndex", wireType)
			}
			m.SubzoneIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowZone
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SubzoneIndex |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipZone(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthZone
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipZone(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowZone
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowZone
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowZone
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthZone
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowZone
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipZone(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthZone = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowZone   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("config/zone.proto", fileDescriptorZone) }

var fileDescriptorZone = []byte{
	// 803 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x54, 0xbf, 0x8f, 0xe3, 0x44,
	0x14, 0xce, 0xe4, 0xc7, 0xc6, 0xf7, 0x92, 0xec, 0xe6, 0xe6, 0xd0, 0x9d, 0x59, 0xb8, 0x38, 0x58,
	0x42, 0x84, 0x5f, 0x09, 0x5a, 0x10, 0x45, 0x10, 0x48, 0x38, 0xc9, 0x2d, 0xe6, 0xee, 0xb8, 0xe0,
	0x04, 0x8a, 0x6b, 0x8c, 0xe3, 0xcc, 0x7a, 0xad, 0x75, 0xc6, 0x96, 0xed, 0xc0, 0x1a, 0x51, 0x53,
	0x53, 0x52, 0x50, 0x6c, 0xc9, 0x9f, 0xc0, 0x9f, 0xb0, 0xa2, 0xa2, 0x84, 0x26, 0x82, 0xd0, 0x50,
	0x53, 0x52, 0x21, 0x8f, 0x27, 0xb1, 0x93, 0xcd, 0xae, 0xe0, 0xba, 0x99, 0x79, 0xef, 0x7d, 0xdf,
	0x9b, 0xf7, 0xbe, 0xf7, 0xe0, 0xb6, 0xe9, 0xd2, 0x13, 0xdb, 0xea, 0x7c, 0xed, 0x52, 0xd2, 0xf6,
	0x7c, 0x37, 0x74, 0x71, 0xdd, 0x74, 0xcd, 0x33, 0xdf, 0x35, 0xcc, 0xd3, 0x76, 0x62, 0x3c, 0x7c,
	0xce, 0x72, 0x2d, 0x97, 0x19, 0x3b, 0xf1, 0x29, 0xf1, 0x93, 0x55, 0x10, 0x8e, 0x7b, 0x43, 0xd7,
	0xb1, 0xcd, 0x08, 0xbf, 0x0d, 0x95, 0x30, 0x74, 0xf4, 0x80, 0x98, 0x2e, 0x9d, 0x06, 0x22, 0x6a,
	0xa2, 0x56, 0x49, 0xc1, 0x97, 0x0b, 0x29, 0xb7, 0x5c, 0x48, 0x30, 0x1e, 0x3f, 0x1a, 0x25, 0x16,
	0x0d, 0xc2, 0xd0, 0xe1, 0xe7, 0xae, 0xf0, 0xd3, 0x85, 0x84, 0xfe, 0xba, 0x90, 0x90, 0xfc, 0x33,
	0x02, 0xe8, 0xb9, 0x34, 0x08, 0x7d, 0xc3, 0xa6, 0x21, 0x7e, 0x0f, 0x8a, 0x61, 0xe4, 0x11, 0x06,
	0xb3, 0x7f, 0xf4, 0x52, 0x7b, 0x3b, 0xa1, 0x76, 0xea, 0xdb, 0x1e, 0x47, 0x1e, 0x51, 0x8a, 0x31,
	0x93, 0xc6, 0x82, 0xf0, 0x5d, 0x28, 0x9c, 0x91, 0x48, 0xcc, 0x37, 0x51, 0xeb, 0x16, 0x37, 0xc4,
	0x0f, 0xf8, 0x10, 0x4a, 0x5f, 0x1a, 0xce, 0x9c, 0x88, 0x85, 0x8c, 0x25, 0x79, 0x92, 0xdf, 0x87,
	0x62, 0x8c, 0x83, 0xef, 0xc1, 0x9d, 0xfe, 0x60, 0xa8, 0x0d, 0x7a, 0x1f, 0x8e, 0x07, 0x7d, 0x7d,
	0xf8, 0x64, 0xa4, 0x8e, 0xd5, 0xcf, 0x07, 0xf5, 0x1c, 0xae, 0x82, 0xa0, 0x0d, 0x3e, 0xfd, 0x4c,
	0xd5, 0x06, 0xfd, 0x3a, 0xc2, 0xfb, 0x00, 0x43, 0xed, 0xc9, 0x47, 0xaa, 0xa2, 0x8e, 0x07, 0xfd,
	0x7a, 0xbe, 0x5b, 0xfd, 0xfe, 0x42, 0xca, 0xad, 0x3f, 0xf3, 0x2d, 0x82, 0x4a, 0x9a, 0x60, 0x80,
	0xfb, 0x50, 0x31, 0xd3, 0xab, 0xb8, 0xd7, 0x2c, 0xb4, 0x2a, 0x47, 0x2f, 0xde, 0xf4, 0x29, 0x9e,
	0x5c, 0x36, 0x0c, 0xbf, 0x02, 0x55, 0x3a, 0x9f, 0xe9, 0x3e, 0xf1, 0x1c, 0xdb, 0x34, 0x02, 0xb1,
	0xcc, 0x4a, 0xcc, 0x1d, 0xe9, 0x7c, 0xa6, 0x71, 0x43, 0xa6, 0xaa, 0xdf, 0xc0, 0xc1, 0x23, 0x62,
	0x04, 0x64, 0xe8, 0x93, 0x13, 0xe2, 0x13, 0x6a, 0x12, 0xac, 0x6f, 0xe6, 0x82, 0xfe, 0x43, 0x2e,
	0x52, 0x4c, 0xf1, 0xf7, 0x42, 0xba, 0x17, 0x19, 0x33, 0xa7, 0x2b, 0x67, 0xc2, 0xdf, 0x38, 0x71,
	0xdc, 0xaf, 0xe4, 0x8d, 0x34, 0x33, 0xec, 0x3f, 0x94, 0x00, 0x9e, 0xba, 0x94, 0xf4, 0x18, 0x22,
	0x7e, 0x00, 0x07, 0xbe, 0x41, 0x2d, 0xa2, 0xcf, 0x6c, 0xaa, 0x4f, 0xa2, 0x90, 0x04, 0xac, 0x45,
	0x05, 0xa5, 0xc1, 0xf1, 0xef, 0x26, 0xf8, 0x5b, 0x4e, 0xb2, 0x56, 0x63, 0x2f, 0x8f, 0x6d, 0xaa,
	0xc4, 0xf7, 0x0c, 0x8e, 0x71, 0xce, 0x71, 0x0a, 0x37, 0xe0, 0xac, 0x9c, 0xd6, 0x38, 0xc6, 0x79,
	0x82, 0xf3, 0x2e, 0xe4, 0x2d, 0x53, 0x2c, 0x36, 0x51, 0xab, 0x72, 0x74, 0x78, 0xb5, 0x00, 0x2b,
	0x65, 0x2b, 0xc0, 0x45, 0x9c, 0x3f, 0xee, 0x69, 0x79, 0xcb, 0xc4, 0x1f, 0x6c, 0xf5, 0xa1, 0xc4,
	0xfa, 0xf0, 0x02, 0x27, 0xbf, 0x93, 0x90, 0x67, 0x3d, 0xe4, 0x8d, 0xf6, 0xe0, 0x2f, 0x76, 0xa9,
	0xe1, 0xfe, 0x4d, 0x1d, 0x08, 0xfe, 0x5f, 0x0b, 0xf0, 0x18, 0x6a, 0xc1, 0x7c, 0x12, 0x0f, 0xb4,
	0x1e, 0x78, 0x06, 0x8d, 0xa5, 0x72, 0x0d, 0xc7, 0x28, 0x71, 0x1b, 0x79, 0x06, 0x55, 0xea, 0x9c,
	0x43, 0x48, 0x38, 0xde, 0x94, 0xb5, 0x6a, 0x90, 0x9a, 0x03, 0x7c, 0x0c, 0x02, 0xbf, 0x07, 0xa2,
	0xc0, 0x00, 0x9f, 0xbf, 0x16, 0x70, 0x07, 0xd8, 0x3a, 0x18, 0xcf, 0xe1, 0xb6, 0x13, 0xab, 0x52,
	0xf7, 0xd6, 0xb2, 0x0c, 0xc4, 0x5b, 0x0c, 0x71, 0xc7, 0xa4, 0x6f, 0x09, 0x58, 0x79, 0x99, 0x23,
	0xdf, 0x4f, 0x90, 0xaf, 0x20, 0xf1, 0x82, 0xd4, 0x9d, 0xcd, 0xb8, 0x8c, 0x30, 0x3f, 0x2e, 0x0a,
	0xa8, 0x9e, 0x97, 0x7f, 0x44, 0x50, 0xe6, 0xe9, 0xe2, 0xd7, 0x40, 0xb0, 0xe9, 0x94, 0x9c, 0xeb,
	0xf6, 0x94, 0xed, 0x9c, 0x9a, 0x72, 0xc0, 0xbb, 0x5e, 0x56, 0xe3, 0x77, 0xb5, 0xaf, 0x95, 0x99,
	0x83, 0x3a, 0xc5, 0xaf, 0xc3, 0xbe, 0x67, 0xf8, 0xa1, 0x1d, 0xda, 0x2e, 0xd5, 0xa9, 0x31, 0x23,
	0x1b, 0x9b, 0xa6, 0xb6, 0xb6, 0x7d, 0x62, 0xcc, 0x08, 0xee, 0xc2, 0x5e, 0xf2, 0x0f, 0xa6, 0xd1,
	0x9d, 0x93, 0x96, 0x8e, 0x08, 0x87, 0xe0, 0x11, 0x99, 0x49, 0xfa, 0x0d, 0x41, 0x25, 0xd3, 0x2a,
	0xfc, 0x20, 0xd9, 0x70, 0x71, 0xa6, 0x55, 0xe5, 0x9d, 0x7f, 0x16, 0xd2, 0x5b, 0x96, 0x1d, 0x9e,
	0xce, 0x27, 0x6d, 0xd3, 0x9d, 0x75, 0xd6, 0x04, 0xd3, 0x49, 0x7a, 0xee, 0x78, 0x67, 0x56, 0x87,
	0x9d, 0xbc, 0x49, 0xfb, 0x21, 0x89, 0x92, 0x8d, 0xf8, 0x18, 0xca, 0x84, 0x4e, 0xf5, 0xd5, 0xb6,
	0x7c, 0x56, 0xac, 0x3d, 0x42, 0xa7, 0x0f, 0x49, 0x84, 0x5f, 0x4d, 0x75, 0xc7, 0x8a, 0xc5, 0xfe,
	0xbc, 0x5a, 0x51, 0x2b, 0x31, 0xb1, 0x7a, 0xa6, 0x7f, 0x53, 0x9a, 0x97, 0x7f, 0x34, 0x72, 0x97,
	0xcb, 0x06, 0xfa, 0x65, 0xd9, 0x40, 0xbf, 0x2e, 0x1b, 0xe8, 0xf7, 0x65, 0x03, 0x7d, 0xf7, 0x67,
	0x23, 0xf7, 0x94, 0xd7, 0xe1, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff, 0xef, 0x80, 0x40, 0x72, 0xa2,
	0x06, 0x00, 0x00,
}
