// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: ccl/storageccl/engineccl/enginepbccl/key_registry.proto

/*
	Package enginepbccl is a generated protocol buffer package.

	It is generated from these files:
		ccl/storageccl/engineccl/enginepbccl/key_registry.proto
		ccl/storageccl/engineccl/enginepbccl/stats.proto

	It has these top-level messages:
		DataKeysRegistry
		KeyInfo
		SecretKey
		EncryptionSettings
		EncryptionStatus
*/
package enginepbccl

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"

import sortkeys "github.com/gogo/protobuf/sortkeys"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

type EncryptionType int32

const (
	// No encryption.
	EncryptionType_Plaintext EncryptionType = 0
	// AES in counter mode with various key lengths.
	EncryptionType_AES128_CTR EncryptionType = 1
	EncryptionType_AES192_CTR EncryptionType = 2
	EncryptionType_AES256_CTR EncryptionType = 3
)

var EncryptionType_name = map[int32]string{
	0: "Plaintext",
	1: "AES128_CTR",
	2: "AES192_CTR",
	3: "AES256_CTR",
}
var EncryptionType_value = map[string]int32{
	"Plaintext":  0,
	"AES128_CTR": 1,
	"AES192_CTR": 2,
	"AES256_CTR": 3,
}

func (x EncryptionType) String() string {
	return proto.EnumName(EncryptionType_name, int32(x))
}
func (EncryptionType) EnumDescriptor() ([]byte, []int) { return fileDescriptorKeyRegistry, []int{0} }

// DataKeysRegistry contains all data keys (including the raw key) as well
// as store key information (excluding raw key).
// This is written to disk.
type DataKeysRegistry struct {
	// Map of key_id to KeyInfo (raw key is not included).
	StoreKeys map[string]*KeyInfo `protobuf:"bytes,1,rep,name=store_keys,json=storeKeys" json:"store_keys,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	// Map of key_id to SecretKey (raw key is included).
	DataKeys map[string]*SecretKey `protobuf:"bytes,2,rep,name=data_keys,json=dataKeys" json:"data_keys,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value"`
	// Active key IDs. Empty means no keys loaded yet.
	ActiveStoreKeyId string `protobuf:"bytes,3,opt,name=active_store_key_id,json=activeStoreKeyId,proto3" json:"active_store_key_id,omitempty"`
	ActiveDataKeyId  string `protobuf:"bytes,4,opt,name=active_data_key_id,json=activeDataKeyId,proto3" json:"active_data_key_id,omitempty"`
}

func (m *DataKeysRegistry) Reset()                    { *m = DataKeysRegistry{} }
func (m *DataKeysRegistry) String() string            { return proto.CompactTextString(m) }
func (*DataKeysRegistry) ProtoMessage()               {}
func (*DataKeysRegistry) Descriptor() ([]byte, []int) { return fileDescriptorKeyRegistry, []int{0} }

// KeyInfo contains information about the key, but not the key itself.
// This is safe to pass around, log, and store.
type KeyInfo struct {
	// EncryptionType is the type of encryption (aka: cipher) used with this key.
	EncryptionType EncryptionType `protobuf:"varint,1,opt,name=encryption_type,json=encryptionType,proto3,enum=cockroach.ccl.storageccl.engineccl.enginepbccl.EncryptionType" json:"encryption_type,omitempty"`
	// The ID (hash) of this key.
	KeyId string `protobuf:"bytes,2,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// First time this key was seen (in seconds since epoch).
	CreationTime int64 `protobuf:"varint,3,opt,name=creation_time,json=creationTime,proto3" json:"creation_time,omitempty"`
	// Source is a description of the source. This could be a filename,
	// or the key manager that made the key. eg: "data key manager".
	Source string `protobuf:"bytes,4,opt,name=source,proto3" json:"source,omitempty"`
	// Was exposed is true if we ever wrote the key in plaintext.
	// This does not apply to store keys, only data keys.
	WasExposed bool `protobuf:"varint,5,opt,name=was_exposed,json=wasExposed,proto3" json:"was_exposed,omitempty"`
	// ID of the key that caused this key to be created.
	ParentKeyId string `protobuf:"bytes,6,opt,name=parent_key_id,json=parentKeyId,proto3" json:"parent_key_id,omitempty"`
}

func (m *KeyInfo) Reset()                    { *m = KeyInfo{} }
func (m *KeyInfo) String() string            { return proto.CompactTextString(m) }
func (*KeyInfo) ProtoMessage()               {}
func (*KeyInfo) Descriptor() ([]byte, []int) { return fileDescriptorKeyRegistry, []int{1} }

// SecretKey contains the information about the key AND the raw key itself.
// This should never be logged, displayed, or stored outside of the key registry.
// The name is intended to make users of the key wary of the usage.
type SecretKey struct {
	Info *KeyInfo `protobuf:"bytes,1,opt,name=info" json:"info,omitempty"`
	// The raw key.
	Key []byte `protobuf:"bytes,2,opt,name=key,proto3" json:"key,omitempty"`
}

func (m *SecretKey) Reset()                    { *m = SecretKey{} }
func (m *SecretKey) String() string            { return proto.CompactTextString(m) }
func (*SecretKey) ProtoMessage()               {}
func (*SecretKey) Descriptor() ([]byte, []int) { return fileDescriptorKeyRegistry, []int{2} }

// EncryptionSettings describes the encryption settings for a file.
// This is stored as a protobuf.Any inside the FileEntry as described in:
// pkg/storage/engine/enginepb/file_registry.proto
type EncryptionSettings struct {
	EncryptionType EncryptionType `protobuf:"varint,1,opt,name=encryption_type,json=encryptionType,proto3,enum=cockroach.ccl.storageccl.engineccl.enginepbccl.EncryptionType" json:"encryption_type,omitempty"`
	// Fields for AES-CTR. Empty when encryption_type = Plaintext.
	KeyId string `protobuf:"bytes,2,opt,name=key_id,json=keyId,proto3" json:"key_id,omitempty"`
	// len(nonce) + sizeof(counter) should add up to AES_Blocksize (128 bits).
	Nonce   []byte `protobuf:"bytes,3,opt,name=nonce,proto3" json:"nonce,omitempty"`
	Counter uint32 `protobuf:"varint,4,opt,name=counter,proto3" json:"counter,omitempty"`
}

func (m *EncryptionSettings) Reset()                    { *m = EncryptionSettings{} }
func (m *EncryptionSettings) String() string            { return proto.CompactTextString(m) }
func (*EncryptionSettings) ProtoMessage()               {}
func (*EncryptionSettings) Descriptor() ([]byte, []int) { return fileDescriptorKeyRegistry, []int{3} }

func init() {
	proto.RegisterType((*DataKeysRegistry)(nil), "cockroach.ccl.storageccl.engineccl.enginepbccl.DataKeysRegistry")
	proto.RegisterType((*KeyInfo)(nil), "cockroach.ccl.storageccl.engineccl.enginepbccl.KeyInfo")
	proto.RegisterType((*SecretKey)(nil), "cockroach.ccl.storageccl.engineccl.enginepbccl.SecretKey")
	proto.RegisterType((*EncryptionSettings)(nil), "cockroach.ccl.storageccl.engineccl.enginepbccl.EncryptionSettings")
	proto.RegisterEnum("cockroach.ccl.storageccl.engineccl.enginepbccl.EncryptionType", EncryptionType_name, EncryptionType_value)
}
func (m *DataKeysRegistry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DataKeysRegistry) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.StoreKeys) > 0 {
		keysForStoreKeys := make([]string, 0, len(m.StoreKeys))
		for k := range m.StoreKeys {
			keysForStoreKeys = append(keysForStoreKeys, string(k))
		}
		sortkeys.Strings(keysForStoreKeys)
		for _, k := range keysForStoreKeys {
			dAtA[i] = 0xa
			i++
			v := m.StoreKeys[string(k)]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovKeyRegistry(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovKeyRegistry(uint64(len(k))) + msgSize
			i = encodeVarintKeyRegistry(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintKeyRegistry(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintKeyRegistry(dAtA, i, uint64(v.Size()))
				n1, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n1
			}
		}
	}
	if len(m.DataKeys) > 0 {
		keysForDataKeys := make([]string, 0, len(m.DataKeys))
		for k := range m.DataKeys {
			keysForDataKeys = append(keysForDataKeys, string(k))
		}
		sortkeys.Strings(keysForDataKeys)
		for _, k := range keysForDataKeys {
			dAtA[i] = 0x12
			i++
			v := m.DataKeys[string(k)]
			msgSize := 0
			if v != nil {
				msgSize = v.Size()
				msgSize += 1 + sovKeyRegistry(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovKeyRegistry(uint64(len(k))) + msgSize
			i = encodeVarintKeyRegistry(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintKeyRegistry(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			if v != nil {
				dAtA[i] = 0x12
				i++
				i = encodeVarintKeyRegistry(dAtA, i, uint64(v.Size()))
				n2, err := v.MarshalTo(dAtA[i:])
				if err != nil {
					return 0, err
				}
				i += n2
			}
		}
	}
	if len(m.ActiveStoreKeyId) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintKeyRegistry(dAtA, i, uint64(len(m.ActiveStoreKeyId)))
		i += copy(dAtA[i:], m.ActiveStoreKeyId)
	}
	if len(m.ActiveDataKeyId) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintKeyRegistry(dAtA, i, uint64(len(m.ActiveDataKeyId)))
		i += copy(dAtA[i:], m.ActiveDataKeyId)
	}
	return i, nil
}

func (m *KeyInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *KeyInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.EncryptionType != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintKeyRegistry(dAtA, i, uint64(m.EncryptionType))
	}
	if len(m.KeyId) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintKeyRegistry(dAtA, i, uint64(len(m.KeyId)))
		i += copy(dAtA[i:], m.KeyId)
	}
	if m.CreationTime != 0 {
		dAtA[i] = 0x18
		i++
		i = encodeVarintKeyRegistry(dAtA, i, uint64(m.CreationTime))
	}
	if len(m.Source) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintKeyRegistry(dAtA, i, uint64(len(m.Source)))
		i += copy(dAtA[i:], m.Source)
	}
	if m.WasExposed {
		dAtA[i] = 0x28
		i++
		if m.WasExposed {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if len(m.ParentKeyId) > 0 {
		dAtA[i] = 0x32
		i++
		i = encodeVarintKeyRegistry(dAtA, i, uint64(len(m.ParentKeyId)))
		i += copy(dAtA[i:], m.ParentKeyId)
	}
	return i, nil
}

func (m *SecretKey) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SecretKey) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Info != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintKeyRegistry(dAtA, i, uint64(m.Info.Size()))
		n3, err := m.Info.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if len(m.Key) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintKeyRegistry(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	return i, nil
}

func (m *EncryptionSettings) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EncryptionSettings) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.EncryptionType != 0 {
		dAtA[i] = 0x8
		i++
		i = encodeVarintKeyRegistry(dAtA, i, uint64(m.EncryptionType))
	}
	if len(m.KeyId) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintKeyRegistry(dAtA, i, uint64(len(m.KeyId)))
		i += copy(dAtA[i:], m.KeyId)
	}
	if len(m.Nonce) > 0 {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintKeyRegistry(dAtA, i, uint64(len(m.Nonce)))
		i += copy(dAtA[i:], m.Nonce)
	}
	if m.Counter != 0 {
		dAtA[i] = 0x20
		i++
		i = encodeVarintKeyRegistry(dAtA, i, uint64(m.Counter))
	}
	return i, nil
}

func encodeVarintKeyRegistry(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *DataKeysRegistry) Size() (n int) {
	var l int
	_ = l
	if len(m.StoreKeys) > 0 {
		for k, v := range m.StoreKeys {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovKeyRegistry(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovKeyRegistry(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovKeyRegistry(uint64(mapEntrySize))
		}
	}
	if len(m.DataKeys) > 0 {
		for k, v := range m.DataKeys {
			_ = k
			_ = v
			l = 0
			if v != nil {
				l = v.Size()
				l += 1 + sovKeyRegistry(uint64(l))
			}
			mapEntrySize := 1 + len(k) + sovKeyRegistry(uint64(len(k))) + l
			n += mapEntrySize + 1 + sovKeyRegistry(uint64(mapEntrySize))
		}
	}
	l = len(m.ActiveStoreKeyId)
	if l > 0 {
		n += 1 + l + sovKeyRegistry(uint64(l))
	}
	l = len(m.ActiveDataKeyId)
	if l > 0 {
		n += 1 + l + sovKeyRegistry(uint64(l))
	}
	return n
}

func (m *KeyInfo) Size() (n int) {
	var l int
	_ = l
	if m.EncryptionType != 0 {
		n += 1 + sovKeyRegistry(uint64(m.EncryptionType))
	}
	l = len(m.KeyId)
	if l > 0 {
		n += 1 + l + sovKeyRegistry(uint64(l))
	}
	if m.CreationTime != 0 {
		n += 1 + sovKeyRegistry(uint64(m.CreationTime))
	}
	l = len(m.Source)
	if l > 0 {
		n += 1 + l + sovKeyRegistry(uint64(l))
	}
	if m.WasExposed {
		n += 2
	}
	l = len(m.ParentKeyId)
	if l > 0 {
		n += 1 + l + sovKeyRegistry(uint64(l))
	}
	return n
}

func (m *SecretKey) Size() (n int) {
	var l int
	_ = l
	if m.Info != nil {
		l = m.Info.Size()
		n += 1 + l + sovKeyRegistry(uint64(l))
	}
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovKeyRegistry(uint64(l))
	}
	return n
}

func (m *EncryptionSettings) Size() (n int) {
	var l int
	_ = l
	if m.EncryptionType != 0 {
		n += 1 + sovKeyRegistry(uint64(m.EncryptionType))
	}
	l = len(m.KeyId)
	if l > 0 {
		n += 1 + l + sovKeyRegistry(uint64(l))
	}
	l = len(m.Nonce)
	if l > 0 {
		n += 1 + l + sovKeyRegistry(uint64(l))
	}
	if m.Counter != 0 {
		n += 1 + sovKeyRegistry(uint64(m.Counter))
	}
	return n
}

func sovKeyRegistry(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozKeyRegistry(x uint64) (n int) {
	return sovKeyRegistry(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *DataKeysRegistry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKeyRegistry
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DataKeysRegistry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DataKeysRegistry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreKeys", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKeyRegistry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKeyRegistry
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StoreKeys == nil {
				m.StoreKeys = make(map[string]*KeyInfo)
			}
			var mapkey string
			var mapvalue *KeyInfo
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowKeyRegistry
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowKeyRegistry
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthKeyRegistry
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowKeyRegistry
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthKeyRegistry
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthKeyRegistry
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &KeyInfo{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipKeyRegistry(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthKeyRegistry
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.StoreKeys[mapkey] = mapvalue
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataKeys", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKeyRegistry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKeyRegistry
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DataKeys == nil {
				m.DataKeys = make(map[string]*SecretKey)
			}
			var mapkey string
			var mapvalue *SecretKey
			for iNdEx < postIndex {
				entryPreIndex := iNdEx
				var wire uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowKeyRegistry
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					wire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				fieldNum := int32(wire >> 3)
				if fieldNum == 1 {
					var stringLenmapkey uint64
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowKeyRegistry
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						stringLenmapkey |= (uint64(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					intStringLenmapkey := int(stringLenmapkey)
					if intStringLenmapkey < 0 {
						return ErrInvalidLengthKeyRegistry
					}
					postStringIndexmapkey := iNdEx + intStringLenmapkey
					if postStringIndexmapkey > l {
						return io.ErrUnexpectedEOF
					}
					mapkey = string(dAtA[iNdEx:postStringIndexmapkey])
					iNdEx = postStringIndexmapkey
				} else if fieldNum == 2 {
					var mapmsglen int
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowKeyRegistry
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						mapmsglen |= (int(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					if mapmsglen < 0 {
						return ErrInvalidLengthKeyRegistry
					}
					postmsgIndex := iNdEx + mapmsglen
					if mapmsglen < 0 {
						return ErrInvalidLengthKeyRegistry
					}
					if postmsgIndex > l {
						return io.ErrUnexpectedEOF
					}
					mapvalue = &SecretKey{}
					if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
						return err
					}
					iNdEx = postmsgIndex
				} else {
					iNdEx = entryPreIndex
					skippy, err := skipKeyRegistry(dAtA[iNdEx:])
					if err != nil {
						return err
					}
					if skippy < 0 {
						return ErrInvalidLengthKeyRegistry
					}
					if (iNdEx + skippy) > postIndex {
						return io.ErrUnexpectedEOF
					}
					iNdEx += skippy
				}
			}
			m.DataKeys[mapkey] = mapvalue
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActiveStoreKeyId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKeyRegistry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKeyRegistry
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ActiveStoreKeyId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActiveDataKeyId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKeyRegistry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKeyRegistry
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ActiveDataKeyId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKeyRegistry(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthKeyRegistry
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *KeyInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKeyRegistry
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: KeyInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: KeyInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EncryptionType", wireType)
			}
			m.EncryptionType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKeyRegistry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EncryptionType |= (EncryptionType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKeyRegistry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKeyRegistry
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.KeyId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field CreationTime", wireType)
			}
			m.CreationTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKeyRegistry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.CreationTime |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Source", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKeyRegistry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKeyRegistry
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Source = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WasExposed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKeyRegistry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.WasExposed = bool(v != 0)
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentKeyId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKeyRegistry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKeyRegistry
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ParentKeyId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKeyRegistry(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthKeyRegistry
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SecretKey) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKeyRegistry
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SecretKey: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SecretKey: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Info", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKeyRegistry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthKeyRegistry
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Info == nil {
				m.Info = &KeyInfo{}
			}
			if err := m.Info.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKeyRegistry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKeyRegistry
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipKeyRegistry(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthKeyRegistry
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EncryptionSettings) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowKeyRegistry
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EncryptionSettings: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EncryptionSettings: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field EncryptionType", wireType)
			}
			m.EncryptionType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKeyRegistry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.EncryptionType |= (EncryptionType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyId", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKeyRegistry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthKeyRegistry
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.KeyId = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nonce", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKeyRegistry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthKeyRegistry
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Nonce = append(m.Nonce[:0], dAtA[iNdEx:postIndex]...)
			if m.Nonce == nil {
				m.Nonce = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Counter", wireType)
			}
			m.Counter = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowKeyRegistry
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Counter |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipKeyRegistry(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthKeyRegistry
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipKeyRegistry(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowKeyRegistry
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowKeyRegistry
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowKeyRegistry
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthKeyRegistry
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowKeyRegistry
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipKeyRegistry(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthKeyRegistry = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowKeyRegistry   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("ccl/storageccl/engineccl/enginepbccl/key_registry.proto", fileDescriptorKeyRegistry)
}

var fileDescriptorKeyRegistry = []byte{
	// 585 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x94, 0xcf, 0x6e, 0xd3, 0x40,
	0x10, 0xc6, 0xbb, 0x49, 0x93, 0x36, 0x93, 0x26, 0x8d, 0x96, 0x82, 0xa2, 0x1e, 0x4c, 0x14, 0x84,
	0x14, 0x81, 0x70, 0x85, 0x11, 0xb4, 0xe5, 0x80, 0xc4, 0x9f, 0x1c, 0xaa, 0x0a, 0x8a, 0x9c, 0x9e,
	0xb8, 0x58, 0xdb, 0xf5, 0xd4, 0x18, 0xa7, 0xbb, 0xd6, 0x7a, 0xd3, 0xd6, 0xcf, 0xc0, 0x85, 0xe7,
	0xe1, 0xcc, 0xa1, 0x47, 0x8e, 0x1c, 0x21, 0xbc, 0x08, 0xf2, 0xda, 0x4e, 0x13, 0xc4, 0x25, 0xea,
	0x81, 0xdb, 0x7c, 0xe3, 0xdd, 0xef, 0xb7, 0x33, 0x5f, 0x14, 0xd8, 0xe5, 0x7c, 0xbc, 0x93, 0x68,
	0xa9, 0x58, 0x80, 0x59, 0x89, 0x22, 0x08, 0xc5, 0x5c, 0x15, 0x9f, 0x64, 0x75, 0x84, 0xa9, 0xa7,
	0x30, 0x08, 0x13, 0xad, 0x52, 0x3b, 0x56, 0x52, 0x4b, 0x6a, 0x73, 0xc9, 0x23, 0x25, 0x19, 0xff,
	0x68, 0x73, 0x3e, 0xb6, 0xaf, 0x2d, 0xec, 0x99, 0x85, 0x3d, 0x67, 0xb1, 0xbd, 0x15, 0xc8, 0x40,
	0x9a, 0xab, 0x3b, 0x59, 0x95, 0xbb, 0xf4, 0xbf, 0xae, 0x42, 0xe7, 0x0d, 0xd3, 0xec, 0x10, 0xd3,
	0xc4, 0x2d, 0x00, 0x54, 0x00, 0x64, 0x76, 0xe8, 0x45, 0x98, 0x26, 0x5d, 0xd2, 0xab, 0x0e, 0x9a,
	0xce, 0xd1, 0x92, 0x3c, 0xfb, 0x6f, 0x57, 0x7b, 0x94, 0x59, 0x66, 0x9d, 0xa1, 0xd0, 0x2a, 0x75,
	0x1b, 0x49, 0xa9, 0x69, 0x04, 0x0d, 0x9f, 0x69, 0x96, 0xe3, 0x2a, 0x06, 0xf7, 0xee, 0xc6, 0xb8,
	0xb2, 0x91, 0xd3, 0xd6, 0xfd, 0x42, 0xd2, 0x47, 0x70, 0x8b, 0x71, 0x1d, 0x9e, 0xa3, 0x37, 0x9b,
	0xd1, 0x0b, 0xfd, 0x6e, 0xb5, 0x47, 0x06, 0x0d, 0xb7, 0x93, 0x7f, 0x2a, 0x9f, 0x7a, 0xe0, 0xd3,
	0x87, 0x40, 0x8b, 0xe3, 0xe5, 0x13, 0xb3, 0xd3, 0xab, 0xe6, 0xf4, 0x66, 0xfe, 0xa5, 0x20, 0x1d,
	0xf8, 0xdb, 0x13, 0x68, 0x2f, 0x4e, 0x49, 0x3b, 0x50, 0x8d, 0x30, 0xed, 0x12, 0x73, 0x3e, 0x2b,
	0xe9, 0x5b, 0xa8, 0x9d, 0xb3, 0xf1, 0x04, 0xbb, 0x95, 0x1e, 0x19, 0x34, 0x9d, 0xdd, 0x65, 0x07,
	0xcd, 0x48, 0xe2, 0x54, 0xba, 0xb9, 0xcb, 0xf3, 0xca, 0x1e, 0xd9, 0x3e, 0x87, 0xd6, 0xc2, 0xb4,
	0xff, 0xa0, 0x1e, 0x2d, 0x52, 0xf7, 0x97, 0xa5, 0x8e, 0x90, 0x2b, 0xd4, 0x87, 0x98, 0xce, 0x71,
	0xfb, 0x9f, 0x2b, 0xb0, 0x56, 0x3c, 0x87, 0x06, 0xb0, 0x89, 0x82, 0xab, 0x34, 0xd6, 0xa1, 0x14,
	0x9e, 0x4e, 0x63, 0x34, 0xf8, 0xb6, 0xf3, 0x62, 0x59, 0xd4, 0x70, 0x66, 0x73, 0x9c, 0xc6, 0xe8,
	0xb6, 0x71, 0x41, 0xd3, 0xdb, 0x50, 0x2f, 0x42, 0xa8, 0x98, 0xf1, 0x6a, 0x91, 0xc9, 0xe9, 0x1e,
	0xb4, 0xb8, 0x42, 0x96, 0xd3, 0xc3, 0x33, 0x34, 0x81, 0x56, 0xdd, 0x8d, 0xb2, 0x79, 0x1c, 0x9e,
	0x21, 0xbd, 0x03, 0xf5, 0x44, 0x4e, 0x14, 0xc7, 0x22, 0xc0, 0x42, 0xd1, 0xbb, 0xd0, 0xbc, 0x60,
	0x89, 0x87, 0x97, 0xb1, 0x4c, 0xd0, 0xef, 0xd6, 0x7a, 0x64, 0xb0, 0xee, 0xc2, 0x05, 0x4b, 0x86,
	0x79, 0x87, 0xf6, 0xa1, 0x15, 0x33, 0x85, 0x42, 0x97, 0x3f, 0x80, 0xba, 0xb9, 0xdf, 0xcc, 0x9b,
	0x26, 0xfc, 0xfe, 0x27, 0x68, 0xcc, 0xb6, 0x44, 0x0f, 0x61, 0x35, 0x14, 0xa7, 0xd2, 0xec, 0xe0,
	0x06, 0x21, 0x1b, 0x93, 0x32, 0xce, 0x6c, 0xde, 0x0d, 0x13, 0x67, 0xff, 0x1b, 0x01, 0x7a, 0xbd,
	0xa7, 0x11, 0x6a, 0x1d, 0x8a, 0x20, 0xf9, 0xef, 0x21, 0x6c, 0x41, 0x4d, 0x48, 0xc1, 0xf3, 0xe5,
	0x6f, 0xb8, 0xb9, 0xa0, 0x5d, 0x58, 0xe3, 0x72, 0x22, 0x34, 0x2a, 0xb3, 0xf6, 0x96, 0x5b, 0xca,
	0x07, 0x47, 0xd0, 0x5e, 0x04, 0xd1, 0x16, 0x34, 0xde, 0x8f, 0x59, 0x28, 0x34, 0x5e, 0xea, 0xce,
	0x0a, 0x6d, 0x03, 0xbc, 0x1c, 0x8e, 0x1e, 0x3b, 0x7b, 0xde, 0xeb, 0x63, 0xb7, 0x43, 0x4a, 0xbd,
	0xef, 0x18, 0x5d, 0x29, 0xb4, 0xf3, 0xf4, 0x99, 0xd1, 0xd5, 0x57, 0xf7, 0xaf, 0x7e, 0x59, 0x2b,
	0x57, 0x53, 0x8b, 0x7c, 0x9f, 0x5a, 0xe4, 0xc7, 0xd4, 0x22, 0x3f, 0xa7, 0x16, 0xf9, 0xf2, 0xdb,
	0x5a, 0xf9, 0xd0, 0x9c, 0x9b, 0xee, 0xa4, 0x6e, 0xfe, 0xfc, 0x9e, 0xfc, 0x09, 0x00, 0x00, 0xff,
	0xff, 0xe0, 0x3c, 0xd1, 0x34, 0x7d, 0x05, 0x00, 0x00,
}
