#include "defs.h"
#include <stdio.h>
#include "printtext.h"
#include "imageio.h"
#include "scale.h"
#include "arglist.h"
#ifdef USE_CLUSTER
#include "cluster.h"
#endif

void printerrorstring(char* title,char *errormessage) {

   if (errormessage!=NULL) fprintf(stderr,"%s: Error: %s!\n\n",title,errormessage);
   fprintf(stderr,"This program will create a greyscale image being\n   a rescaled version of the source!\n   Destination size will default to the source size,\n   but can be altered with --width and --height.\n   Also you can specify old and new coordinates of\n   4 reference points within the image,\n   (top-left, top-right, bottom-left, bottom-right )\n   which default to the edges if not given.\n\n");
   fprintf(stderr,"Usage: %s [ -x <value> | --width=<value> ] \\\n        [-y <value> | --height=<value> ] \\\n        [ --sourcecoords <x1 y1 x2 y2 x3 y3 x4 y4> ] \\\n        [ --destcoords <x1 y1 x2 y2 x3 y3 x4 y4> ] \\\n        <source1> [<destination>] \\\n",title);
#ifdef USE_CLUSTER
   fprintf(stderr,"        [ -j <threads> ] \\\n");
#endif
   fprintf(stderr,"        [--help] [-h]\n\n",title);
}

int main (int argc, char *argv[]) {
   ImagePtr imsource, imdest;	/*Working images*/
   int width,height;		/*The destination size*/
   int x11,x21,x12,x22,x13,x23,x14,x24; /*coords*/
   int y11,y21,y12,y22,y13,y23,y14,y24;
   int answer;			/*return value*/
   char* valuechar;             /*option for value*/
   struct arglist* carglist;	/*commandline options*/
#ifdef USE_CLUSTER
   int threads;			/*number of threads*/
#endif

   carglist = arglist_new(argc, argv);
   arglist_addarg (carglist,"--help",0);
   arglist_addarg (carglist,"-h",0);
   arglist_addarg (carglist,"-x",1);
   arglist_addarg (carglist,"--width",1);
   arglist_addarg (carglist,"-y",1);
   arglist_addarg (carglist,"--height",1);
   arglist_addarg (carglist,"--sourcecoords",8);
   arglist_addarg (carglist,"--destcoords",8);
   arglist_addarg (carglist,"-j",1);

   printwelcomestring();

   if ((arglist_arggiven(carglist,"--help")==0) || (arglist_arggiven(carglist,"-h")==0)) {
      printerrorstring(argv[0],NULL);
      printusagestring();
      return -1;
   }

   if ((arglist_parameter(carglist,"VOIDARGS",2)!=NULL) || (arglist_parameter(carglist,"VOIDARGS",0)==NULL)){
      printerrorstring(argv[0],"Error parsing commandline");
      printusagestring();
      return -1;
   }
   /*Check parameter count*/

#ifdef USE_CLUSTER
   threads=DEFAULT_THREADS;
   if (arglist_arggiven(carglist,"-j")==0) {
      threads=arglist_integer(arglist_parameter(carglist,"-j",0));
   }
   if (threads<1) {
      printerrorstring(argv[0],"Error parsing commandline,\nprocess amount <threads> has to be greater 0.");
      printusagestring();
      return -1;
   }
   /*Check process count */

   cluster_setpnum(threads);
#endif

   imsource=loadim(arglist_parameter(carglist,"VOIDARGS",0));
   if (imsource==NULL) {
      printerrorstring(argv[0],"Error loading source image 1");
      printusagestring();
      return -1;
   }
   /*Load Sourcefile*/


   if ((arglist_arggiven(carglist,"--width")==0) || (arglist_arggiven(carglist,"-x")==0)) {
      valuechar=arglist_parameter(carglist,"-x",0);
      if (valuechar==NULL) {
         valuechar=arglist_parameter(carglist,"--width",0);
      }
      width=arglist_integer(valuechar);
      if (width<=0) {
         printerrorstring(argv[0],"Error parsing commandline,\n<width> has to be any positive interger");
         printusagestring();
	 width=widthim(imsource);
      }
   } else {
      width=widthim(imsource);
   }

   if ((arglist_arggiven(carglist,"--height")==0) || (arglist_arggiven(carglist,"-y")==0)) {
      valuechar=arglist_parameter(carglist,"-y",0);
      if (valuechar==NULL) {
         valuechar=arglist_parameter(carglist,"--height",0);
      }
      height=arglist_integer(valuechar);
      if (width<=0) {
         printerrorstring(argv[0],"Error parsing commandline,\n<height> has to be any positive interger");
         printusagestring();
         height=heightim(imsource);
      }
   } else {
      height=heightim(imsource);
   }

   if (arglist_arggiven(carglist,"--sourcecoords")==0) {
      x11=arglist_integer(arglist_parameter(carglist,"--sourcecoords",0));
      y11=arglist_integer(arglist_parameter(carglist,"--sourcecoords",1));
      x12=arglist_integer(arglist_parameter(carglist,"--sourcecoords",2));
      y12=arglist_integer(arglist_parameter(carglist,"--sourcecoords",3));
      x13=arglist_integer(arglist_parameter(carglist,"--sourcecoords",4));
      y13=arglist_integer(arglist_parameter(carglist,"--sourcecoords",5));
      x14=arglist_integer(arglist_parameter(carglist,"--sourcecoords",6));
      y14=arglist_integer(arglist_parameter(carglist,"--sourcecoords",7));
   } else {
      x11=0;
      y11=0;
      x12=widthim(imsource);
      y12=0;
      x13=0;
      y13=heightim(imsource);
      x14=x12;
      y14=y13;
   }

   if (arglist_arggiven(carglist,"--destcoords")==0) {
      x21=arglist_integer(arglist_parameter(carglist,"--destcoords",0));
      y21=arglist_integer(arglist_parameter(carglist,"--destcoords",1));
      x22=arglist_integer(arglist_parameter(carglist,"--destcoords",2));
      y22=arglist_integer(arglist_parameter(carglist,"--destcoords",3));
      x23=arglist_integer(arglist_parameter(carglist,"--destcoords",4));
      y23=arglist_integer(arglist_parameter(carglist,"--destcoords",5));
      x24=arglist_integer(arglist_parameter(carglist,"--destcoords",6));
      y24=arglist_integer(arglist_parameter(carglist,"--destcoords",7));
   } else {
      x21=0;
      y21=0;
      x22=width;
      y22=0;
      x23=0;
      y23=height;
      x24=x22;
      y24=y23;
   }

   answer=scale(&imdest,imsource,width,height,x11,y11,x12,y12,x13,y13,x14,y14,x21,y21,x22,y22,x23,y23,x24,y24);
   /*Do the main work in scale.h*/

   if (arglist_parameter(carglist,"VOIDARGS",1)!=NULL) {
      if (saveim(imdest,arglist_parameter(carglist,"VOIDARGS",1))!=0) {
         printerrorstring(argv[0],"Error saving destination image");
      }
      /*Save the resulting image*/
   }

   destroyim(imsource);
   destroyim(imdest);
   /*We free our memory*/

   fprintf(stderr,"Total amount of scale data is:\n");
   fprintf(stdout,"%i\n",answer);
   
   arglist_kill(carglist);
   /*i forgot to kill the commandline argument list*/

   return 0;

}
