/* imageio: basic image functions*/

typedef void* ImagePtr;
/*an Image pointer*/

ImagePtr loadim(char* filename);
/*Loads an Image*/
/*Returns ImagePtr to image structure if succesfull and NULL if not*/

int saveim(ImagePtr im, char* filename);
/*Saves the Image in a file*/
/*Returns null if sucessfull and -1 if not*/

inline ImagePtr createim(int width, int height);
/*Creates an Image*/
/*Returns ImagePtr to image structure if succesfull and NULL if not*/

inline int destroyim (ImagePtr im);
/*Frees image memory*/

inline int widthim(ImagePtr im);
/*Returns the images X width*/

inline int heightim(ImagePtr im);
/*Returns the images Y height*/

inline int collorallocateim(ImagePtr im,int r,int g,int b);
/*Allocates a color structure*/
/*Returns an ID integer of this*/

inline int pixelbrightcim(int r, int g, int b);
/*Gives back the corresponding pixelbrightness*/
/*of color r g b*/

inline int pixelbrightim(ImagePtr im,int x,int y);
/*Gives back the pixelbrightness at x,y in im*/
/*Gives back 0 if error (x,y out of range or so)*/

inline int pixelredim(ImagePtr im,int x,int y);
/*Gives back the pixelredness at x,y in im*/
/*Gives back 0 if error (x,y out of range or so)*/

inline int pixelgreenim(ImagePtr im,int x,int y);
/*Gives back the pixelgreenness at x,y in im*/
/*Gives back 0 if error (x,y out of range or so)*/

inline int pixelblueim(ImagePtr im,int x,int y);
/*Gives back the pixelblueness at x,y in im*/
/*Gives back 0 if error (x,y out of range or so)*/

inline int drawpixelim(ImagePtr im,int x,int y,int color);
/*Draws a Pixel into im*/
/*0 if OK, -1 if failed*/

#ifdef USE_CLUSTER
#ifdef USE_SPEEDHACK
inline int processsyncim(ImagePtr *ima,int spread);
/*when working multithreaded, sync image data to pid 0
  spread is the amount used to calculate split_min / max
  when creating the image (important if != image width) */
#else
#error you cannot compile cluster support withoud speedhack, sorry
#endif
#endif



