#include "defs.h"
#include <stdio.h>
#include "imageio.h"
#include "imagemath.h"
#include "sectorlist.h"
#ifdef USE_DEBUG
#include "time.h"
#endif
#ifdef USE_CLUSTER
#include "cluster.h"
#endif

struct sectorlist* checkmove(ImagePtr *dest, ImagePtr imsource, int deltabright, int sectorsize, int method) {
/*Returns a list of overbrighted sectors in source,
  and paints this sectors into a destination image
  a sector is overbrighted when more than 20% over
  the average sector brightness + deltabright if
  method is 0, and when >deltabright if method is 1
  */
   ImagePtr imdest;		/*Pointer to the dest-image*/
   struct sectorlist* answer;	/*Sectorlist to return*/
   int t,tt,actual,avg;		/*Several integers*/
   int x,y;
   int color[256];		/*Colormap*/

#ifdef USE_DEBUG
   clock_t starttime;
   starttime=clock();
   fprintf(stderr,"Running movement check with threshold %i and sectorsize %i, method %i ...\n",deltabright,sectorsize,method);
#endif

   imdest = createim(widthim(imsource),heightim(imsource));
   *dest=imdest;
   /*We create a destination image the size of the source*/
   /*and give its adress back*/

   t=0;
   while (t<256) {
      color[t]=collorallocateim(imdest,t,t,t);
      t++;
   }
   /*We create some sort of 256 colors b/w colormap for the destination*/

   x=xsectorsim(imdest,sectorsize);
   y=ysectorsim(imdest,sectorsize);
   tt=0;
   avg=0;
   #ifdef USE_CLUSTER
      cluster_split();
      /*time to split up the work */
      tt=cluster_split_min(0,y);
      y=cluster_split_max(0,y);
      #ifdef USE_DEBUG
         fprintf(stderr,"process(%i): doing from %i till %i ...\n",pid(),tt,y);
      #endif
   #endif
   while (tt<y) {
      t=0;
      while (t<x) {
	 actual=scalepixelim(imsource,t*sectorsize*256,tt*sectorsize*256,
	    (t+1)*sectorsize*256,(tt+1)*sectorsize*256);
	 drawsectorim (imdest,t,tt,color[actual],sectorsize,0);
	 avg+=actual;
	 t++;
      }
      tt++;
   }
#ifdef USE_CLUSTER
   avg=cluster_sync_add(avg);
   y=ysectorsim(imdest,sectorsize);
   processsyncim(imdest,y);
   cluster_regroup();
   /*re combine execution*/
#endif
   avg=avg/(x*y);
   /*Ok The important stuff, part 1
     This is the first times, going over every 10x10 pixel sector and adding its average brightness to sum
     then we divide the overall sum through the sector count to get the average sector brightness*/

   /*Now comes the new 0.0.2 part:
     We create an object of type sectorlist, and save all overbrighted sectors there!*/
   answer=sectorlist_new();

   tt=0;
   while (tt<y) {
      t=0;
      while (t<x) {
         actual=pixelbrightim(imdest,t*sectorsize,tt*sectorsize);
         if ((method==0 && actual>(((120*avg)/100)+deltabright)) ||
	    (method==1 && actual>deltabright)) {
	    sectorlist_addsector(answer,t,tt,actual);
	    drawsectorim (imdest,t,tt,color[255],sectorsize,1);
	 }
         t++;
      }
      tt++;
   }
   /*Important stuff, part 2
     Now, we go through the sectors again, comparing each sector to the average
     If a sector is more than deltabright + the average we are most likely
     to have movement in this sector. So we store that sector in a list.
     The "average" somehow represents the background cripple created by our camera.
     It should be almost the same in every sector. being deltabright+20% brighter this enlightened sector
     is definitely strange, and should be counted as possible movement
     TODO: make this 2nd part multi process able by
     writing a combination wrapper for the resulting sectorlist
   */

#ifdef USE_DEBUG
   fprintf(stderr," ... took  %.4f seconds!\n",(1.0 * (clock() - starttime) / CLOCKS_PER_SEC));
#endif
   return answer;
   /*We give back the sectorlist!*/
}


