#![no_std]

#[derive(Debug)]
pub struct UnknownLocale;

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod POSIX {
    pub mod LC_MESSAGES {
        /// `"^[nN]"`
        pub const NOEXPR: &str = "^[nN]";
        /// `"No"`
        pub const NOSTR: &str = "No";
        /// `"^[yY]"`
        pub const YESEXPR: &str = "^[yY]";
        /// `"Yes"`
        pub const YESSTR: &str = "Yes";
    }
    pub mod LC_MONETARY {
        /// `""`
        pub const CURRENCY_SYMBOL: &str = "";
        /// `-1`
        pub const FRAC_DIGITS: i64 = -1;
        /// `""`
        pub const INT_CURR_SYMBOL: &str = "";
        /// `-1`
        pub const INT_FRAC_DIGITS: i64 = -1;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `-1`
        pub const MON_GROUPING: i64 = -1;
        /// `""`
        pub const MON_THOUSANDS_SEP: &str = "";
        /// `-1`
        pub const N_CS_PRECEDES: i64 = -1;
        /// `-1`
        pub const N_SEP_BY_SPACE: i64 = -1;
        /// `-1`
        pub const N_SIGN_POSN: i64 = -1;
        /// `""`
        pub const NEGATIVE_SIGN: &str = "";
        /// `-1`
        pub const P_CS_PRECEDES: i64 = -1;
        /// `-1`
        pub const P_SEP_BY_SPACE: i64 = -1;
        /// `-1`
        pub const P_SIGN_POSN: i64 = -1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `-1`
        pub const GROUPING: i64 = -1;
        /// `""`
        pub const THOUSANDS_SEP: &str = "";
    }
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `"%m/%d/%y"`
        pub const D_FMT: &str = "%m/%d/%y";
        /// `"%a %b %e\n %H:%M\n:%S %Y"`
        pub const D_T_FMT: &str = "%a %b %e\n %H:%M\n:%S %Y";
        /// `"%a %b %e %H:%M:%S %Z %Y"`
        pub const DATE_FMT: &str = "%a %b %e %H:%M:%S %Z %Y";
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%H:%M:%S"`
        pub const T_FMT: &str = "%H:%M:%S";
        /// `"%I:%M:%S\n %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S\n %p";
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod aa_DJ {
    pub mod LC_ADDRESS {
        /// `"DJ"`
        pub const COUNTRY_ABTWO: &str = "DJ";
        /// `"DJI"`
        pub const COUNTRY_AB3: &str = "DJI";
        /// `"DJI"`
        pub const COUNTRY_CAR: &str = "DJI";
        /// `"Yabuuti"`
        pub const COUNTRY_NAME: &str = "Yabuuti";
        /// `262`
        pub const COUNTRY_NUM: i64 = 262;
        /// `"DJI"`
        pub const COUNTRY_POST: &str = "DJI";
        /// `"aa"`
        pub const LANG_AB: &str = "aa";
        /// `"aar"`
        pub const LANG_LIB: &str = "aar";
        /// `"Qafar"`
        pub const LANG_NAME: &str = "Qafar";
        /// `"aar"`
        pub const LANG_TERM: &str = "aar";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"7802 Solomon Seal Dr., Springfield, VA 22152, USA"`
        pub const ADDRESS: &str = "7802 Solomon Seal Dr., Springfield, VA 22152, USA";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_TIME"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_TIME"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2003-07-05"`
        pub const DATE: &str = "2003-07-05";
        /// `"locales@geez.org"`
        pub const EMAIL: &str = "locales@geez.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Afar"`
        pub const LANGUAGE: &str = "Afar";
        /// `"0.20"`
        pub const REVISION: &str = "0.20";
        /// `"Ge\'ez Frontier Foundation"`
        pub const SOURCE: &str = "Ge\'ez Frontier Foundation";
        /// `""`
        pub const TEL: &str = "";
        /// `"Djibouti"`
        pub const TERRITORY: &str = "Djibouti";
        /// `"Afar language locale for Djibouti (Cadu/Laaqo Dialects)."`
        pub const TITLE: &str = "Afar language locale for Djibouti (Cadu/Laaqo Dialects).";
    }
    pub use super::aa_ET::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"Fdj"`
        pub const CURRENCY_SYMBOL: &str = "Fdj";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"DJF "`
        pub const INT_CURR_SYMBOL: &str = "DJF ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[0, 0]`
        pub const GROUPING: &[i64] = &[0, 0];
        /// `""`
        pub const THOUSANDS_SEP: &str = "";
    }
    pub mod LC_TELEPHONE {
        /// `"253"`
        pub const INT_PREFIX: &str = "253";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"%a-%l"`
        pub const TEL_DOM_FMT: &str = "%a-%l";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["Aca", "Etl", "Tal", "Arb", "Kam", "Gum", "Sab"]`
        pub const ABDAY: &[&str] = &["Aca", "Etl", "Tal", "Arb", "Kam", "Gum", "Sab"];
        /// `&["Qun", "Nah", "Cig", "Agd", "Cax", "Qas", "Qad", "Leq", "Way", "Dit", "Xim", "Kax"]`
        pub const ABMON: &[&str] = &["Qun", "Nah", "Cig", "Agd", "Cax", "Qas", "Qad", "Leq", "Way", "Dit", "Xim", "Kax"];
        /// `&["saaku", "carra"]`
        pub const AM_PM: &[&str] = &["saaku", "carra"];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %d %b %Y %r %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %r %Z";
        /// `"%a %b %e %r %Z %Y"`
        pub const DATE_FMT: &str = "%a %b %e %r %Z %Y";
        /// `&["Acaada", "Etleeni", "Talaata", "Arbaqa", "Kamiisi", "Gumqata", "Sabti"]`
        pub const DAY: &[&str] = &["Acaada", "Etleeni", "Talaata", "Arbaqa", "Kamiisi", "Gumqata", "Sabti"];
        /// `7`
        pub const FIRST_WEEKDAY: i64 = 7;
        /// `&["Qunxa Garablu", "Naharsi Kudo", "Ciggilta Kudo", "Agda Baxis", "Caxah Alsa", "Qasa Dirri", "Qado Dirri", "Leqeeni", "Waysu", "Diteli", "Ximoli", "Kaxxa Garablu"]`
        pub const MON: &[&str] = &["Qunxa Garablu", "Naharsi Kudo", "Ciggilta Kudo", "Agda Baxis", "Caxah Alsa", "Qasa Dirri", "Qado Dirri", "Leqeeni", "Waysu", "Diteli", "Ximoli", "Kaxxa Garablu"];
        /// `"%l:%M:%S %p"`
        pub const T_FMT: &str = "%l:%M:%S %p";
        /// `"%l:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%l:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod aa_ER {
    pub mod LC_ADDRESS {
        /// `"ER"`
        pub const COUNTRY_ABTWO: &str = "ER";
        /// `"ERI"`
        pub const COUNTRY_AB3: &str = "ERI";
        /// `"ER"`
        pub const COUNTRY_CAR: &str = "ER";
        /// `"Eretria"`
        pub const COUNTRY_NAME: &str = "Eretria";
        /// `232`
        pub const COUNTRY_NUM: i64 = 232;
        /// `"ERI"`
        pub const COUNTRY_POST: &str = "ERI";
        /// `"aa"`
        pub const LANG_AB: &str = "aa";
        /// `"aar"`
        pub const LANG_LIB: &str = "aar";
        /// `"Qafar"`
        pub const LANG_NAME: &str = "Qafar";
        /// `"aar"`
        pub const LANG_TERM: &str = "aar";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"7802 Solomon Seal Dr., Springfield, VA 22152, USA"`
        pub const ADDRESS: &str = "7802 Solomon Seal Dr., Springfield, VA 22152, USA";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_TIME"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_TIME"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2003-07-05"`
        pub const DATE: &str = "2003-07-05";
        /// `"locales@geez.org"`
        pub const EMAIL: &str = "locales@geez.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Afar"`
        pub const LANGUAGE: &str = "Afar";
        /// `"0.20"`
        pub const REVISION: &str = "0.20";
        /// `"Ge\'ez Frontier Foundation"`
        pub const SOURCE: &str = "Ge\'ez Frontier Foundation";
        /// `""`
        pub const TEL: &str = "";
        /// `"Eritrea"`
        pub const TERRITORY: &str = "Eritrea";
        /// `"Afar language locale for Eritrea (Cadu/Laaqo Dialects)."`
        pub const TITLE: &str = "Afar language locale for Eritrea (Cadu/Laaqo Dialects).";
    }
    pub use super::aa_ET::LC_MESSAGES;
    pub use super::ti_ER::LC_MONETARY;
    pub use super::ti_ER::LC_NUMERIC;
    pub use super::ti_ER::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Aca", "Etl", "Tal", "Arb", "Kam", "Gum", "Sab"]`
        pub const ABDAY: &[&str] = &["Aca", "Etl", "Tal", "Arb", "Kam", "Gum", "Sab"];
        /// `&["Qun", "Nah", "Cig", "Agd", "Cax", "Qas", "Qad", "Leq", "Way", "Dit", "Xim", "Kax"]`
        pub const ABMON: &[&str] = &["Qun", "Nah", "Cig", "Agd", "Cax", "Qas", "Qad", "Leq", "Way", "Dit", "Xim", "Kax"];
        /// `&["saaku", "carra"]`
        pub const AM_PM: &[&str] = &["saaku", "carra"];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%A, %B %e, %Y %r %Z"`
        pub const D_T_FMT: &str = "%A, %B %e, %Y %r %Z";
        /// `"%A, %B %e, %r %Z %Y"`
        pub const DATE_FMT: &str = "%A, %B %e, %r %Z %Y";
        /// `&["Acaada", "Etleeni", "Talaata", "Arbaqa", "Kamiisi", "Gumqata", "Sabti"]`
        pub const DAY: &[&str] = &["Acaada", "Etleeni", "Talaata", "Arbaqa", "Kamiisi", "Gumqata", "Sabti"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["Qunxa Garablu", "Naharsi Kudo", "Ciggilta Kudo", "Agda Baxis", "Caxah Alsa", "Qasa Dirri", "Qado Dirri", "Liiqen", "Waysu", "Diteli", "Ximoli", "Kaxxa Garablu"]`
        pub const MON: &[&str] = &["Qunxa Garablu", "Naharsi Kudo", "Ciggilta Kudo", "Agda Baxis", "Caxah Alsa", "Qasa Dirri", "Qado Dirri", "Liiqen", "Waysu", "Diteli", "Ximoli", "Kaxxa Garablu"];
        /// `"%l:%M:%S %p"`
        pub const T_FMT: &str = "%l:%M:%S %p";
        /// `"%l:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%l:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod aa_ER_saaho {
    pub use super::aa_ER::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `"7802 Solomon Seal Dr., Springfield, VA 22152, USA"`
        pub const ADDRESS: &str = "7802 Solomon Seal Dr., Springfield, VA 22152, USA";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_TIME"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_TIME"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2003-07-05"`
        pub const DATE: &str = "2003-07-05";
        /// `"locales@geez.org"`
        pub const EMAIL: &str = "locales@geez.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Afar"`
        pub const LANGUAGE: &str = "Afar";
        /// `"0.20"`
        pub const REVISION: &str = "0.20";
        /// `"Ge\'ez Frontier Foundation"`
        pub const SOURCE: &str = "Ge\'ez Frontier Foundation";
        /// `""`
        pub const TEL: &str = "";
        /// `"Eritrea"`
        pub const TERRITORY: &str = "Eritrea";
        /// `"Afar language locale for Eritrea (Saaho Dialect)."`
        pub const TITLE: &str = "Afar language locale for Eritrea (Saaho Dialect).";
    }
    pub use super::aa_ET::LC_MESSAGES;
    pub use super::aa_ER::LC_MONETARY;
    pub use super::aa_ER::LC_NUMERIC;
    pub use super::aa_ER::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Nab", "San", "Sal", "Rab", "Cam", "Jum", "Qun"]`
        pub const ABDAY: &[&str] = &["Nab", "San", "Sal", "Rab", "Cam", "Jum", "Qun"];
        /// `&["Qun", "Nah", "Cig", "Agd", "Cax", "Qas", "Qad", "Leq", "Way", "Dit", "Xim", "Kax"]`
        pub const ABMON: &[&str] = &["Qun", "Nah", "Cig", "Agd", "Cax", "Qas", "Qad", "Leq", "Way", "Dit", "Xim", "Kax"];
        /// `&["saaku", "carra"]`
        pub const AM_PM: &[&str] = &["saaku", "carra"];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%A, %B %e, %Y %r %Z"`
        pub const D_T_FMT: &str = "%A, %B %e, %Y %r %Z";
        /// `"%A, %B %e, %r %Z %Y"`
        pub const DATE_FMT: &str = "%A, %B %e, %r %Z %Y";
        /// `&["Naba Sambat", "Sani", "Salus", "Rabuq", "Camus", "Jumqata", "Qunxa Sambat"]`
        pub const DAY: &[&str] = &["Naba Sambat", "Sani", "Salus", "Rabuq", "Camus", "Jumqata", "Qunxa Sambat"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["Qunxa Garablu", "Naharsi Kudo", "Ciggilta Kudo", "Agda Baxis", "Caxah Alsa", "Qasa Dirri", "Qado Dirri", "Liiqen", "Waysu", "Diteli", "Ximoli", "Kaxxa Garablu"]`
        pub const MON: &[&str] = &["Qunxa Garablu", "Naharsi Kudo", "Ciggilta Kudo", "Agda Baxis", "Caxah Alsa", "Qasa Dirri", "Qado Dirri", "Liiqen", "Waysu", "Diteli", "Ximoli", "Kaxxa Garablu"];
        /// `"%l:%M:%S %p"`
        pub const T_FMT: &str = "%l:%M:%S %p";
        /// `"%l:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%l:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod aa_ET {
    pub mod LC_ADDRESS {
        /// `"ET"`
        pub const COUNTRY_ABTWO: &str = "ET";
        /// `"ETH"`
        pub const COUNTRY_AB3: &str = "ETH";
        /// `"ETH"`
        pub const COUNTRY_CAR: &str = "ETH";
        /// `"Otobbia"`
        pub const COUNTRY_NAME: &str = "Otobbia";
        /// `231`
        pub const COUNTRY_NUM: i64 = 231;
        /// `"ETH"`
        pub const COUNTRY_POST: &str = "ETH";
        /// `"aa"`
        pub const LANG_AB: &str = "aa";
        /// `"aar"`
        pub const LANG_LIB: &str = "aar";
        /// `"Qafar"`
        pub const LANG_NAME: &str = "Qafar";
        /// `"aar"`
        pub const LANG_TERM: &str = "aar";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"7802 Solomon Seal Dr., Springfield, VA 22152, USA"`
        pub const ADDRESS: &str = "7802 Solomon Seal Dr., Springfield, VA 22152, USA";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_TIME"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_TIME"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2003-07-05"`
        pub const DATE: &str = "2003-07-05";
        /// `"locales@geez.org"`
        pub const EMAIL: &str = "locales@geez.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Afar"`
        pub const LANGUAGE: &str = "Afar";
        /// `"0.20"`
        pub const REVISION: &str = "0.20";
        /// `"Ge\'ez Frontier Foundation"`
        pub const SOURCE: &str = "Ge\'ez Frontier Foundation";
        /// `""`
        pub const TEL: &str = "";
        /// `"Ethiopia"`
        pub const TERRITORY: &str = "Ethiopia";
        /// `"Afar language locale for Ethiopia (Cadu/Carra Dialects)."`
        pub const TITLE: &str = "Afar language locale for Ethiopia (Cadu/Carra Dialects).";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0mnMN]"`
        pub const NOEXPR: &str = "^[-0mnMN]";
        /// `"Maleey"`
        pub const NOSTR: &str = "Maleey";
        /// `"^[+1yY]"`
        pub const YESEXPR: &str = "^[+1yY]";
        /// `"Yeey"`
        pub const YESSTR: &str = "Yeey";
    }
    pub use super::ti_ET::LC_MONETARY;
    pub use super::ti_ET::LC_NUMERIC;
    pub use super::ti_ET::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Aca", "Etl", "Tal", "Arb", "Kam", "Gum", "Sab"]`
        pub const ABDAY: &[&str] = &["Aca", "Etl", "Tal", "Arb", "Kam", "Gum", "Sab"];
        /// `&["Qun", "Nah", "Cig", "Agd", "Cax", "Qas", "Qad", "Leq", "Way", "Dit", "Xim", "Kax"]`
        pub const ABMON: &[&str] = &["Qun", "Nah", "Cig", "Agd", "Cax", "Qas", "Qad", "Leq", "Way", "Dit", "Xim", "Kax"];
        /// `&["saaku", "carra"]`
        pub const AM_PM: &[&str] = &["saaku", "carra"];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%A, %B %e, %Y %r %Z"`
        pub const D_T_FMT: &str = "%A, %B %e, %Y %r %Z";
        /// `"%A, %B %e, %r %Z %Y"`
        pub const DATE_FMT: &str = "%A, %B %e, %r %Z %Y";
        /// `&["Acaada", "Etleeni", "Talaata", "Arbaqa", "Kamiisi", "Gumqata", "Sabti"]`
        pub const DAY: &[&str] = &["Acaada", "Etleeni", "Talaata", "Arbaqa", "Kamiisi", "Gumqata", "Sabti"];
        /// `&["Qunxa Garablu", "Naharsi Kudo", "Ciggilta Kudo", "Agda Baxis", "Caxah Alsa", "Qasa Dirri", "Qado Dirri", "Liiqen", "Waysu", "Diteli", "Ximoli", "Kaxxa Garablu"]`
        pub const MON: &[&str] = &["Qunxa Garablu", "Naharsi Kudo", "Ciggilta Kudo", "Agda Baxis", "Caxah Alsa", "Qasa Dirri", "Qado Dirri", "Liiqen", "Waysu", "Diteli", "Ximoli", "Kaxxa Garablu"];
        /// `"%l:%M:%S %p"`
        pub const T_FMT: &str = "%l:%M:%S %p";
        /// `"%l:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%l:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod af_ZA {
    pub mod LC_ADDRESS {
        /// `"ZA"`
        pub const COUNTRY_ABTWO: &str = "ZA";
        /// `"ZAF"`
        pub const COUNTRY_AB3: &str = "ZAF";
        /// `"ZA"`
        pub const COUNTRY_CAR: &str = "ZA";
        /// `0`
        pub const COUNTRY_ISBN: i64 = 0;
        /// `"Suid-Afrika"`
        pub const COUNTRY_NAME: &str = "Suid-Afrika";
        /// `710`
        pub const COUNTRY_NUM: i64 = 710;
        /// `"ZA"`
        pub const COUNTRY_POST: &str = "ZA";
        /// `"af"`
        pub const LANG_AB: &str = "af";
        /// `"afr"`
        pub const LANG_LIB: &str = "afr";
        /// `"Afrikaans"`
        pub const LANG_NAME: &str = "Afrikaans";
        /// `"afr"`
        pub const LANG_TERM: &str = "afr";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Box 28364, Sunnyside, 0132, South Africa"`
        pub const ADDRESS: &str = "Box 28364, Sunnyside, 0132, South Africa";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `"Dwayne Bailey"`
        pub const CONTACT: &str = "Dwayne Bailey";
        /// `"2005-10-13"`
        pub const DATE: &str = "2005-10-13";
        /// `"dwayne@translate.org.za"`
        pub const EMAIL: &str = "dwayne@translate.org.za";
        /// `""`
        pub const FAX: &str = "";
        /// `"Afrikaans"`
        pub const LANGUAGE: &str = "Afrikaans";
        /// `"1.2.1"`
        pub const REVISION: &str = "1.2.1";
        /// `"Zuza Software Foundation (Translate.org.za)"`
        pub const SOURCE: &str = "Zuza Software Foundation (Translate.org.za)";
        /// `""`
        pub const TEL: &str = "";
        /// `"South Africa"`
        pub const TERRITORY: &str = "South Africa";
        /// `"Afrikaans locale for South Africa"`
        pub const TITLE: &str = "Afrikaans locale for South Africa";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"nee"`
        pub const NOSTR: &str = "nee";
        /// `"^[+1jJyY]"`
        pub const YESEXPR: &str = "^[+1jJyY]";
        /// `"ja"`
        pub const YESSTR: &str = "ja";
    }
    pub use super::en_ZA::LC_MONETARY;
    pub use super::en_ZA::LC_NUMERIC;
    pub use super::en_ZA::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["So", "Ma", "Di", "Wo", "Do", "Vr", "Sa"]`
        pub const ABDAY: &[&str] = &["So", "Ma", "Di", "Wo", "Do", "Vr", "Sa"];
        /// `&["Jan", "Feb", "Mrt", "Apr", "Mei", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Des"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mrt", "Apr", "Mei", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Des"];
        /// `&["VM", "NM"]`
        pub const AM_PM: &[&str] = &["VM", "NM"];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["Sondag", "Maandag", "Dinsdag", "Woensdag", "Donderdag", "Vrydag", "Saterdag"]`
        pub const DAY: &[&str] = &["Sondag", "Maandag", "Dinsdag", "Woensdag", "Donderdag", "Vrydag", "Saterdag"];
        /// `&["Januarie", "Februarie", "Maart", "April", "Mei", "Junie", "Julie", "Augustus", "September", "Oktober", "November", "Desember"]`
        pub const MON: &[&str] = &["Januarie", "Februarie", "Maart", "April", "Mei", "Junie", "Julie", "Augustus", "September", "Oktober", "November", "Desember"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod agr_PE {
    pub mod LC_ADDRESS {
        /// `"PE"`
        pub const COUNTRY_ABTWO: &str = "PE";
        /// `"PER"`
        pub const COUNTRY_AB3: &str = "PER";
        /// `"PE"`
        pub const COUNTRY_CAR: &str = "PE";
        /// `"Perú"`
        pub const COUNTRY_NAME: &str = "Perú";
        /// `604`
        pub const COUNTRY_NUM: i64 = 604;
        /// `""`
        pub const LANG_AB: &str = "";
        /// `"agr"`
        pub const LANG_LIB: &str = "agr";
        /// `"Awajún"`
        pub const LANG_NAME: &str = "Awajún";
        /// `""`
        pub const LANG_TERM: &str = "";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2016-08-20"`
        pub const DATE: &str = "2016-08-20";
        /// `"libc-alpha@sourceware.org"`
        pub const EMAIL: &str = "libc-alpha@sourceware.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Aguaruna"`
        pub const LANGUAGE: &str = "Aguaruna";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"somosazucar.org"`
        pub const SOURCE: &str = "somosazucar.org";
        /// `""`
        pub const TEL: &str = "";
        /// `"Peru"`
        pub const TERRITORY: &str = "Peru";
        /// `"Awajún (agr) locale for Peru"`
        pub const TITLE: &str = "Awajún (agr) locale for Peru";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0aAnN]"`
        pub const NOEXPR: &str = "^[-0aAnN]";
        /// `"atsa"`
        pub const NOSTR: &str = "atsa";
        /// `"^[+1eEsSyY]"`
        pub const YESEXPR: &str = "^[+1eEsSyY]";
        /// `"ehe"`
        pub const YESSTR: &str = "ehe";
    }
    pub use super::es_PE::LC_MONETARY;
    pub use super::es_PE::LC_NUMERIC;
    pub use super::es_PE::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Tun", "Ach", "Kug", "Sak", "Shim", "Im", "Bat"]`
        pub const ABDAY: &[&str] = &["Tun", "Ach", "Kug", "Sak", "Shim", "Im", "Bat"];
        /// `&["Pet", "Kup", "Uya", "Tay", "Keg", "Teg", "Kun", "Yag", "Dait", "Ipam", "Shin", "Sak"]`
        pub const ABMON: &[&str] = &["Pet", "Kup", "Uya", "Tay", "Keg", "Teg", "Kun", "Yag", "Dait", "Ipam", "Shin", "Sak"];
        /// `&["VM", "NM"]`
        pub const AM_PM: &[&str] = &["VM", "NM"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `"%a %b %e %H:%M:%S %Z %Y"`
        pub const DATE_FMT: &str = "%a %b %e %H:%M:%S %Z %Y";
        /// `&["Tuntuamtin", "Achutin", "Kugkuktin", "Saketin", "Shimpitin", "Imaptin", "Bataetin"]`
        pub const DAY: &[&str] = &["Tuntuamtin", "Achutin", "Kugkuktin", "Saketin", "Shimpitin", "Imaptin", "Bataetin"];
        /// `1`
        pub const FIRST_WEEKDAY: i64 = 1;
        /// `2`
        pub const FIRST_WORKDAY: i64 = 2;
        /// `&["Petsatin", "Kupitin", "Uyaitin", "Tayutin", "Kegketin", "Tegmatin", "Kuntutin", "Yagkujutin", "Daiktatin", "Ipamtatin", "Shinutin", "Sakamtin"]`
        pub const MON: &[&str] = &["Petsatin", "Kupitin", "Uyaitin", "Tayutin", "Kegketin", "Tegmatin", "Kuntutin", "Yagkujutin", "Daiktatin", "Ipamtatin", "Shinutin", "Sakamtin"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `&[7, 19971130, 7]`
        pub const WEEK: &[i64] = &[7, 19971130, 7];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ak_GH {
    pub mod LC_ADDRESS {
        /// `"GH"`
        pub const COUNTRY_ABTWO: &str = "GH";
        /// `"GHA"`
        pub const COUNTRY_AB3: &str = "GHA";
        /// `"GH"`
        pub const COUNTRY_CAR: &str = "GH";
        /// `9964`
        pub const COUNTRY_ISBN: i64 = 9964;
        /// `"Gaana"`
        pub const COUNTRY_NAME: &str = "Gaana";
        /// `288`
        pub const COUNTRY_NUM: i64 = 288;
        /// `"GH"`
        pub const COUNTRY_POST: &str = "GH";
        /// `"ak"`
        pub const LANG_AB: &str = "ak";
        /// `"Akan"`
        pub const LANG_NAME: &str = "Akan";
        /// `"aka"`
        pub const LANG_TERM: &str = "aka";
        /// `"%a%N%f%N%d%N%b%N%h %s %e %r%N%T, %S %z%N%c%N"`
        pub const POSTAL_FMT: &str = "%a%N%f%N%d%N%b%N%h %s %e %r%N%T, %S %z%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ];
        /// `"sugarlabs.org"`
        pub const CONTACT: &str = "sugarlabs.org";
        /// `"2013-08-24"`
        pub const DATE: &str = "2013-08-24";
        /// `"libc-alpha@sourceware.org"`
        pub const EMAIL: &str = "libc-alpha@sourceware.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Akan"`
        pub const LANGUAGE: &str = "Akan";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Sugar Labs / OLPC"`
        pub const SOURCE: &str = "Sugar Labs / OLPC";
        /// `""`
        pub const TEL: &str = "";
        /// `"Ghana"`
        pub const TERRITORY: &str = "Ghana";
        /// `"Akan locale for Ghana"`
        pub const TITLE: &str = "Akan locale for Ghana";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0dDnN]"`
        pub const NOEXPR: &str = "^[-0dDnN]";
        /// `"Daabi"`
        pub const NOSTR: &str = "Daabi";
        /// `"^[+1yY]"`
        pub const YESEXPR: &str = "^[+1yY]";
        /// `"Yiw"`
        pub const YESSTR: &str = "Yiw";
    }
    pub mod LC_MONETARY {
        /// `"GH₵"`
        pub const CURRENCY_SYMBOL: &str = "GH₵";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"GHS "`
        pub const INT_CURR_SYMBOL: &str = "GHS ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"233"`
        pub const INT_PREFIX: &str = "233";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"%a %l"`
        pub const TEL_DOM_FMT: &str = "%a %l";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["Kwe", "Dwo", "Ben", "Wuk", "Yaw", "Fia", "Mem"]`
        pub const ABDAY: &[&str] = &["Kwe", "Dwo", "Ben", "Wuk", "Yaw", "Fia", "Mem"];
        /// `&["S-Ɔ", "K-Ɔ", "E-Ɔ", "E-O", "E-K", "O-A", "A-K", "D-Ɔ", "F-Ɛ", "Ɔ-A", "Ɔ-O", "M-Ɔ"]`
        pub const ABMON: &[&str] = &["S-Ɔ", "K-Ɔ", "E-Ɔ", "E-O", "E-K", "O-A", "A-K", "D-Ɔ", "F-Ɛ", "Ɔ-A", "Ɔ-O", "M-Ɔ"];
        /// `&["AN", "EW"]`
        pub const AM_PM: &[&str] = &["AN", "EW"];
        /// `"%Y/%m/%d"`
        pub const D_FMT: &str = "%Y/%m/%d";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["Kwesida", "Dwowda", "Benada", "Wukuda", "Yawda", "Fida", "Memeneda"]`
        pub const DAY: &[&str] = &["Kwesida", "Dwowda", "Benada", "Wukuda", "Yawda", "Fida", "Memeneda"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["Sanda-Ɔpɛpɔn", "Kwakwar-Ɔgyefuo", "Ebɔw-Ɔbenem", "Ebɔbira-Oforisuo", "Esusow Aketseaba-Kɔtɔnimba", "Obirade-Ayɛwohomumu", "Ayɛwoho-Kitawonsa", "Difuu-Ɔsandaa", "Fankwa-Ɛbɔ", "Ɔbɛsɛ-Ahinime", "Ɔberɛfɛw-Obubuo", "Mumu-Ɔpɛnimba"]`
        pub const MON: &[&str] = &["Sanda-Ɔpɛpɔn", "Kwakwar-Ɔgyefuo", "Ebɔw-Ɔbenem", "Ebɔbira-Oforisuo", "Esusow Aketseaba-Kɔtɔnimba", "Obirade-Ayɛwohomumu", "Ayɛwoho-Kitawonsa", "Difuu-Ɔsandaa", "Fankwa-Ɛbɔ", "Ɔbɛsɛ-Ahinime", "Ɔberɛfɛw-Obubuo", "Mumu-Ɔpɛnimba"];
        /// `"%r"`
        pub const T_FMT: &str = "%r";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod am_ET {
    pub mod LC_ADDRESS {
        /// `"ET"`
        pub const COUNTRY_ABTWO: &str = "ET";
        /// `"ETH"`
        pub const COUNTRY_AB3: &str = "ETH";
        /// `"ETH"`
        pub const COUNTRY_CAR: &str = "ETH";
        /// `"ኢትዮጵያ"`
        pub const COUNTRY_NAME: &str = "ኢትዮጵያ";
        /// `231`
        pub const COUNTRY_NUM: i64 = 231;
        /// `"ETH"`
        pub const COUNTRY_POST: &str = "ETH";
        /// `"am"`
        pub const LANG_AB: &str = "am";
        /// `"amh"`
        pub const LANG_LIB: &str = "amh";
        /// `"አማርኛ"`
        pub const LANG_NAME: &str = "አማርኛ";
        /// `"amh"`
        pub const LANG_TERM: &str = "amh";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"7802 Solomon Seal Dr., Springfield, VA 22152, USA"`
        pub const ADDRESS: &str = "7802 Solomon Seal Dr., Springfield, VA 22152, USA";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_TIME"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_TIME"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2003-07-05"`
        pub const DATE: &str = "2003-07-05";
        /// `"locales@geez.org"`
        pub const EMAIL: &str = "locales@geez.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Amharic"`
        pub const LANGUAGE: &str = "Amharic";
        /// `"0.20"`
        pub const REVISION: &str = "0.20";
        /// `"Ge\'ez Frontier Foundation"`
        pub const SOURCE: &str = "Ge\'ez Frontier Foundation";
        /// `""`
        pub const TEL: &str = "";
        /// `"Ethiopia"`
        pub const TERRITORY: &str = "Ethiopia";
        /// `"Amharic language locale for Ethiopia."`
        pub const TITLE: &str = "Amharic language locale for Ethiopia.";
    }
    pub mod LC_MESSAGES {
        /// `"^([-0nNይ]|አይ)"`
        pub const NOEXPR: &str = "^([-0nNይ]|አይ)";
        /// `"አይ"`
        pub const NOSTR: &str = "አይ";
        /// `"^([+1yYዎ]|አዎን)"`
        pub const YESEXPR: &str = "^([+1yYዎ]|አዎን)";
        /// `"አዎን"`
        pub const YESSTR: &str = "አዎን";
    }
    pub use super::ti_ET::LC_MONETARY;
    pub use super::ti_ET::LC_NUMERIC;
    pub use super::ti_ET::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["እሑድ", "ሰኞ ", "ማክሰ", "ረቡዕ", "ሐሙስ", "ዓርብ", "ቅዳሜ"]`
        pub const ABDAY: &[&str] = &["እሑድ", "ሰኞ ", "ማክሰ", "ረቡዕ", "ሐሙስ", "ዓርብ", "ቅዳሜ"];
        /// `&["ጃንዩ", "ፌብሩ", "ማርች", "ኤፕረ", "ሜይ ", "ጁን ", "ጁላይ", "ኦገስ", "ሴፕቴ", "ኦክተ", "ኖቬም", "ዲሴም"]`
        pub const ABMON: &[&str] = &["ጃንዩ", "ፌብሩ", "ማርች", "ኤፕረ", "ሜይ ", "ጁን ", "ጁላይ", "ኦገስ", "ሴፕቴ", "ኦክተ", "ኖቬም", "ዲሴም"];
        /// `&["ጡዋት", "ከሰዓት"]`
        pub const AM_PM: &[&str] = &["ጡዋት", "ከሰዓት"];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%A፣ %B %e ቀን %Y %r %Z"`
        pub const D_T_FMT: &str = "%A፣ %B %e ቀን %Y %r %Z";
        /// `"%A፣ %B %e ቀን %r %Z %Y ዓ/ም"`
        pub const DATE_FMT: &str = "%A፣ %B %e ቀን %r %Z %Y ዓ/ም";
        /// `&["እሑድ", "ሰኞ", "ማክሰኞ", "ረቡዕ", "ሐሙስ", "ዓርብ", "ቅዳሜ"]`
        pub const DAY: &[&str] = &["እሑድ", "ሰኞ", "ማክሰኞ", "ረቡዕ", "ሐሙስ", "ዓርብ", "ቅዳሜ"];
        /// `&["ጃንዩወሪ", "ፌብሩወሪ", "ማርች", "ኤፕሪል", "ሜይ", "ጁን", "ጁላይ", "ኦገስት", "ሴፕቴምበር", "ኦክቶበር", "ኖቬምበር", "ዲሴምበር"]`
        pub const MON: &[&str] = &["ጃንዩወሪ", "ፌብሩወሪ", "ማርች", "ኤፕሪል", "ሜይ", "ጁን", "ጁላይ", "ኦገስት", "ሴፕቴምበር", "ኦክቶበር", "ኖቬምበር", "ዲሴምበር"];
        /// `"%l:%M:%S %p"`
        pub const T_FMT: &str = "%l:%M:%S %p";
        /// `"%l:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%l:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod an_ES {
    pub mod LC_ADDRESS {
        /// `"ES"`
        pub const COUNTRY_ABTWO: &str = "ES";
        /// `"ESP"`
        pub const COUNTRY_AB3: &str = "ESP";
        /// `"E"`
        pub const COUNTRY_CAR: &str = "E";
        /// `"978-84"`
        pub const COUNTRY_ISBN: &str = "978-84";
        /// `"Espanya"`
        pub const COUNTRY_NAME: &str = "Espanya";
        /// `724`
        pub const COUNTRY_NUM: i64 = 724;
        /// `"E"`
        pub const COUNTRY_POST: &str = "E";
        /// `"an"`
        pub const LANG_AB: &str = "an";
        /// `"arg"`
        pub const LANG_LIB: &str = "arg";
        /// `"aragonés"`
        pub const LANG_NAME: &str = "aragonés";
        /// `"arg"`
        pub const LANG_TERM: &str = "arg";
        /// `"%a%N%f%N%d%N%b%N%s %h %e %r%N%z %T, %S%N%c%N"`
        pub const POSTAL_FMT: &str = "%a%N%f%N%d%N%b%N%s %h %e %r%N%z %T, %S%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `"Jordi Mallach Pérez, Juan Pablo Martínez"`
        pub const CONTACT: &str = "Jordi Mallach Pérez, Juan Pablo Martínez";
        /// `"2018-02-05"`
        pub const DATE: &str = "2018-02-05";
        /// `"bug-glibc-locales@gnu.org, softaragones@softaragones.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org, softaragones@softaragones.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Aragonese"`
        pub const LANGUAGE: &str = "Aragonese";
        /// `"1.2"`
        pub const REVISION: &str = "1.2";
        /// `"Softaragones"`
        pub const SOURCE: &str = "Softaragones";
        /// `""`
        pub const TEL: &str = "";
        /// `"Spain"`
        pub const TERRITORY: &str = "Spain";
        /// `"Aragonese locale for Spain"`
        pub const TITLE: &str = "Aragonese locale for Spain";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"no"`
        pub const NOSTR: &str = "no";
        /// `"^[+1sSyY]"`
        pub const YESEXPR: &str = "^[+1sSyY]";
        /// `"sí"`
        pub const YESSTR: &str = "sí";
    }
    pub use super::es_ES::LC_MONETARY;
    pub use super::es_ES::LC_NUMERIC;
    pub use super::es_ES::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mie", "chu", "vie", "sab"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mie", "chu", "vie", "sab"];
        /// `&["chi", "feb", "mar", "abr", "may", "chn", "chl", "ago", "set", "oct", "nov", "avi"]`
        pub const ABMON: &[&str] = &["chi", "feb", "mar", "abr", "may", "chn", "chl", "ago", "set", "oct", "nov", "avi"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["domingo", "luns", "martes", "mierques", "chueves", "viernes", "sabado"]`
        pub const DAY: &[&str] = &["domingo", "luns", "martes", "mierques", "chueves", "viernes", "sabado"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["chinero", "febrero", "marzo", "abril", "mayo", "chunyo", "chuliol", "agosto", "setiembre", "octubre", "noviembre", "aviento"]`
        pub const MON: &[&str] = &["chinero", "febrero", "marzo", "abril", "mayo", "chunyo", "chuliol", "agosto", "setiembre", "octubre", "noviembre", "aviento"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod anp_IN {
    pub mod LC_ADDRESS {
        /// `"IN"`
        pub const COUNTRY_ABTWO: &str = "IN";
        /// `"IND"`
        pub const COUNTRY_AB3: &str = "IND";
        /// `"IND"`
        pub const COUNTRY_CAR: &str = "IND";
        /// `"भारत"`
        pub const COUNTRY_NAME: &str = "भारत";
        /// `356`
        pub const COUNTRY_NUM: i64 = 356;
        /// `"anp"`
        pub const LANG_LIB: &str = "anp";
        /// `"अ\u{902}गिका"`
        pub const LANG_NAME: &str = "अ\u{902}गिका";
        /// `"anp"`
        pub const LANG_TERM: &str = "anp";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2013-10-24"`
        pub const DATE: &str = "2013-10-24";
        /// `"bhashaghar@googlegroups.com"`
        pub const EMAIL: &str = "bhashaghar@googlegroups.com";
        /// `""`
        pub const FAX: &str = "";
        /// `"Angika"`
        pub const LANGUAGE: &str = "Angika";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"India"`
        pub const TERRITORY: &str = "India";
        /// `"Angika language locale for India"`
        pub const TITLE: &str = "Angika language locale for India";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0नइnN]"`
        pub const NOEXPR: &str = "^[-0नइnN]";
        /// `"नही\u{902}"`
        pub const NOSTR: &str = "नही\u{902}";
        /// `"^[+1हवyY]"`
        pub const YESEXPR: &str = "^[+1हवyY]";
        /// `"हा\u{901}"`
        pub const YESSTR: &str = "हा\u{901}";
    }
    pub use super::hi_IN::LC_MONETARY;
    pub use super::hi_IN::LC_NUMERIC;
    pub use super::hi_IN::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["रवि", "सोम", "म\u{902}गल", "ब\u{941}ध", "ब\u{943}हस\u{94d}पति", "श\u{941}क\u{94d}र", "शनि"]`
        pub const ABDAY: &[&str] = &["रवि", "सोम", "म\u{902}गल", "ब\u{941}ध", "ब\u{943}हस\u{94d}पति", "श\u{941}क\u{94d}र", "शनि"];
        /// `&["जनवरी", "फरवरी", "मार\u{94d}च", "अप\u{94d}र\u{948}ल", "मई", "ज\u{942}न", "ज\u{941}लाई", "अगस\u{94d}त", "सित\u{902}बर", "अक\u{94d}ट\u{942}बर", "नव\u{902}बर", "दिस\u{902}बर"]`
        pub const ABMON: &[&str] = &["जनवरी", "फरवरी", "मार\u{94d}च", "अप\u{94d}र\u{948}ल", "मई", "ज\u{942}न", "ज\u{941}लाई", "अगस\u{94d}त", "सित\u{902}बर", "अक\u{94d}ट\u{942}बर", "नव\u{902}बर", "दिस\u{902}बर"];
        /// `&["प\u{942}र\u{94d}वाह\u{94d}न", "अपराह\u{94d}न"]`
        pub const AM_PM: &[&str] = &["प\u{942}र\u{94d}वाह\u{94d}न", "अपराह\u{94d}न"];
        /// `"%-d/%-m/%y"`
        pub const D_FMT: &str = "%-d/%-m/%y";
        /// `"%A %d %b %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A %d %b %Y %I:%M:%S %p %Z";
        /// `&["रविवार", "सोमवार", "म\u{902}गलवार", "ब\u{941}धवार", "ब\u{943}हस\u{94d}पतिवार", "श\u{941}क\u{94d}रवार", "शनिवार"]`
        pub const DAY: &[&str] = &["रविवार", "सोमवार", "म\u{902}गलवार", "ब\u{941}धवार", "ब\u{943}हस\u{94d}पतिवार", "श\u{941}क\u{94d}रवार", "शनिवार"];
        /// `&["जनवरी", "फरवरी", "मार\u{94d}च", "अप\u{94d}र\u{948}ल", "मई", "ज\u{942}न", "ज\u{941}लाई", "अगस\u{94d}त", "सित\u{902}बर", "अक\u{94d}ट\u{942}बर", "नव\u{902}बर", "दिस\u{902}बर"]`
        pub const MON: &[&str] = &["जनवरी", "फरवरी", "मार\u{94d}च", "अप\u{94d}र\u{948}ल", "मई", "ज\u{942}न", "ज\u{941}लाई", "अगस\u{94d}त", "सित\u{902}बर", "अक\u{94d}ट\u{942}बर", "नव\u{902}बर", "दिस\u{902}बर"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_AE {
    pub mod LC_ADDRESS {
        /// `"AE"`
        pub const COUNTRY_ABTWO: &str = "AE";
        /// `"ARE"`
        pub const COUNTRY_AB3: &str = "ARE";
        /// `"UAE"`
        pub const COUNTRY_CAR: &str = "UAE";
        /// `"الإمارات العربية المتحدة"`
        pub const COUNTRY_NAME: &str = "الإمارات العربية المتحدة";
        /// `784`
        pub const COUNTRY_NUM: i64 = 784;
        /// `"ar"`
        pub const LANG_AB: &str = "ar";
        /// `"ara"`
        pub const LANG_LIB: &str = "ara";
        /// `"العربية"`
        pub const LANG_NAME: &str = "العربية";
        /// `"ara"`
        pub const LANG_TERM: &str = "ara";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan"`
        pub const ADDRESS: &str = "1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-07-20"`
        pub const DATE: &str = "2000-07-20";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Arabic"`
        pub const LANGUAGE: &str = "Arabic";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"IBM Globalization Center of Competency, Yamato Software Laboratory"`
        pub const SOURCE: &str = "IBM Globalization Center of Competency, Yamato Software Laboratory";
        /// `""`
        pub const TEL: &str = "";
        /// `"United Arab Emirates"`
        pub const TERRITORY: &str = "United Arab Emirates";
        /// `"Arabic language locale for United Arab Emirates"`
        pub const TITLE: &str = "Arabic language locale for United Arab Emirates";
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"د.إ."`
        pub const CURRENCY_SYMBOL: &str = "د.إ.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"AED "`
        pub const INT_CURR_SYMBOL: &str = "AED ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"971"`
        pub const INT_PREFIX: &str = "971";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c ;%a ;%l"`
        pub const TEL_INT_FMT: &str = "+%c ;%a ;%l";
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"]`
        pub const ABMON: &[&str] = &["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"];
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت "]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت "];
        /// `7`
        pub const FIRST_WEEKDAY: i64 = 7;
        /// `1`
        pub const FIRST_WORKDAY: i64 = 1;
        /// `&["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const MON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_BH {
    pub mod LC_ADDRESS {
        /// `"BH"`
        pub const COUNTRY_ABTWO: &str = "BH";
        /// `"BHR"`
        pub const COUNTRY_AB3: &str = "BHR";
        /// `"BRN"`
        pub const COUNTRY_CAR: &str = "BRN";
        /// `"البحرين"`
        pub const COUNTRY_NAME: &str = "البحرين";
        /// `48`
        pub const COUNTRY_NUM: i64 = 48;
        /// `"ar"`
        pub const LANG_AB: &str = "ar";
        /// `"ara"`
        pub const LANG_LIB: &str = "ara";
        /// `"العربية"`
        pub const LANG_NAME: &str = "العربية";
        /// `"ara"`
        pub const LANG_TERM: &str = "ara";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan"`
        pub const ADDRESS: &str = "1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-07-20"`
        pub const DATE: &str = "2000-07-20";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Arabic"`
        pub const LANGUAGE: &str = "Arabic";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"IBM Globalization Center of Competency, Yamato Software Laboratory"`
        pub const SOURCE: &str = "IBM Globalization Center of Competency, Yamato Software Laboratory";
        /// `""`
        pub const TEL: &str = "";
        /// `"Bahrain"`
        pub const TERRITORY: &str = "Bahrain";
        /// `"Arabic language locale for Bahrain"`
        pub const TITLE: &str = "Arabic language locale for Bahrain";
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"د.ب."`
        pub const CURRENCY_SYMBOL: &str = "د.ب.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"BHD "`
        pub const INT_CURR_SYMBOL: &str = "BHD ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"973"`
        pub const INT_PREFIX: &str = "973";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c ;%a ;%l"`
        pub const TEL_INT_FMT: &str = "+%c ;%a ;%l";
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"]`
        pub const ABMON: &[&str] = &["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"];
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `7`
        pub const FIRST_WEEKDAY: i64 = 7;
        /// `1`
        pub const FIRST_WORKDAY: i64 = 1;
        /// `&["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const MON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_DZ {
    pub mod LC_ADDRESS {
        /// `"DZ"`
        pub const COUNTRY_ABTWO: &str = "DZ";
        /// `"DZA"`
        pub const COUNTRY_AB3: &str = "DZA";
        /// `"DZ"`
        pub const COUNTRY_CAR: &str = "DZ";
        /// `"الجزائر"`
        pub const COUNTRY_NAME: &str = "الجزائر";
        /// `12`
        pub const COUNTRY_NUM: i64 = 12;
        /// `"ar"`
        pub const LANG_AB: &str = "ar";
        /// `"ara"`
        pub const LANG_LIB: &str = "ara";
        /// `"العربية"`
        pub const LANG_NAME: &str = "العربية";
        /// `"ara"`
        pub const LANG_TERM: &str = "ara";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan"`
        pub const ADDRESS: &str = "1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-07-20"`
        pub const DATE: &str = "2000-07-20";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Arabic"`
        pub const LANGUAGE: &str = "Arabic";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"IBM Globalization Center of Competency, Yamato Software Laboratory"`
        pub const SOURCE: &str = "IBM Globalization Center of Competency, Yamato Software Laboratory";
        /// `""`
        pub const TEL: &str = "";
        /// `"Algeria"`
        pub const TERRITORY: &str = "Algeria";
        /// `"Arabic language locale for Algeria"`
        pub const TITLE: &str = "Arabic language locale for Algeria";
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"د.ج."`
        pub const CURRENCY_SYMBOL: &str = "د.ج.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"DZD "`
        pub const INT_CURR_SYMBOL: &str = "DZD ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"213"`
        pub const INT_PREFIX: &str = "213";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c ;%a ;%l"`
        pub const TEL_INT_FMT: &str = "+%c ;%a ;%l";
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["جانفي", "فيفري", "مارس", "أفريل", "ماي", "جوان", "جويلية", "أوت", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const ABMON: &[&str] = &["جانفي", "فيفري", "مارس", "أفريل", "ماي", "جوان", "جويلية", "أوت", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `7`
        pub const FIRST_WEEKDAY: i64 = 7;
        /// `1`
        pub const FIRST_WORKDAY: i64 = 1;
        /// `&["جانفي", "فيفري", "مارس", "أفريل", "ماي", "جوان", "جويلية", "أوت", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const MON: &[&str] = &["جانفي", "فيفري", "مارس", "أفريل", "ماي", "جوان", "جويلية", "أوت", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_EG {
    pub mod LC_ADDRESS {
        /// `"EG"`
        pub const COUNTRY_ABTWO: &str = "EG";
        /// `"EGY"`
        pub const COUNTRY_AB3: &str = "EGY";
        /// `"ET"`
        pub const COUNTRY_CAR: &str = "ET";
        /// `"مصر"`
        pub const COUNTRY_NAME: &str = "مصر";
        /// `818`
        pub const COUNTRY_NUM: i64 = 818;
        /// `"ar"`
        pub const LANG_AB: &str = "ar";
        /// `"ara"`
        pub const LANG_LIB: &str = "ara";
        /// `"العربية"`
        pub const LANG_NAME: &str = "العربية";
        /// `"ara"`
        pub const LANG_TERM: &str = "ara";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan"`
        pub const ADDRESS: &str = "1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-07-20"`
        pub const DATE: &str = "2000-07-20";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Arabic"`
        pub const LANGUAGE: &str = "Arabic";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"IBM Globalization Center of Competency, Yamato Software Laboratory"`
        pub const SOURCE: &str = "IBM Globalization Center of Competency, Yamato Software Laboratory";
        /// `""`
        pub const TEL: &str = "";
        /// `"Egypt"`
        pub const TERRITORY: &str = "Egypt";
        /// `"Arabic language locale for Egypt"`
        pub const TITLE: &str = "Arabic language locale for Egypt";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0لnN]"`
        pub const NOEXPR: &str = "^[-0لnN]";
        /// `"لا"`
        pub const NOSTR: &str = "لا";
        /// `"^[+1نyY]"`
        pub const YESEXPR: &str = "^[+1نyY]";
        /// `"نعم"`
        pub const YESSTR: &str = "نعم";
    }
    pub mod LC_MONETARY {
        /// `"ج.م."`
        pub const CURRENCY_SYMBOL: &str = "ج.م.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"EGP "`
        pub const INT_CURR_SYMBOL: &str = "EGP ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"20"`
        pub const INT_PREFIX: &str = "20";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c ;%a ;%l"`
        pub const TEL_INT_FMT: &str = "+%c ;%a ;%l";
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"]`
        pub const ABMON: &[&str] = &["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"];
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `7`
        pub const FIRST_WEEKDAY: i64 = 7;
        /// `1`
        pub const FIRST_WORKDAY: i64 = 1;
        /// `&["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const MON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_IN {
    pub mod LC_ADDRESS {
        /// `"IN"`
        pub const COUNTRY_ABTWO: &str = "IN";
        /// `"IND"`
        pub const COUNTRY_AB3: &str = "IND";
        /// `"IND"`
        pub const COUNTRY_CAR: &str = "IND";
        /// `"الهند"`
        pub const COUNTRY_NAME: &str = "الهند";
        /// `356`
        pub const COUNTRY_NUM: i64 = 356;
        /// `"ar"`
        pub const LANG_AB: &str = "ar";
        /// `"ara"`
        pub const LANG_LIB: &str = "ara";
        /// `"العربية"`
        pub const LANG_NAME: &str = "العربية";
        /// `"ara"`
        pub const LANG_TERM: &str = "ara";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan"`
        pub const ADDRESS: &str = "1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000,October,27 (XML source:2000,July,20)"`
        pub const DATE: &str = "2000,October,27 (XML source:2000,July,20)";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Arabic"`
        pub const LANGUAGE: &str = "Arabic";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"IBM Globalization Center of Competency, Yamato Software Laboratory"`
        pub const SOURCE: &str = "IBM Globalization Center of Competency, Yamato Software Laboratory";
        /// `""`
        pub const TEL: &str = "";
        /// `"India"`
        pub const TERRITORY: &str = "India";
        /// `"Arabic language locale for India"`
        pub const TITLE: &str = "Arabic language locale for India";
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub use super::hi_IN::LC_MONETARY;
    pub use super::hi_IN::LC_NUMERIC;
    pub use super::hi_IN::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"]`
        pub const ABMON: &[&str] = &["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"];
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `"%-d/%-m/%y"`
        pub const D_FMT: &str = "%-d/%-m/%y";
        /// `"%A %d %B %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A %d %B %Y %I:%M:%S %p %Z";
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `&["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const MON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_IQ {
    pub mod LC_ADDRESS {
        /// `"IQ"`
        pub const COUNTRY_ABTWO: &str = "IQ";
        /// `"IRQ"`
        pub const COUNTRY_AB3: &str = "IRQ";
        /// `"IRQ"`
        pub const COUNTRY_CAR: &str = "IRQ";
        /// `"العراق"`
        pub const COUNTRY_NAME: &str = "العراق";
        /// `368`
        pub const COUNTRY_NUM: i64 = 368;
        /// `"ar"`
        pub const LANG_AB: &str = "ar";
        /// `"ara"`
        pub const LANG_LIB: &str = "ara";
        /// `"العربية"`
        pub const LANG_NAME: &str = "العربية";
        /// `"ara"`
        pub const LANG_TERM: &str = "ara";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan"`
        pub const ADDRESS: &str = "1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-07-20"`
        pub const DATE: &str = "2000-07-20";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Arabic"`
        pub const LANGUAGE: &str = "Arabic";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"IBM Globalization Center of Competency, Yamato Software Laboratory"`
        pub const SOURCE: &str = "IBM Globalization Center of Competency, Yamato Software Laboratory";
        /// `""`
        pub const TEL: &str = "";
        /// `"Iraq"`
        pub const TERRITORY: &str = "Iraq";
        /// `"Arabic language locale for Iraq"`
        pub const TITLE: &str = "Arabic language locale for Iraq";
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"د.ع."`
        pub const CURRENCY_SYMBOL: &str = "د.ع.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"IQD "`
        pub const INT_CURR_SYMBOL: &str = "IQD ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"964"`
        pub const INT_PREFIX: &str = "964";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c ;%a ;%l"`
        pub const TEL_INT_FMT: &str = "+%c ;%a ;%l";
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"]`
        pub const ABMON: &[&str] = &["كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"];
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `7`
        pub const FIRST_WEEKDAY: i64 = 7;
        /// `1`
        pub const FIRST_WORKDAY: i64 = 1;
        /// `&["كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"]`
        pub const MON: &[&str] = &["كانون الثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين الأول", "تشرين الثاني", "كانون الأول"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_JO {
    pub mod LC_ADDRESS {
        /// `"JO"`
        pub const COUNTRY_ABTWO: &str = "JO";
        /// `"JOR"`
        pub const COUNTRY_AB3: &str = "JOR";
        /// `"HKJ"`
        pub const COUNTRY_CAR: &str = "HKJ";
        /// `"الأردن"`
        pub const COUNTRY_NAME: &str = "الأردن";
        /// `400`
        pub const COUNTRY_NUM: i64 = 400;
        /// `"ar"`
        pub const LANG_AB: &str = "ar";
        /// `"ara"`
        pub const LANG_LIB: &str = "ara";
        /// `"العربية"`
        pub const LANG_NAME: &str = "العربية";
        /// `"ara"`
        pub const LANG_TERM: &str = "ara";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan"`
        pub const ADDRESS: &str = "1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-07-20"`
        pub const DATE: &str = "2000-07-20";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Arabic"`
        pub const LANGUAGE: &str = "Arabic";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"IBM Globalization Center of Competency, Yamato Software Laboratory"`
        pub const SOURCE: &str = "IBM Globalization Center of Competency, Yamato Software Laboratory";
        /// `""`
        pub const TEL: &str = "";
        /// `"Jordan"`
        pub const TERRITORY: &str = "Jordan";
        /// `"Arabic language locale for Jordan"`
        pub const TITLE: &str = "Arabic language locale for Jordan";
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"د.أ."`
        pub const CURRENCY_SYMBOL: &str = "د.أ.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"JOD "`
        pub const INT_CURR_SYMBOL: &str = "JOD ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"962"`
        pub const INT_PREFIX: &str = "962";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c ;%a ;%l"`
        pub const TEL_INT_FMT: &str = "+%c ;%a ;%l";
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["كانون ال\nثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين ال\nأول", "تشرين ال\nثاني", "كانون ال\nأول"]`
        pub const ABMON: &[&str] = &["كانون ال\nثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين ال\nأول", "تشرين ال\nثاني", "كانون ال\nأول"];
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `7`
        pub const FIRST_WEEKDAY: i64 = 7;
        /// `1`
        pub const FIRST_WORKDAY: i64 = 1;
        /// `&["كانون ال\nثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين ال\nأول", "تشرين ال\nثاني", "كانون ال\nأول"]`
        pub const MON: &[&str] = &["كانون ال\nثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين ال\nأول", "تشرين ال\nثاني", "كانون ال\nأول"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_KW {
    pub mod LC_ADDRESS {
        /// `"KW"`
        pub const COUNTRY_ABTWO: &str = "KW";
        /// `"KWT"`
        pub const COUNTRY_AB3: &str = "KWT";
        /// `"KWT"`
        pub const COUNTRY_CAR: &str = "KWT";
        /// `"الكويت"`
        pub const COUNTRY_NAME: &str = "الكويت";
        /// `414`
        pub const COUNTRY_NUM: i64 = 414;
        /// `"ar"`
        pub const LANG_AB: &str = "ar";
        /// `"ara"`
        pub const LANG_LIB: &str = "ara";
        /// `"العربية"`
        pub const LANG_NAME: &str = "العربية";
        /// `"ara"`
        pub const LANG_TERM: &str = "ara";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan"`
        pub const ADDRESS: &str = "1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-07-20"`
        pub const DATE: &str = "2000-07-20";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Arabic"`
        pub const LANGUAGE: &str = "Arabic";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"IBM Globalization Center of Competency, Yamato Software Laboratory"`
        pub const SOURCE: &str = "IBM Globalization Center of Competency, Yamato Software Laboratory";
        /// `""`
        pub const TEL: &str = "";
        /// `"Kuwait"`
        pub const TERRITORY: &str = "Kuwait";
        /// `"Arabic language locale for Kuwait"`
        pub const TITLE: &str = "Arabic language locale for Kuwait";
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"د.ك."`
        pub const CURRENCY_SYMBOL: &str = "د.ك.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"KWD "`
        pub const INT_CURR_SYMBOL: &str = "KWD ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"965"`
        pub const INT_PREFIX: &str = "965";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c ;%a ;%l"`
        pub const TEL_INT_FMT: &str = "+%c ;%a ;%l";
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"]`
        pub const ABMON: &[&str] = &["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"];
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `7`
        pub const FIRST_WEEKDAY: i64 = 7;
        /// `1`
        pub const FIRST_WORKDAY: i64 = 1;
        /// `&["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const MON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_LB {
    pub mod LC_ADDRESS {
        /// `"LB"`
        pub const COUNTRY_ABTWO: &str = "LB";
        /// `"LBN"`
        pub const COUNTRY_AB3: &str = "LBN";
        /// `"RL"`
        pub const COUNTRY_CAR: &str = "RL";
        /// `"لبنان"`
        pub const COUNTRY_NAME: &str = "لبنان";
        /// `422`
        pub const COUNTRY_NUM: i64 = 422;
        /// `"ar"`
        pub const LANG_AB: &str = "ar";
        /// `"ara"`
        pub const LANG_LIB: &str = "ara";
        /// `"العربية"`
        pub const LANG_NAME: &str = "العربية";
        /// `"ara"`
        pub const LANG_TERM: &str = "ara";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan"`
        pub const ADDRESS: &str = "1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-07-20"`
        pub const DATE: &str = "2000-07-20";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Arabic"`
        pub const LANGUAGE: &str = "Arabic";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"IBM Globalization Center of Competency, Yamato Software Laboratory"`
        pub const SOURCE: &str = "IBM Globalization Center of Competency, Yamato Software Laboratory";
        /// `""`
        pub const TEL: &str = "";
        /// `"Lebanon"`
        pub const TERRITORY: &str = "Lebanon";
        /// `"Arabic language locale for Lebanon"`
        pub const TITLE: &str = "Arabic language locale for Lebanon";
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"ل.ل."`
        pub const CURRENCY_SYMBOL: &str = "ل.ل.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"LBP "`
        pub const INT_CURR_SYMBOL: &str = "LBP ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"961"`
        pub const INT_PREFIX: &str = "961";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c ;%a ;%l"`
        pub const TEL_INT_FMT: &str = "+%c ;%a ;%l";
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["كانون ال\nثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين ال\nأول", "تشرين ال\nثاني", "كانون ال\nأول"]`
        pub const ABMON: &[&str] = &["كانون ال\nثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين ال\nأول", "تشرين ال\nثاني", "كانون ال\nأول"];
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["كانون ال\nثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين ال\nأول", "تشرين ال\nثاني", "كانون ال\nأول"]`
        pub const MON: &[&str] = &["كانون ال\nثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين ال\nأول", "تشرين ال\nثاني", "كانون ال\nأول"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_LY {
    pub mod LC_ADDRESS {
        /// `"LY"`
        pub const COUNTRY_ABTWO: &str = "LY";
        /// `"LBY"`
        pub const COUNTRY_AB3: &str = "LBY";
        /// `"LAR"`
        pub const COUNTRY_CAR: &str = "LAR";
        /// `"ليبيا"`
        pub const COUNTRY_NAME: &str = "ليبيا";
        /// `434`
        pub const COUNTRY_NUM: i64 = 434;
        /// `"ar"`
        pub const LANG_AB: &str = "ar";
        /// `"ara"`
        pub const LANG_LIB: &str = "ara";
        /// `"العربية"`
        pub const LANG_NAME: &str = "العربية";
        /// `"ara"`
        pub const LANG_TERM: &str = "ara";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan"`
        pub const ADDRESS: &str = "1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-07-20"`
        pub const DATE: &str = "2000-07-20";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Arabic"`
        pub const LANGUAGE: &str = "Arabic";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"IBM Globalization Center of Competency, Yamato Software Laboratory"`
        pub const SOURCE: &str = "IBM Globalization Center of Competency, Yamato Software Laboratory";
        /// `""`
        pub const TEL: &str = "";
        /// `"Libya"`
        pub const TERRITORY: &str = "Libya";
        /// `"Arabic language locale for Libyan Arab Jamahiriya"`
        pub const TITLE: &str = "Arabic language locale for Libyan Arab Jamahiriya";
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"د.ل."`
        pub const CURRENCY_SYMBOL: &str = "د.ل.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"LYD "`
        pub const INT_CURR_SYMBOL: &str = "LYD ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"218"`
        pub const INT_PREFIX: &str = "218";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c ;%a ;%l"`
        pub const TEL_INT_FMT: &str = "+%c ;%a ;%l";
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"]`
        pub const ABMON: &[&str] = &["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"];
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `7`
        pub const FIRST_WEEKDAY: i64 = 7;
        /// `1`
        pub const FIRST_WORKDAY: i64 = 1;
        /// `&["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const MON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_MA {
    pub mod LC_ADDRESS {
        /// `"MA"`
        pub const COUNTRY_ABTWO: &str = "MA";
        /// `"MAR"`
        pub const COUNTRY_AB3: &str = "MAR";
        /// `"MA"`
        pub const COUNTRY_CAR: &str = "MA";
        /// `"المغرب"`
        pub const COUNTRY_NAME: &str = "المغرب";
        /// `504`
        pub const COUNTRY_NUM: i64 = 504;
        /// `"ar"`
        pub const LANG_AB: &str = "ar";
        /// `"ara"`
        pub const LANG_LIB: &str = "ara";
        /// `"العربية"`
        pub const LANG_NAME: &str = "العربية";
        /// `"ara"`
        pub const LANG_TERM: &str = "ara";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan"`
        pub const ADDRESS: &str = "1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-07-20"`
        pub const DATE: &str = "2000-07-20";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Arabic"`
        pub const LANGUAGE: &str = "Arabic";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"IBM Globalization Center of Competency, Yamato Software Laboratory"`
        pub const SOURCE: &str = "IBM Globalization Center of Competency, Yamato Software Laboratory";
        /// `""`
        pub const TEL: &str = "";
        /// `"Morocco"`
        pub const TERRITORY: &str = "Morocco";
        /// `"Arabic language locale for Morocco"`
        pub const TITLE: &str = "Arabic language locale for Morocco";
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"د.م."`
        pub const CURRENCY_SYMBOL: &str = "د.م.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"MAD "`
        pub const INT_CURR_SYMBOL: &str = "MAD ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"212"`
        pub const INT_PREFIX: &str = "212";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c ;%a ;%l"`
        pub const TEL_INT_FMT: &str = "+%c ;%a ;%l";
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["يناير", "فبراير", "مارس", "أبريل", "ماي", "يونيو", "يوليوز", "غشت", "شتنبر", "أكتوبر", "نونبر", "دجنبر"]`
        pub const ABMON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "ماي", "يونيو", "يوليوز", "غشت", "شتنبر", "أكتوبر", "نونبر", "دجنبر"];
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %H:%M:%S"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %H:%M:%S";
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `7`
        pub const FIRST_WEEKDAY: i64 = 7;
        /// `1`
        pub const FIRST_WORKDAY: i64 = 1;
        /// `&["يناير", "فبراير", "مارس", "أبريل", "ماي", "يونيو", "يوليوز", "غشت", "شتنبر", "أكتوبر", "نونبر", "دجنبر"]`
        pub const MON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "ماي", "يونيو", "يوليوز", "غشت", "شتنبر", "أكتوبر", "نونبر", "دجنبر"];
        /// `"%Z %H:%M:%S"`
        pub const T_FMT: &str = "%Z %H:%M:%S";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_OM {
    pub mod LC_ADDRESS {
        /// `"OM"`
        pub const COUNTRY_ABTWO: &str = "OM";
        /// `"OMN"`
        pub const COUNTRY_AB3: &str = "OMN";
        /// `"OM"`
        pub const COUNTRY_CAR: &str = "OM";
        /// `"ع\u{64f}مان"`
        pub const COUNTRY_NAME: &str = "ع\u{64f}مان";
        /// `512`
        pub const COUNTRY_NUM: i64 = 512;
        /// `"ar"`
        pub const LANG_AB: &str = "ar";
        /// `"ara"`
        pub const LANG_LIB: &str = "ara";
        /// `"العربية"`
        pub const LANG_NAME: &str = "العربية";
        /// `"ara"`
        pub const LANG_TERM: &str = "ara";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan"`
        pub const ADDRESS: &str = "1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-07-20"`
        pub const DATE: &str = "2000-07-20";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Arabic"`
        pub const LANGUAGE: &str = "Arabic";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"IBM Globalization Center of Competency, Yamato Software Laboratory"`
        pub const SOURCE: &str = "IBM Globalization Center of Competency, Yamato Software Laboratory";
        /// `""`
        pub const TEL: &str = "";
        /// `"Oman"`
        pub const TERRITORY: &str = "Oman";
        /// `"Arabic language locale for Oman"`
        pub const TITLE: &str = "Arabic language locale for Oman";
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"ر.ع."`
        pub const CURRENCY_SYMBOL: &str = "ر.ع.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"OMR "`
        pub const INT_CURR_SYMBOL: &str = "OMR ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"968"`
        pub const INT_PREFIX: &str = "968";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c ;%a ;%l"`
        pub const TEL_INT_FMT: &str = "+%c ;%a ;%l";
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"]`
        pub const ABMON: &[&str] = &["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"];
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `7`
        pub const FIRST_WEEKDAY: i64 = 7;
        /// `1`
        pub const FIRST_WORKDAY: i64 = 1;
        /// `&["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const MON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_QA {
    pub mod LC_ADDRESS {
        /// `"QA"`
        pub const COUNTRY_ABTWO: &str = "QA";
        /// `"QAT"`
        pub const COUNTRY_AB3: &str = "QAT";
        /// `"Q"`
        pub const COUNTRY_CAR: &str = "Q";
        /// `"قطر"`
        pub const COUNTRY_NAME: &str = "قطر";
        /// `634`
        pub const COUNTRY_NUM: i64 = 634;
        /// `"ar"`
        pub const LANG_AB: &str = "ar";
        /// `"ara"`
        pub const LANG_LIB: &str = "ara";
        /// `"العربية"`
        pub const LANG_NAME: &str = "العربية";
        /// `"ara"`
        pub const LANG_TERM: &str = "ara";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan"`
        pub const ADDRESS: &str = "1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-07-20"`
        pub const DATE: &str = "2000-07-20";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Arabic"`
        pub const LANGUAGE: &str = "Arabic";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"IBM Globalization Center of Competency, Yamato Software Laboratory"`
        pub const SOURCE: &str = "IBM Globalization Center of Competency, Yamato Software Laboratory";
        /// `""`
        pub const TEL: &str = "";
        /// `"Qatar"`
        pub const TERRITORY: &str = "Qatar";
        /// `"Arabic language locale for Qatar"`
        pub const TITLE: &str = "Arabic language locale for Qatar";
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"ر.ق."`
        pub const CURRENCY_SYMBOL: &str = "ر.ق.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"QAR "`
        pub const INT_CURR_SYMBOL: &str = "QAR ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"974"`
        pub const INT_PREFIX: &str = "974";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c ;%a ;%l"`
        pub const TEL_INT_FMT: &str = "+%c ;%a ;%l";
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"]`
        pub const ABMON: &[&str] = &["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"];
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `7`
        pub const FIRST_WEEKDAY: i64 = 7;
        /// `1`
        pub const FIRST_WORKDAY: i64 = 1;
        /// `&["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const MON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_SA {
    pub mod LC_ADDRESS {
        /// `"SA"`
        pub const COUNTRY_ABTWO: &str = "SA";
        /// `"SAU"`
        pub const COUNTRY_AB3: &str = "SAU";
        /// `"KSA"`
        pub const COUNTRY_CAR: &str = "KSA";
        /// `"المملكة العربية السعودية"`
        pub const COUNTRY_NAME: &str = "المملكة العربية السعودية";
        /// `682`
        pub const COUNTRY_NUM: i64 = 682;
        /// `"ar"`
        pub const LANG_AB: &str = "ar";
        /// `"ara"`
        pub const LANG_LIB: &str = "ara";
        /// `"العربية"`
        pub const LANG_NAME: &str = "العربية";
        /// `"ara"`
        pub const LANG_TERM: &str = "ara";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Arabic"`
        pub const LANGUAGE: &str = "Arabic";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"Saudi Arabia"`
        pub const TERRITORY: &str = "Saudi Arabia";
        /// `"Arabic locale for Saudi Arabia"`
        pub const TITLE: &str = "Arabic locale for Saudi Arabia";
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"ر.س"`
        pub const CURRENCY_SYMBOL: &str = "ر.س";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"SAR "`
        pub const INT_CURR_SYMBOL: &str = "SAR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `-1`
        pub const MON_GROUPING: i64 = -1;
        /// `""`
        pub const MON_THOUSANDS_SEP: &str = "";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `-1`
        pub const GROUPING: i64 = -1;
        /// `""`
        pub const THOUSANDS_SEP: &str = "";
    }
    pub mod LC_TELEPHONE {
        /// `"966"`
        pub const INT_PREFIX: &str = "966";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const ABMON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%A %e %B %Y"`
        pub const D_FMT: &str = "%A %e %B %Y";
        /// `"%A %e %B %Y  %k:%M:%S"`
        pub const D_T_FMT: &str = "%A %e %B %Y  %k:%M:%S";
        /// `&["الأحد", "الإثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعـة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الإثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعـة", "السبت"];
        /// `""`
        pub const ERA_D_FMT: &str = "";
        /// `1`
        pub const FIRST_WORKDAY: i64 = 1;
        /// `&["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const MON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `"%k:%M:%S"`
        pub const T_FMT: &str = "%k:%M:%S";
        /// `"%k:%M:%S"`
        pub const T_FMT_AMPM: &str = "%k:%M:%S";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_SD {
    pub mod LC_ADDRESS {
        /// `"SD"`
        pub const COUNTRY_ABTWO: &str = "SD";
        /// `"SDN"`
        pub const COUNTRY_AB3: &str = "SDN";
        /// `"SUD"`
        pub const COUNTRY_CAR: &str = "SUD";
        /// `"السودان"`
        pub const COUNTRY_NAME: &str = "السودان";
        /// `729`
        pub const COUNTRY_NUM: i64 = 729;
        /// `"ar"`
        pub const LANG_AB: &str = "ar";
        /// `"ara"`
        pub const LANG_LIB: &str = "ara";
        /// `"العربية"`
        pub const LANG_NAME: &str = "العربية";
        /// `"ara"`
        pub const LANG_TERM: &str = "ara";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan"`
        pub const ADDRESS: &str = "1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-07-20"`
        pub const DATE: &str = "2000-07-20";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Arabic"`
        pub const LANGUAGE: &str = "Arabic";
        /// `"1.1"`
        pub const REVISION: &str = "1.1";
        /// `"IBM Globalization Center of Competency, Yamato Software Laboratory"`
        pub const SOURCE: &str = "IBM Globalization Center of Competency, Yamato Software Laboratory";
        /// `""`
        pub const TEL: &str = "";
        /// `"Sudan"`
        pub const TERRITORY: &str = "Sudan";
        /// `"Arabic language locale for Sudan"`
        pub const TITLE: &str = "Arabic language locale for Sudan";
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"ج.س."`
        pub const CURRENCY_SYMBOL: &str = "ج.س.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"SDG "`
        pub const INT_CURR_SYMBOL: &str = "SDG ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"249"`
        pub const INT_PREFIX: &str = "249";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c ;%a ;%l"`
        pub const TEL_INT_FMT: &str = "+%c ;%a ;%l";
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"]`
        pub const ABMON: &[&str] = &["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"];
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `7`
        pub const FIRST_WEEKDAY: i64 = 7;
        /// `1`
        pub const FIRST_WORKDAY: i64 = 1;
        /// `&["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const MON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_SS {
    pub mod LC_ADDRESS {
        /// `"SS"`
        pub const COUNTRY_ABTWO: &str = "SS";
        /// `"SSD"`
        pub const COUNTRY_AB3: &str = "SSD";
        /// `"SUD"`
        pub const COUNTRY_CAR: &str = "SUD";
        /// `"جنوب السودان"`
        pub const COUNTRY_NAME: &str = "جنوب السودان";
        /// `728`
        pub const COUNTRY_NUM: i64 = 728;
        /// `"ar"`
        pub const LANG_AB: &str = "ar";
        /// `"ara"`
        pub const LANG_LIB: &str = "ara";
        /// `"العربية"`
        pub const LANG_NAME: &str = "العربية";
        /// `"ara"`
        pub const LANG_TERM: &str = "ara";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan"`
        pub const ADDRESS: &str = "1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-07-20"`
        pub const DATE: &str = "2000-07-20";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Arabic"`
        pub const LANGUAGE: &str = "Arabic";
        /// `"1.1"`
        pub const REVISION: &str = "1.1";
        /// `"IBM Globalization Center of Competency, Yamato Software Laboratory"`
        pub const SOURCE: &str = "IBM Globalization Center of Competency, Yamato Software Laboratory";
        /// `""`
        pub const TEL: &str = "";
        /// `"South Sudan"`
        pub const TERRITORY: &str = "South Sudan";
        /// `"Arabic language locale for South Sudan"`
        pub const TITLE: &str = "Arabic language locale for South Sudan";
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"£"`
        pub const CURRENCY_SYMBOL: &str = "£";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"SSP "`
        pub const INT_CURR_SYMBOL: &str = "SSP ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"211"`
        pub const INT_PREFIX: &str = "211";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c ;%a ;%l"`
        pub const TEL_INT_FMT: &str = "+%c ;%a ;%l";
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"]`
        pub const ABMON: &[&str] = &["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"];
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const MON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_SY {
    pub mod LC_ADDRESS {
        /// `"SY"`
        pub const COUNTRY_ABTWO: &str = "SY";
        /// `"SYR"`
        pub const COUNTRY_AB3: &str = "SYR";
        /// `"SYR"`
        pub const COUNTRY_CAR: &str = "SYR";
        /// `"سوريا"`
        pub const COUNTRY_NAME: &str = "سوريا";
        /// `760`
        pub const COUNTRY_NUM: i64 = 760;
        /// `"ar"`
        pub const LANG_AB: &str = "ar";
        /// `"ara"`
        pub const LANG_LIB: &str = "ara";
        /// `"العربية"`
        pub const LANG_NAME: &str = "العربية";
        /// `"ara"`
        pub const LANG_TERM: &str = "ara";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan"`
        pub const ADDRESS: &str = "1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-07-20"`
        pub const DATE: &str = "2000-07-20";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Arabic"`
        pub const LANGUAGE: &str = "Arabic";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"IBM Globalization Center of Competency, Yamato Software Laboratory"`
        pub const SOURCE: &str = "IBM Globalization Center of Competency, Yamato Software Laboratory";
        /// `""`
        pub const TEL: &str = "";
        /// `"Syria"`
        pub const TERRITORY: &str = "Syria";
        /// `"Arabic language locale for Syrian Arab Republic"`
        pub const TITLE: &str = "Arabic language locale for Syrian Arab Republic";
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"ل.س."`
        pub const CURRENCY_SYMBOL: &str = "ل.س.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"SYP "`
        pub const INT_CURR_SYMBOL: &str = "SYP ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"963"`
        pub const INT_PREFIX: &str = "963";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c ;%a ;%l"`
        pub const TEL_INT_FMT: &str = "+%c ;%a ;%l";
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["كانون ال\nثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين ال\nأول", "تشرين ال\nثاني", "كانون ال\nأول"]`
        pub const ABMON: &[&str] = &["كانون ال\nثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين ال\nأول", "تشرين ال\nثاني", "كانون ال\nأول"];
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `7`
        pub const FIRST_WEEKDAY: i64 = 7;
        /// `1`
        pub const FIRST_WORKDAY: i64 = 1;
        /// `&["كانون ال\nثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين ال\nأول", "تشرين ال\nثاني", "كانون ال\nأول"]`
        pub const MON: &[&str] = &["كانون ال\nثاني", "شباط", "آذار", "نيسان", "أيار", "حزيران", "تموز", "آب", "أيلول", "تشرين ال\nأول", "تشرين ال\nثاني", "كانون ال\nأول"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_TN {
    pub mod LC_ADDRESS {
        /// `"TN"`
        pub const COUNTRY_ABTWO: &str = "TN";
        /// `"TUN"`
        pub const COUNTRY_AB3: &str = "TUN";
        /// `"TN"`
        pub const COUNTRY_CAR: &str = "TN";
        /// `"تونس"`
        pub const COUNTRY_NAME: &str = "تونس";
        /// `788`
        pub const COUNTRY_NUM: i64 = 788;
        /// `"ar"`
        pub const LANG_AB: &str = "ar";
        /// `"ara"`
        pub const LANG_LIB: &str = "ara";
        /// `"العربية"`
        pub const LANG_NAME: &str = "العربية";
        /// `"ara"`
        pub const LANG_TERM: &str = "ara";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan"`
        pub const ADDRESS: &str = "1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-07-20"`
        pub const DATE: &str = "2000-07-20";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Arabic"`
        pub const LANGUAGE: &str = "Arabic";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"IBM Globalization Center of Competency, Yamato Software Laboratory"`
        pub const SOURCE: &str = "IBM Globalization Center of Competency, Yamato Software Laboratory";
        /// `""`
        pub const TEL: &str = "";
        /// `"Tunisia"`
        pub const TERRITORY: &str = "Tunisia";
        /// `"Arabic language locale for Tunisia"`
        pub const TITLE: &str = "Arabic language locale for Tunisia";
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"د.ت."`
        pub const CURRENCY_SYMBOL: &str = "د.ت.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"TND "`
        pub const INT_CURR_SYMBOL: &str = "TND ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"216"`
        pub const INT_PREFIX: &str = "216";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c ;%a ;%l"`
        pub const TEL_INT_FMT: &str = "+%c ;%a ;%l";
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["جانفي", "فيفري", "مارس", "أفريل", "ماي", "جوان", "جويلية", "أوت", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const ABMON: &[&str] = &["جانفي", "فيفري", "مارس", "أفريل", "ماي", "جوان", "جويلية", "أوت", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `1`
        pub const FIRST_WORKDAY: i64 = 1;
        /// `&["جانفي", "فيفري", "مارس", "أفريل", "ماي", "جوان", "جويلية", "أوت", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const MON: &[&str] = &["جانفي", "فيفري", "مارس", "أفريل", "ماي", "جوان", "جويلية", "أوت", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ar_YE {
    pub mod LC_ADDRESS {
        /// `"YE"`
        pub const COUNTRY_ABTWO: &str = "YE";
        /// `"YEM"`
        pub const COUNTRY_AB3: &str = "YEM";
        /// `"YAR"`
        pub const COUNTRY_CAR: &str = "YAR";
        /// `"اليمن"`
        pub const COUNTRY_NAME: &str = "اليمن";
        /// `887`
        pub const COUNTRY_NUM: i64 = 887;
        /// `"ar"`
        pub const LANG_AB: &str = "ar";
        /// `"ara"`
        pub const LANG_LIB: &str = "ara";
        /// `"العربية"`
        pub const LANG_NAME: &str = "العربية";
        /// `"ara"`
        pub const LANG_TERM: &str = "ara";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan"`
        pub const ADDRESS: &str = "1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-07-20"`
        pub const DATE: &str = "2000-07-20";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Arabic"`
        pub const LANGUAGE: &str = "Arabic";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"IBM Globalization Center of Competency, Yamato Software Laboratory"`
        pub const SOURCE: &str = "IBM Globalization Center of Competency, Yamato Software Laboratory";
        /// `""`
        pub const TEL: &str = "";
        /// `"Yemen"`
        pub const TERRITORY: &str = "Yemen";
        /// `"Arabic language locale for Yemen"`
        pub const TITLE: &str = "Arabic language locale for Yemen";
    }
    pub use super::ar_EG::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"ر.ي."`
        pub const CURRENCY_SYMBOL: &str = "ر.ي.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"YER "`
        pub const INT_CURR_SYMBOL: &str = "YER ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"967"`
        pub const INT_PREFIX: &str = "967";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c ;%a ;%l"`
        pub const TEL_INT_FMT: &str = "+%c ;%a ;%l";
    }
    pub mod LC_TIME {
        /// `&["ح", "ن", "ث", "ر", "خ", "ج", "س"]`
        pub const ABDAY: &[&str] = &["ح", "ن", "ث", "ر", "خ", "ج", "س"];
        /// `&["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"]`
        pub const ABMON: &[&str] = &["ينا", "فبر", "مار", "أبر", "ماي", "يون", "يول", "أغس", "سبت", "أكت", "نوف", "ديس"];
        /// `&["ص", "م"]`
        pub const AM_PM: &[&str] = &["ص", "م"];
        /// `"%d %b, %Y"`
        pub const D_FMT: &str = "%d %b, %Y";
        /// `"%d %b, %Y %Z %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%d %b, %Y %Z %I:%M:%S %p";
        /// `&["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"]`
        pub const DAY: &[&str] = &["الأحد", "الاثنين", "الثلاثاء", "الأربعاء", "الخميس", "الجمعة", "السبت"];
        /// `1`
        pub const FIRST_WORKDAY: i64 = 1;
        /// `&["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"]`
        pub const MON: &[&str] = &["يناير", "فبراير", "مارس", "أبريل", "مايو", "يونيو", "يوليو", "أغسطس", "سبتمبر", "أكتوبر", "نوفمبر", "ديسمبر"];
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT: &str = "%Z %I:%M:%S %p";
        /// `"%Z %I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Z %I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod as_IN {
    pub mod LC_ADDRESS {
        /// `"IND"`
        pub const COUNTRY_CAR: &str = "IND";
        /// `"ভ\u{9be}ৰত"`
        pub const COUNTRY_NAME: &str = "ভ\u{9be}ৰত";
        /// `356`
        pub const COUNTRY_NUM: i64 = 356;
        /// `"as"`
        pub const LANG_AB: &str = "as";
        /// `"asm"`
        pub const LANG_LIB: &str = "asm";
        /// `"অসমীয\u{9bc}\u{9be}"`
        pub const LANG_NAME: &str = "অসমীয\u{9bc}\u{9be}";
        /// `"asm"`
        pub const LANG_TERM: &str = "asm";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2006-05-25"`
        pub const DATE: &str = "2006-05-25";
        /// `"bug-glibc@gnu.org"`
        pub const EMAIL: &str = "bug-glibc@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Assamese"`
        pub const LANGUAGE: &str = "Assamese";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Amitakhya Phukan, Red Hat"`
        pub const SOURCE: &str = "Amitakhya Phukan, Red Hat";
        /// `""`
        pub const TEL: &str = "";
        /// `"India"`
        pub const TERRITORY: &str = "India";
        /// `"Assamese language locale for India"`
        pub const TITLE: &str = "Assamese language locale for India";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNন]"`
        pub const NOEXPR: &str = "^[-0nNন]";
        /// `"নহয়"`
        pub const NOSTR: &str = "নহয়";
        /// `"^[+1yYহ]"`
        pub const YESEXPR: &str = "^[+1yYহ]";
        /// `"হয়"`
        pub const YESSTR: &str = "হয়";
    }
    pub use super::hi_IN::LC_MONETARY;
    pub use super::en_IN::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `"91"`
        pub const INT_PREFIX: &str = "91";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c ;%a ;%l"`
        pub const TEL_INT_FMT: &str = "+%c ;%a ;%l";
    }
    pub mod LC_TIME {
        /// `&["দেও", "সোম", "মঙ\u{9cd}গল", "ব\u{9c1}ধ", "ব\u{9c3}হষ\u{9cd}পতি", "শ\u{9c1}ক\u{9cd}ৰ", "শনি"]`
        pub const ABDAY: &[&str] = &["দেও", "সোম", "মঙ\u{9cd}গল", "ব\u{9c1}ধ", "ব\u{9c3}হষ\u{9cd}পতি", "শ\u{9c1}ক\u{9cd}ৰ", "শনি"];
        /// `&["জ\u{9be}ন\u{9c1}", "ফেব\u{9cd}ৰ\u{9c1}", "ম\u{9be}ৰ\u{9cd}চ", "এপ\u{9cd}ৰিল", "মে", "জ\u{9c1}ন", "জ\u{9c1}ল\u{9be}ই", "আগ", "সেপ\u{9cd}ট", "অক\u{9cd}টো", "নভে", "ডিসে"]`
        pub const ABMON: &[&str] = &["জ\u{9be}ন\u{9c1}", "ফেব\u{9cd}ৰ\u{9c1}", "ম\u{9be}ৰ\u{9cd}চ", "এপ\u{9cd}ৰিল", "মে", "জ\u{9c1}ন", "জ\u{9c1}ল\u{9be}ই", "আগ", "সেপ\u{9cd}ট", "অক\u{9cd}টো", "নভে", "ডিসে"];
        /// `&["প\u{9c2}ৰ\u{9cd}ব\u{9cd}ব\u{9be}হ\u{9cd}ন", "অপৰ\u{9be}হ\u{9cd}ন"]`
        pub const AM_PM: &[&str] = &["প\u{9c2}ৰ\u{9cd}ব\u{9cd}ব\u{9be}হ\u{9cd}ন", "অপৰ\u{9be}হ\u{9cd}ন"];
        /// `"%e-%m-%Y"`
        pub const D_FMT: &str = "%e-%m-%Y";
        /// `"%e %B, %Y %I.%M.%S %p %Z"`
        pub const D_T_FMT: &str = "%e %B, %Y %I.%M.%S %p %Z";
        /// `&["দেওব\u{9be}ৰ", "সোমব\u{9be}ৰ", "মঙ\u{9cd}গলব\u{9be}ৰ", "ব\u{9c1}ধব\u{9be}ৰ", "ব\u{9c3}হষ\u{9cd}পতিব\u{9be}ৰ", "শ\u{9c1}ক\u{9cd}ৰব\u{9be}ৰ", "শনিব\u{9be}ৰ"]`
        pub const DAY: &[&str] = &["দেওব\u{9be}ৰ", "সোমব\u{9be}ৰ", "মঙ\u{9cd}গলব\u{9be}ৰ", "ব\u{9c1}ধব\u{9be}ৰ", "ব\u{9c3}হষ\u{9cd}পতিব\u{9be}ৰ", "শ\u{9c1}ক\u{9cd}ৰব\u{9be}ৰ", "শনিব\u{9be}ৰ"];
        /// `&["জ\u{9be}ন\u{9c1}ৱ\u{9be}ৰী", "ফেব\u{9cd}ৰ\u{9c1}ৱ\u{9be}ৰী", "ম\u{9be}ৰ\u{9cd}চ", "এপ\u{9cd}ৰিল", "মে", "জ\u{9c1}ন", "জ\u{9c1}ল\u{9be}ই", "আগষ\u{9cd}ট", "ছেপ\u{9cd}তেম\u{9cd}বৰ", "অক\u{9cd}টোবৰ", "নৱেম\u{9cd}বৰ", "ডিচেম\u{9cd}বৰ"]`
        pub const MON: &[&str] = &["জ\u{9be}ন\u{9c1}ৱ\u{9be}ৰী", "ফেব\u{9cd}ৰ\u{9c1}ৱ\u{9be}ৰী", "ম\u{9be}ৰ\u{9cd}চ", "এপ\u{9cd}ৰিল", "মে", "জ\u{9c1}ন", "জ\u{9c1}ল\u{9be}ই", "আগষ\u{9cd}ট", "ছেপ\u{9cd}তেম\u{9cd}বৰ", "অক\u{9cd}টোবৰ", "নৱেম\u{9cd}বৰ", "ডিচেম\u{9cd}বৰ"];
        /// `"%I.%M.%S %p"`
        pub const T_FMT: &str = "%I.%M.%S %p";
        /// `"%I.%M.%S %p"`
        pub const T_FMT_AMPM: &str = "%I.%M.%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ast_ES {
    pub mod LC_ADDRESS {
        /// `"ES"`
        pub const COUNTRY_ABTWO: &str = "ES";
        /// `"ESP"`
        pub const COUNTRY_AB3: &str = "ESP";
        /// `"E"`
        pub const COUNTRY_CAR: &str = "E";
        /// `"España"`
        pub const COUNTRY_NAME: &str = "España";
        /// `724`
        pub const COUNTRY_NUM: i64 = 724;
        /// `"ast"`
        pub const LANG_LIB: &str = "ast";
        /// `"asturianu"`
        pub const LANG_NAME: &str = "asturianu";
        /// `"ast"`
        pub const LANG_TERM: &str = "ast";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `"Jordi Mallach"`
        pub const CONTACT: &str = "Jordi Mallach";
        /// `"2005-08-26"`
        pub const DATE: &str = "2005-08-26";
        /// `"jordi@gnu.org"`
        pub const EMAIL: &str = "jordi@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Asturian"`
        pub const LANGUAGE: &str = "Asturian";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"Spain"`
        pub const TERRITORY: &str = "Spain";
        /// `"Asturian locale for Spain"`
        pub const TITLE: &str = "Asturian locale for Spain";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"non"`
        pub const NOSTR: &str = "non";
        /// `"^[+1sSyY]"`
        pub const YESEXPR: &str = "^[+1sSyY]";
        /// `"sí"`
        pub const YESSTR: &str = "sí";
    }
    pub use super::es_ES::LC_MONETARY;
    pub use super::es_ES::LC_NUMERIC;
    pub use super::es_ES::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["dom", "llu", "mar", "mié", "xue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "llu", "mar", "mié", "xue", "vie", "sáb"];
        /// `&["xin", "feb", "mar", "abr", "may", "xun", "xnt", "ago", "set", "och", "pay", "avi"]`
        pub const ABMON: &[&str] = &["xin", "feb", "mar", "abr", "may", "xun", "xnt", "ago", "set", "och", "pay", "avi"];
        /// `&["xineru", "febreru", "marzu", "abril", "mayu", "xunu", "xunetu", "agostu", "setiembre", "ochobre", "payares", "avientu"]`
        pub const ALT_MON: &[&str] = &["xineru", "febreru", "marzu", "abril", "mayu", "xunu", "xunetu", "agostu", "setiembre", "ochobre", "payares", "avientu"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["domingu", "llunes", "martes", "miércoles", "xueves", "vienres", "sábadu"]`
        pub const DAY: &[&str] = &["domingu", "llunes", "martes", "miércoles", "xueves", "vienres", "sábadu"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["de xineru", "de febreru", "de marzu", "d’abril", "de mayu", "de xunu", "de xunetu", "d’agostu", "de setiembre", "d’ochobre", "de payares", "d’avientu"]`
        pub const MON: &[&str] = &["de xineru", "de febreru", "de marzu", "d’abril", "de mayu", "de xunu", "de xunetu", "d’agostu", "de setiembre", "d’ochobre", "de payares", "d’avientu"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ayc_PE {
    pub mod LC_ADDRESS {
        /// `"PE"`
        pub const COUNTRY_ABTWO: &str = "PE";
        /// `"PER"`
        pub const COUNTRY_AB3: &str = "PER";
        /// `"PE"`
        pub const COUNTRY_CAR: &str = "PE";
        /// `"Piruw"`
        pub const COUNTRY_NAME: &str = "Piruw";
        /// `604`
        pub const COUNTRY_NUM: i64 = 604;
        /// `"ay"`
        pub const LANG_AB: &str = "ay";
        /// `"ayc"`
        pub const LANG_LIB: &str = "ayc";
        /// `"Aymar aru"`
        pub const LANG_NAME: &str = "Aymar aru";
        /// `"ayc"`
        pub const LANG_TERM: &str = "ayc";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2011-11-13"`
        pub const DATE: &str = "2011-11-13";
        /// `"libc-alpha@sourceware.org"`
        pub const EMAIL: &str = "libc-alpha@sourceware.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Aymara"`
        pub const LANGUAGE: &str = "Aymara";
        /// `"1.1"`
        pub const REVISION: &str = "1.1";
        /// `"runasimipi.org"`
        pub const SOURCE: &str = "runasimipi.org";
        /// `""`
        pub const TEL: &str = "";
        /// `"Peru"`
        pub const TERRITORY: &str = "Peru";
        /// `"Aymara (ayc) locale for Peru"`
        pub const TITLE: &str = "Aymara (ayc) locale for Peru";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0jJnN]"`
        pub const NOEXPR: &str = "^[-0jJnN]";
        /// `"Janiwa"`
        pub const NOSTR: &str = "Janiwa";
        /// `"^[+1uUsSyY]"`
        pub const YESEXPR: &str = "^[+1uUsSyY]";
        /// `"Ukhamawa"`
        pub const YESSTR: &str = "Ukhamawa";
    }
    pub use super::es_PE::LC_MONETARY;
    pub use super::es_PE::LC_NUMERIC;
    pub use super::es_PE::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["tum", "lun", "mar", "mir", "juy", "wir", "saw"]`
        pub const ABDAY: &[&str] = &["tum", "lun", "mar", "mir", "juy", "wir", "saw"];
        /// `&["ini", "phi", "mar", "awr", "may", "jun", "jul", "awu", "sit", "ukt", "nuw", "ris"]`
        pub const ABMON: &[&str] = &["ini", "phi", "mar", "awr", "may", "jun", "jul", "awu", "sit", "ukt", "nuw", "ris"];
        /// `&["VM", "NM"]`
        pub const AM_PM: &[&str] = &["VM", "NM"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["tuminku", "lunisa", "martisa", "mirkulisa", "juywisa", "wirnisa", "sawäru"]`
        pub const DAY: &[&str] = &["tuminku", "lunisa", "martisa", "mirkulisa", "juywisa", "wirnisa", "sawäru"];
        /// `&["inïru", "phiwriru", "marsu", "awrila", "mayu", "junyu", "julyu", "awustu", "sitimri", "uktuwri", "nuwimri", "risimri"]`
        pub const MON: &[&str] = &["inïru", "phiwriru", "marsu", "awrila", "mayu", "junyu", "julyu", "awustu", "sitimri", "uktuwri", "nuwimri", "risimri"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod az_AZ {
    pub mod LC_ADDRESS {
        /// `"AZ"`
        pub const COUNTRY_ABTWO: &str = "AZ";
        /// `"AZE"`
        pub const COUNTRY_AB3: &str = "AZE";
        /// `"AZ"`
        pub const COUNTRY_CAR: &str = "AZ";
        /// `"Azərbaycan"`
        pub const COUNTRY_NAME: &str = "Azərbaycan";
        /// `31`
        pub const COUNTRY_NUM: i64 = 31;
        /// `"az"`
        pub const LANG_AB: &str = "az";
        /// `"aze"`
        pub const LANG_LIB: &str = "aze";
        /// `"azərbaycan"`
        pub const LANG_NAME: &str = "azərbaycan";
        /// `"aze"`
        pub const LANG_TERM: &str = "aze";
        /// `"???"`
        pub const POSTAL_FMT: &str = "???";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
        ];
        /// `"Pablo Saratxaga"`
        pub const CONTACT: &str = "Pablo Saratxaga";
        /// `"2001-01-26"`
        pub const DATE: &str = "2001-01-26";
        /// `"pablo@mandrakesoft.com"`
        pub const EMAIL: &str = "pablo@mandrakesoft.com";
        /// `""`
        pub const FAX: &str = "";
        /// `"Azerbaijani"`
        pub const LANGUAGE: &str = "Azerbaijani";
        /// `"0.4"`
        pub const REVISION: &str = "0.4";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"Azerbaijan"`
        pub const TERRITORY: &str = "Azerbaijan";
        /// `"Azeri language locale for Azerbaijan (latin)"`
        pub const TITLE: &str = "Azeri language locale for Azerbaijan (latin)";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0YyNn]"`
        pub const NOEXPR: &str = "^[-0YyNn]";
        /// `"yox"`
        pub const NOSTR: &str = "yox";
        /// `"^[+1bBhH]"`
        pub const YESEXPR: &str = "^[+1bBhH]";
        /// `"hə"`
        pub const YESSTR: &str = "hə";
    }
    pub mod LC_MONETARY {
        /// `"₼"`
        pub const CURRENCY_SYMBOL: &str = "₼";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"AZN "`
        pub const INT_CURR_SYMBOL: &str = "AZN ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `"994"`
        pub const INT_PREFIX: &str = "994";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["baz", "ber", "çax", "çər", "cax", "cüm", "şnb"]`
        pub const ABDAY: &[&str] = &["baz", "ber", "çax", "çər", "cax", "cüm", "şnb"];
        /// `&["Yan", "Fev", "Mar", "Apr", "May", "İyn", "İyl", "Avq", "Sen", "Okt", "Noy", "Dek"]`
        pub const ABMON: &[&str] = &["Yan", "Fev", "Mar", "Apr", "May", "İyn", "İyl", "Avq", "Sen", "Okt", "Noy", "Dek"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%A, %d %B %Y %T"`
        pub const D_T_FMT: &str = "%A, %d %B %Y %T";
        /// `&["bazar günü", "bazar ertəsi", "çərşənbə axşamı", "çərşənbə", "cümə axşamı", "cümə", "şənbə"]`
        pub const DAY: &[&str] = &["bazar günü", "bazar ertəsi", "çərşənbə axşamı", "çərşənbə", "cümə axşamı", "cümə", "şənbə"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["yanvar", "fevral", "mart", "aprel", "may", "iyun", "iyul", "avqust", "sentyabr", "oktyabr", "noyabr", "dekabr"]`
        pub const MON: &[&str] = &["yanvar", "fevral", "mart", "aprel", "may", "iyun", "iyul", "avqust", "sentyabr", "oktyabr", "noyabr", "dekabr"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod az_IR {
    pub mod LC_ADDRESS {
        /// `"IR"`
        pub const COUNTRY_ABTWO: &str = "IR";
        /// `"IRN"`
        pub const COUNTRY_AB3: &str = "IRN";
        /// `"IR"`
        pub const COUNTRY_CAR: &str = "IR";
        /// `"964"`
        pub const COUNTRY_ISBN: &str = "964";
        /// `"ایران"`
        pub const COUNTRY_NAME: &str = "ایران";
        /// `364`
        pub const COUNTRY_NUM: i64 = 364;
        /// `"az"`
        pub const LANG_AB: &str = "az";
        /// `"aze"`
        pub const LANG_LIB: &str = "aze";
        /// `"تۆرکجه"`
        pub const LANG_NAME: &str = "تۆرکجه";
        /// `"azb"`
        pub const LANG_TERM: &str = "azb";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
        ];
        /// `"Mousa Moradi"`
        pub const CONTACT: &str = "Mousa Moradi";
        /// `"2014-05-01"`
        pub const DATE: &str = "2014-05-01";
        /// `"mousamk@gmail.com"`
        pub const EMAIL: &str = "mousamk@gmail.com";
        /// `""`
        pub const FAX: &str = "";
        /// `"South Azerbaijani"`
        pub const LANGUAGE: &str = "South Azerbaijani";
        /// `"0.2"`
        pub const REVISION: &str = "0.2";
        /// `""`
        pub const SOURCE: &str = "";
        /// `"(+98) 914 492 1058"`
        pub const TEL: &str = "(+98) 914 492 1058";
        /// `"Iran"`
        pub const TERRITORY: &str = "Iran";
        /// `"South Azerbaijani language locale for Iran"`
        pub const TITLE: &str = "South Azerbaijani language locale for Iran";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNیخ]"`
        pub const NOEXPR: &str = "^[-0nNیخ]";
        /// `"یو\u{652}خ"`
        pub const NOSTR: &str = "یو\u{652}خ";
        /// `"^[+1yYهب]"`
        pub const YESEXPR: &str = "^[+1yYهب]";
        /// `"هن"`
        pub const YESSTR: &str = "هن";
    }
    pub use super::fa_IR::LC_MONETARY;
    pub use super::fa_IR::LC_NUMERIC;
    pub use super::fa_IR::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["یکشنبه", "دوشنبه", "سه\u{200c}شنبه", "چارشنبه", "جۆمعه آخشامی", "جۆمعه", "شنبه"]`
        pub const ABDAY: &[&str] = &["یکشنبه", "دوشنبه", "سه\u{200c}شنبه", "چارشنبه", "جۆمعه آخشامی", "جۆمعه", "شنبه"];
        /// `&["ژانویه", "فوریه", "مارس", "آوریل", "مئی", "ژوئن", "جولای", "آقۇست", "سپتامبر", "او\u{652}کتو\u{652}بر", "نو\u{652}وامبر", "دسامبر"]`
        pub const ABMON: &[&str] = &["ژانویه", "فوریه", "مارس", "آوریل", "مئی", "ژوئن", "جولای", "آقۇست", "سپتامبر", "او\u{652}کتو\u{652}بر", "نو\u{652}وامبر", "دسامبر"];
        /// `&["۰۰", "۰۱", "۰۲", "۰۳", "۰۴", "۰۵", "۰۶", "۰۷", "۰۸", "۰۹", "۱۰", "۱۱", "۱۲", "۱۳", "۱۴", "۱۵", "۱۶", "۱۷", "۱۸", "۱۹", "۲۰", "۲۱", "۲۲", "۲۳", "۲۴", "۲۵", "۲۶", "۲۷", "۲۸", "۲۹", "۳۰", "۳۱", "۳۲", "۳۳", "۳۴", "۳۵", "۳۶", "۳۷", "۳۸", "۳۹", "۴۰", "۴۱", "۴۲", "۴۳", "۴۴", "۴۵", "۴۶", "۴۷", "۴۸", "۴۹", "۵۰", "۵۱", "۵۲", "۵۳", "۵۴", "۵۵", "۵۶", "۵۷", "۵۸", "۵۹", "۶۰", "۶۱", "۶۲", "۶۳", "۶۴", "۶۵", "۶۶", "۶۷", "۶۸", "۶۹", "۷۰", "۷۱", "۷۲", "۷۳", "۷۴", "۷۵", "۷۶", "۷۷", "۷۸", "۷۹", "۸۰", "۸۱", "۸۲", "۸۳", "۸۴", "۸۵", "۸۶", "۸۷", "۸۸", "۸۹", "۹۰", "۹۱", "۹۲", "۹۳", "۹۴", "۹۵", "۹۶", "۹۷", "۹۸", "۹۹"]`
        pub const ALT_DIGITS: &[&str] = &["۰۰", "۰۱", "۰۲", "۰۳", "۰۴", "۰۵", "۰۶", "۰۷", "۰۸", "۰۹", "۱۰", "۱۱", "۱۲", "۱۳", "۱۴", "۱۵", "۱۶", "۱۷", "۱۸", "۱۹", "۲۰", "۲۱", "۲۲", "۲۳", "۲۴", "۲۵", "۲۶", "۲۷", "۲۸", "۲۹", "۳۰", "۳۱", "۳۲", "۳۳", "۳۴", "۳۵", "۳۶", "۳۷", "۳۸", "۳۹", "۴۰", "۴۱", "۴۲", "۴۳", "۴۴", "۴۵", "۴۶", "۴۷", "۴۸", "۴۹", "۵۰", "۵۱", "۵۲", "۵۳", "۵۴", "۵۵", "۵۶", "۵۷", "۵۸", "۵۹", "۶۰", "۶۱", "۶۲", "۶۳", "۶۴", "۶۵", "۶۶", "۶۷", "۶۸", "۶۹", "۷۰", "۷۱", "۷۲", "۷۳", "۷۴", "۷۵", "۷۶", "۷۷", "۷۸", "۷۹", "۸۰", "۸۱", "۸۲", "۸۳", "۸۴", "۸۵", "۸۶", "۸۷", "۸۸", "۸۹", "۹۰", "۹۱", "۹۲", "۹۳", "۹۴", "۹۵", "۹۶", "۹۷", "۹۸", "۹۹"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `3`
        pub const CAL_DIRECTION: i64 = 3;
        /// `"%Oy/%Om/%Od"`
        pub const D_FMT: &str = "%Oy/%Om/%Od";
        /// `"\u{202b}%A %Oe %B %Oy، %OH:%OM:%OS\u{202c}"`
        pub const D_T_FMT: &str = "\u{202b}%A %Oe %B %Oy، %OH:%OM:%OS\u{202c}";
        /// `"\u{202b}%A %Oe %B %Oy، ساعات \n%OH:%OM:%OS (%Z)\u{202c}"`
        pub const DATE_FMT: &str = "\u{202b}%A %Oe %B %Oy، ساعات \n%OH:%OM:%OS (%Z)\u{202c}";
        /// `&["یکشنبه", "دوشنبه", "سه\u{200c}شنبه", "چارشنبه", "جۆمعه آخشامی", "جۆمعه", "شنبه"]`
        pub const DAY: &[&str] = &["یکشنبه", "دوشنبه", "سه\u{200c}شنبه", "چارشنبه", "جۆمعه آخشامی", "جۆمعه", "شنبه"];
        /// `7`
        pub const FIRST_WEEKDAY: i64 = 7;
        /// `7`
        pub const FIRST_WORKDAY: i64 = 7;
        /// `&["ژانویه", "فوریه", "مارس", "آوریل", "مئی", "ژوئن", "جولای", "آقۇست", "سپتامبر", "او\u{652}کتو\u{652}بر", "نو\u{652}وامبر", "دسامبر"]`
        pub const MON: &[&str] = &["ژانویه", "فوریه", "مارس", "آوریل", "مئی", "ژوئن", "جولای", "آقۇست", "سپتامبر", "او\u{652}کتو\u{652}بر", "نو\u{652}وامبر", "دسامبر"];
        /// `"%OH:%OM:%OS"`
        pub const T_FMT: &str = "%OH:%OM:%OS";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod be_BY {
    pub mod LC_ADDRESS {
        /// `"BY"`
        pub const COUNTRY_ABTWO: &str = "BY";
        /// `"BLR"`
        pub const COUNTRY_AB3: &str = "BLR";
        /// `"BY"`
        pub const COUNTRY_CAR: &str = "BY";
        /// `"Беларусь"`
        pub const COUNTRY_NAME: &str = "Беларусь";
        /// `112`
        pub const COUNTRY_NUM: i64 = 112;
        /// `"be"`
        pub const LANG_AB: &str = "be";
        /// `"bel"`
        pub const LANG_LIB: &str = "bel";
        /// `"беларуская"`
        pub const LANG_NAME: &str = "беларуская";
        /// `"bel"`
        pub const LANG_TERM: &str = "bel";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Belarusian"`
        pub const LANGUAGE: &str = "Belarusian";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"Belarus"`
        pub const TERRITORY: &str = "Belarus";
        /// `"Belarusian locale for Belarus"`
        pub const TITLE: &str = "Belarusian locale for Belarus";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNНн]"`
        pub const NOEXPR: &str = "^[-0nNНн]";
        /// `"не"`
        pub const NOSTR: &str = "не";
        /// `"^[+1yYТт]"`
        pub const YESEXPR: &str = "^[+1yYТт]";
        /// `"так"`
        pub const YESSTR: &str = "так";
    }
    pub mod LC_MONETARY {
        /// `"руб"`
        pub const CURRENCY_SYMBOL: &str = "руб";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"BYR "`
        pub const INT_CURR_SYMBOL: &str = "BYR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `"375"`
        pub const INT_PREFIX: &str = "375";
        /// `"8~10"`
        pub const INT_SELECT: &str = "8~10";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["сту", "лют", "сак", "кра", "май", "чэр", "ліп", "жні", "вер", "кас", "ліс", "сне"]`
        pub const AB_ALT_MON: &[&str] = &["сту", "лют", "сак", "кра", "май", "чэр", "ліп", "жні", "вер", "кас", "ліс", "сне"];
        /// `&["Няд", "Пан", "Аўт", "Срд", "Чцв", "Пят", "Суб"]`
        pub const ABDAY: &[&str] = &["Няд", "Пан", "Аўт", "Срд", "Чцв", "Пят", "Суб"];
        /// `&["сту", "лют", "сак", "кра", "мая", "чэр", "ліп", "жні", "вер", "кас", "ліс", "сне"]`
        pub const ABMON: &[&str] = &["сту", "лют", "сак", "кра", "мая", "чэр", "ліп", "жні", "вер", "кас", "ліс", "сне"];
        /// `&["студзень", "люты", "сакавік", "красавік", "май", "чэрвень", "ліпень", "жнівень", "верасень", "кастрычнік", "лістапад", "снежань"]`
        pub const ALT_MON: &[&str] = &["студзень", "люты", "сакавік", "красавік", "май", "чэрвень", "ліпень", "жнівень", "верасень", "кастрычнік", "лістапад", "снежань"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %d %b %Y %T"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T";
        /// `&["Нядзеля", "Панядзелак", "Аўторак", "Серада", "Чацвер", "Пятніца", "Субота"]`
        pub const DAY: &[&str] = &["Нядзеля", "Панядзелак", "Аўторак", "Серада", "Чацвер", "Пятніца", "Субота"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["студзеня", "лютага", "сакавіка", "красавіка", "мая", "чэрвеня", "ліпеня", "жніўня", "верасня", "кастрычніка", "лістапада", "снежня"]`
        pub const MON: &[&str] = &["студзеня", "лютага", "сакавіка", "красавіка", "мая", "чэрвеня", "ліпеня", "жніўня", "верасня", "кастрычніка", "лістапада", "снежня"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod be_BY_latin {
    pub mod LC_ADDRESS {
        /// `"BY"`
        pub const COUNTRY_ABTWO: &str = "BY";
        /// `"BLR"`
        pub const COUNTRY_AB3: &str = "BLR";
        /// `"BY"`
        pub const COUNTRY_CAR: &str = "BY";
        /// `"Biełaruś"`
        pub const COUNTRY_NAME: &str = "Biełaruś";
        /// `112`
        pub const COUNTRY_NUM: i64 = 112;
        /// `"be"`
        pub const LANG_AB: &str = "be";
        /// `"bel"`
        pub const LANG_LIB: &str = "bel";
        /// `"biełaruskaja"`
        pub const LANG_NAME: &str = "biełaruskaja";
        /// `"bel"`
        pub const LANG_TERM: &str = "bel";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2005-09-15"`
        pub const DATE: &str = "2005-09-15";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Belarusian"`
        pub const LANGUAGE: &str = "Belarusian";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"Belarus"`
        pub const TERRITORY: &str = "Belarus";
        /// `"Belarusian Latin-Script locale for Belarus"`
        pub const TITLE: &str = "Belarusian Latin-Script locale for Belarus";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0Nn]"`
        pub const NOEXPR: &str = "^[-0Nn]";
        /// `"^[+1TtYy]"`
        pub const YESEXPR: &str = "^[+1TtYy]";
    }
    pub mod LC_MONETARY {
        /// `"Rub"`
        pub const CURRENCY_SYMBOL: &str = "Rub";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"BYR "`
        pub const INT_CURR_SYMBOL: &str = "BYR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub use super::be_BY::LC_NUMERIC;
    pub use super::be_BY::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Nia", "Pan", "Aŭt", "Sie", "Čać", "Pia", "Sub"]`
        pub const ABDAY: &[&str] = &["Nia", "Pan", "Aŭt", "Sie", "Čać", "Pia", "Sub"];
        /// `&["Stu", "Lut", "Sak", "Kra", "Maj", "Čer", "Lip", "Žni", "Vie", "Kas", "Lis", "Śni"]`
        pub const ABMON: &[&str] = &["Stu", "Lut", "Sak", "Kra", "Maj", "Čer", "Lip", "Žni", "Vie", "Kas", "Lis", "Śni"];
        /// `&["Studzień", "Luty", "Sakavik", "Krasavik", "Maj", "Červień", "Lipień", "Žnivień", "Vierasień", "Kastryčnik", "Listapad", "Śniežań"]`
        pub const ALT_MON: &[&str] = &["Studzień", "Luty", "Sakavik", "Krasavik", "Maj", "Červień", "Lipień", "Žnivień", "Vierasień", "Kastryčnik", "Listapad", "Śniežań"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %d %b %Y %T"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T";
        /// `&["Niadziela", "Paniadziełak", "Aŭtorak", "Sierada", "Čaćvier", "Piatnica", "Subota"]`
        pub const DAY: &[&str] = &["Niadziela", "Paniadziełak", "Aŭtorak", "Sierada", "Čaćvier", "Piatnica", "Subota"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["studzienia", "lutaha", "sakavika", "krasavika", "maja", "červienia", "lipienia", "žniŭnia", "vieraśnia", "kastryčnika", "listapada", "śniežnia"]`
        pub const MON: &[&str] = &["studzienia", "lutaha", "sakavika", "krasavika", "maja", "červienia", "lipienia", "žniŭnia", "vieraśnia", "kastryčnika", "listapada", "śniežnia"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod bem_ZM {
    pub mod LC_ADDRESS {
        /// `"ZM"`
        pub const COUNTRY_ABTWO: &str = "ZM";
        /// `"ZMB"`
        pub const COUNTRY_AB3: &str = "ZMB";
        /// `"Z"`
        pub const COUNTRY_CAR: &str = "Z";
        /// `"Zambia"`
        pub const COUNTRY_NAME: &str = "Zambia";
        /// `894`
        pub const COUNTRY_NUM: i64 = 894;
        /// `"ZM"`
        pub const COUNTRY_POST: &str = "ZM";
        /// `"bem"`
        pub const LANG_LIB: &str = "bem";
        /// `"Ichibemba"`
        pub const LANG_NAME: &str = "Ichibemba";
        /// `"bem"`
        pub const LANG_TERM: &str = "bem";
        /// `"%a%N%f%N%e %h%N%b %s%N%z%N%T%N%c%N"`
        pub const POSTAL_FMT: &str = "%a%N%f%N%e %h%N%b %s%N%z%N%T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ];
        /// `"Martin Benjamin"`
        pub const CONTACT: &str = "Martin Benjamin";
        /// `"2011-04-18"`
        pub const DATE: &str = "2011-04-18";
        /// `"locales@africanlocalization.net"`
        pub const EMAIL: &str = "locales@africanlocalization.net";
        /// `"Bemba"`
        pub const LANGUAGE: &str = "Bemba";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"ANLoc"`
        pub const SOURCE: &str = "ANLoc";
        /// `"Zambia"`
        pub const TERRITORY: &str = "Zambia";
        /// `"Bemba locale for Zambia"`
        pub const TITLE: &str = "Bemba locale for Zambia";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNaA]"`
        pub const NOEXPR: &str = "^[-0nNaA]";
        /// `"Awe"`
        pub const NOSTR: &str = "Awe";
        /// `"^[+1yYeE]"`
        pub const YESEXPR: &str = "^[+1yYeE]";
        /// `"Ee"`
        pub const YESSTR: &str = "Ee";
    }
    pub mod LC_MONETARY {
        /// `"K"`
        pub const CURRENCY_SYMBOL: &str = "K";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"ZMW "`
        pub const INT_CURR_SYMBOL: &str = "ZMW ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"260"`
        pub const INT_PREFIX: &str = "260";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"%A %l"`
        pub const TEL_DOM_FMT: &str = "%A %l";
        /// `"+%c %A %l"`
        pub const TEL_INT_FMT: &str = "+%c %A %l";
    }
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mac", "Epr", "Mei", "Jun", "Jul", "Oga", "Sep", "Okt", "Nov", "Dis"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mac", "Epr", "Mei", "Jun", "Jul", "Oga", "Sep", "Okt", "Nov", "Dis"];
        /// `&["uluchelo", "akasuba"]`
        pub const AM_PM: &[&str] = &["uluchelo", "akasuba"];
        /// `"%m/%d/%Y"`
        pub const D_FMT: &str = "%m/%d/%Y";
        /// `"%a %d %b %Y %R %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %R %Z";
        /// `&["Pa Mulungu", "Palichimo", "Palichibuli", "Palichitatu", "Palichine", "Palichisano", "Pachibelushi"]`
        pub const DAY: &[&str] = &["Pa Mulungu", "Palichimo", "Palichibuli", "Palichitatu", "Palichine", "Palichisano", "Pachibelushi"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["Januari", "Februari", "Machi", "Epreo", "Mei", "Juni", "Julai", "Ogasti", "Septemba", "Oktoba", "Novemba", "Disemba"]`
        pub const MON: &[&str] = &["Januari", "Februari", "Machi", "Epreo", "Mei", "Juni", "Julai", "Ogasti", "Septemba", "Oktoba", "Novemba", "Disemba"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ber_DZ {
    pub mod LC_ADDRESS {
        /// `"DZ"`
        pub const COUNTRY_ABTWO: &str = "DZ";
        /// `"DZA"`
        pub const COUNTRY_AB3: &str = "DZA";
        /// `"DZ"`
        pub const COUNTRY_CAR: &str = "DZ";
        /// `"Lezzayer"`
        pub const COUNTRY_NAME: &str = "Lezzayer";
        /// `12`
        pub const COUNTRY_NUM: i64 = 12;
        /// `"ber"`
        pub const LANG_LIB: &str = "ber";
        /// `"Tamaziɣt"`
        pub const LANG_NAME: &str = "Tamaziɣt";
        /// `"ber"`
        pub const LANG_TERM: &str = "ber";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
        ];
        /// `"Pablo Saratxaga"`
        pub const CONTACT: &str = "Pablo Saratxaga";
        /// `"2002-04-16"`
        pub const DATE: &str = "2002-04-16";
        /// `"pablo@mandrakesoft.com"`
        pub const EMAIL: &str = "pablo@mandrakesoft.com";
        /// `""`
        pub const FAX: &str = "";
        /// `"Berber"`
        pub const LANGUAGE: &str = "Berber";
        /// `"0.1"`
        pub const REVISION: &str = "0.1";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"Algeria"`
        pub const TERRITORY: &str = "Algeria";
        /// `"Berber language locale for Algeria (latin)"`
        pub const TITLE: &str = "Berber language locale for Algeria (latin)";
    }
    pub use super::kab_DZ::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"د.ج."`
        pub const CURRENCY_SYMBOL: &str = "د.ج.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"DZD "`
        pub const INT_CURR_SYMBOL: &str = "DZD ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"213"`
        pub const INT_PREFIX: &str = "213";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c ;%a ;%l"`
        pub const TEL_INT_FMT: &str = "+%c ;%a ;%l";
    }
    pub mod LC_TIME {
        /// `&["baz", "bir", "iki", "üçü", "dör", "beş", "alt"]`
        pub const ABDAY: &[&str] = &["baz", "bir", "iki", "üçü", "dör", "beş", "alt"];
        /// `&["Yan", "Fev", "Mar", "Apr", "May", "İyn", "İyl", "Avq", "Sen", "Okt", "Noy", "Dek"]`
        pub const ABMON: &[&str] = &["Yan", "Fev", "Mar", "Apr", "May", "İyn", "İyl", "Avq", "Sen", "Okt", "Noy", "Dek"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%A, %d %B %Y %T"`
        pub const D_T_FMT: &str = "%A, %d %B %Y %T";
        /// `&["bazar günü", "birinci gün", "ikinci gün", "üçüncü gün", "dördüncü gün", "beşinci gün", "altıncı gün"]`
        pub const DAY: &[&str] = &["bazar günü", "birinci gün", "ikinci gün", "üçüncü gün", "dördüncü gün", "beşinci gün", "altıncı gün"];
        /// `7`
        pub const FIRST_WEEKDAY: i64 = 7;
        /// `1`
        pub const FIRST_WORKDAY: i64 = 1;
        /// `&["yanvar", "fevral", "mart", "aprel", "may", "iyun", "iyul", "avqust", "sentyabr", "oktyabr", "noyabr", "dekabr"]`
        pub const MON: &[&str] = &["yanvar", "fevral", "mart", "aprel", "may", "iyun", "iyul", "avqust", "sentyabr", "oktyabr", "noyabr", "dekabr"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ber_MA {
    pub mod LC_ADDRESS {
        /// `"MA"`
        pub const COUNTRY_ABTWO: &str = "MA";
        /// `"MAR"`
        pub const COUNTRY_AB3: &str = "MAR";
        /// `"MA"`
        pub const COUNTRY_CAR: &str = "MA";
        /// `"ⵜⴰⴳⵍⴷⵉⵜ ⵏ ⵍⵎⵖⵔⵉⴱ"`
        pub const COUNTRY_NAME: &str = "ⵜⴰⴳⵍⴷⵉⵜ ⵏ ⵍⵎⵖⵔⵉⴱ";
        /// `504`
        pub const COUNTRY_NUM: i64 = 504;
        /// `"ber"`
        pub const LANG_LIB: &str = "ber";
        /// `"ⵜⴰⵎⴰⵣⵉⵖⵜ"`
        pub const LANG_NAME: &str = "ⵜⴰⵎⴰⵣⵉⵖⵜ";
        /// `"ber"`
        pub const LANG_TERM: &str = "ber";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
        ];
        /// `"Pablo Saratxaga"`
        pub const CONTACT: &str = "Pablo Saratxaga";
        /// `"2002-06-26"`
        pub const DATE: &str = "2002-06-26";
        /// `"pablo@mandrakesoft.com"`
        pub const EMAIL: &str = "pablo@mandrakesoft.com";
        /// `""`
        pub const FAX: &str = "";
        /// `"Berber"`
        pub const LANGUAGE: &str = "Berber";
        /// `"0.1"`
        pub const REVISION: &str = "0.1";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"Morocco"`
        pub const TERRITORY: &str = "Morocco";
        /// `"Berber language locale for Morocco (tifinagh)"`
        pub const TITLE: &str = "Berber language locale for Morocco (tifinagh)";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0YyNn]"`
        pub const NOEXPR: &str = "^[-0YyNn]";
        /// `"yox"`
        pub const NOSTR: &str = "yox";
        /// `"^[+1Bb]"`
        pub const YESEXPR: &str = "^[+1Bb]";
        /// `"bəli"`
        pub const YESSTR: &str = "bəli";
    }
    pub mod LC_MONETARY {
        /// `"ⴷ.ⵎ."`
        pub const CURRENCY_SYMBOL: &str = "ⴷ.ⵎ.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"MAD "`
        pub const INT_CURR_SYMBOL: &str = "MAD ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"212"`
        pub const INT_PREFIX: &str = "212";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c ;%a ;%l"`
        pub const TEL_INT_FMT: &str = "+%c ;%a ;%l";
    }
    pub mod LC_TIME {
        /// `&["baz", "bir", "iki", "üçü", "dör", "beş", "alt"]`
        pub const ABDAY: &[&str] = &["baz", "bir", "iki", "üçü", "dör", "beş", "alt"];
        /// `&["Yan", "Fev", "Mar", "Apr", "May", "İyn", "İyl", "Avq", "Sen", "Okt", "Noy", "Dek"]`
        pub const ABMON: &[&str] = &["Yan", "Fev", "Mar", "Apr", "May", "İyn", "İyl", "Avq", "Sen", "Okt", "Noy", "Dek"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%A, %d %B %Y %T"`
        pub const D_T_FMT: &str = "%A, %d %B %Y %T";
        /// `&["bazar günü", "birinci gün", "ikinci gün", "üçüncü gün", "dördüncü gün", "beşinci gün", "altıncı gün"]`
        pub const DAY: &[&str] = &["bazar günü", "birinci gün", "ikinci gün", "üçüncü gün", "dördüncü gün", "beşinci gün", "altıncı gün"];
        /// `7`
        pub const FIRST_WEEKDAY: i64 = 7;
        /// `1`
        pub const FIRST_WORKDAY: i64 = 1;
        /// `&["yanvar", "fevral", "mart", "aprel", "may", "iyun", "iyul", "avqust", "sentyabr", "oktyabr", "noyabr", "dekabr"]`
        pub const MON: &[&str] = &["yanvar", "fevral", "mart", "aprel", "may", "iyun", "iyul", "avqust", "sentyabr", "oktyabr", "noyabr", "dekabr"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod bg_BG {
    pub mod LC_ADDRESS {
        /// `"BG"`
        pub const COUNTRY_ABTWO: &str = "BG";
        /// `"BGR"`
        pub const COUNTRY_AB3: &str = "BGR";
        /// `"BG"`
        pub const COUNTRY_CAR: &str = "BG";
        /// `954`
        pub const COUNTRY_ISBN: i64 = 954;
        /// `"България"`
        pub const COUNTRY_NAME: &str = "България";
        /// `100`
        pub const COUNTRY_NUM: i64 = 100;
        /// `"BG"`
        pub const COUNTRY_POST: &str = "BG";
        /// `"bg"`
        pub const LANG_AB: &str = "bg";
        /// `"bul"`
        pub const LANG_LIB: &str = "bul";
        /// `"български"`
        pub const LANG_NAME: &str = "български";
        /// `"bul"`
        pub const LANG_TERM: &str = "bul";
        /// `"%f%N%a%N%d%N%b%N%sN%h, %e, %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%sN%h, %e, %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"develop@linux.zonebg.com"`
        pub const ADDRESS: &str = "develop@linux.zonebg.com";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `"Delyan Toshev"`
        pub const CONTACT: &str = "Delyan Toshev";
        /// `"2002-09-10"`
        pub const DATE: &str = "2002-09-10";
        /// `"delyant@yahoo.com"`
        pub const EMAIL: &str = "delyant@yahoo.com";
        /// `""`
        pub const FAX: &str = "";
        /// `"Bulgarian"`
        pub const LANGUAGE: &str = "Bulgarian";
        /// `"2.0.1"`
        pub const REVISION: &str = "2.0.1";
        /// `"Linux Society Bulgaria"`
        pub const SOURCE: &str = "Linux Society Bulgaria";
        /// `""`
        pub const TEL: &str = "";
        /// `"Bulgaria"`
        pub const TERRITORY: &str = "Bulgaria";
        /// `"Bulgarian locale for Bulgaria"`
        pub const TITLE: &str = "Bulgarian locale for Bulgaria";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNkKНн]"`
        pub const NOEXPR: &str = "^[-0nNkKНн]";
        /// `"не"`
        pub const NOSTR: &str = "не";
        /// `"^[+1yYdDoOДд]"`
        pub const YESEXPR: &str = "^[+1yYdDoOДд]";
        /// `"да"`
        pub const YESSTR: &str = "да";
    }
    pub mod LC_MONETARY {
        /// `"лв."`
        pub const CURRENCY_SYMBOL: &str = "лв.";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"BGN "`
        pub const INT_CURR_SYMBOL: &str = "BGN ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `""`
        pub const THOUSANDS_SEP: &str = "";
    }
    pub mod LC_TELEPHONE {
        /// `"359"`
        pub const INT_PREFIX: &str = "359";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"(0%a) %l"`
        pub const TEL_DOM_FMT: &str = "(0%a) %l";
        /// `"(+%c %a) %l"`
        pub const TEL_INT_FMT: &str = "(+%c %a) %l";
    }
    pub mod LC_TIME {
        /// `&["нд", "пн", "вт", "ср", "чт", "пт", "сб"]`
        pub const ABDAY: &[&str] = &["нд", "пн", "вт", "ср", "чт", "пт", "сб"];
        /// `&["яну", "фев", "мар", "апр", "май", "юни", "юли", "авг", "сеп", "окт", "ное", "дек"]`
        pub const ABMON: &[&str] = &["яну", "фев", "мар", "апр", "май", "юни", "юли", "авг", "сеп", "окт", "ное", "дек"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%e.%m.%Y"`
        pub const D_FMT: &str = "%e.%m.%Y";
        /// `"%x (%a) %X %Z"`
        pub const D_T_FMT: &str = "%x (%a) %X %Z";
        /// `&["неделя", "понеделник", "вторник", "сряда", "четвъртък", "петък", "събота"]`
        pub const DAY: &[&str] = &["неделя", "понеделник", "вторник", "сряда", "четвъртък", "петък", "събота"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["януари", "февруари", "март", "април", "май", "юни", "юли", "август", "септември", "октомври", "ноември", "декември"]`
        pub const MON: &[&str] = &["януари", "февруари", "март", "април", "май", "юни", "юли", "август", "септември", "октомври", "ноември", "декември"];
        /// `"%k:%M:%S"`
        pub const T_FMT: &str = "%k:%M:%S";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod bhb_IN {
    pub mod LC_ADDRESS {
        /// `"IN"`
        pub const COUNTRY_ABTWO: &str = "IN";
        /// `"IND"`
        pub const COUNTRY_AB3: &str = "IND";
        /// `"IND"`
        pub const COUNTRY_CAR: &str = "IND";
        /// `"भारत"`
        pub const COUNTRY_NAME: &str = "भारत";
        /// `356`
        pub const COUNTRY_NUM: i64 = 356;
        /// `""`
        pub const LANG_AB: &str = "";
        /// `"bhb"`
        pub const LANG_LIB: &str = "bhb";
        /// `"भीली"`
        pub const LANG_NAME: &str = "भीली";
        /// `"bhb"`
        pub const LANG_TERM: &str = "bhb";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2014-09-30"`
        pub const DATE: &str = "2014-09-30";
        /// `"alexey.merzlyakov@samsung.com"`
        pub const EMAIL: &str = "alexey.merzlyakov@samsung.com";
        /// `""`
        pub const FAX: &str = "";
        /// `"Bhili"`
        pub const LANGUAGE: &str = "Bhili";
        /// `"0.1"`
        pub const REVISION: &str = "0.1";
        /// `"Samsung Electronics Co., Ltd."`
        pub const SOURCE: &str = "Samsung Electronics Co., Ltd.";
        /// `""`
        pub const TEL: &str = "";
        /// `"India"`
        pub const TERRITORY: &str = "India";
        /// `"Bhili(devanagari) language locale for India"`
        pub const TITLE: &str = "Bhili(devanagari) language locale for India";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"^[+1yY]"`
        pub const YESEXPR: &str = "^[+1yY]";
    }
    pub use super::hi_IN::LC_MONETARY;
    pub use super::hi_IN::LC_NUMERIC;
    pub use super::hi_IN::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `"%-d/%-m/%y"`
        pub const D_FMT: &str = "%-d/%-m/%y";
        /// `"%A %d %b %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A %d %b %Y %I:%M:%S %p %Z";
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod bho_IN {
    pub mod LC_ADDRESS {
        /// `"IN"`
        pub const COUNTRY_ABTWO: &str = "IN";
        /// `"IND"`
        pub const COUNTRY_AB3: &str = "IND";
        /// `"IND"`
        pub const COUNTRY_CAR: &str = "IND";
        /// `"भारत"`
        pub const COUNTRY_NAME: &str = "भारत";
        /// `356`
        pub const COUNTRY_NUM: i64 = 356;
        /// `"bho"`
        pub const LANG_LIB: &str = "bho";
        /// `"भोजप\u{941}री"`
        pub const LANG_NAME: &str = "भोजप\u{941}री";
        /// `"bho"`
        pub const LANG_TERM: &str = "bho";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2011-12-20"`
        pub const DATE: &str = "2011-12-20";
        /// `"bhashaghar@googlegroups.com"`
        pub const EMAIL: &str = "bhashaghar@googlegroups.com";
        /// `""`
        pub const FAX: &str = "";
        /// `"Bhojpuri"`
        pub const LANGUAGE: &str = "Bhojpuri";
        /// `"0.1"`
        pub const REVISION: &str = "0.1";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"India"`
        pub const TERRITORY: &str = "India";
        /// `"Bhojpuri language locale for India"`
        pub const TITLE: &str = "Bhojpuri language locale for India";
    }
    pub use super::hi_IN::LC_MESSAGES;
    pub use super::hi_IN::LC_MONETARY;
    pub use super::hi_IN::LC_NUMERIC;
    pub use super::hi_IN::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["रवि", "सोम", "म\u{902}गल", "ब\u{941}ध", "ग\u{941}र\u{941}", "श\u{941}क\u{94d}र", "शनि"]`
        pub const ABDAY: &[&str] = &["रवि", "सोम", "म\u{902}गल", "ब\u{941}ध", "ग\u{941}र\u{941}", "श\u{941}क\u{94d}र", "शनि"];
        /// `&["जनवरी", "फरवरी", "मार\u{94d}च", "अप\u{94d}र\u{948}ल", "मई", "ज\u{942}न", "ज\u{941}लाई", "अगस\u{94d}त", "सितम\u{94d}बर", "अक\u{94d}ट\u{942}बर", "नवम\u{94d}बर", "दिसम\u{94d}बर"]`
        pub const ABMON: &[&str] = &["जनवरी", "फरवरी", "मार\u{94d}च", "अप\u{94d}र\u{948}ल", "मई", "ज\u{942}न", "ज\u{941}लाई", "अगस\u{94d}त", "सितम\u{94d}बर", "अक\u{94d}ट\u{942}बर", "नवम\u{94d}बर", "दिसम\u{94d}बर"];
        /// `&["प\u{942}र\u{94d}वाह\u{94d}न", "अपराह\u{94d}न"]`
        pub const AM_PM: &[&str] = &["प\u{942}र\u{94d}वाह\u{94d}न", "अपराह\u{94d}न"];
        /// `"%-d/%-m/%y"`
        pub const D_FMT: &str = "%-d/%-m/%y";
        /// `"%A %d %b %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A %d %b %Y %I:%M:%S %p %Z";
        /// `&["रविवार", "सोमवार", "म\u{902}गलवार", "ब\u{941}धवार", "ग\u{941}र\u{941}वार", "श\u{941}क\u{94d}रवार", "शनिवार"]`
        pub const DAY: &[&str] = &["रविवार", "सोमवार", "म\u{902}गलवार", "ब\u{941}धवार", "ग\u{941}र\u{941}वार", "श\u{941}क\u{94d}रवार", "शनिवार"];
        /// `&["जनवरी", "फरवरी", "मार\u{94d}च", "अप\u{94d}र\u{948}ल", "मई", "ज\u{942}न", "ज\u{941}लाई", "अगस\u{94d}त", "सितम\u{94d}बर", "अक\u{94d}ट\u{942}बर", "नवम\u{94d}बर", "दिसम\u{94d}बर"]`
        pub const MON: &[&str] = &["जनवरी", "फरवरी", "मार\u{94d}च", "अप\u{94d}र\u{948}ल", "मई", "ज\u{942}न", "ज\u{941}लाई", "अगस\u{94d}त", "सितम\u{94d}बर", "अक\u{94d}ट\u{942}बर", "नवम\u{94d}बर", "दिसम\u{94d}बर"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod bho_NP {
    pub mod LC_ADDRESS {
        /// `"NP"`
        pub const COUNTRY_ABTWO: &str = "NP";
        /// `"NPL"`
        pub const COUNTRY_AB3: &str = "NPL";
        /// `"NEP"`
        pub const COUNTRY_CAR: &str = "NEP";
        /// `"न\u{947}पाल"`
        pub const COUNTRY_NAME: &str = "न\u{947}पाल";
        /// `524`
        pub const COUNTRY_NUM: i64 = 524;
        /// `"bho"`
        pub const LANG_LIB: &str = "bho";
        /// `"भोजप\u{941}री"`
        pub const LANG_NAME: &str = "भोजप\u{941}री";
        /// `"bho"`
        pub const LANG_TERM: &str = "bho";
        /// `"%f%N%h%s%N%T"`
        pub const POSTAL_FMT: &str = "%f%N%h%s%N%T";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2017-07-24"`
        pub const DATE: &str = "2017-07-24";
        /// `"akhilesh.k@samusng.com"`
        pub const EMAIL: &str = "akhilesh.k@samusng.com";
        /// `""`
        pub const FAX: &str = "";
        /// `"Bhojpuri"`
        pub const LANGUAGE: &str = "Bhojpuri";
        /// `"0.1"`
        pub const REVISION: &str = "0.1";
        /// `"Samsung Electronics Co., Ltd."`
        pub const SOURCE: &str = "Samsung Electronics Co., Ltd.";
        /// `""`
        pub const TEL: &str = "";
        /// `"Nepal"`
        pub const TERRITORY: &str = "Nepal";
        /// `"Bhojpuri language locale for Nepal"`
        pub const TITLE: &str = "Bhojpuri language locale for Nepal";
    }
    pub use super::bho_IN::LC_MESSAGES;
    pub use super::ne_NP::LC_MONETARY;
    pub use super::ne_NP::LC_NUMERIC;
    pub use super::ne_NP::LC_TELEPHONE;
    pub use super::bho_IN::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod bi_VU {
    pub mod LC_ADDRESS {
        /// `"VU"`
        pub const COUNTRY_ABTWO: &str = "VU";
        /// `"VUT"`
        pub const COUNTRY_AB3: &str = "VUT";
        /// `"VU"`
        pub const COUNTRY_CAR: &str = "VU";
        /// `"Vanuatu"`
        pub const COUNTRY_NAME: &str = "Vanuatu";
        /// `548`
        pub const COUNTRY_NUM: i64 = 548;
        /// `"bi"`
        pub const LANG_AB: &str = "bi";
        /// `"bis"`
        pub const LANG_LIB: &str = "bis";
        /// `"Bislama"`
        pub const LANG_NAME: &str = "Bislama";
        /// `"bis"`
        pub const LANG_TERM: &str = "bis";
        /// `"%a%b%s%c"`
        pub const POSTAL_FMT: &str = "%a%b%s%c";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2017-07-13"`
        pub const DATE: &str = "2017-07-13";
        /// `"akhilesh.k@samsung.com & maninder1.s@samsung.com"`
        pub const EMAIL: &str = "akhilesh.k@samsung.com & maninder1.s@samsung.com";
        /// `""`
        pub const FAX: &str = "";
        /// `"Bislama"`
        pub const LANGUAGE: &str = "Bislama";
        /// `"0.1"`
        pub const REVISION: &str = "0.1";
        /// `"Samsung Electronics Co., Ltd."`
        pub const SOURCE: &str = "Samsung Electronics Co., Ltd.";
        /// `""`
        pub const TEL: &str = "";
        /// `"Vanuatu"`
        pub const TERRITORY: &str = "Vanuatu";
        /// `"Bislama language locale for Vanuatu"`
        pub const TITLE: &str = "Bislama language locale for Vanuatu";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"No"`
        pub const NOSTR: &str = "No";
        /// `"^[+1yY]"`
        pub const YESEXPR: &str = "^[+1yY]";
        /// `"Yes"`
        pub const YESSTR: &str = "Yes";
    }
    pub mod LC_MONETARY {
        /// `"VT"`
        pub const CURRENCY_SYMBOL: &str = "VT";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"VUV "`
        pub const INT_CURR_SYMBOL: &str = "VUV ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `1`
        pub const INT_N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const INT_P_SEP_BY_SPACE: i64 = 1;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"678"`
        pub const INT_PREFIX: &str = "678";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %l"`
        pub const TEL_INT_FMT: &str = "+%c %l";
    }
    pub mod LC_TIME {
        /// `&["San", "Man", "Tus", "Wen", "Tas", "Fra", "Sar"]`
        pub const ABDAY: &[&str] = &["San", "Man", "Tus", "Wen", "Tas", "Fra", "Sar"];
        /// `&["Jan", "Feb", "Maj", "Epr", "Mei", "Jun", "Jul", "Ogs", "Sep", "Okt", "Nov", "Dis"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Maj", "Epr", "Mei", "Jun", "Jul", "Ogs", "Sep", "Okt", "Nov", "Dis"];
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `"%A %d %b %Y"`
        pub const D_FMT: &str = "%A %d %b %Y";
        /// `"%A %d %b %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A %d %b %Y %I:%M:%S %p %Z";
        /// `&["Sande", "Mande", "Tusde", "Wenesde", "Tosde", "Fraede", "Sarere"]`
        pub const DAY: &[&str] = &["Sande", "Mande", "Tusde", "Wenesde", "Tosde", "Fraede", "Sarere"];
        /// `&["Jenuware", "Febwari", "Maj", "Epril", "Mei", "Jun", "Julae", "Ogis", "Septemba", "Oktoba", "Novemba", "Disemba"]`
        pub const MON: &[&str] = &["Jenuware", "Febwari", "Maj", "Epril", "Mei", "Jun", "Julae", "Ogis", "Septemba", "Oktoba", "Novemba", "Disemba"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod bn_BD {
    pub mod LC_ADDRESS {
        /// `"BD"`
        pub const COUNTRY_ABTWO: &str = "BD";
        /// `"BGD"`
        pub const COUNTRY_AB3: &str = "BGD";
        /// `"BD"`
        pub const COUNTRY_CAR: &str = "BD";
        /// `"ব\u{9be}ংল\u{9be}দেশ"`
        pub const COUNTRY_NAME: &str = "ব\u{9be}ংল\u{9be}দেশ";
        /// `50`
        pub const COUNTRY_NUM: i64 = 50;
        /// `"bn"`
        pub const LANG_AB: &str = "bn";
        /// `"ben"`
        pub const LANG_LIB: &str = "ben";
        /// `"ব\u{9be}ংল\u{9be}"`
        pub const LANG_NAME: &str = "ব\u{9be}ংল\u{9be}";
        /// `"ben"`
        pub const LANG_TERM: &str = "ben";
        /// `"%a%N%f%N%d%N%b%N%h %s %e %r%N%T %z%N%c%N"`
        pub const POSTAL_FMT: &str = "%a%N%f%N%d%N%b%N%h %s %e %r%N%T %z%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Dhaka, Bangladesh"`
        pub const ADDRESS: &str = "Dhaka, Bangladesh";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_NAME"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_NAME"],
        ];
        /// `"Taneem Ahmed, Jamil Ahmed"`
        pub const CONTACT: &str = "Taneem Ahmed, Jamil Ahmed";
        /// `"2007-01-10"`
        pub const DATE: &str = "2007-01-10";
        /// `"taneem@bengalinux.org, jamil@bengalinux.org"`
        pub const EMAIL: &str = "taneem@bengalinux.org, jamil@bengalinux.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Bangla"`
        pub const LANGUAGE: &str = "Bangla";
        /// `"0.5"`
        pub const REVISION: &str = "0.5";
        /// `"Ankur Group, http://www.ankurbangla.org, http://www.bengalinux.org"`
        pub const SOURCE: &str = "Ankur Group, http://www.ankurbangla.org, http://www.bengalinux.org";
        /// `""`
        pub const TEL: &str = "";
        /// `"Bangladesh"`
        pub const TERRITORY: &str = "Bangladesh";
        /// `"Bangla language locale for Bangladesh"`
        pub const TITLE: &str = "Bangla language locale for Bangladesh";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNন]"`
        pub const NOEXPR: &str = "^[-0nNন]";
        /// `"ন\u{9be}"`
        pub const NOSTR: &str = "ন\u{9be}";
        /// `"^[+1yYহ]"`
        pub const YESEXPR: &str = "^[+1yYহ]";
        /// `"হ\u{9cd}য\u{9be}\u{981}"`
        pub const YESSTR: &str = "হ\u{9cd}য\u{9be}\u{981}";
    }
    pub mod LC_MONETARY {
        /// `"৳"`
        pub const CURRENCY_SYMBOL: &str = "৳";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"BDT "`
        pub const INT_CURR_SYMBOL: &str = "BDT ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 2]`
        pub const MON_GROUPING: &[i64] = &[3, 2];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 2]`
        pub const GROUPING: &[i64] = &[3, 2];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"880"`
        pub const INT_PREFIX: &str = "880";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"%a %l"`
        pub const TEL_DOM_FMT: &str = "%a %l";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["রবি", "সোম", "মঙ\u{9cd}গল", "ব\u{9c1}ধ", "ব\u{9c3}হঃ", "শ\u{9c1}ক\u{9cd}র", "শনি"]`
        pub const ABDAY: &[&str] = &["রবি", "সোম", "মঙ\u{9cd}গল", "ব\u{9c1}ধ", "ব\u{9c3}হঃ", "শ\u{9c1}ক\u{9cd}র", "শনি"];
        /// `&["জ\u{9be}ন\u{9c1}", "ফেব", "ম\u{9be}র\u{9cd}চ", "এপ\u{9cd}রিল", "মে", "জ\u{9c1}ন", "জ\u{9c1}ল\u{9be}ই", "আগস\u{9cd}ট", "সেপ\u{9cd}টেম\u{9cd}বর", "অক\u{9cd}টোবর", "নভেম\u{9cd}বর", "ডিসেম\u{9cd}বর"]`
        pub const ABMON: &[&str] = &["জ\u{9be}ন\u{9c1}", "ফেব", "ম\u{9be}র\u{9cd}চ", "এপ\u{9cd}রিল", "মে", "জ\u{9c1}ন", "জ\u{9c1}ল\u{9be}ই", "আগস\u{9cd}ট", "সেপ\u{9cd}টেম\u{9cd}বর", "অক\u{9cd}টোবর", "নভেম\u{9cd}বর", "ডিসেম\u{9cd}বর"];
        /// `&["প\u{9c2}র\u{9cd}ব\u{9be}হ\u{9cd}ণ", "অপর\u{9be}হ\u{9cd}ণ"]`
        pub const AM_PM: &[&str] = &["প\u{9c2}র\u{9cd}ব\u{9be}হ\u{9cd}ণ", "অপর\u{9be}হ\u{9cd}ণ"];
        /// `"%-d/%-m/%y"`
        pub const D_FMT: &str = "%-d/%-m/%y";
        /// `"%A %d %b %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A %d %b %Y %I:%M:%S %p %Z";
        /// `&["রবিব\u{9be}র", "সোমব\u{9be}র", "মঙ\u{9cd}গলব\u{9be}র", "ব\u{9c1}ধব\u{9be}র", "ব\u{9c3}হস\u{9cd}পতিব\u{9be}র", "শ\u{9c1}ক\u{9cd}রব\u{9be}র", "শনিব\u{9be}র"]`
        pub const DAY: &[&str] = &["রবিব\u{9be}র", "সোমব\u{9be}র", "মঙ\u{9cd}গলব\u{9be}র", "ব\u{9c1}ধব\u{9be}র", "ব\u{9c3}হস\u{9cd}পতিব\u{9be}র", "শ\u{9c1}ক\u{9cd}রব\u{9be}র", "শনিব\u{9be}র"];
        /// `6`
        pub const FIRST_WEEKDAY: i64 = 6;
        /// `&["জ\u{9be}ন\u{9c1}য\u{9bc}\u{9be}রী", "ফেব\u{9cd}র\u{9c1}য\u{9bc}\u{9be}রী", "ম\u{9be}র\u{9cd}চ", "এপ\u{9cd}রিল", "মে", "জ\u{9c1}ন", "জ\u{9c1}ল\u{9be}ই", "আগস\u{9cd}ট", "সেপ\u{9cd}টেম\u{9cd}বর", "অক\u{9cd}টোবর", "নভেম\u{9cd}বর", "ডিসেম\u{9cd}বর"]`
        pub const MON: &[&str] = &["জ\u{9be}ন\u{9c1}য\u{9bc}\u{9be}রী", "ফেব\u{9cd}র\u{9c1}য\u{9bc}\u{9be}রী", "ম\u{9be}র\u{9cd}চ", "এপ\u{9cd}রিল", "মে", "জ\u{9c1}ন", "জ\u{9c1}ল\u{9be}ই", "আগস\u{9cd}ট", "সেপ\u{9cd}টেম\u{9cd}বর", "অক\u{9cd}টোবর", "নভেম\u{9cd}বর", "ডিসেম\u{9cd}বর"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod bn_IN {
    pub mod LC_ADDRESS {
        /// `"IN"`
        pub const COUNTRY_ABTWO: &str = "IN";
        /// `"IND"`
        pub const COUNTRY_AB3: &str = "IND";
        /// `"IND"`
        pub const COUNTRY_CAR: &str = "IND";
        /// `"ভ\u{9be}রত"`
        pub const COUNTRY_NAME: &str = "ভ\u{9be}রত";
        /// `356`
        pub const COUNTRY_NUM: i64 = 356;
        /// `"bn"`
        pub const LANG_AB: &str = "bn";
        /// `"ben"`
        pub const LANG_LIB: &str = "ben";
        /// `"ব\u{9be}ংল\u{9be}"`
        pub const LANG_NAME: &str = "ব\u{9be}ংল\u{9be}";
        /// `"ben"`
        pub const LANG_TERM: &str = "ben";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan"`
        pub const ADDRESS: &str = "1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `"2006-05-29"`
        pub const DATE: &str = "2006-05-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Bangla"`
        pub const LANGUAGE: &str = "Bangla";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"IBM Globalization Center of Competency, Yamato Software Laboratory"`
        pub const SOURCE: &str = "IBM Globalization Center of Competency, Yamato Software Laboratory";
        /// `""`
        pub const TEL: &str = "";
        /// `"India"`
        pub const TERRITORY: &str = "India";
        /// `"Bangla language locale for India"`
        pub const TITLE: &str = "Bangla language locale for India";
    }
    pub use super::bn_BD::LC_MESSAGES;
    pub use super::hi_IN::LC_MONETARY;
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 2]`
        pub const GROUPING: &[i64] = &[3, 2];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub use super::hi_IN::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["রবি", "সোম", "মঙ\u{9cd}গল", "ব\u{9c1}ধ", "ব\u{9c3}হস\u{9cd}পতি", "শ\u{9c1}ক\u{9cd}র", "শনি"]`
        pub const ABDAY: &[&str] = &["রবি", "সোম", "মঙ\u{9cd}গল", "ব\u{9c1}ধ", "ব\u{9c3}হস\u{9cd}পতি", "শ\u{9c1}ক\u{9cd}র", "শনি"];
        /// `&["জ\u{9be}ন\u{9c1}", "ফেব", "ম\u{9be}র\u{9cd}চ", "এপ\u{9cd}রিল", "মে", "জ\u{9c1}ন", "জ\u{9c1}ল\u{9be}ই", "আগস\u{9cd}ট", "সেপ\u{9cd}টেম\u{9cd}বর", "অক\u{9cd}টোবর", "নভেম\u{9cd}বর", "ডিসেম\u{9cd}বর"]`
        pub const ABMON: &[&str] = &["জ\u{9be}ন\u{9c1}", "ফেব", "ম\u{9be}র\u{9cd}চ", "এপ\u{9cd}রিল", "মে", "জ\u{9c1}ন", "জ\u{9c1}ল\u{9be}ই", "আগস\u{9cd}ট", "সেপ\u{9cd}টেম\u{9cd}বর", "অক\u{9cd}টোবর", "নভেম\u{9cd}বর", "ডিসেম\u{9cd}বর"];
        /// `&["প\u{9c2}র\u{9cd}ব\u{9be}হ\u{9cd}ণ", "অপর\u{9be}হ\u{9cd}ণ"]`
        pub const AM_PM: &[&str] = &["প\u{9c2}র\u{9cd}ব\u{9be}হ\u{9cd}ণ", "অপর\u{9be}হ\u{9cd}ণ"];
        /// `"%-d/%-m/%y"`
        pub const D_FMT: &str = "%-d/%-m/%y";
        /// `"%A %d %b %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A %d %b %Y %I:%M:%S %p %Z";
        /// `&["রবিব\u{9be}র", "সোমব\u{9be}র", "মঙ\u{9cd}গলব\u{9be}র", "ব\u{9c1}ধব\u{9be}র", "ব\u{9c3}হস\u{9cd}পতিব\u{9be}র", "শ\u{9c1}ক\u{9cd}রব\u{9be}র", "শনিব\u{9be}র"]`
        pub const DAY: &[&str] = &["রবিব\u{9be}র", "সোমব\u{9be}র", "মঙ\u{9cd}গলব\u{9be}র", "ব\u{9c1}ধব\u{9be}র", "ব\u{9c3}হস\u{9cd}পতিব\u{9be}র", "শ\u{9c1}ক\u{9cd}রব\u{9be}র", "শনিব\u{9be}র"];
        /// `&["জ\u{9be}ন\u{9c1}য\u{9bc}\u{9be}রী", "ফেব\u{9cd}র\u{9c1}য\u{9bc}\u{9be}রী", "ম\u{9be}র\u{9cd}চ", "এপ\u{9cd}রিল", "মে", "জ\u{9c1}ন", "জ\u{9c1}ল\u{9be}ই", "আগস\u{9cd}ট", "সেপ\u{9cd}টেম\u{9cd}বর", "অক\u{9cd}টোবর", "নভেম\u{9cd}বর", "ডিসেম\u{9cd}বর"]`
        pub const MON: &[&str] = &["জ\u{9be}ন\u{9c1}য\u{9bc}\u{9be}রী", "ফেব\u{9cd}র\u{9c1}য\u{9bc}\u{9be}রী", "ম\u{9be}র\u{9cd}চ", "এপ\u{9cd}রিল", "মে", "জ\u{9c1}ন", "জ\u{9c1}ল\u{9be}ই", "আগস\u{9cd}ট", "সেপ\u{9cd}টেম\u{9cd}বর", "অক\u{9cd}টোবর", "নভেম\u{9cd}বর", "ডিসেম\u{9cd}বর"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod bo_CN {
    pub mod LC_ADDRESS {
        /// `"CN"`
        pub const COUNTRY_ABTWO: &str = "CN";
        /// `"CHN"`
        pub const COUNTRY_AB3: &str = "CHN";
        /// `"CHN"`
        pub const COUNTRY_CAR: &str = "CHN";
        /// `7`
        pub const COUNTRY_ISBN: i64 = 7;
        /// `"ར\u{f92}\u{fb1}་ནག"`
        pub const COUNTRY_NAME: &str = "ར\u{f92}\u{fb1}་ནག";
        /// `156`
        pub const COUNTRY_NUM: i64 = 156;
        /// `"bo"`
        pub const LANG_AB: &str = "bo";
        /// `"tib"`
        pub const LANG_LIB: &str = "tib";
        /// `"བ\u{f7c}ད་ས\u{f90}ད་"`
        pub const LANG_NAME: &str = "བ\u{f7c}ད་ས\u{f90}ད་";
        /// `"bod"`
        pub const LANG_TERM: &str = "bod";
        /// `"%c%N%T%N%s %h %e %r%N%b%N%d%N%f%N%a%N"`
        pub const POSTAL_FMT: &str = "%c%N%T%N%s %h %e %r%N%b%N%d%N%f%N%a%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2007-11-06"`
        pub const DATE: &str = "2007-11-06";
        /// `"bug-glibc@gnu.org"`
        pub const EMAIL: &str = "bug-glibc@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Tibetan"`
        pub const LANGUAGE: &str = "Tibetan";
        /// `"0.1"`
        pub const REVISION: &str = "0.1";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"China"`
        pub const TERRITORY: &str = "China";
        /// `"Tibetan language locale for P.R. of China"`
        pub const TITLE: &str = "Tibetan language locale for P.R. of China";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNམ]"`
        pub const NOEXPR: &str = "^[-0nNམ]";
        /// `"མ\u{f72}ན།"`
        pub const NOSTR: &str = "མ\u{f72}ན།";
        /// `"^[+1yYཨ]"`
        pub const YESEXPR: &str = "^[+1yYཨ]";
        /// `"ཡ\u{f72}ན།"`
        pub const YESSTR: &str = "ཡ\u{f72}ན།";
    }
    pub use super::zh_CN::LC_MONETARY;
    pub use super::zh_CN::LC_NUMERIC;
    pub use super::zh_CN::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["ཉ\u{f72}་", "ཟ\u{fb3}་", "མ\u{f72}ར་", "ལ\u{fb7}ག་", "པ\u{f74}ར་", "སངས་", "ས\u{fa4}\u{f7a}ན་"]`
        pub const ABDAY: &[&str] = &["ཉ\u{f72}་", "ཟ\u{fb3}་", "མ\u{f72}ར་", "ལ\u{fb7}ག་", "པ\u{f74}ར་", "སངས་", "ས\u{fa4}\u{f7a}ན་"];
        /// `&["ཟ\u{fb3}་༡", "ཟ\u{fb3}་༢", "ཟ\u{fb3}་༣", "ཟ\u{fb3}་༤", "ཟ\u{fb3}་༥", "ཟ\u{fb3}་༦", "ཟ\u{fb3}་༧", "ཟ\u{fb3}་༨", "ཟ\u{fb3}་༩", "ཟ\u{fb3}་༡༠", "ཟ\u{fb3}་༡༡", "ཟ\u{fb3}་༡༢"]`
        pub const ABMON: &[&str] = &["ཟ\u{fb3}་༡", "ཟ\u{fb3}་༢", "ཟ\u{fb3}་༣", "ཟ\u{fb3}་༤", "ཟ\u{fb3}་༥", "ཟ\u{fb3}་༦", "ཟ\u{fb3}་༧", "ཟ\u{fb3}་༨", "ཟ\u{fb3}་༩", "ཟ\u{fb3}་༡༠", "ཟ\u{fb3}་༡༡", "ཟ\u{fb3}་༡༢"];
        /// `&["ངས་ཆ", "ཕ\u{fb1}\u{f72}་ཆ"]`
        pub const AM_PM: &[&str] = &["ངས་ཆ", "ཕ\u{fb1}\u{f72}་ཆ"];
        /// `"པས\u{fb1}\u{f72}་ལ\u{f7c}%y\nཟལ%mཚ\u{f7a}ས%d"`
        pub const D_FMT: &str = "པས\u{fb1}\u{f72}་ལ\u{f7c}%y\nཟལ%mཚ\u{f7a}ས%d";
        /// `"པས\u{fb1}\u{f72}་ལ\u{f7c}%yཟལ%mཚ\u{f7a}ས\n%dཆ\u{f74}་ཚ\u{f7c}ད%Hཀསར་མ\n%Mཀསར་ཆ%S"`
        pub const D_T_FMT: &str = "པས\u{fb1}\u{f72}་ལ\u{f7c}%yཟལ%mཚ\u{f7a}ས\n%dཆ\u{f74}་ཚ\u{f7c}ད%Hཀསར་མ\n%Mཀསར་ཆ%S";
        /// `&["གཟའ་ཉ\u{f72}་མ་", "གཟའ་ཟ\u{fb3}་བ་", "གཟའ་མ\u{f72}ག་དམར་", "གཟའ་ལ\u{fb7}ག་ཕ་", "གཟའ་པ\u{f74}ར་བ\u{f74}་", "གཟའ་པ་སངས་", "གཟའ་ས\u{fa4}\u{f7a}ན་ཕ་"]`
        pub const DAY: &[&str] = &["གཟའ་ཉ\u{f72}་མ་", "གཟའ་ཟ\u{fb3}་བ་", "གཟའ་མ\u{f72}ག་དམར་", "གཟའ་ལ\u{fb7}ག་ཕ་", "གཟའ་པ\u{f74}ར་བ\u{f74}་", "གཟའ་པ་སངས་", "གཟའ་ས\u{fa4}\u{f7a}ན་ཕ་"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["ཟ\u{fb3}་བ་དང་པ་", "ཟ\u{fb3}་བ་གཉ\u{f72}ས་པ་", "ཟ\u{fb3}་བ་གས\u{f74}མ་པ་", "ཟ\u{fb3}་བ་བཞ\u{f72}་པ་", "ཟ\u{fb3}་བ་ལ\u{f94}་ཕ་", "ཟ\u{fb3}་བ་ད\u{fb2}\u{f74}ག་པ་", "ཟ\u{fb3}་བ་བད\u{f74}ནཔ་", "ཟ\u{fb3}་བ་བར\u{f92}\u{fb1}ད་པ་", "ཟ\u{fb3}་བ་དག\u{f74}་པ་", "ཟ\u{fb3}་བ་བཅ\u{f74}་པ་", "ཟ\u{fb3}་བ་བཅ\u{f74}་གཅ\u{f72}ག་པ་", "ཟ\u{fb3}་བ་བཅ\u{f74}་གཉ\u{f72}ས་པ་"]`
        pub const MON: &[&str] = &["ཟ\u{fb3}་བ་དང་པ་", "ཟ\u{fb3}་བ་གཉ\u{f72}ས་པ་", "ཟ\u{fb3}་བ་གས\u{f74}མ་པ་", "ཟ\u{fb3}་བ་བཞ\u{f72}་པ་", "ཟ\u{fb3}་བ་ལ\u{f94}་ཕ་", "ཟ\u{fb3}་བ་ད\u{fb2}\u{f74}ག་པ་", "ཟ\u{fb3}་བ་བད\u{f74}ནཔ་", "ཟ\u{fb3}་བ་བར\u{f92}\u{fb1}ད་པ་", "ཟ\u{fb3}་བ་དག\u{f74}་པ་", "ཟ\u{fb3}་བ་བཅ\u{f74}་པ་", "ཟ\u{fb3}་བ་བཅ\u{f74}་གཅ\u{f72}ག་པ་", "ཟ\u{fb3}་བ་བཅ\u{f74}་གཉ\u{f72}ས་པ་"];
        /// `"ཆ\u{f74}་ཚ\u{f7c}ད\n%Hཀསར་མ\n%Mཀསར་ཆ%S"`
        pub const T_FMT: &str = "ཆ\u{f74}་ཚ\u{f7c}ད\n%Hཀསར་མ\n%Mཀསར་ཆ%S";
        /// `"ཆ\u{f74}་ཚ\u{f7c}ད\n%Iཀསར་མ\n%Mཀསར་ཆ%S \n%p"`
        pub const T_FMT_AMPM: &str = "ཆ\u{f74}་ཚ\u{f7c}ད\n%Iཀསར་མ\n%Mཀསར་ཆ%S \n%p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod bo_IN {
    pub mod LC_ADDRESS {
        /// `"IN"`
        pub const COUNTRY_ABTWO: &str = "IN";
        /// `"IND"`
        pub const COUNTRY_AB3: &str = "IND";
        /// `"IND"`
        pub const COUNTRY_CAR: &str = "IND";
        /// `"ར\u{f92}\u{fb1}་གར་"`
        pub const COUNTRY_NAME: &str = "ར\u{f92}\u{fb1}་གར་";
        /// `356`
        pub const COUNTRY_NUM: i64 = 356;
        /// `"bo"`
        pub const LANG_AB: &str = "bo";
        /// `"tib"`
        pub const LANG_LIB: &str = "tib";
        /// `"བ\u{f7c}ད་ས\u{f90}ད་"`
        pub const LANG_NAME: &str = "བ\u{f7c}ད་ས\u{f90}ད་";
        /// `"bod"`
        pub const LANG_TERM: &str = "bod";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2007-11-06"`
        pub const DATE: &str = "2007-11-06";
        /// `"bug-glibc@gnu.org"`
        pub const EMAIL: &str = "bug-glibc@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Tibetan"`
        pub const LANGUAGE: &str = "Tibetan";
        /// `"0.1"`
        pub const REVISION: &str = "0.1";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"India"`
        pub const TERRITORY: &str = "India";
        /// `"Tibetan language locale for India"`
        pub const TITLE: &str = "Tibetan language locale for India";
    }
    pub use super::bo_CN::LC_MESSAGES;
    pub use super::hi_IN::LC_MONETARY;
    pub use super::bo_CN::LC_NUMERIC;
    pub use super::hi_IN::LC_TELEPHONE;
    pub use super::bo_CN::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod br_FR {
    pub mod LC_ADDRESS {
        /// `"FR"`
        pub const COUNTRY_ABTWO: &str = "FR";
        /// `"FRA"`
        pub const COUNTRY_AB3: &str = "FRA";
        /// `"F"`
        pub const COUNTRY_CAR: &str = "F";
        /// `"979-10"`
        pub const COUNTRY_ISBN: &str = "979-10";
        /// `"Frañs"`
        pub const COUNTRY_NAME: &str = "Frañs";
        /// `250`
        pub const COUNTRY_NUM: i64 = 250;
        /// `"br"`
        pub const LANG_AB: &str = "br";
        /// `"bre"`
        pub const LANG_LIB: &str = "bre";
        /// `"brezhoneg"`
        pub const LANG_NAME: &str = "brezhoneg";
        /// `"bre"`
        pub const LANG_TERM: &str = "bre";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
        ];
        /// `"Thierry Vignaud"`
        pub const CONTACT: &str = "Thierry Vignaud";
        /// `"2001-01-28"`
        pub const DATE: &str = "2001-01-28";
        /// `"thierry.vignaud@gmail.com"`
        pub const EMAIL: &str = "thierry.vignaud@gmail.com";
        /// `""`
        pub const FAX: &str = "";
        /// `"Breton"`
        pub const LANGUAGE: &str = "Breton";
        /// `"0.54"`
        pub const REVISION: &str = "0.54";
        /// `"Denise.Peden@enst-bretagne.fr (Denise Derrien-Peden)"`
        pub const SOURCE: &str = "Denise.Peden@enst-bretagne.fr (Denise Derrien-Peden)";
        /// `""`
        pub const TEL: &str = "";
        /// `"France"`
        pub const TERRITORY: &str = "France";
        /// `"Breton language locale for France"`
        pub const TITLE: &str = "Breton language locale for France";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0kKnN]"`
        pub const NOEXPR: &str = "^[-0kKnN]";
        /// `"ket"`
        pub const NOSTR: &str = "ket";
        /// `"^[+1oOyY]"`
        pub const YESEXPR: &str = "^[+1oOyY]";
        /// `"ya"`
        pub const YESSTR: &str = "ya";
    }
    pub use super::fr_FR::LC_MONETARY;
    pub use super::fr_FR::LC_NUMERIC;
    pub use super::fr_FR::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["sul", "lun", "meu", "mer", "yao", "gwe", "sad"]`
        pub const ABDAY: &[&str] = &["sul", "lun", "meu", "mer", "yao", "gwe", "sad"];
        /// `&["Gen ", "Cʼhw", "Meu ", "Ebr ", "Mae ", "Mezh", "Gou ", "Eos ", "Gwe ", "Her ", "Du  ", "Ker "]`
        pub const ABMON: &[&str] = &["Gen ", "Cʼhw", "Meu ", "Ebr ", "Mae ", "Mezh", "Gou ", "Eos ", "Gwe ", "Her ", "Du  ", "Ker "];
        /// `&[" ", " "]`
        pub const AM_PM: &[&str] = &[" ", " "];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"Dʼar %A %d a viz %B %Y"`
        pub const D_T_FMT: &str = "Dʼar %A %d a viz %B %Y";
        /// `&["sul", "lun", "meurzh", "mercʼher", "yaou", "gwener", "sadorn"]`
        pub const DAY: &[&str] = &["sul", "lun", "meurzh", "mercʼher", "yaou", "gwener", "sadorn"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["Genver", "Cʼhwevrer", "Meurzh", "Ebrel", "Mae", "Mezheven", "Gouere", "Eost", "Gwengolo", "Here", "Du", "Kerzu"]`
        pub const MON: &[&str] = &["Genver", "Cʼhwevrer", "Meurzh", "Ebrel", "Mae", "Mezheven", "Gouere", "Eost", "Gwengolo", "Here", "Du", "Kerzu"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%Ie%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%Ie%M:%S %p";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod br_FR_euro {
    pub use super::br_FR::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `"https://www.gnu.org/software/libc/"`
        pub const ADDRESS: &str = "https://www.gnu.org/software/libc/";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `"2002-02-28"`
        pub const DATE: &str = "2002-02-28";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Breton"`
        pub const LANGUAGE: &str = "Breton";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Free Software Foundation, Inc."`
        pub const SOURCE: &str = "Free Software Foundation, Inc.";
        /// `""`
        pub const TEL: &str = "";
        /// `"France"`
        pub const TERRITORY: &str = "France";
        /// `"Breton locale for France with Euro"`
        pub const TITLE: &str = "Breton locale for France with Euro";
    }
    pub use super::br_FR::LC_MESSAGES;
    pub use super::br_FR::LC_MONETARY;
    pub use super::br_FR::LC_NUMERIC;
    pub use super::br_FR::LC_TELEPHONE;
    pub use super::br_FR::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod brx_IN {
    pub mod LC_ADDRESS {
        /// `"IN"`
        pub const COUNTRY_ABTWO: &str = "IN";
        /// `"IND"`
        pub const COUNTRY_AB3: &str = "IND";
        /// `"IND"`
        pub const COUNTRY_CAR: &str = "IND";
        /// `"भारत"`
        pub const COUNTRY_NAME: &str = "भारत";
        /// `356`
        pub const COUNTRY_NUM: i64 = 356;
        /// `"brx"`
        pub const LANG_LIB: &str = "brx";
        /// `"बड\u{93c}ो"`
        pub const LANG_NAME: &str = "बड\u{93c}ो";
        /// `"brx"`
        pub const LANG_TERM: &str = "brx";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Level 1, Tower X, Cybercity, Magarpatta City, Hadapsar, Pune-411013 "`
        pub const ADDRESS: &str = "Level 1, Tower X, Cybercity, Magarpatta City, Hadapsar, Pune-411013 ";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2011-10-17"`
        pub const DATE: &str = "2011-10-17";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Bodo"`
        pub const LANGUAGE: &str = "Bodo";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Red Hat Pune"`
        pub const SOURCE: &str = "Red Hat Pune";
        /// `""`
        pub const TEL: &str = "";
        /// `"India"`
        pub const TERRITORY: &str = "India";
        /// `"Bodo language locale for India"`
        pub const TITLE: &str = "Bodo language locale for India";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNन]"`
        pub const NOEXPR: &str = "^[-0nNन]";
        /// `"नही\u{902}"`
        pub const NOSTR: &str = "नही\u{902}";
        /// `"^[+1yYह]"`
        pub const YESEXPR: &str = "^[+1yYह]";
        /// `"हा\u{901}"`
        pub const YESSTR: &str = "हा\u{901}";
    }
    pub use super::hi_IN::LC_MONETARY;
    pub use super::hi_IN::LC_NUMERIC;
    pub use super::hi_IN::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["रबि", "सम", "म\u{902}गल", "ब\u{941}द", "बिसथि", "स\u{941}ख\u{941}र", "स\u{941}नि"]`
        pub const ABDAY: &[&str] = &["रबि", "सम", "म\u{902}गल", "ब\u{941}द", "बिसथि", "स\u{941}ख\u{941}र", "स\u{941}नि"];
        /// `&["जान\u{941}वारी", "फ\u{947}ब\u{94d}र\u{941}वारी", "मार\u{94d}स", "एप\u{94d}रिल", "म\u{947}", "ज\u{941}न", "ज\u{941}लाइ", "आगस\u{94d}थ", "स\u{947}बथ\u{947}ज\u{94d}ब\u{93c}र", "अखथबर", "नब\u{947}ज\u{94d}ब\u{93c}र", "दिस\u{947}ज\u{94d}ब\u{93c}र"]`
        pub const ABMON: &[&str] = &["जान\u{941}वारी", "फ\u{947}ब\u{94d}र\u{941}वारी", "मार\u{94d}स", "एप\u{94d}रिल", "म\u{947}", "ज\u{941}न", "ज\u{941}लाइ", "आगस\u{94d}थ", "स\u{947}बथ\u{947}ज\u{94d}ब\u{93c}र", "अखथबर", "नब\u{947}ज\u{94d}ब\u{93c}र", "दिस\u{947}ज\u{94d}ब\u{93c}र"];
        /// `&["फ\u{941}\u{902}.", "ब\u{947}लास\u{947}."]`
        pub const AM_PM: &[&str] = &["फ\u{941}\u{902}.", "ब\u{947}लास\u{947}."];
        /// `"%-m/%-d/%y"`
        pub const D_FMT: &str = "%-m/%-d/%y";
        /// `"%A %d %b %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A %d %b %Y %I:%M:%S %p %Z";
        /// `&["रबिबार", "सोबार", "म\u{902}गलबार", "ब\u{941}दबार", "बिसथिबार", "स\u{941}ख\u{941}रबार", "स\u{941}निबार"]`
        pub const DAY: &[&str] = &["रबिबार", "सोबार", "म\u{902}गलबार", "ब\u{941}दबार", "बिसथिबार", "स\u{941}ख\u{941}रबार", "स\u{941}निबार"];
        /// `&["जान\u{941}वारी", "फ\u{947}ब\u{94d}र\u{941}वारी", "मार\u{94d}स", "एफ\u{94d}रिल", "म\u{947}", "ज\u{941}न", "ज\u{941}लाइ", "आगस\u{94d}थ", "स\u{947}बथ\u{947}ज\u{94d}ब\u{93c}र", "अखथबर", "नब\u{947}ज\u{94d}ब\u{93c}र", "दिस\u{947}ज\u{94d}ब\u{93c}र"]`
        pub const MON: &[&str] = &["जान\u{941}वारी", "फ\u{947}ब\u{94d}र\u{941}वारी", "मार\u{94d}स", "एफ\u{94d}रिल", "म\u{947}", "ज\u{941}न", "ज\u{941}लाइ", "आगस\u{94d}थ", "स\u{947}बथ\u{947}ज\u{94d}ब\u{93c}र", "अखथबर", "नब\u{947}ज\u{94d}ब\u{93c}र", "दिस\u{947}ज\u{94d}ब\u{93c}र"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod bs_BA {
    pub mod LC_ADDRESS {
        /// `"BA"`
        pub const COUNTRY_ABTWO: &str = "BA";
        /// `"BIH"`
        pub const COUNTRY_AB3: &str = "BIH";
        /// `"BIH"`
        pub const COUNTRY_CAR: &str = "BIH";
        /// `"Bosna i Hercegovina"`
        pub const COUNTRY_NAME: &str = "Bosna i Hercegovina";
        /// `70`
        pub const COUNTRY_NUM: i64 = 70;
        /// `"bs"`
        pub const LANG_AB: &str = "bs";
        /// `"bos"`
        pub const LANG_LIB: &str = "bos";
        /// `"bosanski"`
        pub const LANG_NAME: &str = "bosanski";
        /// `"bos"`
        pub const LANG_TERM: &str = "bos";
        /// `"%a%N%f%N%d%N%b%N%h %s %e %r%N%T %z%N%c%N"`
        pub const POSTAL_FMT: &str = "%a%N%f%N%d%N%b%N%h %s %e %r%N%T %z%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
        ];
        /// `"Tomislav Vujec"`
        pub const CONTACT: &str = "Tomislav Vujec";
        /// `"2004-01-09"`
        pub const DATE: &str = "2004-01-09";
        /// `"tvujec@carnet.hr"`
        pub const EMAIL: &str = "tvujec@carnet.hr";
        /// `""`
        pub const FAX: &str = "";
        /// `"Bosnian"`
        pub const LANGUAGE: &str = "Bosnian";
        /// `"0.4"`
        pub const REVISION: &str = "0.4";
        /// `"adapted from Croatian locale"`
        pub const SOURCE: &str = "adapted from Croatian locale";
        /// `""`
        pub const TEL: &str = "";
        /// `"Bosnia & Herzegovina"`
        pub const TERRITORY: &str = "Bosnia & Herzegovina";
        /// `"Bosnian language locale for Bosnia and Herzegowina"`
        pub const TITLE: &str = "Bosnian language locale for Bosnia and Herzegowina";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"ne"`
        pub const NOSTR: &str = "ne";
        /// `"^[+1dDyY]"`
        pub const YESEXPR: &str = "^[+1dDyY]";
        /// `"da"`
        pub const YESSTR: &str = "da";
    }
    pub mod LC_MONETARY {
        /// `"KM"`
        pub const CURRENCY_SYMBOL: &str = "KM";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"BAM "`
        pub const INT_CURR_SYMBOL: &str = "BAM ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[0, 0]`
        pub const GROUPING: &[i64] = &[0, 0];
        /// `""`
        pub const THOUSANDS_SEP: &str = "";
    }
    pub mod LC_TELEPHONE {
        /// `"387"`
        pub const INT_PREFIX: &str = "387";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["Ned", "Pon", "Uto", "Sri", "Čet", "Pet", "Sub"]`
        pub const ABDAY: &[&str] = &["Ned", "Pon", "Uto", "Sri", "Čet", "Pet", "Sub"];
        /// `&["Jan", "Feb", "Mar", "Apr", "Maj", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "Maj", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dec"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %d %b %Y %T"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T";
        /// `&["Nedjelja", "Ponedjeljak", "Utorak", "Srijeda", "Četvrtak", "Petak", "Subota"]`
        pub const DAY: &[&str] = &["Nedjelja", "Ponedjeljak", "Utorak", "Srijeda", "Četvrtak", "Petak", "Subota"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["Januar", "Februar", "Mart", "April", "Maj", "Juni", "Juli", "August", "Septembar", "Oktobar", "Novembar", "Decembar"]`
        pub const MON: &[&str] = &["Januar", "Februar", "Mart", "April", "Maj", "Juni", "Juli", "August", "Septembar", "Oktobar", "Novembar", "Decembar"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod byn_ER {
    pub mod LC_ADDRESS {
        /// `"ER"`
        pub const COUNTRY_ABTWO: &str = "ER";
        /// `"ERI"`
        pub const COUNTRY_AB3: &str = "ERI";
        /// `"ER"`
        pub const COUNTRY_CAR: &str = "ER";
        /// `"ኤርትራ"`
        pub const COUNTRY_NAME: &str = "ኤርትራ";
        /// `232`
        pub const COUNTRY_NUM: i64 = 232;
        /// `"ERI"`
        pub const COUNTRY_POST: &str = "ERI";
        /// `""`
        pub const LANG_AB: &str = "";
        /// `"byn"`
        pub const LANG_LIB: &str = "byn";
        /// `"ብሊን"`
        pub const LANG_NAME: &str = "ብሊን";
        /// `"byn"`
        pub const LANG_TERM: &str = "byn";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"7802 Solomon Seal Dr., Springfield, VA 22152, USA"`
        pub const ADDRESS: &str = "7802 Solomon Seal Dr., Springfield, VA 22152, USA";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_TIME"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_TIME"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2003-11-01"`
        pub const DATE: &str = "2003-11-01";
        /// `"locales@geez.org"`
        pub const EMAIL: &str = "locales@geez.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Blin"`
        pub const LANGUAGE: &str = "Blin";
        /// `"0.21"`
        pub const REVISION: &str = "0.21";
        /// `"Ge\'ez Frontier Foundation"`
        pub const SOURCE: &str = "Ge\'ez Frontier Foundation";
        /// `""`
        pub const TEL: &str = "";
        /// `"Eritrea"`
        pub const TERRITORY: &str = "Eritrea";
        /// `"Blin language locale for Eritrea"`
        pub const TITLE: &str = "Blin language locale for Eritrea";
    }
    pub use super::ti_ER::LC_MESSAGES;
    pub use super::ti_ER::LC_MONETARY;
    pub use super::ti_ER::LC_NUMERIC;
    pub use super::ti_ER::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["ሰ/ቅ", "ሰኑ", "ሰሊጝ", "ለጓ", "ኣምድ", "ኣርብ", "ሰ/ሽ"]`
        pub const ABDAY: &[&str] = &["ሰ/ቅ", "ሰኑ", "ሰሊጝ", "ለጓ", "ኣምድ", "ኣርብ", "ሰ/ሽ"];
        /// `&["ልደት", "ካብኽ", "ክብላ", "ፋጅኺ", "ክቢቅ", "ም/ት", "ኰር", "ማርያ", "ያኸኒ", "መተሉ", "ም/ም", "ተሕሳ"]`
        pub const ABMON: &[&str] = &["ልደት", "ካብኽ", "ክብላ", "ፋጅኺ", "ክቢቅ", "ም/ት", "ኰር", "ማርያ", "ያኸኒ", "መተሉ", "ም/ም", "ተሕሳ"];
        /// `&["ፋዱስ ጃብ", "ፋዱስ ደምቢ"]`
        pub const AM_PM: &[&str] = &["ፋዱስ ጃብ", "ፋዱስ ደምቢ"];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%A፡ %B %e ግርጋ %Y %r %Z"`
        pub const D_T_FMT: &str = "%A፡ %B %e ግርጋ %Y %r %Z";
        /// `"%A፡ %B %e ግርጋ %r %Z %Y ኣድ"`
        pub const DATE_FMT: &str = "%A፡ %B %e ግርጋ %r %Z %Y ኣድ";
        /// `&["ሰንበር ቅዳዅ", "ሰኑ", "ሰሊጝ", "ለጓ ወሪ ለብዋ", "ኣምድ", "ኣርብ", "ሰንበር ሽጓዅ"]`
        pub const DAY: &[&str] = &["ሰንበር ቅዳዅ", "ሰኑ", "ሰሊጝ", "ለጓ ወሪ ለብዋ", "ኣምድ", "ኣርብ", "ሰንበር ሽጓዅ"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["ልደትሪ", "ካብኽብቲ", "ክብላ", "ፋጅኺሪ", "ክቢቅሪ", "ምኪኤል ትጓ\u{305}ኒሪ", "ኰርኩ", "ማርያም ትሪ", "ያኸኒ መሳቅለሪ", "መተሉ", "ምኪኤል መሽወሪ", "ተሕሳስሪ"]`
        pub const MON: &[&str] = &["ልደትሪ", "ካብኽብቲ", "ክብላ", "ፋጅኺሪ", "ክቢቅሪ", "ምኪኤል ትጓ\u{305}ኒሪ", "ኰርኩ", "ማርያም ትሪ", "ያኸኒ መሳቅለሪ", "መተሉ", "ምኪኤል መሽወሪ", "ተሕሳስሪ"];
        /// `"%l:%M:%S %p"`
        pub const T_FMT: &str = "%l:%M:%S %p";
        /// `"%l:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%l:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ca_AD {
    pub mod LC_ADDRESS {
        /// `"AD"`
        pub const COUNTRY_ABTWO: &str = "AD";
        /// `"AND"`
        pub const COUNTRY_AB3: &str = "AND";
        /// `"AND"`
        pub const COUNTRY_CAR: &str = "AND";
        /// `"Andorra"`
        pub const COUNTRY_NAME: &str = "Andorra";
        /// `20`
        pub const COUNTRY_NUM: i64 = 20;
        /// `"ca"`
        pub const LANG_AB: &str = "ca";
        /// `"cat"`
        pub const LANG_LIB: &str = "cat";
        /// `"català"`
        pub const LANG_NAME: &str = "català";
        /// `"cat"`
        pub const LANG_TERM: &str = "cat";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2006-01-16"`
        pub const DATE: &str = "2006-01-16";
        /// `""`
        pub const EMAIL: &str = "";
        /// `""`
        pub const FAX: &str = "";
        /// `"Catalan"`
        pub const LANGUAGE: &str = "Catalan";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Robert Millan"`
        pub const SOURCE: &str = "Robert Millan";
        /// `""`
        pub const TEL: &str = "";
        /// `"Andorra"`
        pub const TERRITORY: &str = "Andorra";
        /// `"Catalan locale for Andorra "`
        pub const TITLE: &str = "Catalan locale for Andorra ";
    }
    pub use super::ca_ES::LC_MESSAGES;
    pub use super::ca_ES::LC_MONETARY;
    pub use super::ca_ES::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `"376"`
        pub const INT_PREFIX: &str = "376";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub use super::ca_ES::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ca_ES {
    pub mod LC_ADDRESS {
        /// `"ES"`
        pub const COUNTRY_ABTWO: &str = "ES";
        /// `"ESP"`
        pub const COUNTRY_AB3: &str = "ESP";
        /// `"E"`
        pub const COUNTRY_CAR: &str = "E";
        /// `"Espanya"`
        pub const COUNTRY_NAME: &str = "Espanya";
        /// `724`
        pub const COUNTRY_NUM: i64 = 724;
        /// `"ca"`
        pub const LANG_AB: &str = "ca";
        /// `"cat"`
        pub const LANG_LIB: &str = "cat";
        /// `"català"`
        pub const LANG_NAME: &str = "català";
        /// `"cat"`
        pub const LANG_TERM: &str = "cat";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Catalan"`
        pub const LANGUAGE: &str = "Catalan";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Spain"`
        pub const TERRITORY: &str = "Spain";
        /// `"Catalan locale for Spain"`
        pub const TITLE: &str = "Catalan locale for Spain";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"no"`
        pub const NOSTR: &str = "no";
        /// `"^[+1sSyY]"`
        pub const YESEXPR: &str = "^[+1sSyY]";
        /// `"sí"`
        pub const YESSTR: &str = "sí";
    }
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `"34"`
        pub const INT_PREFIX: &str = "34";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["gen.", "febr.", "març", "abr.", "maig", "juny", "jul.", "ag.", "set.", "oct.", "nov.", "des."]`
        pub const AB_ALT_MON: &[&str] = &["gen.", "febr.", "març", "abr.", "maig", "juny", "jul.", "ag.", "set.", "oct.", "nov.", "des."];
        /// `&["dg.", "dl.", "dt.", "dc.", "dj.", "dv.", "ds."]`
        pub const ABDAY: &[&str] = &["dg.", "dl.", "dt.", "dc.", "dj.", "dv.", "ds."];
        /// `&["de gen.", "de febr.", "de març", "d’abr.", "de maig", "de juny", "de jul.", "d’ag.", "de set.", "d’oct.", "de nov.", "de des."]`
        pub const ABMON: &[&str] = &["de gen.", "de febr.", "de març", "d’abr.", "de maig", "de juny", "de jul.", "d’ag.", "de set.", "d’oct.", "de nov.", "de des."];
        /// `&["gener", "febrer", "març", "abril", "maig", "juny", "juliol", "agost", "setembre", "octubre", "novembre", "desembre"]`
        pub const ALT_MON: &[&str] = &["gener", "febrer", "març", "abril", "maig", "juny", "juliol", "agost", "setembre", "octubre", "novembre", "desembre"];
        /// `&["a. m.", "p. m."]`
        pub const AM_PM: &[&str] = &["a. m.", "p. m."];
        /// `"%-d/%-m/%y"`
        pub const D_FMT: &str = "%-d/%-m/%y";
        /// `"%A, %-d %B de %Y, %T %Z"`
        pub const D_T_FMT: &str = "%A, %-d %B de %Y, %T %Z";
        /// `&["diumenge", "dilluns", "dimarts", "dimecres", "dijous", "divendres", "dissabte"]`
        pub const DAY: &[&str] = &["diumenge", "dilluns", "dimarts", "dimecres", "dijous", "divendres", "dissabte"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["de gener", "de febrer", "de març", "d’abril", "de maig", "de juny", "de juliol", "d’agost", "de setembre", "d’octubre", "de novembre", "de desembre"]`
        pub const MON: &[&str] = &["de gener", "de febrer", "de març", "d’abril", "de maig", "de juny", "de juliol", "d’agost", "de setembre", "d’octubre", "de novembre", "de desembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ca_ES_euro {
    pub use super::ca_ES::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `"https://www.gnu.org/software/libc/"`
        pub const ADDRESS: &str = "https://www.gnu.org/software/libc/";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-08-20"`
        pub const DATE: &str = "2000-08-20";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Catalan"`
        pub const LANGUAGE: &str = "Catalan";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Free Software Foundation, Inc."`
        pub const SOURCE: &str = "Free Software Foundation, Inc.";
        /// `""`
        pub const TEL: &str = "";
        /// `"Spain"`
        pub const TERRITORY: &str = "Spain";
        /// `"Catalan locale for Catalonia with Euro"`
        pub const TITLE: &str = "Catalan locale for Catalonia with Euro";
    }
    pub use super::ca_ES::LC_MESSAGES;
    pub use super::ca_ES::LC_MONETARY;
    pub use super::ca_ES::LC_NUMERIC;
    pub use super::ca_ES::LC_TELEPHONE;
    pub use super::ca_ES::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ca_ES_valencia {
    pub use super::ca_ES::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `"Jordi Mallach"`
        pub const CONTACT: &str = "Jordi Mallach";
        /// `"2006-04-06"`
        pub const DATE: &str = "2006-04-06";
        /// `"jordi@gnu.org"`
        pub const EMAIL: &str = "jordi@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Catalan"`
        pub const LANGUAGE: &str = "Catalan";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"Spain"`
        pub const TERRITORY: &str = "Spain";
        /// `"Valencian (southern Catalan) locale for Spain with Euro"`
        pub const TITLE: &str = "Valencian (southern Catalan) locale for Spain with Euro";
    }
    pub use super::ca_ES::LC_MESSAGES;
    pub use super::ca_ES::LC_MONETARY;
    pub use super::ca_ES::LC_NUMERIC;
    pub use super::ca_ES::LC_TELEPHONE;
    pub use super::ca_ES::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ca_FR {
    pub mod LC_ADDRESS {
        /// `"FR"`
        pub const COUNTRY_ABTWO: &str = "FR";
        /// `"FRA"`
        pub const COUNTRY_AB3: &str = "FRA";
        /// `"F"`
        pub const COUNTRY_CAR: &str = "F";
        /// `"979-10"`
        pub const COUNTRY_ISBN: &str = "979-10";
        /// `"França"`
        pub const COUNTRY_NAME: &str = "França";
        /// `250`
        pub const COUNTRY_NUM: i64 = 250;
        /// `"ca"`
        pub const LANG_AB: &str = "ca";
        /// `"cat"`
        pub const LANG_LIB: &str = "cat";
        /// `"català"`
        pub const LANG_NAME: &str = "català";
        /// `"cat"`
        pub const LANG_TERM: &str = "cat";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2006-01-16"`
        pub const DATE: &str = "2006-01-16";
        /// `""`
        pub const EMAIL: &str = "";
        /// `""`
        pub const FAX: &str = "";
        /// `"Catalan"`
        pub const LANGUAGE: &str = "Catalan";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Robert Millan"`
        pub const SOURCE: &str = "Robert Millan";
        /// `""`
        pub const TEL: &str = "";
        /// `"France"`
        pub const TERRITORY: &str = "France";
        /// `"Catalan locale for France "`
        pub const TITLE: &str = "Catalan locale for France ";
    }
    pub use super::ca_ES::LC_MESSAGES;
    pub use super::ca_ES::LC_MONETARY;
    pub use super::ca_ES::LC_NUMERIC;
    pub use super::fr_FR::LC_TELEPHONE;
    pub use super::ca_ES::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ca_IT {
    pub mod LC_ADDRESS {
        /// `"IT"`
        pub const COUNTRY_ABTWO: &str = "IT";
        /// `"ITA"`
        pub const COUNTRY_AB3: &str = "ITA";
        /// `"I"`
        pub const COUNTRY_CAR: &str = "I";
        /// `"978-88,979-12"`
        pub const COUNTRY_ISBN: &str = "978-88,979-12";
        /// `"Itàlia"`
        pub const COUNTRY_NAME: &str = "Itàlia";
        /// `380`
        pub const COUNTRY_NUM: i64 = 380;
        /// `"ca"`
        pub const LANG_AB: &str = "ca";
        /// `"cat"`
        pub const LANG_LIB: &str = "cat";
        /// `"català"`
        pub const LANG_NAME: &str = "català";
        /// `"cat"`
        pub const LANG_TERM: &str = "cat";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2006-01-16"`
        pub const DATE: &str = "2006-01-16";
        /// `""`
        pub const EMAIL: &str = "";
        /// `""`
        pub const FAX: &str = "";
        /// `"Catalan"`
        pub const LANGUAGE: &str = "Catalan";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Robert Millan"`
        pub const SOURCE: &str = "Robert Millan";
        /// `""`
        pub const TEL: &str = "";
        /// `"Italy"`
        pub const TERRITORY: &str = "Italy";
        /// `"Catalan locale for Italy (L\'Alguer) "`
        pub const TITLE: &str = "Catalan locale for Italy (L\'Alguer) ";
    }
    pub use super::ca_ES::LC_MESSAGES;
    pub use super::ca_ES::LC_MONETARY;
    pub use super::ca_ES::LC_NUMERIC;
    pub use super::it_IT::LC_TELEPHONE;
    pub use super::ca_ES::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ce_RU {
    pub mod LC_ADDRESS {
        /// `"RU"`
        pub const COUNTRY_ABTWO: &str = "RU";
        /// `"RUS"`
        pub const COUNTRY_AB3: &str = "RUS";
        /// `"RUS"`
        pub const COUNTRY_CAR: &str = "RUS";
        /// `"Росси"`
        pub const COUNTRY_NAME: &str = "Росси";
        /// `643`
        pub const COUNTRY_NUM: i64 = 643;
        /// `"ce"`
        pub const LANG_AB: &str = "ce";
        /// `"нохчийн"`
        pub const LANG_NAME: &str = "нохчийн";
        /// `"che"`
        pub const LANG_TERM: &str = "che";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"364024, ChR, Grozny, pr-kt of M. Esambayev, 13"`
        pub const ADDRESS: &str = "364024, ChR, Grozny, pr-kt of M. Esambayev, 13";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ];
        /// `"2014-08-25"`
        pub const DATE: &str = "2014-08-25";
        /// `"Chechen"`
        pub const LANGUAGE: &str = "Chechen";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"ANCHR"`
        pub const SOURCE: &str = "ANCHR";
        /// `"Russia"`
        pub const TERRITORY: &str = "Russia";
        /// `"Chechen locale for RUSSIAN FEDERATION"`
        pub const TITLE: &str = "Chechen locale for RUSSIAN FEDERATION";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNМм]"`
        pub const NOEXPR: &str = "^[-0nNМм]";
        /// `"^[+1yYДд]"`
        pub const YESEXPR: &str = "^[+1yYДд]";
    }
    pub mod LC_MONETARY {
        /// `"₽"`
        pub const CURRENCY_SYMBOL: &str = "₽";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"RUB "`
        pub const INT_CURR_SYMBOL: &str = "RUB ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub use super::ru_RU::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `"7"`
        pub const INT_PREFIX: &str = "7";
        /// `"0~10"`
        pub const INT_SELECT: &str = "0~10";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["КӀ", "Ор", "Ши", "Кх", "Еа", "ПӀ", "Шо"]`
        pub const ABDAY: &[&str] = &["КӀ", "Ор", "Ши", "Кх", "Еа", "ПӀ", "Шо"];
        /// `&["янв", "фев", "мар", "апр", "май", "июн", "июл", "авг", "сен", "окт", "ноя", "дек"]`
        pub const ABMON: &[&str] = &["янв", "фев", "мар", "апр", "май", "июн", "июл", "авг", "сен", "окт", "ноя", "дек"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%Y.%d.%m"`
        pub const D_FMT: &str = "%Y.%d.%m";
        /// `"%Y %d %b %a %T"`
        pub const D_T_FMT: &str = "%Y %d %b %a %T";
        /// `&["КӀиранан де", "Оршотан де", "Шинарин де", "Кхаарин де", "Еарин де", "ПӀераскан де", "Шот де"]`
        pub const DAY: &[&str] = &["КӀиранан де", "Оршотан де", "Шинарин де", "Кхаарин де", "Еарин де", "ПӀераскан де", "Шот де"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["Январь", "Февраль", "Март", "Апрель", "Май", "Июнь", "Июль", "Август", "Сентябрь", "Октябрь", "Ноябрь", "Декабрь"]`
        pub const MON: &[&str] = &["Январь", "Февраль", "Март", "Апрель", "Май", "Июнь", "Июль", "Август", "Сентябрь", "Октябрь", "Ноябрь", "Декабрь"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod chr_US {
    pub mod LC_ADDRESS {
        /// `"US"`
        pub const COUNTRY_ABTWO: &str = "US";
        /// `"USA"`
        pub const COUNTRY_AB3: &str = "USA";
        /// `"USA"`
        pub const COUNTRY_CAR: &str = "USA";
        /// `0`
        pub const COUNTRY_ISBN: i64 = 0;
        /// `"ᏌᏊ ᎢᏳᎾᎵᏍᏔᏅ ᏍᎦᏚᎩ"`
        pub const COUNTRY_NAME: &str = "ᏌᏊ ᎢᏳᎾᎵᏍᏔᏅ ᏍᎦᏚᎩ";
        /// `840`
        pub const COUNTRY_NUM: i64 = 840;
        /// `"USA"`
        pub const COUNTRY_POST: &str = "USA";
        /// `""`
        pub const LANG_AB: &str = "";
        /// `"chr"`
        pub const LANG_LIB: &str = "chr";
        /// `"ᏣᎳᎩ"`
        pub const LANG_NAME: &str = "ᏣᎳᎩ";
        /// `"chr"`
        pub const LANG_TERM: &str = "chr";
        /// `"%a%N%f%N%d%N%b%N%h %s %e %r%N%T, %S %z%N%c%N"`
        pub const POSTAL_FMT: &str = "%a%N%f%N%d%N%b%N%h %s %e %r%N%T, %S %z%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"http://cldr.unicode.org/index/process"`
        pub const ADDRESS: &str = "http://cldr.unicode.org/index/process";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `"Joseph Erb"`
        pub const CONTACT: &str = "Joseph Erb";
        /// `"2010-10-20"`
        pub const DATE: &str = "2010-10-20";
        /// `"josepherb7@gmail.com"`
        pub const EMAIL: &str = "josepherb7@gmail.com";
        /// `""`
        pub const FAX: &str = "";
        /// `"Cherokee"`
        pub const LANGUAGE: &str = "Cherokee";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Cherokee Nation"`
        pub const SOURCE: &str = "Cherokee Nation";
        /// `""`
        pub const TEL: &str = "";
        /// `"United States"`
        pub const TERRITORY: &str = "United States";
        /// `"Cherokee language locale for United States"`
        pub const TITLE: &str = "Cherokee language locale for United States";
    }
    pub mod LC_MESSAGES {
        /// `"^([-0nN]|ᎥᏝ)"`
        pub const NOEXPR: &str = "^([-0nN]|ᎥᏝ)";
        /// `"ᎥᏝ"`
        pub const NOSTR: &str = "ᎥᏝ";
        /// `"^([+1yY]|ᎥᎥ)"`
        pub const YESEXPR: &str = "^([+1yY]|ᎥᎥ)";
        /// `"ᎥᎥ"`
        pub const YESSTR: &str = "ᎥᎥ";
    }
    pub use super::en_US::LC_MONETARY;
    pub use super::en_US::LC_NUMERIC;
    pub use super::en_US::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["ᏆᏍᎬ", "ᏉᏅᎯ", "ᏔᎵᏁ", "ᏦᎢᏁ", "ᏅᎩᏁ", "ᏧᎾᎩ", "ᏈᏕᎾ"]`
        pub const ABDAY: &[&str] = &["ᏆᏍᎬ", "ᏉᏅᎯ", "ᏔᎵᏁ", "ᏦᎢᏁ", "ᏅᎩᏁ", "ᏧᎾᎩ", "ᏈᏕᎾ"];
        /// `&["ᎤᏃ", "ᎧᎦ", "ᎠᏅ", "ᎧᏬ", "ᎠᏂ", "ᏕᎭ", "ᎫᏰ", "ᎦᎶ", "ᏚᎵ", "ᏚᏂ", "ᏅᏓ", "ᎥᏍ"]`
        pub const ABMON: &[&str] = &["ᎤᏃ", "ᎧᎦ", "ᎠᏅ", "ᎧᏬ", "ᎠᏂ", "ᏕᎭ", "ᎫᏰ", "ᎦᎶ", "ᏚᎵ", "ᏚᏂ", "ᏅᏓ", "ᎥᏍ"];
        /// `&["ᏌᎾᎴ", "ᏒᎯᏱᎢᏗᏢ"]`
        pub const AM_PM: &[&str] = &["ᏌᎾᎴ", "ᏒᎯᏱᎢᏗᏢ"];
        /// `"%m/%d/%Y"`
        pub const D_FMT: &str = "%m/%d/%Y";
        /// `"%a %d %b %Y %r %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %r %Z";
        /// `&["ᎤᎾᏙᏓᏆᏍᎬ", "ᎤᎾᏙᏓᏉᏅᎯ", "ᏔᎵᏁᎢᎦ", "ᏦᎢᏁᎢᎦ", "ᏅᎩᏁᎢᎦ", "ᏧᎾᎩᎶᏍᏗ", "ᎤᎾᏙᏓᏈᏕᎾ"]`
        pub const DAY: &[&str] = &["ᎤᎾᏙᏓᏆᏍᎬ", "ᎤᎾᏙᏓᏉᏅᎯ", "ᏔᎵᏁᎢᎦ", "ᏦᎢᏁᎢᎦ", "ᏅᎩᏁᎢᎦ", "ᏧᎾᎩᎶᏍᏗ", "ᎤᎾᏙᏓᏈᏕᎾ"];
        /// `&["ᎤᏃᎸᏔᏅ", "ᎧᎦᎵ", "ᎠᏅᏱ", "ᎧᏬᏂ", "ᎠᏂᏍᎬᏘ", "ᏕᎭᎷᏱ", "ᎫᏰᏉᏂ", "ᎦᎶᏂ", "ᏚᎵᏍᏗ", "ᏚᏂᏅᏗ", "ᏅᏓᏕᏆ", "ᎥᏍᎩᏱ"]`
        pub const MON: &[&str] = &["ᎤᏃᎸᏔᏅ", "ᎧᎦᎵ", "ᎠᏅᏱ", "ᎧᏬᏂ", "ᎠᏂᏍᎬᏘ", "ᏕᎭᎷᏱ", "ᎫᏰᏉᏂ", "ᎦᎶᏂ", "ᏚᎵᏍᏗ", "ᏚᏂᏅᏗ", "ᏅᏓᏕᏆ", "ᎥᏍᎩᏱ"];
        /// `"%r"`
        pub const T_FMT: &str = "%r";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod cmn_TW {
    pub mod LC_ADDRESS {
        /// `"TW"`
        pub const COUNTRY_ABTWO: &str = "TW";
        /// `"TWN"`
        pub const COUNTRY_AB3: &str = "TWN";
        /// `"RC"`
        pub const COUNTRY_CAR: &str = "RC";
        /// `957`
        pub const COUNTRY_ISBN: i64 = 957;
        /// `"中華民國"`
        pub const COUNTRY_NAME: &str = "中華民國";
        /// `158`
        pub const COUNTRY_NUM: i64 = 158;
        /// `"TW"`
        pub const COUNTRY_POST: &str = "TW";
        /// `"cmn"`
        pub const LANG_LIB: &str = "cmn";
        /// `"漢語官話"`
        pub const LANG_NAME: &str = "漢語官話";
        /// `"cmn"`
        pub const LANG_TERM: &str = "cmn";
        /// `"%c%N%T%N%s %h %e %r%N%b%N%d%N%f%N%a%N"`
        pub const POSTAL_FMT: &str = "%c%N%T%N%s %h %e %r%N%b%N%d%N%f%N%a%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2017-07-20"`
        pub const DATE: &str = "2017-07-20";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Mandarin Chinese"`
        pub const LANGUAGE: &str = "Mandarin Chinese";
        /// `"0.2"`
        pub const REVISION: &str = "0.2";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"Taiwan"`
        pub const TERRITORY: &str = "Taiwan";
        /// `"Mandarin Chinese locale for the Republic of China"`
        pub const TITLE: &str = "Mandarin Chinese locale for the Republic of China";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNｎＮ不否]"`
        pub const NOEXPR: &str = "^[-0nNｎＮ不否]";
        /// `"不是"`
        pub const NOSTR: &str = "不是";
        /// `"^[+1yYｙＹ是]"`
        pub const YESEXPR: &str = "^[+1yYｙＹ是]";
        /// `"是"`
        pub const YESSTR: &str = "是";
    }
    pub mod LC_MONETARY {
        /// `"NT$"`
        pub const CURRENCY_SYMBOL: &str = "NT$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"TWD "`
        pub const INT_CURR_SYMBOL: &str = "TWD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `1`
        pub const INT_N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const INT_N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const INT_N_SIGN_POSN: i64 = 1;
        /// `1`
        pub const INT_P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const INT_P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const INT_P_SIGN_POSN: i64 = 1;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `4`
        pub const MON_GROUPING: i64 = 4;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `4`
        pub const GROUPING: i64 = 4;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"886"`
        pub const INT_PREFIX: &str = "886";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"%A-%l"`
        pub const TEL_DOM_FMT: &str = "%A-%l";
        /// `"+%c-%a-%l"`
        pub const TEL_INT_FMT: &str = "+%c-%a-%l";
    }
    pub mod LC_TIME {
        /// `&["日", "一", "二", "三", "四", "五", "六"]`
        pub const ABDAY: &[&str] = &["日", "一", "二", "三", "四", "五", "六"];
        /// `&[" 1月", " 2月", " 3月", " 4月", " 5月", " 6月", " 7月", " 8月", " 9月", "10月", "11月", "12月"]`
        pub const ABMON: &[&str] = &[" 1月", " 2月", " 3月", " 4月", " 5月", " 6月", " 7月", " 8月", " 9月", "10月", "11月", "12月"];
        /// `&["上午", "下午"]`
        pub const AM_PM: &[&str] = &["上午", "下午"];
        /// `"%Y年%m月%d號"`
        pub const D_FMT: &str = "%Y年%m月%d號";
        /// `"%Y年%m月%d號 (%A) %H點%M分%S秒"`
        pub const D_T_FMT: &str = "%Y年%m月%d號 (%A) %H點%M分%S秒";
        /// `"%Y年 %b %-d號 %A %H:%M:%S %Z"`
        pub const DATE_FMT: &str = "%Y年 %b %-d號 %A %H:%M:%S %Z";
        /// `&["星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"]`
        pub const DAY: &[&str] = &["星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"];
        /// `&["+:2:1913/01/01:+*:民國:%EC%Ey年", "+:1:1912/01/01:1912/12/31:民國:%EC元年", "+:1:1911/12/31:-*:民前:%EC%Ey年"]`
        pub const ERA: &[&str] = &["+:2:1913/01/01:+*:民國:%EC%Ey年", "+:1:1912/01/01:1912/12/31:民國:%EC元年", "+:1:1911/12/31:-*:民前:%EC%Ey年"];
        /// `&["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"]`
        pub const MON: &[&str] = &["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"];
        /// `"%H點%M分%S秒"`
        pub const T_FMT: &str = "%H點%M分%S秒";
        /// `"%p %I點%M分%S秒"`
        pub const T_FMT_AMPM: &str = "%p %I點%M分%S秒";
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod crh_UA {
    pub mod LC_ADDRESS {
        /// `"UA"`
        pub const COUNTRY_ABTWO: &str = "UA";
        /// `"UKR"`
        pub const COUNTRY_AB3: &str = "UKR";
        /// `"UA"`
        pub const COUNTRY_CAR: &str = "UA";
        /// `804`
        pub const COUNTRY_NUM: i64 = 804;
        /// `"crh"`
        pub const LANG_LIB: &str = "crh";
        /// `"qırımtatar tili"`
        pub const LANG_NAME: &str = "qırımtatar tili";
        /// `"crh"`
        pub const LANG_TERM: &str = "crh";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
        ];
        /// `"Reşat SABIQ"`
        pub const CONTACT: &str = "Reşat SABIQ";
        /// `"2009-08-16"`
        pub const DATE: &str = "2009-08-16";
        /// `"tilde.birlik@gmail.com"`
        pub const EMAIL: &str = "tilde.birlik@gmail.com";
        /// `""`
        pub const FAX: &str = "";
        /// `"Crimean Tatar"`
        pub const LANGUAGE: &str = "Crimean Tatar";
        /// `"0.4"`
        pub const REVISION: &str = "0.4";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"Ukraine"`
        pub const TERRITORY: &str = "Ukraine";
        /// `"Crimean Tatar (Crimean Turkish) language locale for Ukraine"`
        pub const TITLE: &str = "Crimean Tatar (Crimean Turkish) language locale for Ukraine";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNhH]"`
        pub const NOEXPR: &str = "^[-0nNhH]";
        /// `"hayır"`
        pub const NOSTR: &str = "hayır";
        /// `"^[+1yYeE]"`
        pub const YESEXPR: &str = "^[+1yYeE]";
        /// `"ebet"`
        pub const YESSTR: &str = "ebet";
    }
    pub mod LC_MONETARY {
        /// `"₴"`
        pub const CURRENCY_SYMBOL: &str = "₴";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"UAH "`
        pub const INT_CURR_SYMBOL: &str = "UAH ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `"380"`
        pub const INT_PREFIX: &str = "380";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["Baz", "Ber", "Sal", "Çar", "Caq", "Cum", "Cer"]`
        pub const ABDAY: &[&str] = &["Baz", "Ber", "Sal", "Çar", "Caq", "Cum", "Cer"];
        /// `&["Yan", "Fev", "Mar", "Apr", "May", "İyn", "İyl", "Avg", "Sen", "Okt", "Noy", "Dek"]`
        pub const ABMON: &[&str] = &["Yan", "Fev", "Mar", "Apr", "May", "İyn", "İyl", "Avg", "Sen", "Okt", "Noy", "Dek"];
        /// `&["ÜE", "ÜS"]`
        pub const AM_PM: &[&str] = &["ÜE", "ÜS"];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %d %b %Y %T"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T";
        /// `&["Bazar", "Bazarertesi", "Salı", "Çarşembe", "Cumaaqşamı", "Cuma", "Cumaertesi"]`
        pub const DAY: &[&str] = &["Bazar", "Bazarertesi", "Salı", "Çarşembe", "Cumaaqşamı", "Cuma", "Cumaertesi"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["Yanvar", "Fevral", "Mart", "Aprel", "Mayıs", "İyun", "İyul", "Avgust", "Sentâbr", "Oktâbr", "Noyabr", "Dekabr"]`
        pub const MON: &[&str] = &["Yanvar", "Fevral", "Mart", "Aprel", "Mayıs", "İyun", "İyul", "Avgust", "Sentâbr", "Oktâbr", "Noyabr", "Dekabr"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod cs_CZ {
    pub mod LC_ADDRESS {
        /// `"CZ"`
        pub const COUNTRY_ABTWO: &str = "CZ";
        /// `"CZE"`
        pub const COUNTRY_AB3: &str = "CZE";
        /// `"CZ"`
        pub const COUNTRY_CAR: &str = "CZ";
        /// `"Česká republika"`
        pub const COUNTRY_NAME: &str = "Česká republika";
        /// `203`
        pub const COUNTRY_NUM: i64 = 203;
        /// `"CZ"`
        pub const COUNTRY_POST: &str = "CZ";
        /// `"cs"`
        pub const LANG_AB: &str = "cs";
        /// `"cze"`
        pub const LANG_LIB: &str = "cze";
        /// `"čeština"`
        pub const LANG_NAME: &str = "čeština";
        /// `"ces"`
        pub const LANG_TERM: &str = "ces";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"https://www.gnu.org/software/libc/"`
        pub const ADDRESS: &str = "https://www.gnu.org/software/libc/";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-28"`
        pub const DATE: &str = "2000-06-28";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Czech"`
        pub const LANGUAGE: &str = "Czech";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Free Software Foundation, Inc."`
        pub const SOURCE: &str = "Free Software Foundation, Inc.";
        /// `""`
        pub const TEL: &str = "";
        /// `"Czech Republic"`
        pub const TERRITORY: &str = "Czech Republic";
        /// `"Czech locale for the Czech Republic"`
        pub const TITLE: &str = "Czech locale for the Czech Republic";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"ne"`
        pub const NOSTR: &str = "ne";
        /// `"^[+1aAyY]"`
        pub const YESEXPR: &str = "^[+1aAyY]";
        /// `"ano"`
        pub const YESSTR: &str = "ano";
    }
    pub mod LC_MONETARY {
        /// `"Kč"`
        pub const CURRENCY_SYMBOL: &str = "Kč";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"CZK "`
        pub const INT_CURR_SYMBOL: &str = "CZK ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const THOUSANDS_SEP: &str = "\u{202f}";
    }
    pub mod LC_TELEPHONE {
        /// `"420"`
        pub const INT_PREFIX: &str = "420";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"(0%a) %l"`
        pub const TEL_DOM_FMT: &str = "(0%a) %l";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["Ne", "Po", "Út", "St", "Čt", "Pá", "So"]`
        pub const ABDAY: &[&str] = &["Ne", "Po", "Út", "St", "Čt", "Pá", "So"];
        /// `&["led", "úno", "bře", "dub", "kvě", "čen", "čec", "srp", "zář", "říj", "lis", "pro"]`
        pub const ABMON: &[&str] = &["led", "úno", "bře", "dub", "kvě", "čen", "čec", "srp", "zář", "říj", "lis", "pro"];
        /// `&["leden", "únor", "březen", "duben", "květen", "červen", "červenec", "srpen", "září", "říjen", "listopad", "prosinec"]`
        pub const ALT_MON: &[&str] = &["leden", "únor", "březen", "duben", "květen", "červen", "červenec", "srpen", "září", "říjen", "listopad", "prosinec"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%-d.%-m.%Y"`
        pub const D_FMT: &str = "%-d.%-m.%Y";
        /// `"%a\u{a0}%-d.\u{a0}%B\u{a0}%Y,\u{a0}%H:%M:%S\u{a0}%Z"`
        pub const D_T_FMT: &str = "%a\u{a0}%-d.\u{a0}%B\u{a0}%Y,\u{a0}%H:%M:%S\u{a0}%Z";
        /// `&["Neděle", "Pondělí", "Úterý", "Středa", "Čtvrtek", "Pátek", "Sobota"]`
        pub const DAY: &[&str] = &["Neděle", "Pondělí", "Úterý", "Středa", "Čtvrtek", "Pátek", "Sobota"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["ledna", "února", "března", "dubna", "května", "června", "července", "srpna", "září", "října", "listopadu", "prosince"]`
        pub const MON: &[&str] = &["ledna", "února", "března", "dubna", "května", "června", "července", "srpna", "září", "října", "listopadu", "prosince"];
        /// `"%H:%M:%S"`
        pub const T_FMT: &str = "%H:%M:%S";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod csb_PL {
    pub mod LC_ADDRESS {
        /// `"PL"`
        pub const COUNTRY_ABTWO: &str = "PL";
        /// `"POL"`
        pub const COUNTRY_AB3: &str = "POL";
        /// `"PL"`
        pub const COUNTRY_CAR: &str = "PL";
        /// `"Pòlskô"`
        pub const COUNTRY_NAME: &str = "Pòlskô";
        /// `616`
        pub const COUNTRY_NUM: i64 = 616;
        /// `"csb"`
        pub const LANG_LIB: &str = "csb";
        /// `"kaszëbsczi jãzëk"`
        pub const LANG_NAME: &str = "kaszëbsczi jãzëk";
        /// `"csb"`
        pub const LANG_TERM: &str = "csb";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `"Michal Ostrowski"`
        pub const CONTACT: &str = "Michal Ostrowski";
        /// `"2006-07-25"`
        pub const DATE: &str = "2006-07-25";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Kashubian"`
        pub const LANGUAGE: &str = "Kashubian";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"csb_PL locale"`
        pub const SOURCE: &str = "csb_PL locale";
        /// `""`
        pub const TEL: &str = "";
        /// `"Poland"`
        pub const TERRITORY: &str = "Poland";
        /// `"Kashubian locale for Poland"`
        pub const TITLE: &str = "Kashubian locale for Poland";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"nié"`
        pub const NOSTR: &str = "nié";
        /// `"^[+1JjTtYy]"`
        pub const YESEXPR: &str = "^[+1JjTtYy]";
        /// `"jo"`
        pub const YESSTR: &str = "jo";
    }
    pub use super::pl_PL::LC_MONETARY;
    pub use super::pl_PL::LC_NUMERIC;
    pub use super::pl_PL::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["stë", "gro", "str", "łżë", "môj", "cze", "lëp", "zél", "séw", "ruj", "lës", "gòd"]`
        pub const AB_ALT_MON: &[&str] = &["stë", "gro", "str", "łżë", "môj", "cze", "lëp", "zél", "séw", "ruj", "lës", "gòd"];
        /// `&["nie", "pòn", "wtó", "str", "czw", "pią", "sob"]`
        pub const ABDAY: &[&str] = &["nie", "pòn", "wtó", "str", "czw", "pią", "sob"];
        /// `&["stë", "gro", "str", "łżë", "maj", "cze", "lëp", "zél", "séw", "ruj", "lës", "gòd"]`
        pub const ABMON: &[&str] = &["stë", "gro", "str", "łżë", "maj", "cze", "lëp", "zél", "séw", "ruj", "lës", "gòd"];
        /// `&["stëcznik", "gromicznik", "strëmiannik", "łżëkwiat", "môj", "czerwińc", "lëpińc", "zélnik", "séwnik", "rujan", "lëstopadnik", "gòdnik"]`
        pub const ALT_MON: &[&str] = &["stëcznik", "gromicznik", "strëmiannik", "łżëkwiat", "môj", "czerwińc", "lëpińc", "zélnik", "séwnik", "rujan", "lëstopadnik", "gòdnik"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%Y-%m-%d"`
        pub const D_FMT: &str = "%Y-%m-%d";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["niedzela", "pòniedzôłk", "wtórk", "strzoda", "czwiôrtk", "piątk", "sobòta"]`
        pub const DAY: &[&str] = &["niedzela", "pòniedzôłk", "wtórk", "strzoda", "czwiôrtk", "piątk", "sobòta"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["stëcznika", "gromicznika", "strëmiannika", "łżëkwiata", "maja", "czerwińca", "lëpińca", "zélnika", "séwnika", "rujana", "lëstopadnika", "gòdnika"]`
        pub const MON: &[&str] = &["stëcznika", "gromicznika", "strëmiannika", "łżëkwiata", "maja", "czerwińca", "lëpińca", "zélnika", "séwnika", "rujana", "lëstopadnika", "gòdnika"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod cv_RU {
    pub mod LC_ADDRESS {
        /// `"RU"`
        pub const COUNTRY_ABTWO: &str = "RU";
        /// `"RUS"`
        pub const COUNTRY_AB3: &str = "RUS";
        /// `"RUS"`
        pub const COUNTRY_CAR: &str = "RUS";
        /// `643`
        pub const COUNTRY_NUM: i64 = 643;
        /// `"cv"`
        pub const LANG_AB: &str = "cv";
        /// `"chv"`
        pub const LANG_LIB: &str = "chv";
        /// `"Чӑвашла"`
        pub const LANG_NAME: &str = "Чӑвашла";
        /// `"chv"`
        pub const LANG_TERM: &str = "chv";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jorgens Alle 8, DK-1615 Kobenhavn V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jorgens Alle 8, DK-1615 Kobenhavn V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Chuvash"`
        pub const LANGUAGE: &str = "Chuvash";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Russia"`
        pub const TERRITORY: &str = "Russia";
        /// `"Chuvash locale for Russia"`
        pub const TITLE: &str = "Chuvash locale for Russia";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"^[+1yY]"`
        pub const YESEXPR: &str = "^[+1yY]";
    }
    pub mod LC_MONETARY {
        /// `"₽"`
        pub const CURRENCY_SYMBOL: &str = "₽";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"RUB "`
        pub const INT_CURR_SYMBOL: &str = "RUB ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub use super::ru_RU::LC_NUMERIC;
    pub use super::ru_RU::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["vr", "tn", "yt", "jn", "kş", "er", "šm"]`
        pub const ABDAY: &[&str] = &["vr", "tn", "yt", "jn", "kş", "er", "šm"];
        /// `&["KĂR", "NAR", "PUŠ", "AKA", "ŞU", "ŞĔR", "UTĂ", "ŞUR", "AVĂ", "JUP", "CÜK", "RAŠ"]`
        pub const ABMON: &[&str] = &["KĂR", "NAR", "PUŠ", "AKA", "ŞU", "ŞĔR", "UTĂ", "ŞUR", "AVĂ", "JUP", "CÜK", "RAŠ"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %d %b %Y %T"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T";
        /// `&["vyrsarnikun", "tuntikun", "ytlarikun", "junkun", "kĕşnernikun", "ernekun", "šămatkun"]`
        pub const DAY: &[&str] = &["vyrsarnikun", "tuntikun", "ytlarikun", "junkun", "kĕşnernikun", "ernekun", "šămatkun"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["kărlac", "narăs", "puš", "aka", "şu", "şĕrtme", "ută", "şurla", "avăn", "jupa", "cük", "raštav"]`
        pub const MON: &[&str] = &["kărlac", "narăs", "puš", "aka", "şu", "şĕrtme", "ută", "şurla", "avăn", "jupa", "cük", "raštav"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod cy_GB {
    pub mod LC_ADDRESS {
        /// `"GB"`
        pub const COUNTRY_ABTWO: &str = "GB";
        /// `"GBR"`
        pub const COUNTRY_AB3: &str = "GBR";
        /// `"GB"`
        pub const COUNTRY_CAR: &str = "GB";
        /// `0`
        pub const COUNTRY_ISBN: i64 = 0;
        /// `"Y Deyrnas Unedig"`
        pub const COUNTRY_NAME: &str = "Y Deyrnas Unedig";
        /// `826`
        pub const COUNTRY_NUM: i64 = 826;
        /// `"GB"`
        pub const COUNTRY_POST: &str = "GB";
        /// `"cy"`
        pub const LANG_AB: &str = "cy";
        /// `"wel"`
        pub const LANG_LIB: &str = "wel";
        /// `"Cymraeg"`
        pub const LANG_NAME: &str = "Cymraeg";
        /// `"cym"`
        pub const LANG_TERM: &str = "cym";
        /// `"%d%N%f%N%d%N%b%N%s %h 5e %r%N%C%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%d%N%f%N%d%N%b%N%s %h 5e %r%N%C%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_MONETARY"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_MONETARY"],
        ];
        /// `"Pablo Saratxaga"`
        pub const CONTACT: &str = "Pablo Saratxaga";
        /// `"2004-09-27"`
        pub const DATE: &str = "2004-09-27";
        /// `"pablo@mandrakesoft.com"`
        pub const EMAIL: &str = "pablo@mandrakesoft.com";
        /// `""`
        pub const FAX: &str = "";
        /// `"Welsh"`
        pub const LANGUAGE: &str = "Welsh";
        /// `"0.9"`
        pub const REVISION: &str = "0.9";
        /// `"thanks to Dafydd Tomos (dafydd@imaginet.co.uk)"`
        pub const SOURCE: &str = "thanks to Dafydd Tomos (dafydd@imaginet.co.uk)";
        /// `""`
        pub const TEL: &str = "";
        /// `"United Kingdom"`
        pub const TERRITORY: &str = "United Kingdom";
        /// `"Welsh language locale for Great Britain"`
        pub const TITLE: &str = "Welsh language locale for Great Britain";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"na"`
        pub const NOSTR: &str = "na";
        /// `"^[+1iItTyY]"`
        pub const YESEXPR: &str = "^[+1iItTyY]";
        /// `"ie"`
        pub const YESSTR: &str = "ie";
    }
    pub use super::en_GB::LC_MONETARY;
    pub use super::en_GB::LC_NUMERIC;
    pub use super::en_GB::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Sul", "Llu", "Maw", "Mer", "Iau", "Gwe", "Sad"]`
        pub const ABDAY: &[&str] = &["Sul", "Llu", "Maw", "Mer", "Iau", "Gwe", "Sad"];
        /// `&["Ion", "Chw", "Maw", "Ebr", "Mai", "Meh", "Gor", "Aws", "Med", "Hyd", "Tach", "Rha"]`
        pub const ABMON: &[&str] = &["Ion", "Chw", "Maw", "Ebr", "Mai", "Meh", "Gor", "Aws", "Med", "Hyd", "Tach", "Rha"];
        /// `&["am", "pm"]`
        pub const AM_PM: &[&str] = &["am", "pm"];
        /// `"%d.%m.%y"`
        pub const D_FMT: &str = "%d.%m.%y";
        /// `"Dydd %A %d mis %B %Y %T %Z"`
        pub const D_T_FMT: &str = "Dydd %A %d mis %B %Y %T %Z";
        /// `"%a %e %b %H:%M:%S %Z %Y"`
        pub const DATE_FMT: &str = "%a %e %b %H:%M:%S %Z %Y";
        /// `&["Sul", "Llun", "Mawrth", "Mercher", "Iau", "Gwener", "Sadwrn"]`
        pub const DAY: &[&str] = &["Sul", "Llun", "Mawrth", "Mercher", "Iau", "Gwener", "Sadwrn"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["Ionawr", "Chwefror", "Mawrth", "Ebrill", "Mai", "Mehefin", "Gorffennaf", "Awst", "Medi", "Hydref", "Tachwedd", "Rhagfyr"]`
        pub const MON: &[&str] = &["Ionawr", "Chwefror", "Mawrth", "Ebrill", "Mai", "Mehefin", "Gorffennaf", "Awst", "Medi", "Hydref", "Tachwedd", "Rhagfyr"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%l:%M:%S %P %Z"`
        pub const T_FMT_AMPM: &str = "%l:%M:%S %P %Z";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod da_DK {
    pub mod LC_ADDRESS {
        /// `"DK"`
        pub const COUNTRY_ABTWO: &str = "DK";
        /// `"DNK"`
        pub const COUNTRY_AB3: &str = "DNK";
        /// `"DK"`
        pub const COUNTRY_CAR: &str = "DK";
        /// `"Danmark"`
        pub const COUNTRY_NAME: &str = "Danmark";
        /// `208`
        pub const COUNTRY_NUM: i64 = 208;
        /// `"da"`
        pub const LANG_AB: &str = "da";
        /// `"dan"`
        pub const LANG_LIB: &str = "dan";
        /// `"dansk"`
        pub const LANG_NAME: &str = "dansk";
        /// `"dan"`
        pub const LANG_TERM: &str = "dan";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Kollegievej 6, DK-2920 Charlottenlund, Danmark"`
        pub const ADDRESS: &str = "Kollegievej 6, DK-2920 Charlottenlund, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Danish"`
        pub const LANGUAGE: &str = "Danish";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Danish Standards Association"`
        pub const SOURCE: &str = "Danish Standards Association";
        /// `""`
        pub const TEL: &str = "";
        /// `"Denmark"`
        pub const TERRITORY: &str = "Denmark";
        /// `"Danish locale for Denmark"`
        pub const TITLE: &str = "Danish locale for Denmark";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0Nn]"`
        pub const NOEXPR: &str = "^[-0Nn]";
        /// `"nej"`
        pub const NOSTR: &str = "nej";
        /// `"^[+1JjYy]"`
        pub const YESEXPR: &str = "^[+1JjYy]";
        /// `"ja"`
        pub const YESSTR: &str = "ja";
    }
    pub mod LC_MONETARY {
        /// `"kr."`
        pub const CURRENCY_SYMBOL: &str = "kr.";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"DKK "`
        pub const INT_CURR_SYMBOL: &str = "DKK ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `2`
        pub const N_SEP_BY_SPACE: i64 = 2;
        /// `4`
        pub const N_SIGN_POSN: i64 = 4;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `2`
        pub const P_SEP_BY_SPACE: i64 = 2;
        /// `4`
        pub const P_SIGN_POSN: i64 = 4;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `"45"`
        pub const INT_PREFIX: &str = "45";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["søn", "man", "tir", "ons", "tor", "fre", "lør"]`
        pub const ABDAY: &[&str] = &["søn", "man", "tir", "ons", "tor", "fre", "lør"];
        /// `&["jan", "feb", "mar", "apr", "maj", "jun", "jul", "aug", "sep", "okt", "nov", "dec"]`
        pub const ABMON: &[&str] = &["jan", "feb", "mar", "apr", "maj", "jun", "jul", "aug", "sep", "okt", "nov", "dec"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d-%m-%Y"`
        pub const D_FMT: &str = "%d-%m-%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `"%a %e %b %H:%M:%S %Z %Y"`
        pub const DATE_FMT: &str = "%a %e %b %H:%M:%S %Z %Y";
        /// `&["søndag", "mandag", "tirsdag", "onsdag", "torsdag", "fredag", "lørdag"]`
        pub const DAY: &[&str] = &["søndag", "mandag", "tirsdag", "onsdag", "torsdag", "fredag", "lørdag"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["januar", "februar", "marts", "april", "maj", "juni", "juli", "august", "september", "oktober", "november", "december"]`
        pub const MON: &[&str] = &["januar", "februar", "marts", "april", "maj", "juni", "juli", "august", "september", "oktober", "november", "december"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod de_AT {
    pub mod LC_ADDRESS {
        /// `"AT"`
        pub const COUNTRY_ABTWO: &str = "AT";
        /// `"AUT"`
        pub const COUNTRY_AB3: &str = "AUT";
        /// `"A"`
        pub const COUNTRY_CAR: &str = "A";
        /// `"Österreich"`
        pub const COUNTRY_NAME: &str = "Österreich";
        /// `40`
        pub const COUNTRY_NUM: i64 = 40;
        /// `"de"`
        pub const LANG_AB: &str = "de";
        /// `"ger"`
        pub const LANG_LIB: &str = "ger";
        /// `"Deutsch"`
        pub const LANG_NAME: &str = "Deutsch";
        /// `"deu"`
        pub const LANG_TERM: &str = "deu";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Postfach 130, A-1021 Wien"`
        pub const ADDRESS: &str = "Postfach 130, A-1021 Wien";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `"Gerhard Budin"`
        pub const CONTACT: &str = "Gerhard Budin";
        /// `"2000-06-28"`
        pub const DATE: &str = "2000-06-28";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Austrian German"`
        pub const LANGUAGE: &str = "Austrian German";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"O:sterreiches Normungsinstitut"`
        pub const SOURCE: &str = "O:sterreiches Normungsinstitut";
        /// `""`
        pub const TEL: &str = "";
        /// `"Austria"`
        pub const TERRITORY: &str = "Austria";
        /// `"German locale for Austria"`
        pub const TITLE: &str = "German locale for Austria";
    }
    pub use super::de_DE::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub use super::de_DE::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `"43"`
        pub const INT_PREFIX: &str = "43";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"%a %l"`
        pub const TEL_DOM_FMT: &str = "%a %l";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"]`
        pub const ABDAY: &[&str] = &["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"];
        /// `&["Jän", "Feb", "Mär", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"]`
        pub const ABMON: &[&str] = &["Jän", "Feb", "Mär", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%Y-%m-%d"`
        pub const D_FMT: &str = "%Y-%m-%d";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"]`
        pub const DAY: &[&str] = &["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["Jänner", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"]`
        pub const MON: &[&str] = &["Jänner", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod de_AT_euro {
    pub use super::de_AT::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `"Postfach 130, A-1021 Wien"`
        pub const ADDRESS: &str = "Postfach 130, A-1021 Wien";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `"Gerhard Budin"`
        pub const CONTACT: &str = "Gerhard Budin";
        /// `"2000-08-20"`
        pub const DATE: &str = "2000-08-20";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"German"`
        pub const LANGUAGE: &str = "German";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"O:sterreiches Normungsinstitut"`
        pub const SOURCE: &str = "O:sterreiches Normungsinstitut";
        /// `""`
        pub const TEL: &str = "";
        /// `"Austria"`
        pub const TERRITORY: &str = "Austria";
        /// `"German locale for Austria with Euro"`
        pub const TITLE: &str = "German locale for Austria with Euro";
    }
    pub use super::de_AT::LC_MESSAGES;
    pub use super::de_AT::LC_MONETARY;
    pub use super::de_AT::LC_NUMERIC;
    pub use super::de_AT::LC_TELEPHONE;
    pub use super::de_AT::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod de_BE {
    pub mod LC_ADDRESS {
        /// `"BE"`
        pub const COUNTRY_ABTWO: &str = "BE";
        /// `"BEL"`
        pub const COUNTRY_AB3: &str = "BEL";
        /// `"B"`
        pub const COUNTRY_CAR: &str = "B";
        /// `"Belgien"`
        pub const COUNTRY_NAME: &str = "Belgien";
        /// `56`
        pub const COUNTRY_NUM: i64 = 56;
        /// `"de"`
        pub const LANG_AB: &str = "de";
        /// `"ger"`
        pub const LANG_LIB: &str = "ger";
        /// `"Deutsch"`
        pub const LANG_NAME: &str = "Deutsch";
        /// `"deu"`
        pub const LANG_TERM: &str = "deu";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"German"`
        pub const LANGUAGE: &str = "German";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Belgium"`
        pub const TERRITORY: &str = "Belgium";
        /// `"German locale for Belgium"`
        pub const TITLE: &str = "German locale for Belgium";
    }
    pub use super::de_DE::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `4`
        pub const N_SIGN_POSN: i64 = 4;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `4`
        pub const P_SIGN_POSN: i64 = 4;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub use super::de_DE::LC_NUMERIC;
    pub use super::fr_BE::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"]`
        pub const ABDAY: &[&str] = &["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"];
        /// `&["Jan", "Feb", "Mär", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mär", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%Y-%m-%d"`
        pub const D_FMT: &str = "%Y-%m-%d";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"]`
        pub const DAY: &[&str] = &["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["Januar", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"]`
        pub const MON: &[&str] = &["Januar", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod de_BE_euro {
    pub use super::de_BE::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `"https://www.gnu.org/software/libc/"`
        pub const ADDRESS: &str = "https://www.gnu.org/software/libc/";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-08-21"`
        pub const DATE: &str = "2000-08-21";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"German"`
        pub const LANGUAGE: &str = "German";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Free Software Foundation, Inc."`
        pub const SOURCE: &str = "Free Software Foundation, Inc.";
        /// `""`
        pub const TEL: &str = "";
        /// `"Belgium"`
        pub const TERRITORY: &str = "Belgium";
        /// `"German locale for Belgium with Euro"`
        pub const TITLE: &str = "German locale for Belgium with Euro";
    }
    pub use super::de_BE::LC_MESSAGES;
    pub use super::de_BE::LC_MONETARY;
    pub use super::de_BE::LC_NUMERIC;
    pub use super::de_BE::LC_TELEPHONE;
    pub use super::de_BE::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod de_CH {
    pub mod LC_ADDRESS {
        /// `"CH"`
        pub const COUNTRY_ABTWO: &str = "CH";
        /// `"CHE"`
        pub const COUNTRY_AB3: &str = "CHE";
        /// `"CH"`
        pub const COUNTRY_CAR: &str = "CH";
        /// `"Schweiz"`
        pub const COUNTRY_NAME: &str = "Schweiz";
        /// `756`
        pub const COUNTRY_NUM: i64 = 756;
        /// `"de"`
        pub const LANG_AB: &str = "de";
        /// `"ger"`
        pub const LANG_LIB: &str = "ger";
        /// `"Deutsch"`
        pub const LANG_NAME: &str = "Deutsch";
        /// `"deu"`
        pub const LANG_TERM: &str = "deu";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2007-09-23"`
        pub const DATE: &str = "2007-09-23";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Swiss High German"`
        pub const LANGUAGE: &str = "Swiss High German";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Switzerland"`
        pub const TERRITORY: &str = "Switzerland";
        /// `"German locale for Switzerland"`
        pub const TITLE: &str = "German locale for Switzerland";
    }
    pub use super::de_DE::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"CHF"`
        pub const CURRENCY_SYMBOL: &str = "CHF";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"CHF "`
        pub const INT_CURR_SYMBOL: &str = "CHF ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"’"`
        pub const MON_THOUSANDS_SEP: &str = "’";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `4`
        pub const N_SIGN_POSN: i64 = 4;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `4`
        pub const P_SIGN_POSN: i64 = 4;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"’"`
        pub const THOUSANDS_SEP: &str = "’";
    }
    pub mod LC_TELEPHONE {
        /// `"41"`
        pub const INT_PREFIX: &str = "41";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"]`
        pub const ABDAY: &[&str] = &["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"];
        /// `&["Jan", "Feb", "Mär", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mär", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"]`
        pub const DAY: &[&str] = &["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["Januar", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"]`
        pub const MON: &[&str] = &["Januar", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod de_DE {
    pub mod LC_ADDRESS {
        /// `"DE"`
        pub const COUNTRY_ABTWO: &str = "DE";
        /// `"DEU"`
        pub const COUNTRY_AB3: &str = "DEU";
        /// `"D"`
        pub const COUNTRY_CAR: &str = "D";
        /// `3`
        pub const COUNTRY_ISBN: i64 = 3;
        /// `"Deutschland"`
        pub const COUNTRY_NAME: &str = "Deutschland";
        /// `276`
        pub const COUNTRY_NUM: i64 = 276;
        /// `"D"`
        pub const COUNTRY_POST: &str = "D";
        /// `"de"`
        pub const LANG_AB: &str = "de";
        /// `"ger"`
        pub const LANG_LIB: &str = "ger";
        /// `"Deutsch"`
        pub const LANG_NAME: &str = "Deutsch";
        /// `"deu"`
        pub const LANG_TERM: &str = "deu";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"https://www.gnu.org/software/libc/"`
        pub const ADDRESS: &str = "https://www.gnu.org/software/libc/";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-24"`
        pub const DATE: &str = "2000-06-24";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"German"`
        pub const LANGUAGE: &str = "German";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Free Software Foundation, Inc."`
        pub const SOURCE: &str = "Free Software Foundation, Inc.";
        /// `""`
        pub const TEL: &str = "";
        /// `"Germany"`
        pub const TERRITORY: &str = "Germany";
        /// `"German locale for Germany"`
        pub const TITLE: &str = "German locale for Germany";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"nein"`
        pub const NOSTR: &str = "nein";
        /// `"^[+1jJyY]"`
        pub const YESEXPR: &str = "^[+1jJyY]";
        /// `"ja"`
        pub const YESSTR: &str = "ja";
    }
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `"49"`
        pub const INT_PREFIX: &str = "49";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"%A %l"`
        pub const TEL_DOM_FMT: &str = "%A %l";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"]`
        pub const ABDAY: &[&str] = &["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"];
        /// `&["Jan", "Feb", "Mär", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mär", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `"%a %-d. %b %H:%M:%S %Z %Y"`
        pub const DATE_FMT: &str = "%a %-d. %b %H:%M:%S %Z %Y";
        /// `&["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"]`
        pub const DAY: &[&str] = &["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["Januar", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"]`
        pub const MON: &[&str] = &["Januar", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod de_DE_euro {
    pub use super::de_DE::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `"https://www.gnu.org/software/libc/"`
        pub const ADDRESS: &str = "https://www.gnu.org/software/libc/";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-24"`
        pub const DATE: &str = "2000-06-24";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"German"`
        pub const LANGUAGE: &str = "German";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Free Software Foundation, Inc."`
        pub const SOURCE: &str = "Free Software Foundation, Inc.";
        /// `""`
        pub const TEL: &str = "";
        /// `"Germany"`
        pub const TERRITORY: &str = "Germany";
        /// `"German locale for Germany with Euro"`
        pub const TITLE: &str = "German locale for Germany with Euro";
    }
    pub use super::de_DE::LC_MESSAGES;
    pub use super::de_DE::LC_MONETARY;
    pub use super::de_DE::LC_NUMERIC;
    pub use super::de_DE::LC_TELEPHONE;
    pub use super::de_DE::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod de_IT {
    pub mod LC_ADDRESS {
        /// `"IT"`
        pub const COUNTRY_ABTWO: &str = "IT";
        /// `"ITA"`
        pub const COUNTRY_AB3: &str = "ITA";
        /// `"I"`
        pub const COUNTRY_CAR: &str = "I";
        /// `"978-88,979-12"`
        pub const COUNTRY_ISBN: &str = "978-88,979-12";
        /// `"Italien"`
        pub const COUNTRY_NAME: &str = "Italien";
        /// `380`
        pub const COUNTRY_NUM: i64 = 380;
        /// `"de"`
        pub const LANG_AB: &str = "de";
        /// `"ger"`
        pub const LANG_LIB: &str = "ger";
        /// `"Deutsch"`
        pub const LANG_NAME: &str = "Deutsch";
        /// `"deu"`
        pub const LANG_TERM: &str = "deu";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"I-39100 Bolzano/Bozen"`
        pub const ADDRESS: &str = "I-39100 Bolzano/Bozen";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `"Matthias Dieter Wallno:fer"`
        pub const CONTACT: &str = "Matthias Dieter Wallno:fer";
        /// `"2000-06-28"`
        pub const DATE: &str = "2000-06-28";
        /// `"libc-locales@sourceware.org"`
        pub const EMAIL: &str = "libc-locales@sourceware.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"German"`
        pub const LANGUAGE: &str = "German";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"Italy"`
        pub const TERRITORY: &str = "Italy";
        /// `"German language locale for Italy"`
        pub const TITLE: &str = "German language locale for Italy";
    }
    pub use super::de_DE::LC_MESSAGES;
    pub use super::it_IT::LC_MONETARY;
    pub use super::de_DE::LC_NUMERIC;
    pub use super::it_IT::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"]`
        pub const ABDAY: &[&str] = &["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"];
        /// `&["Jän", "Feb", "Mär", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"]`
        pub const ABMON: &[&str] = &["Jän", "Feb", "Mär", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `"%a %-d. %b %H:%M:%S %Z %Y"`
        pub const DATE_FMT: &str = "%a %-d. %b %H:%M:%S %Z %Y";
        /// `&["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"]`
        pub const DAY: &[&str] = &["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["Jänner", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"]`
        pub const MON: &[&str] = &["Jänner", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod de_LI {
    pub mod LC_ADDRESS {
        /// `"LI"`
        pub const COUNTRY_ABTWO: &str = "LI";
        /// `"LIE"`
        pub const COUNTRY_AB3: &str = "LIE";
        /// `"FL"`
        pub const COUNTRY_CAR: &str = "FL";
        /// `"Liechtenstein"`
        pub const COUNTRY_NAME: &str = "Liechtenstein";
        /// `438`
        pub const COUNTRY_NUM: i64 = 438;
        /// `"LI"`
        pub const COUNTRY_POST: &str = "LI";
        /// `"de"`
        pub const LANG_AB: &str = "de";
        /// `"ger"`
        pub const LANG_LIB: &str = "ger";
        /// `"Deutsch"`
        pub const LANG_NAME: &str = "Deutsch";
        /// `"deu"`
        pub const LANG_TERM: &str = "deu";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2007-11-27"`
        pub const DATE: &str = "2007-11-27";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"German"`
        pub const LANGUAGE: &str = "German";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"Liechtenstein"`
        pub const TERRITORY: &str = "Liechtenstein";
        /// `"German locale for Liechtenstein"`
        pub const TITLE: &str = "German locale for Liechtenstein";
    }
    pub use super::de_CH::LC_MESSAGES;
    pub use super::de_CH::LC_MONETARY;
    pub use super::de_CH::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `"423"`
        pub const INT_PREFIX: &str = "423";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub use super::de_CH::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod de_LU {
    pub mod LC_ADDRESS {
        /// `"LU"`
        pub const COUNTRY_ABTWO: &str = "LU";
        /// `"LUX"`
        pub const COUNTRY_AB3: &str = "LUX";
        /// `"L"`
        pub const COUNTRY_CAR: &str = "L";
        /// `"Luxemburg"`
        pub const COUNTRY_NAME: &str = "Luxemburg";
        /// `442`
        pub const COUNTRY_NUM: i64 = 442;
        /// `"de"`
        pub const LANG_AB: &str = "de";
        /// `"ger"`
        pub const LANG_LIB: &str = "ger";
        /// `"Deutsch"`
        pub const LANG_NAME: &str = "Deutsch";
        /// `"deu"`
        pub const LANG_TERM: &str = "deu";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"German"`
        pub const LANGUAGE: &str = "German";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Luxembourg"`
        pub const TERRITORY: &str = "Luxembourg";
        /// `"German locale for Luxemburg"`
        pub const TITLE: &str = "German locale for Luxemburg";
    }
    pub use super::de_DE::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `4`
        pub const N_SIGN_POSN: i64 = 4;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `4`
        pub const P_SIGN_POSN: i64 = 4;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub use super::de_DE::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `"352"`
        pub const INT_PREFIX: &str = "352";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"]`
        pub const ABDAY: &[&str] = &["So", "Mo", "Di", "Mi", "Do", "Fr", "Sa"];
        /// `&["Jan", "Feb", "Mär", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mär", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Dez"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%Y-%m-%d"`
        pub const D_FMT: &str = "%Y-%m-%d";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"]`
        pub const DAY: &[&str] = &["Sonntag", "Montag", "Dienstag", "Mittwoch", "Donnerstag", "Freitag", "Samstag"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["Januar", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"]`
        pub const MON: &[&str] = &["Januar", "Februar", "März", "April", "Mai", "Juni", "Juli", "August", "September", "Oktober", "November", "Dezember"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod de_LU_euro {
    pub use super::de_LU::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `"https://www.gnu.org/software/libc/"`
        pub const ADDRESS: &str = "https://www.gnu.org/software/libc/";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-08-20"`
        pub const DATE: &str = "2000-08-20";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"German"`
        pub const LANGUAGE: &str = "German";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Free Software Foundation, Inc."`
        pub const SOURCE: &str = "Free Software Foundation, Inc.";
        /// `""`
        pub const TEL: &str = "";
        /// `"Luxembourg"`
        pub const TERRITORY: &str = "Luxembourg";
        /// `"German locale for Luxemburg with Euro"`
        pub const TITLE: &str = "German locale for Luxemburg with Euro";
    }
    pub use super::de_DE::LC_MESSAGES;
    pub use super::de_LU::LC_MONETARY;
    pub use super::de_DE::LC_NUMERIC;
    pub use super::de_LU::LC_TELEPHONE;
    pub use super::de_LU::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod doi_IN {
    pub mod LC_ADDRESS {
        /// `"IN"`
        pub const COUNTRY_ABTWO: &str = "IN";
        /// `"IND"`
        pub const COUNTRY_AB3: &str = "IND";
        /// `"IND"`
        pub const COUNTRY_CAR: &str = "IND";
        /// `"भारत"`
        pub const COUNTRY_NAME: &str = "भारत";
        /// `356`
        pub const COUNTRY_NUM: i64 = 356;
        /// `"doi"`
        pub const LANG_LIB: &str = "doi";
        /// `"डोगरी"`
        pub const LANG_NAME: &str = "डोगरी";
        /// `"doi"`
        pub const LANG_TERM: &str = "doi";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Level 1, Tower X, Cybercity, Magarpatta City, Hadapsar, Pune-411013 "`
        pub const ADDRESS: &str = "Level 1, Tower X, Cybercity, Magarpatta City, Hadapsar, Pune-411013 ";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2012-02-16"`
        pub const DATE: &str = "2012-02-16";
        /// `"libc-alpha@sourceware.org"`
        pub const EMAIL: &str = "libc-alpha@sourceware.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Dogri"`
        pub const LANGUAGE: &str = "Dogri";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Red Hat Pune"`
        pub const SOURCE: &str = "Red Hat Pune";
        /// `""`
        pub const TEL: &str = "";
        /// `"India"`
        pub const TERRITORY: &str = "India";
        /// `"Dogri language locale for India"`
        pub const TITLE: &str = "Dogri language locale for India";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNन]"`
        pub const NOEXPR: &str = "^[-0nNन]";
        /// `"ना"`
        pub const NOSTR: &str = "ना";
        /// `"^[+1yYऑ]"`
        pub const YESEXPR: &str = "^[+1yYऑ]";
        /// `"ऑह"`
        pub const YESSTR: &str = "ऑह";
    }
    pub use super::hi_IN::LC_MONETARY;
    pub use super::hi_IN::LC_NUMERIC;
    pub use super::hi_IN::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["ऐत", "सोम", "म\u{902}गल", "ब\u{941}ध", "बीर", "श\u{941}क\u{94d}कर", "श\u{94d}नीचर"]`
        pub const ABDAY: &[&str] = &["ऐत", "सोम", "म\u{902}गल", "ब\u{941}ध", "बीर", "श\u{941}क\u{94d}कर", "श\u{94d}नीचर"];
        /// `&["जनवरी", "फरवरी", "मार\u{94d}च", "एप\u{94d}र\u{948}ल", "म\u{947}ई", "ज\u{942}न", "ज\u{942}ल\u{948}", "अगस\u{94d}त", "सित\u{902}बर", "अक\u{94d}त\u{942}बर", "नव\u{902}बर", "दिस\u{902}बर"]`
        pub const ABMON: &[&str] = &["जनवरी", "फरवरी", "मार\u{94d}च", "एप\u{94d}र\u{948}ल", "म\u{947}ई", "ज\u{942}न", "ज\u{942}ल\u{948}", "अगस\u{94d}त", "सित\u{902}बर", "अक\u{94d}त\u{942}बर", "नव\u{902}बर", "दिस\u{902}बर"];
        /// `&["सञ\u{902}", "सब\u{947}र"]`
        pub const AM_PM: &[&str] = &["सञ\u{902}", "सब\u{947}र"];
        /// `"%-d/%-m/%y"`
        pub const D_FMT: &str = "%-d/%-m/%y";
        /// `"%A %d %b %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A %d %b %Y %I:%M:%S %p %Z";
        /// `&["ऐतबार", "सोमबार", "म\u{902}गलबर", "ब\u{941}धबार", "बीरबार", "श\u{941}क\u{94d}करबार", "श\u{94d}नीचरबार"]`
        pub const DAY: &[&str] = &["ऐतबार", "सोमबार", "म\u{902}गलबर", "ब\u{941}धबार", "बीरबार", "श\u{941}क\u{94d}करबार", "श\u{94d}नीचरबार"];
        /// `&["जनवरी", "फरवरी", "मार\u{94d}च", "एप\u{94d}र\u{948}ल", "म\u{947}ई", "ज\u{942}न", "ज\u{942}ल\u{948}", "अगस\u{94d}त", "सित\u{902}बर", "अक\u{94d}त\u{942}बर", "नव\u{902}बर", "दिस\u{902}बर"]`
        pub const MON: &[&str] = &["जनवरी", "फरवरी", "मार\u{94d}च", "एप\u{94d}र\u{948}ल", "म\u{947}ई", "ज\u{942}न", "ज\u{942}ल\u{948}", "अगस\u{94d}त", "सित\u{902}बर", "अक\u{94d}त\u{942}बर", "नव\u{902}बर", "दिस\u{902}बर"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod dsb_DE {
    pub mod LC_ADDRESS {
        /// `"DE"`
        pub const COUNTRY_ABTWO: &str = "DE";
        /// `"DEU"`
        pub const COUNTRY_AB3: &str = "DEU";
        /// `"D"`
        pub const COUNTRY_CAR: &str = "D";
        /// `3`
        pub const COUNTRY_ISBN: i64 = 3;
        /// `"Nimska"`
        pub const COUNTRY_NAME: &str = "Nimska";
        /// `276`
        pub const COUNTRY_NUM: i64 = 276;
        /// `"D"`
        pub const COUNTRY_POST: &str = "D";
        /// `""`
        pub const LANG_AB: &str = "";
        /// `"dsb"`
        pub const LANG_LIB: &str = "dsb";
        /// `"dolnoserbšćina"`
        pub const LANG_NAME: &str = "dolnoserbšćina";
        /// `"dsb"`
        pub const LANG_TERM: &str = "dsb";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `""`
        pub const DATE: &str = "";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Lower Sorbian"`
        pub const LANGUAGE: &str = "Lower Sorbian";
        /// `"0.1"`
        pub const REVISION: &str = "0.1";
        /// `"Information from Michael Wolf"`
        pub const SOURCE: &str = "Information from Michael Wolf";
        /// `""`
        pub const TEL: &str = "";
        /// `"Germany"`
        pub const TERRITORY: &str = "Germany";
        /// `"Lower Sorbian locale for Germany"`
        pub const TITLE: &str = "Lower Sorbian locale for Germany";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"ně"`
        pub const NOSTR: &str = "ně";
        /// `"^[+1jJhHyY]"`
        pub const YESEXPR: &str = "^[+1jJhHyY]";
        /// `"jo"`
        pub const YESSTR: &str = "jo";
    }
    pub use super::de_DE::LC_MONETARY;
    pub use super::de_DE::LC_NUMERIC;
    pub use super::de_DE::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Nj", "Pó", "Wa", "Sr", "St", "Pě", "So"]`
        pub const ABDAY: &[&str] = &["Nj", "Pó", "Wa", "Sr", "St", "Pě", "So"];
        /// `&["Jan", "Feb", "Měr", "Apr", "Maj", "Jun", "Jul", "Awg", "Sep", "Okt", "Now", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Měr", "Apr", "Maj", "Jun", "Jul", "Awg", "Sep", "Okt", "Now", "Dec"];
        /// `&["Januar", "Februar", "Měrc", "Apryl", "Maj", "Junij", "Julij", "Awgust", "September", "Oktober", "Nowember", "December"]`
        pub const ALT_MON: &[&str] = &["Januar", "Februar", "Měrc", "Apryl", "Maj", "Junij", "Julij", "Awgust", "September", "Oktober", "Nowember", "December"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["Njeźela", "Pónjeźele", "Wałtora", "Srjoda", "Stwórtk", "Pětk", "Sobota"]`
        pub const DAY: &[&str] = &["Njeźela", "Pónjeźele", "Wałtora", "Srjoda", "Stwórtk", "Pětk", "Sobota"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["januara", "februara", "měrca", "apryla", "maja", "junija", "julija", "awgusta", "septembra", "oktobra", "nowembra", "decembra"]`
        pub const MON: &[&str] = &["januara", "februara", "měrca", "apryla", "maja", "junija", "julija", "awgusta", "septembra", "oktobra", "nowembra", "decembra"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod dv_MV {
    pub mod LC_ADDRESS {
        /// `"MV"`
        pub const COUNTRY_ABTWO: &str = "MV";
        /// `"MDV"`
        pub const COUNTRY_AB3: &str = "MDV";
        /// `"MV"`
        pub const COUNTRY_CAR: &str = "MV";
        /// `"ދ\u{7a8}ވ\u{7ac}ހ\u{7a8}ރ\u{7a7}އ\u{7b0}ޖ\u{7ac}"`
        pub const COUNTRY_NAME: &str = "ދ\u{7a8}ވ\u{7ac}ހ\u{7a8}ރ\u{7a7}އ\u{7b0}ޖ\u{7ac}";
        /// `462`
        pub const COUNTRY_NUM: i64 = 462;
        /// `"dv"`
        pub const LANG_AB: &str = "dv";
        /// `"div"`
        pub const LANG_LIB: &str = "div";
        /// `"ދ\u{7a8}ވ\u{7ac}ހ\u{7a8}"`
        pub const LANG_NAME: &str = "ދ\u{7a8}ވ\u{7ac}ހ\u{7a8}";
        /// `"div"`
        pub const LANG_TERM: &str = "div";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2006-05-13"`
        pub const DATE: &str = "2006-05-13";
        /// `"sofwath@hotmail.com"`
        pub const EMAIL: &str = "sofwath@hotmail.com";
        /// `""`
        pub const FAX: &str = "";
        /// `"Divehi"`
        pub const LANGUAGE: &str = "Divehi";
        /// `"0.1"`
        pub const REVISION: &str = "0.1";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"Maldives"`
        pub const TERRITORY: &str = "Maldives";
        /// `"Dhivehi Language Locale for Maldives"`
        pub const TITLE: &str = "Dhivehi Language Locale for Maldives";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"^[+1yY]"`
        pub const YESEXPR: &str = "^[+1yY]";
    }
    pub mod LC_MONETARY {
        /// `"ރ."`
        pub const CURRENCY_SYMBOL: &str = "ރ.";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"MVR "`
        pub const INT_CURR_SYMBOL: &str = "MVR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const P_SIGN_POSN: i64 = 2;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"960"`
        pub const INT_PREFIX: &str = "960";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"%a %l"`
        pub const TEL_DOM_FMT: &str = "%a %l";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["އ\u{7a7}ދ\u{7a9}އ\u{7b0}ތ\u{7a6}", "ހ\u{7af}މ\u{7a6}", "އ\u{7a6}ނ\u{7b0}ގ\u{7a7}ރ\u{7a6}", "ބ\u{7aa}ދ\u{7a6}", "ބ\u{7aa}ރ\u{7a7}ސ\u{7b0}ފ\u{7a6}ތ\u{7a8}", "ހ\u{7aa}ކ\u{7aa}ރ\u{7aa}", "ހ\u{7ae}ނ\u{7a8}ހ\u{7a8}ރ\u{7aa}"]`
        pub const ABDAY: &[&str] = &["އ\u{7a7}ދ\u{7a9}އ\u{7b0}ތ\u{7a6}", "ހ\u{7af}މ\u{7a6}", "އ\u{7a6}ނ\u{7b0}ގ\u{7a7}ރ\u{7a6}", "ބ\u{7aa}ދ\u{7a6}", "ބ\u{7aa}ރ\u{7a7}ސ\u{7b0}ފ\u{7a6}ތ\u{7a8}", "ހ\u{7aa}ކ\u{7aa}ރ\u{7aa}", "ހ\u{7ae}ނ\u{7a8}ހ\u{7a8}ރ\u{7aa}"];
        /// `&["ޖ\u{7ac}ނ\u{7aa}އ\u{7a6}ރ\u{7a9}", "ފ\u{7ac}ބ\u{7b0}ރ\u{7aa}އ\u{7a6}ރ\u{7a9}", "މ\u{7a7}ރޗ\u{7b0}", "އ\u{7ac}ޕ\u{7b0}ރ\u{7a9}ލ\u{7b0}", "މ\u{7ac}އ\u{7a8}", "ޖ\u{7ab}ނ\u{7b0}", "ޖ\u{7aa}ލ\u{7a6}އ\u{7a8}", "އ\u{7ae}ގ\u{7a6}ސ\u{7b0}ޓ\u{7b0}", "ސ\u{7ac}ޕ\u{7b0}ޓ\u{7ac}ނ\u{7b0}ބ\u{7a6}ރ", "އ\u{7ae}ކ\u{7b0}ޓ\u{7ab}ބ\u{7a6}ރ", "ނ\u{7ae}ވ\u{7ac}ނ\u{7b0}ބ\u{7a6}ރ", "ޑ\u{7a8}ސ\u{7ac}ނ\u{7b0}ބ\u{7a6}ރ"]`
        pub const ABMON: &[&str] = &["ޖ\u{7ac}ނ\u{7aa}އ\u{7a6}ރ\u{7a9}", "ފ\u{7ac}ބ\u{7b0}ރ\u{7aa}އ\u{7a6}ރ\u{7a9}", "މ\u{7a7}ރޗ\u{7b0}", "އ\u{7ac}ޕ\u{7b0}ރ\u{7a9}ލ\u{7b0}", "މ\u{7ac}އ\u{7a8}", "ޖ\u{7ab}ނ\u{7b0}", "ޖ\u{7aa}ލ\u{7a6}އ\u{7a8}", "އ\u{7ae}ގ\u{7a6}ސ\u{7b0}ޓ\u{7b0}", "ސ\u{7ac}ޕ\u{7b0}ޓ\u{7ac}ނ\u{7b0}ބ\u{7a6}ރ", "އ\u{7ae}ކ\u{7b0}ޓ\u{7ab}ބ\u{7a6}ރ", "ނ\u{7ae}ވ\u{7ac}ނ\u{7b0}ބ\u{7a6}ރ", "ޑ\u{7a8}ސ\u{7ac}ނ\u{7b0}ބ\u{7a6}ރ"];
        /// `&["މކ", "މފ"]`
        pub const AM_PM: &[&str] = &["މކ", "މފ"];
        /// `3`
        pub const CAL_DIRECTION: i64 = 3;
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%Z %H:%M:%S %Y %b %d %a"`
        pub const D_T_FMT: &str = "%Z %H:%M:%S %Y %b %d %a";
        /// `&["އ\u{7a7}ދ\u{7a9}އ\u{7b0}ތ\u{7a6}", "ހ\u{7af}މ\u{7a6}", "އ\u{7a6}ނ\u{7b0}ގ\u{7a7}ރ\u{7a6}", "ބ\u{7aa}ދ\u{7a6}", "ބ\u{7aa}ރ\u{7a7}ސ\u{7b0}ފ\u{7a6}ތ\u{7a8}", "ހ\u{7aa}ކ\u{7aa}ރ\u{7aa}", "ހ\u{7ae}ނ\u{7a8}ހ\u{7a8}ރ\u{7aa}"]`
        pub const DAY: &[&str] = &["އ\u{7a7}ދ\u{7a9}އ\u{7b0}ތ\u{7a6}", "ހ\u{7af}މ\u{7a6}", "އ\u{7a6}ނ\u{7b0}ގ\u{7a7}ރ\u{7a6}", "ބ\u{7aa}ދ\u{7a6}", "ބ\u{7aa}ރ\u{7a7}ސ\u{7b0}ފ\u{7a6}ތ\u{7a8}", "ހ\u{7aa}ކ\u{7aa}ރ\u{7aa}", "ހ\u{7ae}ނ\u{7a8}ހ\u{7a8}ރ\u{7aa}"];
        /// `6`
        pub const FIRST_WEEKDAY: i64 = 6;
        /// `&["ޖ\u{7ac}ނ\u{7aa}އ\u{7a6}ރ\u{7a9}", "ފ\u{7ac}ބ\u{7b0}ރ\u{7aa}އ\u{7a6}ރ\u{7a9}", "މ\u{7a7}ރޗ\u{7b0}", "އ\u{7ac}ޕ\u{7b0}ރ\u{7a9}ލ\u{7b0}", "މ\u{7ac}އ\u{7a8}", "ޖ\u{7ab}ނ\u{7b0}", "ޖ\u{7aa}ލ\u{7a6}އ\u{7a8}", "އ\u{7ae}ގ\u{7a6}ސ\u{7b0}ޓ\u{7b0}", "ސ\u{7ac}ޕ\u{7b0}ޓ\u{7ac}ނ\u{7b0}ބ\u{7a6}ރ", "އ\u{7ae}ކ\u{7b0}ޓ\u{7ab}ބ\u{7a6}ރ", "ނ\u{7ae}ވ\u{7ac}ނ\u{7b0}ބ\u{7a6}ރ", "ޑ\u{7a8}ސ\u{7ac}ނ\u{7b0}ބ\u{7a6}ރ"]`
        pub const MON: &[&str] = &["ޖ\u{7ac}ނ\u{7aa}އ\u{7a6}ރ\u{7a9}", "ފ\u{7ac}ބ\u{7b0}ރ\u{7aa}އ\u{7a6}ރ\u{7a9}", "މ\u{7a7}ރޗ\u{7b0}", "އ\u{7ac}ޕ\u{7b0}ރ\u{7a9}ލ\u{7b0}", "މ\u{7ac}އ\u{7a8}", "ޖ\u{7ab}ނ\u{7b0}", "ޖ\u{7aa}ލ\u{7a6}އ\u{7a8}", "އ\u{7ae}ގ\u{7a6}ސ\u{7b0}ޓ\u{7b0}", "ސ\u{7ac}ޕ\u{7b0}ޓ\u{7ac}ނ\u{7b0}ބ\u{7a6}ރ", "އ\u{7ae}ކ\u{7b0}ޓ\u{7ab}ބ\u{7a6}ރ", "ނ\u{7ae}ވ\u{7ac}ނ\u{7b0}ބ\u{7a6}ރ", "ޑ\u{7a8}ސ\u{7ac}ނ\u{7b0}ބ\u{7a6}ރ"];
        /// `"%H:%M:%S"`
        pub const T_FMT: &str = "%H:%M:%S";
        /// `"%P %I:%M:%S"`
        pub const T_FMT_AMPM: &str = "%P %I:%M:%S";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod dz_BT {
    pub mod LC_ADDRESS {
        /// `"BT"`
        pub const COUNTRY_ABTWO: &str = "BT";
        /// `"BTN"`
        pub const COUNTRY_AB3: &str = "BTN";
        /// `"BHT"`
        pub const COUNTRY_CAR: &str = "BHT";
        /// `"འབ\u{fb2}\u{f74}ག"`
        pub const COUNTRY_NAME: &str = "འབ\u{fb2}\u{f74}ག";
        /// `64`
        pub const COUNTRY_NUM: i64 = 64;
        /// `"dz"`
        pub const LANG_AB: &str = "dz";
        /// `"dzo"`
        pub const LANG_LIB: &str = "dzo";
        /// `"ར\u{fab}\u{f7c}ང་ཁ"`
        pub const LANG_NAME: &str = "ར\u{fab}\u{f7c}ང་ཁ";
        /// `"dzo"`
        pub const LANG_TERM: &str = "dzo";
        /// `"%f%N%a%N%d%N%r%t%e%t%b%N%h%t%s%N%T%N%S%N%z%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%r%t%e%t%b%N%h%t%s%N%T%N%S%N%z%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Kanglung, Bhutan"`
        pub const ADDRESS: &str = "Kanglung, Bhutan";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2004-09-03"`
        pub const DATE: &str = "2004-09-03";
        /// `"bug-glibc@gnu.org"`
        pub const EMAIL: &str = "bug-glibc@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Dzongkha"`
        pub const LANGUAGE: &str = "Dzongkha";
        /// `"0.3"`
        pub const REVISION: &str = "0.3";
        /// `"Sherubtse College"`
        pub const SOURCE: &str = "Sherubtse College";
        /// `""`
        pub const TEL: &str = "";
        /// `"Bhutan"`
        pub const TERRITORY: &str = "Bhutan";
        /// `"Dzongkha language locale for Bhutan"`
        pub const TITLE: &str = "Dzongkha language locale for Bhutan";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNམ]"`
        pub const NOEXPR: &str = "^[-0nNམ]";
        /// `"མ\u{f7a}ན་"`
        pub const NOSTR: &str = "མ\u{f7a}ན་";
        /// `"^[+1yYཨ]"`
        pub const YESEXPR: &str = "^[+1yYཨ]";
        /// `"ཨ\u{f72}ན་"`
        pub const YESSTR: &str = "ཨ\u{f72}ན་";
    }
    pub mod LC_MONETARY {
        /// `"Nu."`
        pub const CURRENCY_SYMBOL: &str = "Nu.";
        /// `3`
        pub const FRAC_DIGITS: i64 = 3;
        /// `"BTN "`
        pub const INT_CURR_SYMBOL: &str = "BTN ";
        /// `3`
        pub const INT_FRAC_DIGITS: i64 = 3;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 2]`
        pub const MON_GROUPING: &[i64] = &[3, 2];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `4`
        pub const N_SIGN_POSN: i64 = 4;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `4`
        pub const P_SIGN_POSN: i64 = 4;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 2]`
        pub const GROUPING: &[i64] = &[3, 2];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"975"`
        pub const INT_PREFIX: &str = "975";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["ཟ\u{fb3}་", "མ\u{f72}ར་", "ལ\u{fb7}ག་", "པ\u{f74}ར་", "སངས་", "ས\u{fa4}\u{f7a}ན་", "ཉ\u{f72}་"]`
        pub const ABDAY: &[&str] = &["ཟ\u{fb3}་", "མ\u{f72}ར་", "ལ\u{fb7}ག་", "པ\u{f74}ར་", "སངས་", "ས\u{fa4}\u{f7a}ན་", "ཉ\u{f72}་"];
        /// `&["ཟ\u{fb3}་༡", "ཟ\u{fb3}་༢", "ཟ\u{fb3}་༣", "ཟ\u{fb3}་༤", "ཟ\u{fb3}་༥", "ཟ\u{fb3}་༦", "ཟ\u{fb3}་༧", "ཟ\u{fb3}་༨", "ཟ\u{fb3}་༩", "ཟ\u{fb3}་༡༠", "ཟ\u{fb3}་༡༡", "ཟ\u{fb3}་༡༢"]`
        pub const ABMON: &[&str] = &["ཟ\u{fb3}་༡", "ཟ\u{fb3}་༢", "ཟ\u{fb3}་༣", "ཟ\u{fb3}་༤", "ཟ\u{fb3}་༥", "ཟ\u{fb3}་༦", "ཟ\u{fb3}་༧", "ཟ\u{fb3}་༨", "ཟ\u{fb3}་༩", "ཟ\u{fb3}་༡༠", "ཟ\u{fb3}་༡༡", "ཟ\u{fb3}་༡༢"];
        /// `&["ངས་ཆ", "ཕ\u{fb1}\u{f72}་ཆ"]`
        pub const AM_PM: &[&str] = &["ངས་ཆ", "ཕ\u{fb1}\u{f72}་ཆ"];
        /// `"པས\u{fb1}\u{f72}་ལ\u{f7c}%y\nཟལ%mཚ\u{f7a}ས%d"`
        pub const D_FMT: &str = "པས\u{fb1}\u{f72}་ལ\u{f7c}%y\nཟལ%mཚ\u{f7a}ས%d";
        /// `"པས\u{fb1}\u{f72}་ལ\u{f7c}%y\nཟལ%mཚ\u{f7a}ས%d\nཆ\u{f74}་ཚ\u{f7c}ད%Hཀ\nསར་མ%M\nཀསར་ཆ%S"`
        pub const D_T_FMT: &str = "པས\u{fb1}\u{f72}་ལ\u{f7c}%y\nཟལ%mཚ\u{f7a}ས%d\nཆ\u{f74}་ཚ\u{f7c}ད%Hཀ\nསར་མ%M\nཀསར་ཆ%S";
        /// `&["གཟའ་ཟ\u{fb3}་བ་", "གཟའ་མ\u{f72}ག་དམར་", "གཟའ་ལ\u{fb7}ག་ཕ་", "གཟའ་པ\u{f74}ར་བ\u{f74}་", "གཟའ་པ་སངས་", "གཟའ་ས\u{fa4}\u{f7a}ན་ཕ་", "གཟའ་ཉ\u{f72}་མ་"]`
        pub const DAY: &[&str] = &["གཟའ་ཟ\u{fb3}་བ་", "གཟའ་མ\u{f72}ག་དམར་", "གཟའ་ལ\u{fb7}ག་ཕ་", "གཟའ་པ\u{f74}ར་བ\u{f74}་", "གཟའ་པ་སངས་", "གཟའ་ས\u{fa4}\u{f7a}ན་ཕ་", "གཟའ་ཉ\u{f72}་མ་"];
        /// `&["ཟ\u{fb3}་བ་དང་པ་", "ཟ\u{fb3}་བ་གཉ\u{f72}ས་པ་", "ཟ\u{fb3}་བ་གས\u{f74}མ་པ་", "ཟ\u{fb3}་བ་བཞ\u{f72}་པ་", "ཟ\u{fb3}་བ་ལ\u{f94}་ཕ་", "ཟ\u{fb3}་བ་ད\u{fb2}\u{f74}ག་པ་", "ཟ\u{fb3}་བ་བད\u{f74}ནཔ་", "ཟ\u{fb3}་བ་བར\u{f92}\u{fb1}ད་པ་", "ཟ\u{fb3}་བ་དག\u{f74}་པ་", "ཟ\u{fb3}་བ་བཅ\u{f74}་པ་", "ཟ\u{fb3}་བ་བཅ\u{f74}་གཅ\u{f72}ག་པ་", "ཟ\u{fb3}་བ་བཅ\u{f74}་གཉ\u{f72}ས་པ་"]`
        pub const MON: &[&str] = &["ཟ\u{fb3}་བ་དང་པ་", "ཟ\u{fb3}་བ་གཉ\u{f72}ས་པ་", "ཟ\u{fb3}་བ་གས\u{f74}མ་པ་", "ཟ\u{fb3}་བ་བཞ\u{f72}་པ་", "ཟ\u{fb3}་བ་ལ\u{f94}་ཕ་", "ཟ\u{fb3}་བ་ད\u{fb2}\u{f74}ག་པ་", "ཟ\u{fb3}་བ་བད\u{f74}ནཔ་", "ཟ\u{fb3}་བ་བར\u{f92}\u{fb1}ད་པ་", "ཟ\u{fb3}་བ་དག\u{f74}་པ་", "ཟ\u{fb3}་བ་བཅ\u{f74}་པ་", "ཟ\u{fb3}་བ་བཅ\u{f74}་གཅ\u{f72}ག་པ་", "ཟ\u{fb3}་བ་བཅ\u{f74}་གཉ\u{f72}ས་པ་"];
        /// `"ཆ\u{f74}་ཚ\u{f7c}ད\n%Hཀསར་མ\n%Mཀསར་ཆ%S"`
        pub const T_FMT: &str = "ཆ\u{f74}་ཚ\u{f7c}ད\n%Hཀསར་མ\n%Mཀསར་ཆ%S";
        /// `"ཆ\u{f74}་ཚ\u{f7c}ད\n%Iཀསར་མ%M\nཀསར་ཆ%S %p"`
        pub const T_FMT_AMPM: &str = "ཆ\u{f74}་ཚ\u{f7c}ད\n%Iཀསར་མ%M\nཀསར་ཆ%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod el_CY {
    pub mod LC_ADDRESS {
        /// `"CY"`
        pub const COUNTRY_ABTWO: &str = "CY";
        /// `"CYP"`
        pub const COUNTRY_AB3: &str = "CYP";
        /// `"CY"`
        pub const COUNTRY_CAR: &str = "CY";
        /// `"Κύπρος"`
        pub const COUNTRY_NAME: &str = "Κύπρος";
        /// `196`
        pub const COUNTRY_NUM: i64 = 196;
        /// `"el"`
        pub const LANG_AB: &str = "el";
        /// `"gre"`
        pub const LANG_LIB: &str = "gre";
        /// `"Ελληνικά"`
        pub const LANG_NAME: &str = "Ελληνικά";
        /// `"ell"`
        pub const LANG_TERM: &str = "ell";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Konstantinos Margaritis, M. Asias 50, Nafplion 21100, Greece"`
        pub const ADDRESS: &str = "Konstantinos Margaritis, M. Asias 50, Nafplion 21100, Greece";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2004-10-20"`
        pub const DATE: &str = "2004-10-20";
        /// `"bug-glibc@gnu.org"`
        pub const EMAIL: &str = "bug-glibc@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Greek"`
        pub const LANGUAGE: &str = "Greek";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Greek Debian Translation Team"`
        pub const SOURCE: &str = "Greek Debian Translation Team";
        /// `""`
        pub const TEL: &str = "";
        /// `"Cyprus"`
        pub const TERRITORY: &str = "Cyprus";
        /// `"Greek locale for Cyprus"`
        pub const TITLE: &str = "Greek locale for Cyprus";
    }
    pub use super::el_GR::LC_MESSAGES;
    pub use super::el_GR::LC_MONETARY;
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[0, 0]`
        pub const GROUPING: &[i64] = &[0, 0];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `"357"`
        pub const INT_PREFIX: &str = "357";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["Ιαν", "Φεβ", "Μάρ", "Απρ", "Μάι", "Ιούν", "Ιούλ", "Αύγ", "Σεπ", "Οκτ", "Νοέ", "Δεκ"]`
        pub const AB_ALT_MON: &[&str] = &["Ιαν", "Φεβ", "Μάρ", "Απρ", "Μάι", "Ιούν", "Ιούλ", "Αύγ", "Σεπ", "Οκτ", "Νοέ", "Δεκ"];
        /// `&["Κυρ", "Δευ", "Τρι", "Τετ", "Πεμ", "Παρ", "Σαβ"]`
        pub const ABDAY: &[&str] = &["Κυρ", "Δευ", "Τρι", "Τετ", "Πεμ", "Παρ", "Σαβ"];
        /// `&["Ιαν", "Φεβ", "Μαρ", "Απρ", "Μαΐ", "Ιουν", "Ιουλ", "Αυγ", "Σεπ", "Οκτ", "Νοε", "Δεκ"]`
        pub const ABMON: &[&str] = &["Ιαν", "Φεβ", "Μαρ", "Απρ", "Μαΐ", "Ιουν", "Ιουλ", "Αυγ", "Σεπ", "Οκτ", "Νοε", "Δεκ"];
        /// `&["Ιανουάριος", "Φεβρουάριος", "Μάρτιος", "Απρίλιος", "Μάιος", "Ιούνιος", "Ιούλιος", "Αύγουστος", "Σεπτέμβριος", "Οκτώβριος", "Νοέμβριος", "Δεκέμβριος"]`
        pub const ALT_MON: &[&str] = &["Ιανουάριος", "Φεβρουάριος", "Μάρτιος", "Απρίλιος", "Μάιος", "Ιούνιος", "Ιούλιος", "Αύγουστος", "Σεπτέμβριος", "Οκτώβριος", "Νοέμβριος", "Δεκέμβριος"];
        /// `&["πμ", "μμ"]`
        pub const AM_PM: &[&str] = &["πμ", "μμ"];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%a %d %b %Y %r %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %r %Z";
        /// `"%a %d %b %Y %r %Z"`
        pub const DATE_FMT: &str = "%a %d %b %Y %r %Z";
        /// `&["Κυριακή", "Δευτέρα", "Τρίτη", "Τετάρτη", "Πέμπτη", "Παρασκευή", "Σάββατο"]`
        pub const DAY: &[&str] = &["Κυριακή", "Δευτέρα", "Τρίτη", "Τετάρτη", "Πέμπτη", "Παρασκευή", "Σάββατο"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["Ιανουαρίου", "Φεβρουαρίου", "Μαρτίου", "Απριλίου", "Μαΐου", "Ιουνίου", "Ιουλίου", "Αυγούστου", "Σεπτεμβρίου", "Οκτωβρίου", "Νοεμβρίου", "Δεκεμβρίου"]`
        pub const MON: &[&str] = &["Ιανουαρίου", "Φεβρουαρίου", "Μαρτίου", "Απριλίου", "Μαΐου", "Ιουνίου", "Ιουλίου", "Αυγούστου", "Σεπτεμβρίου", "Οκτωβρίου", "Νοεμβρίου", "Δεκεμβρίου"];
        /// `"%r"`
        pub const T_FMT: &str = "%r";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod el_GR {
    pub mod LC_ADDRESS {
        /// `"GR"`
        pub const COUNTRY_ABTWO: &str = "GR";
        /// `"GRC"`
        pub const COUNTRY_AB3: &str = "GRC";
        /// `"GR"`
        pub const COUNTRY_CAR: &str = "GR";
        /// `"Ελλάδα"`
        pub const COUNTRY_NAME: &str = "Ελλάδα";
        /// `300`
        pub const COUNTRY_NUM: i64 = 300;
        /// `"el"`
        pub const LANG_AB: &str = "el";
        /// `"gre"`
        pub const LANG_LIB: &str = "gre";
        /// `"Ελληνικά"`
        pub const LANG_NAME: &str = "Ελληνικά";
        /// `"ell"`
        pub const LANG_TERM: &str = "ell";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jorgens Alle 8, DK-1615 Kobenhavn V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jorgens Alle 8, DK-1615 Kobenhavn V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Greek"`
        pub const LANGUAGE: &str = "Greek";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Greece"`
        pub const TERRITORY: &str = "Greece";
        /// `"Greek locale for Greece"`
        pub const TITLE: &str = "Greek locale for Greece";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNοΟόΌ]"`
        pub const NOEXPR: &str = "^[-0nNοΟόΌ]";
        /// `"όχι"`
        pub const NOSTR: &str = "όχι";
        /// `"^[+1yYνΝ]"`
        pub const YESEXPR: &str = "^[+1yYνΝ]";
        /// `"ναι"`
        pub const YESSTR: &str = "ναι";
    }
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[0, 0]`
        pub const GROUPING: &[i64] = &[0, 0];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `"30"`
        pub const INT_PREFIX: &str = "30";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["Ιαν", "Φεβ", "Μάρ", "Απρ", "Μάι", "Ιούν", "Ιούλ", "Αύγ", "Σεπ", "Οκτ", "Νοέ", "Δεκ"]`
        pub const AB_ALT_MON: &[&str] = &["Ιαν", "Φεβ", "Μάρ", "Απρ", "Μάι", "Ιούν", "Ιούλ", "Αύγ", "Σεπ", "Οκτ", "Νοέ", "Δεκ"];
        /// `&["Κυρ", "Δευ", "Τρι", "Τετ", "Πεμ", "Παρ", "Σαβ"]`
        pub const ABDAY: &[&str] = &["Κυρ", "Δευ", "Τρι", "Τετ", "Πεμ", "Παρ", "Σαβ"];
        /// `&["Ιαν", "Φεβ", "Μαρ", "Απρ", "Μαΐ", "Ιουν", "Ιουλ", "Αυγ", "Σεπ", "Οκτ", "Νοε", "Δεκ"]`
        pub const ABMON: &[&str] = &["Ιαν", "Φεβ", "Μαρ", "Απρ", "Μαΐ", "Ιουν", "Ιουλ", "Αυγ", "Σεπ", "Οκτ", "Νοε", "Δεκ"];
        /// `&["Ιανουάριος", "Φεβρουάριος", "Μάρτιος", "Απρίλιος", "Μάιος", "Ιούνιος", "Ιούλιος", "Αύγουστος", "Σεπτέμβριος", "Οκτώβριος", "Νοέμβριος", "Δεκέμβριος"]`
        pub const ALT_MON: &[&str] = &["Ιανουάριος", "Φεβρουάριος", "Μάρτιος", "Απρίλιος", "Μάιος", "Ιούνιος", "Ιούλιος", "Αύγουστος", "Σεπτέμβριος", "Οκτώβριος", "Νοέμβριος", "Δεκέμβριος"];
        /// `&["πμ", "μμ"]`
        pub const AM_PM: &[&str] = &["πμ", "μμ"];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%a %d %b %Y %r %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %r %Z";
        /// `"%a %d %b %Y %r %Z"`
        pub const DATE_FMT: &str = "%a %d %b %Y %r %Z";
        /// `&["Κυριακή", "Δευτέρα", "Τρίτη", "Τετάρτη", "Πέμπτη", "Παρασκευή", "Σάββατο"]`
        pub const DAY: &[&str] = &["Κυριακή", "Δευτέρα", "Τρίτη", "Τετάρτη", "Πέμπτη", "Παρασκευή", "Σάββατο"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["Ιανουαρίου", "Φεβρουαρίου", "Μαρτίου", "Απριλίου", "Μαΐου", "Ιουνίου", "Ιουλίου", "Αυγούστου", "Σεπτεμβρίου", "Οκτωβρίου", "Νοεμβρίου", "Δεκεμβρίου"]`
        pub const MON: &[&str] = &["Ιανουαρίου", "Φεβρουαρίου", "Μαρτίου", "Απριλίου", "Μαΐου", "Ιουνίου", "Ιουλίου", "Αυγούστου", "Σεπτεμβρίου", "Οκτωβρίου", "Νοεμβρίου", "Δεκεμβρίου"];
        /// `"%r"`
        pub const T_FMT: &str = "%r";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod el_GR_euro {
    pub use super::el_GR::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `"https://www.gnu.org/software/libc/"`
        pub const ADDRESS: &str = "https://www.gnu.org/software/libc/";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-24"`
        pub const DATE: &str = "2000-06-24";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Greek"`
        pub const LANGUAGE: &str = "Greek";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Free Software Foundation, Inc."`
        pub const SOURCE: &str = "Free Software Foundation, Inc.";
        /// `""`
        pub const TEL: &str = "";
        /// `"Greece"`
        pub const TERRITORY: &str = "Greece";
        /// `"Greek locale for Greece with Euro"`
        pub const TITLE: &str = "Greek locale for Greece with Euro";
    }
    pub use super::el_GR::LC_MESSAGES;
    pub use super::el_GR::LC_MONETARY;
    pub use super::el_GR::LC_NUMERIC;
    pub use super::el_GR::LC_TELEPHONE;
    pub use super::el_GR::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_AG {
    pub mod LC_ADDRESS {
        /// `"AG"`
        pub const COUNTRY_ABTWO: &str = "AG";
        /// `"ATG"`
        pub const COUNTRY_AB3: &str = "ATG";
        /// `"AG"`
        pub const COUNTRY_CAR: &str = "AG";
        /// `"Antigua & Barbuda"`
        pub const COUNTRY_NAME: &str = "Antigua & Barbuda";
        /// `28`
        pub const COUNTRY_NUM: i64 = 28;
        /// `"en"`
        pub const LANG_AB: &str = "en";
        /// `"eng"`
        pub const LANG_LIB: &str = "eng";
        /// `"English"`
        pub const LANG_NAME: &str = "English";
        /// `"eng"`
        pub const LANG_TERM: &str = "eng";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"https://www.gnu.org/software/libc/"`
        pub const ADDRESS: &str = "https://www.gnu.org/software/libc/";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2008-09-16"`
        pub const DATE: &str = "2008-09-16";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"English"`
        pub const LANGUAGE: &str = "English";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Free Software Foundation, Inc."`
        pub const SOURCE: &str = "Free Software Foundation, Inc.";
        /// `""`
        pub const TEL: &str = "";
        /// `"Antigua & Barbuda"`
        pub const TERRITORY: &str = "Antigua & Barbuda";
        /// `"English language locale for Antigua and Barbuda"`
        pub const TITLE: &str = "English language locale for Antigua and Barbuda";
    }
    pub use super::en_GB::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"XCD "`
        pub const INT_CURR_SYMBOL: &str = "XCD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub use super::en_GB::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `"1"`
        pub const INT_PREFIX: &str = "1";
        /// `"011"`
        pub const INT_SELECT: &str = "011";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `&["am", "pm"]`
        pub const AM_PM: &[&str] = &["am", "pm"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `"%a %e %b %H:%M:%S %Z %Y"`
        pub const DATE_FMT: &str = "%a %e %b %H:%M:%S %Z %Y";
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%l:%M:%S %P %Z"`
        pub const T_FMT_AMPM: &str = "%l:%M:%S %P %Z";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_AU {
    pub mod LC_ADDRESS {
        /// `"AU"`
        pub const COUNTRY_ABTWO: &str = "AU";
        /// `"AUS"`
        pub const COUNTRY_AB3: &str = "AUS";
        /// `"AUS"`
        pub const COUNTRY_CAR: &str = "AUS";
        /// `"Australia"`
        pub const COUNTRY_NAME: &str = "Australia";
        /// `36`
        pub const COUNTRY_NUM: i64 = 36;
        /// `"en"`
        pub const LANG_AB: &str = "en";
        /// `"eng"`
        pub const LANG_LIB: &str = "eng";
        /// `"English"`
        pub const LANG_NAME: &str = "English";
        /// `"eng"`
        pub const LANG_TERM: &str = "eng";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Australian English"`
        pub const LANGUAGE: &str = "Australian English";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Australia"`
        pub const TERRITORY: &str = "Australia";
        /// `"English locale for Australia"`
        pub const TITLE: &str = "English locale for Australia";
    }
    pub use super::en_US::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"AUD "`
        pub const INT_CURR_SYMBOL: &str = "AUD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"61"`
        pub const INT_PREFIX: &str = "61";
        /// `"0011"`
        pub const INT_SELECT: &str = "0011";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_BW {
    pub mod LC_ADDRESS {
        /// `"BW"`
        pub const COUNTRY_ABTWO: &str = "BW";
        /// `"BWA"`
        pub const COUNTRY_AB3: &str = "BWA";
        /// `"BW"`
        pub const COUNTRY_CAR: &str = "BW";
        /// `"Botswana"`
        pub const COUNTRY_NAME: &str = "Botswana";
        /// `72`
        pub const COUNTRY_NUM: i64 = 72;
        /// `"en"`
        pub const LANG_AB: &str = "en";
        /// `"eng"`
        pub const LANG_LIB: &str = "eng";
        /// `"English"`
        pub const LANG_NAME: &str = "English";
        /// `"eng"`
        pub const LANG_TERM: &str = "eng";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"English"`
        pub const LANGUAGE: &str = "English";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Botswana"`
        pub const TERRITORY: &str = "Botswana";
        /// `"English locale for Botswana"`
        pub const TITLE: &str = "English locale for Botswana";
    }
    pub use super::en_ZA::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"P"`
        pub const CURRENCY_SYMBOL: &str = "P";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"BWP "`
        pub const INT_CURR_SYMBOL: &str = "BWP ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub use super::en_ZA::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `"267"`
        pub const INT_PREFIX: &str = "267";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub use super::en_ZA::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_CA {
    pub mod LC_ADDRESS {
        /// `"CA"`
        pub const COUNTRY_ABTWO: &str = "CA";
        /// `"CAN"`
        pub const COUNTRY_AB3: &str = "CAN";
        /// `"CDN"`
        pub const COUNTRY_CAR: &str = "CDN";
        /// `"Canada"`
        pub const COUNTRY_NAME: &str = "Canada";
        /// `124`
        pub const COUNTRY_NUM: i64 = 124;
        /// `"en"`
        pub const LANG_AB: &str = "en";
        /// `"eng"`
        pub const LANG_LIB: &str = "eng";
        /// `"English"`
        pub const LANG_NAME: &str = "English";
        /// `"eng"`
        pub const LANG_TERM: &str = "eng";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Canadian English"`
        pub const LANGUAGE: &str = "Canadian English";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Canada"`
        pub const TERRITORY: &str = "Canada";
        /// `"English locale for Canada"`
        pub const TITLE: &str = "English locale for Canada";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"no"`
        pub const NOSTR: &str = "no";
        /// `"^[+1yYoO]"`
        pub const YESEXPR: &str = "^[+1yYoO]";
        /// `"yes"`
        pub const YESSTR: &str = "yes";
    }
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"CAD "`
        pub const INT_CURR_SYMBOL: &str = "CAD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"1"`
        pub const INT_PREFIX: &str = "1";
        /// `"011"`
        pub const INT_SELECT: &str = "011";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `"%Y-%m-%d"`
        pub const D_FMT: &str = "%Y-%m-%d";
        /// `"%a %d %b %Y %r %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %r %Z";
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%r"`
        pub const T_FMT: &str = "%r";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_DK {
    pub mod LC_ADDRESS {
        /// `"DK"`
        pub const COUNTRY_ABTWO: &str = "DK";
        /// `"DNK"`
        pub const COUNTRY_AB3: &str = "DNK";
        /// `"DK"`
        pub const COUNTRY_CAR: &str = "DK";
        /// `"Denmark"`
        pub const COUNTRY_NAME: &str = "Denmark";
        /// `208`
        pub const COUNTRY_NUM: i64 = 208;
        /// `"en"`
        pub const LANG_AB: &str = "en";
        /// `"eng"`
        pub const LANG_LIB: &str = "eng";
        /// `"English"`
        pub const LANG_NAME: &str = "English";
        /// `"eng"`
        pub const LANG_TERM: &str = "eng";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Kollegievej 6, DK-2920 Charlottenlund, Danmark"`
        pub const ADDRESS: &str = "Kollegievej 6, DK-2920 Charlottenlund, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"English"`
        pub const LANGUAGE: &str = "English";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Danish Standards Association"`
        pub const SOURCE: &str = "Danish Standards Association";
        /// `""`
        pub const TEL: &str = "";
        /// `"Denmark"`
        pub const TERRITORY: &str = "Denmark";
        /// `"English locale for Denmark"`
        pub const TITLE: &str = "English locale for Denmark";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"no"`
        pub const NOSTR: &str = "no";
        /// `"^[+1yYjJsSoO]"`
        pub const YESEXPR: &str = "^[+1yYjJsSoO]";
        /// `"yes"`
        pub const YESSTR: &str = "yes";
    }
    pub mod LC_MONETARY {
        /// `"kr."`
        pub const CURRENCY_SYMBOL: &str = "kr.";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"DKK "`
        pub const INT_CURR_SYMBOL: &str = "DKK ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub use super::da_DK::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%Y-%m-%d"`
        pub const D_FMT: &str = "%Y-%m-%d";
        /// `"%Y-%m-%dT%T %Z"`
        pub const D_T_FMT: &str = "%Y-%m-%dT%T %Z";
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_GB {
    pub mod LC_ADDRESS {
        /// `"GB"`
        pub const COUNTRY_ABTWO: &str = "GB";
        /// `"GBR"`
        pub const COUNTRY_AB3: &str = "GBR";
        /// `"GB"`
        pub const COUNTRY_CAR: &str = "GB";
        /// `"United Kingdom"`
        pub const COUNTRY_NAME: &str = "United Kingdom";
        /// `826`
        pub const COUNTRY_NUM: i64 = 826;
        /// `"en"`
        pub const LANG_AB: &str = "en";
        /// `"eng"`
        pub const LANG_LIB: &str = "eng";
        /// `"English"`
        pub const LANG_NAME: &str = "English";
        /// `"eng"`
        pub const LANG_TERM: &str = "eng";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `"Keld Simonsen"`
        pub const CONTACT: &str = "Keld Simonsen";
        /// `"2000-06-28"`
        pub const DATE: &str = "2000-06-28";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"British English"`
        pub const LANGUAGE: &str = "British English";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"United Kingdom"`
        pub const TERRITORY: &str = "United Kingdom";
        /// `"English locale for Britain"`
        pub const TITLE: &str = "English locale for Britain";
    }
    pub use super::en_US::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"£"`
        pub const CURRENCY_SYMBOL: &str = "£";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"GBP "`
        pub const INT_CURR_SYMBOL: &str = "GBP ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"44"`
        pub const INT_PREFIX: &str = "44";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"%A %l"`
        pub const TEL_DOM_FMT: &str = "%A %l";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `&["am", "pm"]`
        pub const AM_PM: &[&str] = &["am", "pm"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `"%a %e %b %H:%M:%S %Z %Y"`
        pub const DATE_FMT: &str = "%a %e %b %H:%M:%S %Z %Y";
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%l:%M:%S %P %Z"`
        pub const T_FMT_AMPM: &str = "%l:%M:%S %P %Z";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_HK {
    pub mod LC_ADDRESS {
        /// `"HK"`
        pub const COUNTRY_ABTWO: &str = "HK";
        /// `"HKG"`
        pub const COUNTRY_AB3: &str = "HKG";
        /// `"HK"`
        pub const COUNTRY_CAR: &str = "HK";
        /// `"Hong Kong SAR China"`
        pub const COUNTRY_NAME: &str = "Hong Kong SAR China";
        /// `344`
        pub const COUNTRY_NUM: i64 = 344;
        /// `"en"`
        pub const LANG_AB: &str = "en";
        /// `"eng"`
        pub const LANG_LIB: &str = "eng";
        /// `"English"`
        pub const LANG_NAME: &str = "English";
        /// `"eng"`
        pub const LANG_TERM: &str = "eng";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan"`
        pub const ADDRESS: &str = "1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000,October,27 (XML source:2000,July,20)"`
        pub const DATE: &str = "2000,October,27 (XML source:2000,July,20)";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"English"`
        pub const LANGUAGE: &str = "English";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"IBM Globalization Center of Competency, Yamato Software Laboratory"`
        pub const SOURCE: &str = "IBM Globalization Center of Competency, Yamato Software Laboratory";
        /// `""`
        pub const TEL: &str = "";
        /// `"Hong Kong SAR China"`
        pub const TERRITORY: &str = "Hong Kong SAR China";
        /// `"English locale for Hong Kong"`
        pub const TITLE: &str = "English locale for Hong Kong";
    }
    pub use super::en_US::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"HK$"`
        pub const CURRENCY_SYMBOL: &str = "HK$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"HKD "`
        pub const INT_CURR_SYMBOL: &str = "HKD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `0`
        pub const N_SIGN_POSN: i64 = 0;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"852"`
        pub const INT_PREFIX: &str = "852";
        /// `"001"`
        pub const INT_SELECT: &str = "001";
        /// `"+%c ;%a ;%l"`
        pub const TEL_INT_FMT: &str = "+%c ;%a ;%l";
    }
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `"%A, %B %d, %Y"`
        pub const D_FMT: &str = "%A, %B %d, %Y";
        /// `"%A, %B %d, %Y %p%I:%M:%S %Z"`
        pub const D_T_FMT: &str = "%A, %B %d, %Y %p%I:%M:%S %Z";
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_IE {
    pub mod LC_ADDRESS {
        /// `"IE"`
        pub const COUNTRY_ABTWO: &str = "IE";
        /// `"IRL"`
        pub const COUNTRY_AB3: &str = "IRL";
        /// `"IRL"`
        pub const COUNTRY_CAR: &str = "IRL";
        /// `"Ireland"`
        pub const COUNTRY_NAME: &str = "Ireland";
        /// `372`
        pub const COUNTRY_NUM: i64 = 372;
        /// `"en"`
        pub const LANG_AB: &str = "en";
        /// `"eng"`
        pub const LANG_LIB: &str = "eng";
        /// `"English"`
        pub const LANG_NAME: &str = "English";
        /// `"eng"`
        pub const LANG_TERM: &str = "eng";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"English"`
        pub const LANGUAGE: &str = "English";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Ireland"`
        pub const TERRITORY: &str = "Ireland";
        /// `"English locale for Ireland"`
        pub const TITLE: &str = "English locale for Ireland";
    }
    pub use super::en_GB::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub use super::en_GB::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `"353"`
        pub const INT_PREFIX: &str = "353";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_IE_euro {
    pub use super::en_IE::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `"https://www.gnu.org/software/libc/"`
        pub const ADDRESS: &str = "https://www.gnu.org/software/libc/";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-08-20"`
        pub const DATE: &str = "2000-08-20";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"English"`
        pub const LANGUAGE: &str = "English";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Free Software Foundation, Inc."`
        pub const SOURCE: &str = "Free Software Foundation, Inc.";
        /// `""`
        pub const TEL: &str = "";
        /// `"Ireland"`
        pub const TERRITORY: &str = "Ireland";
        /// `"English locale for Ireland with Euro"`
        pub const TITLE: &str = "English locale for Ireland with Euro";
    }
    pub use super::en_IE::LC_MESSAGES;
    pub use super::en_IE::LC_MONETARY;
    pub use super::en_GB::LC_NUMERIC;
    pub use super::en_IE::LC_TELEPHONE;
    pub use super::en_IE::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_IL {
    pub mod LC_ADDRESS {
        /// `"IL"`
        pub const COUNTRY_ABTWO: &str = "IL";
        /// `"ISR"`
        pub const COUNTRY_AB3: &str = "ISR";
        /// `"IL"`
        pub const COUNTRY_CAR: &str = "IL";
        /// `"Israel"`
        pub const COUNTRY_NAME: &str = "Israel";
        /// `376`
        pub const COUNTRY_NUM: i64 = 376;
        /// `"ISR"`
        pub const COUNTRY_POST: &str = "ISR";
        /// `"en"`
        pub const LANG_AB: &str = "en";
        /// `"eng"`
        pub const LANG_LIB: &str = "eng";
        /// `"English"`
        pub const LANG_NAME: &str = "English";
        /// `"eng"`
        pub const LANG_TERM: &str = "eng";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"https://www.gnu.org/software/libc/"`
        pub const ADDRESS: &str = "https://www.gnu.org/software/libc/";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2016-04-19"`
        pub const DATE: &str = "2016-04-19";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"English"`
        pub const LANGUAGE: &str = "English";
        /// `"1.1"`
        pub const REVISION: &str = "1.1";
        /// `"Free Software Foundation, Inc."`
        pub const SOURCE: &str = "Free Software Foundation, Inc.";
        /// `""`
        pub const TEL: &str = "";
        /// `"Israel"`
        pub const TERRITORY: &str = "Israel";
        /// `"English locale for Israel"`
        pub const TITLE: &str = "English locale for Israel";
    }
    pub use super::en_US::LC_MESSAGES;
    pub use super::he_IL::LC_MONETARY;
    pub use super::he_IL::LC_NUMERIC;
    pub use super::he_IL::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `1`
        pub const FIRST_WORKDAY: i64 = 1;
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_IN {
    pub mod LC_ADDRESS {
        /// `"IN"`
        pub const COUNTRY_ABTWO: &str = "IN";
        /// `"IND"`
        pub const COUNTRY_AB3: &str = "IND";
        /// `"IND"`
        pub const COUNTRY_CAR: &str = "IND";
        /// `"India"`
        pub const COUNTRY_NAME: &str = "India";
        /// `356`
        pub const COUNTRY_NUM: i64 = 356;
        /// `"en"`
        pub const LANG_AB: &str = "en";
        /// `"eng"`
        pub const LANG_LIB: &str = "eng";
        /// `"English"`
        pub const LANG_NAME: &str = "English";
        /// `"eng"`
        pub const LANG_TERM: &str = "eng";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan"`
        pub const ADDRESS: &str = "1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000,October,27 (XML source:2000,July,20)"`
        pub const DATE: &str = "2000,October,27 (XML source:2000,July,20)";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"English"`
        pub const LANGUAGE: &str = "English";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"IBM Globalization Center of Competency, Yamato Software Laboratory"`
        pub const SOURCE: &str = "IBM Globalization Center of Competency, Yamato Software Laboratory";
        /// `""`
        pub const TEL: &str = "";
        /// `"India"`
        pub const TERRITORY: &str = "India";
        /// `"English language locale for India"`
        pub const TITLE: &str = "English language locale for India";
    }
    pub use super::en_US::LC_MESSAGES;
    pub use super::hi_IN::LC_MONETARY;
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 2]`
        pub const GROUPING: &[i64] = &[3, 2];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub use super::hi_IN::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%A %d %B %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A %d %B %Y %I:%M:%S %p %Z";
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_NG {
    pub mod LC_ADDRESS {
        /// `"NG"`
        pub const COUNTRY_ABTWO: &str = "NG";
        /// `"NGA"`
        pub const COUNTRY_AB3: &str = "NGA";
        /// `"WAN"`
        pub const COUNTRY_CAR: &str = "WAN";
        /// `978`
        pub const COUNTRY_ISBN: i64 = 978;
        /// `"Nigeria"`
        pub const COUNTRY_NAME: &str = "Nigeria";
        /// `566`
        pub const COUNTRY_NUM: i64 = 566;
        /// `"en"`
        pub const LANG_AB: &str = "en";
        /// `"eng"`
        pub const LANG_LIB: &str = "eng";
        /// `"English"`
        pub const LANG_NAME: &str = "English";
        /// `"eng"`
        pub const LANG_TERM: &str = "eng";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2006-02-01"`
        pub const DATE: &str = "2006-02-01";
        /// `""`
        pub const EMAIL: &str = "";
        /// `""`
        pub const FAX: &str = "";
        /// `"English"`
        pub const LANGUAGE: &str = "English";
        /// `"0.2"`
        pub const REVISION: &str = "0.2";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"Nigeria"`
        pub const TERRITORY: &str = "Nigeria";
        /// `"English locale for Nigeria"`
        pub const TITLE: &str = "English locale for Nigeria";
    }
    pub use super::en_US::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"₦"`
        pub const CURRENCY_SYMBOL: &str = "₦";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"NGN "`
        pub const INT_CURR_SYMBOL: &str = "NGN ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"234"`
        pub const INT_PREFIX: &str = "234";
        /// `"009"`
        pub const INT_SELECT: &str = "009";
        /// `"(%A) %l"`
        pub const TEL_DOM_FMT: &str = "(%A) %l";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_NZ {
    pub mod LC_ADDRESS {
        /// `"NZ"`
        pub const COUNTRY_ABTWO: &str = "NZ";
        /// `"NZL"`
        pub const COUNTRY_AB3: &str = "NZL";
        /// `"NZ"`
        pub const COUNTRY_CAR: &str = "NZ";
        /// `"New Zealand"`
        pub const COUNTRY_NAME: &str = "New Zealand";
        /// `554`
        pub const COUNTRY_NUM: i64 = 554;
        /// `"en"`
        pub const LANG_AB: &str = "en";
        /// `"eng"`
        pub const LANG_LIB: &str = "eng";
        /// `"English"`
        pub const LANG_NAME: &str = "English";
        /// `"eng"`
        pub const LANG_TERM: &str = "eng";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"English"`
        pub const LANGUAGE: &str = "English";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"New Zealand"`
        pub const TERRITORY: &str = "New Zealand";
        /// `"English locale for New Zealand"`
        pub const TITLE: &str = "English locale for New Zealand";
    }
    pub use super::en_US::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"NZD "`
        pub const INT_CURR_SYMBOL: &str = "NZD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"64"`
        pub const INT_PREFIX: &str = "64";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_PH {
    pub mod LC_ADDRESS {
        /// `"PH"`
        pub const COUNTRY_ABTWO: &str = "PH";
        /// `"PHL"`
        pub const COUNTRY_AB3: &str = "PHL";
        /// `"RP"`
        pub const COUNTRY_CAR: &str = "RP";
        /// `"Philippines"`
        pub const COUNTRY_NAME: &str = "Philippines";
        /// `608`
        pub const COUNTRY_NUM: i64 = 608;
        /// `"en"`
        pub const LANG_AB: &str = "en";
        /// `"eng"`
        pub const LANG_LIB: &str = "eng";
        /// `"English"`
        pub const LANG_NAME: &str = "English";
        /// `"eng"`
        pub const LANG_TERM: &str = "eng";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan"`
        pub const ADDRESS: &str = "1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000,October,27 (XML source:2000,July,20)"`
        pub const DATE: &str = "2000,October,27 (XML source:2000,July,20)";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"English"`
        pub const LANGUAGE: &str = "English";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"IBM Globalization Center of Competency, Yamato Software Laboratory"`
        pub const SOURCE: &str = "IBM Globalization Center of Competency, Yamato Software Laboratory";
        /// `""`
        pub const TEL: &str = "";
        /// `"Philippines"`
        pub const TERRITORY: &str = "Philippines";
        /// `"English language locale for Philippines"`
        pub const TITLE: &str = "English language locale for Philippines";
    }
    pub use super::en_US::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"₱"`
        pub const CURRENCY_SYMBOL: &str = "₱";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"PHP "`
        pub const INT_CURR_SYMBOL: &str = "PHP ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `0`
        pub const N_SIGN_POSN: i64 = 0;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"63"`
        pub const INT_PREFIX: &str = "63";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c ;%a ;%l"`
        pub const TEL_INT_FMT: &str = "+%c ;%a ;%l";
    }
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `"%A, %d %B, %Y"`
        pub const D_FMT: &str = "%A, %d %B, %Y";
        /// `"%A, %d %B, %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A, %d %B, %Y %I:%M:%S %p %Z";
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_SC {
    pub mod LC_ADDRESS {
        /// `"SC"`
        pub const COUNTRY_ABTWO: &str = "SC";
        /// `"SYC"`
        pub const COUNTRY_AB3: &str = "SYC";
        /// `"SY"`
        pub const COUNTRY_CAR: &str = "SY";
        /// `"978-99931"`
        pub const COUNTRY_ISBN: &str = "978-99931";
        /// `"Seychelles"`
        pub const COUNTRY_NAME: &str = "Seychelles";
        /// `690`
        pub const COUNTRY_NUM: i64 = 690;
        /// `"en"`
        pub const LANG_AB: &str = "en";
        /// `"eng"`
        pub const LANG_LIB: &str = "eng";
        /// `"English"`
        pub const LANG_NAME: &str = "English";
        /// `"eng"`
        pub const LANG_TERM: &str = "eng";
        /// `"%f%N%h%s%N%T"`
        pub const POSTAL_FMT: &str = "%f%N%h%s%N%T";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2017-07-24"`
        pub const DATE: &str = "2017-07-24";
        /// `"akhilesh.k@samsung.com"`
        pub const EMAIL: &str = "akhilesh.k@samsung.com";
        /// `""`
        pub const FAX: &str = "";
        /// `"English"`
        pub const LANGUAGE: &str = "English";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Samsung Electronics Co., Ltd."`
        pub const SOURCE: &str = "Samsung Electronics Co., Ltd.";
        /// `""`
        pub const TEL: &str = "";
        /// `"Seychelles"`
        pub const TERRITORY: &str = "Seychelles";
        /// `"English locale for the Seychelles"`
        pub const TITLE: &str = "English locale for the Seychelles";
    }
    pub use super::en_GB::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"SR"`
        pub const CURRENCY_SYMBOL: &str = "SR";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"SCR "`
        pub const INT_CURR_SYMBOL: &str = "SCR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `1`
        pub const INT_N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const INT_P_SEP_BY_SPACE: i64 = 1;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub use super::en_GB::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `"248"`
        pub const INT_PREFIX: &str = "248";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %l"`
        pub const TEL_INT_FMT: &str = "+%c %l";
    }
    pub use super::en_GB::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_SG {
    pub mod LC_ADDRESS {
        /// `"SG"`
        pub const COUNTRY_ABTWO: &str = "SG";
        /// `"SGP"`
        pub const COUNTRY_AB3: &str = "SGP";
        /// `"SGP"`
        pub const COUNTRY_CAR: &str = "SGP";
        /// `"Singapore"`
        pub const COUNTRY_NAME: &str = "Singapore";
        /// `702`
        pub const COUNTRY_NUM: i64 = 702;
        /// `"en"`
        pub const LANG_AB: &str = "en";
        /// `"eng"`
        pub const LANG_LIB: &str = "eng";
        /// `"English"`
        pub const LANG_NAME: &str = "English";
        /// `"eng"`
        pub const LANG_TERM: &str = "eng";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan"`
        pub const ADDRESS: &str = "1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000,October,27 (XML source:2000,July,20)"`
        pub const DATE: &str = "2000,October,27 (XML source:2000,July,20)";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"English"`
        pub const LANGUAGE: &str = "English";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"IBM Globalization Center of Competency, Yamato Software Laboratory"`
        pub const SOURCE: &str = "IBM Globalization Center of Competency, Yamato Software Laboratory";
        /// `""`
        pub const TEL: &str = "";
        /// `"Singapore"`
        pub const TERRITORY: &str = "Singapore";
        /// `"English language locale for Singapore"`
        pub const TITLE: &str = "English language locale for Singapore";
    }
    pub use super::en_US::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"SGD "`
        pub const INT_CURR_SYMBOL: &str = "SGD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `0`
        pub const N_SIGN_POSN: i64 = 0;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"65"`
        pub const INT_PREFIX: &str = "65";
        /// `"001"`
        pub const INT_SELECT: &str = "001";
        /// `"+%c ;%a ;%l"`
        pub const TEL_INT_FMT: &str = "+%c ;%a ;%l";
    }
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%a %d %b %Y %r"`
        pub const D_T_FMT: &str = "%a %d %b %Y %r";
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_US {
    pub mod LC_ADDRESS {
        /// `"US"`
        pub const COUNTRY_ABTWO: &str = "US";
        /// `"USA"`
        pub const COUNTRY_AB3: &str = "USA";
        /// `"USA"`
        pub const COUNTRY_CAR: &str = "USA";
        /// `0`
        pub const COUNTRY_ISBN: i64 = 0;
        /// `"United States"`
        pub const COUNTRY_NAME: &str = "United States";
        /// `840`
        pub const COUNTRY_NUM: i64 = 840;
        /// `"USA"`
        pub const COUNTRY_POST: &str = "USA";
        /// `"en"`
        pub const LANG_AB: &str = "en";
        /// `"eng"`
        pub const LANG_LIB: &str = "eng";
        /// `"English"`
        pub const LANG_NAME: &str = "English";
        /// `"eng"`
        pub const LANG_TERM: &str = "eng";
        /// `"%a%N%f%N%d%N%b%N%h %s %e %r%N%T, %S %z%N%c%N"`
        pub const POSTAL_FMT: &str = "%a%N%f%N%d%N%b%N%h %s %e %r%N%T, %S %z%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"https://www.gnu.org/software/libc/"`
        pub const ADDRESS: &str = "https://www.gnu.org/software/libc/";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-24"`
        pub const DATE: &str = "2000-06-24";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"American English"`
        pub const LANGUAGE: &str = "American English";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Free Software Foundation, Inc."`
        pub const SOURCE: &str = "Free Software Foundation, Inc.";
        /// `""`
        pub const TEL: &str = "";
        /// `"United States"`
        pub const TERRITORY: &str = "United States";
        /// `"English locale for the USA"`
        pub const TITLE: &str = "English locale for the USA";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"no"`
        pub const NOSTR: &str = "no";
        /// `"^[+1yY]"`
        pub const YESEXPR: &str = "^[+1yY]";
        /// `"yes"`
        pub const YESSTR: &str = "yes";
    }
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"USD "`
        pub const INT_CURR_SYMBOL: &str = "USD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `1`
        pub const INT_N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const INT_P_SEP_BY_SPACE: i64 = 1;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"1"`
        pub const INT_PREFIX: &str = "1";
        /// `"11"`
        pub const INT_SELECT: &str = "11";
        /// `"(%a) %l"`
        pub const TEL_DOM_FMT: &str = "(%a) %l";
        /// `"+%c (%a) %l"`
        pub const TEL_INT_FMT: &str = "+%c (%a) %l";
    }
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `"%m/%d/%Y"`
        pub const D_FMT: &str = "%m/%d/%Y";
        /// `"%a %d %b %Y %r %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %r %Z";
        /// `"%a %d %b %Y %r %Z"`
        pub const DATE_FMT: &str = "%a %d %b %Y %r %Z";
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%r"`
        pub const T_FMT: &str = "%r";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_ZA {
    pub mod LC_ADDRESS {
        /// `"ZA"`
        pub const COUNTRY_ABTWO: &str = "ZA";
        /// `"ZAF"`
        pub const COUNTRY_AB3: &str = "ZAF";
        /// `"ZA"`
        pub const COUNTRY_CAR: &str = "ZA";
        /// `0`
        pub const COUNTRY_ISBN: i64 = 0;
        /// `"South Africa"`
        pub const COUNTRY_NAME: &str = "South Africa";
        /// `710`
        pub const COUNTRY_NUM: i64 = 710;
        /// `"ZA"`
        pub const COUNTRY_POST: &str = "ZA";
        /// `"en"`
        pub const LANG_AB: &str = "en";
        /// `"eng"`
        pub const LANG_LIB: &str = "eng";
        /// `"English"`
        pub const LANG_NAME: &str = "English";
        /// `"eng"`
        pub const LANG_TERM: &str = "eng";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Translate.org.za"`
        pub const ABBREVIATION: &str = "Translate.org.za";
        /// `"Box 28364, Sunnyside, 0132, South Africa"`
        pub const ADDRESS: &str = "Box 28364, Sunnyside, 0132, South Africa";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ];
        /// `"Dwayne Bailey"`
        pub const CONTACT: &str = "Dwayne Bailey";
        /// `"2007-04-19"`
        pub const DATE: &str = "2007-04-19";
        /// `"dwayne@translate.org.za"`
        pub const EMAIL: &str = "dwayne@translate.org.za";
        /// `""`
        pub const FAX: &str = "";
        /// `"English"`
        pub const LANGUAGE: &str = "English";
        /// `"1.3"`
        pub const REVISION: &str = "1.3";
        /// `"Zuza Software Foundation (Translate.org.za)"`
        pub const SOURCE: &str = "Zuza Software Foundation (Translate.org.za)";
        /// `""`
        pub const TEL: &str = "";
        /// `"South Africa"`
        pub const TERRITORY: &str = "South Africa";
        /// `"English locale for South Africa"`
        pub const TITLE: &str = "English locale for South Africa";
    }
    pub use super::en_US::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"R"`
        pub const CURRENCY_SYMBOL: &str = "R";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"ZAR "`
        pub const INT_CURR_SYMBOL: &str = "ZAR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"27"`
        pub const INT_PREFIX: &str = "27";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"(%A) %l"`
        pub const TEL_DOM_FMT: &str = "(%A) %l";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_ZM {
    pub mod LC_ADDRESS {
        /// `"ZM"`
        pub const COUNTRY_ABTWO: &str = "ZM";
        /// `"ZMB"`
        pub const COUNTRY_AB3: &str = "ZMB";
        /// `"Z"`
        pub const COUNTRY_CAR: &str = "Z";
        /// `"Zambia"`
        pub const COUNTRY_NAME: &str = "Zambia";
        /// `894`
        pub const COUNTRY_NUM: i64 = 894;
        /// `"ZM"`
        pub const COUNTRY_POST: &str = "ZM";
        /// `"en"`
        pub const LANG_AB: &str = "en";
        /// `"eng"`
        pub const LANG_LIB: &str = "eng";
        /// `"English"`
        pub const LANG_NAME: &str = "English";
        /// `"eng"`
        pub const LANG_TERM: &str = "eng";
        /// `"%a%N%f%N%e %h%N%b %s%N%z%N%T%N%c%N"`
        pub const POSTAL_FMT: &str = "%a%N%f%N%e %h%N%b %s%N%z%N%T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ];
        /// `"Martin Benjamin"`
        pub const CONTACT: &str = "Martin Benjamin";
        /// `"2011-04-18"`
        pub const DATE: &str = "2011-04-18";
        /// `"locales@africanlocalization.net"`
        pub const EMAIL: &str = "locales@africanlocalization.net";
        /// `"English"`
        pub const LANGUAGE: &str = "English";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"ANLoc"`
        pub const SOURCE: &str = "ANLoc";
        /// `"Zambia"`
        pub const TERRITORY: &str = "Zambia";
        /// `"English locale for Zambia"`
        pub const TITLE: &str = "English locale for Zambia";
    }
    pub use super::bem_ZM::LC_MESSAGES;
    pub use super::bem_ZM::LC_MONETARY;
    pub use super::en_GB::LC_NUMERIC;
    pub use super::bem_ZM::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"]`
        pub const ABDAY: &[&str] = &["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `&["am", "pm"]`
        pub const AM_PM: &[&str] = &["am", "pm"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `"%a %e %b %H:%M:%S %Z %Y"`
        pub const DATE_FMT: &str = "%a %e %b %H:%M:%S %Z %Y";
        /// `&["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"]`
        pub const DAY: &[&str] = &["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%l:%M:%S %P %Z"`
        pub const T_FMT_AMPM: &str = "%l:%M:%S %P %Z";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod en_ZW {
    pub mod LC_ADDRESS {
        /// `"ZW"`
        pub const COUNTRY_ABTWO: &str = "ZW";
        /// `"ZWE"`
        pub const COUNTRY_AB3: &str = "ZWE";
        /// `"ZW"`
        pub const COUNTRY_CAR: &str = "ZW";
        /// `"Zimbabwe"`
        pub const COUNTRY_NAME: &str = "Zimbabwe";
        /// `716`
        pub const COUNTRY_NUM: i64 = 716;
        /// `"en"`
        pub const LANG_AB: &str = "en";
        /// `"eng"`
        pub const LANG_LIB: &str = "eng";
        /// `"English"`
        pub const LANG_NAME: &str = "English";
        /// `"eng"`
        pub const LANG_TERM: &str = "eng";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"English"`
        pub const LANGUAGE: &str = "English";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Zimbabwe"`
        pub const TERRITORY: &str = "Zimbabwe";
        /// `"English locale for Zimbabwe"`
        pub const TITLE: &str = "English locale for Zimbabwe";
    }
    pub use super::en_ZA::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"USD "`
        pub const INT_CURR_SYMBOL: &str = "USD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub use super::en_ZA::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `"263"`
        pub const INT_PREFIX: &str = "263";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub use super::en_ZA::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod eo {
    pub mod LC_ADDRESS {
        /// `"eo"`
        pub const LANG_AB: &str = "eo";
        /// `"esperanto"`
        pub const LANG_NAME: &str = "esperanto";
        /// `"epo"`
        pub const LANG_TERM: &str = "epo";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2016-06-10"`
        pub const DATE: &str = "2016-06-10";
        /// `"debian-esperanto@lists.debian.org"`
        pub const EMAIL: &str = "debian-esperanto@lists.debian.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Esperanto"`
        pub const LANGUAGE: &str = "Esperanto";
        /// `"draft"`
        pub const REVISION: &str = "draft";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `""`
        pub const TERRITORY: &str = "";
        /// `"Esperanto language locale"`
        pub const TITLE: &str = "Esperanto language locale";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"Ne"`
        pub const NOSTR: &str = "Ne";
        /// `"^[+1JjYy]"`
        pub const YESEXPR: &str = "^[+1JjYy]";
        /// `"Jes"`
        pub const YESSTR: &str = "Jes";
    }
    pub mod LC_MONETARY {
        /// `"¤"`
        pub const CURRENCY_SYMBOL: &str = "¤";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"XDR "`
        pub const INT_CURR_SYMBOL: &str = "XDR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[0, 0]`
        pub const GROUPING: &[i64] = &[0, 0];
        /// `""`
        pub const THOUSANDS_SEP: &str = "";
    }
    pub mod LC_TELEPHONE {
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a%t%l"`
        pub const TEL_INT_FMT: &str = "+%c %a%t%l";
    }
    pub mod LC_TIME {
        /// `&["dim", "lun", "mar", "mer", "ĵaŭ", "ven", "sab"]`
        pub const ABDAY: &[&str] = &["dim", "lun", "mar", "mer", "ĵaŭ", "ven", "sab"];
        /// `&["Jan", "Feb", "Mar", "Apr", "Maj", "Jun", "Jul", "Aŭg", "Sep", "Okt", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "Maj", "Jun", "Jul", "Aŭg", "Sep", "Okt", "Nov", "Dec"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%Y-%m-%d"`
        pub const D_FMT: &str = "%Y-%m-%d";
        /// `"%a %d %b %Y %T %z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %z";
        /// `&["dimanĉo", "lundo", "mardo", "merkredo", "ĵaŭdo", "vendredo", "sabato"]`
        pub const DAY: &[&str] = &["dimanĉo", "lundo", "mardo", "merkredo", "ĵaŭdo", "vendredo", "sabato"];
        /// `&["Januaro", "Februaro", "Marto", "Aprilo", "Majo", "Junio", "Julio", "Aŭgusto", "Septembro", "Oktobro", "Novembro", "Decembro"]`
        pub const MON: &[&str] = &["Januaro", "Februaro", "Marto", "Aprilo", "Majo", "Junio", "Julio", "Aŭgusto", "Septembro", "Oktobro", "Novembro", "Decembro"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_AR {
    pub mod LC_ADDRESS {
        /// `"AR"`
        pub const COUNTRY_ABTWO: &str = "AR";
        /// `"ARG"`
        pub const COUNTRY_AB3: &str = "ARG";
        /// `"RA"`
        pub const COUNTRY_CAR: &str = "RA";
        /// `"Argentina"`
        pub const COUNTRY_NAME: &str = "Argentina";
        /// `32`
        pub const COUNTRY_NUM: i64 = 32;
        /// `"es"`
        pub const LANG_AB: &str = "es";
        /// `"spa"`
        pub const LANG_LIB: &str = "spa";
        /// `"español"`
        pub const LANG_NAME: &str = "español";
        /// `"spa"`
        pub const LANG_TERM: &str = "spa";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Spanish"`
        pub const LANGUAGE: &str = "Spanish";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Argentina"`
        pub const TERRITORY: &str = "Argentina";
        /// `"Spanish locale for Argentina"`
        pub const TITLE: &str = "Spanish locale for Argentina";
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"ARS "`
        pub const INT_CURR_SYMBOL: &str = "ARS ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `"54"`
        pub const INT_PREFIX: &str = "54";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_BO {
    pub mod LC_ADDRESS {
        /// `"BO"`
        pub const COUNTRY_ABTWO: &str = "BO";
        /// `"BOL"`
        pub const COUNTRY_AB3: &str = "BOL";
        /// `"BOL"`
        pub const COUNTRY_CAR: &str = "BOL";
        /// `"Bolivia"`
        pub const COUNTRY_NAME: &str = "Bolivia";
        /// `68`
        pub const COUNTRY_NUM: i64 = 68;
        /// `"es"`
        pub const LANG_AB: &str = "es";
        /// `"spa"`
        pub const LANG_LIB: &str = "spa";
        /// `"español"`
        pub const LANG_NAME: &str = "español";
        /// `"spa"`
        pub const LANG_TERM: &str = "spa";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Spanish"`
        pub const LANGUAGE: &str = "Spanish";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Bolivia"`
        pub const TERRITORY: &str = "Bolivia";
        /// `"Spanish locale for Bolivia"`
        pub const TITLE: &str = "Spanish locale for Bolivia";
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"Bs"`
        pub const CURRENCY_SYMBOL: &str = "Bs";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"BOB "`
        pub const INT_CURR_SYMBOL: &str = "BOB ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub use super::es_ES::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `"591"`
        pub const INT_PREFIX: &str = "591";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_CL {
    pub mod LC_ADDRESS {
        /// `"CL"`
        pub const COUNTRY_ABTWO: &str = "CL";
        /// `"CHL"`
        pub const COUNTRY_AB3: &str = "CHL";
        /// `"RCH"`
        pub const COUNTRY_CAR: &str = "RCH";
        /// `"Chile"`
        pub const COUNTRY_NAME: &str = "Chile";
        /// `152`
        pub const COUNTRY_NUM: i64 = 152;
        /// `"es"`
        pub const LANG_AB: &str = "es";
        /// `"spa"`
        pub const LANG_LIB: &str = "spa";
        /// `"español"`
        pub const LANG_NAME: &str = "español";
        /// `"spa"`
        pub const LANG_TERM: &str = "spa";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Spanish"`
        pub const LANGUAGE: &str = "Spanish";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Chile"`
        pub const TERRITORY: &str = "Chile";
        /// `"Spanish locale for Chile"`
        pub const TITLE: &str = "Spanish locale for Chile";
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"CLP "`
        pub const INT_CURR_SYMBOL: &str = "CLP ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub use super::es_ES::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `"56"`
        pub const INT_PREFIX: &str = "56";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub use super::es_BO::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_CO {
    pub mod LC_ADDRESS {
        /// `"CO"`
        pub const COUNTRY_ABTWO: &str = "CO";
        /// `"COL"`
        pub const COUNTRY_AB3: &str = "COL";
        /// `"CO"`
        pub const COUNTRY_CAR: &str = "CO";
        /// `"Colombia"`
        pub const COUNTRY_NAME: &str = "Colombia";
        /// `170`
        pub const COUNTRY_NUM: i64 = 170;
        /// `"es"`
        pub const LANG_AB: &str = "es";
        /// `"spa"`
        pub const LANG_LIB: &str = "spa";
        /// `"español"`
        pub const LANG_NAME: &str = "español";
        /// `"spa"`
        pub const LANG_TERM: &str = "spa";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Spanish"`
        pub const LANGUAGE: &str = "Spanish";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Colombia"`
        pub const TERRITORY: &str = "Colombia";
        /// `"Spanish locale for Colombia"`
        pub const TITLE: &str = "Spanish locale for Colombia";
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"COP "`
        pub const INT_CURR_SYMBOL: &str = "COP ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub use super::es_ES::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `"57"`
        pub const INT_PREFIX: &str = "57";
        /// `"009"`
        pub const INT_SELECT: &str = "009";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_CR {
    pub mod LC_ADDRESS {
        /// `"CR"`
        pub const COUNTRY_ABTWO: &str = "CR";
        /// `"CRI"`
        pub const COUNTRY_AB3: &str = "CRI";
        /// `"CR"`
        pub const COUNTRY_CAR: &str = "CR";
        /// `"9930,9977,9968"`
        pub const COUNTRY_ISBN: &str = "9930,9977,9968";
        /// `"Costa Rica"`
        pub const COUNTRY_NAME: &str = "Costa Rica";
        /// `188`
        pub const COUNTRY_NUM: i64 = 188;
        /// `"CR"`
        pub const COUNTRY_POST: &str = "CR";
        /// `"es"`
        pub const LANG_AB: &str = "es";
        /// `"spa"`
        pub const LANG_LIB: &str = "spa";
        /// `"español"`
        pub const LANG_NAME: &str = "español";
        /// `"spa"`
        pub const LANG_TERM: &str = "spa";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"https://www.gnu.org/software/libc/"`
        pub const ADDRESS: &str = "https://www.gnu.org/software/libc/";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2009-12-23"`
        pub const DATE: &str = "2009-12-23";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Spanish"`
        pub const LANGUAGE: &str = "Spanish";
        /// `"1.1"`
        pub const REVISION: &str = "1.1";
        /// `"Free Software Foundation, Inc."`
        pub const SOURCE: &str = "Free Software Foundation, Inc.";
        /// `""`
        pub const TEL: &str = "";
        /// `"Costa Rica"`
        pub const TERRITORY: &str = "Costa Rica";
        /// `"Spanish locale for Costa Rica"`
        pub const TITLE: &str = "Spanish locale for Costa Rica";
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"₡"`
        pub const CURRENCY_SYMBOL: &str = "₡";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"CRC "`
        pub const INT_CURR_SYMBOL: &str = "CRC ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const THOUSANDS_SEP: &str = "\u{202f}";
    }
    pub mod LC_TELEPHONE {
        /// `"506"`
        pub const INT_PREFIX: &str = "506";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"%l"`
        pub const TEL_DOM_FMT: &str = "%l";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `&["a.m.", "p.m."]`
        pub const AM_PM: &[&str] = &["a.m.", "p.m."];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `"%a %e %b %H:%M:%S %Z %Y"`
        pub const DATE_FMT: &str = "%a %e %b %H:%M:%S %Z %Y";
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_CU {
    pub mod LC_ADDRESS {
        /// `"CU"`
        pub const COUNTRY_ABTWO: &str = "CU";
        /// `"CUB"`
        pub const COUNTRY_AB3: &str = "CUB";
        /// `"C"`
        pub const COUNTRY_CAR: &str = "C";
        /// `"Cuba"`
        pub const COUNTRY_NAME: &str = "Cuba";
        /// `192`
        pub const COUNTRY_NUM: i64 = 192;
        /// `"es"`
        pub const LANG_AB: &str = "es";
        /// `"spa"`
        pub const LANG_LIB: &str = "spa";
        /// `"español"`
        pub const LANG_NAME: &str = "español";
        /// `"spa"`
        pub const LANG_TERM: &str = "spa";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"San Antonio de los Baøos Highway, Kilometer 1 1/2, University of Informatic Sciences "`
        pub const ADDRESS: &str = "San Antonio de los Baøos Highway, Kilometer 1 1/2, University of Informatic Sciences ";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2011-10-19"`
        pub const DATE: &str = "2011-10-19";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Spanish"`
        pub const LANGUAGE: &str = "Spanish";
        /// `"0.1"`
        pub const REVISION: &str = "0.1";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"Cuba"`
        pub const TERRITORY: &str = "Cuba";
        /// `"Spanish locale for Cuba"`
        pub const TITLE: &str = "Spanish locale for Cuba";
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"CUP "`
        pub const INT_CURR_SYMBOL: &str = "CUP ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[0, 0]`
        pub const GROUPING: &[i64] = &[0, 0];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `"53"`
        pub const INT_PREFIX: &str = "53";
        /// `"119"`
        pub const INT_SELECT: &str = "119";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub use super::es_BO::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_DO {
    pub mod LC_ADDRESS {
        /// `"DO"`
        pub const COUNTRY_ABTWO: &str = "DO";
        /// `"DOM"`
        pub const COUNTRY_AB3: &str = "DOM";
        /// `"DOM"`
        pub const COUNTRY_CAR: &str = "DOM";
        /// `"República Dominicana"`
        pub const COUNTRY_NAME: &str = "República Dominicana";
        /// `214`
        pub const COUNTRY_NUM: i64 = 214;
        /// `"es"`
        pub const LANG_AB: &str = "es";
        /// `"spa"`
        pub const LANG_LIB: &str = "spa";
        /// `"español"`
        pub const LANG_NAME: &str = "español";
        /// `"spa"`
        pub const LANG_TERM: &str = "spa";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Spanish"`
        pub const LANGUAGE: &str = "Spanish";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Dominican Republic"`
        pub const TERRITORY: &str = "Dominican Republic";
        /// `"Spanish locale for Dominican Republic"`
        pub const TITLE: &str = "Spanish locale for Dominican Republic";
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"RD$"`
        pub const CURRENCY_SYMBOL: &str = "RD$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"DOP "`
        pub const INT_CURR_SYMBOL: &str = "DOP ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"1"`
        pub const INT_PREFIX: &str = "1";
        /// `"011"`
        pub const INT_SELECT: &str = "011";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_EC {
    pub mod LC_ADDRESS {
        /// `"EC"`
        pub const COUNTRY_ABTWO: &str = "EC";
        /// `"ECU"`
        pub const COUNTRY_AB3: &str = "ECU";
        /// `"EC"`
        pub const COUNTRY_CAR: &str = "EC";
        /// `"Ecuador"`
        pub const COUNTRY_NAME: &str = "Ecuador";
        /// `218`
        pub const COUNTRY_NUM: i64 = 218;
        /// `"es"`
        pub const LANG_AB: &str = "es";
        /// `"spa"`
        pub const LANG_LIB: &str = "spa";
        /// `"español"`
        pub const LANG_NAME: &str = "español";
        /// `"spa"`
        pub const LANG_TERM: &str = "spa";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Spanish"`
        pub const LANGUAGE: &str = "Spanish";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Ecuador"`
        pub const TERRITORY: &str = "Ecuador";
        /// `"Spanish locale for Ecuador"`
        pub const TITLE: &str = "Spanish locale for Ecuador";
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"USD "`
        pub const INT_CURR_SYMBOL: &str = "USD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub use super::es_ES::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `"593"`
        pub const INT_PREFIX: &str = "593";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub use super::es_BO::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_ES {
    pub mod LC_ADDRESS {
        /// `"ES"`
        pub const COUNTRY_ABTWO: &str = "ES";
        /// `"ESP"`
        pub const COUNTRY_AB3: &str = "ESP";
        /// `"E"`
        pub const COUNTRY_CAR: &str = "E";
        /// `"España"`
        pub const COUNTRY_NAME: &str = "España";
        /// `724`
        pub const COUNTRY_NUM: i64 = 724;
        /// `"es"`
        pub const LANG_AB: &str = "es";
        /// `"spa"`
        pub const LANG_LIB: &str = "spa";
        /// `"español"`
        pub const LANG_NAME: &str = "español";
        /// `"spa"`
        pub const LANG_TERM: &str = "spa";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"European Spanish"`
        pub const LANGUAGE: &str = "European Spanish";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Spain"`
        pub const TERRITORY: &str = "Spain";
        /// `"Spanish locale for Spain"`
        pub const TITLE: &str = "Spanish locale for Spain";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"no"`
        pub const NOSTR: &str = "no";
        /// `"^[+1sSyY]"`
        pub const YESEXPR: &str = "^[+1sSyY]";
        /// `"sí"`
        pub const YESSTR: &str = "sí";
    }
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `"34"`
        pub const INT_PREFIX: &str = "34";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_ES_euro {
    pub use super::es_ES::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `"https://www.gnu.org/software/libc/"`
        pub const ADDRESS: &str = "https://www.gnu.org/software/libc/";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Spanish"`
        pub const LANGUAGE: &str = "Spanish";
        /// `"Free Software Foundation, Inc."`
        pub const SOURCE: &str = "Free Software Foundation, Inc.";
        /// `""`
        pub const TEL: &str = "";
        /// `"Spain"`
        pub const TERRITORY: &str = "Spain";
        /// `"Spanish locale for Spain with Euro"`
        pub const TITLE: &str = "Spanish locale for Spain with Euro";
    }
    pub use super::es_ES::LC_MESSAGES;
    pub use super::es_ES::LC_MONETARY;
    pub use super::es_ES::LC_NUMERIC;
    pub use super::es_ES::LC_TELEPHONE;
    pub use super::es_ES::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_GT {
    pub mod LC_ADDRESS {
        /// `"GT"`
        pub const COUNTRY_ABTWO: &str = "GT";
        /// `"GTM"`
        pub const COUNTRY_AB3: &str = "GTM";
        /// `"GCA"`
        pub const COUNTRY_CAR: &str = "GCA";
        /// `"Guatemala"`
        pub const COUNTRY_NAME: &str = "Guatemala";
        /// `320`
        pub const COUNTRY_NUM: i64 = 320;
        /// `"es"`
        pub const LANG_AB: &str = "es";
        /// `"spa"`
        pub const LANG_LIB: &str = "spa";
        /// `"español"`
        pub const LANG_NAME: &str = "español";
        /// `"spa"`
        pub const LANG_TERM: &str = "spa";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Spanish"`
        pub const LANGUAGE: &str = "Spanish";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Guatemala"`
        pub const TERRITORY: &str = "Guatemala";
        /// `"Spanish locale for Guatemala"`
        pub const TITLE: &str = "Spanish locale for Guatemala";
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"Q"`
        pub const CURRENCY_SYMBOL: &str = "Q";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"GTQ "`
        pub const INT_CURR_SYMBOL: &str = "GTQ ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"502"`
        pub const INT_PREFIX: &str = "502";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_HN {
    pub mod LC_ADDRESS {
        /// `"HN"`
        pub const COUNTRY_ABTWO: &str = "HN";
        /// `"HND"`
        pub const COUNTRY_AB3: &str = "HND";
        /// `"HN"`
        pub const COUNTRY_CAR: &str = "HN";
        /// `"Honduras"`
        pub const COUNTRY_NAME: &str = "Honduras";
        /// `340`
        pub const COUNTRY_NUM: i64 = 340;
        /// `"es"`
        pub const LANG_AB: &str = "es";
        /// `"spa"`
        pub const LANG_LIB: &str = "spa";
        /// `"español"`
        pub const LANG_NAME: &str = "español";
        /// `"spa"`
        pub const LANG_TERM: &str = "spa";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Spanish"`
        pub const LANGUAGE: &str = "Spanish";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Honduras"`
        pub const TERRITORY: &str = "Honduras";
        /// `"Spanish locale for Honduras"`
        pub const TITLE: &str = "Spanish locale for Honduras";
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"L"`
        pub const CURRENCY_SYMBOL: &str = "L";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"HNL "`
        pub const INT_CURR_SYMBOL: &str = "HNL ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"504"`
        pub const INT_PREFIX: &str = "504";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_MX {
    pub mod LC_ADDRESS {
        /// `"MX"`
        pub const COUNTRY_ABTWO: &str = "MX";
        /// `"MEX"`
        pub const COUNTRY_AB3: &str = "MEX";
        /// `"MEX"`
        pub const COUNTRY_CAR: &str = "MEX";
        /// `"México"`
        pub const COUNTRY_NAME: &str = "México";
        /// `484`
        pub const COUNTRY_NUM: i64 = 484;
        /// `"es"`
        pub const LANG_AB: &str = "es";
        /// `"spa"`
        pub const LANG_LIB: &str = "spa";
        /// `"español"`
        pub const LANG_NAME: &str = "español";
        /// `"spa"`
        pub const LANG_TERM: &str = "spa";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Mexican Spanish"`
        pub const LANGUAGE: &str = "Mexican Spanish";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Mexico"`
        pub const TERRITORY: &str = "Mexico";
        /// `"Spanish locale for Mexico"`
        pub const TITLE: &str = "Spanish locale for Mexico";
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"MXN "`
        pub const INT_CURR_SYMBOL: &str = "MXN ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const THOUSANDS_SEP: &str = "\u{202f}";
    }
    pub mod LC_TELEPHONE {
        /// `"52"`
        pub const INT_PREFIX: &str = "52";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_NI {
    pub mod LC_ADDRESS {
        /// `"NI"`
        pub const COUNTRY_ABTWO: &str = "NI";
        /// `"NIC"`
        pub const COUNTRY_AB3: &str = "NIC";
        /// `"NIC"`
        pub const COUNTRY_CAR: &str = "NIC";
        /// `"Nicaragua"`
        pub const COUNTRY_NAME: &str = "Nicaragua";
        /// `558`
        pub const COUNTRY_NUM: i64 = 558;
        /// `"es"`
        pub const LANG_AB: &str = "es";
        /// `"spa"`
        pub const LANG_LIB: &str = "spa";
        /// `"español"`
        pub const LANG_NAME: &str = "español";
        /// `"spa"`
        pub const LANG_TERM: &str = "spa";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"https://www.gnu.org/software/libc/"`
        pub const ADDRESS: &str = "https://www.gnu.org/software/libc/";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-08-21"`
        pub const DATE: &str = "2000-08-21";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Spanish"`
        pub const LANGUAGE: &str = "Spanish";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Free Software Foundation, Inc."`
        pub const SOURCE: &str = "Free Software Foundation, Inc.";
        /// `""`
        pub const TEL: &str = "";
        /// `"Nicaragua"`
        pub const TERRITORY: &str = "Nicaragua";
        /// `"Spanish locale for Nicaragua"`
        pub const TITLE: &str = "Spanish locale for Nicaragua";
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"C$"`
        pub const CURRENCY_SYMBOL: &str = "C$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"NIO "`
        pub const INT_CURR_SYMBOL: &str = "NIO ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"505"`
        pub const INT_PREFIX: &str = "505";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_PA {
    pub mod LC_ADDRESS {
        /// `"PA"`
        pub const COUNTRY_ABTWO: &str = "PA";
        /// `"PAN"`
        pub const COUNTRY_AB3: &str = "PAN";
        /// `"PA"`
        pub const COUNTRY_CAR: &str = "PA";
        /// `"Panamá"`
        pub const COUNTRY_NAME: &str = "Panamá";
        /// `591`
        pub const COUNTRY_NUM: i64 = 591;
        /// `"es"`
        pub const LANG_AB: &str = "es";
        /// `"spa"`
        pub const LANG_LIB: &str = "spa";
        /// `"español"`
        pub const LANG_NAME: &str = "español";
        /// `"spa"`
        pub const LANG_TERM: &str = "spa";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Spanish"`
        pub const LANGUAGE: &str = "Spanish";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Panama"`
        pub const TERRITORY: &str = "Panama";
        /// `"Spanish locale for Panama"`
        pub const TITLE: &str = "Spanish locale for Panama";
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"B/."`
        pub const CURRENCY_SYMBOL: &str = "B/.";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"PAB "`
        pub const INT_CURR_SYMBOL: &str = "PAB ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"507"`
        pub const INT_PREFIX: &str = "507";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_PE {
    pub mod LC_ADDRESS {
        /// `"PE"`
        pub const COUNTRY_ABTWO: &str = "PE";
        /// `"PER"`
        pub const COUNTRY_AB3: &str = "PER";
        /// `"PE"`
        pub const COUNTRY_CAR: &str = "PE";
        /// `"Perú"`
        pub const COUNTRY_NAME: &str = "Perú";
        /// `604`
        pub const COUNTRY_NUM: i64 = 604;
        /// `"es"`
        pub const LANG_AB: &str = "es";
        /// `"spa"`
        pub const LANG_LIB: &str = "spa";
        /// `"español"`
        pub const LANG_NAME: &str = "español";
        /// `"spa"`
        pub const LANG_TERM: &str = "spa";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Spanish"`
        pub const LANGUAGE: &str = "Spanish";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Peru"`
        pub const TERRITORY: &str = "Peru";
        /// `"Spanish locale for Peru"`
        pub const TITLE: &str = "Spanish locale for Peru";
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"S/"`
        pub const CURRENCY_SYMBOL: &str = "S/";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"PEN "`
        pub const INT_CURR_SYMBOL: &str = "PEN ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub use super::es_ES::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `"51"`
        pub const INT_PREFIX: &str = "51";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "set", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "set", "oct", "nov", "dic"];
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "setiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "setiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_PR {
    pub mod LC_ADDRESS {
        /// `"PR"`
        pub const COUNTRY_ABTWO: &str = "PR";
        /// `"PRI"`
        pub const COUNTRY_AB3: &str = "PRI";
        /// `"PR"`
        pub const COUNTRY_CAR: &str = "PR";
        /// `"Puerto Rico"`
        pub const COUNTRY_NAME: &str = "Puerto Rico";
        /// `630`
        pub const COUNTRY_NUM: i64 = 630;
        /// `"es"`
        pub const LANG_AB: &str = "es";
        /// `"spa"`
        pub const LANG_LIB: &str = "spa";
        /// `"español"`
        pub const LANG_NAME: &str = "español";
        /// `"spa"`
        pub const LANG_TERM: &str = "spa";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"https://www.gnu.org/software/libc/"`
        pub const ADDRESS: &str = "https://www.gnu.org/software/libc/";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-08-21"`
        pub const DATE: &str = "2000-08-21";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Spanish"`
        pub const LANGUAGE: &str = "Spanish";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Free Software Foundation, Inc."`
        pub const SOURCE: &str = "Free Software Foundation, Inc.";
        /// `""`
        pub const TEL: &str = "";
        /// `"Puerto Rico"`
        pub const TERRITORY: &str = "Puerto Rico";
        /// `"Spanish locale for Puerto Rico"`
        pub const TITLE: &str = "Spanish locale for Puerto Rico";
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"USD "`
        pub const INT_CURR_SYMBOL: &str = "USD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"1"`
        pub const INT_PREFIX: &str = "1";
        /// `"011"`
        pub const INT_SELECT: &str = "011";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_PY {
    pub mod LC_ADDRESS {
        /// `"PY"`
        pub const COUNTRY_ABTWO: &str = "PY";
        /// `"PRY"`
        pub const COUNTRY_AB3: &str = "PRY";
        /// `"PY"`
        pub const COUNTRY_CAR: &str = "PY";
        /// `"Paraguay"`
        pub const COUNTRY_NAME: &str = "Paraguay";
        /// `600`
        pub const COUNTRY_NUM: i64 = 600;
        /// `"es"`
        pub const LANG_AB: &str = "es";
        /// `"spa"`
        pub const LANG_LIB: &str = "spa";
        /// `"español"`
        pub const LANG_NAME: &str = "español";
        /// `"spa"`
        pub const LANG_TERM: &str = "spa";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Spanish"`
        pub const LANGUAGE: &str = "Spanish";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Paraguay"`
        pub const TERRITORY: &str = "Paraguay";
        /// `"Spanish locale for Paraguay"`
        pub const TITLE: &str = "Spanish locale for Paraguay";
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"Gs."`
        pub const CURRENCY_SYMBOL: &str = "Gs.";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"PYG "`
        pub const INT_CURR_SYMBOL: &str = "PYG ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub use super::es_ES::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `"595"`
        pub const INT_PREFIX: &str = "595";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_SV {
    pub mod LC_ADDRESS {
        /// `"SV"`
        pub const COUNTRY_ABTWO: &str = "SV";
        /// `"SLV"`
        pub const COUNTRY_AB3: &str = "SLV";
        /// `"ES"`
        pub const COUNTRY_CAR: &str = "ES";
        /// `"El Salvador"`
        pub const COUNTRY_NAME: &str = "El Salvador";
        /// `222`
        pub const COUNTRY_NUM: i64 = 222;
        /// `"es"`
        pub const LANG_AB: &str = "es";
        /// `"spa"`
        pub const LANG_LIB: &str = "spa";
        /// `"español"`
        pub const LANG_NAME: &str = "español";
        /// `"spa"`
        pub const LANG_TERM: &str = "spa";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Spanish"`
        pub const LANGUAGE: &str = "Spanish";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"El Salvador"`
        pub const TERRITORY: &str = "El Salvador";
        /// `"Spanish locale for El Salvador"`
        pub const TITLE: &str = "Spanish locale for El Salvador";
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"USD "`
        pub const INT_CURR_SYMBOL: &str = "USD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"503"`
        pub const INT_PREFIX: &str = "503";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_US {
    pub mod LC_ADDRESS {
        /// `"US"`
        pub const COUNTRY_ABTWO: &str = "US";
        /// `"USA"`
        pub const COUNTRY_AB3: &str = "USA";
        /// `"USA"`
        pub const COUNTRY_CAR: &str = "USA";
        /// `0`
        pub const COUNTRY_ISBN: i64 = 0;
        /// `"Estados Unidos"`
        pub const COUNTRY_NAME: &str = "Estados Unidos";
        /// `840`
        pub const COUNTRY_NUM: i64 = 840;
        /// `"USA"`
        pub const COUNTRY_POST: &str = "USA";
        /// `"es"`
        pub const LANG_AB: &str = "es";
        /// `"spa"`
        pub const LANG_LIB: &str = "spa";
        /// `"español"`
        pub const LANG_NAME: &str = "español";
        /// `"spa"`
        pub const LANG_TERM: &str = "spa";
        /// `"%a%N%f%N%d%N%b%N%h %s %e %r%N%T, %S %z%N%c%N"`
        pub const POSTAL_FMT: &str = "%a%N%f%N%d%N%b%N%h %s %e %r%N%T, %S %z%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Spanish"`
        pub const LANGUAGE: &str = "Spanish";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"United States"`
        pub const TERRITORY: &str = "United States";
        /// `"Spanish locale for the USA"`
        pub const TITLE: &str = "Spanish locale for the USA";
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"USD "`
        pub const INT_CURR_SYMBOL: &str = "USD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub use super::en_US::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `"1"`
        pub const INT_PREFIX: &str = "1";
        /// `"11"`
        pub const INT_SELECT: &str = "11";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_UY {
    pub mod LC_ADDRESS {
        /// `"UY"`
        pub const COUNTRY_ABTWO: &str = "UY";
        /// `"URY"`
        pub const COUNTRY_AB3: &str = "URY";
        /// `"UY"`
        pub const COUNTRY_CAR: &str = "UY";
        /// `"Uruguay"`
        pub const COUNTRY_NAME: &str = "Uruguay";
        /// `858`
        pub const COUNTRY_NUM: i64 = 858;
        /// `"es"`
        pub const LANG_AB: &str = "es";
        /// `"spa"`
        pub const LANG_LIB: &str = "spa";
        /// `"español"`
        pub const LANG_NAME: &str = "español";
        /// `"spa"`
        pub const LANG_TERM: &str = "spa";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Spanish"`
        pub const LANGUAGE: &str = "Spanish";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Uruguay"`
        pub const TERRITORY: &str = "Uruguay";
        /// `"Spanish locale for Uruguay"`
        pub const TITLE: &str = "Spanish locale for Uruguay";
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"UYU "`
        pub const INT_CURR_SYMBOL: &str = "UYU ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub use super::es_ES::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `"598"`
        pub const INT_PREFIX: &str = "598";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "set", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "set", "oct", "nov", "dic"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "setiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "setiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod es_VE {
    pub mod LC_ADDRESS {
        /// `"VE"`
        pub const COUNTRY_ABTWO: &str = "VE";
        /// `"VEN"`
        pub const COUNTRY_AB3: &str = "VEN";
        /// `"YV"`
        pub const COUNTRY_CAR: &str = "YV";
        /// `"Venezuela"`
        pub const COUNTRY_NAME: &str = "Venezuela";
        /// `862`
        pub const COUNTRY_NUM: i64 = 862;
        /// `"es"`
        pub const LANG_AB: &str = "es";
        /// `"spa"`
        pub const LANG_LIB: &str = "spa";
        /// `"español"`
        pub const LANG_NAME: &str = "español";
        /// `"spa"`
        pub const LANG_TERM: &str = "spa";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Spanish"`
        pub const LANGUAGE: &str = "Spanish";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Venezuela"`
        pub const TERRITORY: &str = "Venezuela";
        /// `"Spanish locale for Venezuela"`
        pub const TITLE: &str = "Spanish locale for Venezuela";
    }
    pub use super::es_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"Bs."`
        pub const CURRENCY_SYMBOL: &str = "Bs.";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"VEF "`
        pub const INT_CURR_SYMBOL: &str = "VEF ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub use super::es_ES::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `"58"`
        pub const INT_PREFIX: &str = "58";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mié", "jue", "vie", "sáb"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mié", "jue", "vie", "sáb"];
        /// `&["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"]`
        pub const ABMON: &[&str] = &["ene", "feb", "mar", "abr", "may", "jun", "jul", "ago", "sep", "oct", "nov", "dic"];
        /// `&["am", "pm"]`
        pub const AM_PM: &[&str] = &["am", "pm"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"]`
        pub const DAY: &[&str] = &["domingo", "lunes", "martes", "miércoles", "jueves", "viernes", "sábado"];
        /// `&["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"]`
        pub const MON: &[&str] = &["enero", "febrero", "marzo", "abril", "mayo", "junio", "julio", "agosto", "septiembre", "octubre", "noviembre", "diciembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod et_EE {
    pub mod LC_ADDRESS {
        /// `"EE"`
        pub const COUNTRY_ABTWO: &str = "EE";
        /// `"EST"`
        pub const COUNTRY_AB3: &str = "EST";
        /// `"EST"`
        pub const COUNTRY_CAR: &str = "EST";
        /// `"978-9949,978-9985"`
        pub const COUNTRY_ISBN: &str = "978-9949,978-9985";
        /// `"Eesti"`
        pub const COUNTRY_NAME: &str = "Eesti";
        /// `233`
        pub const COUNTRY_NUM: i64 = 233;
        /// `"EE"`
        pub const COUNTRY_POST: &str = "EE";
        /// `"et"`
        pub const LANG_AB: &str = "et";
        /// `"est"`
        pub const LANG_LIB: &str = "est";
        /// `"eesti"`
        pub const LANG_NAME: &str = "eesti";
        /// `"est"`
        pub const LANG_TERM: &str = "est";
        /// `"%a%N%f%N%d%N%b%N%s%t%h%t%e%t%r%N%C-%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%a%N%f%N%d%N%b%N%s%t%h%t%e%t%r%N%C-%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"To-nisma:gi 8, Tallinn, EE0100 Estonia"`
        pub const ADDRESS: &str = "To-nisma:gi 8, Tallinn, EE0100 Estonia";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Estonian"`
        pub const LANGUAGE: &str = "Estonian";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Estonian Informatics Fund"`
        pub const SOURCE: &str = "Estonian Informatics Fund";
        /// `""`
        pub const TEL: &str = "";
        /// `"Estonia"`
        pub const TERRITORY: &str = "Estonia";
        /// `"Estonian locale for Estonia"`
        pub const TITLE: &str = "Estonian locale for Estonia";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0EeNn]"`
        pub const NOEXPR: &str = "^[-0EeNn]";
        /// `"ei"`
        pub const NOSTR: &str = "ei";
        /// `"^[+1JjYy]"`
        pub const YESEXPR: &str = "^[+1JjYy]";
        /// `"jah"`
        pub const YESSTR: &str = "jah";
    }
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const THOUSANDS_SEP: &str = "\u{202f}";
    }
    pub mod LC_TELEPHONE {
        /// `"372"`
        pub const INT_PREFIX: &str = "372";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["P", "E", "T", "K", "N", "R", "L"]`
        pub const ABDAY: &[&str] = &["P", "E", "T", "K", "N", "R", "L"];
        /// `&["jaan ", "veebr", "märts", "apr  ", "mai  ", "juuni", "juuli", "aug  ", "sept ", "okt  ", "nov  ", "dets "]`
        pub const ABMON: &[&str] = &["jaan ", "veebr", "märts", "apr  ", "mai  ", "juuni", "juuli", "aug  ", "sept ", "okt  ", "nov  ", "dets "];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["pühapäev", "esmaspäev", "teisipäev", "kolmapäev", "neljapäev", "reede", "laupäev"]`
        pub const DAY: &[&str] = &["pühapäev", "esmaspäev", "teisipäev", "kolmapäev", "neljapäev", "reede", "laupäev"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["jaanuar", "veebruar", "märts", "aprill", "mai", "juuni", "juuli", "august", "september", "oktoober", "november", "detsember"]`
        pub const MON: &[&str] = &["jaanuar", "veebruar", "märts", "aprill", "mai", "juuni", "juuli", "august", "september", "oktoober", "november", "detsember"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod eu_ES {
    pub mod LC_ADDRESS {
        /// `"ES"`
        pub const COUNTRY_ABTWO: &str = "ES";
        /// `"ESP"`
        pub const COUNTRY_AB3: &str = "ESP";
        /// `"E"`
        pub const COUNTRY_CAR: &str = "E";
        /// `"Espainia"`
        pub const COUNTRY_NAME: &str = "Espainia";
        /// `724`
        pub const COUNTRY_NUM: i64 = 724;
        /// `"eu"`
        pub const LANG_AB: &str = "eu";
        /// `"baq"`
        pub const LANG_LIB: &str = "baq";
        /// `"euskara"`
        pub const LANG_NAME: &str = "euskara";
        /// `"eus"`
        pub const LANG_TERM: &str = "eus";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Basque"`
        pub const LANGUAGE: &str = "Basque";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Spain"`
        pub const TERRITORY: &str = "Spain";
        /// `"Basque locale for Spain"`
        pub const TITLE: &str = "Basque locale for Spain";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0eEnN]"`
        pub const NOEXPR: &str = "^[-0eEnN]";
        /// `"ez"`
        pub const NOSTR: &str = "ez";
        /// `"^[+1bBsSyY]"`
        pub const YESEXPR: &str = "^[+1bBsSyY]";
        /// `"bai"`
        pub const YESSTR: &str = "bai";
    }
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `"34"`
        pub const INT_PREFIX: &str = "34";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["ig.", "al.", "ar.", "az.", "og.", "or.", "lr."]`
        pub const ABDAY: &[&str] = &["ig.", "al.", "ar.", "az.", "og.", "or.", "lr."];
        /// `&["urt", "ots", "mar", "api", "mai", "eka", "uzt", "abu", "ira", "urr", "aza", "abe"]`
        pub const ABMON: &[&str] = &["urt", "ots", "mar", "api", "mai", "eka", "uzt", "abu", "ira", "urr", "aza", "abe"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%a, %Y.eko %bren %da"`
        pub const D_FMT: &str = "%a, %Y.eko %bren %da";
        /// `"%y-%m-%d %T %Z"`
        pub const D_T_FMT: &str = "%y-%m-%d %T %Z";
        /// `&["igandea", "astelehena", "asteartea", "asteazkena", "osteguna", "ostirala", "larunbata"]`
        pub const DAY: &[&str] = &["igandea", "astelehena", "asteartea", "asteazkena", "osteguna", "ostirala", "larunbata"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["urtarrila", "otsaila", "martxoa", "apirila", "maiatza", "ekaina", "uztaila", "abuztua", "iraila", "urria", "azaroa", "abendua"]`
        pub const MON: &[&str] = &["urtarrila", "otsaila", "martxoa", "apirila", "maiatza", "ekaina", "uztaila", "abuztua", "iraila", "urria", "azaroa", "abendua"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod eu_ES_euro {
    pub use super::eu_ES::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `"https://www.gnu.org/software/libc/"`
        pub const ADDRESS: &str = "https://www.gnu.org/software/libc/";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-08-21"`
        pub const DATE: &str = "2000-08-21";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Basque"`
        pub const LANGUAGE: &str = "Basque";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Free Software Foundation, Inc."`
        pub const SOURCE: &str = "Free Software Foundation, Inc.";
        /// `""`
        pub const TEL: &str = "";
        /// `"Spain"`
        pub const TERRITORY: &str = "Spain";
        /// `"Basque language locale for Spain with Euro"`
        pub const TITLE: &str = "Basque language locale for Spain with Euro";
    }
    pub use super::eu_ES::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `0`
        pub const FRAC_DIGITS: i64 = 0;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `0`
        pub const INT_FRAC_DIGITS: i64 = 0;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub use super::eu_ES::LC_NUMERIC;
    pub use super::eu_ES::LC_TELEPHONE;
    pub use super::eu_ES::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod fa_IR {
    pub mod LC_ADDRESS {
        /// `"IR"`
        pub const COUNTRY_ABTWO: &str = "IR";
        /// `"IRN"`
        pub const COUNTRY_AB3: &str = "IRN";
        /// `"IR"`
        pub const COUNTRY_CAR: &str = "IR";
        /// `964`
        pub const COUNTRY_ISBN: i64 = 964;
        /// `"ایران"`
        pub const COUNTRY_NAME: &str = "ایران";
        /// `364`
        pub const COUNTRY_NUM: i64 = 364;
        /// `"fa"`
        pub const LANG_AB: &str = "fa";
        /// `"per"`
        pub const LANG_LIB: &str = "per";
        /// `"فارسی"`
        pub const LANG_NAME: &str = "فارسی";
        /// `"fas"`
        pub const LANG_TERM: &str = "fas";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"5, Shahid Ghasemi Habibollah, Azadi Ave, Tehran, Iran"`
        pub const ADDRESS: &str = "5, Shahid Ghasemi Habibollah, Azadi Ave, Tehran, Iran";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `"Roozbeh Pournader"`
        pub const CONTACT: &str = "Roozbeh Pournader";
        /// `"2005-04-06"`
        pub const DATE: &str = "2005-04-06";
        /// `"roozbeh@farsiweb.info"`
        pub const EMAIL: &str = "roozbeh@farsiweb.info";
        /// `""`
        pub const FAX: &str = "";
        /// `"Persian"`
        pub const LANGUAGE: &str = "Persian";
        /// `"3.0"`
        pub const REVISION: &str = "3.0";
        /// `"Sharif FarsiWeb, Inc."`
        pub const SOURCE: &str = "Sharif FarsiWeb, Inc.";
        /// `""`
        pub const TEL: &str = "";
        /// `"Iran"`
        pub const TERRITORY: &str = "Iran";
        /// `"Persian locale for Iran"`
        pub const TITLE: &str = "Persian locale for Iran";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNخنok]"`
        pub const NOEXPR: &str = "^[-0nNخنok]";
        /// `"نه"`
        pub const NOSTR: &str = "نه";
        /// `"^[+1yYآبHf]"`
        pub const YESEXPR: &str = "^[+1yYآبHf]";
        /// `"بله"`
        pub const YESSTR: &str = "بله";
    }
    pub mod LC_MONETARY {
        /// `"ریال"`
        pub const CURRENCY_SYMBOL: &str = "ریال";
        /// `0`
        pub const FRAC_DIGITS: i64 = 0;
        /// `"IRR "`
        pub const INT_CURR_SYMBOL: &str = "IRR ";
        /// `0`
        pub const INT_FRAC_DIGITS: i64 = 0;
        /// `0`
        pub const INT_N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const INT_N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const INT_N_SIGN_POSN: i64 = 1;
        /// `0`
        pub const INT_P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const INT_P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const INT_P_SIGN_POSN: i64 = 1;
        /// `"٫"`
        pub const MON_DECIMAL_POINT: &str = "٫";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `"٬"`
        pub const MON_THOUSANDS_SEP: &str = "٬";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"98"`
        pub const INT_PREFIX: &str = "98";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"\u{202a}%A‒%l\u{202c}"`
        pub const TEL_DOM_FMT: &str = "\u{202a}%A‒%l\u{202c}";
        /// `"\u{202a}+%c %a %l\u{202c}"`
        pub const TEL_INT_FMT: &str = "\u{202a}+%c %a %l\u{202c}";
    }
    pub mod LC_TIME {
        /// `&["یکشنبه", "دوشنبه", "سه\u{200c}شنبه", "چهارشنبه", "پنجشنبه", "جمعه", "شنبه"]`
        pub const ABDAY: &[&str] = &["یکشنبه", "دوشنبه", "سه\u{200c}شنبه", "چهارشنبه", "پنجشنبه", "جمعه", "شنبه"];
        /// `&["ژانویه", "فوریه", "مارس", "آوریل", "مه", "ژوئن", "ژوئیه", "اوت", "سپتامبر", "اكتبر", "نوامبر", "دسامبر"]`
        pub const ABMON: &[&str] = &["ژانویه", "فوریه", "مارس", "آوریل", "مه", "ژوئن", "ژوئیه", "اوت", "سپتامبر", "اكتبر", "نوامبر", "دسامبر"];
        /// `&["۰۰", "۰۱", "۰۲", "۰۳", "۰۴", "۰۵", "۰۶", "۰۷", "۰۸", "۰۹", "۱۰", "۱۱", "۱۲", "۱۳", "۱۴", "۱۵", "۱۶", "۱۷", "۱۸", "۱۹", "۲۰", "۲۱", "۲۲", "۲۳", "۲۴", "۲۵", "۲۶", "۲۷", "۲۸", "۲۹", "۳۰", "۳۱", "۳۲", "۳۳", "۳۴", "۳۵", "۳۶", "۳۷", "۳۸", "۳۹", "۴۰", "۴۱", "۴۲", "۴۳", "۴۴", "۴۵", "۴۶", "۴۷", "۴۸", "۴۹", "۵۰", "۵۱", "۵۲", "۵۳", "۵۴", "۵۵", "۵۶", "۵۷", "۵۸", "۵۹", "۶۰", "۶۱", "۶۲", "۶۳", "۶۴", "۶۵", "۶۶", "۶۷", "۶۸", "۶۹", "۷۰", "۷۱", "۷۲", "۷۳", "۷۴", "۷۵", "۷۶", "۷۷", "۷۸", "۷۹", "۸۰", "۸۱", "۸۲", "۸۳", "۸۴", "۸۵", "۸۶", "۸۷", "۸۸", "۸۹", "۹۰", "۹۱", "۹۲", "۹۳", "۹۴", "۹۵", "۹۶", "۹۷", "۹۸", "۹۹"]`
        pub const ALT_DIGITS: &[&str] = &["۰۰", "۰۱", "۰۲", "۰۳", "۰۴", "۰۵", "۰۶", "۰۷", "۰۸", "۰۹", "۱۰", "۱۱", "۱۲", "۱۳", "۱۴", "۱۵", "۱۶", "۱۷", "۱۸", "۱۹", "۲۰", "۲۱", "۲۲", "۲۳", "۲۴", "۲۵", "۲۶", "۲۷", "۲۸", "۲۹", "۳۰", "۳۱", "۳۲", "۳۳", "۳۴", "۳۵", "۳۶", "۳۷", "۳۸", "۳۹", "۴۰", "۴۱", "۴۲", "۴۳", "۴۴", "۴۵", "۴۶", "۴۷", "۴۸", "۴۹", "۵۰", "۵۱", "۵۲", "۵۳", "۵۴", "۵۵", "۵۶", "۵۷", "۵۸", "۵۹", "۶۰", "۶۱", "۶۲", "۶۳", "۶۴", "۶۵", "۶۶", "۶۷", "۶۸", "۶۹", "۷۰", "۷۱", "۷۲", "۷۳", "۷۴", "۷۵", "۷۶", "۷۷", "۷۸", "۷۹", "۸۰", "۸۱", "۸۲", "۸۳", "۸۴", "۸۵", "۸۶", "۸۷", "۸۸", "۸۹", "۹۰", "۹۱", "۹۲", "۹۳", "۹۴", "۹۵", "۹۶", "۹۷", "۹۸", "۹۹"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `3`
        pub const CAL_DIRECTION: i64 = 3;
        /// `"%Oy/%Om/%Od"`
        pub const D_FMT: &str = "%Oy/%Om/%Od";
        /// `"\u{202b}%A %Oe %B %Oy، %OH:%OM:%OS\u{202c}"`
        pub const D_T_FMT: &str = "\u{202b}%A %Oe %B %Oy، %OH:%OM:%OS\u{202c}";
        /// `"\u{202b}%A %Oe %B %Oy، ساعت \n%OH:%OM:%OS (%Z)\u{202c}"`
        pub const DATE_FMT: &str = "\u{202b}%A %Oe %B %Oy، ساعت \n%OH:%OM:%OS (%Z)\u{202c}";
        /// `&["یکشنبه", "دوشنبه", "سه\u{200c}شنبه", "چهارشنبه", "پنجشنبه", "جمعه", "شنبه"]`
        pub const DAY: &[&str] = &["یکشنبه", "دوشنبه", "سه\u{200c}شنبه", "چهارشنبه", "پنجشنبه", "جمعه", "شنبه"];
        /// `7`
        pub const FIRST_WEEKDAY: i64 = 7;
        /// `7`
        pub const FIRST_WORKDAY: i64 = 7;
        /// `&["ژانویه", "فوریه", "مارس", "آوریل", "مه", "ژوئن", "ژوئیه", "اوت", "سپتامبر", "اكتبر", "نوامبر", "دسامبر"]`
        pub const MON: &[&str] = &["ژانویه", "فوریه", "مارس", "آوریل", "مه", "ژوئن", "ژوئیه", "اوت", "سپتامبر", "اكتبر", "نوامبر", "دسامبر"];
        /// `"%OH:%OM:%OS"`
        pub const T_FMT: &str = "%OH:%OM:%OS";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ff_SN {
    pub mod LC_ADDRESS {
        /// `"SN"`
        pub const COUNTRY_ABTWO: &str = "SN";
        /// `"SEN"`
        pub const COUNTRY_AB3: &str = "SEN";
        /// `"SN"`
        pub const COUNTRY_CAR: &str = "SN";
        /// `"Senegaal"`
        pub const COUNTRY_NAME: &str = "Senegaal";
        /// `686`
        pub const COUNTRY_NUM: i64 = 686;
        /// `"SN"`
        pub const COUNTRY_POST: &str = "SN";
        /// `"ff"`
        pub const LANG_AB: &str = "ff";
        /// `"ful"`
        pub const LANG_LIB: &str = "ful";
        /// `"Pulaar"`
        pub const LANG_NAME: &str = "Pulaar";
        /// `"ful"`
        pub const LANG_TERM: &str = "ful";
        /// `"%a%N%f%N%d%N%b%N%h %s %e %r%N%T, %S %z%N%c%N"`
        pub const POSTAL_FMT: &str = "%a%N%f%N%d%N%b%N%h %s %e %r%N%T, %S %z%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ];
        /// `"Ibrahima Sarr"`
        pub const CONTACT: &str = "Ibrahima Sarr";
        /// `"2011-03-28"`
        pub const DATE: &str = "2011-03-28";
        /// `"admin@pulaar-fulfulde.org"`
        pub const EMAIL: &str = "admin@pulaar-fulfulde.org";
        /// `"Fulah"`
        pub const LANGUAGE: &str = "Fulah";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Pular-Fulfulde.org"`
        pub const SOURCE: &str = "Pular-Fulfulde.org";
        /// `"Senegal"`
        pub const TERRITORY: &str = "Senegal";
        /// `"Fulah locale for Senegal"`
        pub const TITLE: &str = "Fulah locale for Senegal";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNaA]"`
        pub const NOEXPR: &str = "^[-0nNaA]";
        /// `"Alaa"`
        pub const NOSTR: &str = "Alaa";
        /// `"^[+1yYeE]"`
        pub const YESEXPR: &str = "^[+1yYeE]";
        /// `"Eey"`
        pub const YESSTR: &str = "Eey";
    }
    pub mod LC_MONETARY {
        /// `"CFA"`
        pub const CURRENCY_SYMBOL: &str = "CFA";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"XOF "`
        pub const INT_CURR_SYMBOL: &str = "XOF ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `"221"`
        pub const INT_PREFIX: &str = "221";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"%a %l"`
        pub const TEL_DOM_FMT: &str = "%a %l";
        /// `"%c %a %l"`
        pub const TEL_INT_FMT: &str = "%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["dew", "aaɓ", "maw", "nje", "naa", "mwd", "hbi"]`
        pub const ABDAY: &[&str] = &["dew", "aaɓ", "maw", "nje", "naa", "mwd", "hbi"];
        /// `&["sii", "col", "mbo", "see", "duu", "kor", "mor", "juk", "slt", "yar", "jol", "bow"]`
        pub const ABMON: &[&str] = &["sii", "col", "mbo", "see", "duu", "kor", "mor", "juk", "slt", "yar", "jol", "bow"];
        /// `&["subaka", "kikiiɗe"]`
        pub const AM_PM: &[&str] = &["subaka", "kikiiɗe"];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%a %d %b %Y %R %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %R %Z";
        /// `&["dewo", "aaɓnde", "mawbaare", "njeslaare", "naasaande", "mawnde", "hoore-biir"]`
        pub const DAY: &[&str] = &["dewo", "aaɓnde", "mawbaare", "njeslaare", "naasaande", "mawnde", "hoore-biir"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["siilo", "colte", "mbooy", "seeɗto", "duujal", "korse", "morso", "juko", "siilto", "yarkomaa", "jolal", "bowte"]`
        pub const MON: &[&str] = &["siilo", "colte", "mbooy", "seeɗto", "duujal", "korse", "morso", "juko", "siilto", "yarkomaa", "jolal", "bowte"];
        /// `"%R"`
        pub const T_FMT: &str = "%R";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod fi_FI {
    pub mod LC_ADDRESS {
        /// `"FI"`
        pub const COUNTRY_ABTWO: &str = "FI";
        /// `"FIN"`
        pub const COUNTRY_AB3: &str = "FIN";
        /// `"FIN"`
        pub const COUNTRY_CAR: &str = "FIN";
        /// `952`
        pub const COUNTRY_ISBN: i64 = 952;
        /// `"Suomi"`
        pub const COUNTRY_NAME: &str = "Suomi";
        /// `246`
        pub const COUNTRY_NUM: i64 = 246;
        /// `"FI"`
        pub const COUNTRY_POST: &str = "FI";
        /// `"fi"`
        pub const LANG_AB: &str = "fi";
        /// `"fin"`
        pub const LANG_LIB: &str = "fin";
        /// `"suomi"`
        pub const LANG_NAME: &str = "suomi";
        /// `"fin"`
        pub const LANG_TERM: &str = "fin";
        /// `"%f%N%d%N%b%N%a%N%s %h%t%e%t%r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%d%N%b%N%a%N%s %h%t%e%t%r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Finnish"`
        pub const LANGUAGE: &str = "Finnish";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Finland"`
        pub const TERRITORY: &str = "Finland";
        /// `"Finnish locale for Finland"`
        pub const TITLE: &str = "Finnish locale for Finland";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0EeNn]"`
        pub const NOEXPR: &str = "^[-0EeNn]";
        /// `"ei"`
        pub const NOSTR: &str = "ei";
        /// `"^[+1KkYy]"`
        pub const YESEXPR: &str = "^[+1KkYy]";
        /// `"kyllä"`
        pub const YESSTR: &str = "kyllä";
    }
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const THOUSANDS_SEP: &str = "\u{202f}";
    }
    pub mod LC_TELEPHONE {
        /// `"358"`
        pub const INT_PREFIX: &str = "358";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"(%A) %l"`
        pub const TEL_DOM_FMT: &str = "(%A) %l";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["su", "ma", "ti", "ke", "to", "pe", "la"]`
        pub const ABDAY: &[&str] = &["su", "ma", "ti", "ke", "to", "pe", "la"];
        /// `&["tammi", "helmi", "maalis", "huhti", "touko", "kesä", "heinä", "elo", "syys", "loka", "marras", "joulu"]`
        pub const ABMON: &[&str] = &["tammi", "helmi", "maalis", "huhti", "touko", "kesä", "heinä", "elo", "syys", "loka", "marras", "joulu"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %e. %Bta %Y %H.%M.%S"`
        pub const D_T_FMT: &str = "%a %e. %Bta %Y %H.%M.%S";
        /// `"%a %-d.%-m.%Y %H.%M.%S %z"`
        pub const DATE_FMT: &str = "%a %-d.%-m.%Y %H.%M.%S %z";
        /// `&["sunnuntai", "maanantai", "tiistai", "keskiviikko", "torstai", "perjantai", "lauantai"]`
        pub const DAY: &[&str] = &["sunnuntai", "maanantai", "tiistai", "keskiviikko", "torstai", "perjantai", "lauantai"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["tammikuu", "helmikuu", "maaliskuu", "huhtikuu", "toukokuu", "kesäkuu", "heinäkuu", "elokuu", "syyskuu", "lokakuu", "marraskuu", "joulukuu"]`
        pub const MON: &[&str] = &["tammikuu", "helmikuu", "maaliskuu", "huhtikuu", "toukokuu", "kesäkuu", "heinäkuu", "elokuu", "syyskuu", "lokakuu", "marraskuu", "joulukuu"];
        /// `"%H.%M.%S"`
        pub const T_FMT: &str = "%H.%M.%S";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod fi_FI_euro {
    pub use super::fi_FI::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `"https://www.gnu.org/software/libc/"`
        pub const ADDRESS: &str = "https://www.gnu.org/software/libc/";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-08-20"`
        pub const DATE: &str = "2000-08-20";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Finnish"`
        pub const LANGUAGE: &str = "Finnish";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Free Software Foundation, Inc."`
        pub const SOURCE: &str = "Free Software Foundation, Inc.";
        /// `""`
        pub const TEL: &str = "";
        /// `"Finland"`
        pub const TERRITORY: &str = "Finland";
        /// `"Finnish locale for Finland with Euro"`
        pub const TITLE: &str = "Finnish locale for Finland with Euro";
    }
    pub use super::fi_FI::LC_MESSAGES;
    pub use super::fi_FI::LC_MONETARY;
    pub use super::fi_FI::LC_NUMERIC;
    pub use super::fi_FI::LC_TELEPHONE;
    pub use super::fi_FI::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod fil_PH {
    pub mod LC_ADDRESS {
        /// `"PH"`
        pub const COUNTRY_ABTWO: &str = "PH";
        /// `"PHL"`
        pub const COUNTRY_AB3: &str = "PHL";
        /// `"RP"`
        pub const COUNTRY_CAR: &str = "RP";
        /// `"Pilipinas"`
        pub const COUNTRY_NAME: &str = "Pilipinas";
        /// `608`
        pub const COUNTRY_NUM: i64 = 608;
        /// `"Filipino"`
        pub const LANG_NAME: &str = "Filipino";
        /// `"fil"`
        pub const LANG_TERM: &str = "fil";
        /// `"%a%N%f%N%d%N%b%N%h %s %e %r%N%T %z%N%c%N"`
        pub const POSTAL_FMT: &str = "%a%N%f%N%d%N%b%N%h %s %e %r%N%T %z%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_MONETARY"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_MONETARY"],
        ];
        /// `"Rene Torres, Pablo Saratxaga"`
        pub const CONTACT: &str = "Rene Torres, Pablo Saratxaga";
        /// `"2005-02-02"`
        pub const DATE: &str = "2005-02-02";
        /// `"rgtorre@rocketmail.com, pablo@mandrakesoft.com"`
        pub const EMAIL: &str = "rgtorre@rocketmail.com, pablo@mandrakesoft.com";
        /// `""`
        pub const FAX: &str = "";
        /// `"Filipino"`
        pub const LANGUAGE: &str = "Filipino";
        /// `"0.5"`
        pub const REVISION: &str = "0.5";
        /// `"Rene Torres"`
        pub const SOURCE: &str = "Rene Torres";
        /// `""`
        pub const TEL: &str = "";
        /// `"Philippines"`
        pub const TERRITORY: &str = "Philippines";
        /// `"Filipino language locale for Philippines"`
        pub const TITLE: &str = "Filipino language locale for Philippines";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0hHnN]"`
        pub const NOEXPR: &str = "^[-0hHnN]";
        /// `"hindi"`
        pub const NOSTR: &str = "hindi";
        /// `"^[+1oOyY]"`
        pub const YESEXPR: &str = "^[+1oOyY]";
        /// `"oo"`
        pub const YESSTR: &str = "oo";
    }
    pub mod LC_MONETARY {
        /// `"₱"`
        pub const CURRENCY_SYMBOL: &str = "₱";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"PHP "`
        pub const INT_CURR_SYMBOL: &str = "PHP ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub use super::tl_PH::LC_NUMERIC;
    pub use super::en_PH::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Lin", "Lun", "Mar", "Miy", "Huw", "Biy", "Sab"]`
        pub const ABDAY: &[&str] = &["Lin", "Lun", "Mar", "Miy", "Huw", "Biy", "Sab"];
        /// `&["Ene", "Peb", "Mar", "Abr", "May", "Hun", "Hul", "Ago", "Set", "Okt", "Nob", "Dis"]`
        pub const ABMON: &[&str] = &["Ene", "Peb", "Mar", "Abr", "May", "Hun", "Hul", "Ago", "Set", "Okt", "Nob", "Dis"];
        /// `&["N.U.", "N.H."]`
        pub const AM_PM: &[&str] = &["N.U.", "N.H."];
        /// `"%m/%d/%y"`
        pub const D_FMT: &str = "%m/%d/%y";
        /// `"%a %d %b %Y %r %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %r %Z";
        /// `&["Linggo", "Lunes", "Martes", "Miyerkoles", "Huwebes", "Biyernes", "Sabado"]`
        pub const DAY: &[&str] = &["Linggo", "Lunes", "Martes", "Miyerkoles", "Huwebes", "Biyernes", "Sabado"];
        /// `&["Enero", "Pebrero", "Marso", "Abril", "Mayo", "Hunyo", "Hulyo", "Agosto", "Setyembre", "Oktubre", "Nobyembre", "Disyembre"]`
        pub const MON: &[&str] = &["Enero", "Pebrero", "Marso", "Abril", "Mayo", "Hunyo", "Hulyo", "Agosto", "Setyembre", "Oktubre", "Nobyembre", "Disyembre"];
        /// `"%r"`
        pub const T_FMT: &str = "%r";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod fo_FO {
    pub mod LC_ADDRESS {
        /// `"FO"`
        pub const COUNTRY_ABTWO: &str = "FO";
        /// `"FRO"`
        pub const COUNTRY_AB3: &str = "FRO";
        /// `"FO"`
        pub const COUNTRY_CAR: &str = "FO";
        /// `"Føroyar"`
        pub const COUNTRY_NAME: &str = "Føroyar";
        /// `234`
        pub const COUNTRY_NUM: i64 = 234;
        /// `"fo"`
        pub const LANG_AB: &str = "fo";
        /// `"føroyskt"`
        pub const LANG_NAME: &str = "føroyskt";
        /// `"fao"`
        pub const LANG_TERM: &str = "fao";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Kollegievej 6, DK-2920 Charlottenlund, Danmark"`
        pub const ADDRESS: &str = "Kollegievej 6, DK-2920 Charlottenlund, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Faroese"`
        pub const LANGUAGE: &str = "Faroese";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Danish Standards Association"`
        pub const SOURCE: &str = "Danish Standards Association";
        /// `""`
        pub const TEL: &str = "";
        /// `"Faroe Islands"`
        pub const TERRITORY: &str = "Faroe Islands";
        /// `"Faroese locale for Faroe Islands"`
        pub const TITLE: &str = "Faroese locale for Faroe Islands";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0Nn]"`
        pub const NOEXPR: &str = "^[-0Nn]";
        /// `"nei"`
        pub const NOSTR: &str = "nei";
        /// `"^[+1JjYy]"`
        pub const YESEXPR: &str = "^[+1JjYy]";
        /// `"já"`
        pub const YESSTR: &str = "já";
    }
    pub use super::da_DK::LC_MONETARY;
    pub use super::da_DK::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `"298"`
        pub const INT_PREFIX: &str = "298";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["sun", "mán", "týs", "mik", "hós", "frí", "ley"]`
        pub const ABDAY: &[&str] = &["sun", "mán", "týs", "mik", "hós", "frí", "ley"];
        /// `&["jan", "feb", "mar", "apr", "mai", "jun", "jul", "aug", "sep", "okt", "nov", "des"]`
        pub const ABMON: &[&str] = &["jan", "feb", "mar", "apr", "mai", "jun", "jul", "aug", "sep", "okt", "nov", "des"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d/%m-%Y"`
        pub const D_FMT: &str = "%d/%m-%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["sunnudagur", "mánadagur", "týsdagur", "mikudagur", "hósdagur", "fríggjadagur", "leygardagur"]`
        pub const DAY: &[&str] = &["sunnudagur", "mánadagur", "týsdagur", "mikudagur", "hósdagur", "fríggjadagur", "leygardagur"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["januar", "februar", "mars", "apríl", "mai", "juni", "juli", "august", "september", "oktober", "november", "desember"]`
        pub const MON: &[&str] = &["januar", "februar", "mars", "apríl", "mai", "juni", "juli", "august", "september", "oktober", "november", "desember"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod fr_BE {
    pub mod LC_ADDRESS {
        /// `"BE"`
        pub const COUNTRY_ABTWO: &str = "BE";
        /// `"BEL"`
        pub const COUNTRY_AB3: &str = "BEL";
        /// `"B"`
        pub const COUNTRY_CAR: &str = "B";
        /// `"Belgique"`
        pub const COUNTRY_NAME: &str = "Belgique";
        /// `56`
        pub const COUNTRY_NUM: i64 = 56;
        /// `"fr"`
        pub const LANG_AB: &str = "fr";
        /// `"fre"`
        pub const LANG_LIB: &str = "fre";
        /// `"français"`
        pub const LANG_NAME: &str = "français";
        /// `"fra"`
        pub const LANG_TERM: &str = "fra";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"French"`
        pub const LANGUAGE: &str = "French";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Belgium"`
        pub const TERRITORY: &str = "Belgium";
        /// `"French locale for Belgium"`
        pub const TITLE: &str = "French locale for Belgium";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"non"`
        pub const NOSTR: &str = "non";
        /// `"^[+1oOjJyY]"`
        pub const YESEXPR: &str = "^[+1oOjJyY]";
        /// `"oui"`
        pub const YESSTR: &str = "oui";
    }
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `"32"`
        pub const INT_PREFIX: &str = "32";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["dim", "lun", "mar", "mer", "jeu", "ven", "sam"]`
        pub const ABDAY: &[&str] = &["dim", "lun", "mar", "mer", "jeu", "ven", "sam"];
        /// `&["jan", "fév", "mar", "avr", "mai", "jun", "jui", "aoû", "sep", "oct", "nov", "déc"]`
        pub const ABMON: &[&str] = &["jan", "fév", "mar", "avr", "mai", "jun", "jui", "aoû", "sep", "oct", "nov", "déc"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"]`
        pub const DAY: &[&str] = &["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["janvier", "février", "mars", "avril", "mai", "juin", "juillet", "août", "septembre", "octobre", "novembre", "décembre"]`
        pub const MON: &[&str] = &["janvier", "février", "mars", "avril", "mai", "juin", "juillet", "août", "septembre", "octobre", "novembre", "décembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod fr_BE_euro {
    pub use super::fr_BE::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `"https://www.gnu.org/software/libc/"`
        pub const ADDRESS: &str = "https://www.gnu.org/software/libc/";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-08-20"`
        pub const DATE: &str = "2000-08-20";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"French"`
        pub const LANGUAGE: &str = "French";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Free Software Foundation, Inc."`
        pub const SOURCE: &str = "Free Software Foundation, Inc.";
        /// `""`
        pub const TEL: &str = "";
        /// `"Belgium"`
        pub const TERRITORY: &str = "Belgium";
        /// `"French locale for Belgium with Euro"`
        pub const TITLE: &str = "French locale for Belgium with Euro";
    }
    pub use super::fr_BE::LC_MESSAGES;
    pub use super::fr_BE::LC_MONETARY;
    pub use super::fr_BE::LC_NUMERIC;
    pub use super::fr_BE::LC_TELEPHONE;
    pub use super::fr_BE::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod fr_CA {
    pub mod LC_ADDRESS {
        /// `"CA"`
        pub const COUNTRY_ABTWO: &str = "CA";
        /// `"CAN"`
        pub const COUNTRY_AB3: &str = "CAN";
        /// `"CDN"`
        pub const COUNTRY_CAR: &str = "CDN";
        /// `"Canada"`
        pub const COUNTRY_NAME: &str = "Canada";
        /// `124`
        pub const COUNTRY_NUM: i64 = 124;
        /// `"fr"`
        pub const LANG_AB: &str = "fr";
        /// `"fre"`
        pub const LANG_LIB: &str = "fre";
        /// `"français"`
        pub const LANG_NAME: &str = "français";
        /// `"fra"`
        pub const LANG_TERM: &str = "fra";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Canadian French"`
        pub const LANGUAGE: &str = "Canadian French";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Canada"`
        pub const TERRITORY: &str = "Canada";
        /// `"French locale for Canada"`
        pub const TITLE: &str = "French locale for Canada";
    }
    pub use super::fr_FR::LC_MESSAGES;
    pub mod LC_MONETARY {
        /// `"$"`
        pub const CURRENCY_SYMBOL: &str = "$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"CAD "`
        pub const INT_CURR_SYMBOL: &str = "CAD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `0`
        pub const N_SIGN_POSN: i64 = 0;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub use super::fr_FR::LC_NUMERIC;
    pub use super::en_CA::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["dim", "lun", "mar", "mer", "jeu", "ven", "sam"]`
        pub const ABDAY: &[&str] = &["dim", "lun", "mar", "mer", "jeu", "ven", "sam"];
        /// `&["jan", "fév", "mar", "avr", "mai", "jun", "jui", "aoû", "sep", "oct", "nov", "déc"]`
        pub const ABMON: &[&str] = &["jan", "fév", "mar", "avr", "mai", "jun", "jui", "aoû", "sep", "oct", "nov", "déc"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%Y-%m-%d"`
        pub const D_FMT: &str = "%Y-%m-%d";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"]`
        pub const DAY: &[&str] = &["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"];
        /// `&["janvier", "février", "mars", "avril", "mai", "juin", "juillet", "août", "septembre", "octobre", "novembre", "décembre"]`
        pub const MON: &[&str] = &["janvier", "février", "mars", "avril", "mai", "juin", "juillet", "août", "septembre", "octobre", "novembre", "décembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod fr_CH {
    pub mod LC_ADDRESS {
        /// `"CH"`
        pub const COUNTRY_ABTWO: &str = "CH";
        /// `"CHE"`
        pub const COUNTRY_AB3: &str = "CHE";
        /// `"CH"`
        pub const COUNTRY_CAR: &str = "CH";
        /// `"Suisse"`
        pub const COUNTRY_NAME: &str = "Suisse";
        /// `756`
        pub const COUNTRY_NUM: i64 = 756;
        /// `"fr"`
        pub const LANG_AB: &str = "fr";
        /// `"fre"`
        pub const LANG_LIB: &str = "fre";
        /// `"français"`
        pub const LANG_NAME: &str = "français";
        /// `"fra"`
        pub const LANG_TERM: &str = "fra";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Swiss French"`
        pub const LANGUAGE: &str = "Swiss French";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Switzerland"`
        pub const TERRITORY: &str = "Switzerland";
        /// `"French locale for Switzerland"`
        pub const TITLE: &str = "French locale for Switzerland";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"non"`
        pub const NOSTR: &str = "non";
        /// `"^[+1OojJsSyY]"`
        pub const YESEXPR: &str = "^[+1OojJsSyY]";
        /// `"oui"`
        pub const YESSTR: &str = "oui";
    }
    pub use super::de_CH::LC_MONETARY;
    pub use super::de_CH::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `"41"`
        pub const INT_PREFIX: &str = "41";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["dim", "lun", "mar", "mer", "jeu", "ven", "sam"]`
        pub const ABDAY: &[&str] = &["dim", "lun", "mar", "mer", "jeu", "ven", "sam"];
        /// `&["jan", "fév", "mar", "avr", "mai", "jun", "jui", "aoû", "sep", "oct", "nov", "déc"]`
        pub const ABMON: &[&str] = &["jan", "fév", "mar", "avr", "mai", "jun", "jui", "aoû", "sep", "oct", "nov", "déc"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d. %m. %y"`
        pub const D_FMT: &str = "%d. %m. %y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"]`
        pub const DAY: &[&str] = &["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["janvier", "février", "mars", "avril", "mai", "juin", "juillet", "août", "septembre", "octobre", "novembre", "décembre"]`
        pub const MON: &[&str] = &["janvier", "février", "mars", "avril", "mai", "juin", "juillet", "août", "septembre", "octobre", "novembre", "décembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod fr_FR {
    pub mod LC_ADDRESS {
        /// `"FR"`
        pub const COUNTRY_ABTWO: &str = "FR";
        /// `"FRA"`
        pub const COUNTRY_AB3: &str = "FRA";
        /// `"F"`
        pub const COUNTRY_CAR: &str = "F";
        /// `"979-10"`
        pub const COUNTRY_ISBN: &str = "979-10";
        /// `"France"`
        pub const COUNTRY_NAME: &str = "France";
        /// `250`
        pub const COUNTRY_NUM: i64 = 250;
        /// `"fr"`
        pub const LANG_AB: &str = "fr";
        /// `"fre"`
        pub const LANG_LIB: &str = "fre";
        /// `"français"`
        pub const LANG_NAME: &str = "français";
        /// `"fra"`
        pub const LANG_TERM: &str = "fra";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `"Traduc.org"`
        pub const CONTACT: &str = "Traduc.org";
        /// `"2008-03-15"`
        pub const DATE: &str = "2008-03-15";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"French"`
        pub const LANGUAGE: &str = "French";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"France"`
        pub const TERRITORY: &str = "France";
        /// `"French locale for France"`
        pub const TITLE: &str = "French locale for France";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"non"`
        pub const NOSTR: &str = "non";
        /// `"^[+1oOyY]"`
        pub const YESEXPR: &str = "^[+1oOyY]";
        /// `"oui"`
        pub const YESSTR: &str = "oui";
    }
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `"\u{202f}"`
        pub const THOUSANDS_SEP: &str = "\u{202f}";
    }
    pub mod LC_TELEPHONE {
        /// `"33"`
        pub const INT_PREFIX: &str = "33";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"%a %l"`
        pub const TEL_DOM_FMT: &str = "%a %l";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["dim.", "lun.", "mar.", "mer.", "jeu.", "ven.", "sam."]`
        pub const ABDAY: &[&str] = &["dim.", "lun.", "mar.", "mer.", "jeu.", "ven.", "sam."];
        /// `&["janv.", "févr.", "mars", "avril", "mai", "juin", "juil.", "août", "sept.", "oct.", "nov.", "déc."]`
        pub const ABMON: &[&str] = &["janv.", "févr.", "mars", "avril", "mai", "juin", "juil.", "août", "sept.", "oct.", "nov.", "déc."];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"]`
        pub const DAY: &[&str] = &["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["janvier", "février", "mars", "avril", "mai", "juin", "juillet", "août", "septembre", "octobre", "novembre", "décembre"]`
        pub const MON: &[&str] = &["janvier", "février", "mars", "avril", "mai", "juin", "juillet", "août", "septembre", "octobre", "novembre", "décembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod fr_FR_euro {
    pub use super::fr_FR::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `"https://www.gnu.org/software/libc/"`
        pub const ADDRESS: &str = "https://www.gnu.org/software/libc/";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `"2000-08-20"`
        pub const DATE: &str = "2000-08-20";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"French"`
        pub const LANGUAGE: &str = "French";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Free Software Foundation, Inc."`
        pub const SOURCE: &str = "Free Software Foundation, Inc.";
        /// `""`
        pub const TEL: &str = "";
        /// `"France"`
        pub const TERRITORY: &str = "France";
        /// `"French locale for France with Euro"`
        pub const TITLE: &str = "French locale for France with Euro";
    }
    pub use super::fr_FR::LC_MESSAGES;
    pub use super::fr_FR::LC_MONETARY;
    pub use super::fr_FR::LC_NUMERIC;
    pub use super::fr_FR::LC_TELEPHONE;
    pub use super::fr_FR::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod fr_LU {
    pub mod LC_ADDRESS {
        /// `"LU"`
        pub const COUNTRY_ABTWO: &str = "LU";
        /// `"LUX"`
        pub const COUNTRY_AB3: &str = "LUX";
        /// `"L"`
        pub const COUNTRY_CAR: &str = "L";
        /// `"Luxembourg"`
        pub const COUNTRY_NAME: &str = "Luxembourg";
        /// `442`
        pub const COUNTRY_NUM: i64 = 442;
        /// `"fr"`
        pub const LANG_AB: &str = "fr";
        /// `"fre"`
        pub const LANG_LIB: &str = "fre";
        /// `"français"`
        pub const LANG_NAME: &str = "français";
        /// `"fra"`
        pub const LANG_TERM: &str = "fra";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"French"`
        pub const LANGUAGE: &str = "French";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Luxembourg"`
        pub const TERRITORY: &str = "Luxembourg";
        /// `"French locale for Luxemburg"`
        pub const TITLE: &str = "French locale for Luxemburg";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"non"`
        pub const NOSTR: &str = "non";
        /// `"^[+1oOyY]"`
        pub const YESEXPR: &str = "^[+1oOyY]";
        /// `"oui"`
        pub const YESSTR: &str = "oui";
    }
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const THOUSANDS_SEP: &str = "\u{202f}";
    }
    pub mod LC_TELEPHONE {
        /// `"352"`
        pub const INT_PREFIX: &str = "352";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["dim", "lun", "mar", "mer", "jeu", "ven", "sam"]`
        pub const ABDAY: &[&str] = &["dim", "lun", "mar", "mer", "jeu", "ven", "sam"];
        /// `&["jan", "fév", "mar", "avr", "mai", "jun", "jui", "aoû", "sep", "oct", "nov", "déc"]`
        pub const ABMON: &[&str] = &["jan", "fév", "mar", "avr", "mai", "jun", "jui", "aoû", "sep", "oct", "nov", "déc"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"]`
        pub const DAY: &[&str] = &["dimanche", "lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["janvier", "février", "mars", "avril", "mai", "juin", "juillet", "août", "septembre", "octobre", "novembre", "décembre"]`
        pub const MON: &[&str] = &["janvier", "février", "mars", "avril", "mai", "juin", "juillet", "août", "septembre", "octobre", "novembre", "décembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod fr_LU_euro {
    pub use super::fr_LU::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `"https://www.gnu.org/software/libc/"`
        pub const ADDRESS: &str = "https://www.gnu.org/software/libc/";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-08-20"`
        pub const DATE: &str = "2000-08-20";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"French"`
        pub const LANGUAGE: &str = "French";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Free Software Foundation, Inc."`
        pub const SOURCE: &str = "Free Software Foundation, Inc.";
        /// `""`
        pub const TEL: &str = "";
        /// `"Luxembourg"`
        pub const TERRITORY: &str = "Luxembourg";
        /// `"French locale for Luxemburg with Euro"`
        pub const TITLE: &str = "French locale for Luxemburg with Euro";
    }
    pub use super::fr_LU::LC_MESSAGES;
    pub use super::fr_LU::LC_MONETARY;
    pub use super::fr_LU::LC_NUMERIC;
    pub use super::fr_LU::LC_TELEPHONE;
    pub use super::fr_LU::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod fur_IT {
    pub mod LC_ADDRESS {
        /// `"IT"`
        pub const COUNTRY_ABTWO: &str = "IT";
        /// `"ITA"`
        pub const COUNTRY_AB3: &str = "ITA";
        /// `"I"`
        pub const COUNTRY_CAR: &str = "I";
        /// `"978-88,979-12"`
        pub const COUNTRY_ISBN: &str = "978-88,979-12";
        /// `"Italie"`
        pub const COUNTRY_NAME: &str = "Italie";
        /// `380`
        pub const COUNTRY_NUM: i64 = 380;
        /// `"furlan"`
        pub const LANG_NAME: &str = "furlan";
        /// `"fur"`
        pub const LANG_TERM: &str = "fur";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `"Pablo Saratxaga"`
        pub const CONTACT: &str = "Pablo Saratxaga";
        /// `"2004-04-26"`
        pub const DATE: &str = "2004-04-26";
        /// `"pablo@mandrakesoft.com"`
        pub const EMAIL: &str = "pablo@mandrakesoft.com";
        /// `""`
        pub const FAX: &str = "";
        /// `"Friulian"`
        pub const LANGUAGE: &str = "Friulian";
        /// `"0.3"`
        pub const REVISION: &str = "0.3";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"Italy"`
        pub const TERRITORY: &str = "Italy";
        /// `"Furlan locale for Italy"`
        pub const TITLE: &str = "Furlan locale for Italy";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"no"`
        pub const NOSTR: &str = "no";
        /// `"^[+1sSjJoOyY]"`
        pub const YESEXPR: &str = "^[+1sSjJoOyY]";
        /// `"sì"`
        pub const YESSTR: &str = "sì";
    }
    pub use super::it_IT::LC_MONETARY;
    pub use super::it_IT::LC_NUMERIC;
    pub use super::it_IT::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Dom", "Lun", "Mar", "Mie", "Joi", "Vin", "Sab"]`
        pub const ABDAY: &[&str] = &["Dom", "Lun", "Mar", "Mie", "Joi", "Vin", "Sab"];
        /// `&["Zen", "Fev", "Mar", "Avr", "Mai", "Jug", "Lui", "Avo", "Set", "Otu", "Nov", "Dic"]`
        pub const ABMON: &[&str] = &["Zen", "Fev", "Mar", "Avr", "Mai", "Jug", "Lui", "Avo", "Set", "Otu", "Nov", "Dic"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d. %m. %y"`
        pub const D_FMT: &str = "%d. %m. %y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["Domenie", "Lunis", "Martars", "Miercus", "Joibe", "Vinars", "Sabide"]`
        pub const DAY: &[&str] = &["Domenie", "Lunis", "Martars", "Miercus", "Joibe", "Vinars", "Sabide"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["Zenâr", "Fevrâr", "Març", "Avrîl", "Mai", "Jugn", "Lui", "Avost", "Setembar", "Otubar", "Novembar", "Dicembar"]`
        pub const MON: &[&str] = &["Zenâr", "Fevrâr", "Març", "Avrîl", "Mai", "Jugn", "Lui", "Avost", "Setembar", "Otubar", "Novembar", "Dicembar"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod fy_DE {
    pub mod LC_ADDRESS {
        /// `"DE"`
        pub const COUNTRY_ABTWO: &str = "DE";
        /// `"DEU"`
        pub const COUNTRY_AB3: &str = "DEU";
        /// `"D"`
        pub const COUNTRY_CAR: &str = "D";
        /// `"3"`
        pub const COUNTRY_ISBN: &str = "3";
        /// `"Dútslân"`
        pub const COUNTRY_NAME: &str = "Dútslân";
        /// `276`
        pub const COUNTRY_NUM: i64 = 276;
        /// `"D"`
        pub const COUNTRY_POST: &str = "D";
        /// `"fy"`
        pub const LANG_AB: &str = "fy";
        /// `"fry"`
        pub const LANG_LIB: &str = "fry";
        /// `"Frysk"`
        pub const LANG_NAME: &str = "Frysk";
        /// `"fry"`
        pub const LANG_TERM: &str = "fry";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_ADDRESS"],
        ];
        /// `"Kenneth Christiansen, Pablo Saratxaga"`
        pub const CONTACT: &str = "Kenneth Christiansen, Pablo Saratxaga";
        /// `"2003-11-30"`
        pub const DATE: &str = "2003-11-30";
        /// `"kenneth@gnu.org, pablo@mandriva.com"`
        pub const EMAIL: &str = "kenneth@gnu.org, pablo@mandriva.com";
        /// `"Western Frisian"`
        pub const LANGUAGE: &str = "Western Frisian";
        /// `"0.1"`
        pub const REVISION: &str = "0.1";
        /// `"information from Kenneth Christiansen"`
        pub const SOURCE: &str = "information from Kenneth Christiansen";
        /// `""`
        pub const TEL: &str = "";
        /// `"Germany"`
        pub const TERRITORY: &str = "Germany";
        /// `"Sater Frisian and North Frisian Locale for Germany"`
        pub const TITLE: &str = "Sater Frisian and North Frisian Locale for Germany";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"nee"`
        pub const NOSTR: &str = "nee";
        /// `"^[+1jJyY]"`
        pub const YESEXPR: &str = "^[+1jJyY]";
        /// `"ja"`
        pub const YESSTR: &str = "ja";
    }
    pub use super::de_DE::LC_MONETARY;
    pub use super::de_DE::LC_NUMERIC;
    pub use super::de_DE::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Sdg", "Mdg", "Dsg", "Mwk", "Ddg", "Fdg", "Swd"]`
        pub const ABDAY: &[&str] = &["Sdg", "Mdg", "Dsg", "Mwk", "Ddg", "Fdg", "Swd"];
        /// `&["Jan", "Feb", "Moz", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Now", "Dez"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Moz", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Now", "Dez"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %d. %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d. %b %Y %T %Z";
        /// `&["Sinndag", "Mondag", "Dingsdag", "Meddwäakj", "Donnadag", "Friedag", "Sinnowend"]`
        pub const DAY: &[&str] = &["Sinndag", "Mondag", "Dingsdag", "Meddwäakj", "Donnadag", "Friedag", "Sinnowend"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["Jaunuwoa", "Februwoa", "Moaz", "Aprell", "Mai", "Juni", "Juli", "August", "Septamba", "Oktoba", "Nowamba", "Dezamba"]`
        pub const MON: &[&str] = &["Jaunuwoa", "Februwoa", "Moaz", "Aprell", "Mai", "Juni", "Juli", "August", "Septamba", "Oktoba", "Nowamba", "Dezamba"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod fy_NL {
    pub mod LC_ADDRESS {
        /// `"NL"`
        pub const COUNTRY_ABTWO: &str = "NL";
        /// `"NLD"`
        pub const COUNTRY_AB3: &str = "NLD";
        /// `"NL"`
        pub const COUNTRY_CAR: &str = "NL";
        /// `"Nederlân"`
        pub const COUNTRY_NAME: &str = "Nederlân";
        /// `528`
        pub const COUNTRY_NUM: i64 = 528;
        /// `"fy"`
        pub const LANG_AB: &str = "fy";
        /// `"fry"`
        pub const LANG_LIB: &str = "fry";
        /// `"West-Frysk"`
        pub const LANG_NAME: &str = "West-Frysk";
        /// `"fry"`
        pub const LANG_TERM: &str = "fry";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"https://www.gnu.org/software/libc/"`
        pub const ADDRESS: &str = "https://www.gnu.org/software/libc/";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2006-08-13"`
        pub const DATE: &str = "2006-08-13";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Western Frisian"`
        pub const LANGUAGE: &str = "Western Frisian";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Free Software Foundation, Inc."`
        pub const SOURCE: &str = "Free Software Foundation, Inc.";
        /// `""`
        pub const TEL: &str = "";
        /// `"Netherlands"`
        pub const TERRITORY: &str = "Netherlands";
        /// `"Frisian locale for the Netherlands"`
        pub const TITLE: &str = "Frisian locale for the Netherlands";
    }
    pub use super::nl_NL::LC_MESSAGES;
    pub use super::nl_NL::LC_MONETARY;
    pub use super::nl_NL::LC_NUMERIC;
    pub use super::nl_NL::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Sn", "Mo", "Ti", "Wo", "To", "Fr", "Sn"]`
        pub const ABDAY: &[&str] = &["Sn", "Mo", "Ti", "Wo", "To", "Fr", "Sn"];
        /// `&["Jan", "Feb", "Mrt", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Des"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mrt", "Apr", "Mai", "Jun", "Jul", "Aug", "Sep", "Okt", "Nov", "Des"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d-%m-%y"`
        pub const D_FMT: &str = "%d-%m-%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["Snein", "Moandei", "Tiisdei", "Woansdei", "Tongersdei", "Freed", "Sneon"]`
        pub const DAY: &[&str] = &["Snein", "Moandei", "Tiisdei", "Woansdei", "Tongersdei", "Freed", "Sneon"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["Jannewaris", "Febrewaris", "Maart", "April", "Maaie", "Juny", "July", "Augustus", "Septimber", "Oktober", "Novimber", "Desimber"]`
        pub const MON: &[&str] = &["Jannewaris", "Febrewaris", "Maart", "April", "Maaie", "Juny", "July", "Augustus", "Septimber", "Oktober", "Novimber", "Desimber"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ga_IE {
    pub mod LC_ADDRESS {
        /// `"IE"`
        pub const COUNTRY_ABTWO: &str = "IE";
        /// `"IRL"`
        pub const COUNTRY_AB3: &str = "IRL";
        /// `"IRL"`
        pub const COUNTRY_CAR: &str = "IRL";
        /// `"Éire"`
        pub const COUNTRY_NAME: &str = "Éire";
        /// `372`
        pub const COUNTRY_NUM: i64 = 372;
        /// `"ga"`
        pub const LANG_AB: &str = "ga";
        /// `"gle"`
        pub const LANG_LIB: &str = "gle";
        /// `"Gaeilge"`
        pub const LANG_NAME: &str = "Gaeilge";
        /// `"gle"`
        pub const LANG_TERM: &str = "gle";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Glasnevin, Dublin 9, Ireland"`
        pub const ADDRESS: &str = "Glasnevin, Dublin 9, Ireland";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Irish"`
        pub const LANGUAGE: &str = "Irish";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"NSAI"`
        pub const SOURCE: &str = "NSAI";
        /// `""`
        pub const TEL: &str = "";
        /// `"Ireland"`
        pub const TERRITORY: &str = "Ireland";
        /// `"Irish locale for Ireland"`
        pub const TITLE: &str = "Irish locale for Ireland";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"níl"`
        pub const NOSTR: &str = "níl";
        /// `"^[+1tTyY]"`
        pub const YESEXPR: &str = "^[+1tTyY]";
        /// `"tá"`
        pub const YESSTR: &str = "tá";
    }
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"353"`
        pub const INT_PREFIX: &str = "353";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["Domh", "Luan", "Máirt", "Céad", "Déar", "Aoine", "Sath"]`
        pub const ABDAY: &[&str] = &["Domh", "Luan", "Máirt", "Céad", "Déar", "Aoine", "Sath"];
        /// `&["Ean", "Feabh", "Márta", "Aib", "Beal", "Meith", "Iúil", "Lún", "MFómh", "DFómh", "Samh", "Noll"]`
        pub const ABMON: &[&str] = &["Ean", "Feabh", "Márta", "Aib", "Beal", "Meith", "Iúil", "Lún", "MFómh", "DFómh", "Samh", "Noll"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d.%m.%y"`
        pub const D_FMT: &str = "%d.%m.%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["Dé Domhnaigh", "Dé Luain", "Dé Máirt", "Dé Céadaoin", "Déardaoin", "Dé hAoine", "Dé Sathairn"]`
        pub const DAY: &[&str] = &["Dé Domhnaigh", "Dé Luain", "Dé Máirt", "Dé Céadaoin", "Déardaoin", "Dé hAoine", "Dé Sathairn"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["Eanáir", "Feabhra", "Márta", "Aibreán", "Bealtaine", "Meitheamh", "Iúil", "Lúnasa", "Meán Fómhair", "Deireadh Fómhair", "Samhain", "Nollaig"]`
        pub const MON: &[&str] = &["Eanáir", "Feabhra", "Márta", "Aibreán", "Bealtaine", "Meitheamh", "Iúil", "Lúnasa", "Meán Fómhair", "Deireadh Fómhair", "Samhain", "Nollaig"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ga_IE_euro {
    pub use super::ga_IE::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `"https://www.gnu.org/software/libc/"`
        pub const ADDRESS: &str = "https://www.gnu.org/software/libc/";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-08-21"`
        pub const DATE: &str = "2000-08-21";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Irish"`
        pub const LANGUAGE: &str = "Irish";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Free Software Foundation, Inc."`
        pub const SOURCE: &str = "Free Software Foundation, Inc.";
        /// `""`
        pub const TEL: &str = "";
        /// `"Ireland"`
        pub const TERRITORY: &str = "Ireland";
        /// `"Irish locale for Ireland with Euro"`
        pub const TITLE: &str = "Irish locale for Ireland with Euro";
    }
    pub use super::ga_IE::LC_MESSAGES;
    pub use super::ga_IE::LC_MONETARY;
    pub use super::ga_IE::LC_NUMERIC;
    pub use super::ga_IE::LC_TELEPHONE;
    pub use super::ga_IE::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod gd_GB {
    pub mod LC_ADDRESS {
        /// `"GB"`
        pub const COUNTRY_ABTWO: &str = "GB";
        /// `"GBR"`
        pub const COUNTRY_AB3: &str = "GBR";
        /// `"GB"`
        pub const COUNTRY_CAR: &str = "GB";
        /// `0`
        pub const COUNTRY_ISBN: i64 = 0;
        /// `"An Rìoghachd Aonaichte"`
        pub const COUNTRY_NAME: &str = "An Rìoghachd Aonaichte";
        /// `826`
        pub const COUNTRY_NUM: i64 = 826;
        /// `"gd"`
        pub const LANG_AB: &str = "gd";
        /// `"gla"`
        pub const LANG_LIB: &str = "gla";
        /// `"Gàidhlig"`
        pub const LANG_NAME: &str = "Gàidhlig";
        /// `"gla"`
        pub const LANG_TERM: &str = "gla";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%S%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%S%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"1/2, 47 Wilton Street, Glasgow G20 6RT, UK"`
        pub const ADDRESS: &str = "1/2, 47 Wilton Street, Glasgow G20 6RT, UK";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ];
        /// `"Michael Bauer"`
        pub const CONTACT: &str = "Michael Bauer";
        /// `"2013-04-25"`
        pub const DATE: &str = "2013-04-25";
        /// `"fios@akerbeltz.org"`
        pub const EMAIL: &str = "fios@akerbeltz.org";
        /// `"Scottish Gaelic"`
        pub const LANGUAGE: &str = "Scottish Gaelic";
        /// `"1.2"`
        pub const REVISION: &str = "1.2";
        /// `"Akerbeltz"`
        pub const SOURCE: &str = "Akerbeltz";
        /// `""`
        pub const TEL: &str = "";
        /// `"United Kingdom"`
        pub const TERRITORY: &str = "United Kingdom";
        /// `"Scots Gaelic language locale for Great Britain"`
        pub const TITLE: &str = "Scots Gaelic language locale for Great Britain";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0cCnN]"`
        pub const NOEXPR: &str = "^[-0cCnN]";
        /// `"chan eil"`
        pub const NOSTR: &str = "chan eil";
        /// `"^[+1tTyY]"`
        pub const YESEXPR: &str = "^[+1tTyY]";
        /// `"tha"`
        pub const YESSTR: &str = "tha";
    }
    pub use super::en_GB::LC_MONETARY;
    pub use super::en_GB::LC_NUMERIC;
    pub use super::en_GB::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["DiD", "DiL", "DiM", "DiC", "Dia", "Dih", "DiS"]`
        pub const ABDAY: &[&str] = &["DiD", "DiL", "DiM", "DiC", "Dia", "Dih", "DiS"];
        /// `&["Faoi", "Gearr", "Màrt", "Gibl", "Cèit", "Ògmh", "Iuch", "Lùna", "Sult", "Dàmh", "Samh", "Dùbh"]`
        pub const ABMON: &[&str] = &["Faoi", "Gearr", "Màrt", "Gibl", "Cèit", "Ògmh", "Iuch", "Lùna", "Sult", "Dàmh", "Samh", "Dùbh"];
        /// `&["Am Faoilleach", "An Gearran", "Am Màrt", "An Giblean", "An Cèitean", "An t-Ògmhios", "An t-Iuchar", "An Lùnastal", "An t-Sultain", "An Dàmhair", "An t-Samhain", "An Dùbhlachd"]`
        pub const ALT_MON: &[&str] = &["Am Faoilleach", "An Gearran", "Am Màrt", "An Giblean", "An Cèitean", "An t-Ògmhios", "An t-Iuchar", "An Lùnastal", "An t-Sultain", "An Dàmhair", "An t-Samhain", "An Dùbhlachd"];
        /// `&["m", "f"]`
        pub const AM_PM: &[&str] = &["m", "f"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["DiDòmhnaich", "DiLuain", "DiMàirt", "DiCiadain", "DiarDaoin", "DihAoine", "DiSathairne"]`
        pub const DAY: &[&str] = &["DiDòmhnaich", "DiLuain", "DiMàirt", "DiCiadain", "DiarDaoin", "DihAoine", "DiSathairne"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["dhen Fhaoilleach", "dhen Ghearran", "dhen Mhàrt", "dhen Ghiblean", "dhen Chèitean", "dhen Ògmhios", "dhen Iuchar", "dhen Lùnastal", "dhen t-Sultain", "dhen Dàmhair", "dhen t-Samhain", "dhen Dùbhlachd"]`
        pub const MON: &[&str] = &["dhen Fhaoilleach", "dhen Ghearran", "dhen Mhàrt", "dhen Ghiblean", "dhen Chèitean", "dhen Ògmhios", "dhen Iuchar", "dhen Lùnastal", "dhen t-Sultain", "dhen Dàmhair", "dhen t-Samhain", "dhen Dùbhlachd"];
        /// `"%r"`
        pub const T_FMT: &str = "%r";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod gez_ER {
    pub mod LC_ADDRESS {
        /// `"ER"`
        pub const COUNTRY_ABTWO: &str = "ER";
        /// `"ERI"`
        pub const COUNTRY_AB3: &str = "ERI";
        /// `"ER"`
        pub const COUNTRY_CAR: &str = "ER";
        /// `"ኤርትራ"`
        pub const COUNTRY_NAME: &str = "ኤርትራ";
        /// `232`
        pub const COUNTRY_NUM: i64 = 232;
        /// `"ERI"`
        pub const COUNTRY_POST: &str = "ERI";
        /// `"ግዕዝ"`
        pub const LANG_NAME: &str = "ግዕዝ";
        /// `"gez"`
        pub const LANG_TERM: &str = "gez";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"7802 Solomon Seal Dr., Springfield, VA 22152, USA"`
        pub const ADDRESS: &str = "7802 Solomon Seal Dr., Springfield, VA 22152, USA";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_TIME"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_TIME"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2003-07-05"`
        pub const DATE: &str = "2003-07-05";
        /// `"locales@geez.org"`
        pub const EMAIL: &str = "locales@geez.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Geez"`
        pub const LANGUAGE: &str = "Geez";
        /// `"0.20"`
        pub const REVISION: &str = "0.20";
        /// `"Ge\'ez Frontier Foundation"`
        pub const SOURCE: &str = "Ge\'ez Frontier Foundation";
        /// `""`
        pub const TEL: &str = "";
        /// `"Eritrea"`
        pub const TERRITORY: &str = "Eritrea";
        /// `"Ge\'ez language locale for Eritrea."`
        pub const TITLE: &str = "Ge\'ez language locale for Eritrea.";
    }
    pub use super::ti_ER::LC_MESSAGES;
    pub use super::ti_ER::LC_MONETARY;
    pub use super::ti_ER::LC_NUMERIC;
    pub use super::ti_ER::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["እኁድ", "ሰኑይ", "ሠሉስ", "ራብዕ", "ሐሙስ", "ዓርበ", "ቀዳሚ"]`
        pub const ABDAY: &[&str] = &["እኁድ", "ሰኑይ", "ሠሉስ", "ራብዕ", "ሐሙስ", "ዓርበ", "ቀዳሚ"];
        /// `&["ጠሐረ", "ከተተ", "መገበ", "አኀዘ", "ግንባ", "ሠንየ", "ሐመለ", "ነሐሰ", "ከረመ", "ጠቀመ", "ኀደረ", "ኀሠሠ"]`
        pub const ABMON: &[&str] = &["ጠሐረ", "ከተተ", "መገበ", "አኀዘ", "ግንባ", "ሠንየ", "ሐመለ", "ነሐሰ", "ከረመ", "ጠቀመ", "ኀደረ", "ኀሠሠ"];
        /// `&["ጽባሕ", "ምሴት"]`
        pub const AM_PM: &[&str] = &["ጽባሕ", "ምሴት"];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%A፥%B፡%e፡መዓልት\n፡%Y፡%r፡%Z"`
        pub const D_T_FMT: &str = "%A፥%B፡%e፡መዓልት\n፡%Y፡%r፡%Z";
        /// `"%A፥%B፡%e፡መዓልት\n፡%r፡%Z፡%Y፡ዓ/ም"`
        pub const DATE_FMT: &str = "%A፥%B፡%e፡መዓልት\n፡%r፡%Z፡%Y፡ዓ/ም";
        /// `&["እኁድ", "ሰኑይ", "ሠሉስ", "ራብዕ", "ሐሙስ", "ዓርበ", "ቀዳሚት"]`
        pub const DAY: &[&str] = &["እኁድ", "ሰኑይ", "ሠሉስ", "ራብዕ", "ሐሙስ", "ዓርበ", "ቀዳሚት"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["ጠሐረ", "ከተተ", "መገበ", "አኀዘ", "ግንባት", "ሠንየ", "ሐመለ", "ነሐሰ", "ከረመ", "ጠቀመ", "ኀደረ", "ኀሠሠ"]`
        pub const MON: &[&str] = &["ጠሐረ", "ከተተ", "መገበ", "አኀዘ", "ግንባት", "ሠንየ", "ሐመለ", "ነሐሰ", "ከረመ", "ጠቀመ", "ኀደረ", "ኀሠሠ"];
        /// `"%l:%M:%S፡%p"`
        pub const T_FMT: &str = "%l:%M:%S፡%p";
        /// `"%l:%M:%S፡%p"`
        pub const T_FMT_AMPM: &str = "%l:%M:%S፡%p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod gez_ER_abegede {
    pub use super::gez_ER::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `"7802 Solomon Seal Dr., Springfield, VA 22152, USA"`
        pub const ADDRESS: &str = "7802 Solomon Seal Dr., Springfield, VA 22152, USA";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_TIME"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_TIME"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2003-07-05"`
        pub const DATE: &str = "2003-07-05";
        /// `"locales@geez.org"`
        pub const EMAIL: &str = "locales@geez.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Geez"`
        pub const LANGUAGE: &str = "Geez";
        /// `"0.20"`
        pub const REVISION: &str = "0.20";
        /// `"Ge\'ez Frontier Foundation"`
        pub const SOURCE: &str = "Ge\'ez Frontier Foundation";
        /// `""`
        pub const TEL: &str = "";
        /// `"Eritrea"`
        pub const TERRITORY: &str = "Eritrea";
        /// `"Ge\'ez language locale for Eritrea With Abegede Collation."`
        pub const TITLE: &str = "Ge\'ez language locale for Eritrea With Abegede Collation.";
    }
    pub use super::gez_ER::LC_MESSAGES;
    pub use super::gez_ER::LC_MONETARY;
    pub use super::gez_ER::LC_NUMERIC;
    pub use super::gez_ER::LC_TELEPHONE;
    pub use super::gez_ER::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod gez_ET {
    pub mod LC_ADDRESS {
        /// `"ET"`
        pub const COUNTRY_ABTWO: &str = "ET";
        /// `"ETH"`
        pub const COUNTRY_AB3: &str = "ETH";
        /// `"ETH"`
        pub const COUNTRY_CAR: &str = "ETH";
        /// `"ኢትዮጵያ"`
        pub const COUNTRY_NAME: &str = "ኢትዮጵያ";
        /// `231`
        pub const COUNTRY_NUM: i64 = 231;
        /// `"ETH"`
        pub const COUNTRY_POST: &str = "ETH";
        /// `"ግዕዝ"`
        pub const LANG_NAME: &str = "ግዕዝ";
        /// `"gez"`
        pub const LANG_TERM: &str = "gez";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"7802 Solomon Seal Dr., Springfield, VA 22152, USA"`
        pub const ADDRESS: &str = "7802 Solomon Seal Dr., Springfield, VA 22152, USA";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_TIME"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_TIME"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2003-07-05"`
        pub const DATE: &str = "2003-07-05";
        /// `"locales@geez.org"`
        pub const EMAIL: &str = "locales@geez.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Geez"`
        pub const LANGUAGE: &str = "Geez";
        /// `"0.20"`
        pub const REVISION: &str = "0.20";
        /// `"Ge\'ez Frontier Foundation"`
        pub const SOURCE: &str = "Ge\'ez Frontier Foundation";
        /// `""`
        pub const TEL: &str = "";
        /// `"Ethiopia"`
        pub const TERRITORY: &str = "Ethiopia";
        /// `"Ge\'ez language locale for Ethiopia"`
        pub const TITLE: &str = "Ge\'ez language locale for Ethiopia";
    }
    pub use super::ti_ET::LC_MESSAGES;
    pub use super::ti_ET::LC_MONETARY;
    pub use super::ti_ET::LC_NUMERIC;
    pub use super::ti_ET::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["እኁድ", "ሰኑይ", "ሠሉስ", "ራብዕ", "ሐሙስ", "ዓርበ", "ቀዳሚ"]`
        pub const ABDAY: &[&str] = &["እኁድ", "ሰኑይ", "ሠሉስ", "ራብዕ", "ሐሙስ", "ዓርበ", "ቀዳሚ"];
        /// `&["ጃንዩ", "ፌብሩ", "ማርች", "ኤፕረ", "ሜይ ", "ጁን ", "ጁላይ", "ኦገስ", "ሴፕቴ", "ኦክተ", "ኖቬም", "ዲሴም"]`
        pub const ABMON: &[&str] = &["ጃንዩ", "ፌብሩ", "ማርች", "ኤፕረ", "ሜይ ", "ጁን ", "ጁላይ", "ኦገስ", "ሴፕቴ", "ኦክተ", "ኖቬም", "ዲሴም"];
        /// `&["ጽባሕ", "ምሴት"]`
        pub const AM_PM: &[&str] = &["ጽባሕ", "ምሴት"];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%A፥%B፡%e፡መዓልት\n፡%Y፡%r፡%Z"`
        pub const D_T_FMT: &str = "%A፥%B፡%e፡መዓልት\n፡%Y፡%r፡%Z";
        /// `"%A፥%B፡%e፡መዓልት\n፡%r፡%Z፡%Y፡ዓ/ም"`
        pub const DATE_FMT: &str = "%A፥%B፡%e፡መዓልት\n፡%r፡%Z፡%Y፡ዓ/ም";
        /// `&["እኁድ", "ሰኑይ", "ሠሉስ", "ራብዕ", "ሐሙስ", "ዓርበ", "ቀዳሚት"]`
        pub const DAY: &[&str] = &["እኁድ", "ሰኑይ", "ሠሉስ", "ራብዕ", "ሐሙስ", "ዓርበ", "ቀዳሚት"];
        /// `&["ጃንዩወሪ", "ፌብሩወሪ", "ማርች", "ኤፕረል", "ሜይ", "ጁን", "ጁላይ", "ኦገስት", "ሴፕቴምበር", "ኦክተውበር", "ኖቬምበር", "ዲሴምበር"]`
        pub const MON: &[&str] = &["ጃንዩወሪ", "ፌብሩወሪ", "ማርች", "ኤፕረል", "ሜይ", "ጁን", "ጁላይ", "ኦገስት", "ሴፕቴምበር", "ኦክተውበር", "ኖቬምበር", "ዲሴምበር"];
        /// `"%l:%M:%S፡%p"`
        pub const T_FMT: &str = "%l:%M:%S፡%p";
        /// `"%l:%M:%S፡%p"`
        pub const T_FMT_AMPM: &str = "%l:%M:%S፡%p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod gez_ET_abegede {
    pub use super::gez_ET::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `"7802 Solomon Seal Dr., Springfield, VA 22152, USA"`
        pub const ADDRESS: &str = "7802 Solomon Seal Dr., Springfield, VA 22152, USA";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_TIME"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_TIME"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2003-07-05"`
        pub const DATE: &str = "2003-07-05";
        /// `"locales@geez.org"`
        pub const EMAIL: &str = "locales@geez.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Geez"`
        pub const LANGUAGE: &str = "Geez";
        /// `"0.20"`
        pub const REVISION: &str = "0.20";
        /// `"Ge\'ez Frontier Foundation"`
        pub const SOURCE: &str = "Ge\'ez Frontier Foundation";
        /// `""`
        pub const TEL: &str = "";
        /// `"Ethiopia"`
        pub const TERRITORY: &str = "Ethiopia";
        /// `"Ge\'ez language locale for Ethiopia With Abegede Collation"`
        pub const TITLE: &str = "Ge\'ez language locale for Ethiopia With Abegede Collation";
    }
    pub use super::gez_ET::LC_MESSAGES;
    pub use super::gez_ET::LC_MONETARY;
    pub use super::gez_ET::LC_NUMERIC;
    pub use super::gez_ET::LC_TELEPHONE;
    pub use super::gez_ET::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod gl_ES {
    pub mod LC_ADDRESS {
        /// `"ES"`
        pub const COUNTRY_ABTWO: &str = "ES";
        /// `"ESP"`
        pub const COUNTRY_AB3: &str = "ESP";
        /// `"E"`
        pub const COUNTRY_CAR: &str = "E";
        /// `"España"`
        pub const COUNTRY_NAME: &str = "España";
        /// `724`
        pub const COUNTRY_NUM: i64 = 724;
        /// `"gl"`
        pub const LANG_AB: &str = "gl";
        /// `"glg"`
        pub const LANG_LIB: &str = "glg";
        /// `"galego"`
        pub const LANG_NAME: &str = "galego";
        /// `"glg"`
        pub const LANG_TERM: &str = "glg";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Facultade de Informática, Campus de Elviña, s/n, 15071 A Coruña, Spain"`
        pub const ADDRESS: &str = "Facultade de Informática, Campus de Elviña, s/n, 15071 A Coruña, Spain";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Galician"`
        pub const LANGUAGE: &str = "Galician";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"GPUL"`
        pub const SOURCE: &str = "GPUL";
        /// `""`
        pub const TEL: &str = "";
        /// `"Spain"`
        pub const TERRITORY: &str = "Spain";
        /// `"Galician locale for Spain"`
        pub const TITLE: &str = "Galician locale for Spain";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"non"`
        pub const NOSTR: &str = "non";
        /// `"^[+1sSyY]"`
        pub const YESEXPR: &str = "^[+1sSyY]";
        /// `"si"`
        pub const YESSTR: &str = "si";
    }
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[0, 0]`
        pub const GROUPING: &[i64] = &[0, 0];
        /// `""`
        pub const THOUSANDS_SEP: &str = "";
    }
    pub mod LC_TELEPHONE {
        /// `"34"`
        pub const INT_PREFIX: &str = "34";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["Dom", "Lun", "Mar", "Mér", "Xov", "Ven", "Sáb"]`
        pub const ABDAY: &[&str] = &["Dom", "Lun", "Mar", "Mér", "Xov", "Ven", "Sáb"];
        /// `&["Xan", "Feb", "Mar", "Abr", "Mai", "Xuñ", "Xul", "Ago", "Set", "Out", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Xan", "Feb", "Mar", "Abr", "Mai", "Xuñ", "Xul", "Ago", "Set", "Out", "Nov", "Dec"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["Domingo", "Luns", "Martes", "Mércores", "Xoves", "Venres", "Sábado"]`
        pub const DAY: &[&str] = &["Domingo", "Luns", "Martes", "Mércores", "Xoves", "Venres", "Sábado"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["Xaneiro", "Febreiro", "Marzo", "Abril", "Maio", "Xuño", "Xullo", "Agosto", "Setembro", "Outubro", "Novembro", "Decembro"]`
        pub const MON: &[&str] = &["Xaneiro", "Febreiro", "Marzo", "Abril", "Maio", "Xuño", "Xullo", "Agosto", "Setembro", "Outubro", "Novembro", "Decembro"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod gl_ES_euro {
    pub use super::gl_ES::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `"https://www.gnu.org/software/libc/"`
        pub const ADDRESS: &str = "https://www.gnu.org/software/libc/";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-08-21"`
        pub const DATE: &str = "2000-08-21";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Galician"`
        pub const LANGUAGE: &str = "Galician";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Free Software Foundation, Inc."`
        pub const SOURCE: &str = "Free Software Foundation, Inc.";
        /// `""`
        pub const TEL: &str = "";
        /// `"Spain"`
        pub const TERRITORY: &str = "Spain";
        /// `"Galician locale for Spain with Euro"`
        pub const TITLE: &str = "Galician locale for Spain with Euro";
    }
    pub use super::gl_ES::LC_MESSAGES;
    pub use super::gl_ES::LC_MONETARY;
    pub use super::gl_ES::LC_NUMERIC;
    pub use super::gl_ES::LC_TELEPHONE;
    pub use super::gl_ES::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod gu_IN {
    pub mod LC_ADDRESS {
        /// `"IN"`
        pub const COUNTRY_ABTWO: &str = "IN";
        /// `"IND"`
        pub const COUNTRY_AB3: &str = "IND";
        /// `"IND"`
        pub const COUNTRY_CAR: &str = "IND";
        /// `"ભારત"`
        pub const COUNTRY_NAME: &str = "ભારત";
        /// `356`
        pub const COUNTRY_NUM: i64 = 356;
        /// `"gu"`
        pub const LANG_AB: &str = "gu";
        /// `"guj"`
        pub const LANG_LIB: &str = "guj";
        /// `"ગ\u{ac1}જરાતી"`
        pub const LANG_NAME: &str = "ગ\u{ac1}જરાતી";
        /// `"guj"`
        pub const LANG_TERM: &str = "guj";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2004-09-14"`
        pub const DATE: &str = "2004-09-14";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Gujarati"`
        pub const LANGUAGE: &str = "Gujarati";
        /// `"0.2"`
        pub const REVISION: &str = "0.2";
        /// `"IndLinux.org"`
        pub const SOURCE: &str = "IndLinux.org";
        /// `""`
        pub const TEL: &str = "";
        /// `"India"`
        pub const TERRITORY: &str = "India";
        /// `"Gujarati Language Locale For India"`
        pub const TITLE: &str = "Gujarati Language Locale For India";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNન]"`
        pub const NOEXPR: &str = "^[-0nNન]";
        /// `"નહી\u{a82}"`
        pub const NOSTR: &str = "નહી\u{a82}";
        /// `"^[+1yYહ]"`
        pub const YESEXPR: &str = "^[+1yYહ]";
        /// `"હા"`
        pub const YESSTR: &str = "હા";
    }
    pub use super::hi_IN::LC_MONETARY;
    pub use super::hi_IN::LC_NUMERIC;
    pub use super::hi_IN::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["રવિ", "સોમ", "મ\u{a82}ગળ", "બ\u{ac1}ધ", "ગ\u{ac1}ર\u{ac1}", "શ\u{ac1}ક\u{acd}ર", "શનિ"]`
        pub const ABDAY: &[&str] = &["રવિ", "સોમ", "મ\u{a82}ગળ", "બ\u{ac1}ધ", "ગ\u{ac1}ર\u{ac1}", "શ\u{ac1}ક\u{acd}ર", "શનિ"];
        /// `&["જાન\u{acd}ય\u{ac1}", "ફ\u{ac7}બ\u{acd}ર\u{ac1}", "માર\u{acd}ચ", "એપ\u{acd}રિલ", "મ\u{ac7}", "જ\u{ac2}ન", "જ\u{ac1}લાઈ", "ઑગસ\u{acd}ટ", "સપ\u{acd}ટ\u{ac7}", "ઑક\u{acd}ટો", "નવ\u{ac7}", "ડિસ\u{ac7}"]`
        pub const ABMON: &[&str] = &["જાન\u{acd}ય\u{ac1}", "ફ\u{ac7}બ\u{acd}ર\u{ac1}", "માર\u{acd}ચ", "એપ\u{acd}રિલ", "મ\u{ac7}", "જ\u{ac2}ન", "જ\u{ac1}લાઈ", "ઑગસ\u{acd}ટ", "સપ\u{acd}ટ\u{ac7}", "ઑક\u{acd}ટો", "નવ\u{ac7}", "ડિસ\u{ac7}"];
        /// `&["સવાર\u{ac7}", "સા\u{a82}જ\u{ac7}"]`
        pub const AM_PM: &[&str] = &["સવાર\u{ac7}", "સા\u{a82}જ\u{ac7}"];
        /// `"%-d/%-m/%y"`
        pub const D_FMT: &str = "%-d/%-m/%y";
        /// `"%A %d %b %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A %d %b %Y %I:%M:%S %p %Z";
        /// `&["રવિવાર", "સોમવાર", "મ\u{a82}ગળવાર", "બ\u{ac1}ધવાર", "ગ\u{ac1}ર\u{ac1}વાર", "શ\u{ac1}ક\u{acd}રવાર", "શનિવાર"]`
        pub const DAY: &[&str] = &["રવિવાર", "સોમવાર", "મ\u{a82}ગળવાર", "બ\u{ac1}ધવાર", "ગ\u{ac1}ર\u{ac1}વાર", "શ\u{ac1}ક\u{acd}રવાર", "શનિવાર"];
        /// `&["જાન\u{acd}ય\u{ac1}આરી", "ફ\u{ac7}બ\u{acd}ર\u{ac1}આરી", "માર\u{acd}ચ", "એપ\u{acd}રિલ", "મ\u{ac7}", "જ\u{ac2}ન", "જ\u{ac1}લાઈ", "ઑગસ\u{acd}ટ", "સપ\u{acd}ટ\u{ac7}મ\u{acd}બર", "ઑક\u{acd}ટોબર", "નવ\u{ac7}મ\u{acd}બર", "ડિસ\u{ac7}મ\u{acd}બર"]`
        pub const MON: &[&str] = &["જાન\u{acd}ય\u{ac1}આરી", "ફ\u{ac7}બ\u{acd}ર\u{ac1}આરી", "માર\u{acd}ચ", "એપ\u{acd}રિલ", "મ\u{ac7}", "જ\u{ac2}ન", "જ\u{ac1}લાઈ", "ઑગસ\u{acd}ટ", "સપ\u{acd}ટ\u{ac7}મ\u{acd}બર", "ઑક\u{acd}ટોબર", "નવ\u{ac7}મ\u{acd}બર", "ડિસ\u{ac7}મ\u{acd}બર"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod gv_GB {
    pub mod LC_ADDRESS {
        /// `"GB"`
        pub const COUNTRY_ABTWO: &str = "GB";
        /// `"GBR"`
        pub const COUNTRY_AB3: &str = "GBR";
        /// `"GB"`
        pub const COUNTRY_CAR: &str = "GB";
        /// `"Rywvaneth Unys"`
        pub const COUNTRY_NAME: &str = "Rywvaneth Unys";
        /// `826`
        pub const COUNTRY_NUM: i64 = 826;
        /// `"gv"`
        pub const LANG_AB: &str = "gv";
        /// `"glv"`
        pub const LANG_LIB: &str = "glv";
        /// `"Gaelg"`
        pub const LANG_NAME: &str = "Gaelg";
        /// `"glv"`
        pub const LANG_TERM: &str = "glv";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Croí Lár, Ballinahalla, Maigh Cuilinn,, Co. Gaillimh, Ireland"`
        pub const ADDRESS: &str = "Croí Lár, Ballinahalla, Maigh Cuilinn,, Co. Gaillimh, Ireland";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Manx"`
        pub const LANGUAGE: &str = "Manx";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Alastair McKinstry"`
        pub const SOURCE: &str = "Alastair McKinstry";
        /// `""`
        pub const TEL: &str = "";
        /// `"United Kingdom"`
        pub const TERRITORY: &str = "United Kingdom";
        /// `"Manx Gaelic locale for Britain"`
        pub const TITLE: &str = "Manx Gaelic locale for Britain";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"^[+1yY]"`
        pub const YESEXPR: &str = "^[+1yY]";
    }
    pub mod LC_MONETARY {
        /// `"£"`
        pub const CURRENCY_SYMBOL: &str = "£";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"GBP "`
        pub const INT_CURR_SYMBOL: &str = "GBP ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"44"`
        pub const INT_PREFIX: &str = "44";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["Jed", "Jel", "Jem", "Jerc", "Jerd", "Jeh", "Jes"]`
        pub const ABDAY: &[&str] = &["Jed", "Jel", "Jem", "Jerc", "Jerd", "Jeh", "Jes"];
        /// `&["J-guer", "T-arree", "Mayrnt", "Avrril", "Boaldyn", "M-souree", "J-souree", "Luanistyn", "M-fouyir", "J-fouyir", "M.Houney", "M.Nollick"]`
        pub const ABMON: &[&str] = &["J-guer", "T-arree", "Mayrnt", "Avrril", "Boaldyn", "M-souree", "J-souree", "Luanistyn", "M-fouyir", "J-fouyir", "M.Houney", "M.Nollick"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["Jedoonee", "Jelhein", "Jemayrt", "Jercean", "Jerdein", "Jeheiney", "Jesarn"]`
        pub const DAY: &[&str] = &["Jedoonee", "Jelhein", "Jemayrt", "Jercean", "Jerdein", "Jeheiney", "Jesarn"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["Jerrey-geuree", "Toshiaght-arree", "Mayrnt", "Averil", "Boaldyn", "Mean-souree", "Jerrey-souree", "Luanistyn", "Mean-fouyir", "Jerrey-fouyir", "Mee Houney", "Mee ny Nollick"]`
        pub const MON: &[&str] = &["Jerrey-geuree", "Toshiaght-arree", "Mayrnt", "Averil", "Boaldyn", "Mean-souree", "Jerrey-souree", "Luanistyn", "Mean-fouyir", "Jerrey-fouyir", "Mee Houney", "Mee ny Nollick"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ha_NG {
    pub mod LC_ADDRESS {
        /// `"NG"`
        pub const COUNTRY_ABTWO: &str = "NG";
        /// `"NGA"`
        pub const COUNTRY_AB3: &str = "NGA";
        /// `"WAN"`
        pub const COUNTRY_CAR: &str = "WAN";
        /// `978`
        pub const COUNTRY_ISBN: i64 = 978;
        /// `"Najeriya"`
        pub const COUNTRY_NAME: &str = "Najeriya";
        /// `566`
        pub const COUNTRY_NUM: i64 = 566;
        /// `"ha"`
        pub const LANG_AB: &str = "ha";
        /// `"hau"`
        pub const LANG_LIB: &str = "hau";
        /// `"Hausa"`
        pub const LANG_NAME: &str = "Hausa";
        /// `"hau"`
        pub const LANG_TERM: &str = "hau";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2006-02-01"`
        pub const DATE: &str = "2006-02-01";
        /// `"pablo@mandriva.com"`
        pub const EMAIL: &str = "pablo@mandriva.com";
        /// `""`
        pub const FAX: &str = "";
        /// `"Hausa"`
        pub const LANGUAGE: &str = "Hausa";
        /// `"0.2"`
        pub const REVISION: &str = "0.2";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"Nigeria"`
        pub const TERRITORY: &str = "Nigeria";
        /// `"Hausa locale for Nigeria"`
        pub const TITLE: &str = "Hausa locale for Nigeria";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0bBaAnN]"`
        pub const NOEXPR: &str = "^[-0bBaAnN]";
        /// `"aʼa"`
        pub const NOSTR: &str = "aʼa";
        /// `"^[+1TtiIYy]"`
        pub const YESEXPR: &str = "^[+1TtiIYy]";
        /// `"i"`
        pub const YESSTR: &str = "i";
    }
    pub use super::en_NG::LC_MONETARY;
    pub use super::en_NG::LC_NUMERIC;
    pub use super::en_NG::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Lah", "Lit", "Tal", "Lar", "Alh", "Jum", "Asa"]`
        pub const ABDAY: &[&str] = &["Lah", "Lit", "Tal", "Lar", "Alh", "Jum", "Asa"];
        /// `&["Jan", "Fab", "Mar", "Afi", "May", "Yun", "Yul", "Agu", "Sat", "Okt", "Nuw", "Dis"]`
        pub const ABMON: &[&str] = &["Jan", "Fab", "Mar", "Afi", "May", "Yun", "Yul", "Agu", "Sat", "Okt", "Nuw", "Dis"];
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"ranar %A, %d ga %B cikin %r %Z"`
        pub const D_T_FMT: &str = "ranar %A, %d ga %B cikin %r %Z";
        /// `&["Lahadi", "Litini", "Talata", "Laraba", "Alhamis", "Juma\'a", "Asabar"]`
        pub const DAY: &[&str] = &["Lahadi", "Litini", "Talata", "Laraba", "Alhamis", "Juma\'a", "Asabar"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["Janairu", "Faburairu", "Maris", "Afirilu", "Mayu", "Yuni", "Yuli", "Agusta", "Satumba", "Oktoba", "Nuwamba", "Disamba"]`
        pub const MON: &[&str] = &["Janairu", "Faburairu", "Maris", "Afirilu", "Mayu", "Yuni", "Yuli", "Agusta", "Satumba", "Oktoba", "Nuwamba", "Disamba"];
        /// `"%r"`
        pub const T_FMT: &str = "%r";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod hak_TW {
    pub mod LC_ADDRESS {
        /// `"TW"`
        pub const COUNTRY_ABTWO: &str = "TW";
        /// `"TWN"`
        pub const COUNTRY_AB3: &str = "TWN";
        /// `"RC"`
        pub const COUNTRY_CAR: &str = "RC";
        /// `957`
        pub const COUNTRY_ISBN: i64 = 957;
        /// `"中華民國"`
        pub const COUNTRY_NAME: &str = "中華民國";
        /// `158`
        pub const COUNTRY_NUM: i64 = 158;
        /// `"TW"`
        pub const COUNTRY_POST: &str = "TW";
        /// `"hak"`
        pub const LANG_LIB: &str = "hak";
        /// `"客家話"`
        pub const LANG_NAME: &str = "客家話";
        /// `"hak"`
        pub const LANG_TERM: &str = "hak";
        /// `"%c%N%T%N%s %h %e %r%N%b%N%d%N%f%N%a%N"`
        pub const POSTAL_FMT: &str = "%c%N%T%N%s %h %e %r%N%b%N%d%N%f%N%a%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2013-06-02"`
        pub const DATE: &str = "2013-06-02";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Hakka Chinese"`
        pub const LANGUAGE: &str = "Hakka Chinese";
        /// `"0.1"`
        pub const REVISION: &str = "0.1";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"Taiwan"`
        pub const TERRITORY: &str = "Taiwan";
        /// `"Hakka Chinese locale for the Republic of China"`
        pub const TITLE: &str = "Hakka Chinese locale for the Republic of China";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNｎＮ毋]"`
        pub const NOEXPR: &str = "^[-0nNｎＮ毋]";
        /// `"^[+1yYｙＹ係]"`
        pub const YESEXPR: &str = "^[+1yYｙＹ係]";
    }
    pub mod LC_MONETARY {
        /// `"NT$"`
        pub const CURRENCY_SYMBOL: &str = "NT$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"TWD "`
        pub const INT_CURR_SYMBOL: &str = "TWD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `1`
        pub const INT_N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const INT_N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const INT_N_SIGN_POSN: i64 = 1;
        /// `1`
        pub const INT_P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const INT_P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const INT_P_SIGN_POSN: i64 = 1;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `4`
        pub const MON_GROUPING: i64 = 4;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `4`
        pub const GROUPING: i64 = 4;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"886"`
        pub const INT_PREFIX: &str = "886";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"%A-%l"`
        pub const TEL_DOM_FMT: &str = "%A-%l";
        /// `"+%c-%a-%l"`
        pub const TEL_INT_FMT: &str = "+%c-%a-%l";
    }
    pub mod LC_TIME {
        /// `&["日", "一", "二", "三", "四", "五", "六"]`
        pub const ABDAY: &[&str] = &["日", "一", "二", "三", "四", "五", "六"];
        /// `&[" 1月", " 2月", " 3月", " 4月", " 5月", " 6月", " 7月", " 8月", " 9月", "10月", "11月", "12月"]`
        pub const ABMON: &[&str] = &[" 1月", " 2月", " 3月", " 4月", " 5月", " 6月", " 7月", " 8月", " 9月", "10月", "11月", "12月"];
        /// `&["上晝", "下晝"]`
        pub const AM_PM: &[&str] = &["上晝", "下晝"];
        /// `"%Y年%m月%d日"`
        pub const D_FMT: &str = "%Y年%m月%d日";
        /// `"%Y年%m月%d日 (%A) %H點%M分%S秒"`
        pub const D_T_FMT: &str = "%Y年%m月%d日 (%A) %H點%M分%S秒";
        /// `"%Y年 %b %e日 %A %H:%M:%S %Z"`
        pub const DATE_FMT: &str = "%Y年 %b %e日 %A %H:%M:%S %Z";
        /// `&["禮拜日", "禮拜一", "禮拜二", "禮拜三", "禮拜四", "禮拜五", "禮拜六"]`
        pub const DAY: &[&str] = &["禮拜日", "禮拜一", "禮拜二", "禮拜三", "禮拜四", "禮拜五", "禮拜六"];
        /// `&["+:2:1913/01/01:+*:民國:%EC%Ey年", "+:1:1912/01/01:1912/12/31:民國:%EC元年", "+:1:1911/12/31:-*:民前:%EC%Ey年"]`
        pub const ERA: &[&str] = &["+:2:1913/01/01:+*:民國:%EC%Ey年", "+:1:1912/01/01:1912/12/31:民國:%EC元年", "+:1:1911/12/31:-*:民前:%EC%Ey年"];
        /// `&["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"]`
        pub const MON: &[&str] = &["一月", "二月", "三月", "四月", "五月", "六月", "七月", "八月", "九月", "十月", "十一月", "十二月"];
        /// `"%H點%M分%S秒"`
        pub const T_FMT: &str = "%H點%M分%S秒";
        /// `"%p %I點%M分%S秒"`
        pub const T_FMT_AMPM: &str = "%p %I點%M分%S秒";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod he_IL {
    pub mod LC_ADDRESS {
        /// `"IL"`
        pub const COUNTRY_ABTWO: &str = "IL";
        /// `"ISR"`
        pub const COUNTRY_AB3: &str = "ISR";
        /// `"IL"`
        pub const COUNTRY_CAR: &str = "IL";
        /// `"ישראל"`
        pub const COUNTRY_NAME: &str = "ישראל";
        /// `376`
        pub const COUNTRY_NUM: i64 = 376;
        /// `"he"`
        pub const LANG_AB: &str = "he";
        /// `"heb"`
        pub const LANG_LIB: &str = "heb";
        /// `"עברית"`
        pub const LANG_NAME: &str = "עברית";
        /// `"heb"`
        pub const LANG_TERM: &str = "heb";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jo/rgens Alle 8, DK-1615 Ko/benhavn V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jo/rgens Alle 8, DK-1615 Ko/benhavn V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Hebrew"`
        pub const LANGUAGE: &str = "Hebrew";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Israel"`
        pub const TERRITORY: &str = "Israel";
        /// `"Hebrew locale for Israel"`
        pub const TITLE: &str = "Hebrew locale for Israel";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNל]"`
        pub const NOEXPR: &str = "^[-0nNל]";
        /// `"לא"`
        pub const NOSTR: &str = "לא";
        /// `"^[+1yYכ]"`
        pub const YESEXPR: &str = "^[+1yYכ]";
        /// `"כן"`
        pub const YESSTR: &str = "כן";
    }
    pub mod LC_MONETARY {
        /// `"₪"`
        pub const CURRENCY_SYMBOL: &str = "₪";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"ILS "`
        pub const INT_CURR_SYMBOL: &str = "ILS ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const N_SIGN_POSN: i64 = 2;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `2`
        pub const P_SIGN_POSN: i64 = 2;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"972"`
        pub const INT_PREFIX: &str = "972";
        /// `"00,012,013,014,018"`
        pub const INT_SELECT: &str = "00,012,013,014,018";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["א\'", "ב\'", "ג\'", "ד\'", "ה\'", "ו\'", "ש\'"]`
        pub const ABDAY: &[&str] = &["א\'", "ב\'", "ג\'", "ד\'", "ה\'", "ו\'", "ש\'"];
        /// `&["ינו", "פבר", "מרץ", "אפר", "מאי", "יונ", "יול", "אוג", "ספט", "אוק", "נוב", "דצמ"]`
        pub const ABMON: &[&str] = &["ינו", "פבר", "מרץ", "אפר", "מאי", "יונ", "יול", "אוג", "ספט", "אוק", "נוב", "דצמ"];
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%Z %H:%M:%S %Y %b %d %a"`
        pub const D_T_FMT: &str = "%Z %H:%M:%S %Y %b %d %a";
        /// `&["ראשון", "שני", "שלישי", "רביעי", "חמישי", "שישי", "שבת"]`
        pub const DAY: &[&str] = &["ראשון", "שני", "שלישי", "רביעי", "חמישי", "שישי", "שבת"];
        /// `1`
        pub const FIRST_WORKDAY: i64 = 1;
        /// `&["ינואר", "פברואר", "מרץ", "אפריל", "מאי", "יוני", "יולי", "אוגוסט", "ספטמבר", "אוקטובר", "נובמבר", "דצמבר"]`
        pub const MON: &[&str] = &["ינואר", "פברואר", "מרץ", "אפריל", "מאי", "יוני", "יולי", "אוגוסט", "ספטמבר", "אוקטובר", "נובמבר", "דצמבר"];
        /// `"%H:%M:%S"`
        pub const T_FMT: &str = "%H:%M:%S";
        /// `"%I:%M:%S %P"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %P";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod hi_IN {
    pub mod LC_ADDRESS {
        /// `"IN"`
        pub const COUNTRY_ABTWO: &str = "IN";
        /// `"IND"`
        pub const COUNTRY_AB3: &str = "IND";
        /// `"IND"`
        pub const COUNTRY_CAR: &str = "IND";
        /// `"भारत"`
        pub const COUNTRY_NAME: &str = "भारत";
        /// `356`
        pub const COUNTRY_NUM: i64 = 356;
        /// `"hi"`
        pub const LANG_AB: &str = "hi";
        /// `"hin"`
        pub const LANG_LIB: &str = "hin";
        /// `"हिन\u{94d}दी"`
        pub const LANG_NAME: &str = "हिन\u{94d}दी";
        /// `"hin"`
        pub const LANG_TERM: &str = "hin";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan"`
        pub const ADDRESS: &str = "1623-14, Shimotsuruma, Yamato-shi, Kanagawa-ken, 242-8502, Japan";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-07-21"`
        pub const DATE: &str = "2000-07-21";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Hindi"`
        pub const LANGUAGE: &str = "Hindi";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"IBM Globalization Center of Competency, Yamato Software Laboratory"`
        pub const SOURCE: &str = "IBM Globalization Center of Competency, Yamato Software Laboratory";
        /// `""`
        pub const TEL: &str = "";
        /// `"India"`
        pub const TERRITORY: &str = "India";
        /// `"Hindi language locale for India"`
        pub const TITLE: &str = "Hindi language locale for India";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNन]"`
        pub const NOEXPR: &str = "^[-0nNन]";
        /// `"नही\u{902}"`
        pub const NOSTR: &str = "नही\u{902}";
        /// `"^[+1yYह]"`
        pub const YESEXPR: &str = "^[+1yYह]";
        /// `"हा\u{901}"`
        pub const YESSTR: &str = "हा\u{901}";
    }
    pub mod LC_MONETARY {
        /// `"₹"`
        pub const CURRENCY_SYMBOL: &str = "₹";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"INR "`
        pub const INT_CURR_SYMBOL: &str = "INR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 2]`
        pub const MON_GROUPING: &[i64] = &[3, 2];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"91"`
        pub const INT_PREFIX: &str = "91";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c ;%a ;%l"`
        pub const TEL_INT_FMT: &str = "+%c ;%a ;%l";
    }
    pub mod LC_TIME {
        /// `&["रवि", "सोम", "म\u{902}गल", "ब\u{941}ध", "ग\u{941}र\u{941}", "श\u{941}क\u{94d}र", "शनि"]`
        pub const ABDAY: &[&str] = &["रवि", "सोम", "म\u{902}गल", "ब\u{941}ध", "ग\u{941}र\u{941}", "श\u{941}क\u{94d}र", "शनि"];
        /// `&["जन॰", "फ\u{93c}र॰", "मार\u{94d}च", "अप\u{94d}र\u{948}ल", "मई", "ज\u{942}न", "ज\u{941}ल॰", "अग॰", "सित॰", "अक\u{94d}त\u{942}॰", "नव॰", "दिस॰"]`
        pub const ABMON: &[&str] = &["जन॰", "फ\u{93c}र॰", "मार\u{94d}च", "अप\u{94d}र\u{948}ल", "मई", "ज\u{942}न", "ज\u{941}ल॰", "अग॰", "सित॰", "अक\u{94d}त\u{942}॰", "नव॰", "दिस॰"];
        /// `&["प\u{942}र\u{94d}वाह\u{94d}न", "अपराह\u{94d}न"]`
        pub const AM_PM: &[&str] = &["प\u{942}र\u{94d}वाह\u{94d}न", "अपराह\u{94d}न"];
        /// `"%-d/%-m/%y"`
        pub const D_FMT: &str = "%-d/%-m/%y";
        /// `"%A %d %b %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A %d %b %Y %I:%M:%S %p %Z";
        /// `&["रविवार", "सोमवार", "म\u{902}गलवार", "ब\u{941}धवार", "ग\u{941}र\u{941}वार", "श\u{941}क\u{94d}रवार", "शनिवार"]`
        pub const DAY: &[&str] = &["रविवार", "सोमवार", "म\u{902}गलवार", "ब\u{941}धवार", "ग\u{941}र\u{941}वार", "श\u{941}क\u{94d}रवार", "शनिवार"];
        /// `&["जनवरी", "फ\u{93c}रवरी", "मार\u{94d}च", "अप\u{94d}र\u{948}ल", "मई", "ज\u{942}न", "ज\u{941}लाई", "अगस\u{94d}त", "सित\u{902}बर", "अक\u{94d}त\u{942}बर", "नव\u{902}बर", "दिस\u{902}बर"]`
        pub const MON: &[&str] = &["जनवरी", "फ\u{93c}रवरी", "मार\u{94d}च", "अप\u{94d}र\u{948}ल", "मई", "ज\u{942}न", "ज\u{941}लाई", "अगस\u{94d}त", "सित\u{902}बर", "अक\u{94d}त\u{942}बर", "नव\u{902}बर", "दिस\u{902}बर"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod hif_FJ {
    pub mod LC_ADDRESS {
        /// `"FJ"`
        pub const COUNTRY_ABTWO: &str = "FJ";
        /// `"FJI"`
        pub const COUNTRY_AB3: &str = "FJI";
        /// `"FJI"`
        pub const COUNTRY_CAR: &str = "FJI";
        /// `"Fiji"`
        pub const COUNTRY_NAME: &str = "Fiji";
        /// `242`
        pub const COUNTRY_NUM: i64 = 242;
        /// `""`
        pub const COUNTRY_POST: &str = "";
        /// `""`
        pub const LANG_AB: &str = "";
        /// `""`
        pub const LANG_LIB: &str = "";
        /// `"हिन\u{94d}दी"`
        pub const LANG_NAME: &str = "हिन\u{94d}दी";
        /// `"hif"`
        pub const LANG_TERM: &str = "hif";
        /// `"%a%N%h%t%s%N%N%T%c"`
        pub const POSTAL_FMT: &str = "%a%N%h%t%s%N%N%T%c";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2017-03-21"`
        pub const DATE: &str = "2017-03-21";
        /// `"akhilesh.k@samsung.com"`
        pub const EMAIL: &str = "akhilesh.k@samsung.com";
        /// `""`
        pub const FAX: &str = "";
        /// `"Fiji Hindi"`
        pub const LANGUAGE: &str = "Fiji Hindi";
        /// `"0.1"`
        pub const REVISION: &str = "0.1";
        /// `"Samsung Electronics Co., Ltd."`
        pub const SOURCE: &str = "Samsung Electronics Co., Ltd.";
        /// `""`
        pub const TEL: &str = "";
        /// `"Fiji"`
        pub const TERRITORY: &str = "Fiji";
        /// `"Fiji Hindi (Latin) language locale for Fiji"`
        pub const TITLE: &str = "Fiji Hindi (Latin) language locale for Fiji";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"Nahi"`
        pub const NOSTR: &str = "Nahi";
        /// `"^[+1hHyY]"`
        pub const YESEXPR: &str = "^[+1hHyY]";
        /// `"Haan"`
        pub const YESSTR: &str = "Haan";
    }
    pub mod LC_MONETARY {
        /// `"FJ$"`
        pub const CURRENCY_SYMBOL: &str = "FJ$";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"FJD "`
        pub const INT_CURR_SYMBOL: &str = "FJD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `1`
        pub const INT_N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const INT_P_SEP_BY_SPACE: i64 = 1;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub use super::hi_IN::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `"679"`
        pub const INT_PREFIX: &str = "679";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %l"`
        pub const TEL_INT_FMT: &str = "+%c %l";
    }
    pub mod LC_TIME {
        /// `&["Ravi", "Som", "Mangal", "Budh", "Guru", "Shukra", "Shani"]`
        pub const ABDAY: &[&str] = &["Ravi", "Som", "Mangal", "Budh", "Guru", "Shukra", "Shani"];
        /// `&["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        /// `&["Purvahan", "Aparaahna"]`
        pub const AM_PM: &[&str] = &["Purvahan", "Aparaahna"];
        /// `"%A %d %b %Y"`
        pub const D_FMT: &str = "%A %d %b %Y";
        /// `"%A %d %b %Y %I:%M:%S %p"`
        pub const D_T_FMT: &str = "%A %d %b %Y %I:%M:%S %p";
        /// `"%A %d %b %Y %I:%M:%S %p %Z"`
        pub const DATE_FMT: &str = "%A %d %b %Y %I:%M:%S %p %Z";
        /// `&["Ravivar", "Somvar", "Mangalvar", "Budhvar", "Guruvar", "Shukravar", "Shanivar"]`
        pub const DAY: &[&str] = &["Ravivar", "Somvar", "Mangalvar", "Budhvar", "Guruvar", "Shukravar", "Shanivar"];
        /// `&["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"]`
        pub const MON: &[&str] = &["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod hne_IN {
    pub mod LC_ADDRESS {
        /// `"IN"`
        pub const COUNTRY_ABTWO: &str = "IN";
        /// `"IND"`
        pub const COUNTRY_AB3: &str = "IND";
        /// `"IND"`
        pub const COUNTRY_CAR: &str = "IND";
        /// `"भारत"`
        pub const COUNTRY_NAME: &str = "भारत";
        /// `356`
        pub const COUNTRY_NUM: i64 = 356;
        /// `"छत\u{94d}तीसगढ\u{93c}ी"`
        pub const LANG_NAME: &str = "छत\u{94d}तीसगढ\u{93c}ी";
        /// `"hne"`
        pub const LANG_TERM: &str = "hne";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Marisfot III, Marigold Premises, East-Wing, Kalyaninagar, Pune, India-411014"`
        pub const ADDRESS: &str = "Marisfot III, Marigold Premises, East-Wing, Kalyaninagar, Pune, India-411014";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2008-12-03"`
        pub const DATE: &str = "2008-12-03";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Chhattisgarhi"`
        pub const LANGUAGE: &str = "Chhattisgarhi";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Red Hat, Pune"`
        pub const SOURCE: &str = "Red Hat, Pune";
        /// `""`
        pub const TEL: &str = "";
        /// `"India"`
        pub const TERRITORY: &str = "India";
        /// `"Chhattisgarhi language locale for India"`
        pub const TITLE: &str = "Chhattisgarhi language locale for India";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNन]"`
        pub const NOEXPR: &str = "^[-0nNन]";
        /// `"नइ"`
        pub const NOSTR: &str = "नइ";
        /// `"^[+1yYह]"`
        pub const YESEXPR: &str = "^[+1yYह]";
        /// `"हव"`
        pub const YESSTR: &str = "हव";
    }
    pub use super::hi_IN::LC_MONETARY;
    pub use super::hi_IN::LC_NUMERIC;
    pub use super::hi_IN::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["इत", "सोम", "म\u{902}ग", "ब\u{941}ध", "बिर", "स\u{941}क", "सनि"]`
        pub const ABDAY: &[&str] = &["इत", "सोम", "म\u{902}ग", "ब\u{941}ध", "बिर", "स\u{941}क", "सनि"];
        /// `&["जन", "फर", "मार\u{94d}च", "अप", "मई", "ज\u{942}न", "ज\u{941}ला", "अग", "सित", "अकट\u{942}", "नव", "दिस"]`
        pub const ABMON: &[&str] = &["जन", "फर", "मार\u{94d}च", "अप", "मई", "ज\u{942}न", "ज\u{941}ला", "अग", "सित", "अकट\u{942}", "नव", "दिस"];
        /// `&["बिहिनिया\u{901}", "म\u{902}झनिया\u{901}"]`
        pub const AM_PM: &[&str] = &["बिहिनिया\u{901}", "म\u{902}झनिया\u{901}"];
        /// `"%-d/%-m/%y"`
        pub const D_FMT: &str = "%-d/%-m/%y";
        /// `"%A %d %b %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A %d %b %Y %I:%M:%S %p %Z";
        /// `&["इतवार", "सोमवार", "म\u{902}गलवार", "ब\u{941}धवार", "बिरसपत", "स\u{941}करवार", "सनिवार"]`
        pub const DAY: &[&str] = &["इतवार", "सोमवार", "म\u{902}गलवार", "ब\u{941}धवार", "बिरसपत", "स\u{941}करवार", "सनिवार"];
        /// `&["जनवरी", "फरवरी", "मार\u{94d}च", "अपर\u{947}ल", "मई", "ज\u{942}न", "ज\u{941}लाई", "अगस\u{94d}त", "सितमबर", "अकट\u{942}बर", "नवमबर", "दिसमबर"]`
        pub const MON: &[&str] = &["जनवरी", "फरवरी", "मार\u{94d}च", "अपर\u{947}ल", "मई", "ज\u{942}न", "ज\u{941}लाई", "अगस\u{94d}त", "सितमबर", "अकट\u{942}बर", "नवमबर", "दिसमबर"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod hr_HR {
    pub mod LC_ADDRESS {
        /// `"HR"`
        pub const COUNTRY_ABTWO: &str = "HR";
        /// `"HRV"`
        pub const COUNTRY_AB3: &str = "HRV";
        /// `"HR"`
        pub const COUNTRY_CAR: &str = "HR";
        /// `"978-953"`
        pub const COUNTRY_ISBN: &str = "978-953";
        /// `"Hrvatska"`
        pub const COUNTRY_NAME: &str = "Hrvatska";
        /// `191`
        pub const COUNTRY_NUM: i64 = 191;
        /// `"HR"`
        pub const COUNTRY_POST: &str = "HR";
        /// `"hr"`
        pub const LANG_AB: &str = "hr";
        /// `"hrv"`
        pub const LANG_LIB: &str = "hrv";
        /// `"hrvatski"`
        pub const LANG_NAME: &str = "hrvatski";
        /// `"hrv"`
        pub const LANG_TERM: &str = "hrv";
        /// `"%f%N%d%N%a%N%s %h%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%d%N%a%N%s %h%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2016-04-16"`
        pub const DATE: &str = "2016-04-16";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Croatian"`
        pub const LANGUAGE: &str = "Croatian";
        /// `"2.3"`
        pub const REVISION: &str = "2.3";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"Croatia"`
        pub const TERRITORY: &str = "Croatia";
        /// `"Croatian locale for Croatia"`
        pub const TITLE: &str = "Croatian locale for Croatia";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"ne"`
        pub const NOSTR: &str = "ne";
        /// `"^[+1dDyY]"`
        pub const YESEXPR: &str = "^[+1dDyY]";
        /// `"da"`
        pub const YESSTR: &str = "da";
    }
    pub mod LC_MONETARY {
        /// `"kn"`
        pub const CURRENCY_SYMBOL: &str = "kn";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"HRK "`
        pub const INT_CURR_SYMBOL: &str = "HRK ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `1`
        pub const INT_N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const INT_P_CS_PRECEDES: i64 = 1;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `"385"`
        pub const INT_PREFIX: &str = "385";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"%A %l"`
        pub const TEL_DOM_FMT: &str = "%A %l";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["ned", "pon", "uto", "sri", "čet", "pet", "sub"]`
        pub const ABDAY: &[&str] = &["ned", "pon", "uto", "sri", "čet", "pet", "sub"];
        /// `&["sij", "velj", "ožu", "tra", "svi", "lip", "srp", "kol", "ruj", "lis", "stu", "pro"]`
        pub const ABMON: &[&str] = &["sij", "velj", "ožu", "tra", "svi", "lip", "srp", "kol", "ruj", "lis", "stu", "pro"];
        /// `&["siječanj", "veljača", "ožujak", "travanj", "svibanj", "lipanj", "srpanj", "kolovoz", "rujan", "listopad", "studeni", "prosinac"]`
        pub const ALT_MON: &[&str] = &["siječanj", "veljača", "ožujak", "travanj", "svibanj", "lipanj", "srpanj", "kolovoz", "rujan", "listopad", "studeni", "prosinac"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%A, %d. %B %Y. %T %Z"`
        pub const D_T_FMT: &str = "%A, %d. %B %Y. %T %Z";
        /// `"%a, %e.%m.%Y.  %H:%M:%S %Z"`
        pub const DATE_FMT: &str = "%a, %e.%m.%Y.  %H:%M:%S %Z";
        /// `&["nedjelja", "ponedjeljak", "utorak", "srijeda", "četvrtak", "petak", "subota"]`
        pub const DAY: &[&str] = &["nedjelja", "ponedjeljak", "utorak", "srijeda", "četvrtak", "petak", "subota"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `2`
        pub const FIRST_WORKDAY: i64 = 2;
        /// `&["siječnja", "veljače", "ožujka", "travnja", "svibnja", "lipnja", "srpnja", "kolovoza", "rujna", "listopada", "studenoga", "prosinca"]`
        pub const MON: &[&str] = &["siječnja", "veljače", "ožujka", "travnja", "svibnja", "lipnja", "srpnja", "kolovoza", "rujna", "listopada", "studenoga", "prosinca"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod hsb_DE {
    pub mod LC_ADDRESS {
        /// `"DE"`
        pub const COUNTRY_ABTWO: &str = "DE";
        /// `"DEU"`
        pub const COUNTRY_AB3: &str = "DEU";
        /// `"D"`
        pub const COUNTRY_CAR: &str = "D";
        /// `3`
        pub const COUNTRY_ISBN: i64 = 3;
        /// `"Němska"`
        pub const COUNTRY_NAME: &str = "Němska";
        /// `276`
        pub const COUNTRY_NUM: i64 = 276;
        /// `"D"`
        pub const COUNTRY_POST: &str = "D";
        /// `""`
        pub const LANG_AB: &str = "";
        /// `"hsb"`
        pub const LANG_LIB: &str = "hsb";
        /// `"hornjoserbšćina"`
        pub const LANG_NAME: &str = "hornjoserbšćina";
        /// `"hsb"`
        pub const LANG_TERM: &str = "hsb";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `"Andrzej Krzysztofowicz"`
        pub const CONTACT: &str = "Andrzej Krzysztofowicz";
        /// `"2004-09-09"`
        pub const DATE: &str = "2004-09-09";
        /// `"ankry@mif.pg.gda.pl"`
        pub const EMAIL: &str = "ankry@mif.pg.gda.pl";
        /// `""`
        pub const FAX: &str = "";
        /// `"Upper Sorbian"`
        pub const LANGUAGE: &str = "Upper Sorbian";
        /// `"0.1"`
        pub const REVISION: &str = "0.1";
        /// `"Information from Michael Wolf"`
        pub const SOURCE: &str = "Information from Michael Wolf";
        /// `""`
        pub const TEL: &str = "";
        /// `"Germany"`
        pub const TERRITORY: &str = "Germany";
        /// `"Upper Sorbian locale for Germany"`
        pub const TITLE: &str = "Upper Sorbian locale for Germany";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"ně"`
        pub const NOSTR: &str = "ně";
        /// `"^[+1hHyY]"`
        pub const YESEXPR: &str = "^[+1hHyY]";
        /// `"haj"`
        pub const YESSTR: &str = "haj";
    }
    pub use super::de_DE::LC_MONETARY;
    pub use super::de_DE::LC_NUMERIC;
    pub use super::de_DE::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Nj", "Pó", "Wu", "Sr", "Št", "Pj", "So"]`
        pub const ABDAY: &[&str] = &["Nj", "Pó", "Wu", "Sr", "Št", "Pj", "So"];
        /// `&["Jan", "Feb", "Měr", "Apr", "Mej", "Jun", "Jul", "Awg", "Sep", "Okt", "Now", "Dec"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Měr", "Apr", "Mej", "Jun", "Jul", "Awg", "Sep", "Okt", "Now", "Dec"];
        /// `&["Januar", "Februar", "Měrc", "Apryl", "Meja", "Junij", "Julij", "Awgust", "September", "Oktober", "Nowember", "December"]`
        pub const ALT_MON: &[&str] = &["Januar", "Februar", "Měrc", "Apryl", "Meja", "Junij", "Julij", "Awgust", "September", "Oktober", "Nowember", "December"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["Njedźela", "Póndźela", "Wutora", "Srjeda", "Štvórtk", "Pjatk", "Sobota"]`
        pub const DAY: &[&str] = &["Njedźela", "Póndźela", "Wutora", "Srjeda", "Štvórtk", "Pjatk", "Sobota"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["januara", "februara", "měrca", "apryla", "meje", "junija", "julija", "awgusta", "septembra", "oktobra", "nowembra", "decembra"]`
        pub const MON: &[&str] = &["januara", "februara", "měrca", "apryla", "meje", "junija", "julija", "awgusta", "septembra", "oktobra", "nowembra", "decembra"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ht_HT {
    pub mod LC_ADDRESS {
        /// `"HT"`
        pub const COUNTRY_ABTWO: &str = "HT";
        /// `"HTI"`
        pub const COUNTRY_AB3: &str = "HTI";
        /// `"RH"`
        pub const COUNTRY_CAR: &str = "RH";
        /// `99935`
        pub const COUNTRY_ISBN: i64 = 99935;
        /// `"Ayiti"`
        pub const COUNTRY_NAME: &str = "Ayiti";
        /// `332`
        pub const COUNTRY_NUM: i64 = 332;
        /// `"HT"`
        pub const COUNTRY_POST: &str = "HT";
        /// `"ht"`
        pub const LANG_AB: &str = "ht";
        /// `"hat"`
        pub const LANG_LIB: &str = "hat";
        /// `"Kreyòl ayisyen"`
        pub const LANG_NAME: &str = "Kreyòl ayisyen";
        /// `"hat"`
        pub const LANG_TERM: &str = "hat";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %R%N%%Z %t%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %R%N%%Z %t%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ];
        /// `"sugarlabs.org"`
        pub const CONTACT: &str = "sugarlabs.org";
        /// `"2013-08-09"`
        pub const DATE: &str = "2013-08-09";
        /// `"libc-alpha@sourceware.org"`
        pub const EMAIL: &str = "libc-alpha@sourceware.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Haitian Creole"`
        pub const LANGUAGE: &str = "Haitian Creole";
        /// `"1.1"`
        pub const REVISION: &str = "1.1";
        /// `"Sugar Labs / OLPC"`
        pub const SOURCE: &str = "Sugar Labs / OLPC";
        /// `""`
        pub const TEL: &str = "";
        /// `"Haiti"`
        pub const TERRITORY: &str = "Haiti";
        /// `"Kreyol locale for Haiti"`
        pub const TITLE: &str = "Kreyol locale for Haiti";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"Non"`
        pub const NOSTR: &str = "Non";
        /// `"^[+1wWoOyY]"`
        pub const YESEXPR: &str = "^[+1wWoOyY]";
        /// `"Wi"`
        pub const YESSTR: &str = "Wi";
    }
    pub mod LC_MONETARY {
        /// `"g"`
        pub const CURRENCY_SYMBOL: &str = "g";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"HTG "`
        pub const INT_CURR_SYMBOL: &str = "HTG ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `"\u{202f}"`
        pub const THOUSANDS_SEP: &str = "\u{202f}";
    }
    pub mod LC_TELEPHONE {
        /// `"509"`
        pub const INT_PREFIX: &str = "509";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"%a %l"`
        pub const TEL_DOM_FMT: &str = "%a %l";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["dim", "len", "mad", "mèk", "jed", "van", "sam"]`
        pub const ABDAY: &[&str] = &["dim", "len", "mad", "mèk", "jed", "van", "sam"];
        /// `&["jan", "fev", "mas", "avr", "me", "jen", "jiy", "out", "sep", "okt", "nov", "des"]`
        pub const ABMON: &[&str] = &["jan", "fev", "mas", "avr", "me", "jen", "jiy", "out", "sep", "okt", "nov", "des"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["dimanch", "lendi", "madi", "mèkredi", "jedi", "vandredi", "samdi"]`
        pub const DAY: &[&str] = &["dimanch", "lendi", "madi", "mèkredi", "jedi", "vandredi", "samdi"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["janvye", "fevriye", "mas", "avril", "me", "jen", "jiyè", "out", "septanm", "oktòb", "novanm", "desanm"]`
        pub const MON: &[&str] = &["janvye", "fevriye", "mas", "avril", "me", "jen", "jiyè", "out", "septanm", "oktòb", "novanm", "desanm"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod hu_HU {
    pub mod LC_ADDRESS {
        /// `"HU"`
        pub const COUNTRY_ABTWO: &str = "HU";
        /// `"HUN"`
        pub const COUNTRY_AB3: &str = "HUN";
        /// `"H"`
        pub const COUNTRY_CAR: &str = "H";
        /// `"Magyarország"`
        pub const COUNTRY_NAME: &str = "Magyarország";
        /// `348`
        pub const COUNTRY_NUM: i64 = 348;
        /// `"hu"`
        pub const LANG_AB: &str = "hu";
        /// `"hun"`
        pub const LANG_LIB: &str = "hun";
        /// `"magyar"`
        pub const LANG_NAME: &str = "magyar";
        /// `"hun"`
        pub const LANG_TERM: &str = "hun";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jorgens Alle 8, DK-1615 Kobenhavn V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jorgens Alle 8, DK-1615 Kobenhavn V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2001-01-29"`
        pub const DATE: &str = "2001-01-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Hungarian"`
        pub const LANGUAGE: &str = "Hungarian";
        /// `"4.7"`
        pub const REVISION: &str = "4.7";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Hungary"`
        pub const TERRITORY: &str = "Hungary";
        /// `"Hungarian locale for Hungary"`
        pub const TITLE: &str = "Hungarian locale for Hungary";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"nem"`
        pub const NOSTR: &str = "nem";
        /// `"^[+1IiYy]"`
        pub const YESEXPR: &str = "^[+1IiYy]";
        /// `"igen"`
        pub const YESSTR: &str = "igen";
    }
    pub mod LC_MONETARY {
        /// `"Ft"`
        pub const CURRENCY_SYMBOL: &str = "Ft";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"HUF "`
        pub const INT_CURR_SYMBOL: &str = "HUF ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `1`
        pub const INT_N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const INT_N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const INT_N_SIGN_POSN: i64 = 1;
        /// `1`
        pub const INT_P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const INT_P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const INT_P_SIGN_POSN: i64 = 1;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `"36"`
        pub const INT_PREFIX: &str = "36";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["v", "h", "k", "sze", "cs", "p", "szo"]`
        pub const ABDAY: &[&str] = &["v", "h", "k", "sze", "cs", "p", "szo"];
        /// `&["jan", "febr", "márc", "ápr", "máj", "jún", "júl", "aug", "szept", "okt", "nov", "dec"]`
        pub const ABMON: &[&str] = &["jan", "febr", "márc", "ápr", "máj", "jún", "júl", "aug", "szept", "okt", "nov", "dec"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%Y-%m-%d"`
        pub const D_FMT: &str = "%Y-%m-%d";
        /// `"%Y. %b. %-e., %A, %H:%M:%S %Z"`
        pub const D_T_FMT: &str = "%Y. %b. %-e., %A, %H:%M:%S %Z";
        /// `"%Y. %b. %-e., %A, %H:%M:%S %Z"`
        pub const DATE_FMT: &str = "%Y. %b. %-e., %A, %H:%M:%S %Z";
        /// `&["vasárnap", "hétfő", "kedd", "szerda", "csütörtök", "péntek", "szombat"]`
        pub const DAY: &[&str] = &["vasárnap", "hétfő", "kedd", "szerda", "csütörtök", "péntek", "szombat"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["január", "február", "március", "április", "május", "június", "július", "augusztus", "szeptember", "október", "november", "december"]`
        pub const MON: &[&str] = &["január", "február", "március", "április", "május", "június", "július", "augusztus", "szeptember", "október", "november", "december"];
        /// `"%H:%M:%S"`
        pub const T_FMT: &str = "%H:%M:%S";
        /// `"%H:%M:%S"`
        pub const T_FMT_AMPM: &str = "%H:%M:%S";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod hy_AM {
    pub mod LC_ADDRESS {
        /// `"AM"`
        pub const COUNTRY_ABTWO: &str = "AM";
        /// `"ARM"`
        pub const COUNTRY_AB3: &str = "ARM";
        /// `"AM"`
        pub const COUNTRY_CAR: &str = "AM";
        /// `"978-9939,978-99930,978-99941"`
        pub const COUNTRY_ISBN: &str = "978-9939,978-99930,978-99941";
        /// `"Հայաստան"`
        pub const COUNTRY_NAME: &str = "Հայաստան";
        /// `51`
        pub const COUNTRY_NUM: i64 = 51;
        /// `"AM"`
        pub const COUNTRY_POST: &str = "AM";
        /// `"hy"`
        pub const LANG_AB: &str = "hy";
        /// `"arm"`
        pub const LANG_LIB: &str = "arm";
        /// `"հայերեն"`
        pub const LANG_NAME: &str = "հայերեն";
        /// `"hye"`
        pub const LANG_TERM: &str = "hye";
        /// `"%d%N%f%N%d%N%b%N%s %h 5e %r%N%C%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%d%N%f%N%d%N%b%N%s %h 5e %r%N%C%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_ADDRESS"],
        ];
        /// `"Pablo Saratxaga"`
        pub const CONTACT: &str = "Pablo Saratxaga";
        /// `"2001-01-26"`
        pub const DATE: &str = "2001-01-26";
        /// `"pablo@mandrakesoft.com"`
        pub const EMAIL: &str = "pablo@mandrakesoft.com";
        /// `""`
        pub const FAX: &str = "";
        /// `"Armenian"`
        pub const LANGUAGE: &str = "Armenian";
        /// `"0.4"`
        pub const REVISION: &str = "0.4";
        /// `"http://www.freenet.am/armscii"`
        pub const SOURCE: &str = "http://www.freenet.am/armscii";
        /// `""`
        pub const TEL: &str = "";
        /// `"Armenia"`
        pub const TERRITORY: &str = "Armenia";
        /// `"Armenian language locale for Armenia"`
        pub const TITLE: &str = "Armenian language locale for Armenia";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNոՈ]"`
        pub const NOEXPR: &str = "^[-0nNոՈ]";
        /// `"ոչ"`
        pub const NOSTR: &str = "ոչ";
        /// `"^[+1yYsSաԱ]"`
        pub const YESEXPR: &str = "^[+1yYsSաԱ]";
        /// `"այո"`
        pub const YESSTR: &str = "այո";
    }
    pub mod LC_MONETARY {
        /// `"֏"`
        pub const CURRENCY_SYMBOL: &str = "֏";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"AMD "`
        pub const INT_CURR_SYMBOL: &str = "AMD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"374"`
        pub const INT_PREFIX: &str = "374";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["Կրկ", "Երկ", "Երք", "Չրք", "Հնգ", "Ուր", "Շբթ"]`
        pub const ABDAY: &[&str] = &["Կրկ", "Երկ", "Երք", "Չրք", "Հնգ", "Ուր", "Շբթ"];
        /// `&["Հնվ", "Փտր", "Մար", "Ապր", "Մայ", "Հնս", "Հլս", "Օգս", "Սեպ", "Հոկ", "Նմբ", "Դեկ"]`
        pub const ABMON: &[&str] = &["Հնվ", "Փտր", "Մար", "Ապր", "Մայ", "Հնս", "Հլս", "Օգս", "Սեպ", "Հոկ", "Նմբ", "Դեկ"];
        /// `&["հունվար", "փետրվար", "մարտ", "ապրիլ", "մայիս", "հունիս", "հուլիս", "օգոստոս", "սեպտեմբեր", "հոկտեմբեր", "նոյեմբեր", "դեկտեմբեր"]`
        pub const ALT_MON: &[&str] = &["հունվար", "փետրվար", "մարտ", "ապրիլ", "մայիս", "հունիս", "հուլիս", "օգոստոս", "սեպտեմբեր", "հոկտեմբեր", "նոյեմբեր", "դեկտեմբեր"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%m/%d/%y"`
        pub const D_FMT: &str = "%m/%d/%y";
        /// `"%a %d %b %Y %r %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %r %Z";
        /// `&["Կիրակի", "Երկուշաբթի", "Երեքշաբթի", "Չորեքշաբթի", "Հինգշաբթի", "Ուրբաթ", "Շաբաթ"]`
        pub const DAY: &[&str] = &["Կիրակի", "Երկուշաբթի", "Երեքշաբթի", "Չորեքշաբթի", "Հինգշաբթի", "Ուրբաթ", "Շաբաթ"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["հունվարի", "փետրվարի", "մարտի", "ապրիլի", "մայիսի", "հունիսի", "հուլիսի", "օգոստոսի", "սեպտեմբերի", "հոկտեմբերի", "նոյեմբերի", "դեկտեմբերի"]`
        pub const MON: &[&str] = &["հունվարի", "փետրվարի", "մարտի", "ապրիլի", "մայիսի", "հունիսի", "հուլիսի", "օգոստոսի", "սեպտեմբերի", "հոկտեմբերի", "նոյեմբերի", "դեկտեմբերի"];
        /// `"%r"`
        pub const T_FMT: &str = "%r";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ia_FR {
    pub mod LC_ADDRESS {
        /// `"FR"`
        pub const COUNTRY_ABTWO: &str = "FR";
        /// `"FRA"`
        pub const COUNTRY_AB3: &str = "FRA";
        /// `"F"`
        pub const COUNTRY_CAR: &str = "F";
        /// `"979-10"`
        pub const COUNTRY_ISBN: &str = "979-10";
        /// `"Francia"`
        pub const COUNTRY_NAME: &str = "Francia";
        /// `250`
        pub const COUNTRY_NUM: i64 = 250;
        /// `"F"`
        pub const COUNTRY_POST: &str = "F";
        /// `"ia"`
        pub const LANG_AB: &str = "ia";
        /// `"ina"`
        pub const LANG_LIB: &str = "ina";
        /// `"interlingua"`
        pub const LANG_NAME: &str = "interlingua";
        /// `"ina"`
        pub const LANG_TERM: &str = "ina";
        /// `"%f%N%a%N%d%N%b%N%s%t%h%t%e%t%r%N%z%t%T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s%t%h%t%e%t%r%N%z%t%T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
        ];
        /// `"Nik Kalach"`
        pub const CONTACT: &str = "Nik Kalach";
        /// `"2013-03-01"`
        pub const DATE: &str = "2013-03-01";
        /// `"nikka@fedoraproject.org"`
        pub const EMAIL: &str = "nikka@fedoraproject.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Interlingua"`
        pub const LANGUAGE: &str = "Interlingua";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Fedora Project"`
        pub const SOURCE: &str = "Fedora Project";
        /// `""`
        pub const TEL: &str = "";
        /// `"France"`
        pub const TERRITORY: &str = "France";
        /// `"Interlingua locale for France"`
        pub const TITLE: &str = "Interlingua locale for France";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"No"`
        pub const NOSTR: &str = "No";
        /// `"^[+1sSyY]"`
        pub const YESEXPR: &str = "^[+1sSyY]";
        /// `"Si"`
        pub const YESSTR: &str = "Si";
    }
    pub use super::fr_FR::LC_MONETARY;
    pub use super::fr_FR::LC_NUMERIC;
    pub use super::fr_FR::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mer", "jov", "ven", "sab"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mer", "jov", "ven", "sab"];
        /// `&["jan", "feb", "mar", "apr", "mai", "jun", "jul", "aug", "sep", "oct", "nov", "dec"]`
        pub const ABMON: &[&str] = &["jan", "feb", "mar", "apr", "mai", "jun", "jul", "aug", "sep", "oct", "nov", "dec"];
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["dominica", "lunedi", "martedi", "mercuridi", "jovedi", "venerdi", "sabbato"]`
        pub const DAY: &[&str] = &["dominica", "lunedi", "martedi", "mercuridi", "jovedi", "venerdi", "sabbato"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["januario", "februario", "martio", "april", "maio", "junio", "julio", "augusto", "septembre", "octobre", "novembre", "decembre"]`
        pub const MON: &[&str] = &["januario", "februario", "martio", "april", "maio", "junio", "julio", "augusto", "septembre", "octobre", "novembre", "decembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod id_ID {
    pub mod LC_ADDRESS {
        /// `"ID"`
        pub const COUNTRY_ABTWO: &str = "ID";
        /// `"IDN"`
        pub const COUNTRY_AB3: &str = "IDN";
        /// `"RI"`
        pub const COUNTRY_CAR: &str = "RI";
        /// `"Indonesia"`
        pub const COUNTRY_NAME: &str = "Indonesia";
        /// `360`
        pub const COUNTRY_NUM: i64 = 360;
        /// `"id"`
        pub const LANG_AB: &str = "id";
        /// `"ind"`
        pub const LANG_LIB: &str = "ind";
        /// `"Indonesia"`
        pub const LANG_NAME: &str = "Indonesia";
        /// `"ind"`
        pub const LANG_TERM: &str = "ind";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Indonesian"`
        pub const LANGUAGE: &str = "Indonesian";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"Indonesia"`
        pub const TERRITORY: &str = "Indonesia";
        /// `"Indonesian locale for Indonesia"`
        pub const TITLE: &str = "Indonesian locale for Indonesia";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0tTnN]"`
        pub const NOEXPR: &str = "^[-0tTnN]";
        /// `"tidak"`
        pub const NOSTR: &str = "tidak";
        /// `"^[+1yY]"`
        pub const YESEXPR: &str = "^[+1yY]";
        /// `"ya"`
        pub const YESSTR: &str = "ya";
    }
    pub mod LC_MONETARY {
        /// `"Rp"`
        pub const CURRENCY_SYMBOL: &str = "Rp";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"IDR "`
        pub const INT_CURR_SYMBOL: &str = "IDR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `"62"`
        pub const INT_PREFIX: &str = "62";
        /// `"001,008,007,009"`
        pub const INT_SELECT: &str = "001,008,007,009";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["Min", "Sen", "Sel", "Rab", "Kam", "Jum", "Sab"]`
        pub const ABDAY: &[&str] = &["Min", "Sen", "Sel", "Rab", "Kam", "Jum", "Sab"];
        /// `&["Jan", "Feb", "Mar", "Apr", "Mei", "Jun", "Jul", "Agu", "Sep", "Okt", "Nov", "Des"]`
        pub const ABMON: &[&str] = &["Jan", "Feb", "Mar", "Apr", "Mei", "Jun", "Jul", "Agu", "Sep", "Okt", "Nov", "Des"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %r %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %r %Z";
        /// `&["Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jumat", "Sabtu"]`
        pub const DAY: &[&str] = &["Minggu", "Senin", "Selasa", "Rabu", "Kamis", "Jumat", "Sabtu"];
        /// `&["Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli", "Agustus", "September", "Oktober", "November", "Desember"]`
        pub const MON: &[&str] = &["Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli", "Agustus", "September", "Oktober", "November", "Desember"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ig_NG {
    pub mod LC_ADDRESS {
        /// `"NG"`
        pub const COUNTRY_ABTWO: &str = "NG";
        /// `"NGA"`
        pub const COUNTRY_AB3: &str = "NGA";
        /// `"WAN"`
        pub const COUNTRY_CAR: &str = "WAN";
        /// `978`
        pub const COUNTRY_ISBN: i64 = 978;
        /// `"Naịjịrịa"`
        pub const COUNTRY_NAME: &str = "Naịjịrịa";
        /// `566`
        pub const COUNTRY_NUM: i64 = 566;
        /// `"ig"`
        pub const LANG_AB: &str = "ig";
        /// `"ibo"`
        pub const LANG_LIB: &str = "ibo";
        /// `"Asụsụ Igbo"`
        pub const LANG_NAME: &str = "Asụsụ Igbo";
        /// `"ibo"`
        pub const LANG_TERM: &str = "ibo";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2005-12-14"`
        pub const DATE: &str = "2005-12-14";
        /// `"pablo@mandriva.com"`
        pub const EMAIL: &str = "pablo@mandriva.com";
        /// `""`
        pub const FAX: &str = "";
        /// `"Igbo"`
        pub const LANGUAGE: &str = "Igbo";
        /// `"0.2"`
        pub const REVISION: &str = "0.2";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"Nigeria"`
        pub const TERRITORY: &str = "Nigeria";
        /// `"Igbo locale for Nigeria"`
        pub const TITLE: &str = "Igbo locale for Nigeria";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0MmNn]"`
        pub const NOEXPR: &str = "^[-0MmNn]";
        /// `"Mba"`
        pub const NOSTR: &str = "Mba";
        /// `"^[+1EeIiYy]"`
        pub const YESEXPR: &str = "^[+1EeIiYy]";
        /// `"Eye"`
        pub const YESSTR: &str = "Eye";
    }
    pub use super::en_NG::LC_MONETARY;
    pub use super::en_NG::LC_NUMERIC;
    pub use super::en_NG::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["sọn", "mọn", "tuz", "wen", "tọs", "fra", "sat"]`
        pub const ABDAY: &[&str] = &["sọn", "mọn", "tuz", "wen", "tọs", "fra", "sat"];
        /// `&["Jen", "Feb", "Maa", "Epr", "Mee", "Juu", "Jul", "Ọgọ", "Sep", "Ọkt", "Nov", "Dis"]`
        pub const ABMON: &[&str] = &["Jen", "Feb", "Maa", "Epr", "Mee", "Juu", "Jul", "Ọgọ", "Sep", "Ọkt", "Nov", "Dis"];
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%A, %d %B %Y %T %Z"`
        pub const D_T_FMT: &str = "%A, %d %B %Y %T %Z";
        /// `&["sọnde", "mọnde", "tuzde", "wenzde", "tọsde", "fraịde", "satọde"]`
        pub const DAY: &[&str] = &["sọnde", "mọnde", "tuzde", "wenzde", "tọsde", "fraịde", "satọde"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["Jenụwarị", "Febrụwarị", "Maachị", "Eprel", "Mee", "Juun", "Julaị", "Ọgọọst", "Septemba", "Ọktoba", "Novemba", "Disemba"]`
        pub const MON: &[&str] = &["Jenụwarị", "Febrụwarị", "Maachị", "Eprel", "Mee", "Juun", "Julaị", "Ọgọọst", "Septemba", "Ọktoba", "Novemba", "Disemba"];
        /// `"%r"`
        pub const T_FMT: &str = "%r";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ik_CA {
    pub mod LC_ADDRESS {
        /// `"CA"`
        pub const COUNTRY_ABTWO: &str = "CA";
        /// `"CAN"`
        pub const COUNTRY_AB3: &str = "CAN";
        /// `"CDN"`
        pub const COUNTRY_CAR: &str = "CDN";
        /// `"Kanada"`
        pub const COUNTRY_NAME: &str = "Kanada";
        /// `124`
        pub const COUNTRY_NUM: i64 = 124;
        /// `"ik"`
        pub const LANG_AB: &str = "ik";
        /// `"ipk"`
        pub const LANG_LIB: &str = "ipk";
        /// `"Iñupiatun"`
        pub const LANG_NAME: &str = "Iñupiatun";
        /// `"ipk"`
        pub const LANG_TERM: &str = "ipk";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2004-08-01"`
        pub const DATE: &str = "2004-08-01";
        /// `"pablo@mandriva.com"`
        pub const EMAIL: &str = "pablo@mandriva.com";
        /// `""`
        pub const FAX: &str = "";
        /// `"Inupiaq"`
        pub const LANGUAGE: &str = "Inupiaq";
        /// `"0.2"`
        pub const REVISION: &str = "0.2";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"Canada"`
        pub const TERRITORY: &str = "Canada";
        /// `"Inupiaq locale for Canada"`
        pub const TITLE: &str = "Inupiaq locale for Canada";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNqQ]"`
        pub const NOEXPR: &str = "^[-0nNqQ]";
        /// `"qañaa"`
        pub const NOSTR: &str = "qañaa";
        /// `"^[+1yYiIaA]"`
        pub const YESEXPR: &str = "^[+1yYiIaA]";
        /// `"aa"`
        pub const YESSTR: &str = "aa";
    }
    pub use super::en_CA::LC_MONETARY;
    pub use super::en_CA::LC_NUMERIC;
    pub use super::en_CA::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Min", "Sav", "Ila", "Qit", "Sis", "Tal", "Maq"]`
        pub const ABDAY: &[&str] = &["Min", "Sav", "Ila", "Qit", "Sis", "Tal", "Maq"];
        /// `&["Sñt", "Sñs", "Pan", "Qil", "Sup", "Iġñ", "Itc", "Tiñ", "Ami", "Sik", "Nip", "Siq"]`
        pub const ABMON: &[&str] = &["Sñt", "Sñs", "Pan", "Qil", "Sup", "Iġñ", "Itc", "Tiñ", "Ami", "Sik", "Nip", "Siq"];
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `"%d/%m/%y"`
        pub const D_FMT: &str = "%d/%m/%y";
        /// `"%a %d %b %Y %r %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %r %Z";
        /// `&["Minġuiqsioiq", "Savałłiq", "Ilaqtchiioiq", "Qitchiioiq", "Sisamiioiq", "Tallimmiioiq", "Maqinġuoiq"]`
        pub const DAY: &[&str] = &["Minġuiqsioiq", "Savałłiq", "Ilaqtchiioiq", "Qitchiioiq", "Sisamiioiq", "Tallimmiioiq", "Maqinġuoiq"];
        /// `&["Siqiññaatchiaq", "Siqiññaasrugruk", "Paniqsiqsiivik", "Qilġich Tatqiat", "Suppivik", "Iġñivik", "Itchavik", "Tiññivik", "Amiġaiqsivik", "Sikkuvik", "Nippivik", "Siqiñġiḷaq"]`
        pub const MON: &[&str] = &["Siqiññaatchiaq", "Siqiññaasrugruk", "Paniqsiqsiivik", "Qilġich Tatqiat", "Suppivik", "Iġñivik", "Itchavik", "Tiññivik", "Amiġaiqsivik", "Sikkuvik", "Nippivik", "Siqiñġiḷaq"];
        /// `"%r"`
        pub const T_FMT: &str = "%r";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod is_IS {
    pub mod LC_ADDRESS {
        /// `"IS"`
        pub const COUNTRY_ABTWO: &str = "IS";
        /// `"ISL"`
        pub const COUNTRY_AB3: &str = "ISL";
        /// `"IS"`
        pub const COUNTRY_CAR: &str = "IS";
        /// `"Ísland"`
        pub const COUNTRY_NAME: &str = "Ísland";
        /// `352`
        pub const COUNTRY_NUM: i64 = 352;
        /// `"is"`
        pub const LANG_AB: &str = "is";
        /// `"ice"`
        pub const LANG_LIB: &str = "ice";
        /// `"íslenska"`
        pub const LANG_NAME: &str = "íslenska";
        /// `"isl"`
        pub const LANG_TERM: &str = "isl";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Keldnaholt-ITI\', IS-112 Reykjavi\'k, Iceland"`
        pub const ADDRESS: &str = "Keldnaholt-ITI\', IS-112 Reykjavi\'k, Iceland";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Icelandic"`
        pub const LANGUAGE: &str = "Icelandic";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Stadlarad I\'slands"`
        pub const SOURCE: &str = "Stadlarad I\'slands";
        /// `""`
        pub const TEL: &str = "";
        /// `"Iceland"`
        pub const TERRITORY: &str = "Iceland";
        /// `"Icelandic locale for Iceland"`
        pub const TITLE: &str = "Icelandic locale for Iceland";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"nei"`
        pub const NOSTR: &str = "nei";
        /// `"^[+1jJyY]"`
        pub const YESEXPR: &str = "^[+1jJyY]";
        /// `"já"`
        pub const YESSTR: &str = "já";
    }
    pub mod LC_MONETARY {
        /// `"kr"`
        pub const CURRENCY_SYMBOL: &str = "kr";
        /// `0`
        pub const FRAC_DIGITS: i64 = 0;
        /// `"ISK "`
        pub const INT_CURR_SYMBOL: &str = "ISK ";
        /// `0`
        pub const INT_FRAC_DIGITS: i64 = 0;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `"354"`
        pub const INT_PREFIX: &str = "354";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["sun", "mán", "þri", "mið", "fim", "fös", "lau"]`
        pub const ABDAY: &[&str] = &["sun", "mán", "þri", "mið", "fim", "fös", "lau"];
        /// `&["jan", "feb", "mar", "apr", "maí", "jún", "júl", "ágú", "sep", "okt", "nóv", "des"]`
        pub const ABMON: &[&str] = &["jan", "feb", "mar", "apr", "maí", "jún", "júl", "ágú", "sep", "okt", "nóv", "des"];
        /// `&["fh", "eh"]`
        pub const AM_PM: &[&str] = &["fh", "eh"];
        /// `"%a %e.%b %Y"`
        pub const D_FMT: &str = "%a %e.%b %Y";
        /// `"%a %e.%b %Y, %T %Z"`
        pub const D_T_FMT: &str = "%a %e.%b %Y, %T %Z";
        /// `&["sunnudagur", "mánudagur", "þriðjudagur", "miðvikudagur", "fimmtudagur", "föstudagur", "laugardagur"]`
        pub const DAY: &[&str] = &["sunnudagur", "mánudagur", "þriðjudagur", "miðvikudagur", "fimmtudagur", "föstudagur", "laugardagur"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["janúar", "febrúar", "mars", "apríl", "maí", "júní", "júlí", "ágúst", "september", "október", "nóvember", "desember"]`
        pub const MON: &[&str] = &["janúar", "febrúar", "mars", "apríl", "maí", "júní", "júlí", "ágúst", "september", "október", "nóvember", "desember"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod it_CH {
    pub mod LC_ADDRESS {
        /// `"CH"`
        pub const COUNTRY_ABTWO: &str = "CH";
        /// `"CHE"`
        pub const COUNTRY_AB3: &str = "CHE";
        /// `"CH"`
        pub const COUNTRY_CAR: &str = "CH";
        /// `"Svizzera"`
        pub const COUNTRY_NAME: &str = "Svizzera";
        /// `756`
        pub const COUNTRY_NUM: i64 = 756;
        /// `"it"`
        pub const LANG_AB: &str = "it";
        /// `"ita"`
        pub const LANG_LIB: &str = "ita";
        /// `"italiano"`
        pub const LANG_NAME: &str = "italiano";
        /// `"ita"`
        pub const LANG_TERM: &str = "ita";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Italian"`
        pub const LANGUAGE: &str = "Italian";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"Switzerland"`
        pub const TERRITORY: &str = "Switzerland";
        /// `"Italian locale for Switzerland"`
        pub const TITLE: &str = "Italian locale for Switzerland";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"no"`
        pub const NOSTR: &str = "no";
        /// `"^[+1sSjJoOyY]"`
        pub const YESEXPR: &str = "^[+1sSjJoOyY]";
        /// `"sì"`
        pub const YESSTR: &str = "sì";
    }
    pub use super::de_CH::LC_MONETARY;
    pub use super::de_CH::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `"41"`
        pub const INT_PREFIX: &str = "41";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mer", "gio", "ven", "sab"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mer", "gio", "ven", "sab"];
        /// `&["gen", "feb", "mar", "apr", "mag", "giu", "lug", "ago", "set", "ott", "nov", "dic"]`
        pub const ABMON: &[&str] = &["gen", "feb", "mar", "apr", "mag", "giu", "lug", "ago", "set", "ott", "nov", "dic"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %-d %b %Y, %T"`
        pub const D_T_FMT: &str = "%a %-d %b %Y, %T";
        /// `"%a %-d %b %Y, %T, %Z"`
        pub const DATE_FMT: &str = "%a %-d %b %Y, %T, %Z";
        /// `&["domenica", "lunedì", "martedì", "mercoledì", "giovedì", "venerdì", "sabato"]`
        pub const DAY: &[&str] = &["domenica", "lunedì", "martedì", "mercoledì", "giovedì", "venerdì", "sabato"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["gennaio", "febbraio", "marzo", "aprile", "maggio", "giugno", "luglio", "agosto", "settembre", "ottobre", "novembre", "dicembre"]`
        pub const MON: &[&str] = &["gennaio", "febbraio", "marzo", "aprile", "maggio", "giugno", "luglio", "agosto", "settembre", "ottobre", "novembre", "dicembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod it_IT {
    pub mod LC_ADDRESS {
        /// `"IT"`
        pub const COUNTRY_ABTWO: &str = "IT";
        /// `"ITA"`
        pub const COUNTRY_AB3: &str = "ITA";
        /// `"I"`
        pub const COUNTRY_CAR: &str = "I";
        /// `"978-88,979-12"`
        pub const COUNTRY_ISBN: &str = "978-88,979-12";
        /// `"Italia"`
        pub const COUNTRY_NAME: &str = "Italia";
        /// `380`
        pub const COUNTRY_NUM: i64 = 380;
        /// `"it"`
        pub const LANG_AB: &str = "it";
        /// `"ita"`
        pub const LANG_LIB: &str = "ita";
        /// `"italiano"`
        pub const LANG_NAME: &str = "italiano";
        /// `"ita"`
        pub const LANG_TERM: &str = "ita";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Sankt Jørgens Alle 8, DK-1615 København V, Danmark"`
        pub const ADDRESS: &str = "Sankt Jørgens Alle 8, DK-1615 København V, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Italian"`
        pub const LANGUAGE: &str = "Italian";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"RAP"`
        pub const SOURCE: &str = "RAP";
        /// `""`
        pub const TEL: &str = "";
        /// `"Italy"`
        pub const TERRITORY: &str = "Italy";
        /// `"Italian locale for Italy"`
        pub const TITLE: &str = "Italian locale for Italy";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"no"`
        pub const NOSTR: &str = "no";
        /// `"^[+1sSyY]"`
        pub const YESEXPR: &str = "^[+1sSyY]";
        /// `"sì"`
        pub const YESSTR: &str = "sì";
    }
    pub mod LC_MONETARY {
        /// `"€"`
        pub const CURRENCY_SYMBOL: &str = "€";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"EUR "`
        pub const INT_CURR_SYMBOL: &str = "EUR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `"39"`
        pub const INT_PREFIX: &str = "39";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["dom", "lun", "mar", "mer", "gio", "ven", "sab"]`
        pub const ABDAY: &[&str] = &["dom", "lun", "mar", "mer", "gio", "ven", "sab"];
        /// `&["gen", "feb", "mar", "apr", "mag", "giu", "lug", "ago", "set", "ott", "nov", "dic"]`
        pub const ABMON: &[&str] = &["gen", "feb", "mar", "apr", "mag", "giu", "lug", "ago", "set", "ott", "nov", "dic"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%a %-d %b %Y, %T"`
        pub const D_T_FMT: &str = "%a %-d %b %Y, %T";
        /// `"%a %-d %b %Y, %T, %Z"`
        pub const DATE_FMT: &str = "%a %-d %b %Y, %T, %Z";
        /// `&["domenica", "lunedì", "martedì", "mercoledì", "giovedì", "venerdì", "sabato"]`
        pub const DAY: &[&str] = &["domenica", "lunedì", "martedì", "mercoledì", "giovedì", "venerdì", "sabato"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["gennaio", "febbraio", "marzo", "aprile", "maggio", "giugno", "luglio", "agosto", "settembre", "ottobre", "novembre", "dicembre"]`
        pub const MON: &[&str] = &["gennaio", "febbraio", "marzo", "aprile", "maggio", "giugno", "luglio", "agosto", "settembre", "ottobre", "novembre", "dicembre"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 4]`
        pub const WEEK: &[i64] = &[7, 19971130, 4];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod it_IT_euro {
    pub use super::it_IT::LC_ADDRESS;
    pub mod LC_IDENTIFICATION {
        /// `"https://www.gnu.org/software/libc/"`
        pub const ADDRESS: &str = "https://www.gnu.org/software/libc/";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-08-20"`
        pub const DATE: &str = "2000-08-20";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Italian"`
        pub const LANGUAGE: &str = "Italian";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Free Software Foundation, Inc."`
        pub const SOURCE: &str = "Free Software Foundation, Inc.";
        /// `""`
        pub const TEL: &str = "";
        /// `"Italy"`
        pub const TERRITORY: &str = "Italy";
        /// `"Italian locale for Italy with Euro"`
        pub const TITLE: &str = "Italian locale for Italy with Euro";
    }
    pub use super::it_IT::LC_MESSAGES;
    pub use super::it_IT::LC_MONETARY;
    pub use super::it_IT::LC_NUMERIC;
    pub use super::it_IT::LC_TELEPHONE;
    pub use super::it_IT::LC_TIME;
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod iu_CA {
    pub mod LC_ADDRESS {
        /// `"CA"`
        pub const COUNTRY_ABTWO: &str = "CA";
        /// `"CAN"`
        pub const COUNTRY_AB3: &str = "CAN";
        /// `"CDN"`
        pub const COUNTRY_CAR: &str = "CDN";
        /// `"ᑲᓇᑕ"`
        pub const COUNTRY_NAME: &str = "ᑲᓇᑕ";
        /// `124`
        pub const COUNTRY_NUM: i64 = 124;
        /// `"CA"`
        pub const COUNTRY_POST: &str = "CA";
        /// `"iu"`
        pub const LANG_AB: &str = "iu";
        /// `"iku"`
        pub const LANG_LIB: &str = "iku";
        /// `"ᐃᓄᒃᑎᑐᑦ"`
        pub const LANG_NAME: &str = "ᐃᓄᒃᑎᑐᑦ";
        /// `"iku"`
        pub const LANG_TERM: &str = "iku";
        /// `"%a%N%f%N%d%N%b%N%h %s %e %r%N%T %z%N%c%N"`
        pub const POSTAL_FMT: &str = "%a%N%f%N%d%N%b%N%h %s %e %r%N%T %z%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_ADDRESS"],
        ];
        /// `"Pablo Saratxaga"`
        pub const CONTACT: &str = "Pablo Saratxaga";
        /// `"2001-05-04"`
        pub const DATE: &str = "2001-05-04";
        /// `"pablo@mandriva.com"`
        pub const EMAIL: &str = "pablo@mandriva.com";
        /// `""`
        pub const FAX: &str = "";
        /// `"Inuktitut"`
        pub const LANGUAGE: &str = "Inuktitut";
        /// `"0.1"`
        pub const REVISION: &str = "0.1";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"Canada"`
        pub const TERRITORY: &str = "Canada";
        /// `"Inuktitut language locale for Nunavut, Canada"`
        pub const TITLE: &str = "Inuktitut language locale for Nunavut, Canada";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nN]"`
        pub const NOEXPR: &str = "^[-0nN]";
        /// `"^[+1yYsS]"`
        pub const YESEXPR: &str = "^[+1yYsS]";
    }
    pub use super::en_CA::LC_MONETARY;
    pub use super::en_CA::LC_NUMERIC;
    pub use super::en_CA::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["ᓈ", "ᓇ", "ᓕ", "ᐱ", "ᕿ", "ᐅ", "ᓯ"]`
        pub const ABDAY: &[&str] = &["ᓈ", "ᓇ", "ᓕ", "ᐱ", "ᕿ", "ᐅ", "ᓯ"];
        /// `&["ᔮᓄ", "ᕕᕗ", "ᒪᔅ", "ᐃᐳ", "ᒪᐃ", "ᔪᓂ", "ᔪᓚ", "ᐊᒋ", "ᓯᑎ", "ᐊᑦ", "ᓄᕕ", "ᑎᓯ"]`
        pub const ABMON: &[&str] = &["ᔮᓄ", "ᕕᕗ", "ᒪᔅ", "ᐃᐳ", "ᒪᐃ", "ᔪᓂ", "ᔪᓚ", "ᐊᒋ", "ᓯᑎ", "ᐊᑦ", "ᓄᕕ", "ᑎᓯ"];
        /// `&["AM", "PM"]`
        pub const AM_PM: &[&str] = &["AM", "PM"];
        /// `"%m/%d/%y"`
        pub const D_FMT: &str = "%m/%d/%y";
        /// `"%a %d %b %Y %r %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %r %Z";
        /// `&["ᓈᑦᑎᖑᔭᕐᕕᒃ", "ᓇᒡᒐᔾᔭᐅ", "ᓇᒡᒐᔾᔭᐅᓕᖅᑭᑦ", "ᐱᖓᓲᓕᖅᓯᐅᑦ", "ᕿᑎᖅᑰᑦ", "ᐅᓪᓗᕈᓘᑐᐃᓇᖅ", "ᓯᕙᑖᕕᒃ"]`
        pub const DAY: &[&str] = &["ᓈᑦᑎᖑᔭᕐᕕᒃ", "ᓇᒡᒐᔾᔭᐅ", "ᓇᒡᒐᔾᔭᐅᓕᖅᑭᑦ", "ᐱᖓᓲᓕᖅᓯᐅᑦ", "ᕿᑎᖅᑰᑦ", "ᐅᓪᓗᕈᓘᑐᐃᓇᖅ", "ᓯᕙᑖᕕᒃ"];
        /// `&["ᔮᓄᐊᓕ", "ᕕᕗᐊᓕ", "ᒪᔅᓯ", "ᐃᐳᓗ", "ᒪᐃ", "ᔪᓂ", "ᔪᓚᐃ", "ᐊᒋᓯ", "ᓯᑎᕙ", "ᐊᑦᑐᕙ", "ᓄᕕᕙ", "ᑎᓯᕝᕙ"]`
        pub const MON: &[&str] = &["ᔮᓄᐊᓕ", "ᕕᕗᐊᓕ", "ᒪᔅᓯ", "ᐃᐳᓗ", "ᒪᐃ", "ᔪᓂ", "ᔪᓚᐃ", "ᐊᒋᓯ", "ᓯᑎᕙ", "ᐊᑦᑐᕙ", "ᓄᕕᕙ", "ᑎᓯᕝᕙ"];
        /// `"%r"`
        pub const T_FMT: &str = "%r";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ja_JP {
    pub mod LC_ADDRESS {
        /// `"JP"`
        pub const COUNTRY_ABTWO: &str = "JP";
        /// `"JPN"`
        pub const COUNTRY_AB3: &str = "JPN";
        /// `"J"`
        pub const COUNTRY_CAR: &str = "J";
        /// `"日本"`
        pub const COUNTRY_NAME: &str = "日本";
        /// `392`
        pub const COUNTRY_NUM: i64 = 392;
        /// `"ja"`
        pub const LANG_AB: &str = "ja";
        /// `"jpn"`
        pub const LANG_LIB: &str = "jpn";
        /// `"日本語"`
        pub const LANG_NAME: &str = "日本語";
        /// `"jpn"`
        pub const LANG_TERM: &str = "jpn";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-07-20"`
        pub const DATE: &str = "2000-07-20";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Japanese"`
        pub const LANGUAGE: &str = "Japanese";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"HANATAKA, Shinya, hanataka@abyss.rim.or.jp"`
        pub const SOURCE: &str = "HANATAKA, Shinya, hanataka@abyss.rim.or.jp";
        /// `""`
        pub const TEL: &str = "";
        /// `"Japan"`
        pub const TERRITORY: &str = "Japan";
        /// `"Japanese language locale for Japan"`
        pub const TITLE: &str = "Japanese language locale for Japan";
    }
    pub mod LC_MESSAGES {
        /// `"^([-0nNｎＮ]|いいえ|イイエ)"`
        pub const NOEXPR: &str = "^([-0nNｎＮ]|いいえ|イイエ)";
        /// `"いいえ"`
        pub const NOSTR: &str = "いいえ";
        /// `"^([+1yYｙＹ]|はい|ハイ)"`
        pub const YESEXPR: &str = "^([+1yYｙＹ]|はい|ハイ)";
        /// `"はい"`
        pub const YESSTR: &str = "はい";
    }
    pub mod LC_MONETARY {
        /// `"￥"`
        pub const CURRENCY_SYMBOL: &str = "￥";
        /// `0`
        pub const FRAC_DIGITS: i64 = 0;
        /// `"JPY "`
        pub const INT_CURR_SYMBOL: &str = "JPY ";
        /// `0`
        pub const INT_FRAC_DIGITS: i64 = 0;
        /// `2`
        pub const INT_N_SEP_BY_SPACE: i64 = 2;
        /// `2`
        pub const INT_P_SEP_BY_SPACE: i64 = 2;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `4`
        pub const N_SIGN_POSN: i64 = 4;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `4`
        pub const P_SIGN_POSN: i64 = 4;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"81"`
        pub const INT_PREFIX: &str = "81";
        /// `"010"`
        pub const INT_SELECT: &str = "010";
        /// `"+%c ;%a \n;%l"`
        pub const TEL_INT_FMT: &str = "+%c ;%a \n;%l";
    }
    pub mod LC_TIME {
        /// `&["日", "月", "火", "水", "木", "金", "土"]`
        pub const ABDAY: &[&str] = &["日", "月", "火", "水", "木", "金", "土"];
        /// `&[" 1月", " 2月", " 3月", " 4月", " 5月", " 6月", " 7月", " 8月", " 9月", "10月", "11月", "12月"]`
        pub const ABMON: &[&str] = &[" 1月", " 2月", " 3月", " 4月", " 5月", " 6月", " 7月", " 8月", " 9月", "10月", "11月", "12月"];
        /// `&["〇", "一", "二", "三", "四", "五", "六", "七", "八", "九", "十", "十一", "十二", "十三", "十四", "十五", "十六", "十七", "十八", "十九", "二十", "二十一", "二十二", "二十三", "二十四", "二十五", "二十六", "二十七", "二十八", "二十九", "三十", "三十一", "三十二", "三十三", "三十四", "三十五", "三十六", "三十七", "三十八", "三十九", "四十", "四十一", "四十二", "四十三", "四十四", "四十五", "四十六", "四十七", "四十八", "四十九", "五十", "五十一", "五十二", "五十三", "五十四", "五十五", "五十六", "五十七", "五十八", "五十九", "六十", "六十一", "六十二", "六十三", "六十四", "六十五", "六十六", "六十七", "六十八", "六十九", "七十", "七十一", "七十二", "七十三", "七十四", "七十五", "七十六", "七十七", "七十八", "七十九", "八十", "八十一", "八十二", "八十三", "八十四", "八十五", "八十六", "八十七", "八十八", "八十九", "九十", "九十一", "九十二", "九十三", "九十四", "九十五", "九十六", "九十七", "九十八", "九十九"]`
        pub const ALT_DIGITS: &[&str] = &["〇", "一", "二", "三", "四", "五", "六", "七", "八", "九", "十", "十一", "十二", "十三", "十四", "十五", "十六", "十七", "十八", "十九", "二十", "二十一", "二十二", "二十三", "二十四", "二十五", "二十六", "二十七", "二十八", "二十九", "三十", "三十一", "三十二", "三十三", "三十四", "三十五", "三十六", "三十七", "三十八", "三十九", "四十", "四十一", "四十二", "四十三", "四十四", "四十五", "四十六", "四十七", "四十八", "四十九", "五十", "五十一", "五十二", "五十三", "五十四", "五十五", "五十六", "五十七", "五十八", "五十九", "六十", "六十一", "六十二", "六十三", "六十四", "六十五", "六十六", "六十七", "六十八", "六十九", "七十", "七十一", "七十二", "七十三", "七十四", "七十五", "七十六", "七十七", "七十八", "七十九", "八十", "八十一", "八十二", "八十三", "八十四", "八十五", "八十六", "八十七", "八十八", "八十九", "九十", "九十一", "九十二", "九十三", "九十四", "九十五", "九十六", "九十七", "九十八", "九十九"];
        /// `&["午前", "午後"]`
        pub const AM_PM: &[&str] = &["午前", "午後"];
        /// `"%Y年%m月%d日"`
        pub const D_FMT: &str = "%Y年%m月%d日";
        /// `"%Y年%m月%d日 %H時%M分%S秒"`
        pub const D_T_FMT: &str = "%Y年%m月%d日 %H時%M分%S秒";
        /// `"%Y年 %b %e日 %A %H:%M:%S %Z"`
        pub const DATE_FMT: &str = "%Y年 %b %e日 %A %H:%M:%S %Z";
        /// `&["日曜日", "月曜日", "火曜日", "水曜日", "木曜日", "金曜日", "土曜日"]`
        pub const DAY: &[&str] = &["日曜日", "月曜日", "火曜日", "水曜日", "木曜日", "金曜日", "土曜日"];
        /// `&["+:2:2020/01/01:+*:令和:%EC%Ey年", "+:1:2019/05/01:2019/12/31:令和:%EC元年", "+:2:1990/01/01:2019/04/30:平成:%EC%Ey年", "+:1:1989/01/08:1989/12/31:平成:%EC元年", "+:2:1927/01/01:1989/01/07:昭和:%EC%Ey年", "+:1:1926/12/25:1926/12/31:昭和:%EC元年", "+:2:1913/01/01:1926/12/24:大正:%EC%Ey年", "+:1:1912/07/30:1912/12/31:大正:%EC元年", "+:6:1873/01/01:1912/07/29:明治:%EC%Ey年", "+:1:0001/01/01:1872/12/31:西暦:%EC%Ey年", "+:1:-0001/12/31:-*:紀元前:%EC%Ey年"]`
        pub const ERA: &[&str] = &["+:2:2020/01/01:+*:令和:%EC%Ey年", "+:1:2019/05/01:2019/12/31:令和:%EC元年", "+:2:1990/01/01:2019/04/30:平成:%EC%Ey年", "+:1:1989/01/08:1989/12/31:平成:%EC元年", "+:2:1927/01/01:1989/01/07:昭和:%EC%Ey年", "+:1:1926/12/25:1926/12/31:昭和:%EC元年", "+:2:1913/01/01:1926/12/24:大正:%EC%Ey年", "+:1:1912/07/30:1912/12/31:大正:%EC元年", "+:6:1873/01/01:1912/07/29:明治:%EC%Ey年", "+:1:0001/01/01:1872/12/31:西暦:%EC%Ey年", "+:1:-0001/12/31:-*:紀元前:%EC%Ey年"];
        /// `"%EY%m月%d日"`
        pub const ERA_D_FMT: &str = "%EY%m月%d日";
        /// `"%EY%m月%d日 %H時%M分%S秒"`
        pub const ERA_D_T_FMT: &str = "%EY%m月%d日 %H時%M分%S秒";
        /// `&["1月", "2月", "3月", "4月", "5月", "6月", "7月", "8月", "9月", "10月", "11月", "12月"]`
        pub const MON: &[&str] = &["1月", "2月", "3月", "4月", "5月", "6月", "7月", "8月", "9月", "10月", "11月", "12月"];
        /// `"%H時%M分%S秒"`
        pub const T_FMT: &str = "%H時%M分%S秒";
        /// `"%p%I時%M分%S秒"`
        pub const T_FMT_AMPM: &str = "%p%I時%M分%S秒";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ka_GE {
    pub mod LC_ADDRESS {
        /// `"GE"`
        pub const COUNTRY_ABTWO: &str = "GE";
        /// `"GEO"`
        pub const COUNTRY_AB3: &str = "GEO";
        /// `"GE"`
        pub const COUNTRY_CAR: &str = "GE";
        /// `"99928"`
        pub const COUNTRY_ISBN: &str = "99928";
        /// `"საქართველო"`
        pub const COUNTRY_NAME: &str = "საქართველო";
        /// `268`
        pub const COUNTRY_NUM: i64 = 268;
        /// `"ka"`
        pub const LANG_AB: &str = "ka";
        /// `"geo"`
        pub const LANG_LIB: &str = "geo";
        /// `"ქართული"`
        pub const LANG_NAME: &str = "ქართული";
        /// `"kat"`
        pub const LANG_TERM: &str = "kat";
        /// `"%d%N%f%N%d%N%b%N%s %h 5e %r%N%C%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%d%N%f%N%d%N%b%N%s %h 5e %r%N%C%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_MONETARY"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_MONETARY"],
        ];
        /// `"Pablo Saratxaga"`
        pub const CONTACT: &str = "Pablo Saratxaga";
        /// `"2001-01-26"`
        pub const DATE: &str = "2001-01-26";
        /// `"srtxg@chanae.alphanet.ch"`
        pub const EMAIL: &str = "srtxg@chanae.alphanet.ch";
        /// `""`
        pub const FAX: &str = "";
        /// `"Georgian"`
        pub const LANGUAGE: &str = "Georgian";
        /// `"0.6"`
        pub const REVISION: &str = "0.6";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"Georgia"`
        pub const TERRITORY: &str = "Georgia";
        /// `"Georgian language locale for Georgia"`
        pub const TITLE: &str = "Georgian language locale for Georgia";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNaAა]"`
        pub const NOEXPR: &str = "^[-0nNaAა]";
        /// `"არა"`
        pub const NOSTR: &str = "არა";
        /// `"^[+1yYkKxXკ]"`
        pub const YESEXPR: &str = "^[+1yYkKxXკ]";
        /// `"კი"`
        pub const YESSTR: &str = "კი";
    }
    pub mod LC_MONETARY {
        /// `"₾"`
        pub const CURRENCY_SYMBOL: &str = "₾";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"GEL "`
        pub const INT_CURR_SYMBOL: &str = "GEL ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const MON_THOUSANDS_SEP: &str = ".";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"."`
        pub const THOUSANDS_SEP: &str = ".";
    }
    pub mod LC_TELEPHONE {
        /// `"995"`
        pub const INT_PREFIX: &str = "995";
        /// `"8~10"`
        pub const INT_SELECT: &str = "8~10";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["კვი", "ორშ", "სამ", "ოთხ", "ხუთ", "პარ", "შაბ"]`
        pub const ABDAY: &[&str] = &["კვი", "ორშ", "სამ", "ოთხ", "ხუთ", "პარ", "შაბ"];
        /// `&["იან", "თებ", "მარ", "აპრ", "მაი", "ივნ", "ივლ", "აგვ", "სექ", "ოქტ", "ნოე", "დეკ"]`
        pub const ABMON: &[&str] = &["იან", "თებ", "მარ", "აპრ", "მაი", "ივნ", "ივლ", "აგვ", "სექ", "ოქტ", "ნოე", "დეკ"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%m/%d/%Y"`
        pub const D_FMT: &str = "%m/%d/%Y";
        /// `"%Y წლის %d %B, %T %Z"`
        pub const D_T_FMT: &str = "%Y წლის %d %B, %T %Z";
        /// `&["კვირა", "ორშაბათი", "სამშაბათი", "ოთხშაბათი", "ხუთშაბათი", "პარასკევი", "შაბათი"]`
        pub const DAY: &[&str] = &["კვირა", "ორშაბათი", "სამშაბათი", "ოთხშაბათი", "ხუთშაბათი", "პარასკევი", "შაბათი"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["იანვარი", "თებერვალი", "მარტი", "აპრილი", "მაისი", "ივნისი", "ივლისი", "აგვისტო", "სექტემბერი", "ოქტომბერი", "ნოემბერი", "დეკემბერი"]`
        pub const MON: &[&str] = &["იანვარი", "თებერვალი", "მარტი", "აპრილი", "მაისი", "ივნისი", "ივლისი", "აგვისტო", "სექტემბერი", "ოქტომბერი", "ნოემბერი", "დეკემბერი"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod kab_DZ {
    pub mod LC_ADDRESS {
        /// `"DZ"`
        pub const COUNTRY_ABTWO: &str = "DZ";
        /// `"DZA"`
        pub const COUNTRY_AB3: &str = "DZA";
        /// `"DZ"`
        pub const COUNTRY_CAR: &str = "DZ";
        /// `"Lezzayer"`
        pub const COUNTRY_NAME: &str = "Lezzayer";
        /// `12`
        pub const COUNTRY_NUM: i64 = 12;
        /// `"kab"`
        pub const LANG_LIB: &str = "kab";
        /// `"Taqbaylit"`
        pub const LANG_NAME: &str = "Taqbaylit";
        /// `"kab"`
        pub const LANG_TERM: &str = "kab";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2016-07-06"`
        pub const DATE: &str = "2016-07-06";
        /// `"belkacem77@gmail.com"`
        pub const EMAIL: &str = "belkacem77@gmail.com";
        /// `"Kabyle"`
        pub const LANGUAGE: &str = "Kabyle";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `""`
        pub const SOURCE: &str = "";
        /// `"Algeria"`
        pub const TERRITORY: &str = "Algeria";
        /// `"Kabyle language locale for Algeria"`
        pub const TITLE: &str = "Kabyle language locale for Algeria";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNuUaA]"`
        pub const NOEXPR: &str = "^[-0nNuUaA]";
        /// `"Uhu"`
        pub const NOSTR: &str = "Uhu";
        /// `"^[+1yYiI]"`
        pub const YESEXPR: &str = "^[+1yYiI]";
        /// `"Ih"`
        pub const YESSTR: &str = "Ih";
    }
    pub mod LC_MONETARY {
        /// `"DA"`
        pub const CURRENCY_SYMBOL: &str = "DA";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"DZD "`
        pub const INT_CURR_SYMBOL: &str = "DZD ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `3`
        pub const MON_GROUPING: i64 = 3;
        /// `""`
        pub const MON_THOUSANDS_SEP: &str = "";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const P_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `""`
        pub const THOUSANDS_SEP: &str = "";
    }
    pub use super::ar_DZ::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["Ace", "Ari", "Ara", "Aha", "Amh", "Sem", "Sed"]`
        pub const ABDAY: &[&str] = &["Ace", "Ari", "Ara", "Aha", "Amh", "Sem", "Sed"];
        /// `&["Yen", "Fur", "Meɣ", "Yeb", "May", "Yun", "Yul", "ɣuc", "Cte", "Tub", "Wam", "Duj"]`
        pub const ABMON: &[&str] = &["Yen", "Fur", "Meɣ", "Yeb", "May", "Yun", "Yul", "ɣuc", "Cte", "Tub", "Wam", "Duj"];
        /// `&["FT", "MD"]`
        pub const AM_PM: &[&str] = &["FT", "MD"];
        /// `"%d/%m/%Y"`
        pub const D_FMT: &str = "%d/%m/%Y";
        /// `"%a %d %b %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T %Z";
        /// `&["Acer", "Arim", "Aram", "Ahad", "Amhad", "Sem", "Sed"]`
        pub const DAY: &[&str] = &["Acer", "Arim", "Aram", "Ahad", "Amhad", "Sem", "Sed"];
        /// `7`
        pub const FIRST_WEEKDAY: i64 = 7;
        /// `1`
        pub const FIRST_WORKDAY: i64 = 1;
        /// `&["Yennayer", "Fuṛar", "Meɣres", "Yebrir", "Mayyu", "Yunyu", "Yulyu", "ɣuct", "Ctembeṛ", "Tubeṛ", "Wambeṛ", "Dujembeṛ"]`
        pub const MON: &[&str] = &["Yennayer", "Fuṛar", "Meɣres", "Yebrir", "Mayyu", "Yunyu", "Yulyu", "ɣuct", "Ctembeṛ", "Tubeṛ", "Wambeṛ", "Dujembeṛ"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `"%I:%M:%S %p"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod kk_KZ {
    pub mod LC_ADDRESS {
        /// `"KZ"`
        pub const COUNTRY_ABTWO: &str = "KZ";
        /// `"KAZ"`
        pub const COUNTRY_AB3: &str = "KAZ";
        /// `"KZ"`
        pub const COUNTRY_CAR: &str = "KZ";
        /// `"978-601"`
        pub const COUNTRY_ISBN: &str = "978-601";
        /// `"Қазақстан"`
        pub const COUNTRY_NAME: &str = "Қазақстан";
        /// `398`
        pub const COUNTRY_NUM: i64 = 398;
        /// `"KAZ"`
        pub const COUNTRY_POST: &str = "KAZ";
        /// `"kk"`
        pub const LANG_AB: &str = "kk";
        /// `"kaz"`
        pub const LANG_LIB: &str = "kaz";
        /// `"қазақ тілі"`
        pub const LANG_NAME: &str = "қазақ тілі";
        /// `"kaz"`
        pub const LANG_TERM: &str = "kaz";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `"Timur Birsh"`
        pub const CONTACT: &str = "Timur Birsh";
        /// `"2016-03-22"`
        pub const DATE: &str = "2016-03-22";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Kazakh"`
        pub const LANGUAGE: &str = "Kazakh";
        /// `"1.1"`
        pub const REVISION: &str = "1.1";
        /// `"linukz.org"`
        pub const SOURCE: &str = "linukz.org";
        /// `""`
        pub const TEL: &str = "";
        /// `"Kazakhstan"`
        pub const TERRITORY: &str = "Kazakhstan";
        /// `"Kazakh locale for Kazakhstan"`
        pub const TITLE: &str = "Kazakh locale for Kazakhstan";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNЖжN]"`
        pub const NOEXPR: &str = "^[-0nNЖжN]";
        /// `"жоқ"`
        pub const NOSTR: &str = "жоқ";
        /// `"^[+1yYИи]"`
        pub const YESEXPR: &str = "^[+1yYИи]";
        /// `"иә"`
        pub const YESSTR: &str = "иә";
    }
    pub mod LC_MONETARY {
        /// `"₸"`
        pub const CURRENCY_SYMBOL: &str = "₸";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"KZT "`
        pub const INT_CURR_SYMBOL: &str = "KZT ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `1`
        pub const INT_N_CS_PRECEDES: i64 = 1;
        /// `1`
        pub const INT_N_SEP_BY_SPACE: i64 = 1;
        /// `4`
        pub const INT_N_SIGN_POSN: i64 = 4;
        /// `1`
        pub const INT_P_CS_PRECEDES: i64 = 1;
        /// `2`
        pub const INT_P_SEP_BY_SPACE: i64 = 2;
        /// `4`
        pub const INT_P_SIGN_POSN: i64 = 4;
        /// `","`
        pub const MON_DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const MON_THOUSANDS_SEP: &str = "\u{202f}";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `1`
        pub const N_SEP_BY_SPACE: i64 = 1;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `2`
        pub const P_SEP_BY_SPACE: i64 = 2;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `","`
        pub const DECIMAL_POINT: &str = ",";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `"\u{202f}"`
        pub const THOUSANDS_SEP: &str = "\u{202f}";
    }
    pub mod LC_TELEPHONE {
        /// `"7"`
        pub const INT_PREFIX: &str = "7";
        /// `"8~10"`
        pub const INT_SELECT: &str = "8~10";
        /// `"(%A) %l"`
        pub const TEL_DOM_FMT: &str = "(%A) %l";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["Жк", "Дс", "Сс", "Ср", "Бс", "Жм", "Сб"]`
        pub const ABDAY: &[&str] = &["Жк", "Дс", "Сс", "Ср", "Бс", "Жм", "Сб"];
        /// `&["Қаң", "Ақп", "Нау", "Сәу", "Мам", "Мау", "Шіл", "Там", "Қыр", "Қаз", "Қар", "Жел"]`
        pub const ABMON: &[&str] = &["Қаң", "Ақп", "Нау", "Сәу", "Мам", "Мау", "Шіл", "Там", "Қыр", "Қаз", "Қар", "Жел"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%d.%m.%Y"`
        pub const D_FMT: &str = "%d.%m.%Y";
        /// `"%a %d %b %Y %T"`
        pub const D_T_FMT: &str = "%a %d %b %Y %T";
        /// `&["Жексенбі", "Дүйсенбі", "Сейсенбі", "Сәрсенбі", "Бейсенбі", "Жұма", "Сенбі"]`
        pub const DAY: &[&str] = &["Жексенбі", "Дүйсенбі", "Сейсенбі", "Сәрсенбі", "Бейсенбі", "Жұма", "Сенбі"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["Қаңтар", "Ақпан", "Наурыз", "Сәуір", "Мамыр", "Маусым", "Шілде", "Тамыз", "Қыркүйек", "Қазан", "Қараша", "Желтоқсан"]`
        pub const MON: &[&str] = &["Қаңтар", "Ақпан", "Наурыз", "Сәуір", "Мамыр", "Маусым", "Шілде", "Тамыз", "Қыркүйек", "Қазан", "Қараша", "Желтоқсан"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod kl_GL {
    pub mod LC_ADDRESS {
        /// `"GL"`
        pub const COUNTRY_ABTWO: &str = "GL";
        /// `"GRL"`
        pub const COUNTRY_AB3: &str = "GRL";
        /// `"KN"`
        pub const COUNTRY_CAR: &str = "KN";
        /// `"Kalaallit Nunaat"`
        pub const COUNTRY_NAME: &str = "Kalaallit Nunaat";
        /// `304`
        pub const COUNTRY_NUM: i64 = 304;
        /// `"kl"`
        pub const LANG_AB: &str = "kl";
        /// `"kal"`
        pub const LANG_LIB: &str = "kal";
        /// `"kalaallisut"`
        pub const LANG_NAME: &str = "kalaallisut";
        /// `"kal"`
        pub const LANG_TERM: &str = "kal";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Kollegievej 6, DK-2920 Charlottenlund, Danmark"`
        pub const ADDRESS: &str = "Kollegievej 6, DK-2920 Charlottenlund, Danmark";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-06-29"`
        pub const DATE: &str = "2000-06-29";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Kalaallisut"`
        pub const LANGUAGE: &str = "Kalaallisut";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Danish Standards Association"`
        pub const SOURCE: &str = "Danish Standards Association";
        /// `""`
        pub const TEL: &str = "";
        /// `"Greenland"`
        pub const TERRITORY: &str = "Greenland";
        /// `"Greenlandic locale for Greenland"`
        pub const TITLE: &str = "Greenlandic locale for Greenland";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0Nn]"`
        pub const NOEXPR: &str = "^[-0Nn]";
        /// `"naagga"`
        pub const NOSTR: &str = "naagga";
        /// `"^[+1JjYyAa]"`
        pub const YESEXPR: &str = "^[+1JjYyAa]";
        /// `"aap"`
        pub const YESSTR: &str = "aap";
    }
    pub use super::da_DK::LC_MONETARY;
    pub use super::da_DK::LC_NUMERIC;
    pub mod LC_TELEPHONE {
        /// `"299"`
        pub const INT_PREFIX: &str = "299";
        /// `"00"`
        pub const INT_SELECT: &str = "00";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["sap", "ata", "mar", "pin", "sis", "tal", "arf"]`
        pub const ABDAY: &[&str] = &["sap", "ata", "mar", "pin", "sis", "tal", "arf"];
        /// `&["jan", "feb", "mar", "apr", "maj", "jun", "jul", "aug", "sep", "okt", "nov", "dec"]`
        pub const ABMON: &[&str] = &["jan", "feb", "mar", "apr", "maj", "jun", "jul", "aug", "sep", "okt", "nov", "dec"];
        /// `&["januaari", "februaari", "marsi", "apriili", "maaji", "juuni", "juuli", "aggusti", "septembari", "oktobari", "novembari", "decembari"]`
        pub const ALT_MON: &[&str] = &["januaari", "februaari", "marsi", "apriili", "maaji", "juuni", "juuli", "aggusti", "septembari", "oktobari", "novembari", "decembari"];
        /// `&["", ""]`
        pub const AM_PM: &[&str] = &["", ""];
        /// `"%b %d %Y"`
        pub const D_FMT: &str = "%b %d %Y";
        /// `"%a %b %d %Y %T %Z"`
        pub const D_T_FMT: &str = "%a %b %d %Y %T %Z";
        /// `&["sapaat", "ataasinngorneq", "marlunngorneq", "pingasunngorneq", "sisamanngorneq", "tallimanngorneq", "arfininngorneq"]`
        pub const DAY: &[&str] = &["sapaat", "ataasinngorneq", "marlunngorneq", "pingasunngorneq", "sisamanngorneq", "tallimanngorneq", "arfininngorneq"];
        /// `2`
        pub const FIRST_WEEKDAY: i64 = 2;
        /// `&["januaarip", "februaarip", "marsip", "apriilip", "maajip", "juunip", "juulip", "aggustip", "septembarip", "oktobarip", "novembarip", "decembarip"]`
        pub const MON: &[&str] = &["januaarip", "februaarip", "marsip", "apriilip", "maajip", "juunip", "juulip", "aggustip", "septembarip", "oktobarip", "novembarip", "decembarip"];
        /// `"%T"`
        pub const T_FMT: &str = "%T";
        /// `""`
        pub const T_FMT_AMPM: &str = "";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod km_KH {
    pub mod LC_ADDRESS {
        /// `"KH"`
        pub const COUNTRY_ABTWO: &str = "KH";
        /// `"KHM"`
        pub const COUNTRY_AB3: &str = "KHM";
        /// `"KH"`
        pub const COUNTRY_CAR: &str = "KH";
        /// `"កម\u{17d2}ព\u{17bb}ជា"`
        pub const COUNTRY_NAME: &str = "កម\u{17d2}ព\u{17bb}ជា";
        /// `116`
        pub const COUNTRY_NUM: i64 = 116;
        /// `"km"`
        pub const LANG_AB: &str = "km";
        /// `"khm"`
        pub const LANG_LIB: &str = "khm";
        /// `"ខ\u{17d2}មែរ"`
        pub const LANG_NAME: &str = "ខ\u{17d2}មែរ";
        /// `"khm"`
        pub const LANG_TERM: &str = "khm";
        /// `"%f%N%a%N%d%N%r%t%e%t%b%N%h%t%s%N%T%N%S%N%z%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%r%t%e%t%b%N%h%t%s%N%T%N%S%N%z%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `"Jens Herden at: jens@khmeros.info"`
        pub const CONTACT: &str = "Jens Herden at: jens@khmeros.info";
        /// `"2005-3-15"`
        pub const DATE: &str = "2005-3-15";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Khmer"`
        pub const LANGUAGE: &str = "Khmer";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"Cambodia"`
        pub const TERRITORY: &str = "Cambodia";
        /// `"Khmer locale for Cambodia"`
        pub const TITLE: &str = "Khmer locale for Cambodia";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNទ]"`
        pub const NOEXPR: &str = "^[-0nNទ]";
        /// `"ទេ"`
        pub const NOSTR: &str = "ទេ";
        /// `"^[+1yYប]"`
        pub const YESEXPR: &str = "^[+1yYប]";
        /// `"បាទ/ចាស"`
        pub const YESSTR: &str = "បាទ/ចាស";
    }
    pub mod LC_MONETARY {
        /// `"៛"`
        pub const CURRENCY_SYMBOL: &str = "៛";
        /// `2`
        pub const FRAC_DIGITS: i64 = 2;
        /// `"KHR "`
        pub const INT_CURR_SYMBOL: &str = "KHR ";
        /// `2`
        pub const INT_FRAC_DIGITS: i64 = 2;
        /// `0`
        pub const INT_N_CS_PRECEDES: i64 = 0;
        /// `0`
        pub const INT_N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const INT_N_SIGN_POSN: i64 = 1;
        /// `0`
        pub const INT_P_CS_PRECEDES: i64 = 0;
        /// `0`
        pub const INT_P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const INT_P_SIGN_POSN: i64 = 1;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `0`
        pub const N_CS_PRECEDES: i64 = 0;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const N_SIGN_POSN: i64 = 1;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `0`
        pub const P_CS_PRECEDES: i64 = 0;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `3`
        pub const GROUPING: i64 = 3;
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"855"`
        pub const INT_PREFIX: &str = "855";
        /// `"001"`
        pub const INT_SELECT: &str = "001";
        /// `"(%A)%l"`
        pub const TEL_DOM_FMT: &str = "(%A)%l";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["អា", "ច", "អ", "ព\u{17bb}", "ព\u{17d2}រ", "ស\u{17bb}", "ស"]`
        pub const ABDAY: &[&str] = &["អា", "ច", "អ", "ព\u{17bb}", "ព\u{17d2}រ", "ស\u{17bb}", "ស"];
        /// `&["១", "២", "៣", "៤", "៥", "៦", "៧", "៨", "៩", "១០", "១១", "១២"]`
        pub const ABMON: &[&str] = &["១", "២", "៣", "៤", "៥", "៦", "៧", "៨", "៩", "១០", "១១", "១២"];
        /// `&["ព\u{17d2}រ\u{17b9}ក", "ល\u{17d2}ងាច"]`
        pub const AM_PM: &[&str] = &["ព\u{17d2}រ\u{17b9}ក", "ល\u{17d2}ងាច"];
        /// `"%e %B %Y"`
        pub const D_FMT: &str = "%e %B %Y";
        /// `"%A ថ\u{17d2}ងៃ %e ខែ %B ឆ\u{17d2}នា\u{17c6} %Y, %H ម\u{17c9}ោង m នាទ\u{17b8} %S វ\u{17b7}នាទ\u{17b8}\u{200b}"`
        pub const D_T_FMT: &str = "%A ថ\u{17d2}ងៃ %e ខែ %B ឆ\u{17d2}នា\u{17c6} %Y, %H ម\u{17c9}ោង m នាទ\u{17b8} %S វ\u{17b7}នាទ\u{17b8}\u{200b}";
        /// `&["ថ\u{17d2}ងៃ\u{200b}អាទ\u{17b7}ត\u{17d2}យ", "ថ\u{17d2}ងៃ\u{200b}ច\u{17d0}ន\u{17d2}ទ", "ថ\u{17d2}ងៃ\u{200b}អង\u{17d2}គារ", "ថ\u{17d2}ងៃ\u{200b}ព\u{17bb}ធ", "ថ\u{17d2}ងៃ\u{200b}ព\u{17d2}រហស\u{17d2}បត\u{17b7}\u{17cd}", "ថ\u{17d2}ងៃ\u{200b}ស\u{17bb}ក\u{17d2}រ", "ថ\u{17d2}ងៃ\u{200b}សៅរ\u{17cd}"]`
        pub const DAY: &[&str] = &["ថ\u{17d2}ងៃ\u{200b}អាទ\u{17b7}ត\u{17d2}យ", "ថ\u{17d2}ងៃ\u{200b}ច\u{17d0}ន\u{17d2}ទ", "ថ\u{17d2}ងៃ\u{200b}អង\u{17d2}គារ", "ថ\u{17d2}ងៃ\u{200b}ព\u{17bb}ធ", "ថ\u{17d2}ងៃ\u{200b}ព\u{17d2}រហស\u{17d2}បត\u{17b7}\u{17cd}", "ថ\u{17d2}ងៃ\u{200b}ស\u{17bb}ក\u{17d2}រ", "ថ\u{17d2}ងៃ\u{200b}សៅរ\u{17cd}"];
        /// `1`
        pub const FIRST_WEEKDAY: i64 = 1;
        /// `&["មករា", "ក\u{17bb}ម\u{17d2}ភៈ", "ម\u{17b8}នា", "មេសា", "ឧសភា", "ម\u{17b7}ថ\u{17bb}នា", "កក\u{17d2}កដា", "ស\u{17b8}ហា", "កញ\u{17d2}ញា", "ត\u{17bb}លា", "វ\u{17b7}ច\u{17d2}ឆ\u{17b7}កា", "ធ\u{17d2}ន\u{17bc}"]`
        pub const MON: &[&str] = &["មករា", "ក\u{17bb}ម\u{17d2}ភៈ", "ម\u{17b8}នា", "មេសា", "ឧសភា", "ម\u{17b7}ថ\u{17bb}នា", "កក\u{17d2}កដា", "ស\u{17b8}ហា", "កញ\u{17d2}ញា", "ត\u{17bb}លា", "វ\u{17b7}ច\u{17d2}ឆ\u{17b7}កា", "ធ\u{17d2}ន\u{17bc}"];
        /// `"%H:%M:%S"`
        pub const T_FMT: &str = "%H:%M:%S";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod kn_IN {
    pub mod LC_ADDRESS {
        /// `"IN"`
        pub const COUNTRY_ABTWO: &str = "IN";
        /// `"IND"`
        pub const COUNTRY_AB3: &str = "IND";
        /// `"IND"`
        pub const COUNTRY_CAR: &str = "IND";
        /// `"ಭಾರತ"`
        pub const COUNTRY_NAME: &str = "ಭಾರತ";
        /// `356`
        pub const COUNTRY_NUM: i64 = 356;
        /// `"kn"`
        pub const LANG_AB: &str = "kn";
        /// `"kan"`
        pub const LANG_LIB: &str = "kan";
        /// `"ಕನ\u{ccd}ನಡ"`
        pub const LANG_NAME: &str = "ಕನ\u{ccd}ನಡ";
        /// `"kan"`
        pub const LANG_TERM: &str = "kan";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2002-11-28"`
        pub const DATE: &str = "2002-11-28";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Kannada"`
        pub const LANGUAGE: &str = "Kannada";
        /// `"0.1"`
        pub const REVISION: &str = "0.1";
        /// `"IndLinux.org"`
        pub const SOURCE: &str = "IndLinux.org";
        /// `""`
        pub const TEL: &str = "";
        /// `"India"`
        pub const TERRITORY: &str = "India";
        /// `"Kannada language locale for India"`
        pub const TITLE: &str = "Kannada language locale for India";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNಇ]"`
        pub const NOEXPR: &str = "^[-0nNಇ]";
        /// `"ಇಲ\u{ccd}ಲ"`
        pub const NOSTR: &str = "ಇಲ\u{ccd}ಲ";
        /// `"^[+1yYಹ]"`
        pub const YESEXPR: &str = "^[+1yYಹ]";
        /// `"ಹ\u{ccc}ದು"`
        pub const YESSTR: &str = "ಹ\u{ccc}ದು";
    }
    pub use super::hi_IN::LC_MONETARY;
    pub use super::hi_IN::LC_NUMERIC;
    pub use super::hi_IN::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["ರ", "ಸೋ", "ಮಂ", "ಬು", "ಗು", "ಶು", "ಶ"]`
        pub const ABDAY: &[&str] = &["ರ", "ಸೋ", "ಮಂ", "ಬು", "ಗು", "ಶು", "ಶ"];
        /// `&["ಜನ", "ಫ\u{cc6}ಬ\u{ccd}ರ", "ಮಾರ\u{ccd}ಚ\u{ccd}", "ಏಪ\u{ccd}ರ\u{cbf}", "ಮೇ", "ಜ\u{cc2}ನ\u{ccd}", "ಜುಲೈ", "ಆ", "ಸ\u{cc6}ಪ\u{ccd}ಟ\u{cc6}ಂ", "ಅಕ\u{ccd}ಟೋ", "ನವ\u{cc6}ಂ", "ಡ\u{cbf}ಸ\u{cc6}ಂ"]`
        pub const ABMON: &[&str] = &["ಜನ", "ಫ\u{cc6}ಬ\u{ccd}ರ", "ಮಾರ\u{ccd}ಚ\u{ccd}", "ಏಪ\u{ccd}ರ\u{cbf}", "ಮೇ", "ಜ\u{cc2}ನ\u{ccd}", "ಜುಲೈ", "ಆ", "ಸ\u{cc6}ಪ\u{ccd}ಟ\u{cc6}ಂ", "ಅಕ\u{ccd}ಟೋ", "ನವ\u{cc6}ಂ", "ಡ\u{cbf}ಸ\u{cc6}ಂ"];
        /// `&["ಪ\u{cc2}ರ\u{ccd}ವಾಹ\u{ccd}ನ", "ಅಪರಾಹ\u{ccd}ನ"]`
        pub const AM_PM: &[&str] = &["ಪ\u{cc2}ರ\u{ccd}ವಾಹ\u{ccd}ನ", "ಅಪರಾಹ\u{ccd}ನ"];
        /// `"%-d/%-m/%y"`
        pub const D_FMT: &str = "%-d/%-m/%y";
        /// `"%A %d %b %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A %d %b %Y %I:%M:%S %p %Z";
        /// `&["ರವ\u{cbf}ವಾರ", "ಸೋಮವಾರ", "ಮಂಗಳವಾರ", "ಬುಧವಾರ", "ಗುರುವಾರ", "ಶುಕ\u{ccd}ರವಾರ", "ಶನ\u{cbf}ವಾರ"]`
        pub const DAY: &[&str] = &["ರವ\u{cbf}ವಾರ", "ಸೋಮವಾರ", "ಮಂಗಳವಾರ", "ಬುಧವಾರ", "ಗುರುವಾರ", "ಶುಕ\u{ccd}ರವಾರ", "ಶನ\u{cbf}ವಾರ"];
        /// `&["ಜನವರ\u{cbf}", "ಫ\u{cc6}ಬ\u{ccd}ರವರ\u{cbf}", "ಮಾರ\u{ccd}ಚ\u{ccd}", "ಏಪ\u{ccd}ರ\u{cbf}ಲ\u{ccd}", "ಮೇ", "ಜ\u{cc2}ನ\u{ccd}", "ಜುಲೈ", "ಆಗಸ\u{ccd}ಟ\u{ccd}", "ಸ\u{cc6}ಪ\u{ccd}ಟ\u{cc6}ಂಬರ\u{ccd}", "ಅಕ\u{ccd}ಟೋಬರ\u{ccd}", "ನವ\u{cc6}ಂಬರ\u{ccd}", "ಡ\u{cbf}ಸ\u{cc6}ಂಬರ\u{ccd}"]`
        pub const MON: &[&str] = &["ಜನವರ\u{cbf}", "ಫ\u{cc6}ಬ\u{ccd}ರವರ\u{cbf}", "ಮಾರ\u{ccd}ಚ\u{ccd}", "ಏಪ\u{ccd}ರ\u{cbf}ಲ\u{ccd}", "ಮೇ", "ಜ\u{cc2}ನ\u{ccd}", "ಜುಲೈ", "ಆಗಸ\u{ccd}ಟ\u{ccd}", "ಸ\u{cc6}ಪ\u{ccd}ಟ\u{cc6}ಂಬರ\u{ccd}", "ಅಕ\u{ccd}ಟೋಬರ\u{ccd}", "ನವ\u{cc6}ಂಬರ\u{ccd}", "ಡ\u{cbf}ಸ\u{cc6}ಂಬರ\u{ccd}"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ko_KR {
    pub mod LC_ADDRESS {
        /// `"KR"`
        pub const COUNTRY_ABTWO: &str = "KR";
        /// `"KOR"`
        pub const COUNTRY_AB3: &str = "KOR";
        /// `"ROK"`
        pub const COUNTRY_CAR: &str = "ROK";
        /// `"979-11,978-89"`
        pub const COUNTRY_ISBN: &str = "979-11,978-89";
        /// `"대한민국"`
        pub const COUNTRY_NAME: &str = "대한민국";
        /// `410`
        pub const COUNTRY_NUM: i64 = 410;
        /// `"ko"`
        pub const LANG_AB: &str = "ko";
        /// `"kor"`
        pub const LANG_LIB: &str = "kor";
        /// `"한국어"`
        pub const LANG_NAME: &str = "한국어";
        /// `"kor"`
        pub const LANG_TERM: &str = "kor";
        /// `"%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N"`
        pub const POSTAL_FMT: &str = "%f%N%a%N%d%N%b%N%s %h %e %r%N%z %T%N%c%N";
    }
    pub mod LC_IDENTIFICATION {
        /// `""`
        pub const ADDRESS: &str = "";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2000-11-09"`
        pub const DATE: &str = "2000-11-09";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Korean"`
        pub const LANGUAGE: &str = "Korean";
        /// `"1.1"`
        pub const REVISION: &str = "1.1";
        /// `""`
        pub const SOURCE: &str = "";
        /// `""`
        pub const TEL: &str = "";
        /// `"South Korea"`
        pub const TERRITORY: &str = "South Korea";
        /// `"Korean locale for Republic of Korea"`
        pub const TITLE: &str = "Korean locale for Republic of Korea";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNｎＮ아]"`
        pub const NOEXPR: &str = "^[-0nNｎＮ아]";
        /// `"아니요"`
        pub const NOSTR: &str = "아니요";
        /// `"^[+1yYｙＹ예]"`
        pub const YESEXPR: &str = "^[+1yYｙＹ예]";
        /// `"예"`
        pub const YESSTR: &str = "예";
    }
    pub mod LC_MONETARY {
        /// `"₩"`
        pub const CURRENCY_SYMBOL: &str = "₩";
        /// `0`
        pub const FRAC_DIGITS: i64 = 0;
        /// `"KRW "`
        pub const INT_CURR_SYMBOL: &str = "KRW ";
        /// `0`
        pub const INT_FRAC_DIGITS: i64 = 0;
        /// `"."`
        pub const MON_DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const MON_GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const MON_THOUSANDS_SEP: &str = ",";
        /// `1`
        pub const N_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const N_SEP_BY_SPACE: i64 = 0;
        /// `4`
        pub const N_SIGN_POSN: i64 = 4;
        /// `"-"`
        pub const NEGATIVE_SIGN: &str = "-";
        /// `1`
        pub const P_CS_PRECEDES: i64 = 1;
        /// `0`
        pub const P_SEP_BY_SPACE: i64 = 0;
        /// `1`
        pub const P_SIGN_POSN: i64 = 1;
        /// `""`
        pub const POSITIVE_SIGN: &str = "";
    }
    pub mod LC_NUMERIC {
        /// `"."`
        pub const DECIMAL_POINT: &str = ".";
        /// `&[3, 3]`
        pub const GROUPING: &[i64] = &[3, 3];
        /// `","`
        pub const THOUSANDS_SEP: &str = ",";
    }
    pub mod LC_TELEPHONE {
        /// `"82"`
        pub const INT_PREFIX: &str = "82";
        /// `"001"`
        pub const INT_SELECT: &str = "001";
        /// `"(%A) %l"`
        pub const TEL_DOM_FMT: &str = "(%A) %l";
        /// `"+%c %a %l"`
        pub const TEL_INT_FMT: &str = "+%c %a %l";
    }
    pub mod LC_TIME {
        /// `&["일", "월", "화", "수", "목", "금", "토"]`
        pub const ABDAY: &[&str] = &["일", "월", "화", "수", "목", "금", "토"];
        /// `&[" 1월", " 2월", " 3월", " 4월", " 5월", " 6월", " 7월", " 8월", " 9월", "10월", "11월", "12월"]`
        pub const ABMON: &[&str] = &[" 1월", " 2월", " 3월", " 4월", " 5월", " 6월", " 7월", " 8월", " 9월", "10월", "11월", "12월"];
        /// `&["오전", "오후"]`
        pub const AM_PM: &[&str] = &["오전", "오후"];
        /// `"%Y년 %m월 %d일"`
        pub const D_FMT: &str = "%Y년 %m월 %d일";
        /// `"%x (%a) %r"`
        pub const D_T_FMT: &str = "%x (%a) %r";
        /// `"%Y. %m. %d. (%a) %H:%M:%S %Z"`
        pub const DATE_FMT: &str = "%Y. %m. %d. (%a) %H:%M:%S %Z";
        /// `&["일요일", "월요일", "화요일", "수요일", "목요일", "금요일", "토요일"]`
        pub const DAY: &[&str] = &["일요일", "월요일", "화요일", "수요일", "목요일", "금요일", "토요일"];
        /// `&["1월", "2월", "3월", "4월", "5월", "6월", "7월", "8월", "9월", "10월", "11월", "12월"]`
        pub const MON: &[&str] = &["1월", "2월", "3월", "4월", "5월", "6월", "7월", "8월", "9월", "10월", "11월", "12월"];
        /// `"%H시 %M분 %S초"`
        pub const T_FMT: &str = "%H시 %M분 %S초";
        /// `"%p %I시 %M분 %S초"`
        pub const T_FMT_AMPM: &str = "%p %I시 %M분 %S초";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod kok_IN {
    pub mod LC_ADDRESS {
        /// `"IN"`
        pub const COUNTRY_ABTWO: &str = "IN";
        /// `"IND"`
        pub const COUNTRY_AB3: &str = "IND";
        /// `"IND"`
        pub const COUNTRY_CAR: &str = "IND";
        /// `"भारत"`
        pub const COUNTRY_NAME: &str = "भारत";
        /// `356`
        pub const COUNTRY_NUM: i64 = 356;
        /// `"kok"`
        pub const LANG_LIB: &str = "kok";
        /// `"को\u{902}कणी"`
        pub const LANG_NAME: &str = "को\u{902}कणी";
        /// `"kok"`
        pub const LANG_TERM: &str = "kok";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Level-1, Tower 10, Cyber City, Magarpatta City, Hadapsar, Pune, Maharashtra, India-411013"`
        pub const ADDRESS: &str = "Level-1, Tower 10, Cyber City, Magarpatta City, Hadapsar, Pune, Maharashtra, India-411013";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2009,December,08"`
        pub const DATE: &str = "2009,December,08";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Konkani"`
        pub const LANGUAGE: &str = "Konkani";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Red Hat, Pune"`
        pub const SOURCE: &str = "Red Hat, Pune";
        /// `""`
        pub const TEL: &str = "";
        /// `"India"`
        pub const TERRITORY: &str = "India";
        /// `"Konkani language locale for India"`
        pub const TITLE: &str = "Konkani language locale for India";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNन]"`
        pub const NOEXPR: &str = "^[-0nNन]";
        /// `"न\u{94d}ही"`
        pub const NOSTR: &str = "न\u{94d}ही";
        /// `"^[+1yYह]"`
        pub const YESEXPR: &str = "^[+1yYह]";
        /// `"हय"`
        pub const YESSTR: &str = "हय";
    }
    pub use super::hi_IN::LC_MONETARY;
    pub use super::hi_IN::LC_NUMERIC;
    pub use super::hi_IN::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["आयतार", "सोमार", "म\u{902}गळवार", "ब\u{941}धवार", "ब\u{947}र\u{947}सतार", "श\u{941}करार", "श\u{947}नवार"]`
        pub const ABDAY: &[&str] = &["आयतार", "सोमार", "म\u{902}गळवार", "ब\u{941}धवार", "ब\u{947}र\u{947}सतार", "श\u{941}करार", "श\u{947}नवार"];
        /// `&["जान\u{947}वारी", "फ\u{947}ब\u{94d}र\u{941}वारी", "मार\u{94d}च", "एप\u{94d}रिल", "म\u{947}", "ज\u{942}न", "ज\u{941}ल\u{948}", "ओगस\u{94d}ट", "स\u{947}प\u{94d}ट\u{947}\u{902}बर", "ओक\u{94d}टोबर", "नोव\u{94d}ह\u{947}\u{902}बर", "डिस\u{947}\u{902}बर"]`
        pub const ABMON: &[&str] = &["जान\u{947}वारी", "फ\u{947}ब\u{94d}र\u{941}वारी", "मार\u{94d}च", "एप\u{94d}रिल", "म\u{947}", "ज\u{942}न", "ज\u{941}ल\u{948}", "ओगस\u{94d}ट", "स\u{947}प\u{94d}ट\u{947}\u{902}बर", "ओक\u{94d}टोबर", "नोव\u{94d}ह\u{947}\u{902}बर", "डिस\u{947}\u{902}बर"];
        /// `&["म.प\u{942}.", "म.न\u{902}."]`
        pub const AM_PM: &[&str] = &["म.प\u{942}.", "म.न\u{902}."];
        /// `"%-d-%-m-%y"`
        pub const D_FMT: &str = "%-d-%-m-%y";
        /// `"%A %d %b %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A %d %b %Y %I:%M:%S %p %Z";
        /// `&["आयतार", "सोमार", "म\u{902}गळवार", "ब\u{941}धवार", "ब\u{947}र\u{947}सतार", "श\u{941}करार", "श\u{947}नवार"]`
        pub const DAY: &[&str] = &["आयतार", "सोमार", "म\u{902}गळवार", "ब\u{941}धवार", "ब\u{947}र\u{947}सतार", "श\u{941}करार", "श\u{947}नवार"];
        /// `&["जान\u{947}वारी", "फ\u{947}ब\u{94d}र\u{941}वारी", "मार\u{94d}च", "एप\u{94d}रिल", "म\u{947}", "ज\u{942}न", "ज\u{941}ल\u{948}", "ओगस\u{94d}ट", "स\u{947}प\u{94d}ट\u{947}\u{902}बर", "ओक\u{94d}टोबर", "नोव\u{94d}ह\u{947}\u{902}बर", "डिस\u{947}\u{902}बर"]`
        pub const MON: &[&str] = &["जान\u{947}वारी", "फ\u{947}ब\u{94d}र\u{941}वारी", "मार\u{94d}च", "एप\u{94d}रिल", "म\u{947}", "ज\u{942}न", "ज\u{941}ल\u{948}", "ओगस\u{94d}ट", "स\u{947}प\u{94d}ट\u{947}\u{902}बर", "ओक\u{94d}टोबर", "नोव\u{94d}ह\u{947}\u{902}बर", "डिस\u{947}\u{902}बर"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ks_IN {
    pub mod LC_ADDRESS {
        /// `"IN"`
        pub const COUNTRY_ABTWO: &str = "IN";
        /// `"IND"`
        pub const COUNTRY_AB3: &str = "IND";
        /// `"IND"`
        pub const COUNTRY_CAR: &str = "IND";
        /// `"ہ\u{650}ندوستان"`
        pub const COUNTRY_NAME: &str = "ہ\u{650}ندوستان";
        /// `356`
        pub const COUNTRY_NUM: i64 = 356;
        /// `"ks"`
        pub const LANG_AB: &str = "ks";
        /// `"kas"`
        pub const LANG_LIB: &str = "kas";
        /// `"کٲش\u{64f}ر"`
        pub const LANG_NAME: &str = "کٲش\u{64f}ر";
        /// `"kas"`
        pub const LANG_TERM: &str = "kas";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATION {
        /// `"Marisfot III, Marigold Premises, East-Wing, Kalyaninagar, Pune, India-411014"`
        pub const ADDRESS: &str = "Marisfot III, Marigold Premises, East-Wing, Kalyaninagar, Pune, India-411014";
        /// ```ignore
        /// &[
        ///     &["i18n:2012", "LC_IDENTIFICATION"],
        ///     &["i18n:2012", "LC_CTYPE"],
        ///     &["i18n:2012", "LC_COLLATE"],
        ///     &["i18n:2012", "LC_TIME"],
        ///     &["i18n:2012", "LC_NUMERIC"],
        ///     &["i18n:2012", "LC_MONETARY"],
        ///     &["i18n:2012", "LC_MESSAGES"],
        ///     &["i18n:2012", "LC_PAPER"],
        ///     &["i18n:2012", "LC_NAME"],
        ///     &["i18n:2012", "LC_ADDRESS"],
        ///     &["i18n:2012", "LC_TELEPHONE"],
        ///     &["i18n:2012", "LC_MEASUREMENT"],
        /// ]
        /// ```
        pub const CATEGORY: &[&[&str]] = &[
            &["i18n:2012", "LC_IDENTIFICATION"],
            &["i18n:2012", "LC_CTYPE"],
            &["i18n:2012", "LC_COLLATE"],
            &["i18n:2012", "LC_TIME"],
            &["i18n:2012", "LC_NUMERIC"],
            &["i18n:2012", "LC_MONETARY"],
            &["i18n:2012", "LC_MESSAGES"],
            &["i18n:2012", "LC_PAPER"],
            &["i18n:2012", "LC_NAME"],
            &["i18n:2012", "LC_ADDRESS"],
            &["i18n:2012", "LC_TELEPHONE"],
            &["i18n:2012", "LC_MEASUREMENT"],
        ];
        /// `""`
        pub const CONTACT: &str = "";
        /// `"2009,April,06"`
        pub const DATE: &str = "2009,April,06";
        /// `"bug-glibc-locales@gnu.org"`
        pub const EMAIL: &str = "bug-glibc-locales@gnu.org";
        /// `""`
        pub const FAX: &str = "";
        /// `"Kashmiri"`
        pub const LANGUAGE: &str = "Kashmiri";
        /// `"1.0"`
        pub const REVISION: &str = "1.0";
        /// `"Red Hat, Pune"`
        pub const SOURCE: &str = "Red Hat, Pune";
        /// `""`
        pub const TEL: &str = "";
        /// `"India"`
        pub const TERRITORY: &str = "India";
        /// `"Kashmiri language locale for India"`
        pub const TITLE: &str = "Kashmiri language locale for India";
    }
    pub mod LC_MESSAGES {
        /// `"^[-0nNن]"`
        pub const NOEXPR: &str = "^[-0nNن]";
        /// `"نع"`
        pub const NOSTR: &str = "نع";
        /// `"^[+1yYآ]"`
        pub const YESEXPR: &str = "^[+1yYآ]";
        /// `"آ"`
        pub const YESSTR: &str = "آ";
    }
    pub use super::hi_IN::LC_MONETARY;
    pub use super::hi_IN::LC_NUMERIC;
    pub use super::hi_IN::LC_TELEPHONE;
    pub mod LC_TIME {
        /// `&["آتهوار", "ژءنتروار", "بوءںوار", "بودهوار", "برىسوار", "جمع", "بٹوار"]`
        pub const ABDAY: &[&str] = &["آتهوار", "ژءنتروار", "بوءںوار", "بودهوار", "برىسوار", "جمع", "بٹوار"];
        /// `&["جنؤری", "فرؤری", "مار\u{655}چ", "اپریل", "می\u{654}", "جو\u{657}ن", "جو\u{657}لایی", "اگست", "ستمبر", "اکتو\u{657}بر", "نومبر", "دسمبر"]`
        pub const ABMON: &[&str] = &["جنؤری", "فرؤری", "مار\u{655}چ", "اپریل", "می\u{654}", "جو\u{657}ن", "جو\u{657}لایی", "اگست", "ستمبر", "اکتو\u{657}بر", "نومبر", "دسمبر"];
        /// `&["دوپھربرونھ", "دوپھرپتھ"]`
        pub const AM_PM: &[&str] = &["دوپھربرونھ", "دوپھرپتھ"];
        /// `"%-m/%-d/%y"`
        pub const D_FMT: &str = "%-m/%-d/%y";
        /// `"%A %d %b %Y %I:%M:%S %p %Z"`
        pub const D_T_FMT: &str = "%A %d %b %Y %I:%M:%S %p %Z";
        /// `&["آتهوار", "ژءندروار", "بوءںوار", "بودهوار", "برىسوار", "جمع", "بٹوار"]`
        pub const DAY: &[&str] = &["آتهوار", "ژءندروار", "بوءںوار", "بودهوار", "برىسوار", "جمع", "بٹوار"];
        /// `&["جنؤری", "فرؤری", "مار\u{655}چ", "اپریل", "می\u{654}", "جو\u{657}ن", "جو\u{657}لایی", "اگست", "ستمبر", "اکتو\u{657}بر", "نومبر", "دسمبر"]`
        pub const MON: &[&str] = &["جنؤری", "فرؤری", "مار\u{655}چ", "اپریل", "می\u{654}", "جو\u{657}ن", "جو\u{657}لایی", "اگست", "ستمبر", "اکتو\u{657}بر", "نومبر", "دسمبر"];
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT: &str = "%I:%M:%S %p %Z";
        /// `"%I:%M:%S %p %Z"`
        pub const T_FMT_AMPM: &str = "%I:%M:%S %p %Z";
        /// `&[7, 19971130, 1]`
        pub const WEEK: &[i64] = &[7, 19971130, 1];
    }
}

#[allow(non_snake_case,non_camel_case_types,dead_code,unused_imports)]
pub mod ks_IN_devanagari {
    pub mod LC_ADDRESS {
        /// `"IN"`
        pub const COUNTRY_ABTWO: &str = "IN";
        /// `"IND"`
        pub const COUNTRY_AB3: &str = "IND";
        /// `"IND"`
        pub const COUNTRY_CAR: &str = "IND";
        /// `"भारत"`
        pub const COUNTRY_NAME: &str = "भारत";
        /// `356`
        pub const COUNTRY_NUM: i64 = 356;
        /// `"ks"`
        pub const LANG_AB: &str = "ks";
        /// `"kas"`
        pub const LANG_LIB: &str = "kas";
        /// `"कॉश\u{941}र"`
        pub const LANG_NAME: &str = "कॉश\u{941}र";
        /// `"kas"`
        pub const LANG_TERM: &str = "kas";
        /// `"%z%c%T%s%b%e%r"`
        pub const POSTAL_FMT: &str = "%z%c%T%s%b%e%r";
    }
    pub mod LC_IDENTIFICATIO