require 'lib/child_labor'
require 'pathname'
require 'fileutils'

module PathHelpers
  def root(*args)
    Pathname.new("../../").expand_path(__FILE__).join(*args)
  end

  def tmp(*args)
    root("tmp", *args)
  end
end

Spec::Runner.configure do |c|
  c.include PathHelpers

  c.before :each do
    FileUtils.rm_rf(tmp)
    FileUtils.mkdir_p(tmp)
  end
end
