// Copyright 2023-2024 Gentoo Authors
// Distributed under the terms of the GNU General Public License v2

namespace Gdmt.Ebuild.Entities

open Gdmt.Shared.Types

[<Struct>]
type PortageSettings =

    { DoPerformTest: bool
      FEATURES: string
      USE: string }

    member this.GetTestFlag: string = if this.DoPerformTest then "test " else ""
    member this.GetAllowTest: string = if this.DoPerformTest then "all " else ""

    member this.GetFeatures: string = this.GetTestFlag + this.FEATURES
    member this.GetUse: string = this.GetTestFlag + this.USE

    member this.GetPortageEnv() : ProcessEnvironmentMap =
        [ ("ALLOW_TEST", this.GetAllowTest)
          ("FEATURES", this.GetFeatures)
          ("USE", this.GetUse) ]
