/*
   Copyright (C) 2004 by James Gregory
   Part of the GalaxyHack project

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.

   See the COPYING file for more details.
*/

#ifndef GUARD_Stuff
#define GUARD_Stuff

#include "GlobalConstants.h"
#include "Enums.h"

#include <SDL.h>

#include <vector>
#include <string>
#include <map>
#include <stdexcept>

using std::vector;
using std::string;
using std::map;
using std::runtime_error;

class MinorError: public runtime_error
{
public:
	MinorError(const char* description):runtime_error(description) {}
};

class CoordsInt
{
public:   
    int x;
    int y;
	CoordsInt& operator=(const CoordsInt& coordsTwo) {x = coordsTwo.x; y = coordsTwo.y; return *this;}
	
    bool operator==(const CoordsInt& coordsTwo) const {return (x == coordsTwo.x && y == coordsTwo.y) ? 1 : 0;}
    bool operator!=(const CoordsInt& coordsTwo) const {return (x == coordsTwo.x && y == coordsTwo.y) ? 0 : 1;}	
};

class CoordsFloat
{
public:   
    float x;
    float y;
	CoordsFloat& operator=(const CoordsFloat& coordsTwo) {x = coordsTwo.x; y = coordsTwo.y; return *this;}
	
    bool operator==(const CoordsFloat& coordsTwo) const {return (x == coordsTwo.x && y == coordsTwo.y) ? 1 : 0;}
    bool operator!=(const CoordsFloat& coordsTwo) const {return (x == coordsTwo.x && y == coordsTwo.y) ? 0 : 1;}	
};

class FontStruct
{
public:
    void Init(int iWidth, int iHeight, int iLetterJump, int iLineJump);
    void AddFont(SDL_Surface* newPic);
    void Shutdown();

    void BlitString(int x, int y, int nFont, const string& output);
	
	map<char, SDL_Rect> fontLookup;

private:
    void NextLetter(SDL_Rect& theRect);
    void NextLine(SDL_Rect& theRect);

    vector<SDL_Surface*> pics;
    int width;
    int height;
    int letterJump;
    int lineJump;
};

int StringInput(SDL_keysym& keysym, string& giveString, int maxLength);

int TestOverlap(const SDL_Rect& rectOne, const SDL_Rect& rectTwo);

int GetMoveProps(float& propx, float& propy, float dx, float dy);

void CheckFileExists(const string& filename);
bool DoesFileExist(const string& filename);
void NewlineConvert(string& theString);
bool CheckNameValid(const string& theName, bool createInfo);
void FileToString(const string& fileName, string& theString);

void DrawRectBorder(SDL_Rect& theRect, Uint16 color);

void ReportOnMinorError(const char* error, bool force = false);
void ErrorBackToMM(const string& error);

string MakePicDirString(int nSide, const string& endOfDir, bool standard);
string GetFleetDir(int whichSide);
bool CheckFleetExists(const string& fleetName);

void FollowViewCenter();
void CycleGroupInfoType();

void RemoveDirectory(const string& path);

ustring strToUstr(const string& str);
string ustrToStr(const ustring& ustr);

void LoadStandardGraphics();
void ClearStandardGraphics();
void ResetGraphics();

void SelectGroup(int side, int group, WindowChoice infoType);

#endif

