/*
   Copyright (C) 2004 by James Gregory
   Part of the GalaxyHack project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#ifndef GUARD_RTSStructs
#define GUARD_RTSStructs

#include "Enums.h"
#include "Stuff.h"

#include <string>

using std::string;

class AICommands {
public:
	MoveCommand moveCommand;
	bool bInverse;
	bool bFire;

	CoordsInt fireTarget;
	int fireTargetDist;

	//all these values get used for PATROL, too
	//moveTargetSide.y is also used to store compass directions
	CoordsInt moveTarget;
	float aimPropx;
	float aimPropy;
	//only valid if a group target
	int moveTargetDist;
	int patrolDist;
};

//for an individual unit, AI commands is for a group
class TargetDesc {
public:
	int whichUnit;

	int currentx;
	int currenty;
	CoordsInt weakSpot;

	float speedx;
	float speedy;

	int difficulty;
};

class WeaponDesc {
public:
	string name;
	int points;
	int power;
	int range;
	int accuracy;
	int reload;
	float speed;
	//for big lasers, missiles and torpedos this means length in time
	int length;
	int startAmmo;

	WeaponCat category;
	WindowChoice FSWC;
};

class EquipDesc {
public:
	int points;
	int max;
	int recharge;

	EquipCat category;
	WindowChoice FSEC;
};

#endif
