/*
   Copyright (C) 2004 by James Gregory
   Part of the GalaxyHack project

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.

   See the COPYING file for more details.
*/

#ifndef GUARD_PreBattle
#define GUARD_PreBattle

#include "GameState.h"
#include "Enums.h"
#include "RTS.h"

#include <string>
#include <vector>
#include <map>

using std::map;
using std::vector;
using std::string;

namespace PreBattle
{

extern PBState pbState;

class PreBattle_State: public GameState
{
public:
	PreBattle_State();
	~PreBattle_State();
	void Main();
	
	void MouseD(Uint8 button, Uint16 x, Uint16 y);
	void MouseU(Uint8 button, Uint16 x, Uint16 y);
	void MouseM(Uint8 state, Uint16 x, Uint16 y);
	void Keyboard(SDL_keysym& keysym);
};

void SetupTerrain();
void SetStartingRects();
void SetStartingPositions();
void FitGroupsInRemainingSpace(vector<bool> placedGroups, bool ignoreOverlap = false);

void Unload();
void UnloadGraphics();



} // end namespace

#endif
