/*
   Copyright (C) 2004 by James Gregory
   Part of the GalaxyHack project
 
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License.
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY.
 
   See the COPYING file for more details.
*/

#include "Globals.h"
#include "Group.h"
#include "TerrainTile.h"

SettingsStruct globalSettings;
SettingsStruct oldGlobalSettings;

JamesSDL JSDL;
bool skipDisplayFrame;

SDL_Rect screenRect;

GameStateType gsCurrent = GST_TheOS;
GameStateType gsTo = GST_MainMenu;

int windowIDs = 0;
bool anInfoString = 0;

int now;
int worldUpdateInterval = standardInterval;
int scrollInterval = standardInterval;

//pseudo-consts
SDL_Rect colorRect;

Uint16 gold;
Uint16 veryDarkGold;
Uint16 veryDarkGreen;
Uint16 lightBlue;
Uint16 black;
Uint16 white;
Uint16 laserRed;
Uint16 laserGreen;
Uint16 laserBlue;
Uint16 laserYellow;
Uint16 missileGrey;
Uint16 torpedoBlue;
Uint16 greyText;
Uint16 bigRangeBlue;

Uint16 sideRed;
Uint16 sideGreen;
Uint16 sideBlue;
Uint16 sideYellow;

Uint16 radarRed;
Uint16 radarGreen;
Uint16 radarBlue;
Uint16 radarYellow;


vector<Side> sides;
list<GenWindow> myWindows;
SDL_Surface* genPictures[nGenPictures];

map<string, unsigned char> tokenLookup;
map<string, WeaponType> weaponLoadLookup;
WeaponDesc weaponLookup[nWeapons];
map<string, EquipDesc> equipLookup;
map<WindowChoice, WeaponType> WCToWTLookup;
map<WindowChoice, string> WCToETLookup;

map<UnitType, string> uTypeToString;
map<CapShipType, string> csTypeToString;
map<string, UnitType> stringToUType;
map<string, CapShipType> stringToCSType;

FontStruct normalFonts;
FontStruct boldFonts;


string globalErrorString = "No error right now";

//RTS Globals
int worldWidth;
int worldHeight;
int viewx;
int viewy;

int viewSide;
int viewGroup;

bool paused = false;

//only counts frames that get run
unsigned int frameCounter;

//set to now in rtsinit
int lastAITime;

//set to now in rtsinit
int lastScrollTime;

bool radarDragging;

SDL_Rect topRightBoxRect;
SDL_Rect radarRect;
SDL_Surface* radarSurface;

vector<SDL_Surface*> terrainPictures;
std::vector<TerrainArea> terrainTree;

list<Projectile> projectiles;


