#include "gimme_config_h.h"

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif

#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include "cddb_handle_multiple_matches.h"
#include "cdstatus_cddb.h"
#include "cdstatus_output.h"

int handleMultipleMatches(void *buffer, unsigned int first_inexact, char *category, unsigned int * discid)
{
	void *backup_buffer;
	unsigned int index;
	int choice;
	char *token;

	backup_buffer = calloc(1, BUFFSIZE);
	if (backup_buffer == NULL)
	{
		conditional_puts(CRITICAL, "Error, unable to allocate backup_buffer for parsing entries.");
		return 0;
	}
	memcpy(backup_buffer, buffer, BUFFSIZE);
	token = strtok((char *) buffer, "\n");
	index = 1;
	while ((token != NULL) && (strcmp(token, ".")!=0))
	{
		token = strtok(NULL, "\n");
		if(token==NULL)
		{
			conditional_puts(WARNING, "Error, invalid response received from server, exiting.");
			free(backup_buffer);
			return 0;
		}
		if (strncmp(token, ".", 1)!=0)
		{
			conditional_printf(NORMAL, "%u. %s\n", index, token);
		}

		else
		{
			break;
		}
		++index;
	}
	(void)fflush(stdout);
	if (first_inexact!=0)
	{
		choice = 1;
		conditional_puts(DEBUG, "Defaulting to first match due to user preference");
	}
	else
	{
		choice = getchar() - 48;
	}
	memcpy(buffer, backup_buffer, BUFFSIZE);
	free(backup_buffer);
	token = strtok((char *) buffer, "\n");
	index = 1;
	while ((token != NULL) && (strcmp(token, ".")!=0))
	{
		token = strtok(NULL, "\n");
		if(token==NULL)
		{
			conditional_puts(CRITICAL, "Invalid server response or error in parsing, exiting");
			return 0;
		}
		if (strncmp(token, ".", 1)!=0)
		{
			if (index == (unsigned int)choice)
			{
				break;
			}
		}
		++index;
	}
	if(token==NULL)
	{
		conditional_puts(CRITICAL, "Error, got null token from server, exiting.");
		return 0;
	}
	strncpy(buffer, token, BUFFSIZE);
	token = strtok((char *) buffer, " ");
	strncpy(category, token, 64);
	token = strtok(NULL, " ");
	if(token==NULL)
	{
		conditional_puts(CRITICAL, "Invalid server response or error in parsing. Exiting.");
		return 0;
	}
	if(sscanf(token, "%x", discid)!=1)
	{
		conditional_puts(CRITICAL, "Invalid server response or parsing error. Exiting.");
		return 0;
	}
	return choice;
}
