/*
 * hash.h --- hash package.
 *
 * Copyright (c) 1997, 98, 99, 2000, 2001 by Pascal Wassong All Rights Reserved.
 *
 * Time-stamp: <2001-04-16 18:22:36 Pascal>
 *
 * This file is part of Natch.
 *
 * Natch is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Natch is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef	HASH_H
#define	HASH_H

#include	"types.h"
#include	"expltype.h"

#define	LG_KEY		33

bool_t		hashTest   ( const exploration_t*	datas      ,
			     unsigned long*		hash_value ,
			     unsigned int*		solution   );
void		hashInsert ( const exploration_t*	datas      ,
			     unsigned long		hash_value ,
			     unsigned int		solution   );
void		hashSetSize( unsigned int n );
void		hashInit   ( unsigned int single_moves, unsigned int lg_key );
void		hashFree   ();

#ifndef EXTERN_HASH
#define	EXTERN_HASH	extern
#endif

EXTERN_HASH unsigned int	Hash_Key_Length ;

#endif /* HASH_H */

