---
layout: post
title: "Cap'n Proto 0.7 Released"
author: kentonv
---

<div style="float: right"><a class="block_link" style="color: #fff"
href="{{site.baseurl}}install.html">Get it now &raquo;</a></div>

Today we're releasing Cap'n Proto 0.7.

### As used in Cloudflare Workers

The biggest high-level development in Cap'n Proto since the last release is its use in the implementation of [Cloudflare Workers](https://blog.cloudflare.com/cloudflare-workers-unleashed/) (of which I am the tech lead).

Cloudflare operates a global network of 152 datacenters and growing, and Cloudflare Workers allows you to deploy "serveless" JavaScript to all of those locations in under 30 seconds. Your code is written against the W3C standard [Service Workers API](https://developer.mozilla.org/en-US/docs/Web/API/Service_Worker_API) and handles HTTP traffic for your web site.

The Cloudflare Workers runtime implementation is written in C++, leveraging the V8 JavaScript engine and libKJ, the C++ toolkit library distributed with Cap'n Proto.

Cloudflare Workers are all about handling HTTP traffic, and the runtime uses KJ's HTTP library to do it. This means the KJ HTTP library is now battle-tested in production. Every package downloaded from [npm](https://npmjs.org), for example, passes through KJ's HTTP client and server libraries on the way (since npm uses Workers).

The Workers runtime makes heavy use of KJ, but so far only makes light use of Cap'n Proto serialization. Cap'n Proto is used as a format for distributing configuration as well as (ironically) to handle JSON. We anticipate, however, making deeper use of Cap'n Proto in the future, including RPC.

### What else is new?

* The C++ library now requires C++14 or newer. It requires GCC 4.9+, Clang 3.6+, or Microsoft Visual Studio 2017. This change allows us to make faster progress and provide cleaner APIs by utilizing newer language features.
* The JSON parser now supports [annotations to customize conversion behavior](https://github.com/capnproto/capnproto/blob/master/c++/src/capnp/compat/json.capnp). These allow you to override field names (e.g. to use underscores instead of camelCase), flatten sub-objects, and express unions in various more-idiomatic ways.
* The KJ HTTP library supports WebSockets, and has generally become much higher-quality as it has been battle-tested in Cloudflare Workers.
* KJ now offers its own [hashtable- and b-tree-based container implementations](https://github.com/capnproto/capnproto/blob/master/c++/src/kj/map.h). `kj::HashMap` is significantly faster and more memory-efficient than `std::unordered_map`, with more optimizations coming. `kj::TreeMap` is somewhat slower than `std::map`, but uses less memory and has a smaller code footprint. Both are implemented on top of `kj::Table`, a building block that can also support multi-maps. Most importantly, all these interfaces are cleaner and more modern than their ancient STL counterparts.
* KJ now includes [TLS bindings](https://github.com/capnproto/capnproto/blob/master/c++/src/kj/compat/tls.h). `libkj-tls` wraps OpenSSL or BoringSSL and provides a simple, hard-to-mess-up API integrated with the KJ event loop.
* KJ now includes [gzip bindings](https://github.com/capnproto/capnproto/blob/master/c++/src/kj/compat/gzip.h), which wrap zlib in KJ stream interfaces (sync and async).
* KJ now includes [helpers for encoding/decoding Unicode (UTF-8/UTF-16/UTF-32), base64, hex, URI-encoding, and C-escaped text](https://github.com/capnproto/capnproto/blob/master/c++/src/kj/encoding.h).
* The [`kj::Url` helper class](https://github.com/capnproto/capnproto/blob/master/c++/src/kj/compat/url.h) is provided to parse and compose URLs.
* KJ now includes [a filesystem API](https://github.com/capnproto/capnproto/blob/master/c++/src/kj/filesystem.h) which is designed to be resistant to path injection attacks, is dependency-injection-friendly to ease unit testing, is cross-platform (Unix and Windows), makes atomic file replacement easy, makes mmap easy, and [other neat features](https://github.com/capnproto/capnproto/pull/384).
* The `capnp` tool now has a `convert` command which can be used to convert between all known message encodings, such as binary, packed, text, JSON, canonical, etc. This obsoletes the old `encode` and `decode` commands.
* Many smaller tweaks and bug fixes.

<div style="text-align: center"><a class="block_link" style="color: #fff; width: 45%"
href="{{site.baseurl}}install.html">Download &raquo;</a></div>
