/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api.builder.dependency;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.jfrog.build.api.dependency.PatternArtifact;

public class PatternArtifactBuilder {
    private String artifactoryUrl;
    private String uri;
    private long size;
    private String lastModified;
    private String sha1;

    public PatternArtifact build() {
        if (this.artifactoryUrl == null) {
            throw new IllegalArgumentException("PatternArtifact must have an Artifactory URL.");
        }
        if (this.uri == null) {
            throw new IllegalArgumentException("PatternArtifact must have a URI.");
        }
        if (this.size < 0L) {
            throw new IllegalArgumentException("PatternArtifact must have a zero or positive size.");
        }
        if (this.lastModified == null) {
            throw new IllegalArgumentException("PatternArtifact must have a last Modified date.");
        }
        if (this.sha1 == null) {
            throw new IllegalArgumentException("PatternArtifact must have a sha1 checksum.");
        }
        return new PatternArtifact(this.artifactoryUrl, this.uri, this.size, this.lastModified, this.sha1);
    }

    public PatternArtifactBuilder artifactoryUrl(String artifactoryUrl) {
        this.artifactoryUrl = artifactoryUrl;
        return this;
    }

    public PatternArtifactBuilder uri(String uri) {
        this.uri = uri;
        return this;
    }

    public PatternArtifactBuilder size(long size) {
        this.size = size;
        return this;
    }

    public PatternArtifactBuilder lastModified(String lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public PatternArtifactBuilder lastModifiedDate(Date lastModified) {
        if (lastModified == null) {
            throw new IllegalArgumentException("Cannot format a null date.");
        }
        this.lastModified = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(lastModified);
        return this;
    }

    public PatternArtifactBuilder sha1(String sha1) {
        this.sha1 = sha1;
        return this;
    }
}

