// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/iam/v3/principal_access_boundary_policies_service.proto

package iampb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	_ "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for CreatePrincipalAccessBoundaryPolicyRequest method.
type CreatePrincipalAccessBoundaryPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource where this principal access boundary policy
	// will be created. Only organizations are supported.
	//
	// Format:
	//
	//	`organizations/{organization_id}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID to use for the principal access boundary policy, which
	// will become the final component of the principal access boundary policy's
	// resource name.
	//
	// This value must start with a lowercase letter followed by up to 62
	// lowercase letters, numbers, hyphens, or dots. Pattern,
	// /[a-z][a-z0-9-\.]{2,62}/.
	PrincipalAccessBoundaryPolicyId string `protobuf:"bytes,2,opt,name=principal_access_boundary_policy_id,json=principalAccessBoundaryPolicyId,proto3" json:"principal_access_boundary_policy_id,omitempty"`
	// Required. The principal access boundary policy to create.
	PrincipalAccessBoundaryPolicy *PrincipalAccessBoundaryPolicy `protobuf:"bytes,3,opt,name=principal_access_boundary_policy,json=principalAccessBoundaryPolicy,proto3" json:"principal_access_boundary_policy,omitempty"`
	// Optional. If set, validate the request and preview the creation, but do not
	// actually post it.
	ValidateOnly bool `protobuf:"varint,4,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
}

func (x *CreatePrincipalAccessBoundaryPolicyRequest) Reset() {
	*x = CreatePrincipalAccessBoundaryPolicyRequest{}
	mi := &file_google_iam_v3_principal_access_boundary_policies_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreatePrincipalAccessBoundaryPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreatePrincipalAccessBoundaryPolicyRequest) ProtoMessage() {}

func (x *CreatePrincipalAccessBoundaryPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v3_principal_access_boundary_policies_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreatePrincipalAccessBoundaryPolicyRequest.ProtoReflect.Descriptor instead.
func (*CreatePrincipalAccessBoundaryPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_v3_principal_access_boundary_policies_service_proto_rawDescGZIP(), []int{0}
}

func (x *CreatePrincipalAccessBoundaryPolicyRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreatePrincipalAccessBoundaryPolicyRequest) GetPrincipalAccessBoundaryPolicyId() string {
	if x != nil {
		return x.PrincipalAccessBoundaryPolicyId
	}
	return ""
}

func (x *CreatePrincipalAccessBoundaryPolicyRequest) GetPrincipalAccessBoundaryPolicy() *PrincipalAccessBoundaryPolicy {
	if x != nil {
		return x.PrincipalAccessBoundaryPolicy
	}
	return nil
}

func (x *CreatePrincipalAccessBoundaryPolicyRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

// Request message for GetPrincipalAccessBoundaryPolicy method.
type GetPrincipalAccessBoundaryPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the principal access boundary policy to retrieve.
	//
	// Format:
	//
	//	`organizations/{organization_id}/locations/{location}/principalAccessBoundaryPolicies/{principal_access_boundary_policy_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetPrincipalAccessBoundaryPolicyRequest) Reset() {
	*x = GetPrincipalAccessBoundaryPolicyRequest{}
	mi := &file_google_iam_v3_principal_access_boundary_policies_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetPrincipalAccessBoundaryPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetPrincipalAccessBoundaryPolicyRequest) ProtoMessage() {}

func (x *GetPrincipalAccessBoundaryPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v3_principal_access_boundary_policies_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetPrincipalAccessBoundaryPolicyRequest.ProtoReflect.Descriptor instead.
func (*GetPrincipalAccessBoundaryPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_v3_principal_access_boundary_policies_service_proto_rawDescGZIP(), []int{1}
}

func (x *GetPrincipalAccessBoundaryPolicyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for UpdatePrincipalAccessBoundaryPolicy method.
type UpdatePrincipalAccessBoundaryPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The principal access boundary policy to update.
	//
	// The principal access boundary policy's `name` field is used to identify the
	// policy to update.
	PrincipalAccessBoundaryPolicy *PrincipalAccessBoundaryPolicy `protobuf:"bytes,1,opt,name=principal_access_boundary_policy,json=principalAccessBoundaryPolicy,proto3" json:"principal_access_boundary_policy,omitempty"`
	// Optional. If set, validate the request and preview the update, but do not
	// actually post it.
	ValidateOnly bool `protobuf:"varint,2,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// Optional. The list of fields to update
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdatePrincipalAccessBoundaryPolicyRequest) Reset() {
	*x = UpdatePrincipalAccessBoundaryPolicyRequest{}
	mi := &file_google_iam_v3_principal_access_boundary_policies_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdatePrincipalAccessBoundaryPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdatePrincipalAccessBoundaryPolicyRequest) ProtoMessage() {}

func (x *UpdatePrincipalAccessBoundaryPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v3_principal_access_boundary_policies_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdatePrincipalAccessBoundaryPolicyRequest.ProtoReflect.Descriptor instead.
func (*UpdatePrincipalAccessBoundaryPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_v3_principal_access_boundary_policies_service_proto_rawDescGZIP(), []int{2}
}

func (x *UpdatePrincipalAccessBoundaryPolicyRequest) GetPrincipalAccessBoundaryPolicy() *PrincipalAccessBoundaryPolicy {
	if x != nil {
		return x.PrincipalAccessBoundaryPolicy
	}
	return nil
}

func (x *UpdatePrincipalAccessBoundaryPolicyRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *UpdatePrincipalAccessBoundaryPolicyRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// Request message for DeletePrincipalAccessBoundaryPolicy method.
type DeletePrincipalAccessBoundaryPolicyRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the principal access boundary policy to delete.
	//
	// Format:
	//
	//	`organizations/{organization_id}/locations/{location}/principalAccessBoundaryPolicies/{principal_access_boundary_policy_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The etag of the principal access boundary policy.
	// If this is provided, it must match the server's etag.
	Etag string `protobuf:"bytes,2,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. If set, validate the request and preview the deletion, but do not
	// actually post it.
	ValidateOnly bool `protobuf:"varint,3,opt,name=validate_only,json=validateOnly,proto3" json:"validate_only,omitempty"`
	// Optional. If set to true, the request will force the deletion of the policy
	// even if the policy is referenced in policy bindings.
	Force bool `protobuf:"varint,4,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeletePrincipalAccessBoundaryPolicyRequest) Reset() {
	*x = DeletePrincipalAccessBoundaryPolicyRequest{}
	mi := &file_google_iam_v3_principal_access_boundary_policies_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeletePrincipalAccessBoundaryPolicyRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeletePrincipalAccessBoundaryPolicyRequest) ProtoMessage() {}

func (x *DeletePrincipalAccessBoundaryPolicyRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v3_principal_access_boundary_policies_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeletePrincipalAccessBoundaryPolicyRequest.ProtoReflect.Descriptor instead.
func (*DeletePrincipalAccessBoundaryPolicyRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_v3_principal_access_boundary_policies_service_proto_rawDescGZIP(), []int{3}
}

func (x *DeletePrincipalAccessBoundaryPolicyRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeletePrincipalAccessBoundaryPolicyRequest) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *DeletePrincipalAccessBoundaryPolicyRequest) GetValidateOnly() bool {
	if x != nil {
		return x.ValidateOnly
	}
	return false
}

func (x *DeletePrincipalAccessBoundaryPolicyRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Request message for ListPrincipalAccessBoundaryPolicies method.
type ListPrincipalAccessBoundaryPoliciesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource, which owns the collection of principal
	// access boundary policies.
	//
	// Format:
	//
	//	`organizations/{organization_id}/locations/{location}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of principal access boundary policies to
	// return. The service may return fewer than this value.
	//
	// If unspecified, at most 50 principal access boundary policies will be
	// returned. The maximum value is 1000; values above 1000 will be coerced to
	// 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous
	// `ListPrincipalAccessBoundaryPolicies` call. Provide this to retrieve the
	// subsequent page.
	//
	// When paginating, all other parameters provided to
	// `ListPrincipalAccessBoundaryPolicies` must match the call that provided the
	// page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListPrincipalAccessBoundaryPoliciesRequest) Reset() {
	*x = ListPrincipalAccessBoundaryPoliciesRequest{}
	mi := &file_google_iam_v3_principal_access_boundary_policies_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPrincipalAccessBoundaryPoliciesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPrincipalAccessBoundaryPoliciesRequest) ProtoMessage() {}

func (x *ListPrincipalAccessBoundaryPoliciesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v3_principal_access_boundary_policies_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPrincipalAccessBoundaryPoliciesRequest.ProtoReflect.Descriptor instead.
func (*ListPrincipalAccessBoundaryPoliciesRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_v3_principal_access_boundary_policies_service_proto_rawDescGZIP(), []int{4}
}

func (x *ListPrincipalAccessBoundaryPoliciesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListPrincipalAccessBoundaryPoliciesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListPrincipalAccessBoundaryPoliciesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for ListPrincipalAccessBoundaryPolicies method.
type ListPrincipalAccessBoundaryPoliciesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The principal access boundary policies from the specified parent.
	PrincipalAccessBoundaryPolicies []*PrincipalAccessBoundaryPolicy `protobuf:"bytes,1,rep,name=principal_access_boundary_policies,json=principalAccessBoundaryPolicies,proto3" json:"principal_access_boundary_policies,omitempty"`
	// Optional. A token, which can be sent as `page_token` to retrieve the next
	// page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListPrincipalAccessBoundaryPoliciesResponse) Reset() {
	*x = ListPrincipalAccessBoundaryPoliciesResponse{}
	mi := &file_google_iam_v3_principal_access_boundary_policies_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListPrincipalAccessBoundaryPoliciesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListPrincipalAccessBoundaryPoliciesResponse) ProtoMessage() {}

func (x *ListPrincipalAccessBoundaryPoliciesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v3_principal_access_boundary_policies_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListPrincipalAccessBoundaryPoliciesResponse.ProtoReflect.Descriptor instead.
func (*ListPrincipalAccessBoundaryPoliciesResponse) Descriptor() ([]byte, []int) {
	return file_google_iam_v3_principal_access_boundary_policies_service_proto_rawDescGZIP(), []int{5}
}

func (x *ListPrincipalAccessBoundaryPoliciesResponse) GetPrincipalAccessBoundaryPolicies() []*PrincipalAccessBoundaryPolicy {
	if x != nil {
		return x.PrincipalAccessBoundaryPolicies
	}
	return nil
}

func (x *ListPrincipalAccessBoundaryPoliciesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for SearchPrincipalAccessBoundaryPolicyBindings rpc.
type SearchPrincipalAccessBoundaryPolicyBindingsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the principal access boundary policy.
	// Format:
	//
	//	`organizations/{organization_id}/locations/{location}/principalAccessBoundaryPolicies/{principal_access_boundary_policy_id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The maximum number of policy bindings to return. The service may
	// return fewer than this value.
	//
	// If unspecified, at most 50 policy bindings will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous
	// `SearchPrincipalAccessBoundaryPolicyBindingsRequest` call. Provide this to
	// retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to
	// `SearchPrincipalAccessBoundaryPolicyBindingsRequest` must match the call
	// that provided the page token.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *SearchPrincipalAccessBoundaryPolicyBindingsRequest) Reset() {
	*x = SearchPrincipalAccessBoundaryPolicyBindingsRequest{}
	mi := &file_google_iam_v3_principal_access_boundary_policies_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchPrincipalAccessBoundaryPolicyBindingsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchPrincipalAccessBoundaryPolicyBindingsRequest) ProtoMessage() {}

func (x *SearchPrincipalAccessBoundaryPolicyBindingsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v3_principal_access_boundary_policies_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchPrincipalAccessBoundaryPolicyBindingsRequest.ProtoReflect.Descriptor instead.
func (*SearchPrincipalAccessBoundaryPolicyBindingsRequest) Descriptor() ([]byte, []int) {
	return file_google_iam_v3_principal_access_boundary_policies_service_proto_rawDescGZIP(), []int{6}
}

func (x *SearchPrincipalAccessBoundaryPolicyBindingsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SearchPrincipalAccessBoundaryPolicyBindingsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchPrincipalAccessBoundaryPolicyBindingsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for SearchPrincipalAccessBoundaryPolicyBindings rpc.
type SearchPrincipalAccessBoundaryPolicyBindingsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The policy bindings that reference the specified policy.
	PolicyBindings []*PolicyBinding `protobuf:"bytes,1,rep,name=policy_bindings,json=policyBindings,proto3" json:"policy_bindings,omitempty"`
	// Optional. A token, which can be sent as `page_token` to retrieve the next
	// page. If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchPrincipalAccessBoundaryPolicyBindingsResponse) Reset() {
	*x = SearchPrincipalAccessBoundaryPolicyBindingsResponse{}
	mi := &file_google_iam_v3_principal_access_boundary_policies_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchPrincipalAccessBoundaryPolicyBindingsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchPrincipalAccessBoundaryPolicyBindingsResponse) ProtoMessage() {}

func (x *SearchPrincipalAccessBoundaryPolicyBindingsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_iam_v3_principal_access_boundary_policies_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchPrincipalAccessBoundaryPolicyBindingsResponse.ProtoReflect.Descriptor instead.
func (*SearchPrincipalAccessBoundaryPolicyBindingsResponse) Descriptor() ([]byte, []int) {
	return file_google_iam_v3_principal_access_boundary_policies_service_proto_rawDescGZIP(), []int{7}
}

func (x *SearchPrincipalAccessBoundaryPolicyBindingsResponse) GetPolicyBindings() []*PolicyBinding {
	if x != nil {
		return x.PolicyBindings
	}
	return nil
}

func (x *SearchPrincipalAccessBoundaryPolicyBindingsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_google_iam_v3_principal_access_boundary_policies_service_proto protoreflect.FileDescriptor

var file_google_iam_v3_principal_access_boundary_policies_service_proto_rawDesc = []byte{
	0x0a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x33, 0x2f,
	0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x0d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76,
	0x33, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2c, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x33, 0x2f, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61,
	0x6c, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72,
	0x79, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65,
	0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf7, 0x02, 0x0a,
	0x2a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x50, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x32, 0x12, 0x30, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61,
	0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x51, 0x0a,
	0x23, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x1f, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x64,
	0x12, 0x7a, 0x0a, 0x20, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x5f, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x70, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x72, 0x69, 0x6e, 0x63,
	0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61,
	0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x1d, 0x70,
	0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f,
	0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x28, 0x0a, 0x0d,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x22, 0x77, 0x0a, 0x27, 0x47, 0x65, 0x74, 0x50, 0x72, 0x69,
	0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e,
	0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x69, 0x6e,
	0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64,
	0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0x94, 0x02, 0x0a, 0x2a, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69,
	0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72,
	0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x7a,
	0x0a, 0x20, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x5f, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70,
	0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x1d, 0x70, 0x72, 0x69,
	0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e,
	0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x28, 0x0a, 0x0d, 0x76, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c,
	0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xd8, 0x01, 0x0a, 0x2a, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x69, 0x61, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42,
	0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x28, 0x0a, 0x0d,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6f, 0x6e, 0x6c, 0x79, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x4f, 0x6e, 0x6c, 0x79, 0x12, 0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63,
	0x65, 0x22, 0xc4, 0x01, 0x0a, 0x2a, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69,
	0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72,
	0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x50, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x12, 0x30, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x50, 0x72, 0x69,
	0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e,
	0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xd5, 0x01, 0x0a, 0x2b, 0x4c, 0x69, 0x73,
	0x74, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x79, 0x0a, 0x22, 0x70, 0x72, 0x69, 0x6e,
	0x63, 0x69, 0x70, 0x61, 0x6c, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x6f, 0x75,
	0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61,
	0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x1f, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x69, 0x65, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x22, 0xc8, 0x01, 0x0a, 0x32, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x50, 0x72, 0x69, 0x6e, 0x63,
	0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61,
	0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x38, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x32, 0x0a, 0x30, 0x69,
	0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69,
	0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa9, 0x01, 0x0a, 0x33,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x45, 0x0a, 0x0f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x62, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1c, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x0e, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x32, 0xec, 0x0e, 0x0a, 0x1f, 0x50, 0x72, 0x69, 0x6e,
	0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64,
	0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0xf7, 0x02, 0x0a, 0x23,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d,
	0x2e, 0x76, 0x33, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69,
	0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72,
	0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xf5, 0x01,
	0xca, 0x41, 0x32, 0x0a, 0x1d, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x4b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x70,
	0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f,
	0x62, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2c,
	0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x6c, 0x3a, 0x20, 0x70, 0x72, 0x69, 0x6e, 0x63,
	0x69, 0x70, 0x61, 0x6c, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x6f, 0x75, 0x6e,
	0x64, 0x61, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x48, 0x2f, 0x76, 0x33,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0xe1, 0x01, 0x0a, 0x20, 0x47, 0x65, 0x74, 0x50, 0x72, 0x69,
	0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e,
	0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x36, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x47, 0x65, 0x74, 0x50, 0x72,
	0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75,
	0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e,
	0x76, 0x33, 0x2e, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x22, 0x57, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x12,
	0x48, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xfa, 0x02, 0x0a, 0x23, 0x55, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76,
	0x33, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61,
	0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xf8, 0x01, 0xca, 0x41,
	0x32, 0x0a, 0x1d, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64,
	0x61, 0x74, 0x61, 0xda, 0x41, 0x2c, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x5f,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61,
	0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x8d, 0x01, 0x3a, 0x20, 0x70, 0x72, 0x69, 0x6e, 0x63,
	0x69, 0x70, 0x61, 0x6c, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x62, 0x6f, 0x75, 0x6e,
	0x64, 0x61, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x32, 0x69, 0x2f, 0x76, 0x33,
	0x2f, 0x7b, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x5f, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x5f, 0x70, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x86, 0x02, 0x0a, 0x23, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x39,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x84, 0x01, 0xca, 0x41, 0x2a, 0x0a, 0x15,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x45, 0x6d, 0x70, 0x74, 0x79, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x2a, 0x48, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69,
	0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e,
	0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x12,
	0xf7, 0x01, 0x0a, 0x23, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61,
	0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x69, 0x6e,
	0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64,
	0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e,
	0x76, 0x33, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x59,
	0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x4a, 0x12,
	0x48, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69,
	0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72,
	0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x12, 0xa2, 0x02, 0x0a, 0x2b, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42,
	0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e,
	0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x42, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x2e, 0x53, 0x65, 0x61,
	0x72, 0x63, 0x68, 0x50, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79,
	0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x6c, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x5f, 0x12,
	0x5d, 0x2f, 0x76, 0x33, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c,
	0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x1a, 0x46,
	0xca, 0x41, 0x12, 0x69, 0x61, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f,
	0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x99, 0x01, 0x0a, 0x11, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x33, 0x42, 0x2b, 0x50, 0x72,
	0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x6f, 0x75,
	0x6e, 0x64, 0x61, 0x72, 0x79, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x29, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f,
	0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x33, 0x2f, 0x69, 0x61, 0x6d, 0x70, 0x62,
	0x3b, 0x69, 0x61, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x49, 0x61, 0x6d, 0x2e, 0x56, 0x33, 0xca, 0x02, 0x13, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x49, 0x61, 0x6d, 0x5c,
	0x56, 0x33, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_iam_v3_principal_access_boundary_policies_service_proto_rawDescOnce sync.Once
	file_google_iam_v3_principal_access_boundary_policies_service_proto_rawDescData = file_google_iam_v3_principal_access_boundary_policies_service_proto_rawDesc
)

func file_google_iam_v3_principal_access_boundary_policies_service_proto_rawDescGZIP() []byte {
	file_google_iam_v3_principal_access_boundary_policies_service_proto_rawDescOnce.Do(func() {
		file_google_iam_v3_principal_access_boundary_policies_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_iam_v3_principal_access_boundary_policies_service_proto_rawDescData)
	})
	return file_google_iam_v3_principal_access_boundary_policies_service_proto_rawDescData
}

var file_google_iam_v3_principal_access_boundary_policies_service_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_iam_v3_principal_access_boundary_policies_service_proto_goTypes = []any{
	(*CreatePrincipalAccessBoundaryPolicyRequest)(nil),          // 0: google.iam.v3.CreatePrincipalAccessBoundaryPolicyRequest
	(*GetPrincipalAccessBoundaryPolicyRequest)(nil),             // 1: google.iam.v3.GetPrincipalAccessBoundaryPolicyRequest
	(*UpdatePrincipalAccessBoundaryPolicyRequest)(nil),          // 2: google.iam.v3.UpdatePrincipalAccessBoundaryPolicyRequest
	(*DeletePrincipalAccessBoundaryPolicyRequest)(nil),          // 3: google.iam.v3.DeletePrincipalAccessBoundaryPolicyRequest
	(*ListPrincipalAccessBoundaryPoliciesRequest)(nil),          // 4: google.iam.v3.ListPrincipalAccessBoundaryPoliciesRequest
	(*ListPrincipalAccessBoundaryPoliciesResponse)(nil),         // 5: google.iam.v3.ListPrincipalAccessBoundaryPoliciesResponse
	(*SearchPrincipalAccessBoundaryPolicyBindingsRequest)(nil),  // 6: google.iam.v3.SearchPrincipalAccessBoundaryPolicyBindingsRequest
	(*SearchPrincipalAccessBoundaryPolicyBindingsResponse)(nil), // 7: google.iam.v3.SearchPrincipalAccessBoundaryPolicyBindingsResponse
	(*PrincipalAccessBoundaryPolicy)(nil),                       // 8: google.iam.v3.PrincipalAccessBoundaryPolicy
	(*fieldmaskpb.FieldMask)(nil),                               // 9: google.protobuf.FieldMask
	(*PolicyBinding)(nil),                                       // 10: google.iam.v3.PolicyBinding
	(*longrunningpb.Operation)(nil),                             // 11: google.longrunning.Operation
}
var file_google_iam_v3_principal_access_boundary_policies_service_proto_depIdxs = []int32{
	8,  // 0: google.iam.v3.CreatePrincipalAccessBoundaryPolicyRequest.principal_access_boundary_policy:type_name -> google.iam.v3.PrincipalAccessBoundaryPolicy
	8,  // 1: google.iam.v3.UpdatePrincipalAccessBoundaryPolicyRequest.principal_access_boundary_policy:type_name -> google.iam.v3.PrincipalAccessBoundaryPolicy
	9,  // 2: google.iam.v3.UpdatePrincipalAccessBoundaryPolicyRequest.update_mask:type_name -> google.protobuf.FieldMask
	8,  // 3: google.iam.v3.ListPrincipalAccessBoundaryPoliciesResponse.principal_access_boundary_policies:type_name -> google.iam.v3.PrincipalAccessBoundaryPolicy
	10, // 4: google.iam.v3.SearchPrincipalAccessBoundaryPolicyBindingsResponse.policy_bindings:type_name -> google.iam.v3.PolicyBinding
	0,  // 5: google.iam.v3.PrincipalAccessBoundaryPolicies.CreatePrincipalAccessBoundaryPolicy:input_type -> google.iam.v3.CreatePrincipalAccessBoundaryPolicyRequest
	1,  // 6: google.iam.v3.PrincipalAccessBoundaryPolicies.GetPrincipalAccessBoundaryPolicy:input_type -> google.iam.v3.GetPrincipalAccessBoundaryPolicyRequest
	2,  // 7: google.iam.v3.PrincipalAccessBoundaryPolicies.UpdatePrincipalAccessBoundaryPolicy:input_type -> google.iam.v3.UpdatePrincipalAccessBoundaryPolicyRequest
	3,  // 8: google.iam.v3.PrincipalAccessBoundaryPolicies.DeletePrincipalAccessBoundaryPolicy:input_type -> google.iam.v3.DeletePrincipalAccessBoundaryPolicyRequest
	4,  // 9: google.iam.v3.PrincipalAccessBoundaryPolicies.ListPrincipalAccessBoundaryPolicies:input_type -> google.iam.v3.ListPrincipalAccessBoundaryPoliciesRequest
	6,  // 10: google.iam.v3.PrincipalAccessBoundaryPolicies.SearchPrincipalAccessBoundaryPolicyBindings:input_type -> google.iam.v3.SearchPrincipalAccessBoundaryPolicyBindingsRequest
	11, // 11: google.iam.v3.PrincipalAccessBoundaryPolicies.CreatePrincipalAccessBoundaryPolicy:output_type -> google.longrunning.Operation
	8,  // 12: google.iam.v3.PrincipalAccessBoundaryPolicies.GetPrincipalAccessBoundaryPolicy:output_type -> google.iam.v3.PrincipalAccessBoundaryPolicy
	11, // 13: google.iam.v3.PrincipalAccessBoundaryPolicies.UpdatePrincipalAccessBoundaryPolicy:output_type -> google.longrunning.Operation
	11, // 14: google.iam.v3.PrincipalAccessBoundaryPolicies.DeletePrincipalAccessBoundaryPolicy:output_type -> google.longrunning.Operation
	5,  // 15: google.iam.v3.PrincipalAccessBoundaryPolicies.ListPrincipalAccessBoundaryPolicies:output_type -> google.iam.v3.ListPrincipalAccessBoundaryPoliciesResponse
	7,  // 16: google.iam.v3.PrincipalAccessBoundaryPolicies.SearchPrincipalAccessBoundaryPolicyBindings:output_type -> google.iam.v3.SearchPrincipalAccessBoundaryPolicyBindingsResponse
	11, // [11:17] is the sub-list for method output_type
	5,  // [5:11] is the sub-list for method input_type
	5,  // [5:5] is the sub-list for extension type_name
	5,  // [5:5] is the sub-list for extension extendee
	0,  // [0:5] is the sub-list for field type_name
}

func init() { file_google_iam_v3_principal_access_boundary_policies_service_proto_init() }
func file_google_iam_v3_principal_access_boundary_policies_service_proto_init() {
	if File_google_iam_v3_principal_access_boundary_policies_service_proto != nil {
		return
	}
	file_google_iam_v3_operation_metadata_proto_init()
	file_google_iam_v3_policy_binding_resources_proto_init()
	file_google_iam_v3_principal_access_boundary_policy_resources_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_iam_v3_principal_access_boundary_policies_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_iam_v3_principal_access_boundary_policies_service_proto_goTypes,
		DependencyIndexes: file_google_iam_v3_principal_access_boundary_policies_service_proto_depIdxs,
		MessageInfos:      file_google_iam_v3_principal_access_boundary_policies_service_proto_msgTypes,
	}.Build()
	File_google_iam_v3_principal_access_boundary_policies_service_proto = out.File
	file_google_iam_v3_principal_access_boundary_policies_service_proto_rawDesc = nil
	file_google_iam_v3_principal_access_boundary_policies_service_proto_goTypes = nil
	file_google_iam_v3_principal_access_boundary_policies_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// PrincipalAccessBoundaryPoliciesClient is the client API for PrincipalAccessBoundaryPolicies service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PrincipalAccessBoundaryPoliciesClient interface {
	// Creates a principal access boundary policy, and returns a long running
	// operation.
	CreatePrincipalAccessBoundaryPolicy(ctx context.Context, in *CreatePrincipalAccessBoundaryPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets a principal access boundary policy.
	GetPrincipalAccessBoundaryPolicy(ctx context.Context, in *GetPrincipalAccessBoundaryPolicyRequest, opts ...grpc.CallOption) (*PrincipalAccessBoundaryPolicy, error)
	// Updates a principal access boundary policy.
	UpdatePrincipalAccessBoundaryPolicy(ctx context.Context, in *UpdatePrincipalAccessBoundaryPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a principal access boundary policy.
	DeletePrincipalAccessBoundaryPolicy(ctx context.Context, in *DeletePrincipalAccessBoundaryPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists principal access boundary policies.
	ListPrincipalAccessBoundaryPolicies(ctx context.Context, in *ListPrincipalAccessBoundaryPoliciesRequest, opts ...grpc.CallOption) (*ListPrincipalAccessBoundaryPoliciesResponse, error)
	// Returns all policy bindings that bind a specific policy if a user has
	// searchPolicyBindings permission on that policy.
	SearchPrincipalAccessBoundaryPolicyBindings(ctx context.Context, in *SearchPrincipalAccessBoundaryPolicyBindingsRequest, opts ...grpc.CallOption) (*SearchPrincipalAccessBoundaryPolicyBindingsResponse, error)
}

type principalAccessBoundaryPoliciesClient struct {
	cc grpc.ClientConnInterface
}

func NewPrincipalAccessBoundaryPoliciesClient(cc grpc.ClientConnInterface) PrincipalAccessBoundaryPoliciesClient {
	return &principalAccessBoundaryPoliciesClient{cc}
}

func (c *principalAccessBoundaryPoliciesClient) CreatePrincipalAccessBoundaryPolicy(ctx context.Context, in *CreatePrincipalAccessBoundaryPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.iam.v3.PrincipalAccessBoundaryPolicies/CreatePrincipalAccessBoundaryPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *principalAccessBoundaryPoliciesClient) GetPrincipalAccessBoundaryPolicy(ctx context.Context, in *GetPrincipalAccessBoundaryPolicyRequest, opts ...grpc.CallOption) (*PrincipalAccessBoundaryPolicy, error) {
	out := new(PrincipalAccessBoundaryPolicy)
	err := c.cc.Invoke(ctx, "/google.iam.v3.PrincipalAccessBoundaryPolicies/GetPrincipalAccessBoundaryPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *principalAccessBoundaryPoliciesClient) UpdatePrincipalAccessBoundaryPolicy(ctx context.Context, in *UpdatePrincipalAccessBoundaryPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.iam.v3.PrincipalAccessBoundaryPolicies/UpdatePrincipalAccessBoundaryPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *principalAccessBoundaryPoliciesClient) DeletePrincipalAccessBoundaryPolicy(ctx context.Context, in *DeletePrincipalAccessBoundaryPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.iam.v3.PrincipalAccessBoundaryPolicies/DeletePrincipalAccessBoundaryPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *principalAccessBoundaryPoliciesClient) ListPrincipalAccessBoundaryPolicies(ctx context.Context, in *ListPrincipalAccessBoundaryPoliciesRequest, opts ...grpc.CallOption) (*ListPrincipalAccessBoundaryPoliciesResponse, error) {
	out := new(ListPrincipalAccessBoundaryPoliciesResponse)
	err := c.cc.Invoke(ctx, "/google.iam.v3.PrincipalAccessBoundaryPolicies/ListPrincipalAccessBoundaryPolicies", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *principalAccessBoundaryPoliciesClient) SearchPrincipalAccessBoundaryPolicyBindings(ctx context.Context, in *SearchPrincipalAccessBoundaryPolicyBindingsRequest, opts ...grpc.CallOption) (*SearchPrincipalAccessBoundaryPolicyBindingsResponse, error) {
	out := new(SearchPrincipalAccessBoundaryPolicyBindingsResponse)
	err := c.cc.Invoke(ctx, "/google.iam.v3.PrincipalAccessBoundaryPolicies/SearchPrincipalAccessBoundaryPolicyBindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PrincipalAccessBoundaryPoliciesServer is the server API for PrincipalAccessBoundaryPolicies service.
type PrincipalAccessBoundaryPoliciesServer interface {
	// Creates a principal access boundary policy, and returns a long running
	// operation.
	CreatePrincipalAccessBoundaryPolicy(context.Context, *CreatePrincipalAccessBoundaryPolicyRequest) (*longrunningpb.Operation, error)
	// Gets a principal access boundary policy.
	GetPrincipalAccessBoundaryPolicy(context.Context, *GetPrincipalAccessBoundaryPolicyRequest) (*PrincipalAccessBoundaryPolicy, error)
	// Updates a principal access boundary policy.
	UpdatePrincipalAccessBoundaryPolicy(context.Context, *UpdatePrincipalAccessBoundaryPolicyRequest) (*longrunningpb.Operation, error)
	// Deletes a principal access boundary policy.
	DeletePrincipalAccessBoundaryPolicy(context.Context, *DeletePrincipalAccessBoundaryPolicyRequest) (*longrunningpb.Operation, error)
	// Lists principal access boundary policies.
	ListPrincipalAccessBoundaryPolicies(context.Context, *ListPrincipalAccessBoundaryPoliciesRequest) (*ListPrincipalAccessBoundaryPoliciesResponse, error)
	// Returns all policy bindings that bind a specific policy if a user has
	// searchPolicyBindings permission on that policy.
	SearchPrincipalAccessBoundaryPolicyBindings(context.Context, *SearchPrincipalAccessBoundaryPolicyBindingsRequest) (*SearchPrincipalAccessBoundaryPolicyBindingsResponse, error)
}

// UnimplementedPrincipalAccessBoundaryPoliciesServer can be embedded to have forward compatible implementations.
type UnimplementedPrincipalAccessBoundaryPoliciesServer struct {
}

func (*UnimplementedPrincipalAccessBoundaryPoliciesServer) CreatePrincipalAccessBoundaryPolicy(context.Context, *CreatePrincipalAccessBoundaryPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePrincipalAccessBoundaryPolicy not implemented")
}
func (*UnimplementedPrincipalAccessBoundaryPoliciesServer) GetPrincipalAccessBoundaryPolicy(context.Context, *GetPrincipalAccessBoundaryPolicyRequest) (*PrincipalAccessBoundaryPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPrincipalAccessBoundaryPolicy not implemented")
}
func (*UnimplementedPrincipalAccessBoundaryPoliciesServer) UpdatePrincipalAccessBoundaryPolicy(context.Context, *UpdatePrincipalAccessBoundaryPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePrincipalAccessBoundaryPolicy not implemented")
}
func (*UnimplementedPrincipalAccessBoundaryPoliciesServer) DeletePrincipalAccessBoundaryPolicy(context.Context, *DeletePrincipalAccessBoundaryPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePrincipalAccessBoundaryPolicy not implemented")
}
func (*UnimplementedPrincipalAccessBoundaryPoliciesServer) ListPrincipalAccessBoundaryPolicies(context.Context, *ListPrincipalAccessBoundaryPoliciesRequest) (*ListPrincipalAccessBoundaryPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPrincipalAccessBoundaryPolicies not implemented")
}
func (*UnimplementedPrincipalAccessBoundaryPoliciesServer) SearchPrincipalAccessBoundaryPolicyBindings(context.Context, *SearchPrincipalAccessBoundaryPolicyBindingsRequest) (*SearchPrincipalAccessBoundaryPolicyBindingsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchPrincipalAccessBoundaryPolicyBindings not implemented")
}

func RegisterPrincipalAccessBoundaryPoliciesServer(s *grpc.Server, srv PrincipalAccessBoundaryPoliciesServer) {
	s.RegisterService(&_PrincipalAccessBoundaryPolicies_serviceDesc, srv)
}

func _PrincipalAccessBoundaryPolicies_CreatePrincipalAccessBoundaryPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePrincipalAccessBoundaryPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrincipalAccessBoundaryPoliciesServer).CreatePrincipalAccessBoundaryPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.v3.PrincipalAccessBoundaryPolicies/CreatePrincipalAccessBoundaryPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrincipalAccessBoundaryPoliciesServer).CreatePrincipalAccessBoundaryPolicy(ctx, req.(*CreatePrincipalAccessBoundaryPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrincipalAccessBoundaryPolicies_GetPrincipalAccessBoundaryPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPrincipalAccessBoundaryPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrincipalAccessBoundaryPoliciesServer).GetPrincipalAccessBoundaryPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.v3.PrincipalAccessBoundaryPolicies/GetPrincipalAccessBoundaryPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrincipalAccessBoundaryPoliciesServer).GetPrincipalAccessBoundaryPolicy(ctx, req.(*GetPrincipalAccessBoundaryPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrincipalAccessBoundaryPolicies_UpdatePrincipalAccessBoundaryPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePrincipalAccessBoundaryPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrincipalAccessBoundaryPoliciesServer).UpdatePrincipalAccessBoundaryPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.v3.PrincipalAccessBoundaryPolicies/UpdatePrincipalAccessBoundaryPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrincipalAccessBoundaryPoliciesServer).UpdatePrincipalAccessBoundaryPolicy(ctx, req.(*UpdatePrincipalAccessBoundaryPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrincipalAccessBoundaryPolicies_DeletePrincipalAccessBoundaryPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePrincipalAccessBoundaryPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrincipalAccessBoundaryPoliciesServer).DeletePrincipalAccessBoundaryPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.v3.PrincipalAccessBoundaryPolicies/DeletePrincipalAccessBoundaryPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrincipalAccessBoundaryPoliciesServer).DeletePrincipalAccessBoundaryPolicy(ctx, req.(*DeletePrincipalAccessBoundaryPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrincipalAccessBoundaryPolicies_ListPrincipalAccessBoundaryPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPrincipalAccessBoundaryPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrincipalAccessBoundaryPoliciesServer).ListPrincipalAccessBoundaryPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.v3.PrincipalAccessBoundaryPolicies/ListPrincipalAccessBoundaryPolicies",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrincipalAccessBoundaryPoliciesServer).ListPrincipalAccessBoundaryPolicies(ctx, req.(*ListPrincipalAccessBoundaryPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrincipalAccessBoundaryPolicies_SearchPrincipalAccessBoundaryPolicyBindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchPrincipalAccessBoundaryPolicyBindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrincipalAccessBoundaryPoliciesServer).SearchPrincipalAccessBoundaryPolicyBindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.iam.v3.PrincipalAccessBoundaryPolicies/SearchPrincipalAccessBoundaryPolicyBindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrincipalAccessBoundaryPoliciesServer).SearchPrincipalAccessBoundaryPolicyBindings(ctx, req.(*SearchPrincipalAccessBoundaryPolicyBindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _PrincipalAccessBoundaryPolicies_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.iam.v3.PrincipalAccessBoundaryPolicies",
	HandlerType: (*PrincipalAccessBoundaryPoliciesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreatePrincipalAccessBoundaryPolicy",
			Handler:    _PrincipalAccessBoundaryPolicies_CreatePrincipalAccessBoundaryPolicy_Handler,
		},
		{
			MethodName: "GetPrincipalAccessBoundaryPolicy",
			Handler:    _PrincipalAccessBoundaryPolicies_GetPrincipalAccessBoundaryPolicy_Handler,
		},
		{
			MethodName: "UpdatePrincipalAccessBoundaryPolicy",
			Handler:    _PrincipalAccessBoundaryPolicies_UpdatePrincipalAccessBoundaryPolicy_Handler,
		},
		{
			MethodName: "DeletePrincipalAccessBoundaryPolicy",
			Handler:    _PrincipalAccessBoundaryPolicies_DeletePrincipalAccessBoundaryPolicy_Handler,
		},
		{
			MethodName: "ListPrincipalAccessBoundaryPolicies",
			Handler:    _PrincipalAccessBoundaryPolicies_ListPrincipalAccessBoundaryPolicies_Handler,
		},
		{
			MethodName: "SearchPrincipalAccessBoundaryPolicyBindings",
			Handler:    _PrincipalAccessBoundaryPolicies_SearchPrincipalAccessBoundaryPolicyBindings_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/iam/v3/principal_access_boundary_policies_service.proto",
}
