/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * callbacks.c
 * Copyright (C) Carles Sentis 2010 <realtimesunlightwallpaper.gtk@gmail.com>
 * 
 * gtk-sunlight is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * gtk-sunlight is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
 
#include "support.h"

void button_sensitive (ChData *data, gboolean sensitive);
void scale_box_sensitive (ChData *data, gboolean sensitive);
void get_and_set_options (ChData *data);
gshort get_map_position (ChData *data);
gboolean is_peters (ChData *data);
gshort move_earth_true (ChData *data);

void button_sensitive (ChData *data, gboolean sensitive){
	gtk_widget_set_sensitive (GTK_WIDGET (data->rad.rd_mercator), sensitive);
	gtk_widget_set_sensitive (GTK_WIDGET (data->rad.rd_peters), sensitive);
	gtk_widget_set_sensitive (GTK_WIDGET (data->rad.rd_mollweide), sensitive);
	gtk_widget_set_sensitive (GTK_WIDGET (data->rad.rd_equirectangular), sensitive);
}

void scale_box_sensitive (ChData *data, gboolean sensitive){
	gtk_widget_set_sensitive (data->adv.box_advanced, sensitive);
}

void get_and_set_options (ChData *data){
	gchar *get_option1 = g_strconcat("gconftool-2 --get /desktop/gnome/background/picture_options > ", g_get_home_dir(), DIR_PROJECT, "/tmpfile.txt", NULL);
	gchar *get_option2 = g_strconcat("gconftool-2 --get /desktop/gnome/background/color_shading_type > ", g_get_home_dir(), DIR_PROJECT, "/tmpfile.txt", NULL);
	gchar *get_option3 = g_strconcat("gconftool-2 --get /desktop/gnome/background/primary_color > ", g_get_home_dir(), DIR_PROJECT, "/tmpfile.txt", NULL);
	gchar *get_option4 = g_strconcat("gconftool-2 --get /desktop/gnome/background/secondary_color > ", g_get_home_dir(), DIR_PROJECT, "/tmpfile.txt", NULL);

	gchar *option_file = g_strconcat(g_get_home_dir(), DIR_PROJECT, "/tmpfile.txt", NULL);
	GError     	*error = NULL;
	gchar 		*contents;
	gsize 		length;
	gchar 		*options;
	GdkColor	new_color;
	gshort i;
	
	system(get_option1);

	if (g_file_test(option_file, G_FILE_TEST_EXISTS)){
		if (g_file_get_contents (option_file, &contents, &length, &error)){
			for (  i = 0; i < length; ++i )
    		{
        		if ( contents[i] == '\n' )
        	 		contents[i] = '\0';
		    }				
			if (0 == g_strcmp0 ("wallpaper", contents)){
				gtk_combo_box_set_active (data->sys.cmb_style, 0);
			}else if (0 == g_strcmp0 ("zoom", contents)){
				gtk_combo_box_set_active (data->sys.cmb_style, 1);
			}else if (0 == g_strcmp0 ("centered", contents)){
				gtk_combo_box_set_active (data->sys.cmb_style, 2);
			}else if (0 == g_strcmp0 ("scaled", contents)){
				gtk_combo_box_set_active (data->sys.cmb_style, 3);
			}else if (0 == g_strcmp0 ("stretched", contents)){
				gtk_combo_box_set_active (data->sys.cmb_style, 4);
			}else if (0 == g_strcmp0 ("spanned", contents)){
				gtk_combo_box_set_active (data->sys.cmb_style, 5);
			}
		}
	}

	system(get_option2);

	if (g_file_test(option_file, G_FILE_TEST_EXISTS)){
		if (g_file_get_contents (option_file, &contents, &length, &error)){
			for (  i = 0; i < length; ++i )
    		{
        		if ( contents[i] == '\n' )
        			contents[i] = '\0';
		    }			
			if (0 == g_strcmp0 ("solid", contents)){
				gtk_combo_box_set_active (data->sys.cmb_colors, 0);
			}else if (0 == g_strcmp0 ("horizontal-gradient", contents)){
				gtk_combo_box_set_active (data->sys.cmb_colors, 1);
			}else if (0 == g_strcmp0 ("vertical-gradient", contents)){
				gtk_combo_box_set_active (data->sys.cmb_colors, 2);
			}
		}
	}
	
	system(get_option3);

	if (g_file_test(option_file, G_FILE_TEST_EXISTS)){
		if (g_file_get_contents (option_file, &contents, &length, &error)){
			for (  i = 0; i < length; ++i )
    		{
        		if ( contents[i] == '\n' )
        			contents[i] = '\0';
		    }	
			gdk_color_parse (contents, &new_color);
			gtk_color_button_set_color (data->sys.color_picker_one, &new_color);
		}
	}

	system(get_option4);

	if (g_file_test(option_file, G_FILE_TEST_EXISTS)){
		if (g_file_get_contents (option_file, &contents, &length, &error)){
			for (  i = 0; i < length; ++i )
    		{
        		if ( contents[i] == '\n' )
        			contents[i] = '\0';
		    }	
			gdk_color_parse (contents, &new_color);
			gtk_color_button_set_color (data->sys.color_picker_two, &new_color);
		}
	}
	g_free(option_file);
	g_free(get_option1);
	g_free(get_option2);
	g_free(get_option3);
	g_free(get_option4);
	g_free(contents);
}

gshort get_map_position (ChData *data){
	gshort scale_position, position, new_position, move_scale;
	
	scale_position = 0;
	
	if ((data->var.gb_move_map == TRUE) && (data->var.gb_apply_clicked == FALSE)){
		move_scale = move_earth_true(data);
		for (position = move_scale; position < 24; position++) scale_position++;
	}else{for (position = (int)data->var.gd_map_scale; position < 24; position++) scale_position++;}

	if(is_peters(data)){
		if (scale_position <= 24) new_position = (int)(1 + 29.428571429 * (24 - scale_position));
		else new_position = (int)(29.428571429 * (73 - scale_position) - 1);

	}else{
		if (scale_position <= 24) new_position = (int)(1 + 32.653061224 * (24 - scale_position));
		else new_position = (int)(32.653061224 * (73 - scale_position));
	}
	
	DBG (("scale_position: %d, new_position: %d\n", scale_position, new_position));
	return new_position;
}

gboolean is_peters (ChData *data){
	if ((data->var.gi_rd1 == 1) && (data->var.gi_rd2 == 2)) return TRUE;
	else return FALSE;
}

gshort move_earth_true (ChData *data){
	gdouble gd_hours;
	gshort gs_diff_time, gs_scale_position;
	
	time (&data->var.tm_current);
	gd_hours = difftime(data->var.tm_current, data->var.tm_saved) / 3600;
	gd_hours = gd_hours - (int)(gd_hours / 24) * 24;
	gs_diff_time = (int)gd_hours * 2;
	DBG (("diff_time: %d, difftime: %.2f\n", gs_diff_time, difftime(data->var.tm_current, data->var.tm_saved) / 3600));
	if((gd_hours - (int)gd_hours) > 0.30) gs_diff_time++;
	DBG (("diff_time: %d, hours: %.2f, hours: %d\n", gs_diff_time, gd_hours, (int)gd_hours));
	gs_scale_position = (int)data->var.gd_map_scale;
	
	if((gs_scale_position + gs_diff_time) <= 24) gs_scale_position += gs_diff_time;
	else{gs_scale_position = -25 + (gs_diff_time - (24 - abs(gs_scale_position)));}
	
	// DBG (("diff_time: %d, hours: %.2f, hours: %d\n", diff_time, hours, (int)hours));

	DBG (("saved time:   %scurrent time: %s", ctime(&data->var.tm_saved), ctime(&data->var.tm_current)));
	DBG (("diff_time: %d, scale_position: %d\n", gs_diff_time, gs_scale_position));
	
	return gs_scale_position;
}
