/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * callbacks.c
 * Copyright (C) Carles Sentis 2010 <realtimesunlightwallpaper.gtk@gmail.com>
 * 
 * gtk-sunlight is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * gtk-sunlight is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
 
 /* Todo:
  * 
  * - if map 0.0 not do any mogrify etc
  * - if no network connection
  * - Select picture if no network connection
  * - Error Checking for maps
  * 
  */

#include "support.h"

void change_wallpaper (ChData *data);
gpointer create_progressbar_window (ChData *data);
gboolean update_progress(gpointer data);
gpointer async_lengthy_func(gpointer data);

/***************************************
	Window Callbacks
***************************************/
void on_main_window_show (GtkWidget *widget, ChData *data){
	gchar *s_filename;
	gchar *s_path_startup = g_strconcat(g_get_home_dir(), "/.config/autostart/", "sunlight.desktop", NULL);
	gshort gs_scale_position, gs_cnt;
	
	scale_box_sensitive (data, FALSE);
	
	gtk_file_chooser_set_current_folder (GTK_FILE_CHOOSER (data->offline.file_offline), g_get_home_dir());
	gtk_file_filter_add_mime_type       (data->offline.filter_offline, "image/*");
	if(data->var.gb_offline == TRUE){
		gtk_toggle_button_set_active ((data->offline.chk_offline), TRUE);
	}else{
		gtk_widget_set_sensitive (GTK_WIDGET (data->offline.box_offline), FALSE);
	}

	switch(data->var.gi_rd1){
		case 1:	switch (data->var.gi_rd2){
					case 1:	s_filename = "/usr/share/sunlight/images/mercator_small.jpg";
							gtk_toggle_button_set_active ((data->rad.rd_mercator), TRUE);
							scale_box_sensitive (data, TRUE);
							data->var.gi_map_height = 887;
							break;
					case 2: s_filename = "/usr/share/sunlight/images/peters_small.jpg";
							gtk_toggle_button_set_active ((data->rad.rd_peters), TRUE);
							scale_box_sensitive (data, TRUE);
							data->var.gi_map_height = 710;
							break;
					case 3:	s_filename = "/usr/share/sunlight/images/mollweide_small.jpg";
							gtk_toggle_button_set_active ((data->rad.rd_mollweide), TRUE);
							break;		
					case 4:	s_filename = "/usr/share/sunlight/images/equirectangular_small.jpg";
							gtk_toggle_button_set_active ((data->rad.rd_equirectangular), TRUE);
							scale_box_sensitive (data, TRUE);
							data->var.gi_map_height = 660;
							break;
				}
				break;
		case 2:	s_filename = "/usr/share/sunlight/images/dawntodusk_small.jpg";
				gtk_toggle_button_set_active ((data->rad.rd_realistic), TRUE);
				break;
		case 3:	s_filename = "/usr/share/sunlight/images/moon_small.jpg";
				gtk_toggle_button_set_active ((data->rad.rd_moon), TRUE);
				break;
	}
	gtk_image_set_from_file (data->main_image, s_filename);
	
	if (g_file_test(s_path_startup, G_FILE_TEST_EXISTS))
		gtk_toggle_button_set_active ((data->chk_start_up), TRUE);
		
	if (data->var.gb_move_map == TRUE){
		gtk_toggle_button_set_active ((data->adv.chk_move_map), TRUE);
		gs_scale_position = move_earth_true(data);
		g_print("gs_scale_position: %d\n", gs_scale_position);
		//for (gs_cnt = gs_scale_position; gs_cnt < 24; gs_cnt++) gs_scale_position++;
		gtk_adjustment_set_value (data->adv.hscale_adj, (double)gs_scale_position);
		g_print("gs_scale_position: %d\n", gs_scale_position);
	}else
		gtk_adjustment_set_value (data->adv.hscale_adj, data->var.gd_map_scale);
		
	if ((data->var.gd_map_scale != 0) || (data->var.gb_move_map == TRUE))
		gtk_expander_set_expanded ((data->adv.exp_advanced), TRUE);
	
	get_and_set_options(data);

    g_free(s_path_startup);
}

void on_main_window_destroy (GtkWidget *widget, ChData *data){
	guint32 time_out;
	if(data->var.gi_rd1 != 3)
		time_out = g_timeout_add(1800000, (GSourceFunc) change_wallpaper, data);
	else
		time_out = g_timeout_add(86400000, (GSourceFunc) change_wallpaper, data);
}

/*******************************************************
	Window Buttons
*******************************************************/
void cmd_apply_clicked (GtkButton *button, ChData *data){
	gchar *s_ping = "ping -c 1 www.google.com";
	
	data->var.gb_apply_clicked = TRUE;
	
	if(system(s_ping)){
		DBG (("Not Connected"));
		gint result = gtk_dialog_run (GTK_DIALOG (data->mes.message_dialog));
		//switch (result)
		//{
			//case GTK_RESPONSE_OK:
					//DBG (("hello"));
					//break;
			//default:
					//DBG (("hello2"));
			//break;
		//}
		gtk_widget_destroy (data->mes.message_dialog);
	}else{
		change_wallpaper (data);
	}
}

void cmd_ok_clicked ( GtkButton *button, ChData *data){
	guint32 time_out;
	gshort gs_tmp_move_map;
	gshort gs_tmp_offline;
	gchar *s_contents = g_malloc(1002);
	gchar *s_fname = g_strconcat(g_get_home_dir(), DIR_PROJECT, "/sunlight_options", NULL);
	data->var.gb_apply_clicked = FALSE;
		
	gtk_widget_hide(data->main_window);
	
	if (data->var.gb_move_map == TRUE) gs_tmp_move_map = 0;
	else gs_tmp_move_map = 1;
	
	if (data->var.gb_offline == TRUE) gs_tmp_offline = 0;
	else gs_tmp_offline = 1;
	
	time(&data->var.tm_saved);
	
	/*Saving variables to a file under DIR_PROJECT*/
	snprintf(s_contents, 1000, "%d %d %d %d %d %ld", data->var.gi_rd1, data->var.gi_rd2, (int)data->var.gd_map_scale, gs_tmp_move_map, gs_tmp_offline, data->var.tm_saved);
	
	if (g_file_set_contents(s_fname, s_contents, -1, NULL))
			g_print("sunlight_options created\n");
	else g_print("no sunlight_options file created\n");
	
	change_wallpaper (data);
	if(data->var.gi_rd1 != 3)
		time_out = g_timeout_add(1800000, (GSourceFunc) change_wallpaper, data);
	else
		time_out = g_timeout_add(86400000, (GSourceFunc) change_wallpaper, data);
	
	g_free(s_contents);
	g_free(s_fname);
}

/*******************************************************
	Changing Wallpaper Function
*******************************************************/
void change_wallpaper (ChData *data){
	data->var.gl_file_time = time(NULL);
	
	gchar *s_dir_project = g_strconcat(g_get_home_dir(), DIR_PROJECT, NULL);
	gchar *s_dir_wallpapers = g_strconcat(g_get_home_dir(), DIR_WALLPAPERS, NULL);
	gchar *s_fname = g_strconcat(s_dir_project, "/get_image.sh", NULL);
	gchar *s_fname2 = g_strconcat(s_dir_project, "/file_time", NULL);
	gchar *s_file_time = g_strdup_printf("sunlight_wallpaper%ld.jpg", data->var.gl_file_time);
	gchar *s_set_wallpaper = g_strdup_printf("%s%s/%s", GCONF_SET_WALLPAPER, s_dir_wallpapers, s_file_time);
	gchar *s_text1, *s_text2, *s_text3, *s_text4, *s_text5, *s_image_address, *s_contents;
	gshort gs_map_position = get_map_position(data);
	
	s_text1 = "#!/bin/bash\n\nCOUNTER=0\nwhile [  $COUNTER -lt 12 ]; do\n\tcurl --user-agent Firefox ";
	s_text2 = g_strdup_printf(" > world.jpg\n\ttemp=$(stat -c%%s world.jpg)\n\tif [[ $temp > 1000 ]]\n\tthen rm -f %s/*.jpg\n\t\tmv world.jpg %s/%s\n\t\tcd %s", s_dir_wallpapers, s_dir_wallpapers, s_file_time, s_dir_wallpapers);
	s_text3 = g_strdup_printf("\n\t\tmogrify -crop 1600x710-158+30 %s", s_file_time);
	if(is_peters(data)){s_text4 = g_strdup_printf("\n\t\tcp %s sunlight_wallpaper_right.jpg\n\t\tcp %s sunlight_wallpaper_left.jpg\n\t\tmogrify -crop 1442x%d-%d+0 sunlight_wallpaper_left.jpg\n\t\tmogrify -crop 1442x%d+%d+0 sunlight_wallpaper_right.jpg\n\t\tmontage -geometry +0+0 sunlight_wallpaper_right.jpg sunlight_wallpaper_left.jpg %s", s_file_time, s_file_time, data->var.gi_map_height, gs_map_position, data->var.gi_map_height, 1442 - gs_map_position, s_file_time);}
	else{s_text4 = g_strdup_printf("\n\t\tcp %s sunlight_wallpaper_right.jpg\n\t\tcp %s sunlight_wallpaper_left.jpg\n\t\tmogrify -crop 1600x%d-%d+0 sunlight_wallpaper_left.jpg\n\t\tmogrify -crop 1600x%d+%d+0 sunlight_wallpaper_right.jpg\n\t\tmontage -geometry +0+0 sunlight_wallpaper_right.jpg sunlight_wallpaper_left.jpg %s", s_file_time, s_file_time, data->var.gi_map_height, gs_map_position, data->var.gi_map_height, 1600 - gs_map_position, s_file_time);}
	s_text5 = "\n\t\texit 0\n\tfi\n\tsleep 5\n\tlet COUNTER=COUNTER+1\ndone";
	
	g_file_set_contents(s_fname2, s_file_time, -1, NULL);
	
	switch(data->var.gi_rd1){
		case 1:	switch(data->var.gi_rd2){
					case 1: s_image_address = "http://static.die.net/earth/mercator/1600.jpg";
							break;
					case 2:	s_image_address = "http://static.die.net/earth/peters/1600.jpg";
							break;
					case 3:	s_image_address = "http://static.die.net/earth/mollweide/1600.jpg";
							break;
					case 4:	s_image_address = "http://static.die.net/earth/rectangular/1600.jpg";
							break;
				}
				break;
		case 2:	s_image_address = "http://static.die.net/earth/hemisphere/1600.jpg";
				break;
		case 3:	s_image_address = "http://static.die.net/moon/800.jpg";
				break;
	}
	
	if(data->var.gi_rd1 == 1){
		if(data->var.gi_rd2 == 3) s_contents = g_strconcat(s_text1, s_image_address, s_text2, s_text5, NULL);
		else{
			 if(is_peters(data)) s_contents = g_strconcat(s_text1, s_image_address, s_text2, s_text3, s_text4, s_text5, NULL);
			 else s_contents = g_strconcat(s_text1, s_image_address, s_text2, s_text4, s_text5, NULL);
		 }
	}else s_contents = g_strconcat(s_text1, s_image_address, s_text2, s_text5, NULL);	
	
	if (g_file_set_contents(s_fname, s_contents, -1, NULL)) {
		
		if (g_chmod(s_fname, 0750) == 0) g_thread_create((GThreadFunc)async_lengthy_func, create_progressbar_window(data), FALSE, NULL);
			
	}else { g_print("no get_image.sh file created");}
	
	g_free(s_dir_wallpapers);
	g_free(s_dir_project);
	g_free(s_fname);
	g_free(s_file_time);
	g_free(s_contents);
	g_free(s_set_wallpaper);
	g_free(s_text2);
	g_free(s_text3);
	g_free(s_text4);
}

/*******************************************************
	Check Toggle Button
*******************************************************/
void chk_startup_toggled_cb (GtkToggleButton *togglebutton, ChData *data){
	gchar *s_contents = "[Desktop Entry]\nEncoding=UTF-8\nIcon=/usr/share/icons/hicolor/48x48/apps/gtk-sunlight.png\nName=Real-time Sunlight Wallpaper\nComment=World sunlight map every 30 minutes\nExec=gtk-sunlight --nodisplay\nTerminal=false\nType=Application\nCategories=Utility;\nStartupNotify=false\nHidden=false\nNoDisplay=false";
	gchar *s_path_startup = g_strconcat(g_get_home_dir(), "/.config/autostart/", NULL);
	gchar *s_path_startup_check = g_strconcat(g_get_home_dir(), "/.config/autostart/", "sunlight.desktop", NULL);

	if (gtk_toggle_button_get_active(togglebutton))
	{		
		if (!g_file_test(s_path_startup_check, G_FILE_TEST_EXISTS))
		{
			if (g_file_set_contents(g_strconcat(s_path_startup, "sunlight.desktop", NULL), s_contents, -1, NULL))
			{
				g_print("sunlight.desktop created");
			}
			else g_print("no sunlight.desktop file created");		
		}
	}else if (g_file_test(s_path_startup_check, G_FILE_TEST_EXISTS)) 
			g_remove(g_strconcat(s_path_startup, "sunlight.desktop", NULL));

	g_free(s_path_startup);
	g_free(s_path_startup_check);
}

void chk_move_map_toggled_cb (GtkToggleButton *togglebutton, ChData *data){
	if (gtk_toggle_button_get_active(togglebutton)){
		data->var.gb_move_map = TRUE;
	}else data->var.gb_move_map = FALSE;
}

void on_chk_offline_toggled (GtkToggleButton *togglebutton, ChData *data){
	if (gtk_toggle_button_get_active(togglebutton)){
		gtk_widget_set_sensitive (GTK_WIDGET (data->offline.box_offline), TRUE);
		data->var.gb_offline = TRUE;
	}else{
		gtk_widget_set_sensitive (GTK_WIDGET (data->offline.box_offline), FALSE);
		data->var.gb_offline = FALSE;
	}
}

/*********************************************************
	Level 1 - RadioButtons
*********************************************************/
void rd1_worldmap_toggled_cb (GtkToggleButton *togglebutton, ChData *data){
	data->var.gi_rd1=1;
	gchar *s_filename;
	
	button_sensitive (data, TRUE);

	switch (data->var.gi_rd2)
	{
		case 1: s_filename = "/usr/share/sunlight/images/mercator_small.jpg";
				scale_box_sensitive (data, TRUE);
				break;
		case 2:	s_filename = "/usr/share/sunlight/images/peters_small.jpg";
				scale_box_sensitive (data, TRUE);
				break;
		case 3:	s_filename = "/usr/share/sunlight/images/mollweide_small.jpg";
				break;		
		case 4:	s_filename = "/usr/share/sunlight/images/equirectangular_small.jpg";
				scale_box_sensitive (data, TRUE);
				break;
	}
	gtk_image_set_from_file (data->main_image, s_filename);
}

void rd1_realistic_toggled_cb (GtkToggleButton *togglebutton, ChData *data){
	data->var.gi_rd1=2;
	gchar *s_filename = "/usr/share/sunlight/images/dawntodusk_small.jpg";
	gtk_image_set_from_file (data->main_image, s_filename);
	button_sensitive (data, FALSE);
	scale_box_sensitive (data, FALSE);
}

void rd1_moon_toggled_cb (GtkToggleButton *togglebutton, ChData *data){
	data->var.gi_rd1=3;
	gchar *s_filename = "/usr/share/sunlight/images/moon_small.jpg";
	gtk_image_set_from_file (data->main_image, s_filename);
	button_sensitive (data, FALSE);
	scale_box_sensitive (data, FALSE);
}

/*********************************************************
	Level 2 - RadioButtons
*********************************************************/
void rd2_mercator_toggled_cb (GtkToggleButton *togglebutton, ChData *data){
	data->var.gi_rd2=1;
	gchar *s_filename = "/usr/share/sunlight/images/mercator_small.jpg";
	gtk_image_set_from_file (data->main_image, s_filename);
	scale_box_sensitive (data, TRUE);
	data->var.gi_map_height = 887;
}

void rd2_peters_toggled_cb (GtkToggleButton *togglebutton, ChData *data){
	data->var.gi_rd2=2;
	gchar *s_filename = "/usr/share/sunlight/images/peters_small.jpg";
	gtk_image_set_from_file (data->main_image, s_filename);
	scale_box_sensitive (data, TRUE);
	data->var.gi_map_height = 710;
}

void rd2_mollweide_toggled_cb (GtkToggleButton *togglebutton, ChData *data){
	data->var.gi_rd2=3;
	gchar *s_filename = "/usr/share/sunlight/images/mollweide_small.jpg";
	gtk_image_set_from_file (data->main_image, s_filename);
	scale_box_sensitive (data, FALSE);
}

void rd2_equirectangular_toggled_cb (GtkToggleButton *togglebutton, ChData *data){
	data->var.gi_rd2=4;
	gchar *s_filename = "/usr/share/sunlight/images/equirectangular_small.jpg";
	gtk_image_set_from_file (data->main_image, s_filename);
	scale_box_sensitive (data, TRUE);
	data->var.gi_map_height = 660;
}

/*********************************************************
	HScale
*********************************************************/
void on_hscale_adj_value_changed (GtkAdjustment *hscale_adj, ChData *data){
	gdouble hvalue = gtk_adjustment_get_value (hscale_adj);  	
	gtk_adjustment_set_value (hscale_adj, (int)hvalue);
	data->var.gd_map_scale = gtk_adjustment_get_value (hscale_adj);
}

/*********************************************************
	ComboBoxes
*********************************************************/
void on_cmb_style_changed (GtkComboBox *ComboBox){
	gchar *options;
	gint lst_option = gtk_combo_box_get_active (ComboBox);

	switch (lst_option)
	{
		case 0:	options = g_strconcat(GCONF_SET_PICTURE_OPTIONS, "wallpaper", NULL);
				break;
		case 1:	options = g_strconcat(GCONF_SET_PICTURE_OPTIONS,"zoom", NULL);
				break;
		case 2:	options = g_strconcat(GCONF_SET_PICTURE_OPTIONS,"centered", NULL);
				break;
		case 3:	options = g_strconcat(GCONF_SET_PICTURE_OPTIONS,"scaled", NULL);
				break;
		case 4:	options = g_strconcat(GCONF_SET_PICTURE_OPTIONS,"stretched", NULL);
				break;
		case 5:	options = g_strconcat(GCONF_SET_PICTURE_OPTIONS,"spanned", NULL);
				break;
	}
	system (options);
	g_free (options);
}

void on_cmb_colors_changed (GtkComboBox *ComboBox, ChData *data){
	gchar *options;	
	gint lst_option = gtk_combo_box_get_active (ComboBox);

	switch (lst_option)
	{
		case 0:	options = g_strconcat(GCONF_SET_GRADIENT_OPTIONS, "solid", NULL);
				gtk_widget_hide (data->sys.hbox);
				break;
		case 1:	options = g_strconcat(GCONF_SET_GRADIENT_OPTIONS,"horizontal", NULL);
				gtk_widget_show_all (data->sys.hbox);
				break;
		case 2:	options = g_strconcat(GCONF_SET_GRADIENT_OPTIONS,"vertical", NULL);
				gtk_widget_show_all (data->sys.hbox);
				break;	
	}
	system (options);
	g_free (options);
}

void on_colorbutton1_color_set (GtkColorButton *ColorButton){
	GdkColor color;
	gchar *options;
	
	gtk_color_button_get_color (ColorButton, &color);

	options = g_strconcat(GCONF_SET_COLOR_PRIMARY_OPTIONS, "\"", gdk_color_to_string (&color), "\"", NULL);
	system(options);
	g_free(options);
}

void on_colorbutton2_color_set (GtkColorButton *ColorButton){
	GdkColor color;
	gchar *options;
	
	gtk_color_button_get_color (ColorButton, &color);

	options = g_strconcat(GCONF_SET_COLOR_SECONDARY_OPTIONS, "\"", gdk_color_to_string (&color), "\"", NULL);	
	system(options);
	g_free(options);
}

/*********************************************************
	Menu Items
*********************************************************/
void menu_quit_activate_cb (GtkImageMenuItem *self, ChData *data){
	gtk_main_quit();
}

void menu_about_activate_cb (GtkImageMenuItem *self, ChData *data){
	   
	static const gchar * const authors[] = {
				"Carles Sentis <realtimesunlightwallpaper.gtk@gmail.com>",
				NULL
				};

	static const gchar copyright[] = \
				"GNU GPL v3 \xc2\xa9 2010 Carles Sentis";

	static const gchar comments[] = "Watch the sun rise, sun set and could system all over the world on this real-time, computer-generated illustration of the earth's patterns of sunlight and darkness or watch the moon phases.\n\nImages courtesy of die.net";

	gtk_show_about_dialog (GTK_WINDOW (data->main_window),
		       "authors", authors,
		       "comments", comments,
		       "copyright", copyright,
		       "version", "v0.4.2",
		       "website", "http://realtimesunlightwallpaper.weebly.com",
		       "program-name", "Real-time Sunlight Wallpaper",
		       "logo", gdk_pixbuf_new_from_file("/usr/share/icons/hicolor/48x48/apps/gtk-sunlight.png", NULL),
		       NULL); 
}

/***********************************************************
	Expander
***********************************************************/
void exp_advanced_activate_cb (GtkExpander *self, ChData *data){
/*	if (gtk_expander_get_expanded (self)){
		if((data->var.gd_map_scale != 0) || (data->var.gb_move_map == TRUE)){
			gint result = gtk_dialog_run (GTK_DIALOG (data->mes.message_dialog));
			switch (result)
			{
				case GTK_RESPONSE_OK:
						g_print("OK\n\n");
						break;
				case GTK_RESPONSE_CANCEL:
						gtk_expander_set_expanded (data->adv.exp_advanced, TRUE);
						break;
			}
			gtk_widget_hide (data->mes.message_dialog);	
		}
	}
*/
}

/*********************************************************
 * 	Message Dialog
 * ******************************************************/
void on_message_dialog_close(){
}

void on_message_dialog_response(){
}

gpointer create_progressbar_window (ChData *data){
	GtkWidget *win, *w, *vbox;
	guint sid;
	/* create the modal window which warns the user to wait */
	win = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_modal(GTK_WINDOW(win), TRUE);
	gtk_window_set_title(GTK_WINDOW(win), "Progress");
	gtk_window_set_decorated (GTK_WINDOW(win), FALSE);
	gtk_window_set_skip_taskbar_hint (GTK_WINDOW(win), TRUE);
	gtk_window_set_transient_for (GTK_WINDOW(win), GTK_WINDOW(data->main_window));
	gtk_container_set_border_width(GTK_CONTAINER(win), 12);
	g_signal_connect(win, "delete_event", G_CALLBACK(gtk_true), NULL);
	vbox = gtk_vbox_new(FALSE, 12);
	gtk_widget_show(vbox);
	/* create label */
	w = gtk_label_new("Please wait...");
	gtk_widget_show(w);
	gtk_container_add(GTK_CONTAINER(vbox), w);
	/* create progress bar */
	w = gtk_progress_bar_new();
	gtk_widget_show(w);
	gtk_container_add(GTK_CONTAINER(vbox), w);
	/* add vbox to dialog */
	gtk_container_add(GTK_CONTAINER(win), vbox);
	
	if (data->var.gb_apply_clicked == TRUE) gtk_widget_show (win);
	/* refresh the progress dialog */
	sid = g_timeout_add(150, update_progress, w);
	g_object_set_data(G_OBJECT(win), "source_id", GINT_TO_POINTER(sid));
	
	return win;
}

gboolean update_progress(gpointer data){
	gtk_progress_bar_pulse(GTK_PROGRESS_BAR(data));
	return TRUE;
}

gpointer async_lengthy_func(gpointer data){
	GError     	*error = NULL;
	gchar 		*option_file = g_strconcat(g_get_home_dir(), DIR_PROJECT, "/file_time", NULL);
	gchar 		*contents;
	gsize 		length;
	
	g_file_get_contents (option_file, &contents, &length, &error);
	
	gchar *s_dir_project = g_strconcat(g_get_home_dir(), DIR_PROJECT, NULL);
	gchar *s_dir_wallpapers = g_strconcat(g_get_home_dir(), DIR_WALLPAPERS, NULL);
	//gchar *s_file_time = g_strdup_printf("sunlight_wallpaper%ld.jpg", data->var.gl_file_time);
	gchar *s_set_wallpaper = g_strdup_printf("%s%s/%s", GCONF_SET_WALLPAPER, s_dir_wallpapers, contents);
	gchar *s_fname = g_strconcat(s_dir_project, "/get_image.sh", NULL);
	
	if (system(s_fname) == 0) system(s_set_wallpaper);
	
	g_free(s_dir_wallpapers);
	g_free(s_dir_project);
	g_free(s_fname);
	//g_free(s_file_time);
	g_free(s_set_wallpaper);
	g_free(option_file);
	g_free(contents);
	
	GtkWidget *w = GTK_WIDGET (data) ;
	/* stop pulsing progress bar */
	g_source_remove(GPOINTER_TO_INT(g_object_get_data(G_OBJECT(w), "source_id")));
	gtk_widget_hide(w);
	gtk_widget_destroy(w);
	
	return NULL;
}

void on_filechooser_offline_file_set (GtkFileChooser *file_chooser, gpointer data){
	gchar *file;
	
	file = gtk_file_chooser_get_filename(file_chooser);
	
	if (file != NULL) DBG (("file seleted"));
	else DBG (("No file selected"));
	
	g_printf("file: %s", file);
	
	g_free(file);
}
