//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/_cgdisplayconfigref?language=objc)
#[repr(C)]
#[derive(Debug)]
pub struct _CGDisplayConfigRef {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for _CGDisplayConfigRef {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Encoding::Struct("_CGDisplayConfigRef", &[]));
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgdisplayconfigref?language=objc)
pub type CGDisplayConfigRef = *mut _CGDisplayConfigRef;

extern "C-unwind" {
    #[cfg(feature = "CGError")]
    pub fn CGBeginDisplayConfiguration(config: *mut CGDisplayConfigRef) -> CGError;
}

extern "C-unwind" {
    #[cfg(all(feature = "CGDirectDisplay", feature = "CGError"))]
    pub fn CGConfigureDisplayOrigin(
        config: CGDisplayConfigRef,
        display: CGDirectDisplayID,
        x: i32,
        y: i32,
    ) -> CGError;
}

extern "C-unwind" {
    #[cfg(all(feature = "CGDirectDisplay", feature = "CGError"))]
    pub fn CGConfigureDisplayWithDisplayMode(
        config: CGDisplayConfigRef,
        display: CGDirectDisplayID,
        mode: Option<&CGDisplayMode>,
        options: Option<&CFDictionary>,
    ) -> CGError;
}

#[cfg(all(feature = "CGDirectDisplay", feature = "CGError", feature = "libc"))]
#[inline]
pub unsafe extern "C-unwind" fn CGConfigureDisplayStereoOperation(
    config: CGDisplayConfigRef,
    display: CGDirectDisplayID,
    stereo: bool,
    force_blue_line: bool,
) -> CGError {
    extern "C-unwind" {
        fn CGConfigureDisplayStereoOperation(
            config: CGDisplayConfigRef,
            display: CGDirectDisplayID,
            stereo: libc::boolean_t,
            force_blue_line: libc::boolean_t,
        ) -> CGError;
    }
    unsafe { CGConfigureDisplayStereoOperation(config, display, stereo as _, force_blue_line as _) }
}

extern "C-unwind" {
    #[cfg(all(feature = "CGDirectDisplay", feature = "CGError"))]
    pub fn CGConfigureDisplayMirrorOfDisplay(
        config: CGDisplayConfigRef,
        display: CGDirectDisplayID,
        master: CGDirectDisplayID,
    ) -> CGError;
}

extern "C-unwind" {
    #[cfg(feature = "CGError")]
    pub fn CGCancelDisplayConfiguration(config: CGDisplayConfigRef) -> CGError;
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgconfigureoption?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGConfigureOption(pub u32);
bitflags::bitflags! {
    impl CGConfigureOption: u32 {
        #[doc(alias = "kCGConfigureForAppOnly")]
        const ForAppOnly = 0;
        #[doc(alias = "kCGConfigureForSession")]
        const ForSession = 1;
        #[doc(alias = "kCGConfigurePermanently")]
        const Permanently = 2;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGConfigureOption {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGConfigureOption {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C-unwind" {
    #[cfg(feature = "CGError")]
    pub fn CGCompleteDisplayConfiguration(
        config: CGDisplayConfigRef,
        option: CGConfigureOption,
    ) -> CGError;
}

extern "C-unwind" {
    pub fn CGRestorePermanentDisplayConfiguration();
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgdisplaychangesummaryflags?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CGDisplayChangeSummaryFlags(pub u32);
bitflags::bitflags! {
    impl CGDisplayChangeSummaryFlags: u32 {
        #[doc(alias = "kCGDisplayBeginConfigurationFlag")]
        const BeginConfigurationFlag = 1<<0;
        #[doc(alias = "kCGDisplayMovedFlag")]
        const MovedFlag = 1<<1;
        #[doc(alias = "kCGDisplaySetMainFlag")]
        const SetMainFlag = 1<<2;
        #[doc(alias = "kCGDisplaySetModeFlag")]
        const SetModeFlag = 1<<3;
        #[doc(alias = "kCGDisplayAddFlag")]
        const AddFlag = 1<<4;
        #[doc(alias = "kCGDisplayRemoveFlag")]
        const RemoveFlag = 1<<5;
        #[doc(alias = "kCGDisplayEnabledFlag")]
        const EnabledFlag = 1<<8;
        #[doc(alias = "kCGDisplayDisabledFlag")]
        const DisabledFlag = 1<<9;
        #[doc(alias = "kCGDisplayMirrorFlag")]
        const MirrorFlag = 1<<10;
        #[doc(alias = "kCGDisplayUnMirrorFlag")]
        const UnMirrorFlag = 1<<11;
        #[doc(alias = "kCGDisplayDesktopShapeChangedFlag")]
        const DesktopShapeChangedFlag = 1<<12;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CGDisplayChangeSummaryFlags {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CGDisplayChangeSummaryFlags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/coregraphics/cgdisplayreconfigurationcallback?language=objc)
#[cfg(feature = "CGDirectDisplay")]
pub type CGDisplayReconfigurationCallBack = Option<
    unsafe extern "C-unwind" fn(CGDirectDisplayID, CGDisplayChangeSummaryFlags, *mut c_void),
>;

extern "C-unwind" {
    #[cfg(all(feature = "CGDirectDisplay", feature = "CGError"))]
    pub fn CGDisplayRegisterReconfigurationCallback(
        callback: CGDisplayReconfigurationCallBack,
        user_info: *mut c_void,
    ) -> CGError;
}

extern "C-unwind" {
    #[cfg(all(feature = "CGDirectDisplay", feature = "CGError"))]
    pub fn CGDisplayRemoveReconfigurationCallback(
        callback: CGDisplayReconfigurationCallBack,
        user_info: *mut c_void,
    ) -> CGError;
}

#[cfg(all(feature = "CGDirectDisplay", feature = "CGError", feature = "libc"))]
#[inline]
pub unsafe extern "C-unwind" fn CGDisplaySetStereoOperation(
    display: CGDirectDisplayID,
    stereo: bool,
    force_blue_line: bool,
    option: CGConfigureOption,
) -> CGError {
    extern "C-unwind" {
        fn CGDisplaySetStereoOperation(
            display: CGDirectDisplayID,
            stereo: libc::boolean_t,
            force_blue_line: libc::boolean_t,
            option: CGConfigureOption,
        ) -> CGError;
    }
    unsafe { CGDisplaySetStereoOperation(display, stereo as _, force_blue_line as _, option) }
}

#[cfg(all(feature = "CGDirectDisplay", feature = "libc"))]
#[inline]
pub unsafe extern "C-unwind" fn CGDisplayIsActive(display: CGDirectDisplayID) -> bool {
    extern "C-unwind" {
        fn CGDisplayIsActive(display: CGDirectDisplayID) -> libc::boolean_t;
    }
    let ret = unsafe { CGDisplayIsActive(display) };
    ret != 0
}

#[cfg(all(feature = "CGDirectDisplay", feature = "libc"))]
#[inline]
pub unsafe extern "C-unwind" fn CGDisplayIsAsleep(display: CGDirectDisplayID) -> bool {
    extern "C-unwind" {
        fn CGDisplayIsAsleep(display: CGDirectDisplayID) -> libc::boolean_t;
    }
    let ret = unsafe { CGDisplayIsAsleep(display) };
    ret != 0
}

#[cfg(all(feature = "CGDirectDisplay", feature = "libc"))]
#[inline]
pub unsafe extern "C-unwind" fn CGDisplayIsOnline(display: CGDirectDisplayID) -> bool {
    extern "C-unwind" {
        fn CGDisplayIsOnline(display: CGDirectDisplayID) -> libc::boolean_t;
    }
    let ret = unsafe { CGDisplayIsOnline(display) };
    ret != 0
}

#[cfg(all(feature = "CGDirectDisplay", feature = "libc"))]
#[inline]
pub unsafe extern "C-unwind" fn CGDisplayIsMain(display: CGDirectDisplayID) -> bool {
    extern "C-unwind" {
        fn CGDisplayIsMain(display: CGDirectDisplayID) -> libc::boolean_t;
    }
    let ret = unsafe { CGDisplayIsMain(display) };
    ret != 0
}

#[cfg(all(feature = "CGDirectDisplay", feature = "libc"))]
#[inline]
pub unsafe extern "C-unwind" fn CGDisplayIsBuiltin(display: CGDirectDisplayID) -> bool {
    extern "C-unwind" {
        fn CGDisplayIsBuiltin(display: CGDirectDisplayID) -> libc::boolean_t;
    }
    let ret = unsafe { CGDisplayIsBuiltin(display) };
    ret != 0
}

#[cfg(all(feature = "CGDirectDisplay", feature = "libc"))]
#[inline]
pub unsafe extern "C-unwind" fn CGDisplayIsInMirrorSet(display: CGDirectDisplayID) -> bool {
    extern "C-unwind" {
        fn CGDisplayIsInMirrorSet(display: CGDirectDisplayID) -> libc::boolean_t;
    }
    let ret = unsafe { CGDisplayIsInMirrorSet(display) };
    ret != 0
}

#[cfg(all(feature = "CGDirectDisplay", feature = "libc"))]
#[inline]
pub unsafe extern "C-unwind" fn CGDisplayIsAlwaysInMirrorSet(display: CGDirectDisplayID) -> bool {
    extern "C-unwind" {
        fn CGDisplayIsAlwaysInMirrorSet(display: CGDirectDisplayID) -> libc::boolean_t;
    }
    let ret = unsafe { CGDisplayIsAlwaysInMirrorSet(display) };
    ret != 0
}

#[cfg(all(feature = "CGDirectDisplay", feature = "libc"))]
#[inline]
pub unsafe extern "C-unwind" fn CGDisplayIsInHWMirrorSet(display: CGDirectDisplayID) -> bool {
    extern "C-unwind" {
        fn CGDisplayIsInHWMirrorSet(display: CGDirectDisplayID) -> libc::boolean_t;
    }
    let ret = unsafe { CGDisplayIsInHWMirrorSet(display) };
    ret != 0
}

extern "C-unwind" {
    #[cfg(feature = "CGDirectDisplay")]
    pub fn CGDisplayMirrorsDisplay(display: CGDirectDisplayID) -> CGDirectDisplayID;
}

#[cfg(all(feature = "CGDirectDisplay", feature = "libc"))]
#[inline]
pub unsafe extern "C-unwind" fn CGDisplayUsesOpenGLAcceleration(
    display: CGDirectDisplayID,
) -> bool {
    extern "C-unwind" {
        fn CGDisplayUsesOpenGLAcceleration(display: CGDirectDisplayID) -> libc::boolean_t;
    }
    let ret = unsafe { CGDisplayUsesOpenGLAcceleration(display) };
    ret != 0
}

#[cfg(all(feature = "CGDirectDisplay", feature = "libc"))]
#[inline]
pub unsafe extern "C-unwind" fn CGDisplayIsStereo(display: CGDirectDisplayID) -> bool {
    extern "C-unwind" {
        fn CGDisplayIsStereo(display: CGDirectDisplayID) -> libc::boolean_t;
    }
    let ret = unsafe { CGDisplayIsStereo(display) };
    ret != 0
}

extern "C-unwind" {
    #[cfg(feature = "CGDirectDisplay")]
    pub fn CGDisplayPrimaryDisplay(display: CGDirectDisplayID) -> CGDirectDisplayID;
}

extern "C-unwind" {
    #[cfg(feature = "CGDirectDisplay")]
    pub fn CGDisplayUnitNumber(display: CGDirectDisplayID) -> u32;
}

extern "C-unwind" {
    #[cfg(feature = "CGDirectDisplay")]
    pub fn CGDisplayVendorNumber(display: CGDirectDisplayID) -> u32;
}

extern "C-unwind" {
    #[cfg(feature = "CGDirectDisplay")]
    pub fn CGDisplayModelNumber(display: CGDirectDisplayID) -> u32;
}

extern "C-unwind" {
    #[cfg(feature = "CGDirectDisplay")]
    pub fn CGDisplaySerialNumber(display: CGDirectDisplayID) -> u32;
}

extern "C-unwind" {
    #[cfg(feature = "CGDirectDisplay")]
    pub fn CGDisplayScreenSize(display: CGDirectDisplayID) -> CGSize;
}

extern "C-unwind" {
    #[cfg(feature = "CGDirectDisplay")]
    pub fn CGDisplayRotation(display: CGDirectDisplayID) -> c_double;
}

#[cfg(all(feature = "CGColorSpace", feature = "CGDirectDisplay"))]
#[inline]
pub unsafe extern "C-unwind" fn CGDisplayCopyColorSpace(
    display: CGDirectDisplayID,
) -> CFRetained<CGColorSpace> {
    extern "C-unwind" {
        fn CGDisplayCopyColorSpace(display: CGDirectDisplayID) -> Option<NonNull<CGColorSpace>>;
    }
    let ret = unsafe { CGDisplayCopyColorSpace(display) };
    let ret = ret.expect("function was marked as returning non-null, but actually returned NULL");
    unsafe { CFRetained::from_raw(ret) }
}

extern "C-unwind" {
    #[cfg(all(feature = "CGDirectDisplay", feature = "CGError"))]
    #[deprecated = "No longer supported"]
    pub fn CGConfigureDisplayMode(
        config: CGDisplayConfigRef,
        display: CGDirectDisplayID,
        mode: Option<&CFDictionary>,
    ) -> CGError;
}
