pub fn test_data() -> Vec<&'static [u8]> {
    [
        // monitors I have lying around
        &b"(prot(monitor)type(lcd)27UD58cmds(01 02 03 0C E3 F3)vcp(02 04 05 08 10 12 14(05 08 0B ) 16 18 1A 52 60( 11 12 0F 10) AC AE B2 B6 C0 C6 C8 C9 D6(01 04) DF 62 8D F4 F5(01 02) F6(00 01 02) 4D 4E 4F 15(01 06 11 13 14 28 29 32 48) F7(00 01 02 03) F8(00 01) F9 E4 E5 E6 E7 E8 E9 EA EB EF FD(00 01) FE(00 01 02) FF)mccs_ver(2.1)mswhql(1))"[..],
        &b"(prot(monitor)type(LCD)model(ACER)cmds(01 02 03 07 0C E3 F3)vcp(02 04 05 08 0B 10 12 14(05 08 0B) 16 18 1A 52 60(01 03 11) 6C 6E 70 AC AE B2 B6 C6 C8 C9 CC(01 02 03 04 05 06 08 09 0A 0C 0D 14 16 1E) D6(01 05) DF)mswhql(1)asset_eep(40)mccs_ver(2.0))\0"[..],
        &b"(prot(monitor)type(lcd)model(S2721QS)cmds(01 02 03 07 0C E3 F3)vcp(02 04 05 08 10 12 14(05 08 0B 0C) 16 18 1A 52 60( 0F 11 12) 62 AC AE B2 B6 C6 C8 C9 CC(02 03 04 06 09 0A 0D 0E) D6(01 04 05) DC(00 03 ) DF E0 E1 E2(00 1D 02 20 21 22 0E 12 14 23 24 27 )E3 E5 E8 E9(00 01 02 21 22 24) EA F0(00 0C 0F 10 11 31 32 34 35) F1 F2 FD)mccs_ver(2.1)mswhql(1))"[..],
        &b"(prot(monitor)type(lcd)EVEcmds(01 02 03 07 0C E3 F3)vcp(02 04 05 08 10 12 14(05 08 0B 0C) 16 18 1A 52 60( 11 12 0F 10) AA(01 02) AC AE B2 B6 C6 C8 C9 D6(01 04 05) DC(00 02 03 05 ) DF FD E0 E1 E2)mccs_ver(2.1)mswhql(1))"[..],
        // example from ddcutil
        &b"(prot(monitor)type(LED)model(25UM65)cmds(01 02 03 0C E3 F3)vcp(0203(10 00)0405080B0C101214(05 07 08 0B) 16181A5260(03 04)6C6E7087ACAEB6C0C6C8C9D6(01 04)DFE4E5E6E7E8E9EAEBED(00 10 20 40)EE(00 01)FE(01 02 03)FF)mswhql(1)mccs_ver(2.1))"[..],
        // example from MCCS spec v2.2a
        &b"Prot(display) type(lcd) model(xxxxx) cmds(xxxxx) vcp(02 03 10 12 C8 DC(00 01 02 03 07) DF)mccs_ver(2.2) window1(type (PIP) area(25 25 1895 1175) max(640 480) min(10 10) window(10))vcpname(10(Brightness))"[..],
        // example from access bus section 7
        &br"vcpname(14((9300 6500 5500))44(Rotate)80(Do\x20this(On Off))82(Fixit))"[..],
        // above example with matching vcp() section
        &br"vcp(14(010203)448082)vcpname(14((9300 6500 5500))44(Rotate)80(Do\x20this(On Off))82(Fixit))"[..],
        // tagged length with bracket and invalid utf8 seems like a worst case scenario here:
        &b"edid bin(3(\xff) ))vdif bin(3 (abc))unknown bin(2(ab))"[..],
        // samples gathered from various online sources
        &b"(prot(monitor)type(lcd)model(p2317h)cmds(01 02 03 07 0c e3 f3)vcp(02 04 05 08 10 12 14(05 08 0b 0c) 16 18 1a 52 60(01 0f 11) aa(01 02) ac ae b2 b6 c6 c8 c9 d6(01 04 05) dc(00 02 03 05) df e0 e1 e2(00 1d 01 02 04 0e 12 14) f0(0c) f1 f2 fd)mswhql(1)asset_eep(40)mccs_ver(2.1))"[..],
        &b"(prot(monitor)type(lcd)model(U3011)cmds(01 02 03 07 0C E3 F3)vcp(02 04 05 06 08 10 12 14(01 05 08 0B 0C) 16 18 1A 52 60(01 03 04 0C 0F 11 12) AC AE B2 B6 C6 C8 C9 D6(01 04 05) DC(00 02 03 04 05) DF FD)mccs_ver(2.1)mswhql(1))"[..],
        &b"(prot(monitor)type(lcd)model(W2413)cmds(01 02 03 07 0C 4E F3 E3)vcp(02 04 05 08 0B 0C 10 12 14(05 06 08 0B) 16 18 1A 52 AC AE B2 B6 C0 C6 C8 C9 CC(02 03 04 05 06 09 0A 0D 12 14 1E) D6(01 05) DF 60(01 03 11) 62 8D)mswhql(1)mccs_ver(2.0)asset_eep(32)mpu_ver(01))"[..],
        &b"(prot(monitor)type(LCD)model(Plum)mccs_ver(2.0)vcp(04 05 06 08 0E 10 12 14(02 03 0A 0B) 16 18 1A 1E 20 30 3E 60(01 03 05) 87 B0(01 02) B6 C6 C8 C9 D6(01 04) DC(01 02 03 04 05 06 F0 F2 F9 FA FB) DB(00 04 FE) DF E8(00 07 09 0A FE) E9 EA(00 01 02 03 04) EC(00 01 02 03 04 05) F0(00 01 02 03) F2 F6 F7(00 01 02 03) )mswhql(1))"[..],
        &b"(prot(monitor)type(LCD)model(AOC)cmds(01 02 03 07 0C E3 F3)vcp(02 04 05 06 08 0B 0C 10 12 14(01 02 04 05 08) 16 18 1A 52 60(01 03 11) 87 AC AE B2 B6 C6 C8 CA CC(01 02 03 04 06 0A 0D) D6(01 04) DF FD FF)mswhql(1)asset_eep(40)mccs_ver(2.2))"[..],
        // start googling "prot(monitor)" and see what you get...
        &b"(prot(monitor)type(lcd)model(XV273K)cmds(01 02 03 07 0C E3 F3)vcp(02 04 05 08 0B 0C 10 12 14(05 06 08 0B 0C) 16 18 1A 52 54(00 01) 59 5A 5B 5C 5D 5E 60(03 11 0F 10) 62 9B 9C 9D 9E 9F A0 AC AE B6 C0 C6 C8 C9 CC(01 02 03 04 05 06 08 09 0A 0C 0D 0E 14 16 1E)D6(01 04 05) DF E3 E5 E6 E7(00 01 02) E8(00 01 02) )mswhql(1)asset_eep(32)mccs_ver(2.1))"[..],
        &b"(prot(monitor)type(lcd)model(s3219d)cmds(01 02 03 07 0c e3 f3)vcp(02 04 05 08 10 12 14(05 08 0b 0c) 16 18 1a 52 60(0f 11 12 ) 62 ac ae b2 b6 c6 c8 c9 cc(02 0a 03 04 08 09 0d 06 ) d6(01 04 05) dc(00 03 05 ) df e0 e1 e2(00 1d 02 04 0e 12 14 ) f0(0c ) f1 f2 fd)mswhql(1)asset_eep(40)mccs_ver(2.1))"[..],
        &b"(prot(monitor)type(lcd)model(se2722hx)cmds(01 02 03 07 0c e3 f3)vcp(02 04 05 08 10 12 14(05 08 0b 0c) 16 18 1a 52 60(01 11 ) ac ae b2 b6 c6 c8 c9 ca cc(02 0a 03 04 08 09 0d 06 ) d6(01 04 05) dc(00 03 05 ) df e0 e1 e2(00 1d 02 22 20 21 0e 12 14 ) f0(0c 0f 10 11 ) f1 f2 fd)mswhql(1)asset_eep(40)mccs_ver(2.1))"[..],
        &b"(prot(monitor)type(lcd)model(HP X24c)cmds(01 02 03 07 0C E3 F3)vcp(02 04 05 08 0B 0C 10 12 14(02 03 04 05 08 09 0B 0C 0D ) 16 18 1A 52 60(0F 11 ) 6C 6E 70 86(01 02 05) 87(01 02 03 04 05 06 07) AC AE B2 B6 C0 C6 C8 C9 CA(01 02) CC(01 02 03 04 05 06 08 0A 0D 14) D6(01 02 03 04 05) DA(00 02 ) DC (00 (00 10 13 14 15 17 1A 1D 1E ) 01 02 03) E0(02 (00 01 02) ) E1(02 (00 01) 03 (00 01 02 03 04 05 06 07) 04 (00 01) 0F (00 01) 10 (00 01) 27 (02 03 04 05 07 ) ) DF E6(00 01) E7(00 01) E8(00 ( 01 02 03 ) 01 02 03 04 05 06 80 81 82 83 84 85 86 ) E9(00 01) EA(00 01) EB(00 (00 01 02 03 04 ) ) DE(00 (00 01 06 07 ) ) ED(00 01) EE(01 02 03) EE(01 02 03) F4(00 (00 01 02 03) 01 (00 01 02 03 04 05 06 07) 02 (00 01 02 03) 0A (00 01 05) 0B (00 01 02 03 04 05 06 07) 11 (00 01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 0F) )  FF)mswhql(1)asset_eep(40)mccs_ver(2.2))"[..],
        &b"(prot(monitor)type(LCD)model(RTK)cmds(01 02 03 07 0C E3 F3)vcp(02 04 05 06 08 0B 0C 10 12 14(01 02 04 05 06 08 0B) 16 18 1A 52 60(01 03 04 0F 10 11 12) 87 AC AE B2 B6 C6 C8 CA CC(01 02 03 04 06 0A 0D) D6(01 04 05) DF FD FF)mswhql(1)asset_eep(40)mccs_ver(2.2))"[..],
        &b"(prot(monitor)type(LCD)model(P2414H)cmds(01 02 03 07 0C E3 F3)vcp(02 04 05 08 10 12 14(05 08 0B 0C) 16 18 1A 52 60(01 03 0F) AA AC AE B2 B6 C6 C8 C9 D6(01 04 05) DC(00 02 03 05) DF E0 E1 E2(00 01 02 04 06 0E 12 14) F0(00 01) F1(01) F2 FD)mswhql(1)asset_eep(40)mccs_ver(2.1))"[..],
        &b"(vcp(02 04 05 08 10 12 14(01 05 06 08 0B) 16 18 1A 60(01 03)6C 6E 70 C8 9B 9D 9F 9C A0 9EB0 B6 DF)prot(monitor)type(LCD)cmds(01 02 03 07 0C F3)mccs_ver(2.1)asset_eep(64)mpu_ver(V2.00)model(SA240Y bid)mswhql(1))"[..],
        &b"prot(monitor)type(LCD)model(VX4380)cmds(01 02 03 07 0C E3 F3)vcp(02 04 05 08 0B 0C 10 12 14(01 08 06 05 04 0B) 16 18 1A 52 60(0F 10 11 12) 62 87 8D(01 02) A5 AC AE B2 B6 C6 C8 CA CC(01 02 03 04 05 06 07 08 09 0A 0B 0C 0D 0E 12 14 16 17 1A 1E 24) D6(01 04 05) DC(00 01 02 03 05 08 1F) DF E0(00 01 02 03 14) EC(01 02 03) F6 F7(42 FF) FA(00 01 02) FB FC FD FE(00 01 02 04) FF)mswhql(1)asset_eep(40)mccs_ver(2.2)"[..],
        &b"(prot(monitor)type(LCD)model(XB2779QS)cmds(01 03 0C F3)vcp(02 04 05 06 08 0B 0C 10 12 14(02 05 08 0B) 16 18 1A 52 60(01 03 0F 11) B6 DF)mswhql(1)mccs_ver(2.1))"[..],
        &b"(prot(monitor)type(lcd)34uc88cmds(01 02 03 0c e3 f3)vcp(02 04 05 08 10 12 14(05 08 0b ) 16 18 1a 52 60( 11 12 0f 10) ac ae b2 b6 c0 c6 c8 c9 d6(01 04) df 62 8d f4 f5(00 01 02 03 04) f6(00 01 02) 4d 4e 4f 15(01 07 08 09 10 11 13 14 28 29 32 48) f7(00 01 02 03) f8(00 01) f9 fd(00 01) fe(00 01 02) ff)mccs_ver(2.1)mswhql(1))"[..],
        &b"((prot(monitor)type(lcd)modelVG278Hcmds(01 02 03 07 0C F3)vcp(02 04 05 06 08 0B 0C 10 12 14(01 04 05 08 0B) 16 18 1A 60(01 03 04) 62 6C 6E 70 A8 AC AE B6 C6 C8 C9 D6(01 04) DF FE)mccs_ver(2.1)asset_eep(32)mpu(001)mswhql(1)))"[..],
        &b"(prot(monitor)type(lcd)model(xl2411t)cmds(01 02 03 07 0c e3 f3)vcp(02 04 05 08 0b 0c 10 12 14(04 05 08 0b) 16 18 1a 52 60(01 03 11) ac ae b2 b6 c0 c6 c8 c9 ca(01 02) cc(01 02 03 04 05 06 08 09 0a 0b 0d 12 14 1a 1e 1f 20) d6(01 05) df)mswhql(1)mccs_ver(2.0))"[..],
        &b"prot(monitor)type(lcd)model(SDM-S205)cmds(0102030CE3F3)vcp(040E10121314(0508010B)16181A1E20303E6C6E7072(0A78FA5064788CA0)B6C0C9DC(00080904)DF)mccs_ver(0201)"[..],
        &b"((prot(monitor)type(LCD)model(T)mccs_ver(2.0)vcp(04 05 08 10 12 14(02 03 0A 0B) 16 18 1A 60(01 03) 87 B0(01 02) B6 C6 C8 C9 D6(01 04) DC(01 02 03 04 05 06 F0 F2) DB(00 04 FE) DF E8(00 01 06 07 FE) E9 EA(00 01 02 03 04) F0(00 01 02 03) F2 F3(00 01 02) F6))mswhql(1))"[..], // NOTE: this one's a bit too messed up...
        &b"(prot(monitor)type(LCD)model(McKinley)mccs_ver(2.0)vcp(04 05 06 08 0E 10 12 14(02 03 0A 0B) 16 18 1A 1E 20 30 3E 87 B0(01 02) B6 C6 C8 C9 D6(01 04) DC(01 02 03 04 05 06 F0 F2) DB(00 04 FE) DF E8(00 01 06 07 FE) EA(00 01 02 03 04) F0(00 01 02 03) F2 F6 )mswhql(1))"[..],
    ].iter().cloned().collect()
}
