//! Some additional checks based on https://github.com/ridiculousfish/widecharwidth/blob/master/widechar_width.rs.

/// Nonprinting characters.
const NONPRINT_TABLE: &[(u32, u32)] = &[
    (0x00000, 0x0001F),
    (0x0007F, 0x0009F),
    (0x000AD, 0x000AD),
    (0x00600, 0x00605),
    (0x0061C, 0x0061C),
    (0x006DD, 0x006DD),
    (0x0070F, 0x0070F),
    (0x00890, 0x00891),
    (0x008E2, 0x008E2),
    (0x0180E, 0x0180E),
    (0x0200B, 0x0200F),
    (0x02028, 0x0202E),
    (0x02060, 0x02064),
    (0x02066, 0x0206F),
    (0x0D800, 0x0DFFF),
    (0x0FEFF, 0x0FEFF),
    (0x0FFF9, 0x0FFFB),
    (0x110BD, 0x110BD),
    (0x110CD, 0x110CD),
    (0x13430, 0x1343F),
    (0x1BCA0, 0x1BCA3),
    (0x1D173, 0x1D17A),
    (0xE0001, 0xE0001),
    (0xE0020, 0xE007F),
];

/// Width 0 combining marks.
const COMBINING_TABLE: &[(u32, u32)] = &[
    (0x00300, 0x0036F),
    (0x00483, 0x00489),
    (0x00591, 0x005BD),
    (0x005BF, 0x005BF),
    (0x005C1, 0x005C2),
    (0x005C4, 0x005C5),
    (0x005C7, 0x005C7),
    (0x00610, 0x0061A),
    (0x0064B, 0x0065F),
    (0x00670, 0x00670),
    (0x006D6, 0x006DC),
    (0x006DF, 0x006E4),
    (0x006E7, 0x006E8),
    (0x006EA, 0x006ED),
    (0x00711, 0x00711),
    (0x00730, 0x0074A),
    (0x007A6, 0x007B0),
    (0x007EB, 0x007F3),
    (0x007FD, 0x007FD),
    (0x00816, 0x00819),
    (0x0081B, 0x00823),
    (0x00825, 0x00827),
    (0x00829, 0x0082D),
    (0x00859, 0x0085B),
    (0x00897, 0x0089F),
    (0x008CA, 0x008E1),
    (0x008E3, 0x00903),
    (0x0093A, 0x0093C),
    (0x0093E, 0x0094F),
    (0x00951, 0x00957),
    (0x00962, 0x00963),
    (0x00981, 0x00983),
    (0x009BC, 0x009BC),
    (0x009BE, 0x009C4),
    (0x009C7, 0x009C8),
    (0x009CB, 0x009CD),
    (0x009D7, 0x009D7),
    (0x009E2, 0x009E3),
    (0x009FE, 0x009FE),
    (0x00A01, 0x00A03),
    (0x00A3C, 0x00A3C),
    (0x00A3E, 0x00A42),
    (0x00A47, 0x00A48),
    (0x00A4B, 0x00A4D),
    (0x00A51, 0x00A51),
    (0x00A70, 0x00A71),
    (0x00A75, 0x00A75),
    (0x00A81, 0x00A83),
    (0x00ABC, 0x00ABC),
    (0x00ABE, 0x00AC5),
    (0x00AC7, 0x00AC9),
    (0x00ACB, 0x00ACD),
    (0x00AE2, 0x00AE3),
    (0x00AFA, 0x00AFF),
    (0x00B01, 0x00B03),
    (0x00B3C, 0x00B3C),
    (0x00B3E, 0x00B44),
    (0x00B47, 0x00B48),
    (0x00B4B, 0x00B4D),
    (0x00B55, 0x00B57),
    (0x00B62, 0x00B63),
    (0x00B82, 0x00B82),
    (0x00BBE, 0x00BC2),
    (0x00BC6, 0x00BC8),
    (0x00BCA, 0x00BCD),
    (0x00BD7, 0x00BD7),
    (0x00C00, 0x00C04),
    (0x00C3C, 0x00C3C),
    (0x00C3E, 0x00C44),
    (0x00C46, 0x00C48),
    (0x00C4A, 0x00C4D),
    (0x00C55, 0x00C56),
    (0x00C62, 0x00C63),
    (0x00C81, 0x00C83),
    (0x00CBC, 0x00CBC),
    (0x00CBE, 0x00CC4),
    (0x00CC6, 0x00CC8),
    (0x00CCA, 0x00CCD),
    (0x00CD5, 0x00CD6),
    (0x00CE2, 0x00CE3),
    (0x00CF3, 0x00CF3),
    (0x00D00, 0x00D03),
    (0x00D3B, 0x00D3C),
    (0x00D3E, 0x00D44),
    (0x00D46, 0x00D48),
    (0x00D4A, 0x00D4D),
    (0x00D57, 0x00D57),
    (0x00D62, 0x00D63),
    (0x00D81, 0x00D83),
    (0x00DCA, 0x00DCA),
    (0x00DCF, 0x00DD4),
    (0x00DD6, 0x00DD6),
    (0x00DD8, 0x00DDF),
    (0x00DF2, 0x00DF3),
    (0x00E31, 0x00E31),
    (0x00E34, 0x00E3A),
    (0x00E47, 0x00E4E),
    (0x00EB1, 0x00EB1),
    (0x00EB4, 0x00EBC),
    (0x00EC8, 0x00ECE),
    (0x00F18, 0x00F19),
    (0x00F35, 0x00F35),
    (0x00F37, 0x00F37),
    (0x00F39, 0x00F39),
    (0x00F3E, 0x00F3F),
    (0x00F71, 0x00F84),
    (0x00F86, 0x00F87),
    (0x00F8D, 0x00F97),
    (0x00F99, 0x00FBC),
    (0x00FC6, 0x00FC6),
    (0x0102B, 0x0103E),
    (0x01056, 0x01059),
    (0x0105E, 0x01060),
    (0x01062, 0x01064),
    (0x01067, 0x0106D),
    (0x01071, 0x01074),
    (0x01082, 0x0108D),
    (0x0108F, 0x0108F),
    (0x0109A, 0x0109D),
    (0x0135D, 0x0135F),
    (0x01712, 0x01715),
    (0x01732, 0x01734),
    (0x01752, 0x01753),
    (0x01772, 0x01773),
    (0x017B4, 0x017D3),
    (0x017DD, 0x017DD),
    (0x0180B, 0x0180D),
    (0x0180F, 0x0180F),
    (0x01885, 0x01886),
    (0x018A9, 0x018A9),
    (0x01920, 0x0192B),
    (0x01930, 0x0193B),
    (0x01A17, 0x01A1B),
    (0x01A55, 0x01A5E),
    (0x01A60, 0x01A7C),
    (0x01A7F, 0x01A7F),
    (0x01AB0, 0x01ACE),
    (0x01B00, 0x01B04),
    (0x01B34, 0x01B44),
    (0x01B6B, 0x01B73),
    (0x01B80, 0x01B82),
    (0x01BA1, 0x01BAD),
    (0x01BE6, 0x01BF3),
    (0x01C24, 0x01C37),
    (0x01CD0, 0x01CD2),
    (0x01CD4, 0x01CE8),
    (0x01CED, 0x01CED),
    (0x01CF4, 0x01CF4),
    (0x01CF7, 0x01CF9),
    (0x01DC0, 0x01DFF),
    (0x020D0, 0x020F0),
    (0x02CEF, 0x02CF1),
    (0x02D7F, 0x02D7F),
    (0x02DE0, 0x02DFF),
    (0x0302A, 0x0302F),
    (0x03099, 0x0309A),
    (0x0A66F, 0x0A672),
    (0x0A674, 0x0A67D),
    (0x0A69E, 0x0A69F),
    (0x0A6F0, 0x0A6F1),
    (0x0A802, 0x0A802),
    (0x0A806, 0x0A806),
    (0x0A80B, 0x0A80B),
    (0x0A823, 0x0A827),
    (0x0A82C, 0x0A82C),
    (0x0A880, 0x0A881),
    (0x0A8B4, 0x0A8C5),
    (0x0A8E0, 0x0A8F1),
    (0x0A8FF, 0x0A8FF),
    (0x0A926, 0x0A92D),
    (0x0A947, 0x0A953),
    (0x0A980, 0x0A983),
    (0x0A9B3, 0x0A9C0),
    (0x0A9E5, 0x0A9E5),
    (0x0AA29, 0x0AA36),
    (0x0AA43, 0x0AA43),
    (0x0AA4C, 0x0AA4D),
    (0x0AA7B, 0x0AA7D),
    (0x0AAB0, 0x0AAB0),
    (0x0AAB2, 0x0AAB4),
    (0x0AAB7, 0x0AAB8),
    (0x0AABE, 0x0AABF),
    (0x0AAC1, 0x0AAC1),
    (0x0AAEB, 0x0AAEF),
    (0x0AAF5, 0x0AAF6),
    (0x0ABE3, 0x0ABEA),
    (0x0ABEC, 0x0ABED),
    (0x0FB1E, 0x0FB1E),
    (0x0FE00, 0x0FE0F),
    (0x0FE20, 0x0FE2F),
    (0x101FD, 0x101FD),
    (0x102E0, 0x102E0),
    (0x10376, 0x1037A),
    (0x10A01, 0x10A03),
    (0x10A05, 0x10A06),
    (0x10A0C, 0x10A0F),
    (0x10A38, 0x10A3A),
    (0x10A3F, 0x10A3F),
    (0x10AE5, 0x10AE6),
    (0x10D24, 0x10D27),
    (0x10D69, 0x10D6D),
    (0x10EAB, 0x10EAC),
    (0x10EFC, 0x10EFF),
    (0x10F46, 0x10F50),
    (0x10F82, 0x10F85),
    (0x11000, 0x11002),
    (0x11038, 0x11046),
    (0x11070, 0x11070),
    (0x11073, 0x11074),
    (0x1107F, 0x11082),
    (0x110B0, 0x110BA),
    (0x110C2, 0x110C2),
    (0x11100, 0x11102),
    (0x11127, 0x11134),
    (0x11145, 0x11146),
    (0x11173, 0x11173),
    (0x11180, 0x11182),
    (0x111B3, 0x111C0),
    (0x111C9, 0x111CC),
    (0x111CE, 0x111CF),
    (0x1122C, 0x11237),
    (0x1123E, 0x1123E),
    (0x11241, 0x11241),
    (0x112DF, 0x112EA),
    (0x11300, 0x11303),
    (0x1133B, 0x1133C),
    (0x1133E, 0x11344),
    (0x11347, 0x11348),
    (0x1134B, 0x1134D),
    (0x11357, 0x11357),
    (0x11362, 0x11363),
    (0x11366, 0x1136C),
    (0x11370, 0x11374),
    (0x113B8, 0x113C0),
    (0x113C2, 0x113C2),
    (0x113C5, 0x113C5),
    (0x113C7, 0x113CA),
    (0x113CC, 0x113D0),
    (0x113D2, 0x113D2),
    (0x113E1, 0x113E2),
    (0x11435, 0x11446),
    (0x1145E, 0x1145E),
    (0x114B0, 0x114C3),
    (0x115AF, 0x115B5),
    (0x115B8, 0x115C0),
    (0x115DC, 0x115DD),
    (0x11630, 0x11640),
    (0x116AB, 0x116B7),
    (0x1171D, 0x1172B),
    (0x1182C, 0x1183A),
    (0x11930, 0x11935),
    (0x11937, 0x11938),
    (0x1193B, 0x1193E),
    (0x11940, 0x11940),
    (0x11942, 0x11943),
    (0x119D1, 0x119D7),
    (0x119DA, 0x119E0),
    (0x119E4, 0x119E4),
    (0x11A01, 0x11A0A),
    (0x11A33, 0x11A39),
    (0x11A3B, 0x11A3E),
    (0x11A47, 0x11A47),
    (0x11A51, 0x11A5B),
    (0x11A8A, 0x11A99),
    (0x11C2F, 0x11C36),
    (0x11C38, 0x11C3F),
    (0x11C92, 0x11CA7),
    (0x11CA9, 0x11CB6),
    (0x11D31, 0x11D36),
    (0x11D3A, 0x11D3A),
    (0x11D3C, 0x11D3D),
    (0x11D3F, 0x11D45),
    (0x11D47, 0x11D47),
    (0x11D8A, 0x11D8E),
    (0x11D90, 0x11D91),
    (0x11D93, 0x11D97),
    (0x11EF3, 0x11EF6),
    (0x11F00, 0x11F01),
    (0x11F03, 0x11F03),
    (0x11F34, 0x11F3A),
    (0x11F3E, 0x11F42),
    (0x11F5A, 0x11F5A),
    (0x13440, 0x13440),
    (0x13447, 0x13455),
    (0x1611E, 0x1612F),
    (0x16AF0, 0x16AF4),
    (0x16B30, 0x16B36),
    (0x16F4F, 0x16F4F),
    (0x16F51, 0x16F87),
    (0x16F8F, 0x16F92),
    (0x16FE4, 0x16FE4),
    (0x16FF0, 0x16FF1),
    (0x1BC9D, 0x1BC9E),
    (0x1CF00, 0x1CF2D),
    (0x1CF30, 0x1CF46),
    (0x1D165, 0x1D169),
    (0x1D16D, 0x1D172),
    (0x1D17B, 0x1D182),
    (0x1D185, 0x1D18B),
    (0x1D1AA, 0x1D1AD),
    (0x1D242, 0x1D244),
    (0x1DA00, 0x1DA36),
    (0x1DA3B, 0x1DA6C),
    (0x1DA75, 0x1DA75),
    (0x1DA84, 0x1DA84),
    (0x1DA9B, 0x1DA9F),
    (0x1DAA1, 0x1DAAF),
    (0x1E000, 0x1E006),
    (0x1E008, 0x1E018),
    (0x1E01B, 0x1E021),
    (0x1E023, 0x1E024),
    (0x1E026, 0x1E02A),
    (0x1E08F, 0x1E08F),
    (0x1E130, 0x1E136),
    (0x1E2AE, 0x1E2AE),
    (0x1E2EC, 0x1E2EF),
    (0x1E4EC, 0x1E4EF),
    (0x1E5EE, 0x1E5EF),
    (0x1E8D0, 0x1E8D6),
    (0x1E944, 0x1E94A),
    (0xE0100, 0xE01EF),
];

/// Width 0 combining letters.
const COMBININGLETTERS_TABLE: &[(u32, u32)] = &[(0x01160, 0x011FF), (0x0D7B0, 0x0D7FF)];

/// Non-characters.
const NONCHAR_TABLE: &[(u32, u32)] = &[
    (0x0FDD0, 0x0FDEF),
    (0x0FFFE, 0x0FFFF),
    (0x1FFFE, 0x1FFFF),
    (0x2FFFE, 0x2FFFF),
    (0x3FFFE, 0x3FFFF),
    (0x4FFFE, 0x4FFFF),
    (0x5FFFE, 0x5FFFF),
    (0x6FFFE, 0x6FFFF),
    (0x7FFFE, 0x7FFFF),
    (0x8FFFE, 0x8FFFF),
    (0x9FFFE, 0x9FFFF),
    (0xAFFFE, 0xAFFFF),
    (0xBFFFE, 0xBFFFF),
    (0xCFFFE, 0xCFFFF),
    (0xDFFFE, 0xDFFFF),
    (0xEFFFE, 0xEFFFF),
    (0xFFFFE, 0xFFFFF),
    (0x10FFFE, 0x10FFFF),
];

fn in_table(arr: &[(u32, u32)], c: u32) -> bool {
    arr.binary_search_by(|(start, end)| {
        if c >= *start && c <= *end {
            std::cmp::Ordering::Equal
        } else {
            start.cmp(&c)
        }
    })
    .is_ok()
}

pub(crate) fn char_width(c: char) -> Option<usize> {
    let c = c as u32;

    if in_table(NONPRINT_TABLE, c)
        || in_table(NONCHAR_TABLE, c)
        || in_table(COMBINING_TABLE, c)
        || in_table(COMBININGLETTERS_TABLE, c)
    {
        Some(0)
    } else {
        // SAFETY: this was converted from a char in the first place.
        let c = unsafe { char::from_u32_unchecked(c) };

        // See https://github.com/ridiculousfish/widecharwidth/issues/32
        if c == '\u{ffa0}' || c == '\u{115f}' {
            Some(0)
        } else {
            None
        }
    }
}
