// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/websecurityscanner/v1/web_security_scanner.proto

#include "google/cloud/websecurityscanner/v1/web_security_scanner_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace websecurityscanner_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

WebSecurityScannerConnectionIdempotencyPolicy::
    ~WebSecurityScannerConnectionIdempotencyPolicy() = default;

std::unique_ptr<WebSecurityScannerConnectionIdempotencyPolicy>
WebSecurityScannerConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<WebSecurityScannerConnectionIdempotencyPolicy>(*this);
}

Idempotency WebSecurityScannerConnectionIdempotencyPolicy::CreateScanConfig(
    google::cloud::websecurityscanner::v1::CreateScanConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency WebSecurityScannerConnectionIdempotencyPolicy::DeleteScanConfig(
    google::cloud::websecurityscanner::v1::DeleteScanConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency WebSecurityScannerConnectionIdempotencyPolicy::GetScanConfig(
    google::cloud::websecurityscanner::v1::GetScanConfigRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency WebSecurityScannerConnectionIdempotencyPolicy::ListScanConfigs(
    google::cloud::websecurityscanner::v1::ListScanConfigsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency WebSecurityScannerConnectionIdempotencyPolicy::UpdateScanConfig(
    google::cloud::websecurityscanner::v1::UpdateScanConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency WebSecurityScannerConnectionIdempotencyPolicy::StartScanRun(
    google::cloud::websecurityscanner::v1::StartScanRunRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency WebSecurityScannerConnectionIdempotencyPolicy::GetScanRun(
    google::cloud::websecurityscanner::v1::GetScanRunRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency WebSecurityScannerConnectionIdempotencyPolicy::ListScanRuns(
    google::cloud::websecurityscanner::v1::ListScanRunsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency WebSecurityScannerConnectionIdempotencyPolicy::StopScanRun(
    google::cloud::websecurityscanner::v1::StopScanRunRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency WebSecurityScannerConnectionIdempotencyPolicy::ListCrawledUrls(
    google::cloud::websecurityscanner::v1::ListCrawledUrlsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency WebSecurityScannerConnectionIdempotencyPolicy::GetFinding(
    google::cloud::websecurityscanner::v1::GetFindingRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency WebSecurityScannerConnectionIdempotencyPolicy::ListFindings(
    google::cloud::websecurityscanner::v1::ListFindingsRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency WebSecurityScannerConnectionIdempotencyPolicy::ListFindingTypeStats(
    google::cloud::websecurityscanner::v1::ListFindingTypeStatsRequest const&) {
  return Idempotency::kIdempotent;
}

std::unique_ptr<WebSecurityScannerConnectionIdempotencyPolicy>
MakeDefaultWebSecurityScannerConnectionIdempotencyPolicy() {
  return std::make_unique<WebSecurityScannerConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace websecurityscanner_v1
}  // namespace cloud
}  // namespace google
