// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/sql/v1/cloud_sql_instances.proto

#include "google/cloud/sql/v1/sql_instances_connection_idempotency_policy.h"
#include <memory>

namespace google {
namespace cloud {
namespace sql_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

using ::google::cloud::Idempotency;

SqlInstancesServiceConnectionIdempotencyPolicy::
    ~SqlInstancesServiceConnectionIdempotencyPolicy() = default;

std::unique_ptr<SqlInstancesServiceConnectionIdempotencyPolicy>
SqlInstancesServiceConnectionIdempotencyPolicy::clone() const {
  return std::make_unique<SqlInstancesServiceConnectionIdempotencyPolicy>(
      *this);
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::AddServerCa(
    google::cloud::sql::v1::SqlInstancesAddServerCaRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::Clone(
    google::cloud::sql::v1::SqlInstancesCloneRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::Delete(
    google::cloud::sql::v1::SqlInstancesDeleteRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::DemoteMaster(
    google::cloud::sql::v1::SqlInstancesDemoteMasterRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::Demote(
    google::cloud::sql::v1::SqlInstancesDemoteRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::Export(
    google::cloud::sql::v1::SqlInstancesExportRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::Failover(
    google::cloud::sql::v1::SqlInstancesFailoverRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::Reencrypt(
    google::cloud::sql::v1::SqlInstancesReencryptRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::Get(
    google::cloud::sql::v1::SqlInstancesGetRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::Import(
    google::cloud::sql::v1::SqlInstancesImportRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::Insert(
    google::cloud::sql::v1::SqlInstancesInsertRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::List(
    google::cloud::sql::v1::SqlInstancesListRequest) {  // NOLINT
  return Idempotency::kIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::ListServerCas(
    google::cloud::sql::v1::SqlInstancesListServerCasRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::Patch(
    google::cloud::sql::v1::SqlInstancesPatchRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::PromoteReplica(
    google::cloud::sql::v1::SqlInstancesPromoteReplicaRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::Switchover(
    google::cloud::sql::v1::SqlInstancesSwitchoverRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::ResetSslConfig(
    google::cloud::sql::v1::SqlInstancesResetSslConfigRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::Restart(
    google::cloud::sql::v1::SqlInstancesRestartRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::RestoreBackup(
    google::cloud::sql::v1::SqlInstancesRestoreBackupRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::RotateServerCa(
    google::cloud::sql::v1::SqlInstancesRotateServerCaRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::StartReplica(
    google::cloud::sql::v1::SqlInstancesStartReplicaRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::StopReplica(
    google::cloud::sql::v1::SqlInstancesStopReplicaRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::TruncateLog(
    google::cloud::sql::v1::SqlInstancesTruncateLogRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::Update(
    google::cloud::sql::v1::SqlInstancesUpdateRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::CreateEphemeral(
    google::cloud::sql::v1::SqlInstancesCreateEphemeralCertRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
SqlInstancesServiceConnectionIdempotencyPolicy::RescheduleMaintenance(
    google::cloud::sql::v1::SqlInstancesRescheduleMaintenanceRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
SqlInstancesServiceConnectionIdempotencyPolicy::VerifyExternalSyncSettings(
    google::cloud::sql::v1::
        SqlInstancesVerifyExternalSyncSettingsRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::StartExternalSync(
    google::cloud::sql::v1::SqlInstancesStartExternalSyncRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::PerformDiskShrink(
    google::cloud::sql::v1::SqlInstancesPerformDiskShrinkRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::GetDiskShrinkConfig(
    google::cloud::sql::v1::SqlInstancesGetDiskShrinkConfigRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::ResetReplicaSize(
    google::cloud::sql::v1::SqlInstancesResetReplicaSizeRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency
SqlInstancesServiceConnectionIdempotencyPolicy::GetLatestRecoveryTime(
    google::cloud::sql::v1::SqlInstancesGetLatestRecoveryTimeRequest const&) {
  return Idempotency::kIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::AcquireSsrsLease(
    google::cloud::sql::v1::SqlInstancesAcquireSsrsLeaseRequest const&) {
  return Idempotency::kNonIdempotent;
}

Idempotency SqlInstancesServiceConnectionIdempotencyPolicy::ReleaseSsrsLease(
    google::cloud::sql::v1::SqlInstancesReleaseSsrsLeaseRequest const&) {
  return Idempotency::kNonIdempotent;
}

std::unique_ptr<SqlInstancesServiceConnectionIdempotencyPolicy>
MakeDefaultSqlInstancesServiceConnectionIdempotencyPolicy() {
  return std::make_unique<SqlInstancesServiceConnectionIdempotencyPolicy>();
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace sql_v1
}  // namespace cloud
}  // namespace google
