// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/api/serviceusage/v1/serviceusage.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEUSAGE_V1_MOCKS_MOCK_SERVICE_USAGE_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEUSAGE_V1_MOCKS_MOCK_SERVICE_USAGE_CONNECTION_H

#include "google/cloud/serviceusage/v1/service_usage_connection.h"
#include <gmock/gmock.h>

namespace google {
namespace cloud {
namespace serviceusage_v1_mocks {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/**
 * A class to mock `ServiceUsageConnection`.
 *
 * Application developers may want to test their code with simulated responses,
 * including errors, from an object of type `ServiceUsageClient`. To do so,
 * construct an object of type `ServiceUsageClient` with an instance of this
 * class. Then use the Google Test framework functions to program the behavior
 * of this mock.
 *
 * @see [This example][bq-mock] for how to test your application with GoogleTest.
 * While the example showcases types from the BigQuery library, the underlying
 * principles apply for any pair of `*Client` and `*Connection`.
 *
 * [bq-mock]: @cloud_cpp_docs_link{bigquery,bigquery-read-mock}
 */
class MockServiceUsageConnection
    : public serviceusage_v1::ServiceUsageConnection {
 public:
  MOCK_METHOD(Options, options, (), (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// EnableService(Matcher<google::api::serviceusage::v1::EnableServiceRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::api::serviceusage::v1::EnableServiceResponse>>,
      EnableService,
      (google::api::serviceusage::v1::EnableServiceRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, EnableService(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, EnableService,
      (NoAwaitTag,
       google::api::serviceusage::v1::EnableServiceRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, EnableService(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::api::serviceusage::v1::EnableServiceResponse>>,
      EnableService, (google::longrunning::Operation const& operation),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// DisableService(Matcher<google::api::serviceusage::v1::DisableServiceRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::api::serviceusage::v1::DisableServiceResponse>>,
      DisableService,
      (google::api::serviceusage::v1::DisableServiceRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, DisableService(_, _))
  /// @endcode
  MOCK_METHOD(
      StatusOr<google::longrunning::Operation>, DisableService,
      (NoAwaitTag,
       google::api::serviceusage::v1::DisableServiceRequest const& request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock, DisableService(Matcher<google::longrunning::Operation
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<StatusOr<google::api::serviceusage::v1::DisableServiceResponse>>,
      DisableService, (google::longrunning::Operation const& operation),
      (override));

  MOCK_METHOD(StatusOr<google::api::serviceusage::v1::Service>, GetService,
              (google::api::serviceusage::v1::GetServiceRequest const& request),
              (override));

  MOCK_METHOD((StreamRange<google::api::serviceusage::v1::Service>),
              ListServices,
              (google::api::serviceusage::v1::ListServicesRequest request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// BatchEnableServices(Matcher<google::api::serviceusage::v1::BatchEnableServicesRequest
  /// const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<
          StatusOr<google::api::serviceusage::v1::BatchEnableServicesResponse>>,
      BatchEnableServices,
      (google::api::serviceusage::v1::BatchEnableServicesRequest const&
           request),
      (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// EXPECT_CALL(*mock, BatchEnableServices(_, _))
  /// @endcode
  MOCK_METHOD(StatusOr<google::longrunning::Operation>, BatchEnableServices,
              (NoAwaitTag,
               google::api::serviceusage::v1::BatchEnableServicesRequest const&
                   request),
              (override));

  /// To disambiguate calls, use:
  ///
  /// @code
  /// using ::testing::_;
  /// using ::testing::Matcher;
  /// EXPECT_CALL(*mock,
  /// BatchEnableServices(Matcher<google::longrunning::Operation const&>(_)))
  /// @endcode
  MOCK_METHOD(
      future<
          StatusOr<google::api::serviceusage::v1::BatchEnableServicesResponse>>,
      BatchEnableServices, (google::longrunning::Operation const& operation),
      (override));

  MOCK_METHOD(
      StatusOr<google::api::serviceusage::v1::BatchGetServicesResponse>,
      BatchGetServices,
      (google::api::serviceusage::v1::BatchGetServicesRequest const& request),
      (override));
};

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace serviceusage_v1_mocks
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_SERVICEUSAGE_V1_MOCKS_MOCK_SERVICE_USAGE_CONNECTION_H
