// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/oslogin/v1/oslogin.proto

#include "google/cloud/oslogin/v1/internal/os_login_logging_decorator.h"
#include "google/cloud/internal/log_wrapper.h"
#include "google/cloud/status_or.h"
#include <google/cloud/oslogin/v1/oslogin.grpc.pb.h>
#include <memory>
#include <set>
#include <string>
#include <utility>

namespace google {
namespace cloud {
namespace oslogin_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

OsLoginServiceLogging::OsLoginServiceLogging(
    std::shared_ptr<OsLoginServiceStub> child, TracingOptions tracing_options,
    std::set<std::string> const&)
    : child_(std::move(child)), tracing_options_(std::move(tracing_options)) {}

StatusOr<google::cloud::oslogin::common::SshPublicKey>
OsLoginServiceLogging::CreateSshPublicKey(
    grpc::ClientContext& context, Options const& options,
    google::cloud::oslogin::v1::CreateSshPublicKeyRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::oslogin::v1::CreateSshPublicKeyRequest const&
                 request) {
        return child_->CreateSshPublicKey(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status OsLoginServiceLogging::DeletePosixAccount(
    grpc::ClientContext& context, Options const& options,
    google::cloud::oslogin::v1::DeletePosixAccountRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::oslogin::v1::DeletePosixAccountRequest const&
                 request) {
        return child_->DeletePosixAccount(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

Status OsLoginServiceLogging::DeleteSshPublicKey(
    grpc::ClientContext& context, Options const& options,
    google::cloud::oslogin::v1::DeleteSshPublicKeyRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::oslogin::v1::DeleteSshPublicKeyRequest const&
                 request) {
        return child_->DeleteSshPublicKey(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::oslogin::v1::LoginProfile>
OsLoginServiceLogging::GetLoginProfile(
    grpc::ClientContext& context, Options const& options,
    google::cloud::oslogin::v1::GetLoginProfileRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::oslogin::v1::GetLoginProfileRequest const& request) {
        return child_->GetLoginProfile(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::oslogin::common::SshPublicKey>
OsLoginServiceLogging::GetSshPublicKey(
    grpc::ClientContext& context, Options const& options,
    google::cloud::oslogin::v1::GetSshPublicKeyRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](
          grpc::ClientContext& context, Options const& options,
          google::cloud::oslogin::v1::GetSshPublicKeyRequest const& request) {
        return child_->GetSshPublicKey(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::oslogin::v1::ImportSshPublicKeyResponse>
OsLoginServiceLogging::ImportSshPublicKey(
    grpc::ClientContext& context, Options const& options,
    google::cloud::oslogin::v1::ImportSshPublicKeyRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::oslogin::v1::ImportSshPublicKeyRequest const&
                 request) {
        return child_->ImportSshPublicKey(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

StatusOr<google::cloud::oslogin::common::SshPublicKey>
OsLoginServiceLogging::UpdateSshPublicKey(
    grpc::ClientContext& context, Options const& options,
    google::cloud::oslogin::v1::UpdateSshPublicKeyRequest const& request) {
  return google::cloud::internal::LogWrapper(
      [this](grpc::ClientContext& context, Options const& options,
             google::cloud::oslogin::v1::UpdateSshPublicKeyRequest const&
                 request) {
        return child_->UpdateSshPublicKey(context, options, request);
      },
      context, options, request, __func__, tracing_options_);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace oslogin_v1_internal
}  // namespace cloud
}  // namespace google
