// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/networkmanagement/v1/reachability.proto

#include "google/cloud/networkmanagement/v1/internal/reachability_stub.h"
#include "google/cloud/grpc_error_delegate.h"
#include "google/cloud/status_or.h"
#include <google/cloud/networkmanagement/v1/reachability.grpc.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace networkmanagement_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

ReachabilityServiceStub::~ReachabilityServiceStub() = default;

StatusOr<google::cloud::networkmanagement::v1::ListConnectivityTestsResponse>
DefaultReachabilityServiceStub::ListConnectivityTests(
    grpc::ClientContext& context, Options const&,
    google::cloud::networkmanagement::v1::ListConnectivityTestsRequest const&
        request) {
  google::cloud::networkmanagement::v1::ListConnectivityTestsResponse response;
  auto status = grpc_stub_->ListConnectivityTests(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

StatusOr<google::cloud::networkmanagement::v1::ConnectivityTest>
DefaultReachabilityServiceStub::GetConnectivityTest(
    grpc::ClientContext& context, Options const&,
    google::cloud::networkmanagement::v1::GetConnectivityTestRequest const&
        request) {
  google::cloud::networkmanagement::v1::ConnectivityTest response;
  auto status = grpc_stub_->GetConnectivityTest(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultReachabilityServiceStub::AsyncCreateConnectivityTest(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::networkmanagement::v1::CreateConnectivityTestRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::networkmanagement::v1::CreateConnectivityTestRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::networkmanagement::v1::
                 CreateConnectivityTestRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncCreateConnectivityTest(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultReachabilityServiceStub::CreateConnectivityTest(
    grpc::ClientContext& context, Options,
    google::cloud::networkmanagement::v1::CreateConnectivityTestRequest const&
        request) {
  google::longrunning::Operation response;
  auto status =
      grpc_stub_->CreateConnectivityTest(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultReachabilityServiceStub::AsyncUpdateConnectivityTest(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::networkmanagement::v1::UpdateConnectivityTestRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::networkmanagement::v1::UpdateConnectivityTestRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::networkmanagement::v1::
                 UpdateConnectivityTestRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncUpdateConnectivityTest(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultReachabilityServiceStub::UpdateConnectivityTest(
    grpc::ClientContext& context, Options,
    google::cloud::networkmanagement::v1::UpdateConnectivityTestRequest const&
        request) {
  google::longrunning::Operation response;
  auto status =
      grpc_stub_->UpdateConnectivityTest(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultReachabilityServiceStub::AsyncRerunConnectivityTest(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::networkmanagement::v1::RerunConnectivityTestRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::networkmanagement::v1::RerunConnectivityTestRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::networkmanagement::v1::
                 RerunConnectivityTestRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncRerunConnectivityTest(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultReachabilityServiceStub::RerunConnectivityTest(
    grpc::ClientContext& context, Options,
    google::cloud::networkmanagement::v1::RerunConnectivityTestRequest const&
        request) {
  google::longrunning::Operation response;
  auto status = grpc_stub_->RerunConnectivityTest(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultReachabilityServiceStub::AsyncDeleteConnectivityTest(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::cloud::internal::ImmutableOptions,
    google::cloud::networkmanagement::v1::DeleteConnectivityTestRequest const&
        request) {
  return internal::MakeUnaryRpcImpl<
      google::cloud::networkmanagement::v1::DeleteConnectivityTestRequest,
      google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::cloud::networkmanagement::v1::
                 DeleteConnectivityTestRequest const& request,
             grpc::CompletionQueue* cq) {
        return grpc_stub_->AsyncDeleteConnectivityTest(context, request, cq);
      },
      request, std::move(context));
}

StatusOr<google::longrunning::Operation>
DefaultReachabilityServiceStub::DeleteConnectivityTest(
    grpc::ClientContext& context, Options,
    google::cloud::networkmanagement::v1::DeleteConnectivityTestRequest const&
        request) {
  google::longrunning::Operation response;
  auto status =
      grpc_stub_->DeleteConnectivityTest(&context, request, &response);
  if (!status.ok()) {
    return google::cloud::MakeStatusFromRpcError(status);
  }
  return response;
}

future<StatusOr<google::longrunning::Operation>>
DefaultReachabilityServiceStub::AsyncGetOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    // NOLINTNEXTLINE(performance-unnecessary-value-param)
    google::cloud::internal::ImmutableOptions,
    google::longrunning::GetOperationRequest const& request) {
  return internal::MakeUnaryRpcImpl<google::longrunning::GetOperationRequest,
                                    google::longrunning::Operation>(
      cq,
      [this](grpc::ClientContext* context,
             google::longrunning::GetOperationRequest const& request,
             grpc::CompletionQueue* cq) {
        return operations_->AsyncGetOperation(context, request, cq);
      },
      request, std::move(context));
}

future<Status> DefaultReachabilityServiceStub::AsyncCancelOperation(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    // NOLINTNEXTLINE(performance-unnecessary-value-param)
    google::cloud::internal::ImmutableOptions,
    google::longrunning::CancelOperationRequest const& request) {
  return internal::MakeUnaryRpcImpl<google::longrunning::CancelOperationRequest,
                                    google::protobuf::Empty>(
             cq,
             [this](grpc::ClientContext* context,
                    google::longrunning::CancelOperationRequest const& request,
                    grpc::CompletionQueue* cq) {
               return operations_->AsyncCancelOperation(context, request, cq);
             },
             request, std::move(context))
      .then([](future<StatusOr<google::protobuf::Empty>> f) {
        return f.get().status();
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace networkmanagement_v1_internal
}  // namespace cloud
}  // namespace google
