// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/monitoring/dashboard/v1/dashboards_service.proto

#include "google/cloud/monitoring/dashboard/v1/dashboards_connection.h"
#include "google/cloud/monitoring/dashboard/v1/dashboards_options.h"
#include "google/cloud/monitoring/dashboard/v1/internal/dashboards_connection_impl.h"
#include "google/cloud/monitoring/dashboard/v1/internal/dashboards_option_defaults.h"
#include "google/cloud/monitoring/dashboard/v1/internal/dashboards_stub_factory.h"
#include "google/cloud/monitoring/dashboard/v1/internal/dashboards_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace monitoring_dashboard_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

DashboardsServiceConnection::~DashboardsServiceConnection() = default;

StatusOr<google::monitoring::dashboard::v1::Dashboard>
DashboardsServiceConnection::CreateDashboard(
    google::monitoring::dashboard::v1::CreateDashboardRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::monitoring::dashboard::v1::Dashboard>
DashboardsServiceConnection::ListDashboards(
    google::monitoring::dashboard::v1::
        ListDashboardsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::monitoring::dashboard::v1::Dashboard>>();
}

StatusOr<google::monitoring::dashboard::v1::Dashboard>
DashboardsServiceConnection::GetDashboard(
    google::monitoring::dashboard::v1::GetDashboardRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status DashboardsServiceConnection::DeleteDashboard(
    google::monitoring::dashboard::v1::DeleteDashboardRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::monitoring::dashboard::v1::Dashboard>
DashboardsServiceConnection::UpdateDashboard(
    google::monitoring::dashboard::v1::UpdateDashboardRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<DashboardsServiceConnection> MakeDashboardsServiceConnection(
    Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 DashboardsServicePolicyOptionList>(options,
                                                                    __func__);
  options = monitoring_dashboard_v1_internal::DashboardsServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub =
      monitoring_dashboard_v1_internal::CreateDefaultDashboardsServiceStub(
          std::move(auth), options);
  return monitoring_dashboard_v1_internal::
      MakeDashboardsServiceTracingConnection(
          std::make_shared<monitoring_dashboard_v1_internal::
                               DashboardsServiceConnectionImpl>(
              std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace monitoring_dashboard_v1
}  // namespace cloud
}  // namespace google
