// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/migrationcenter/v1/migrationcenter.proto

#include "google/cloud/migrationcenter/v1/migration_center_client.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace migrationcenter_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

MigrationCenterClient::MigrationCenterClient(
    std::shared_ptr<MigrationCenterConnection> connection, Options opts)
    : connection_(std::move(connection)),
      options_(
          internal::MergeOptions(std::move(opts), connection_->options())) {}
MigrationCenterClient::~MigrationCenterClient() = default;

StreamRange<google::cloud::migrationcenter::v1::Asset>
MigrationCenterClient::ListAssets(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::ListAssetsRequest request;
  request.set_parent(parent);
  return connection_->ListAssets(request);
}

StreamRange<google::cloud::migrationcenter::v1::Asset>
MigrationCenterClient::ListAssets(
    google::cloud::migrationcenter::v1::ListAssetsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListAssets(std::move(request));
}

StatusOr<google::cloud::migrationcenter::v1::Asset>
MigrationCenterClient::GetAsset(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::GetAssetRequest request;
  request.set_name(name);
  return connection_->GetAsset(request);
}

StatusOr<google::cloud::migrationcenter::v1::Asset>
MigrationCenterClient::GetAsset(
    google::cloud::migrationcenter::v1::GetAssetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetAsset(request);
}

StatusOr<google::cloud::migrationcenter::v1::Asset>
MigrationCenterClient::UpdateAsset(
    google::cloud::migrationcenter::v1::Asset const& asset,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::UpdateAssetRequest request;
  *request.mutable_asset() = asset;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateAsset(request);
}

StatusOr<google::cloud::migrationcenter::v1::Asset>
MigrationCenterClient::UpdateAsset(
    google::cloud::migrationcenter::v1::UpdateAssetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateAsset(request);
}

StatusOr<google::cloud::migrationcenter::v1::BatchUpdateAssetsResponse>
MigrationCenterClient::BatchUpdateAssets(
    std::string const& parent,
    std::vector<google::cloud::migrationcenter::v1::UpdateAssetRequest> const&
        requests,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::BatchUpdateAssetsRequest request;
  request.set_parent(parent);
  *request.mutable_requests() = {requests.begin(), requests.end()};
  return connection_->BatchUpdateAssets(request);
}

StatusOr<google::cloud::migrationcenter::v1::BatchUpdateAssetsResponse>
MigrationCenterClient::BatchUpdateAssets(
    google::cloud::migrationcenter::v1::BatchUpdateAssetsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchUpdateAssets(request);
}

Status MigrationCenterClient::DeleteAsset(std::string const& name,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::DeleteAssetRequest request;
  request.set_name(name);
  return connection_->DeleteAsset(request);
}

Status MigrationCenterClient::DeleteAsset(
    google::cloud::migrationcenter::v1::DeleteAssetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteAsset(request);
}

Status MigrationCenterClient::BatchDeleteAssets(
    std::string const& parent, std::vector<std::string> const& names,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::BatchDeleteAssetsRequest request;
  request.set_parent(parent);
  *request.mutable_names() = {names.begin(), names.end()};
  return connection_->BatchDeleteAssets(request);
}

Status MigrationCenterClient::BatchDeleteAssets(
    google::cloud::migrationcenter::v1::BatchDeleteAssetsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->BatchDeleteAssets(request);
}

StatusOr<google::cloud::migrationcenter::v1::ReportAssetFramesResponse>
MigrationCenterClient::ReportAssetFrames(
    google::cloud::migrationcenter::v1::ReportAssetFramesRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ReportAssetFrames(request);
}

StatusOr<google::cloud::migrationcenter::v1::AggregateAssetsValuesResponse>
MigrationCenterClient::AggregateAssetsValues(
    google::cloud::migrationcenter::v1::AggregateAssetsValuesRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AggregateAssetsValues(request);
}

future<StatusOr<google::cloud::migrationcenter::v1::ImportJob>>
MigrationCenterClient::CreateImportJob(
    std::string const& parent,
    google::cloud::migrationcenter::v1::ImportJob const& import_job,
    std::string const& import_job_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::CreateImportJobRequest request;
  request.set_parent(parent);
  *request.mutable_import_job() = import_job;
  request.set_import_job_id(import_job_id);
  return connection_->CreateImportJob(request);
}

StatusOr<google::longrunning::Operation> MigrationCenterClient::CreateImportJob(
    NoAwaitTag, std::string const& parent,
    google::cloud::migrationcenter::v1::ImportJob const& import_job,
    std::string const& import_job_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::CreateImportJobRequest request;
  request.set_parent(parent);
  *request.mutable_import_job() = import_job;
  request.set_import_job_id(import_job_id);
  return connection_->CreateImportJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::ImportJob>>
MigrationCenterClient::CreateImportJob(
    google::cloud::migrationcenter::v1::CreateImportJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateImportJob(request);
}

StatusOr<google::longrunning::Operation> MigrationCenterClient::CreateImportJob(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::CreateImportJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateImportJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::ImportJob>>
MigrationCenterClient::CreateImportJob(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateImportJob(operation);
}

StreamRange<google::cloud::migrationcenter::v1::ImportJob>
MigrationCenterClient::ListImportJobs(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::ListImportJobsRequest request;
  request.set_parent(parent);
  return connection_->ListImportJobs(request);
}

StreamRange<google::cloud::migrationcenter::v1::ImportJob>
MigrationCenterClient::ListImportJobs(
    google::cloud::migrationcenter::v1::ListImportJobsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListImportJobs(std::move(request));
}

StatusOr<google::cloud::migrationcenter::v1::ImportJob>
MigrationCenterClient::GetImportJob(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::GetImportJobRequest request;
  request.set_name(name);
  return connection_->GetImportJob(request);
}

StatusOr<google::cloud::migrationcenter::v1::ImportJob>
MigrationCenterClient::GetImportJob(
    google::cloud::migrationcenter::v1::GetImportJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetImportJob(request);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterClient::DeleteImportJob(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::DeleteImportJobRequest request;
  request.set_name(name);
  return connection_->DeleteImportJob(request);
}

StatusOr<google::longrunning::Operation> MigrationCenterClient::DeleteImportJob(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::DeleteImportJobRequest request;
  request.set_name(name);
  return connection_->DeleteImportJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterClient::DeleteImportJob(
    google::cloud::migrationcenter::v1::DeleteImportJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteImportJob(request);
}

StatusOr<google::longrunning::Operation> MigrationCenterClient::DeleteImportJob(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::DeleteImportJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteImportJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterClient::DeleteImportJob(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteImportJob(operation);
}

future<StatusOr<google::cloud::migrationcenter::v1::ImportJob>>
MigrationCenterClient::UpdateImportJob(
    google::cloud::migrationcenter::v1::ImportJob const& import_job,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::UpdateImportJobRequest request;
  *request.mutable_import_job() = import_job;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateImportJob(request);
}

StatusOr<google::longrunning::Operation> MigrationCenterClient::UpdateImportJob(
    NoAwaitTag, google::cloud::migrationcenter::v1::ImportJob const& import_job,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::UpdateImportJobRequest request;
  *request.mutable_import_job() = import_job;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateImportJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::ImportJob>>
MigrationCenterClient::UpdateImportJob(
    google::cloud::migrationcenter::v1::UpdateImportJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateImportJob(request);
}

StatusOr<google::longrunning::Operation> MigrationCenterClient::UpdateImportJob(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::UpdateImportJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateImportJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::ImportJob>>
MigrationCenterClient::UpdateImportJob(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateImportJob(operation);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterClient::ValidateImportJob(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::ValidateImportJobRequest request;
  request.set_name(name);
  return connection_->ValidateImportJob(request);
}

StatusOr<google::longrunning::Operation>
MigrationCenterClient::ValidateImportJob(NoAwaitTag, std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::ValidateImportJobRequest request;
  request.set_name(name);
  return connection_->ValidateImportJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterClient::ValidateImportJob(
    google::cloud::migrationcenter::v1::ValidateImportJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ValidateImportJob(request);
}

StatusOr<google::longrunning::Operation>
MigrationCenterClient::ValidateImportJob(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::ValidateImportJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ValidateImportJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterClient::ValidateImportJob(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ValidateImportJob(operation);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterClient::RunImportJob(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::RunImportJobRequest request;
  request.set_name(name);
  return connection_->RunImportJob(request);
}

StatusOr<google::longrunning::Operation> MigrationCenterClient::RunImportJob(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::RunImportJobRequest request;
  request.set_name(name);
  return connection_->RunImportJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterClient::RunImportJob(
    google::cloud::migrationcenter::v1::RunImportJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RunImportJob(request);
}

StatusOr<google::longrunning::Operation> MigrationCenterClient::RunImportJob(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::RunImportJobRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RunImportJob(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterClient::RunImportJob(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RunImportJob(operation);
}

StatusOr<google::cloud::migrationcenter::v1::ImportDataFile>
MigrationCenterClient::GetImportDataFile(std::string const& name,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::GetImportDataFileRequest request;
  request.set_name(name);
  return connection_->GetImportDataFile(request);
}

StatusOr<google::cloud::migrationcenter::v1::ImportDataFile>
MigrationCenterClient::GetImportDataFile(
    google::cloud::migrationcenter::v1::GetImportDataFileRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetImportDataFile(request);
}

StreamRange<google::cloud::migrationcenter::v1::ImportDataFile>
MigrationCenterClient::ListImportDataFiles(std::string const& parent,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::ListImportDataFilesRequest request;
  request.set_parent(parent);
  return connection_->ListImportDataFiles(request);
}

StreamRange<google::cloud::migrationcenter::v1::ImportDataFile>
MigrationCenterClient::ListImportDataFiles(
    google::cloud::migrationcenter::v1::ListImportDataFilesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListImportDataFiles(std::move(request));
}

future<StatusOr<google::cloud::migrationcenter::v1::ImportDataFile>>
MigrationCenterClient::CreateImportDataFile(
    std::string const& parent,
    google::cloud::migrationcenter::v1::ImportDataFile const& import_data_file,
    std::string const& import_data_file_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::CreateImportDataFileRequest request;
  request.set_parent(parent);
  *request.mutable_import_data_file() = import_data_file;
  request.set_import_data_file_id(import_data_file_id);
  return connection_->CreateImportDataFile(request);
}

StatusOr<google::longrunning::Operation>
MigrationCenterClient::CreateImportDataFile(
    NoAwaitTag, std::string const& parent,
    google::cloud::migrationcenter::v1::ImportDataFile const& import_data_file,
    std::string const& import_data_file_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::CreateImportDataFileRequest request;
  request.set_parent(parent);
  *request.mutable_import_data_file() = import_data_file;
  request.set_import_data_file_id(import_data_file_id);
  return connection_->CreateImportDataFile(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::ImportDataFile>>
MigrationCenterClient::CreateImportDataFile(
    google::cloud::migrationcenter::v1::CreateImportDataFileRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateImportDataFile(request);
}

StatusOr<google::longrunning::Operation>
MigrationCenterClient::CreateImportDataFile(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::CreateImportDataFileRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateImportDataFile(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::ImportDataFile>>
MigrationCenterClient::CreateImportDataFile(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateImportDataFile(operation);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterClient::DeleteImportDataFile(std::string const& name,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::DeleteImportDataFileRequest request;
  request.set_name(name);
  return connection_->DeleteImportDataFile(request);
}

StatusOr<google::longrunning::Operation>
MigrationCenterClient::DeleteImportDataFile(NoAwaitTag, std::string const& name,
                                            Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::DeleteImportDataFileRequest request;
  request.set_name(name);
  return connection_->DeleteImportDataFile(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterClient::DeleteImportDataFile(
    google::cloud::migrationcenter::v1::DeleteImportDataFileRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteImportDataFile(request);
}

StatusOr<google::longrunning::Operation>
MigrationCenterClient::DeleteImportDataFile(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::DeleteImportDataFileRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteImportDataFile(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterClient::DeleteImportDataFile(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteImportDataFile(operation);
}

StreamRange<google::cloud::migrationcenter::v1::Group>
MigrationCenterClient::ListGroups(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::ListGroupsRequest request;
  request.set_parent(parent);
  return connection_->ListGroups(request);
}

StreamRange<google::cloud::migrationcenter::v1::Group>
MigrationCenterClient::ListGroups(
    google::cloud::migrationcenter::v1::ListGroupsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListGroups(std::move(request));
}

StatusOr<google::cloud::migrationcenter::v1::Group>
MigrationCenterClient::GetGroup(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::GetGroupRequest request;
  request.set_name(name);
  return connection_->GetGroup(request);
}

StatusOr<google::cloud::migrationcenter::v1::Group>
MigrationCenterClient::GetGroup(
    google::cloud::migrationcenter::v1::GetGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetGroup(request);
}

future<StatusOr<google::cloud::migrationcenter::v1::Group>>
MigrationCenterClient::CreateGroup(
    std::string const& parent,
    google::cloud::migrationcenter::v1::Group const& group,
    std::string const& group_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::CreateGroupRequest request;
  request.set_parent(parent);
  *request.mutable_group() = group;
  request.set_group_id(group_id);
  return connection_->CreateGroup(request);
}

StatusOr<google::longrunning::Operation> MigrationCenterClient::CreateGroup(
    NoAwaitTag, std::string const& parent,
    google::cloud::migrationcenter::v1::Group const& group,
    std::string const& group_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::CreateGroupRequest request;
  request.set_parent(parent);
  *request.mutable_group() = group;
  request.set_group_id(group_id);
  return connection_->CreateGroup(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::Group>>
MigrationCenterClient::CreateGroup(
    google::cloud::migrationcenter::v1::CreateGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateGroup(request);
}

StatusOr<google::longrunning::Operation> MigrationCenterClient::CreateGroup(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::CreateGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateGroup(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::Group>>
MigrationCenterClient::CreateGroup(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateGroup(operation);
}

future<StatusOr<google::cloud::migrationcenter::v1::Group>>
MigrationCenterClient::UpdateGroup(
    google::cloud::migrationcenter::v1::Group const& group,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::UpdateGroupRequest request;
  *request.mutable_group() = group;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateGroup(request);
}

StatusOr<google::longrunning::Operation> MigrationCenterClient::UpdateGroup(
    NoAwaitTag, google::cloud::migrationcenter::v1::Group const& group,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::UpdateGroupRequest request;
  *request.mutable_group() = group;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateGroup(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::Group>>
MigrationCenterClient::UpdateGroup(
    google::cloud::migrationcenter::v1::UpdateGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateGroup(request);
}

StatusOr<google::longrunning::Operation> MigrationCenterClient::UpdateGroup(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::UpdateGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateGroup(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::Group>>
MigrationCenterClient::UpdateGroup(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateGroup(operation);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterClient::DeleteGroup(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::DeleteGroupRequest request;
  request.set_name(name);
  return connection_->DeleteGroup(request);
}

StatusOr<google::longrunning::Operation> MigrationCenterClient::DeleteGroup(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::DeleteGroupRequest request;
  request.set_name(name);
  return connection_->DeleteGroup(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterClient::DeleteGroup(
    google::cloud::migrationcenter::v1::DeleteGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteGroup(request);
}

StatusOr<google::longrunning::Operation> MigrationCenterClient::DeleteGroup(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::DeleteGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteGroup(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterClient::DeleteGroup(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteGroup(operation);
}

future<StatusOr<google::cloud::migrationcenter::v1::Group>>
MigrationCenterClient::AddAssetsToGroup(std::string const& group,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::AddAssetsToGroupRequest request;
  request.set_group(group);
  return connection_->AddAssetsToGroup(request);
}

StatusOr<google::longrunning::Operation>
MigrationCenterClient::AddAssetsToGroup(NoAwaitTag, std::string const& group,
                                        Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::AddAssetsToGroupRequest request;
  request.set_group(group);
  return connection_->AddAssetsToGroup(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::Group>>
MigrationCenterClient::AddAssetsToGroup(
    google::cloud::migrationcenter::v1::AddAssetsToGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AddAssetsToGroup(request);
}

StatusOr<google::longrunning::Operation>
MigrationCenterClient::AddAssetsToGroup(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::AddAssetsToGroupRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AddAssetsToGroup(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::Group>>
MigrationCenterClient::AddAssetsToGroup(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->AddAssetsToGroup(operation);
}

future<StatusOr<google::cloud::migrationcenter::v1::Group>>
MigrationCenterClient::RemoveAssetsFromGroup(std::string const& group,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::RemoveAssetsFromGroupRequest request;
  request.set_group(group);
  return connection_->RemoveAssetsFromGroup(request);
}

StatusOr<google::longrunning::Operation>
MigrationCenterClient::RemoveAssetsFromGroup(NoAwaitTag,
                                             std::string const& group,
                                             Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::RemoveAssetsFromGroupRequest request;
  request.set_group(group);
  return connection_->RemoveAssetsFromGroup(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::Group>>
MigrationCenterClient::RemoveAssetsFromGroup(
    google::cloud::migrationcenter::v1::RemoveAssetsFromGroupRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RemoveAssetsFromGroup(request);
}

StatusOr<google::longrunning::Operation>
MigrationCenterClient::RemoveAssetsFromGroup(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::RemoveAssetsFromGroupRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RemoveAssetsFromGroup(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::Group>>
MigrationCenterClient::RemoveAssetsFromGroup(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->RemoveAssetsFromGroup(operation);
}

StreamRange<google::cloud::migrationcenter::v1::ErrorFrame>
MigrationCenterClient::ListErrorFrames(std::string const& parent,
                                       Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::ListErrorFramesRequest request;
  request.set_parent(parent);
  return connection_->ListErrorFrames(request);
}

StreamRange<google::cloud::migrationcenter::v1::ErrorFrame>
MigrationCenterClient::ListErrorFrames(
    google::cloud::migrationcenter::v1::ListErrorFramesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListErrorFrames(std::move(request));
}

StatusOr<google::cloud::migrationcenter::v1::ErrorFrame>
MigrationCenterClient::GetErrorFrame(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::GetErrorFrameRequest request;
  request.set_name(name);
  return connection_->GetErrorFrame(request);
}

StatusOr<google::cloud::migrationcenter::v1::ErrorFrame>
MigrationCenterClient::GetErrorFrame(
    google::cloud::migrationcenter::v1::GetErrorFrameRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetErrorFrame(request);
}

StreamRange<google::cloud::migrationcenter::v1::Source>
MigrationCenterClient::ListSources(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::ListSourcesRequest request;
  request.set_parent(parent);
  return connection_->ListSources(request);
}

StreamRange<google::cloud::migrationcenter::v1::Source>
MigrationCenterClient::ListSources(
    google::cloud::migrationcenter::v1::ListSourcesRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListSources(std::move(request));
}

StatusOr<google::cloud::migrationcenter::v1::Source>
MigrationCenterClient::GetSource(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::GetSourceRequest request;
  request.set_name(name);
  return connection_->GetSource(request);
}

StatusOr<google::cloud::migrationcenter::v1::Source>
MigrationCenterClient::GetSource(
    google::cloud::migrationcenter::v1::GetSourceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetSource(request);
}

future<StatusOr<google::cloud::migrationcenter::v1::Source>>
MigrationCenterClient::CreateSource(
    std::string const& parent,
    google::cloud::migrationcenter::v1::Source const& source,
    std::string const& source_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::CreateSourceRequest request;
  request.set_parent(parent);
  *request.mutable_source() = source;
  request.set_source_id(source_id);
  return connection_->CreateSource(request);
}

StatusOr<google::longrunning::Operation> MigrationCenterClient::CreateSource(
    NoAwaitTag, std::string const& parent,
    google::cloud::migrationcenter::v1::Source const& source,
    std::string const& source_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::CreateSourceRequest request;
  request.set_parent(parent);
  *request.mutable_source() = source;
  request.set_source_id(source_id);
  return connection_->CreateSource(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::Source>>
MigrationCenterClient::CreateSource(
    google::cloud::migrationcenter::v1::CreateSourceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateSource(request);
}

StatusOr<google::longrunning::Operation> MigrationCenterClient::CreateSource(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::CreateSourceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateSource(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::Source>>
MigrationCenterClient::CreateSource(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateSource(operation);
}

future<StatusOr<google::cloud::migrationcenter::v1::Source>>
MigrationCenterClient::UpdateSource(
    google::cloud::migrationcenter::v1::Source const& source,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::UpdateSourceRequest request;
  *request.mutable_source() = source;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateSource(request);
}

StatusOr<google::longrunning::Operation> MigrationCenterClient::UpdateSource(
    NoAwaitTag, google::cloud::migrationcenter::v1::Source const& source,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::UpdateSourceRequest request;
  *request.mutable_source() = source;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateSource(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::Source>>
MigrationCenterClient::UpdateSource(
    google::cloud::migrationcenter::v1::UpdateSourceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateSource(request);
}

StatusOr<google::longrunning::Operation> MigrationCenterClient::UpdateSource(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::UpdateSourceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateSource(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::Source>>
MigrationCenterClient::UpdateSource(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateSource(operation);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterClient::DeleteSource(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::DeleteSourceRequest request;
  request.set_name(name);
  return connection_->DeleteSource(request);
}

StatusOr<google::longrunning::Operation> MigrationCenterClient::DeleteSource(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::DeleteSourceRequest request;
  request.set_name(name);
  return connection_->DeleteSource(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterClient::DeleteSource(
    google::cloud::migrationcenter::v1::DeleteSourceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteSource(request);
}

StatusOr<google::longrunning::Operation> MigrationCenterClient::DeleteSource(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::DeleteSourceRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteSource(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterClient::DeleteSource(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteSource(operation);
}

StreamRange<google::cloud::migrationcenter::v1::PreferenceSet>
MigrationCenterClient::ListPreferenceSets(std::string const& parent,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::ListPreferenceSetsRequest request;
  request.set_parent(parent);
  return connection_->ListPreferenceSets(request);
}

StreamRange<google::cloud::migrationcenter::v1::PreferenceSet>
MigrationCenterClient::ListPreferenceSets(
    google::cloud::migrationcenter::v1::ListPreferenceSetsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListPreferenceSets(std::move(request));
}

StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>
MigrationCenterClient::GetPreferenceSet(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::GetPreferenceSetRequest request;
  request.set_name(name);
  return connection_->GetPreferenceSet(request);
}

StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>
MigrationCenterClient::GetPreferenceSet(
    google::cloud::migrationcenter::v1::GetPreferenceSetRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetPreferenceSet(request);
}

future<StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>>
MigrationCenterClient::CreatePreferenceSet(
    std::string const& parent,
    google::cloud::migrationcenter::v1::PreferenceSet const& preference_set,
    std::string const& preference_set_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::CreatePreferenceSetRequest request;
  request.set_parent(parent);
  *request.mutable_preference_set() = preference_set;
  request.set_preference_set_id(preference_set_id);
  return connection_->CreatePreferenceSet(request);
}

StatusOr<google::longrunning::Operation>
MigrationCenterClient::CreatePreferenceSet(
    NoAwaitTag, std::string const& parent,
    google::cloud::migrationcenter::v1::PreferenceSet const& preference_set,
    std::string const& preference_set_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::CreatePreferenceSetRequest request;
  request.set_parent(parent);
  *request.mutable_preference_set() = preference_set;
  request.set_preference_set_id(preference_set_id);
  return connection_->CreatePreferenceSet(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>>
MigrationCenterClient::CreatePreferenceSet(
    google::cloud::migrationcenter::v1::CreatePreferenceSetRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreatePreferenceSet(request);
}

StatusOr<google::longrunning::Operation>
MigrationCenterClient::CreatePreferenceSet(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::CreatePreferenceSetRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreatePreferenceSet(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>>
MigrationCenterClient::CreatePreferenceSet(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreatePreferenceSet(operation);
}

future<StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>>
MigrationCenterClient::UpdatePreferenceSet(
    google::cloud::migrationcenter::v1::PreferenceSet const& preference_set,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::UpdatePreferenceSetRequest request;
  *request.mutable_preference_set() = preference_set;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdatePreferenceSet(request);
}

StatusOr<google::longrunning::Operation>
MigrationCenterClient::UpdatePreferenceSet(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::PreferenceSet const& preference_set,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::UpdatePreferenceSetRequest request;
  *request.mutable_preference_set() = preference_set;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdatePreferenceSet(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>>
MigrationCenterClient::UpdatePreferenceSet(
    google::cloud::migrationcenter::v1::UpdatePreferenceSetRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdatePreferenceSet(request);
}

StatusOr<google::longrunning::Operation>
MigrationCenterClient::UpdatePreferenceSet(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::UpdatePreferenceSetRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdatePreferenceSet(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::PreferenceSet>>
MigrationCenterClient::UpdatePreferenceSet(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdatePreferenceSet(operation);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterClient::DeletePreferenceSet(std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::DeletePreferenceSetRequest request;
  request.set_name(name);
  return connection_->DeletePreferenceSet(request);
}

StatusOr<google::longrunning::Operation>
MigrationCenterClient::DeletePreferenceSet(NoAwaitTag, std::string const& name,
                                           Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::DeletePreferenceSetRequest request;
  request.set_name(name);
  return connection_->DeletePreferenceSet(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterClient::DeletePreferenceSet(
    google::cloud::migrationcenter::v1::DeletePreferenceSetRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeletePreferenceSet(request);
}

StatusOr<google::longrunning::Operation>
MigrationCenterClient::DeletePreferenceSet(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::DeletePreferenceSetRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeletePreferenceSet(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterClient::DeletePreferenceSet(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeletePreferenceSet(operation);
}

StatusOr<google::cloud::migrationcenter::v1::Settings>
MigrationCenterClient::GetSettings(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::GetSettingsRequest request;
  request.set_name(name);
  return connection_->GetSettings(request);
}

StatusOr<google::cloud::migrationcenter::v1::Settings>
MigrationCenterClient::GetSettings(
    google::cloud::migrationcenter::v1::GetSettingsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetSettings(request);
}

future<StatusOr<google::cloud::migrationcenter::v1::Settings>>
MigrationCenterClient::UpdateSettings(
    google::cloud::migrationcenter::v1::Settings const& settings,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::UpdateSettingsRequest request;
  *request.mutable_settings() = settings;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateSettings(request);
}

StatusOr<google::longrunning::Operation> MigrationCenterClient::UpdateSettings(
    NoAwaitTag, google::cloud::migrationcenter::v1::Settings const& settings,
    google::protobuf::FieldMask const& update_mask, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::UpdateSettingsRequest request;
  *request.mutable_settings() = settings;
  *request.mutable_update_mask() = update_mask;
  return connection_->UpdateSettings(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::Settings>>
MigrationCenterClient::UpdateSettings(
    google::cloud::migrationcenter::v1::UpdateSettingsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateSettings(request);
}

StatusOr<google::longrunning::Operation> MigrationCenterClient::UpdateSettings(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::UpdateSettingsRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateSettings(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::Settings>>
MigrationCenterClient::UpdateSettings(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->UpdateSettings(operation);
}

future<StatusOr<google::cloud::migrationcenter::v1::ReportConfig>>
MigrationCenterClient::CreateReportConfig(
    std::string const& parent,
    google::cloud::migrationcenter::v1::ReportConfig const& report_config,
    std::string const& report_config_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::CreateReportConfigRequest request;
  request.set_parent(parent);
  *request.mutable_report_config() = report_config;
  request.set_report_config_id(report_config_id);
  return connection_->CreateReportConfig(request);
}

StatusOr<google::longrunning::Operation>
MigrationCenterClient::CreateReportConfig(
    NoAwaitTag, std::string const& parent,
    google::cloud::migrationcenter::v1::ReportConfig const& report_config,
    std::string const& report_config_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::CreateReportConfigRequest request;
  request.set_parent(parent);
  *request.mutable_report_config() = report_config;
  request.set_report_config_id(report_config_id);
  return connection_->CreateReportConfig(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::ReportConfig>>
MigrationCenterClient::CreateReportConfig(
    google::cloud::migrationcenter::v1::CreateReportConfigRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateReportConfig(request);
}

StatusOr<google::longrunning::Operation>
MigrationCenterClient::CreateReportConfig(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::CreateReportConfigRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateReportConfig(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::ReportConfig>>
MigrationCenterClient::CreateReportConfig(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateReportConfig(operation);
}

StatusOr<google::cloud::migrationcenter::v1::ReportConfig>
MigrationCenterClient::GetReportConfig(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::GetReportConfigRequest request;
  request.set_name(name);
  return connection_->GetReportConfig(request);
}

StatusOr<google::cloud::migrationcenter::v1::ReportConfig>
MigrationCenterClient::GetReportConfig(
    google::cloud::migrationcenter::v1::GetReportConfigRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetReportConfig(request);
}

StreamRange<google::cloud::migrationcenter::v1::ReportConfig>
MigrationCenterClient::ListReportConfigs(std::string const& parent,
                                         Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::ListReportConfigsRequest request;
  request.set_parent(parent);
  return connection_->ListReportConfigs(request);
}

StreamRange<google::cloud::migrationcenter::v1::ReportConfig>
MigrationCenterClient::ListReportConfigs(
    google::cloud::migrationcenter::v1::ListReportConfigsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListReportConfigs(std::move(request));
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterClient::DeleteReportConfig(std::string const& name,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::DeleteReportConfigRequest request;
  request.set_name(name);
  return connection_->DeleteReportConfig(request);
}

StatusOr<google::longrunning::Operation>
MigrationCenterClient::DeleteReportConfig(NoAwaitTag, std::string const& name,
                                          Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::DeleteReportConfigRequest request;
  request.set_name(name);
  return connection_->DeleteReportConfig(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterClient::DeleteReportConfig(
    google::cloud::migrationcenter::v1::DeleteReportConfigRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteReportConfig(request);
}

StatusOr<google::longrunning::Operation>
MigrationCenterClient::DeleteReportConfig(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::DeleteReportConfigRequest const&
        request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteReportConfig(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterClient::DeleteReportConfig(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteReportConfig(operation);
}

future<StatusOr<google::cloud::migrationcenter::v1::Report>>
MigrationCenterClient::CreateReport(
    std::string const& parent,
    google::cloud::migrationcenter::v1::Report const& report,
    std::string const& report_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::CreateReportRequest request;
  request.set_parent(parent);
  *request.mutable_report() = report;
  request.set_report_id(report_id);
  return connection_->CreateReport(request);
}

StatusOr<google::longrunning::Operation> MigrationCenterClient::CreateReport(
    NoAwaitTag, std::string const& parent,
    google::cloud::migrationcenter::v1::Report const& report,
    std::string const& report_id, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::CreateReportRequest request;
  request.set_parent(parent);
  *request.mutable_report() = report;
  request.set_report_id(report_id);
  return connection_->CreateReport(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::Report>>
MigrationCenterClient::CreateReport(
    google::cloud::migrationcenter::v1::CreateReportRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateReport(request);
}

StatusOr<google::longrunning::Operation> MigrationCenterClient::CreateReport(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::CreateReportRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateReport(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::Report>>
MigrationCenterClient::CreateReport(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->CreateReport(operation);
}

StatusOr<google::cloud::migrationcenter::v1::Report>
MigrationCenterClient::GetReport(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::GetReportRequest request;
  request.set_name(name);
  return connection_->GetReport(request);
}

StatusOr<google::cloud::migrationcenter::v1::Report>
MigrationCenterClient::GetReport(
    google::cloud::migrationcenter::v1::GetReportRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->GetReport(request);
}

StreamRange<google::cloud::migrationcenter::v1::Report>
MigrationCenterClient::ListReports(std::string const& parent, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::ListReportsRequest request;
  request.set_parent(parent);
  return connection_->ListReports(request);
}

StreamRange<google::cloud::migrationcenter::v1::Report>
MigrationCenterClient::ListReports(
    google::cloud::migrationcenter::v1::ListReportsRequest request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->ListReports(std::move(request));
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterClient::DeleteReport(std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::DeleteReportRequest request;
  request.set_name(name);
  return connection_->DeleteReport(request);
}

StatusOr<google::longrunning::Operation> MigrationCenterClient::DeleteReport(
    NoAwaitTag, std::string const& name, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  google::cloud::migrationcenter::v1::DeleteReportRequest request;
  request.set_name(name);
  return connection_->DeleteReport(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterClient::DeleteReport(
    google::cloud::migrationcenter::v1::DeleteReportRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteReport(request);
}

StatusOr<google::longrunning::Operation> MigrationCenterClient::DeleteReport(
    NoAwaitTag,
    google::cloud::migrationcenter::v1::DeleteReportRequest const& request,
    Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteReport(NoAwaitTag{}, request);
}

future<StatusOr<google::cloud::migrationcenter::v1::OperationMetadata>>
MigrationCenterClient::DeleteReport(
    google::longrunning::Operation const& operation, Options opts) {
  internal::OptionsSpan span(internal::MergeOptions(std::move(opts), options_));
  return connection_->DeleteReport(operation);
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace migrationcenter_v1
}  // namespace cloud
}  // namespace google
