// Copyright 2024 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/managedkafka/v1/managed_kafka.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MANAGEDKAFKA_V1_MANAGED_KAFKA_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MANAGEDKAFKA_V1_MANAGED_KAFKA_CONNECTION_H

#include "google/cloud/managedkafka/v1/internal/managed_kafka_retry_traits.h"
#include "google/cloud/managedkafka/v1/managed_kafka_connection_idempotency_policy.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/no_await_tag.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/cloud/managedkafka/v1/managed_kafka.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace managedkafka_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `ManagedKafkaConnection`.
class ManagedKafkaRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<ManagedKafkaRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `ManagedKafkaConnection` based on counting errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class ManagedKafkaLimitedErrorCountRetryPolicy
    : public ManagedKafkaRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit ManagedKafkaLimitedErrorCountRetryPolicy(int maximum_failures)
      : impl_(maximum_failures) {}

  ManagedKafkaLimitedErrorCountRetryPolicy(
      ManagedKafkaLimitedErrorCountRetryPolicy&& rhs) noexcept
      : ManagedKafkaLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}
  ManagedKafkaLimitedErrorCountRetryPolicy(
      ManagedKafkaLimitedErrorCountRetryPolicy const& rhs) noexcept
      : ManagedKafkaLimitedErrorCountRetryPolicy(rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<ManagedKafkaRetryPolicy> clone() const override {
    return std::make_unique<ManagedKafkaLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = ManagedKafkaRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      managedkafka_v1_internal::ManagedKafkaRetryTraits>
      impl_;
};

/**
 * A retry policy for `ManagedKafkaConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class ManagedKafkaLimitedTimeRetryPolicy : public ManagedKafkaRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit ManagedKafkaLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  ManagedKafkaLimitedTimeRetryPolicy(
      ManagedKafkaLimitedTimeRetryPolicy&& rhs) noexcept
      : ManagedKafkaLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  ManagedKafkaLimitedTimeRetryPolicy(
      ManagedKafkaLimitedTimeRetryPolicy const& rhs) noexcept
      : ManagedKafkaLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<ManagedKafkaRetryPolicy> clone() const override {
    return std::make_unique<ManagedKafkaLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = ManagedKafkaRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      managedkafka_v1_internal::ManagedKafkaRetryTraits>
      impl_;
};

/**
 * The `ManagedKafkaConnection` object for `ManagedKafkaClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `ManagedKafkaClient`. This allows users to inject custom behavior
 * (e.g., with a Google Mock object) when writing tests that use objects of type
 * `ManagedKafkaClient`.
 *
 * To create a concrete instance, see `MakeManagedKafkaConnection()`.
 *
 * For mocking, see `managedkafka_v1_mocks::MockManagedKafkaConnection`.
 */
class ManagedKafkaConnection {
 public:
  virtual ~ManagedKafkaConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual StreamRange<google::cloud::managedkafka::v1::Cluster> ListClusters(
      google::cloud::managedkafka::v1::ListClustersRequest request);

  virtual StatusOr<google::cloud::managedkafka::v1::Cluster> GetCluster(
      google::cloud::managedkafka::v1::GetClusterRequest const& request);

  virtual future<StatusOr<google::cloud::managedkafka::v1::Cluster>>
  CreateCluster(
      google::cloud::managedkafka::v1::CreateClusterRequest const& request);

  virtual StatusOr<google::longrunning::Operation> CreateCluster(
      NoAwaitTag,
      google::cloud::managedkafka::v1::CreateClusterRequest const& request);

  virtual future<StatusOr<google::cloud::managedkafka::v1::Cluster>>
  CreateCluster(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::managedkafka::v1::Cluster>>
  UpdateCluster(
      google::cloud::managedkafka::v1::UpdateClusterRequest const& request);

  virtual StatusOr<google::longrunning::Operation> UpdateCluster(
      NoAwaitTag,
      google::cloud::managedkafka::v1::UpdateClusterRequest const& request);

  virtual future<StatusOr<google::cloud::managedkafka::v1::Cluster>>
  UpdateCluster(google::longrunning::Operation const& operation);

  virtual future<StatusOr<google::cloud::managedkafka::v1::OperationMetadata>>
  DeleteCluster(
      google::cloud::managedkafka::v1::DeleteClusterRequest const& request);

  virtual StatusOr<google::longrunning::Operation> DeleteCluster(
      NoAwaitTag,
      google::cloud::managedkafka::v1::DeleteClusterRequest const& request);

  virtual future<StatusOr<google::cloud::managedkafka::v1::OperationMetadata>>
  DeleteCluster(google::longrunning::Operation const& operation);

  virtual StreamRange<google::cloud::managedkafka::v1::Topic> ListTopics(
      google::cloud::managedkafka::v1::ListTopicsRequest request);

  virtual StatusOr<google::cloud::managedkafka::v1::Topic> GetTopic(
      google::cloud::managedkafka::v1::GetTopicRequest const& request);

  virtual StatusOr<google::cloud::managedkafka::v1::Topic> CreateTopic(
      google::cloud::managedkafka::v1::CreateTopicRequest const& request);

  virtual StatusOr<google::cloud::managedkafka::v1::Topic> UpdateTopic(
      google::cloud::managedkafka::v1::UpdateTopicRequest const& request);

  virtual Status DeleteTopic(
      google::cloud::managedkafka::v1::DeleteTopicRequest const& request);

  virtual StreamRange<google::cloud::managedkafka::v1::ConsumerGroup>
  ListConsumerGroups(
      google::cloud::managedkafka::v1::ListConsumerGroupsRequest request);

  virtual StatusOr<google::cloud::managedkafka::v1::ConsumerGroup>
  GetConsumerGroup(
      google::cloud::managedkafka::v1::GetConsumerGroupRequest const& request);

  virtual StatusOr<google::cloud::managedkafka::v1::ConsumerGroup>
  UpdateConsumerGroup(
      google::cloud::managedkafka::v1::UpdateConsumerGroupRequest const&
          request);

  virtual Status DeleteConsumerGroup(
      google::cloud::managedkafka::v1::DeleteConsumerGroupRequest const&
          request);
};

/**
 * A factory function to construct an object of type `ManagedKafkaConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of ManagedKafkaClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `ManagedKafkaConnection`. Expected options are any of the types in
 * the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::managedkafka_v1::ManagedKafkaPolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `ManagedKafkaConnection` created by
 * this function.
 */
std::shared_ptr<ManagedKafkaConnection> MakeManagedKafkaConnection(
    Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace managedkafka_v1
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_MANAGEDKAFKA_V1_MANAGED_KAFKA_CONNECTION_H
