// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/ids/v1/ids.proto

#include "google/cloud/ids/v1/internal/ids_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include "google/cloud/internal/traced_stream_range.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace ids_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

IDSTracingConnection::IDSTracingConnection(
    std::shared_ptr<ids_v1::IDSConnection> child)
    : child_(std::move(child)) {}

StreamRange<google::cloud::ids::v1::Endpoint>
IDSTracingConnection::ListEndpoints(
    google::cloud::ids::v1::ListEndpointsRequest request) {
  auto span = internal::MakeSpan("ids_v1::IDSConnection::ListEndpoints");
  internal::OTelScope scope(span);
  auto sr = child_->ListEndpoints(std::move(request));
  return internal::MakeTracedStreamRange<google::cloud::ids::v1::Endpoint>(
      std::move(span), std::move(sr));
}

StatusOr<google::cloud::ids::v1::Endpoint> IDSTracingConnection::GetEndpoint(
    google::cloud::ids::v1::GetEndpointRequest const& request) {
  auto span = internal::MakeSpan("ids_v1::IDSConnection::GetEndpoint");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->GetEndpoint(request));
}

future<StatusOr<google::cloud::ids::v1::Endpoint>>
IDSTracingConnection::CreateEndpoint(
    google::cloud::ids::v1::CreateEndpointRequest const& request) {
  auto span = internal::MakeSpan("ids_v1::IDSConnection::CreateEndpoint");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateEndpoint(request));
}

StatusOr<google::longrunning::Operation> IDSTracingConnection::CreateEndpoint(
    NoAwaitTag, google::cloud::ids::v1::CreateEndpointRequest const& request) {
  auto span = internal::MakeSpan("ids_v1::IDSConnection::CreateEndpoint");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->CreateEndpoint(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::ids::v1::Endpoint>>
IDSTracingConnection::CreateEndpoint(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("ids_v1::IDSConnection::CreateEndpoint");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->CreateEndpoint(operation));
}

future<StatusOr<google::cloud::ids::v1::OperationMetadata>>
IDSTracingConnection::DeleteEndpoint(
    google::cloud::ids::v1::DeleteEndpointRequest const& request) {
  auto span = internal::MakeSpan("ids_v1::IDSConnection::DeleteEndpoint");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteEndpoint(request));
}

StatusOr<google::longrunning::Operation> IDSTracingConnection::DeleteEndpoint(
    NoAwaitTag, google::cloud::ids::v1::DeleteEndpointRequest const& request) {
  auto span = internal::MakeSpan("ids_v1::IDSConnection::DeleteEndpoint");
  opentelemetry::trace::Scope scope(span);
  return internal::EndSpan(*span,
                           child_->DeleteEndpoint(NoAwaitTag{}, request));
}

future<StatusOr<google::cloud::ids::v1::OperationMetadata>>
IDSTracingConnection::DeleteEndpoint(
    google::longrunning::Operation const& operation) {
  auto span = internal::MakeSpan("ids_v1::IDSConnection::DeleteEndpoint");
  internal::OTelScope scope(span);
  return internal::EndSpan(std::move(span), child_->DeleteEndpoint(operation));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<ids_v1::IDSConnection> MakeIDSTracingConnection(
    std::shared_ptr<ids_v1::IDSConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<IDSTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace ids_v1_internal
}  // namespace cloud
}  // namespace google
