// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/functions/v1/functions.proto

#include "google/cloud/functions/v1/cloud_functions_connection.h"
#include "google/cloud/functions/v1/cloud_functions_options.h"
#include "google/cloud/functions/v1/internal/cloud_functions_connection_impl.h"
#include "google/cloud/functions/v1/internal/cloud_functions_option_defaults.h"
#include "google/cloud/functions/v1/internal/cloud_functions_stub_factory.h"
#include "google/cloud/functions/v1/internal/cloud_functions_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace functions_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

CloudFunctionsServiceConnection::~CloudFunctionsServiceConnection() = default;

StreamRange<google::cloud::functions::v1::CloudFunction>
CloudFunctionsServiceConnection::ListFunctions(
    google::cloud::functions::v1::
        ListFunctionsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::functions::v1::CloudFunction>>();
}

StatusOr<google::cloud::functions::v1::CloudFunction>
CloudFunctionsServiceConnection::GetFunction(
    google::cloud::functions::v1::GetFunctionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

future<StatusOr<google::cloud::functions::v1::CloudFunction>>
CloudFunctionsServiceConnection::CreateFunction(
    google::cloud::functions::v1::CreateFunctionRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::functions::v1::CloudFunction>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CloudFunctionsServiceConnection::CreateFunction(
    NoAwaitTag, google::cloud::functions::v1::CreateFunctionRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::functions::v1::CloudFunction>>
CloudFunctionsServiceConnection::CreateFunction(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::functions::v1::CloudFunction>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::functions::v1::CloudFunction>>
CloudFunctionsServiceConnection::UpdateFunction(
    google::cloud::functions::v1::UpdateFunctionRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::functions::v1::CloudFunction>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CloudFunctionsServiceConnection::UpdateFunction(
    NoAwaitTag, google::cloud::functions::v1::UpdateFunctionRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::functions::v1::CloudFunction>>
CloudFunctionsServiceConnection::UpdateFunction(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::functions::v1::CloudFunction>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::functions::v1::OperationMetadataV1>>
CloudFunctionsServiceConnection::DeleteFunction(
    google::cloud::functions::v1::DeleteFunctionRequest const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::functions::v1::OperationMetadataV1>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::longrunning::Operation>
CloudFunctionsServiceConnection::DeleteFunction(
    NoAwaitTag, google::cloud::functions::v1::DeleteFunctionRequest const&) {
  return StatusOr<google::longrunning::Operation>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

future<StatusOr<google::cloud::functions::v1::OperationMetadataV1>>
CloudFunctionsServiceConnection::DeleteFunction(
    google::longrunning::Operation const&) {
  return google::cloud::make_ready_future<
      StatusOr<google::cloud::functions::v1::OperationMetadataV1>>(
      Status(StatusCode::kUnimplemented, "not implemented"));
}

StatusOr<google::cloud::functions::v1::CallFunctionResponse>
CloudFunctionsServiceConnection::CallFunction(
    google::cloud::functions::v1::CallFunctionRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::functions::v1::GenerateUploadUrlResponse>
CloudFunctionsServiceConnection::GenerateUploadUrl(
    google::cloud::functions::v1::GenerateUploadUrlRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::functions::v1::GenerateDownloadUrlResponse>
CloudFunctionsServiceConnection::GenerateDownloadUrl(
    google::cloud::functions::v1::GenerateDownloadUrlRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> CloudFunctionsServiceConnection::SetIamPolicy(
    google::iam::v1::SetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::Policy> CloudFunctionsServiceConnection::GetIamPolicy(
    google::iam::v1::GetIamPolicyRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::iam::v1::TestIamPermissionsResponse>
CloudFunctionsServiceConnection::TestIamPermissions(
    google::iam::v1::TestIamPermissionsRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<CloudFunctionsServiceConnection>
MakeCloudFunctionsServiceConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 CloudFunctionsServicePolicyOptionList>(
      options, __func__);
  options = functions_v1_internal::CloudFunctionsServiceDefaultOptions(
      std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub = functions_v1_internal::CreateDefaultCloudFunctionsServiceStub(
      std::move(auth), options);
  return functions_v1_internal::MakeCloudFunctionsServiceTracingConnection(
      std::make_shared<
          functions_v1_internal::CloudFunctionsServiceConnectionImpl>(
          std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace functions_v1
}  // namespace cloud
}  // namespace google
