// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/essentialcontacts/v1/service.proto

#include "google/cloud/essentialcontacts/v1/essential_contacts_connection.h"
#include "google/cloud/essentialcontacts/v1/essential_contacts_options.h"
#include "google/cloud/essentialcontacts/v1/internal/essential_contacts_connection_impl.h"
#include "google/cloud/essentialcontacts/v1/internal/essential_contacts_option_defaults.h"
#include "google/cloud/essentialcontacts/v1/internal/essential_contacts_stub_factory.h"
#include "google/cloud/essentialcontacts/v1/internal/essential_contacts_tracing_connection.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/credentials.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/unified_grpc_credentials.h"
#include <memory>
#include <utility>

namespace google {
namespace cloud {
namespace essentialcontacts_v1 {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

EssentialContactsServiceConnection::~EssentialContactsServiceConnection() =
    default;

StatusOr<google::cloud::essentialcontacts::v1::Contact>
EssentialContactsServiceConnection::CreateContact(
    google::cloud::essentialcontacts::v1::CreateContactRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StatusOr<google::cloud::essentialcontacts::v1::Contact>
EssentialContactsServiceConnection::UpdateContact(
    google::cloud::essentialcontacts::v1::UpdateContactRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::essentialcontacts::v1::Contact>
EssentialContactsServiceConnection::ListContacts(
    google::cloud::essentialcontacts::v1::
        ListContactsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::essentialcontacts::v1::Contact>>();
}

StatusOr<google::cloud::essentialcontacts::v1::Contact>
EssentialContactsServiceConnection::GetContact(
    google::cloud::essentialcontacts::v1::GetContactRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

Status EssentialContactsServiceConnection::DeleteContact(
    google::cloud::essentialcontacts::v1::DeleteContactRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

StreamRange<google::cloud::essentialcontacts::v1::Contact>
EssentialContactsServiceConnection::ComputeContacts(
    google::cloud::essentialcontacts::v1::
        ComputeContactsRequest) {  // NOLINT(performance-unnecessary-value-param)
  return google::cloud::internal::MakeUnimplementedPaginationRange<
      StreamRange<google::cloud::essentialcontacts::v1::Contact>>();
}

Status EssentialContactsServiceConnection::SendTestMessage(
    google::cloud::essentialcontacts::v1::SendTestMessageRequest const&) {
  return Status(StatusCode::kUnimplemented, "not implemented");
}

std::shared_ptr<EssentialContactsServiceConnection>
MakeEssentialContactsServiceConnection(Options options) {
  internal::CheckExpectedOptions<CommonOptionList, GrpcOptionList,
                                 UnifiedCredentialsOptionList,
                                 EssentialContactsServicePolicyOptionList>(
      options, __func__);
  options =
      essentialcontacts_v1_internal::EssentialContactsServiceDefaultOptions(
          std::move(options));
  auto background = internal::MakeBackgroundThreadsFactory(options)();
  auto auth = internal::CreateAuthenticationStrategy(background->cq(), options);
  auto stub =
      essentialcontacts_v1_internal::CreateDefaultEssentialContactsServiceStub(
          std::move(auth), options);
  return essentialcontacts_v1_internal::
      MakeEssentialContactsServiceTracingConnection(
          std::make_shared<essentialcontacts_v1_internal::
                               EssentialContactsServiceConnectionImpl>(
              std::move(background), std::move(stub), std::move(options)));
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace essentialcontacts_v1
}  // namespace cloud
}  // namespace google
